/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.requestfactory.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.requestfactory.shared.RequestTransport;
import com.google.gwt.requestfactory.shared.ServerFailure;
import com.google.gwt.user.client.Window;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
public class DefaultRequestTransport
implements RequestTransport {
    private static final String SERVER_ERROR = "Server Error";
    public static final String URL = "gwtRequest";
    private static final Logger wireLogger = Logger.getLogger("WireActivityLogger");
    private String requestUrl = GWT.getHostPageBaseURL() + "gwtRequest";

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void send(String payload, RequestTransport.TransportReceiver receiver) {
        RequestBuilder builder = this.createRequestBuilder();
        this.configureRequestBuilder(builder);
        builder.setRequestData(payload);
        builder.setCallback(this.createRequestCallback(receiver));
        try {
            wireLogger.finest("Sending fire request");
            builder.send();
        }
        catch (RequestException e) {
            wireLogger.log(Level.SEVERE, "Server Error (" + e.getMessage() + ")", e);
        }
    }

    public void setRequestUrl(String url) {
        this.requestUrl = url;
    }

    protected void configureRequestBuilder(RequestBuilder builder) {
        builder.setHeader("Content-Type", "application/json; charset=utf-8");
        builder.setHeader("pageurl", Window.Location.getHref());
        builder.setHeader("X-GWT-Permutation", GWT.getPermutationStrongName());
    }

    protected RequestBuilder createRequestBuilder() {
        return new RequestBuilder(RequestBuilder.POST, this.getRequestUrl());
    }

    protected RequestCallback createRequestCallback(final RequestTransport.TransportReceiver receiver) {
        return new RequestCallback(){

            public void onError(Request request, Throwable exception) {
                wireLogger.log(Level.SEVERE, DefaultRequestTransport.SERVER_ERROR, exception);
                receiver.onTransportFailure(new ServerFailure(exception.getMessage()));
            }

            public void onResponseReceived(Request request, Response response) {
                wireLogger.finest("Response received");
                if (200 == response.getStatusCode()) {
                    String text = response.getText();
                    receiver.onTransportSuccess(text);
                } else {
                    String message = "Server Error " + response.getStatusCode() + " " + response.getText();
                    wireLogger.severe(message);
                    receiver.onTransportFailure(new ServerFailure(message));
                }
            }
        };
    }
}

