package org.inria.bmajwatcher.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

import org.apache.log4j.Logger;
import org.inria.bmajwatcher.client.services.SiteManagerService;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

public class SiteManagerServiceImpl extends RemoteServiceServlet implements SiteManagerService {

	private static final long serialVersionUID = 6845683612063156414L;
	private String repositoriesFile;
	
	
	private static Logger log = Logger.getLogger(SiteManagerServiceImpl.class);
	
	@Override
	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		repositoriesFile = getServletContext().getRealPath("/") + "/remoteRepositories.properties";
	}
	
	@Override
	public boolean addSite(String url, String description) {
		Properties props = loadProperties();
		if (props == null)
			return false;
		
		if (!url.startsWith("http://"))
			url = "http://" + url;
		
		if (props.containsKey(url)) {
			return false;
		}
		
		props.put(url, description);
		
		return saveProperties(props);
		
	}

	@Override
	public boolean deleteSite(String url) {
		Properties props = loadProperties();
		if (props == null)
			return false;
		
		props.remove(url);
		
		return saveProperties(props);
	}

	@Override
	public Map<String, String> getSites() {
		Properties props = loadProperties();
		Map<String, String> res = new HashMap<String, String>();
		for (Object key : props.keySet()) {
			res.put(key.toString(), props.get(key).toString());
		}
		
		return res;
	}

	@Override
	public boolean updateSite(String refUrl, String newUrl, String newDescription) {
		Properties props = loadProperties();
		if (props == null)
			return false;

		if (!newUrl.trim().isEmpty()) {
			props.remove(refUrl);
			if (!newUrl.startsWith("http://"))
				newUrl = "http://" + newUrl;
			props.setProperty(newUrl, newDescription);
		}
		
		return saveProperties(props);
		
	}
	
	private Properties loadProperties() {
		try {
			new File(repositoriesFile).createNewFile();
		} catch (IOException e1) {
			log.error(e1);
		}
		Properties props = new Properties();
		try {
			FileReader fr = new FileReader(repositoriesFile); 
			props.load(fr);
			fr.close();
		} catch (FileNotFoundException e) {
			log.error(e);
			return null;
		} catch (IOException e) {
			log.error(e);
			return null;
		}
		
		return props;
	}
	
	private boolean saveProperties(Properties p) {
		try {
			new File(repositoriesFile).createNewFile();
		} catch (IOException e1) {
			log.error(e1);
		}
		
		try {
			PrintWriter pw = new PrintWriter(repositoriesFile);
			p.store(pw, "Generated by BW");
			pw.close();
		} catch (FileNotFoundException e) {
			log.error(e);
			return false;
		} catch (IOException e) {
			log.error(e);
			return false;
		}
		
		return true;
	}

}
