/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TestUtil {
    public static File getTempDirectory(String prefix, String suffix) {
        File tempDirectory;
        try {
            tempDirectory = File.createTempFile(prefix, suffix);
        }
        catch (IOException e) {
            throw new SAMException("Failed to create temporary file.", e);
        }
        if (!tempDirectory.delete()) {
            throw new SAMException("Failed to delete file: " + tempDirectory);
        }
        if (!tempDirectory.mkdir()) {
            throw new SAMException("Failed to make directory: " + tempDirectory);
        }
        tempDirectory.deleteOnExit();
        return tempDirectory;
    }

    public static File getTempDirecory(String prefix, String suffix) {
        return TestUtil.getTempDirectory(prefix, suffix);
    }

    public static void recursiveDelete(File directory) {
        for (File f : directory.listFiles()) {
            if (f.isDirectory()) {
                TestUtil.recursiveDelete(f);
            }
            f.delete();
        }
    }

    public static <T extends Serializable> T serializeAndDeserialize(T input) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteArrayStream);
        out.writeObject(input);
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteArrayStream.toByteArray()));
        Serializable result = (Serializable)in.readObject();
        out.close();
        in.close();
        return (T)result;
    }
}

