/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public class CodeAttribute
extends Attribute {
    private static final byte[] EMPTY_CODE = new byte[0];
    private static final ExceptionInfo[] EMPTY_EXCEPTION_TABLE = new ExceptionInfo[0];
    private static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];
    public int u2maxStack;
    public int u2maxLocals;
    public int u4codeLength;
    public byte[] code;
    public int u2exceptionTableLength;
    public ExceptionInfo[] exceptionTable;
    public int u2attributesCount;
    public Attribute[] attributes;

    public CodeAttribute() {
    }

    public CodeAttribute(int n) {
        this(n, 0, 0, 0, EMPTY_CODE);
    }

    public CodeAttribute(int n, int n2, int n3, int n4, byte[] byArray) {
        this(n, n2, n3, n4, byArray, 0, EMPTY_EXCEPTION_TABLE, 0, EMPTY_ATTRIBUTES);
    }

    public CodeAttribute(int n, int n2, int n3, int n4, byte[] byArray, int n5, ExceptionInfo[] exceptionInfoArray, int n6, Attribute[] attributeArray) {
        super(n);
        this.u2maxStack = n2;
        this.u2maxLocals = n3;
        this.u4codeLength = n4;
        this.code = byArray;
        this.u2exceptionTableLength = n5;
        this.exceptionTable = exceptionInfoArray;
        this.u2attributesCount = n6;
        this.attributes = attributeArray;
    }

    public Attribute getAttribute(Clazz clazz, String string) {
        for (int i = 0; i < this.u2attributesCount; ++i) {
            Attribute attribute = this.attributes[i];
            if (!attribute.getAttributeName(clazz).equals(string)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public void accept(Clazz clazz, Method method, AttributeVisitor attributeVisitor) {
        attributeVisitor.visitCodeAttribute(clazz, method, this);
    }

    public void instructionsAccept(Clazz clazz, Method method, InstructionVisitor instructionVisitor) {
        this.instructionsAccept(clazz, method, 0, this.u4codeLength, instructionVisitor);
    }

    public void instructionAccept(Clazz clazz, Method method, int n, InstructionVisitor instructionVisitor) {
        Instruction instruction = InstructionFactory.create(this.code, n);
        instruction.accept(clazz, method, this, n, instructionVisitor);
    }

    public void instructionsAccept(Clazz clazz, Method method, int n, int n2, InstructionVisitor instructionVisitor) {
        int n3;
        for (int i = n; i < n2; i += n3) {
            Instruction instruction = InstructionFactory.create(this.code, i);
            n3 = instruction.length(i);
            instruction.accept(clazz, method, this, i, instructionVisitor);
        }
    }

    public void exceptionsAccept(Clazz clazz, Method method, ExceptionInfoVisitor exceptionInfoVisitor) {
        for (int i = 0; i < this.u2exceptionTableLength; ++i) {
            exceptionInfoVisitor.visitExceptionInfo(clazz, method, this, this.exceptionTable[i]);
        }
    }

    public void exceptionsAccept(Clazz clazz, Method method, int n, ExceptionInfoVisitor exceptionInfoVisitor) {
        for (int i = 0; i < this.u2exceptionTableLength; ++i) {
            ExceptionInfo exceptionInfo = this.exceptionTable[i];
            if (!exceptionInfo.isApplicable(n)) continue;
            exceptionInfoVisitor.visitExceptionInfo(clazz, method, this, exceptionInfo);
        }
    }

    public void exceptionsAccept(Clazz clazz, Method method, int n, int n2, ExceptionInfoVisitor exceptionInfoVisitor) {
        for (int i = 0; i < this.u2exceptionTableLength; ++i) {
            ExceptionInfo exceptionInfo = this.exceptionTable[i];
            if (!exceptionInfo.isApplicable(n, n2)) continue;
            exceptionInfoVisitor.visitExceptionInfo(clazz, method, this, exceptionInfo);
        }
    }

    public void attributesAccept(Clazz clazz, Method method, AttributeVisitor attributeVisitor) {
        for (int i = 0; i < this.u2attributesCount; ++i) {
            this.attributes[i].accept(clazz, method, this, attributeVisitor);
        }
    }
}

