#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Friday 07 August 2009 14:21:47 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Examples/matplotlib/ImageFigure_net.py,v 1.7 2009/09/04 17:38:01 vareille Exp $
#
# $Id: ImageFigure_net.py,v 1.7 2009/09/04 17:38:01 vareille Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from Vision.matplotlibNodes import matplotliblib
from Vision.StandardNodes import stdlib
from DejaVu.VisionInterface.DejaVuNodes import vizlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(matplotliblib,"Vision.matplotlibNodes", "matplotliblib")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

masterNet.getEditor().addLibraryInstance(vizlib,"DejaVu.VisionInterface.DejaVuNodes", "vizlib")

try:
    ## saving node Histogram ##
    from Vision.matplotlibNodes import HistogramNE
    Histogram_0 = HistogramNE(constrkw={}, name='Histogram', library=matplotliblib)
    masterNet.addNode(Histogram_0,108,243)
    Histogram_0.inputPortByName['bins'].widget.set(50, run=False)
    Histogram_0.inputPortByName['normed'].widget.set(1, run=False)
    Histogram_0.inputPortByName['patch_antialiased'].widget.set(1, run=False)
    Histogram_0.inputPortByName['patch_linewidth'].widget.set(1, run=False)
    Histogram_0.inputPortByName['patch_edgecolor'].widget.set(r"black", run=False)
    Histogram_0.inputPortByName['patch_facecolor'].widget.set(r"green", run=False)
    apply(Histogram_0.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore HistogramNE named Histogram in network masterNet"
    print_exc()
    Histogram_0=None

try:
    ## saving node Draw Area ##
    from Vision.matplotlibNodes import MPLDrawAreaNE
    Draw_Area_1 = MPLDrawAreaNE(constrkw={}, name='Draw Area', library=matplotliblib)
    masterNet.addNode(Draw_Area_1,125,180)
    Draw_Area_1.inputPortByName['left'].widget.set(0.147222222222, run=False)
    Draw_Area_1.inputPortByName['bottom'].widget.set(0.1, run=False)
    Draw_Area_1.inputPortByName['width'].widget.set(0.8, run=False)
    Draw_Area_1.inputPortByName['height'].widget.set(0.8, run=False)
    Draw_Area_1.inputPortByName['frameon'].widget.set(1, run=False)
    Draw_Area_1.inputPortByName['hold'].widget.set(1, run=False)
    Draw_Area_1.inputPortByName['title'].widget.set(r"Histogram of IQ ", run=False)
    Draw_Area_1.inputPortByName['xlabel'].widget.set(r"Smarts", run=False)
    Draw_Area_1.inputPortByName['ylabel'].widget.set(r"Probability", run=False)
    Draw_Area_1.inputPortByName['xlimit'].widget.set(r"", run=False)
    Draw_Area_1.inputPortByName['ylimit'].widget.set(r"", run=False)
    Draw_Area_1.inputPortByName['xticklabels'].widget.set(1, run=False)
    Draw_Area_1.inputPortByName['yticklabels'].widget.set(1, run=False)
    Draw_Area_1.inputPortByName['axison'].widget.set(1, run=False)
    Draw_Area_1.inputPortByName['autoscaleon'].widget.set(1, run=False)
    apply(Draw_Area_1.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore MPLDrawAreaNE named Draw Area in network masterNet"
    print_exc()
    Draw_Area_1=None

try:
    ## saving node Viewer ##
    from DejaVu.VisionInterface.DejaVuNodes import Viewer
    Viewer_2 = Viewer(constrkw={}, name='Viewer', library=vizlib)
    masterNet.addNode(Viewer_2,309,381)
    ##
        ## Saving State for Viewer
    Viewer_2.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0, 0, 0, 1), 'd2off': 1, 'height': 417, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 1341, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 32.399999999999999, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 470, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -21.220682], 'd2cutH': 255, 'far': 50.0, 'd1off': 4, 'lookFrom': [0.0, 0.0, 21.220682], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'rooty': 601, 'd1scale': 0.012999999999999999}
    apply(Viewer_2.vi.cameras[0].Set, (), state)

    state = {'end': 26.856655027923544, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': False, 'start': 15.584708746728857, 'mode': 'GL_LINEAR'}
    apply(Viewer_2.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [5.0, 5.0000009536743164, 3.2785532511070414e-08], 'rotation': [0.63510573, 0.5481227, -0.54424459, 0.0, -0.20086479, 0.79754817, 0.56883228, 0.0, 0.74585122, -0.25194907, 0.61662602, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-5.0, -5.0000005, 7.761256e-07], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 2, 'inheritXform': 0}
    apply(Viewer_2.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if Viewer_2.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if Viewer_2.vi.rootObject:
        Viewer_2.vi.rootObject.clipP = []
        Viewer_2.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore Viewer named Viewer in network masterNet"
    print_exc()
    Viewer_2=None

try:
    ## saving node ImageFigure ##
    from Vision.matplotlibNodes import MPLImageNE
    ImageFigure_3 = MPLImageNE(constrkw={}, name='ImageFigure', library=matplotliblib)
    masterNet.addNode(ImageFigure_3,168,370)
    ImageFigure_3.inputPortByName['width'].widget.set(6.4, run=False)
    ImageFigure_3.inputPortByName['height'].widget.set(4.8, run=False)
    ImageFigure_3.inputPortByName['dpi'].widget.set(80, run=False)
    ImageFigure_3.inputPortByName['alphaFace'].widget.set(0.5, run=False)
    ImageFigure_3.inputPortByName['alphaEdge'].widget.set(0.5, run=False)
    ImageFigure_3.inputPortByName['frameon'].widget.set(1, run=False)
    ImageFigure_3.inputPortByName['hold'].widget.set(0, run=False)
except:
    print "WARNING: failed to restore MPLImageNE named ImageFigure in network masterNet"
    print_exc()
    ImageFigure_3=None

try:
    ## saving node oneTexturedQuad ##
    from DejaVu.VisionInterface.GeometryNodes import OneTexturedQuadNE
    oneTexturedQuad_4 = OneTexturedQuadNE(constrkw={}, name='oneTexturedQuad', library=vizlib)
    masterNet.addNode(oneTexturedQuad_4,345,243)
    oneTexturedQuad_4.inputPortByName['name'].widget.set(r"", run=False)
    oneTexturedQuad_4.inputPortByName['geoms'].widget.set(r"", run=False)
except:
    print "WARNING: failed to restore OneTexturedQuadNE named oneTexturedQuad in network masterNet"
    print_exc()
    oneTexturedQuad_4=None

try:
    ## saving node ReadTable ##
    from Vision.StandardNodes import ReadTable
    ReadTable_5 = ReadTable(constrkw={}, name='ReadTable', library=stdlib)
    masterNet.addNode(ReadTable_5,32,11)
    ReadTable_5.inputPortByName['filename'].widget.set(r"Data/histogram_data.dat", run=False)
    apply(ReadTable_5.inputPortByName['numOfTopLinesToJump'].widget.configure, (), {'oneTurn': 10.0})
    ReadTable_5.inputPortByName['numOfTopLinesToJump'].widget.set(0, run=False)
    apply(ReadTable_5.inputPortByName['numOfBottomLinesToJump'].widget.configure, (), {'oneTurn': 10.0})
    ReadTable_5.inputPortByName['numOfBottomLinesToJump'].widget.set(0, run=False)
    ReadTable_5.inputPortByName['sep'].widget.set(r",", run=False)
    ReadTable_5.inputPortByName['datatype'].widget.set(r"float", run=False)
except:
    print "WARNING: failed to restore ReadTable named ReadTable in network masterNet"
    print_exc()
    ReadTable_5=None

try:
    ## saving node Index ##
    from Vision.StandardNodes import Index
    Index_6 = Index(constrkw={}, name='Index', library=stdlib)
    masterNet.addNode(Index_6,32,189)
    Index_6.inputPortByName['index'].widget.set(0, run=False)
    apply(Index_6.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Index named Index in network masterNet"
    print_exc()
    Index_6=None

#masterNet.run()
masterNet.freeze()

## saving connections for network ImageFigure ##
if Draw_Area_1 is not None and Histogram_0 is not None:
    try:
        masterNet.connectNodes(
            Draw_Area_1, Histogram_0, "drawAreaDef", "drawAreaDef", blocking=True
            , splitratio=[0.71050182771612547, 0.48216779631799078])
    except:
        print "WARNING: failed to restore connection between Draw_Area_1 and Histogram_0 in network masterNet"
if Histogram_0 is not None and ImageFigure_3 is not None:
    try:
        masterNet.connectNodes(
            Histogram_0, ImageFigure_3, "plot", "plots", blocking=True
            , splitratio=[0.59755305137816794, 0.58329747250836284])
    except:
        print "WARNING: failed to restore connection between Histogram_0 and ImageFigure_3 in network masterNet"
if ImageFigure_3 is not None and oneTexturedQuad_4 is not None:
    try:
        masterNet.connectNodes(
            ImageFigure_3, oneTexturedQuad_4, "image", "image", blocking=True
            , splitratio=[0.47798728751964126, 0.24202926139887365])
    except:
        print "WARNING: failed to restore connection between ImageFigure_3 and oneTexturedQuad_4 in network masterNet"
if oneTexturedQuad_4 is not None and Viewer_2 is not None:
    try:
        masterNet.connectNodes(
            oneTexturedQuad_4, Viewer_2, "oneTexturedQuad", "geometries", blocking=True
            , splitratio=[0.21950913437670352, 0.42827072505870828])
    except:
        print "WARNING: failed to restore connection between oneTexturedQuad_4 and Viewer_2 in network masterNet"
if ReadTable_5 is not None and Index_6 is not None:
    try:
        masterNet.connectNodes(
            ReadTable_5, Index_6, "data", "data", blocking=True
            , splitratio=[0.69808863015860145, 0.40545243784105833])
    except:
        print "WARNING: failed to restore connection between ReadTable_5 and Index_6 in network masterNet"
if Index_6 is not None and Histogram_0 is not None:
    try:
        masterNet.connectNodes(
            Index_6, Histogram_0, "data", "values", blocking=True
            , splitratio=[0.27099623707717196, 0.73465807202136291])
    except:
        print "WARNING: failed to restore connection between Index_6 and Histogram_0 in network masterNet"
masterNet.runOnNewData.value = True


def loadSavedStates_Viewer_2(self=Viewer_2, event=None):
    ##
    ## Saving State for objects in Viewer
    ##

    ## End Object root

    ##
        ## Saving State for Viewer
    self.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0, 0, 0, 1), 'd2off': 1, 'height': 417, 'lookAt': [0.0, 0.0, 0.0], 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 32.399999999999999, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 470, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -21.220682], 'd2cutH': 255, 'far': 50.0, 'd1off': 4, 'lookFrom': [0.0, 0.0, 21.220682], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'd1scale': 0.012999999999999999}
    apply(self.vi.cameras[0].Set, (), state)

    state = {'end': 26.856655027923544, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': False, 'start': 15.584708746728857, 'mode': 'GL_LINEAR'}
    apply(self.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [5.0, 5.0000009536743164, 3.2785532511070414e-08], 'rotation': [0.63510573, 0.5481227, -0.54424459, 0.0, -0.20086479, 0.79754817, 0.56883228, 0.0, 0.74585122, -0.25194907, 0.61662602, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-5.0, -5.0000005, 7.761256e-07], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 2, 'inheritXform': 0}
    apply(self.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if self.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if self.vi.rootObject:
        self.vi.rootObject.clipP = []
        self.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

Viewer_2.restoreStates_cb = Viewer_2.restoreStatesFirstRun = loadSavedStates_Viewer_2
Viewer_2.menu.add_separator()
Viewer_2.menu.add_command(label='Restore states', command=Viewer_2.restoreStates_cb)

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 1) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        # create communication socket
        import socket
        HOST = ''                 # Symbolic name meaning the local host
        PORT = 50010              # Arbitrary non-privileged port
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.bind((HOST, PORT))
        s.listen(5)
        s.setblocking(0)
        masterNet.socket = s
        masterNet.socketConnections = []
        masterNet.HOST = HOST
        masterNet.PORT = PORT

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

