/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui.actions;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class BuildConfigurationsJob
extends Job {
    private ICConfigurationDescription[] cfgDescriptions;
    private int cleanKind;
    private int buildKind;

    private static String composeJobName(ICConfigurationDescription[] cfgDescriptions, boolean isCleaning) {
        String firstProjectName = cfgDescriptions[0].getProjectDescription().getName();
        String firstConfigurationName = cfgDescriptions[0].getName();
        if (isCleaning) {
            return MessageFormat.format((String)Messages.BuildConfigurationsJob_Cleaning, (Object[])new Object[]{"" + cfgDescriptions.length, firstProjectName, firstConfigurationName});
        }
        return MessageFormat.format((String)Messages.BuildConfigurationsJob_Building, (Object[])new Object[]{"" + cfgDescriptions.length, firstProjectName, firstConfigurationName});
    }

    public BuildConfigurationsJob(ICConfigurationDescription[] cfgDescriptions, int cleanKind, int buildKind) {
        super(BuildConfigurationsJob.composeJobName(cfgDescriptions, buildKind == 0));
        this.cfgDescriptions = cfgDescriptions;
        this.cleanKind = cleanKind;
        this.buildKind = buildKind;
    }

    protected IStatus run(IProgressMonitor monitor) {
        CUIPlugin.getDefault().startGlobalConsole();
        IConfiguration[] cfgs = new IConfiguration[this.cfgDescriptions.length];
        int i = 0;
        while (i < this.cfgDescriptions.length) {
            cfgs[i] = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)this.cfgDescriptions[i]);
            ++i;
        }
        try {
            if (this.cleanKind == 15) {
                ManagedBuildManager.buildConfigurations((IConfiguration[])cfgs, null, (IProgressMonitor)monitor, (boolean)true, (int)this.cleanKind);
            }
            if (this.buildKind != 0) {
                ManagedBuildManager.buildConfigurations((IConfiguration[])cfgs, null, (IProgressMonitor)monitor, (boolean)true, (int)this.buildKind);
            }
        }
        catch (CoreException e) {
            return new Status(4, Messages.BuildConfigurationsJob_BuildError, e.getLocalizedMessage());
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
    }
}

