/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.core;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.internal.core.RemoteServicesDescriptor;
import org.eclipse.remote.internal.core.RemoteServicesImpl;

public class RemoteServices {
    public static IRemoteServices getLocalServices() {
        return RemoteServices.getRemoteServices("org.eclipse.remote.LocalServices");
    }

    public static IRemoteServices getRemoteServices(String id) {
        return RemoteServices.getRemoteServices(id, null);
    }

    public static IRemoteServices getRemoteServices(String id, IProgressMonitor monitor) {
        IRemoteServices service;
        RemoteServicesDescriptor proxy = RemoteServicesImpl.getRemoteServiceDescriptorById(id);
        if (proxy != null && (service = proxy.getServices()).initialize(monitor)) {
            return service;
        }
        return null;
    }

    public static IRemoteServices getRemoteServices(URI uri) {
        return RemoteServices.getRemoteServices(uri, null);
    }

    public static IRemoteServices getRemoteServices(URI uri, IProgressMonitor monitor) {
        IRemoteServices service;
        RemoteServicesDescriptor proxy = RemoteServicesImpl.getRemoteServiceDescriptorByURI(uri);
        if (proxy != null && (service = proxy.getServices()).initialize(monitor)) {
            return service;
        }
        return null;
    }
}

