/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.GroupExecutor;
import org.eclipse.birt.report.engine.executor.IPageBreakListener;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.model.api.TableHandle;

public abstract class ListingElementExecutor
extends QueryItemExecutor
implements IPageBreakListener {
    protected int rsetCursor;
    protected boolean needPageBreak;
    protected int pageRowCount = 0;
    protected int pageBreakInterval = -1;
    protected int pageBreakLevel = -1;
    protected boolean breakOnDetailBand = false;
    protected boolean softBreakBefore = false;
    protected boolean addAfterBreak = false;
    private static int MAX_PAGE_BREAK_INTERVAL = 10000;
    ReportItemDesign[] executableElements;
    int totalElements;
    int currentElement;
    boolean endOfListing;

    protected ListingElementExecutor(ExecutorManager manager, int type) {
        super(manager, type);
    }

    protected int getMaxPageBreakInterval() {
        int maxPageBreakInterval;
        Object maxPageBreakObject;
        Map appContext = this.context.getAppContext();
        if (appContext != null && (maxPageBreakObject = appContext.get("MAX_PAGE_BREAK_INTERVAL")) instanceof Number && (maxPageBreakInterval = ((Number)maxPageBreakObject).intValue()) > 0) {
            return maxPageBreakInterval;
        }
        return MAX_PAGE_BREAK_INTERVAL;
    }

    @Override
    protected void initializeContent(ReportElementDesign design, IContent content) {
        super.initializeContent(design, content);
        this.pageBreakInterval = ((ListingDesign)design).getPageBreakInterval();
        int maxPageBreakInterval = this.getMaxPageBreakInterval();
        if (this.pageBreakInterval <= 0) {
            this.pageBreakInterval = maxPageBreakInterval;
        }
        if (this.pageBreakInterval > maxPageBreakInterval) {
            this.getLogger().log(Level.WARNING, "Page Break Interval for listing element {0}  is {1}. Reset it to {2} to prevent OOM", new Object[]{this.getInstanceID().toString(), this.pageBreakInterval, maxPageBreakInterval});
            this.pageBreakInterval = maxPageBreakInterval;
        }
        this.pageBreakLevel = this.getPageBreakIntervalGroup();
        this.breakOnDetailBand = this.pageBreakIntervalOnDetail();
        if (this.pageBreakInterval > 0) {
            this.context.addPageBreakListener(this);
        }
    }

    protected int getPageBreakIntervalGroup() {
        ListingDesign listing = (ListingDesign)this.design;
        int groupCount = listing.getGroupCount();
        if (groupCount > 0) {
            TableHandle handle;
            int i = 0;
            while (i < groupCount) {
                if (listing.getGroup(i).getHideDetail()) {
                    return i;
                }
                ++i;
            }
            if (this.design instanceof TableItemDesign && (handle = (TableHandle)this.design.getHandle()).isSummaryTable()) {
                return groupCount - 1;
            }
            return groupCount;
        }
        return -1;
    }

    @Override
    public void close() throws BirtException {
        if (this.pageBreakInterval != -1) {
            this.context.removePageBreakListener(this);
        }
        this.rsetCursor = -1;
        this.needPageBreak = false;
        this.pageRowCount = 0;
        this.pageBreakInterval = -1;
        this.executableElements = null;
        this.totalElements = 0;
        this.currentElement = 0;
        this.endOfListing = false;
        this.breakOnDetailBand = false;
        this.pageBreakLevel = -1;
        this.softBreakBefore = false;
        this.addAfterBreak = false;
        super.close();
    }

    void next() {
        if (this.pageBreakInterval > 0) {
            ++this.pageRowCount;
        }
    }

    void previous() {
        if (this.pageBreakInterval > 0) {
            --this.pageRowCount;
        }
    }

    boolean needSoftBreakAfter() {
        return this.pageBreakInterval > 0 && this.pageBreakInterval <= this.pageRowCount;
    }

    boolean pageBreakIntervalOnDetail() {
        ListingDesign listing;
        int groupCount;
        return this.pageBreakInterval > 0 && ((groupCount = (listing = (ListingDesign)this.design).getGroupCount()) == this.pageBreakLevel || groupCount == 0);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean hasNextChild() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public IReportItemExecutor getNextChild() {
        if (this.hasNextChild()) {
            ReportItemDesign nextDesign;
            ReportItemExecutor nextExecutor;
            assert (this.currentElement < this.totalElements);
            if ((nextExecutor = this.manager.createExecutor(this, nextDesign = this.executableElements[this.currentElement++])) instanceof GroupExecutor) {
                GroupExecutor groupExecutor = (GroupExecutor)nextExecutor;
                groupExecutor.setLisingExecutor(this);
            }
            return nextExecutor;
        }
        return null;
    }

    protected void prepareToExecuteChildren() {
        ListingDesign listingDesign = (ListingDesign)this.getDesign();
        this.executableElements = new ReportItemDesign[3];
        if (this.rset == null || this.rsetEmpty) {
            BandDesign footer;
            BandDesign header = listingDesign.getHeader();
            if (header != null) {
                this.executableElements[this.totalElements++] = header;
            }
            if ((footer = listingDesign.getFooter()) != null) {
                this.executableElements[this.totalElements++] = footer;
            }
            this.endOfListing = true;
        } else {
            this.collectExecutableElements();
        }
    }

    void collectExecutableElements() {
        try {
            BandDesign header;
            this.currentElement = 0;
            this.totalElements = 0;
            this.endOfListing = false;
            ListingDesign listingDesign = (ListingDesign)this.getDesign();
            int groupCount = listingDesign.getGroupCount();
            int startGroup = this.rset.getStartingGroupLevel();
            if (startGroup == 0 && (header = listingDesign.getHeader()) != null) {
                this.executableElements[this.totalElements++] = header;
            }
            if (groupCount > 0) {
                this.executableElements[this.totalElements++] = listingDesign.getGroup(0);
            } else {
                BandDesign detail = listingDesign.getDetail();
                if (detail != null) {
                    this.executableElements[this.totalElements++] = detail;
                }
            }
            int endGroup = this.rset.getEndingGroupLevel();
            if (endGroup <= 0) {
                BandDesign footer = listingDesign.getFooter();
                if (footer != null) {
                    this.executableElements[this.totalElements++] = footer;
                }
                this.endOfListing = true;
            }
        }
        catch (BirtException ex) {
            this.context.addException(this.getDesign(), ex);
        }
    }

    @Override
    public void onPageBreak(boolean isHorizontalPageBreak) {
        if (!isHorizontalPageBreak) {
            this.pageRowCount = 0;
            if (this.addAfterBreak) {
                this.next();
                this.addAfterBreak = false;
            } else if (this.softBreakBefore) {
                this.softBreakBefore = false;
            }
        }
    }
}

