/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.gnu;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.AbstractGCCBOPConsoleParserUtility;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ScannerInfoConsoleParserUtility
extends AbstractGCCBOPConsoleParserUtility {
    private Map<String, IFile> fFilesInProject = new HashMap<String, IFile>();
    private List<IResource> fCollectedFiles = new ArrayList<IResource>();
    private List<String> fNameConflicts = new ArrayList<String>();

    public ScannerInfoConsoleParserUtility(IProject project, IPath workingDirectory, IMarkerGenerator markerGenerator) {
        super(project, workingDirectory, markerGenerator);
        this.collectFiles((IContainer)this.getProject(), this.fCollectedFiles);
        int i = 0;
        while (i < this.fCollectedFiles.size()) {
            IFile curr = (IFile)this.fCollectedFiles.get(i);
            IFile existing = this.fFilesInProject.put(curr.getName(), curr);
            if (existing != null) {
                this.fNameConflicts.add(curr.getName());
            }
            ++i;
        }
    }

    public IFile findFile(String fileName) {
        IFile file = this.findFilePath(fileName);
        if (file == null && (file = this.findFileName(fileName)) != null && this.isConflictingName(fileName)) {
            file = null;
            String error = MakeMessages.getString("ConsoleParser.Ambiguous_Filepath_Error_Message");
            TraceUtil.outputError(error, fileName);
            this.generateMarker((IResource)this.getProject(), -1, String.valueOf(error) + fileName, 1, null);
        }
        if (file != null) {
            String foundLocation;
            Path filePath = new Path(fileName);
            if (filePath.segment(0).compareTo("..") == 0) {
                filePath = filePath.removeFirstSegments(1);
            }
            if (!(foundLocation = file.getLocationURI().toString()).endsWith(filePath.toString())) {
                file = null;
            }
        }
        return file;
    }

    protected IFile findFilePath(String filePath) {
        IPath path = null;
        Path fp = new Path(filePath);
        if (fp.isAbsolute()) {
            if (this.getBaseDirectory().isPrefixOf((IPath)fp)) {
                int segments = this.getBaseDirectory().matchingFirstSegments((IPath)fp);
                path = fp.removeFirstSegments(segments);
            } else {
                path = fp;
            }
        } else {
            path = this.getWorkingDirectory().append(filePath);
        }
        IFile file = null;
        try {
            file = this.findFileInWorkspace(path);
        }
        catch (Exception exception) {}
        if (file == null || !file.exists()) {
            File f = path.toFile();
            try {
                String canon = f.getCanonicalPath();
                path = new Path(canon);
                file = this.findFileInWorkspace(path);
            }
            catch (IOException iOException) {}
        }
        return file != null && file.exists() ? file : null;
    }

    protected IFile findFileName(String fileName) {
        Path path = new Path(fileName);
        return this.fFilesInProject.get(path.lastSegment());
    }

    protected IFile findFileInWorkspace(IPath path) {
        IFile file = null;
        if (path.isAbsolute()) {
            IWorkspaceRoot root = this.getProject().getWorkspace().getRoot();
            file = root.getFileForLocation(path);
            if (file == null) {
                file = ResourceLookup.selectFileForLocation((IPath)path, (IProject)this.getProject());
            }
        } else {
            file = this.getProject().getFile(path);
        }
        return file;
    }

    protected void collectFiles(IContainer parent, List<IResource> result) {
        try {
            IResource[] resources = parent.members();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (resource instanceof IFile) {
                    result.add(resource);
                } else if (resource instanceof IContainer) {
                    this.collectFiles((IContainer)resource, result);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e.getStatus());
        }
    }

    protected boolean isConflictingName(String fileName) {
        Path path = new Path(fileName);
        return this.fNameConflicts.contains(path.lastSegment());
    }

    public List<String> translateRelativePaths(IFile file, String fileName, List<String> includes) {
        ArrayList<String> translatedIncludes = new ArrayList<String>(includes.size());
        for (String include : includes) {
            Path includePath = new Path(include);
            if (!includePath.isUNC()) {
                String error;
                if (includePath.isAbsolute()) {
                    if (includePath.getDevice() == null) {
                        String device = this.getWorkingDirectory().getDevice();
                        IPath candidatePath = includePath.setDevice(device);
                        File dir = candidatePath.toFile();
                        if (dir.exists()) {
                            include = candidatePath.toString();
                        } else {
                            error = MakeMessages.getString("ConsoleParser.Nonexistent_Include_Path_Error_Message");
                            TraceUtil.outputError(error, include);
                        }
                    }
                } else {
                    Path filePath;
                    IPath cwd = this.getWorkingDirectory();
                    if (!cwd.isAbsolute()) {
                        cwd = this.getBaseDirectory().append(cwd);
                    }
                    if ((filePath = new Path(fileName)).isAbsolute()) {
                        if (filePath.getDevice() == null) {
                            String device = this.getWorkingDirectory().getDevice();
                            filePath = filePath.setDevice(device);
                        }
                    } else {
                        filePath = cwd.append(fileName);
                    }
                    Path fileLocation = new Path(EFSExtensionManager.getDefault().getPathFromURI(file.getLocationURI()));
                    if (!filePath.toString().equalsIgnoreCase(fileLocation.toString())) {
                        IPath lastFileSegment;
                        if (fileName.startsWith("..")) {
                            error = MakeMessages.getString("ConsoleParser.Working_Directory_Error_Message");
                            TraceUtil.outputError(error, fileName);
                            this.generateMarker((IResource)file, -1, error, 1, fileName);
                            break;
                        }
                        Path tPath = new Path(fileName);
                        if (fileName.startsWith(".")) {
                            tPath = tPath.removeFirstSegments(1);
                        }
                        if ((lastFileSegment = (filePath = fileLocation).removeFirstSegments(filePath.segmentCount() - tPath.segmentCount())).matchingFirstSegments((IPath)tPath) == tPath.segmentCount()) {
                            cwd = filePath.removeLastSegments(tPath.segmentCount());
                        }
                    }
                    IPath candidatePath = cwd.append((IPath)includePath);
                    File dir = candidatePath.toFile();
                    include = candidatePath.toString();
                    if (!dir.exists()) {
                        String error2 = MakeMessages.getString("ConsoleParser.Nonexistent_Include_Path_Error_Message");
                        TraceUtil.outputError(error2, include);
                    }
                }
            }
            translatedIncludes.add(include);
        }
        return translatedIncludes;
    }

    public String normalizePath(String path) {
        int sdot;
        char driveLetter;
        int column = path.indexOf(58);
        if (column > 0 && Character.isLowerCase(driveLetter = path.charAt(column - 1))) {
            StringBuffer sb = new StringBuffer();
            if (column - 1 > 0) {
                sb.append(path.substring(0, column - 1));
            }
            sb.append(Character.toUpperCase(driveLetter));
            sb.append(path.substring(column));
            path = sb.toString();
        }
        if (path.indexOf(46) == -1 || path.equals(".")) {
            return new Path(path).toString();
        }
        StringBuffer buf = new StringBuffer(path);
        int len = buf.length();
        StringBuffer newBuf = new StringBuffer(buf.length());
        int scp = 0;
        int ssp = 0;
        while (ssp < len && (sdot = buf.indexOf(".", ssp)) != -1) {
            boolean validPrefix = false;
            int ddot = buf.indexOf("..", ssp);
            if (sdot < ddot || ddot == -1) {
                newBuf.append(buf.substring(scp, sdot));
                scp = sdot;
                ssp = sdot + 1;
                if (ssp >= len) continue;
                if (sdot == 0 || buf.charAt(sdot - 1) == '/' || buf.charAt(sdot - 1) == '\\') {
                    validPrefix = true;
                }
                char nextChar = buf.charAt(ssp);
                if (validPrefix && nextChar == '/') {
                    scp = ++ssp;
                    continue;
                }
                if (validPrefix && nextChar == '\\') {
                    if (++ssp < len - 1 && buf.charAt(ssp) == '\\') {
                        ++ssp;
                    }
                    scp = ssp;
                    continue;
                }
                scp = ssp - 1;
                continue;
            }
            if (sdot != ddot) continue;
            ssp = sdot + 2;
        }
        newBuf.append(buf.substring(scp, len));
        Path orgPath = new Path(newBuf.toString());
        return orgPath.toString();
    }
}

