/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig2;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.core.BuildRunnerHelper;
import org.eclipse.cdt.make.core.MakeBuilder;
import org.eclipse.cdt.make.core.MakeBuilderUtil;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IExternalScannerInfoProvider;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerInfoConsoleParserFactory;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCMarkerGenerator;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class DefaultRunSIProvider
implements IExternalScannerInfoProvider {
    private static final String GMAKE_ERROR_PARSER_ID = "org.eclipse.cdt.core.GmakeErrorParser";
    private static final String PREF_CONSOLE_ENABLED = "org.eclipse.cdt.make.core.scanner.discovery.console.enabled";
    private static final int PROGRESS_MONITOR_SCALE = 100;
    private static final int TICKS_STREAM_PROGRESS_MONITOR = 100;
    private static final int TICKS_EXECUTE_PROGRAM = 100;
    protected IResource resource;
    protected String providerId;
    protected IScannerConfigBuilderInfo2 buildInfo;
    protected IScannerInfoCollector collector;
    protected IPath fWorkingDirectory;
    protected IPath fCompileCommand;
    protected String[] fCompileArguments;
    private SCMarkerGenerator markerGenerator = new SCMarkerGenerator();

    @Override
    public boolean invokeProvider(IProgressMonitor monitor, IResource resource, String providerId, IScannerConfigBuilderInfo2 buildInfo, IScannerInfoCollector collector) {
        return this.invokeProvider(monitor, resource, new InfoContext(resource.getProject()), providerId, buildInfo, collector, null);
    }

    @Override
    public boolean invokeProvider(IProgressMonitor monitor, IResource resource, InfoContext context, String providerId, IScannerConfigBuilderInfo2 buildInfo, IScannerInfoCollector collector, Properties env) {
        this.resource = resource;
        this.providerId = providerId;
        this.buildInfo = buildInfo;
        this.collector = collector;
        IProject project = resource.getProject();
        BuildRunnerHelper buildRunnerHelper = new BuildRunnerHelper(project);
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(MakeMessages.getString("ExternalScannerInfoProvider.Reading_Specs"), 200);
            if (!this.initialize()) {
                return false;
            }
            try {
                IConsole console;
                ILanguage language = context.getLanguage();
                if (language != null && DefaultRunSIProvider.isConsoleEnabled()) {
                    String consoleId = "org.eclipse.cdt.make.core." + providerId + '.' + language.getId();
                    String consoleName = MakeMessages.getFormattedString("ExternalScannerInfoProvider.Console_Name", language.getName());
                    console = CCorePlugin.getDefault().getBuildConsole(consoleId, consoleName, null);
                } else {
                    console = CCorePlugin.getDefault().getConsole("org.eclipse.cdt.make.core.console.hidden");
                }
                console.start(project);
                CommandLauncher launcher = new CommandLauncher();
                launcher.setProject(project);
                IPath program = this.getCommandToLaunch();
                if (!program.isEmpty()) {
                    String[] comandLineOptions = this.getCommandLineOptions();
                    URI workingDirectoryURI = MakeBuilderUtil.getBuildDirectoryURI(project, MakeBuilder.BUILDER_ID);
                    String[] envp = this.setEnvironment((ICommandLauncher)launcher, env);
                    ErrorParserManager epm = new ErrorParserManager(project, (IMarkerGenerator)this.markerGenerator, new String[]{GMAKE_ERROR_PARSER_ID});
                    ArrayList<IScannerInfoConsoleParser> parsers = new ArrayList<IScannerInfoConsoleParser>();
                    IScannerInfoConsoleParser parser = ScannerInfoConsoleParserFactory.getESIConsoleParser(project, context, providerId, buildInfo, collector, this.markerGenerator);
                    if (parser != null) {
                        parsers.add(parser);
                    }
                    buildRunnerHelper.setLaunchParameters((ICommandLauncher)launcher, program, comandLineOptions, workingDirectoryURI, envp);
                    buildRunnerHelper.prepareStreams(epm, parsers, console, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 4));
                    buildRunnerHelper.greeting(MakeMessages.getFormattedString("ExternalScannerInfoProvider.Greeting", project.getName()));
                    buildRunnerHelper.build((IProgressMonitor)new SubProgressMonitor(monitor, 100, 4));
                    buildRunnerHelper.close();
                    buildRunnerHelper.goodbye();
                }
            }
            catch (Exception e) {
                MakeCorePlugin.log(e);
            }
        }
        finally {
            try {
                buildRunnerHelper.close();
            }
            catch (IOException e) {
                MakeCorePlugin.log(e);
            }
            monitor.done();
        }
        return true;
    }

    protected IPath getCommandToLaunch() {
        return this.fCompileCommand;
    }

    protected String[] getCommandLineOptions() {
        return this.prepareArguments(this.buildInfo.isUseDefaultProviderCommand(this.providerId));
    }

    protected boolean initialize() {
        IProject currProject = this.resource.getProject();
        URI workingDirURI = MakeBuilderUtil.getBuildDirectoryURI(currProject, MakeBuilder.BUILDER_ID);
        String pathString = EFSExtensionManager.getDefault().getPathFromURI(workingDirURI);
        if (pathString == null) {
            throw new IllegalStateException();
        }
        this.fWorkingDirectory = new Path(pathString);
        this.fCompileCommand = new Path(this.buildInfo.getProviderRunCommand(this.providerId));
        this.fCompileArguments = ScannerConfigUtil.tokenizeStringWithQuotes(this.buildInfo.getProviderRunArguments(this.providerId), "\"");
        return this.fCompileCommand != null;
    }

    protected String[] prepareArguments(boolean isDefaultCommand) {
        return this.fCompileArguments;
    }

    private Properties getEnvMap(ICommandLauncher launcher, Properties initialEnv) {
        Properties props;
        Properties properties = props = initialEnv != null ? initialEnv : launcher.getEnvironment();
        if (this.fWorkingDirectory != null) {
            props.put("CWD", this.fWorkingDirectory.toOSString());
            props.put("PWD", this.fWorkingDirectory.toOSString());
        }
        props.put("LANGUAGE", "en");
        props.put("LC_ALL", "en_US.UTF-8");
        return props;
    }

    protected String[] setEnvironment(ICommandLauncher launcher, Properties initialEnv) {
        Properties props = this.getEnvMap(launcher, initialEnv);
        String[] env = null;
        ArrayList<String> envList = new ArrayList<String>();
        Enumeration<?> names = props.propertyNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                envList.add(String.valueOf(key) + "=" + props.getProperty(key));
            }
            env = envList.toArray(new String[envList.size()]);
        }
        return env;
    }

    public static void setConsoleEnabled(boolean value) {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.make.core");
        node.putBoolean(PREF_CONSOLE_ENABLED, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            MakeCorePlugin.log(e);
        }
    }

    public static boolean isConsoleEnabled() {
        boolean value = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.make.core").getBoolean(PREF_CONSOLE_ENABLED, false);
        return value;
    }
}

