/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.commands;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.remote.internal.Activator;
import com.nvidia.cuda.ide.remote.internal.wizard.DebugWizard;
import com.nvidia.cuda.ide.remote.internal.wizard.IDebugSessionType;
import com.nvidia.cuda.ide.remote.ui.launch.LaunchMode;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public final class DebugCommand
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        DebugWizard debugWizard = new DebugWizard(LaunchMode.DEBUG, false);
        String parameter = event.getParameter("com.nvidia.cuda.ide.debugSessionType");
        if (!CoreUtil.isNullOrEmpty((String)parameter)) {
            try {
                IDebugSessionType sessionType = (IDebugSessionType)Class.forName(parameter.trim()).newInstance();
                debugWizard.setSessionType(sessionType);
            }
            catch (InstantiationException e) {
                Activator.log(e);
            }
            catch (IllegalAccessException e) {
                Activator.log(e);
            }
            catch (ClassNotFoundException e) {
                Activator.log(e);
            }
        }
        if ((selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event)) instanceof IStructuredSelection) {
            debugWizard.setSelection(selection);
        } else {
            IEditorInput input = HandlerUtil.getActiveEditorInput((ExecutionEvent)event);
            if (input != null) {
                debugWizard.setSelection((ISelection)new StructuredSelection((Object)input));
            }
        }
        WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)debugWizard);
        dialog.open();
        return null;
    }
}

