/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.properties;

import com.nvidia.cuda.ide.remote.internal.ui.build.BuildConfigurationsMenuBuilder;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;

public final class IsBuildableTester
extends PropertyTester {
    private static IProject getEditorProject(Object receiver) {
        IResource resource = (IResource)((IEditorPart)receiver).getEditorInput().getAdapter(IResource.class);
        if (resource != null) {
            return resource.getProject();
        }
        return null;
    }

    private static final IProject getProject(Object object) {
        if (object instanceof IResource) {
            return ((IResource)object).getProject();
        }
        if (object instanceof IAdaptable) {
            IResource resource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
            if (resource != null) {
                return resource.getProject();
            }
            return null;
        }
        return null;
    }

    private static IProject getProjectFromSelection(Object receiver) {
        IProject project = null;
        Object[] objectArray = ((IStructuredSelection)receiver).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            IProject prj = IsBuildableTester.getProject(object);
            if (project == null && prj != null) {
                project = prj;
            } else if (prj == null || !project.equals((Object)prj)) {
                return null;
            }
            ++n2;
        }
        return project;
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if ("isBuildable".equals(property)) {
            IProject project;
            if (receiver instanceof IEditorPart) {
                project = IsBuildableTester.getEditorProject(receiver);
            } else if (receiver instanceof IStructuredSelection) {
                project = IsBuildableTester.getProjectFromSelection(receiver);
            } else {
                if (receiver instanceof IViewPart) {
                    return this.test(((IViewPart)receiver).getViewSite().getWorkbenchWindow(), property, args, expectedValue);
                }
                if (receiver instanceof IWorkbenchWindow) {
                    IWorkbenchWindow window = (IWorkbenchWindow)receiver;
                    project = BuildConfigurationsMenuBuilder.getSelectedProject(window.getSelectionService().getSelection(), window.getActivePage().getActivePart(), window);
                } else {
                    project = null;
                }
            }
            return project != null && CoreModel.getDefault().getProjectDescription(project, false) != null;
        }
        return false;
    }
}

