/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import com.nvidia.viper.run.NvprofResult;
import java.util.HashMap;
import java.util.Map;

public class ViperRunMode {
    private static String TEST_USING_TYCHO = "org.eclipse.tycho.surefire.osgibooter.uitest";
    private static String TEST_USING_IDE = "org.eclipse.pde.junit.runtime.nonuithreadtestapplication";
    private static RunMode runMode;
    private static int exceptionCount;
    private static Map<Integer, Integer> dialogCounts;
    private static Map<Integer, Map<String, Integer>> dialogTitles;
    static NvprofResult lastNvprofResult;

    static {
        exceptionCount = 0;
        dialogCounts = new HashMap<Integer, Integer>();
        dialogTitles = new HashMap<Integer, Map<String, Integer>>();
        lastNvprofResult = NvprofResult.NVPROF_SUCCESS;
    }

    public static NvprofResult getLastNvprofResult() {
        return lastNvprofResult;
    }

    public static void setLastNvprofResult(NvprofResult nvprofResult) {
        lastNvprofResult = nvprofResult;
    }

    public static RunMode getRunMode() {
        if (runMode == null) {
            String property = System.getProperty("eclipse.application");
            runMode = TEST_USING_TYCHO.equals(property) || TEST_USING_IDE.equals(property) ? RunMode.TEST : RunMode.PRODUCT;
        }
        return runMode;
    }

    public static int getDialogCount(int kind) {
        if (!dialogCounts.containsKey(kind)) {
            return 0;
        }
        return dialogCounts.get(kind);
    }

    public static int getDialogTitleCount(int kind, String title) {
        Map<String, Integer> titles = dialogTitles.get(kind);
        if (titles == null) {
            return 0;
        }
        if (!titles.containsKey(title)) {
            return 0;
        }
        return titles.get(title);
    }

    public static void recordDialogOpen(int kind, String title) {
        Map<String, Integer> titles = dialogTitles.get(kind);
        if (titles == null) {
            titles = new HashMap<String, Integer>();
            dialogTitles.put(kind, titles);
        }
        int count = 0;
        if (titles.containsKey(title)) {
            count = titles.get(title);
        }
        titles.put(title, count + 1);
        dialogCounts.put(kind, ViperRunMode.getDialogCount(kind) + 1);
    }

    public static void resetDialog() {
        dialogCounts.clear();
        dialogTitles.clear();
    }

    public static int getExceptionCount() {
        return exceptionCount;
    }

    public static void recordException(String message) {
        ++exceptionCount;
    }

    public static void resetException() {
        exceptionCount = 0;
    }

    public static enum RunMode {
        TEST,
        PRODUCT;

    }
}

