/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuDeviceAttribute;
import com.nvidia.viper.activity.CuptiActivityDevice;
import com.nvidia.viper.activity.CuptiActivityDeviceAttribute;
import com.nvidia.viper.activity.CuptiActivityFlag;
import com.nvidia.viper.activity.CuptiActivityName;
import com.nvidia.viper.activity.CuptiActivityObjectKind;
import com.nvidia.viper.activity.CuptiDeviceAttribute;
import com.nvidia.viper.analysis.OccupancyCalculator;
import com.nvidia.viper.jni.CuCacheConfig;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineContext;
import com.nvidia.viper.model.TimelineIntervalEnvironment;
import com.nvidia.viper.model.TimelineKind;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TimelineDevice
extends Timeline
implements IModel {
    private CuptiActivityDevice activity;
    private final Map<CuptiDeviceAttribute, CuptiActivityDeviceAttribute> cuptiAttributes;
    private final Map<CuDeviceAttribute, CuptiActivityDeviceAttribute> cuAttributes;
    private long totalKernelExecutionTime;
    private int totalInvocations;
    private int smClockMin;
    private int smClockMax;
    private double smClockAvg;
    private int memoryClockMin;
    private int memoryClockMax;
    private double memoryClockAvg;
    private int temperatureMin;
    private int temperatureMax;
    private int temperatureAvg;
    private int powerMin;
    private int powerMax;
    private double powerAvg;
    private int fanSpeedMin;
    private int fanSpeedMax;
    private double fanSpeedAvg;
    private int numClockSamples;
    private int numTemperatureSamples;
    private int numPowerSamples;
    private int numFanSpeedSamples;
    private boolean calculateEnvMinMaxAvg;
    private Set<ITimelineInterval> utilizationIntervals = new HashSet<ITimelineInterval>();

    public TimelineDevice(CuptiActivityDevice activity) {
        super(activity == null ? null : activity.name, TimelineKind.DEVICE);
        this.activity = activity;
        this.cuptiAttributes = new HashMap<CuptiDeviceAttribute, CuptiActivityDeviceAttribute>();
        this.cuAttributes = new HashMap<CuDeviceAttribute, CuptiActivityDeviceAttribute>();
        this.totalKernelExecutionTime = -1L;
        this.totalInvocations = -1;
        this.smClockMin = -1;
        this.smClockMax = -1;
        this.smClockAvg = -1.0;
        this.memoryClockMin = -1;
        this.memoryClockMax = -1;
        this.memoryClockAvg = -1.0;
        this.temperatureMin = -1;
        this.temperatureMax = -1;
        this.temperatureAvg = -1;
        this.powerMin = -1;
        this.powerMax = -1;
        this.powerAvg = -1.0;
        this.fanSpeedMin = -1;
        this.fanSpeedMax = -1;
        this.fanSpeedAvg = -1.0;
        this.numClockSamples = 0;
        this.numTemperatureSamples = 0;
        this.numPowerSamples = 0;
        this.numFanSpeedSamples = 0;
        this.calculateEnvMinMaxAvg = true;
    }

    public void setActivity(CuptiActivityDevice activity) {
        this.activity = activity;
    }

    @Override
    public String getDisplayName(boolean verbose) {
        String deviceId = Integer.toString(this.activity.id);
        String customName = this.getCustomName();
        if (customName != null) {
            deviceId = customName;
        }
        return this.getFormattedName(deviceId);
    }

    public String getNameWithId() {
        return this.getFormattedName(Integer.toString(this.activity.id));
    }

    private String getFormattedName(String id) {
        return "[" + id + "] " + super.getName();
    }

    public int getId() {
        return this.activity.id;
    }

    public byte[] getUuid() {
        return this.activity.uuid;
    }

    public StringBuilder getUuidSHA_1Format() {
        if (this.getUuid() != null && !this.isUuidZero()) {
            StringBuilder sb = new StringBuilder();
            sb.append("GPU-");
            int i = 0;
            byte[] byArray = this.getUuid();
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                if (i == 4 || i == 6 || i == 8 || i == 10) {
                    sb.append("-");
                }
                sb.append(String.format("%02x", b));
                ++i;
                ++n2;
            }
            return sb;
        }
        return null;
    }

    public boolean isUuidZero() {
        if (this.getUuid() != null) {
            byte[] uuid = this.getUuid();
            int i = 0;
            while (i < uuid.length) {
                if (uuid[i] != 0) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public int getNumClockSamples() {
        if (this.calculateEnvMinMaxAvg) {
            this.calculateEnvMinMaxAvgTotal();
        }
        return this.numClockSamples;
    }

    public int getNumTemperatureSamples() {
        if (this.calculateEnvMinMaxAvg) {
            this.calculateEnvMinMaxAvgTotal();
        }
        return this.numTemperatureSamples;
    }

    public int getNumPowerSamples() {
        if (this.calculateEnvMinMaxAvg) {
            this.calculateEnvMinMaxAvgTotal();
        }
        return this.numPowerSamples;
    }

    public int getNumFanSpeedSamples() {
        if (this.calculateEnvMinMaxAvg) {
            this.calculateEnvMinMaxAvgTotal();
        }
        return this.numFanSpeedSamples;
    }

    public int getSmClockMin() {
        if (this.calculateEnvMinMaxAvg) {
            this.calculateEnvMinMaxAvgTotal();
        }
        return this.smClockMin;
    }

    public int getSmClockMax() {
        if (this.calculateEnvMinMaxAvg) {
            this.calculateEnvMinMaxAvgTotal();
        }
        return this.smClockMax;
    }

    public double getSmClockAvg() {
        if (this.calculateEnvMinMaxAvg) {
            this.calculateEnvMinMaxAvgTotal();
        }
        return this.smClockAvg;
    }

    public int getMemoryClockMin() {
        if (this.calculateEnvMinMaxAvg) {
            this.calculateEnvMinMaxAvgTotal();
        }
        return this.memoryClockMin;
    }

    public int getMemoryClockMax() {
        if (this.calculateEnvMinMaxAvg) {
            this.calculateEnvMinMaxAvgTotal();
        }
        return this.memoryClockMax;
    }

    public double getMemoryClockAvg() {
        if (this.calculateEnvMinMaxAvg) {
            this.calculateEnvMinMaxAvgTotal();
        }
        return this.memoryClockAvg;
    }

    public int getTemperatureMin() {
        if (this.calculateEnvMinMaxAvg) {
            this.calculateEnvMinMaxAvgTotal();
        }
        return this.temperatureMin;
    }

    public int getTemperatureMax() {
        if (this.calculateEnvMinMaxAvg) {
            this.calculateEnvMinMaxAvgTotal();
        }
        return this.temperatureMax;
    }

    public int getTemperatureAvg() {
        if (this.calculateEnvMinMaxAvg) {
            this.calculateEnvMinMaxAvgTotal();
        }
        return this.temperatureAvg;
    }

    public int getPowerMin() {
        if (this.calculateEnvMinMaxAvg) {
            this.calculateEnvMinMaxAvgTotal();
        }
        return this.powerMin;
    }

    public int getPowerMax() {
        if (this.calculateEnvMinMaxAvg) {
            this.calculateEnvMinMaxAvgTotal();
        }
        return this.powerMax;
    }

    public double getPowerAvg() {
        if (this.calculateEnvMinMaxAvg) {
            this.calculateEnvMinMaxAvgTotal();
        }
        return this.powerAvg;
    }

    public int getFanSpeedMin() {
        if (this.calculateEnvMinMaxAvg) {
            this.calculateEnvMinMaxAvgTotal();
        }
        return this.fanSpeedMin;
    }

    public int getFanSpeedMax() {
        if (this.calculateEnvMinMaxAvg) {
            this.calculateEnvMinMaxAvgTotal();
        }
        return this.fanSpeedMax;
    }

    public double getFanSpeedAvg() {
        if (this.calculateEnvMinMaxAvg) {
            this.calculateEnvMinMaxAvgTotal();
        }
        return this.fanSpeedAvg;
    }

    private void calculateEnvMinMaxAvgTotal() {
        long smClockTotal = 0L;
        long memoryClockTotal = 0L;
        long tempTotal = 0L;
        long powerTotal = 0L;
        long fanTotal = 0L;
        List<ITimelineInterval> intervals = this.getIntervals(false);
        for (ITimelineInterval iTimelineInterval : intervals) {
            if (!(iTimelineInterval instanceof TimelineIntervalEnvironment)) continue;
            TimelineIntervalEnvironment envInterval = (TimelineIntervalEnvironment)iTimelineInterval;
            switch (envInterval.getEnvironmentKind()) {
                case CUPTI_ACTIVITY_ENVIRONMENT_SPEED: {
                    if (envInterval.getSmClock() < this.smClockMin || this.numClockSamples == 0) {
                        this.smClockMin = envInterval.getSmClock();
                    }
                    if (envInterval.getSmClock() > this.smClockMax) {
                        this.smClockMax = envInterval.getSmClock();
                    }
                    if (envInterval.getMemoryClock() < this.memoryClockMin || this.numClockSamples == 0) {
                        this.memoryClockMin = envInterval.getMemoryClock();
                    }
                    if (envInterval.getMemoryClock() > this.memoryClockMax) {
                        this.memoryClockMax = envInterval.getMemoryClock();
                    }
                    smClockTotal += (long)envInterval.getSmClock();
                    memoryClockTotal += (long)envInterval.getMemoryClock();
                    ++this.numClockSamples;
                    break;
                }
                case CUPTI_ACTIVITY_ENVIRONMENT_TEMPERATURE: {
                    if (envInterval.getGpuTemperature() < this.temperatureMin || this.numTemperatureSamples == 0) {
                        this.temperatureMin = envInterval.getGpuTemperature();
                    }
                    if (envInterval.getGpuTemperature() > this.temperatureMax) {
                        this.temperatureMax = envInterval.getGpuTemperature();
                    }
                    tempTotal += (long)envInterval.getGpuTemperature();
                    ++this.numTemperatureSamples;
                    break;
                }
                case CUPTI_ACTIVITY_ENVIRONMENT_POWER: {
                    if (envInterval.getPower() < this.powerMin || this.numPowerSamples == 0) {
                        this.powerMin = envInterval.getPower();
                    }
                    if (envInterval.getPower() > this.powerMax) {
                        this.powerMax = envInterval.getPower();
                    }
                    powerTotal += (long)envInterval.getPower();
                    ++this.numPowerSamples;
                    break;
                }
                case CUPTI_ACTIVITY_ENVIRONMENT_COOLING: {
                    if (envInterval.getFanSpeed() < this.fanSpeedMin || this.numFanSpeedSamples == 0) {
                        this.fanSpeedMin = envInterval.getFanSpeed();
                    }
                    if (envInterval.getFanSpeed() > this.fanSpeedMax) {
                        this.fanSpeedMax = envInterval.getFanSpeed();
                    }
                    fanTotal += (long)envInterval.getFanSpeed();
                    ++this.numFanSpeedSamples;
                    break;
                }
            }
        }
        if (smClockTotal > 0L) {
            this.smClockAvg = (double)smClockTotal / (double)this.numClockSamples;
        }
        if (memoryClockTotal > 0L) {
            this.memoryClockAvg = (double)memoryClockTotal / (double)this.numClockSamples;
        }
        if (tempTotal > 0L) {
            this.temperatureAvg = (int)(tempTotal / (long)this.numTemperatureSamples);
        }
        if (powerTotal > 0L) {
            this.powerAvg = (double)powerTotal / (double)this.numPowerSamples;
        }
        if (fanTotal > 0L) {
            this.fanSpeedAvg = (double)fanTotal / (double)this.numFanSpeedSamples;
        }
        this.calculateEnvMinMaxAvg = false;
    }

    public int getYOffsetForEnvSymbol(ITimelineInterval interval) {
        TimelineIntervalEnvironment envInterval = (TimelineIntervalEnvironment)interval;
        double yOffset = 0.0;
        switch (envInterval.getEnvironmentKind()) {
            case CUPTI_ACTIVITY_ENVIRONMENT_SPEED: {
                if (this.getSmClockMax() != this.getSmClockMin()) {
                    double iSize = (double)(this.getSmClockMax() - this.getSmClockMin()) / (double)this.getIntervalRowHeight();
                    yOffset = (double)(envInterval.getSmClock() - this.getSmClockMin()) / iSize;
                } else if (this.getSmClockAvg() > 0.0) {
                    yOffset = this.getIntervalRowHeight() / 2;
                }
                return (int)yOffset;
            }
            case CUPTI_ACTIVITY_ENVIRONMENT_TEMPERATURE: {
                if (this.getTemperatureMax() != this.getTemperatureMin()) {
                    double tSize = (double)(this.getTemperatureMax() - this.getTemperatureMin()) / (double)this.getIntervalRowHeight();
                    yOffset = (double)(envInterval.getGpuTemperature() - this.getTemperatureMin()) / tSize;
                } else if (this.getTemperatureAvg() > 0) {
                    yOffset = this.getIntervalRowHeight() / 2;
                }
                return (int)yOffset;
            }
            case CUPTI_ACTIVITY_ENVIRONMENT_POWER: {
                double powerFactor = (double)envInterval.getPower() / (double)envInterval.getPowerLimit();
                return (int)(powerFactor * (double)this.getIntervalRowHeight());
            }
            case CUPTI_ACTIVITY_ENVIRONMENT_COOLING: {
                double fanFactor = (double)envInterval.getFanSpeed() / 100.0;
                return (int)(fanFactor * (double)this.getIntervalRowHeight());
            }
        }
        return 0;
    }

    public int getComputeCapabilityMajor() {
        return this.activity.computeCapabilityMajor;
    }

    public int getComputeCapabilityMinor() {
        return this.activity.computeCapabilityMinor;
    }

    public Integer[] getMaxGridDims() {
        Integer[] grid = new Integer[]{this.activity.maxGridDimX, this.activity.maxGridDimY, this.activity.maxGridDimZ};
        return grid;
    }

    public Integer[] getMaxBlockDims() {
        Integer[] block = new Integer[]{this.activity.maxBlockDimX, this.activity.maxBlockDimY, this.activity.maxBlockDimZ};
        return block;
    }

    public int getMaxThreadsPerBlock() {
        return this.activity.maxThreadsPerBlock;
    }

    public int getMaxSharedMemoryPerBlock() {
        return this.activity.maxSharedMemoryPerBlock;
    }

    public int getMaxRegistersPerBlock() {
        return this.activity.maxRegistersPerBlock;
    }

    public int getMaxWarpsPerMultiprocessor() {
        return this.activity.maxWarpsPerMultiprocessor;
    }

    public int getMaxBlocksPerMultiprocessor() {
        return this.activity.maxBlocksPerMultiprocessor;
    }

    public int getConstantMemorySize() {
        return this.activity.constantMemorySize;
    }

    public int getNumThreadsPerWarp() {
        return this.activity.numThreadsPerWarp;
    }

    public int getNumMultiprocessors() {
        return this.activity.numMultiprocessors;
    }

    public boolean supportsConcurrentKernels() {
        return CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_DEVICE_CONCURRENT_KERNELS.isSet(this.activity.flags);
    }

    public int getL2CacheSize() {
        return this.activity.l2CacheSize;
    }

    public long getCoreClockRate() {
        return this.activity.coreClockRate * 1000;
    }

    public int getNumMemcpyEngines() {
        return this.activity.numMemcpyEngines;
    }

    public long getGlobalMemoryBandwidth() {
        return this.activity.globalMemoryBandwidth * 1000L;
    }

    public long getGlobalMemorySize() {
        return this.activity.globalMemorySize;
    }

    public int getMaxIPC() {
        return this.activity.maxIPC;
    }

    public long getTotalKernelExecutionTime() {
        if (this.totalKernelExecutionTime < 0L) {
            this.totalKernelExecutionTime = 0L;
            for (Timeline child : this.getChildren()) {
                if (!(child instanceof TimelineContext)) continue;
                this.totalKernelExecutionTime += ((TimelineContext)child).getTotalKernelExecutionTime();
            }
        }
        return this.totalKernelExecutionTime;
    }

    public int getTotalKernelInvocationCount() {
        if (this.totalInvocations < 0) {
            this.totalInvocations = 0;
            for (Timeline child : this.getChildren()) {
                if (!(child instanceof TimelineContext)) continue;
                this.totalInvocations += ((TimelineContext)child).getTotalKernelInvocationCount();
            }
        }
        return this.totalInvocations;
    }

    public Number getAttributeValue(CuptiDeviceAttribute kind) {
        CuptiActivityDeviceAttribute attr = this.cuptiAttributes.get((Object)kind);
        if (attr != null) {
            return attr.longValue;
        }
        return null;
    }

    public Number getAttributeValue(CuDeviceAttribute kind) {
        CuptiActivityDeviceAttribute attr = this.cuAttributes.get((Object)kind);
        if (attr != null) {
            return attr.intValue;
        }
        return null;
    }

    public Long getMaxSharedMemory(CuCacheConfig config) {
        CuptiActivityDeviceAttribute attr = null;
        switch (config) {
            case CU_FUNC_CACHE_PREFER_NONE: {
                return OccupancyCalculator.getMaxSharedMemoryPerMultiprocessor(this);
            }
            case CU_FUNC_CACHE_PREFER_SHARED: {
                attr = this.cuptiAttributes.get((Object)CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_SHARED);
                break;
            }
            case CU_FUNC_CACHE_PREFER_L1: {
                attr = this.cuptiAttributes.get((Object)CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_L1);
                break;
            }
            case CU_FUNC_CACHE_PREFER_EQUAL: {
                attr = this.cuptiAttributes.get((Object)CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_EQUAL);
                break;
            }
        }
        return attr != null ? Long.valueOf(attr.longValue) : null;
    }

    public boolean addAttribute(CuptiActivityDeviceAttribute attr) {
        CuptiDeviceAttribute cupti = attr.getCuptiAttribute();
        if (cupti != null) {
            this.cuptiAttributes.put(cupti, attr);
            return true;
        }
        CuDeviceAttribute cu = attr.getCuAttribute();
        if (cu != null) {
            this.cuAttributes.put(cu, attr);
            return true;
        }
        return false;
    }

    public void addAttributes(Collection<CuptiActivityDeviceAttribute> attrs) {
        for (CuptiActivityDeviceAttribute attr : attrs) {
            this.addAttribute(attr);
        }
    }

    @Override
    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        try {
            this.activity.appendToPDM(pdm.getNativeHandle());
            if (this.getCustomName() != null) {
                CuptiActivityName nameActivity = new CuptiActivityName(CuptiActivityObjectKind.CUPTI_ACTIVITY_OBJECT_DEVICE.getCode(), 0, 0, this.activity.id, 0, 0, this.getCustomName());
                nameActivity.appendToPDM(pdm.getNativeHandle());
            }
            for (CuptiActivityDeviceAttribute attr : this.cuptiAttributes.values()) {
                attr.appendToPDM(pdm.getNativeHandle());
            }
            for (CuptiActivityDeviceAttribute attr : this.cuAttributes.values()) {
                attr.appendToPDM(pdm.getNativeHandle());
            }
            List<ITimelineInterval> intervals = this.getIntervals(true);
            for (ITimelineInterval iTimelineInterval : intervals) {
                if (!(iTimelineInterval instanceof TimelineIntervalEnvironment)) continue;
                iTimelineInterval.appendToPDM(pdm);
            }
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }

    @Override
    public int getNumIntervals() {
        return super.getNumIntervals() + this.utilizationIntervals.size();
    }

    @Override
    public List<ITimelineInterval> getIntervals(boolean loadAnalysis) {
        List<ITimelineInterval> result = super.getIntervals(loadAnalysis);
        result.addAll(this.utilizationIntervals);
        return result;
    }

    public synchronized void addUtilizationInterval(ITimelineInterval interval) {
        this.utilizationIntervals.add(interval);
    }

    public synchronized void removeAllUtilizationIntervals() {
        this.utilizationIntervals.clear();
    }

    @Override
    public synchronized void addAdditionalIntervals() {
        for (ITimelineInterval interval : this.utilizationIntervals) {
            this.addInterval(interval, false);
        }
    }
}

