/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.ui.connection.toolkits;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.wizards.ContextPropertyStore;
import com.nvidia.common.wizards.PropertyDescriptor;
import com.nvidia.cuda.ide.remote.connection.CudaToolkitWorkingCopy;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.ui.connection.toolkits.CustomToolsWizardPage;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.wizard.Wizard;

public final class CustomToolsWizard
extends Wizard {
    private final CudaToolkitWorkingCopy toolkit;
    private final IRemoteConnection connection;
    private ContextPropertyStore map;

    public static PropertyDescriptor<String> getPathProperty(ICudaToolkit.Tool tool) {
        return new PropertyDescriptor(String.valueOf(tool.name()) + ".path", String.class);
    }

    public CustomToolsWizard(CudaToolkitWorkingCopy toolkit, IRemoteConnection connection) {
        this.toolkit = toolkit;
        this.connection = connection;
    }

    public void addPages() {
        DataBindingContext context = new DataBindingContext();
        this.map = new ContextPropertyStore(context.getValidationRealm());
        this.addPage(new CustomToolsWizardPage(context, this.map, this.toolkit, this.connection));
    }

    public boolean performFinish() {
        ICudaToolkit.Tool[] tools;
        ICudaToolkit.Tool[] toolArray = tools = ICudaToolkit.Tool.values();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ICudaToolkit.Tool tool = toolArray[n2];
            String path = (String)this.map.getProperty(CustomToolsWizard.getPathProperty(tool));
            if (CoreUtil.isNullOrEmpty((String)path) || CoreUtil.equals((Object)this.toolkit.getDefaultToolPath(tool), (Object)path)) {
                path = null;
            }
            this.toolkit.setToolPath(tool, path);
            ++n2;
        }
        return true;
    }
}

