/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.repository.tree.FileNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddToIndexCommand
extends RepositoriesViewCommandHandler<FileNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List selectedNodes = this.getSelectedNodes(event);
        if (selectedNodes.isEmpty() || ((FileNode)selectedNodes.get(0)).getRepository() == null) {
            return null;
        }
        Repository repository = ((FileNode)selectedNodes.get(0)).getRepository();
        Path workTreePath = new Path(repository.getWorkTree().getAbsolutePath());
        AddCommand addCommand = new Git(repository).add();
        Collection<IPath> paths = this.getSelectedFileAndFolderPaths(event);
        for (IPath path : paths) {
            String repoRelativepath = path.equals((Object)workTreePath) ? "." : path.removeFirstSegments(path.matchingFirstSegments((IPath)workTreePath)).setDevice(null).toString();
            addCommand.addFilepattern(repoRelativepath);
        }
        try {
            addCommand.call();
        }
        catch (GitAPIException e) {
            Activator.logError(UIText.AddToIndexCommand_addingFilesFailed, e);
        }
        return null;
    }

    public boolean isEnabled() {
        return this.isWorkingDirSelection();
    }
}

