/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.ui;

import com.nvidia.cuda.ide.build.project.AbstractMultiModule;
import com.nvidia.cuda.ide.build.ui.ExecutableFilesContentProvider;
import com.nvidia.cuda.ide.build.ui.MultiModuleView;
import com.nvidia.cuda.ide.build.util.SwtUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerComparator;
import org.eclipse.ui.statushandlers.StatusManager;

public final class ModuleFiles {
    private final ToolItem exludeButton;
    private final TableViewer files;
    private final ToolItem includeButton;
    private AbstractMultiModule module;
    private final Composite topPane;

    protected static void handle(CoreException e1) {
        StatusManager.getManager().handle((IStatus)new Status(4, "com.nvidia.cuda.ide.build", "Cannot update file list", (Throwable)e1));
    }

    public ModuleFiles(Composite parent) {
        this.topPane = new Composite(parent, 2048);
        this.topPane.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gl_composite_4 = new GridLayout(2, false);
        gl_composite_4.verticalSpacing = 0;
        gl_composite_4.marginHeight = 0;
        this.topPane.setLayout((Layout)gl_composite_4);
        Label lblIncludedFiles = new Label(this.topPane, 0);
        lblIncludedFiles.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblIncludedFiles.setText("Included files");
        ToolBar toolBar_1 = new ToolBar(this.topPane, 0x820000);
        toolBar_1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.includeButton = new ToolItem(toolBar_1, 0);
        this.includeButton.setToolTipText("Add source file");
        this.includeButton.setImage(sharedImages.getImage("IMG_OBJ_ADD"));
        this.includeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IFile file = ModuleFiles.this.addToExecutable();
                    ModuleFiles.this.files.refresh();
                    if (file != null) {
                        ModuleFiles.this.files.setSelection((ISelection)new StructuredSelection((Object)file));
                    }
                }
                catch (CoreException e1) {
                    ModuleFiles.handle(e1);
                }
            }
        });
        this.exludeButton = new ToolItem(toolBar_1, 0);
        this.exludeButton.setToolTipText("Remove source file");
        this.exludeButton.setImage(sharedImages.getImage("IMG_TOOL_DELETE"));
        this.exludeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ModuleFiles.this.removeFromExecutable(ModuleFiles.this.files.getSelection());
                }
                catch (CoreException e1) {
                    ModuleFiles.handle(e1);
                }
                ModuleFiles.this.files.refresh();
            }
        });
        this.files = new TableViewer(parent, 67584);
        Table table = this.files.getTable();
        GridData data = new GridData(4, 4, true, true, 1, 1);
        data.heightHint = 30;
        data.minimumHeight = 16;
        table.setLayoutData((Object)data);
        this.files.setLabelProvider((IBaseLabelProvider)new ModuleFilesLabelProvider());
        this.files.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        this.files.setContentProvider((IContentProvider)new ExecutableFilesContentProvider());
        this.files.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                Boolean includes = ModuleFiles.this.module.includes((IFile)element);
                return includes == null || includes != false;
            }
        }});
        this.files.setInput((Object)this.module);
        this.files.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModuleFiles.this.exludeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        Object element = this.files.getElementAt(0);
        if (element != null) {
            this.files.setSelection((ISelection)new StructuredSelection(element));
        }
        this.exludeButton.setEnabled(element != null);
    }

    protected IFile addToExecutable() throws CoreException {
        if (this.module != null) {
            IFile file = this.getSelectionIfNotInAllConfigs();
            if (file == null) {
                file = MultiModuleView.getNewModuleSourceFile(this.module.getParentConfiguration(), null);
            }
            if (file != null) {
                this.module.include(file);
                return file;
            }
        }
        return null;
    }

    private IFile getSelectionIfNotInAllConfigs() {
        Object file;
        IStructuredSelection selection;
        if (this.module != null && !(selection = (IStructuredSelection)this.files.getSelection()).isEmpty() && (file = selection.getFirstElement()) instanceof IFile && this.module.includes((IFile)file) == null) {
            return (IFile)file;
        }
        return null;
    }

    public void hide(boolean hide) {
        SwtUtil.setHidden((Control)this.topPane, hide);
        SwtUtil.setHidden(this.files.getControl(), hide);
    }

    public boolean isOnlyInSomeConfigurations(Object element) {
        if (element instanceof IFile && this.module != null) {
            return this.module.includes((IFile)element) == null;
        }
        return false;
    }

    public void refresh() {
        if (!this.files.getControl().isDisposed()) {
            this.files.refresh();
        }
    }

    protected void removeFromExecutable(ISelection selection) throws CoreException {
        if (!selection.isEmpty()) {
            this.module.exclude((IFile)((IStructuredSelection)selection).getFirstElement());
        }
    }

    public void setEnabled(boolean enabled) {
        this.files.getControl().setEnabled(enabled);
        this.exludeButton.setEnabled(enabled && !this.files.getSelection().isEmpty());
        this.includeButton.setEnabled(enabled);
    }

    public void setModule(AbstractMultiModule module) {
        this.module = module;
        this.files.setInput((Object)module);
    }

    public final class ModuleFilesLabelProvider
    extends WorkbenchLabelProvider {
        public Color getForeground(Object element) {
            if (ModuleFiles.this.isOnlyInSomeConfigurations(element)) {
                return ModuleFiles.this.files.getControl().getDisplay().getSystemColor(33);
            }
            return super.getForeground(element);
        }
    }
}

