/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.files;

import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.exceptions.InternalErrorException;
import amazon.fws.clicommando.files.FileUtils;
import amazon.fws.clicommando.files.FilesBrowser;
import amazon.fws.clicommando.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByExtensionFileSystemFilesBrowser
implements Iterator<InputStream>,
FilesBrowser {
    private Iterator<File> iterator;
    private String currentFilePath;

    public ByExtensionFileSystemFilesBrowser(String rootDir, String dir, String extension) {
        String root = StringUtils.isEmpty(rootDir) ? "" : rootDir;
        String pathname = StringUtils.isEmpty(dir) ? root : root + File.separator + dir;
        File path = new File(pathname);
        if (!path.canRead()) {
            throw new ConfigurationErrorException("Can't read from file: " + pathname);
        }
        LinkedList<File> xmlFiles = new LinkedList<File>();
        File[] allFiles = path.isDirectory() ? path.listFiles() : new File[]{path};
        for (File curFile : allFiles) {
            if (!FileUtils.hasExtension(curFile.getName(), extension) || curFile.isDirectory()) continue;
            xmlFiles.add(curFile);
        }
        this.iterator = xmlFiles.iterator();
    }

    @Override
    public void remove() {
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public InputStream next() {
        File file = this.iterator.next();
        try {
            this.currentFilePath = file.getPath();
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new InternalErrorException("Cannot open file: ", e);
        }
    }

    @Override
    public String getCurrentFilePath() {
        return this.currentFilePath;
    }

    @Override
    public Iterator<InputStream> iterator() {
        return this;
    }
}

