/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.security;

import amazon.fws.clicommando.exceptions.InternalErrorException;
import amazon.fws.clicommando.processors.service.ServiceCallConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.StrictHostnameVerifier;

public final class VerifyHostnameAgainstCertificate {
    public static void setHttpsTrustManager(boolean addHostnameVerifier, ServiceCallConfig config) {
        TrustManager[] trustManager = null;
        if (addHostnameVerifier) {
            trustManager = new TrustManager[]{new VerifyHostnameTrustManager(config)};
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustManager, new SecureRandom());
            SSLContext.setDefault(sslContext);
        }
        catch (GeneralSecurityException gse) {
            throw new InternalErrorException("In creating hostname verifier trust manager", gse);
        }
    }

    private static class VerifyHostnameTrustManager
    implements X509TrustManager {
        private ServiceCallConfig config;

        public VerifyHostnameTrustManager(ServiceCallConfig config) {
            this.config = config;
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) {
            throw new UnsupportedOperationException();
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                this.checkServerTrustedUsingSystemDefaultTrustManagers(chain, authType);
                StrictHostnameVerifier verifier = new StrictHostnameVerifier();
                URL serviceUrl = new URL(this.config.getServiceUrl());
                try {
                    verifier.verify(serviceUrl.getHost(), chain[0]);
                }
                catch (SSLException e) {
                    throw new CertificateException("Unable to match the service hostname (" + serviceUrl.getHost() + ") with the certificate returned by the server.");
                }
            }
            catch (MalformedURLException e) {
                throw new CertificateException("Couldn't parse the service URL for some reason.");
            }
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        private void checkServerTrustedUsingSystemDefaultTrustManagers(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
                if (trustManagerFactory == null) {
                    trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                }
                trustManagerFactory.init((KeyStore)null);
                TrustManager[] tms = trustManagerFactory.getTrustManagers();
                X509TrustManager x509tm = this.getOnlyX509TrustManager(tms);
                x509tm.checkServerTrusted(chain, authType);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CertificateException("Unable to set up the TrustManagerFactory.");
            }
            catch (KeyStoreException e) {
                throw new CertificateException("Unable to set up the TrustManagerFactory.");
            }
        }

        private X509TrustManager getOnlyX509TrustManager(TrustManager[] tms) throws CertificateException {
            X509TrustManager x509tm = null;
            for (TrustManager tm : tms) {
                if (!(tm instanceof X509TrustManager)) continue;
                if (x509tm == null) {
                    x509tm = (X509TrustManager)tm;
                    continue;
                }
                throw new CertificateException("Found more than one X509TrustManager, don't know which to trust.");
            }
            if (x509tm == null) {
                throw new CertificateException("Didn't find an X509TrustManager, assuming nothing can be trusted.");
            }
            return x509tm;
        }
    }
}

