/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache license, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the license for the specific language governing permissions and
 * limitations under the license.
 */
package org.apache.logging.log4j.web;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.junit.Test;

import static org.junit.Assert.*;

/**
 *
 */
public class PropertyTest {

    @Test
    public void testShutdownHookDisabled() {
        assertFalse(
                "Shutdown hook should be disabled by default in web applications",
                ((Log4jContextFactory) LogManager.getFactory()).isShutdownHookEnabled());
    }

    @Test
    public void testIsWebApp() {
        assertTrue("When servlet classes are available IS_WEB_APP should default to true", Constants.IS_WEB_APP);
    }
}
