
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsewaverepo.proc"
// Licensed GNU LGPL v2.1 or later: http://www.gnu.org/licenses/lgpl.html
#include <bse/bseplugin.hh>
#include <bse/bseprocedure.hh>
#include <bse/bsewaverepo.hh>
#include <bse/bseloader.hh>
#include <bse/bsewave.hh>
#include "bsecxxplugin.hh"
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
#line 12 "bsewaverepo.proc"

static BseErrorType
load_file (BseWaveRepo *wrepo,
	   const gchar *file_name,
           BseWave    **wave_p)
{
  gchar *fname = g_path_get_basename (file_name);
  BseWave *wave = (BseWave*) g_object_new (BSE_TYPE_WAVE, "uname", fname, NULL);
  g_free (fname);
  BseErrorType error = bse_wave_load_wave_file (wave, file_name, NULL, NULL, NULL, TRUE);
  if (wave->n_wchunks)
    {
      bse_container_add_item (BSE_CONTAINER (wrepo), BSE_ITEM (wave));
      *wave_p = wave;
      error = BSE_ERROR_NONE;
    }
  else
    {
      if (!error)
        error = BSE_ERROR_WAVE_NOT_FOUND;
      *wave_p = NULL;
    }
  g_object_unref (wave);
  return error;
}
#line 37 "bsewaverepo.proc"

/* --- load-file --- */
static void
load_file_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 40 "bsewaverepo.proc"
 {
#line 42 "bsewaverepo.proc"
  *(in_pspecs++)    = bse_param_spec_object ("wave_repo", "Wave Repo", NULL,
				 BSE_TYPE_WAVE_REPO, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("file_name", "File Name", "The file to import waves from",
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 50 "bsewaverepo.proc"
 }
static BseErrorType
#line 50 "bsewaverepo.proc"
load_file_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 53 "bsewaverepo.proc"
{
#line 54 "bsewaverepo.proc"
  
  BseWaveRepo *self = (BseWaveRepo*) bse_value_get_object (in_values++);
  const char *file_name = sfi_value_get_string (in_values++);
  BseUndoStack *ustack;
  BseErrorType error;
  BseWave *wave;
#line 60 "bsewaverepo.proc"
  
  if (!BSE_IS_WAVE_REPO (self) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  ustack = bse_item_undo_open (self, "load-wave");
  error = load_file (self, file_name, &wave);
  if (wave)
    bse_item_push_undo_proc (self, "remove-wave", wave);
  bse_item_undo_close (ustack);
#line 68 "bsewaverepo.proc"
  
  g_value_set_enum (out_values++, error);
  return BSE_ERROR_NONE;
}
/* --- remove-wave --- */
static void
remove_wave_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 72 "bsewaverepo.proc"
 {
#line 74 "bsewaverepo.proc"
  *(in_pspecs++)    = bse_param_spec_object ("wave_repo", "Wave Repo", NULL,
				 BSE_TYPE_WAVE_REPO, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("wave", "Wave", NULL,
				 BSE_TYPE_WAVE, SFI_PARAM_STANDARD);
#line 78 "bsewaverepo.proc"
}  }
static BseErrorType
#line 78 "bsewaverepo.proc"
remove_wave_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 81 "bsewaverepo.proc"
{
#line 82 "bsewaverepo.proc"
  
  BseWaveRepo *self = (BseWaveRepo*) bse_value_get_object (in_values++);
  BseItem *child    = (BseItem*) bse_value_get_object (in_values++);
  BseUndoStack *ustack;
#line 86 "bsewaverepo.proc"
  
  if (!BSE_IS_WAVE_REPO (self) || !BSE_IS_WAVE (child) ||
      child->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 90 "bsewaverepo.proc"
  
  ustack = bse_item_undo_open (self, "remove-wave %s", bse_object_debug_name (child));
#line 92 "bsewaverepo.proc"
  
  bse_container_uncross_undoable (BSE_CONTAINER (self), child);
#line 94 "bsewaverepo.proc"
  
  bse_item_push_redo_proc (self, "remove-wave", child);
#line 96 "bsewaverepo.proc"
  
  bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 98 "bsewaverepo.proc"
  
  bse_item_undo_close (ustack);
  return BSE_ERROR_NONE;
}
/* --- bse-sample-file-info --- */
static void
bse_sample_file_info_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 102 "bsewaverepo.proc"
 {
#line 104 "bsewaverepo.proc"
  *(in_pspecs++) = sfi_pspec_string ("file_name", "File Name", "The file to load info from",
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("sample_file_info", NULL, NULL, BSE_TYPE_SAMPLE_FILE_INFO, SFI_PARAM_STANDARD);
}
#line 108 "bsewaverepo.proc"
 }
static BseErrorType
#line 108 "bsewaverepo.proc"
bse_sample_file_info_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 111 "bsewaverepo.proc"
{
#line 112 "bsewaverepo.proc"
  
  const char *filename = sfi_value_get_string (in_values++);
  BseWaveFileInfo *wfi = NULL;
  struct stat sbuf = { 0, };
#line 116 "bsewaverepo.proc"
  
  if (!filename)
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 119 "bsewaverepo.proc"
  
  BseSampleFileInfo info = { 0, };
  info.file = (char*) filename;
  info.waves = bse_string_seq_new ();
  if (stat (filename, &sbuf) < 0)
    info.error = bse_error_from_errno (errno, BSE_ERROR_FILE_OPEN_FAILED);
  else
    {
      info.size = sbuf.st_size;
      info.mtime = sbuf.st_mtime * SFI_USEC_FACTOR;
      wfi = bse_wave_file_info_load (filename, (BseErrorType*) &info.error);
      if (wfi)
	{
	  guint i;
	  for (i = 0; i < wfi->n_waves; i++)
	    bse_string_seq_append (info.waves, wfi->waves[i].name);
	  info.loader = (gchar*) bse_wave_file_info_loader (wfi);
	}
    }
#line 138 "bsewaverepo.proc"
  
  bse_value_set_boxed (out_values++, &info);
#line 140 "bsewaverepo.proc"
  
  bse_string_seq_free (info.waves);
  if (wfi)
    bse_wave_file_info_unref (wfi);
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_load_file__fill_strings (BseExportStrings *es)
{
  es->blurb = "Load wave from file";
  es->file = "/opt/src/beast/bse/bsewaverepo.proc";
  es->line = 41;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_load_file = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseWaveRepo+load-file", 
    NULL,
    "/Methods/BseWaveRepo/General/Load File",
    NULL,
    __enode_load_file__fill_strings,
  },
  0, load_file_setup, load_file_exec, 
};
static void
__enode_remove_wave__fill_strings (BseExportStrings *es)
{
  es->blurb = "Remove a wave from repository";
  es->file = "/opt/src/beast/bse/bsewaverepo.proc";
  es->line = 73;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_remove_wave = {
  { (BseExportNode*) &__enode_load_file, BSE_EXPORT_NODE_PROC,
    "BseWaveRepo+remove-wave", 
    NULL,
    "/Methods/BseWaveRepo/General/Remove Wave",
    NULL,
    __enode_remove_wave__fill_strings,
  },
  0, remove_wave_setup, remove_wave_exec, 
};
static void
__enode_bse_sample_file_info__fill_strings (BseExportStrings *es)
{
  es->blurb = "Load sample file info from file";
  es->file = "/opt/src/beast/bse/bsewaverepo.proc";
  es->line = 103;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_sample_file_info = {
  { (BseExportNode*) &__enode_remove_wave, BSE_EXPORT_NODE_PROC,
    "bse-sample-file-info", 
    NULL,
    "/Proc/Sample File Info",
    NULL,
    __enode_bse_sample_file_info__fill_strings,
  },
  0, bse_sample_file_info_setup, bse_sample_file_info_exec, 
};
extern "C" BseExportNode* bse__builtin_init_bsewaverepo_genprc_cc (void)
{
  return (BseExportNode*) &__enode_bse_sample_file_info;
}

/*
 * Generated data ends here
 */
