set set-var(name) set-var
set set-var(short) sv
set set-var(purpose) {
  set value of variables in din
}
set set-var(invoke) {
  set-var <variable1> <value1> <variable2> <value2>... <variableN> <valueN>
}
set set-var(help) {
  sets the value of variables. available variables are:

  wave_volume or wv -- lead voice volume
  note_volume or nv -- note volume on keyboard-keyboard
  attack_time or at -- attack time in seconds for a note on keyboard-keyboard
  decay_time or dt -- decay time in seconds for a note on keyboard-keyboard
  sustain or su -- position on attack curve where note starts to sustain
  drone_master_volume or dmv -- drone master volume
  fm_depth or fmd -- FM depth
  am_depth or amd -- AM depth
  delta_bpm or dbpm -- amount to increase/decrease when changing bpm of gater, fm, am & octave shift modules
  num_sine_samples or nss -- number of samples used when converting sine waveform to bezier waveform
  drone_handle_size or dhs -- handle size of drones used for display/selection
  snap_drones or sd -- drones snapped to notes? 1 = yes or 0 = no
  scroll or sc -- scroll rate, amount in x and amount in y for wsad key press
  zoom -- zoom of all curve editors. returns rate and amount
  pan -- pan on all curve editors. returns rate and amount
  show_cursor_info or sci -- show frequency/volume under mouse cursor? 1 = yes, 0 = no
  jog or j -- number of samples to jump upon <- and -> key presses when phrasor is playing
  fps -- number of times din refreshes the ui every second
  usleep -- number of microseconds din sleeps to allow processor do other tasks
  scale -- name of current scale
  tuning or tu -- name of current tuning
  auto_connect_outputs -- auto connect din audio outputs to system audio output?}
set set-var(examples) {
  set-var scroll rate 100 x 25 y 3;# scroll 25 units in x & 3 units in y upto 100 times a second on wasd key presses
  set-var amd 0 ;# set am_depth to 0
  set-var fmd 0 ;# set fm_depth to 0
  set-var am_depth -0.5 fm_depth 100 ;# set am_depth to -0.5 and fm_depth to 100
  set-var delta_bpm 5 ;# change bpm of gaters, fm, am & octave shift by 5 beats when asked
  set-var drone_master_volume 0.9 ;# very loud drones. careful.
  set-var dmv 0 ;# silence all drones
  set-var snap_drones 1 ;# snap new drones or moved drones to notes
  set-var drone_handle_size 14 ;# twice the size of default drone handles which is 7
  set-var zoom rate 100 amount 0.03 ;# zoom 100 times a second at 0.03 units per zoom in all curve editors
  set-var pan amount 0.03 rate 100 ;# pan 100 times a second at 0.03 units per pan in all curve editors
  set-var fps 30 ;# refresh din ui 30 times a second
  set-var usleep 0 ;# dont sleep at all - max processor usage but ultra performance (in theory)
  set-var num_sine_samples 100 ;# number of samples for converting sine waveform -> bezier waveform
  set-var jog 10 ;# jump 10 samples when jogging the phrasor
  set-var wave_volume 0.1 ;# volume of lead voice
  set-var attack_time 1 ;# note on keyboard-keyboard attacks in 1 second
  set-var decay_time 10 ;# note on keyboard-keyboard decays in 1 second
  set-var note_volume [expr 0.75 * [get-var wave_volume]] ;# max note volume is 75% of lead voice
  set-var sustain 1.0 ;# position on attack curve where sustain begins ie at 1.0 (default)}
