/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#include "glyph.h"

#include <iostream>
using namespace std;

glyph::glyph (const vector<line>& vl) : lines(vl) {}

void glyph::find_width_height () {

  if (int nlines = lines.size ()) {
		
		int l, r, t;
		l = r = t = 0;
    vector< point<int> >& points = lines[0].points;
    if (points.size()) {
      point<int>& p = points[0];
      l = r = p.x;
      t = p.y;
    }

    for (int i = 0; i < nlines; ++i) {
      vector< point<int> >& points = lines[i].points;
      for (int p = 0, q = points.size(); p < q; ++p) {
        point<int>& pt = points[p];
        if (pt.x < l) l = pt.x; else if (pt.x > r) r = pt.x;
        if (pt.y > t) t = pt.y;
      }
    }

    width = r - l;
    height = t;
    
  }

}
