/*******************************************************************************
 * Copyright (c) 2006, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cdt.errorparsers.xlc.tests;

import junit.framework.TestCase;

import org.eclipse.cdt.core.IMarkerGenerator;

public class TestRedeclaration extends TestCase {
	/**
	 * This function tests parseLine function of the
	 * XlcErrorParser class. The second message generated by
	 * xlc compiler for symbol redeclaration problem is given as
	 * input for testing.
	 */
	public void testparseLine()
	{
		XlcErrorParserTester aix = new XlcErrorParserTester();
		// Redeclaration error generates 2 cross-referencing messages.
		String err_msg = "\"src/temp1.c\", line 6.6: 1506-343 (S) Redeclaration of my_fun differs from previous declaration on line 334 of \"include/temp1.h\".";
		aix.parseLine(err_msg);
		assertEquals(2, aix.getNumberOfMarkers());
		
		assertEquals("Redeclaration of my_fun differs from another declaration on line 6 of \"src/temp1.c\".", aix.getMessage(0));
		assertEquals("temp1.h", aix.getFileName(0));
		assertEquals(334, aix.getLineNumber(0));
		assertEquals(IMarkerGenerator.SEVERITY_ERROR_RESOURCE, aix.getSeverity(0));
		
		assertEquals("Redeclaration of my_fun differs from previous declaration on line 334 of \"include/temp1.h\".", aix.getMessage(1));
		assertEquals("temp1.c", aix.getFileName(1));
		assertEquals(6, aix.getLineNumber(1));
		assertEquals(IMarkerGenerator.SEVERITY_ERROR_RESOURCE, aix.getSeverity(1));
	}
	public TestRedeclaration( String name)
	{
		super(name);
	}
}