// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file core_typesPubSubTypes.cpp
 * This header file contains the implementation of the serialization functions.
 *
 * This file was generated by the tool fastddsgen.
 */

#include "core_typesPubSubTypes.hpp"

#include <fastdds/dds/log/Log.hpp>
#include <fastdds/rtps/common/CdrSerialization.hpp>

#include "core_typesCdrAux.hpp"
#include "core_typesTypeObjectSupport.hpp"

using SerializedPayload_t = eprosima::fastdds::rtps::SerializedPayload_t;
using InstanceHandle_t = eprosima::fastdds::rtps::InstanceHandle_t;
using DataRepresentationId_t = eprosima::fastdds::dds::DataRepresentationId_t;

namespace eprosima {
    namespace fastdds {
        namespace rtps {
            namespace core {
                namespace detail {
                    EntityId_tPubSubType::EntityId_tPubSubType()
                    {
                        set_name("eprosima::fastdds::rtps::core::detail::EntityId_t");
                        uint32_t type_size = eprosima_fastdds_rtps_core_detail_EntityId_t_max_cdr_typesize;
                        type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                        max_serialized_type_size = type_size + 4; /*encapsulation*/
                        is_compute_key_provided = false;
                        uint32_t key_length = eprosima_fastdds_rtps_core_detail_EntityId_t_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_detail_EntityId_t_max_key_cdr_typesize : 16;
                        key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                        memset(key_buffer_, 0, key_length);
                    }

                    EntityId_tPubSubType::~EntityId_tPubSubType()
                    {
                        if (key_buffer_ != nullptr)
                        {
                            free(key_buffer_);
                        }
                    }

                    bool EntityId_tPubSubType::serialize(
                            const void* const data,
                            SerializedPayload_t& payload,
                            DataRepresentationId_t data_representation)
                    {
                        const EntityId_t* p_type = static_cast<const EntityId_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                        payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                        ser.set_encoding_flag(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                        try
                        {
                            // Serialize encapsulation
                            ser.serialize_encapsulation();
                            // Serialize the object.
                            ser << *p_type;
                            ser.set_dds_cdr_options({0,0});
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        // Get the serialized length
                        payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                        return true;
                    }

                    bool EntityId_tPubSubType::deserialize(
                            SerializedPayload_t& payload,
                            void* data)
                    {
                        try
                        {
                            // Convert DATA to pointer of your type
                            EntityId_t* p_type = static_cast<EntityId_t*>(data);

                            // Object that manages the raw buffer.
                            eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                            // Object that deserializes the data.
                            eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                            // Deserialize encapsulation.
                            deser.read_encapsulation();
                            payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                            // Deserialize the object.
                            deser >> *p_type;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        return true;
                    }

                    uint32_t EntityId_tPubSubType::calculate_serialized_size(
                            const void* const data,
                            DataRepresentationId_t data_representation)
                    {
                        try
                        {
                            eprosima::fastcdr::CdrSizeCalculator calculator(
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                            size_t current_alignment {0};
                            return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                        *static_cast<const EntityId_t*>(data), current_alignment)) +
                                    4u /*encapsulation*/;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return 0;
                        }
                    }

                    void* EntityId_tPubSubType::create_data()
                    {
                        return reinterpret_cast<void*>(new EntityId_t());
                    }

                    void EntityId_tPubSubType::delete_data(
                            void* data)
                    {
                        delete(reinterpret_cast<EntityId_t*>(data));
                    }

                    bool EntityId_tPubSubType::compute_key(
                            SerializedPayload_t& payload,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        EntityId_t data;
                        if (deserialize(payload, static_cast<void*>(&data)))
                        {
                            return compute_key(static_cast<void*>(&data), handle, force_md5);
                        }

                        return false;
                    }

                    bool EntityId_tPubSubType::compute_key(
                            const void* const data,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        const EntityId_t* p_type = static_cast<const EntityId_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                                eprosima_fastdds_rtps_core_detail_EntityId_t_max_key_cdr_typesize);

                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                        ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                        eprosima::fastcdr::serialize_key(ser, *p_type);
                        if (force_md5 || eprosima_fastdds_rtps_core_detail_EntityId_t_max_key_cdr_typesize > 16)
                        {
                            md5_.init();
                            md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                            md5_.finalize();
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = md5_.digest[i];
                            }
                        }
                        else
                        {
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = key_buffer_[i];
                            }
                        }
                        return true;
                    }

                    void EntityId_tPubSubType::register_type_object_representation()
                    {
                        register_EntityId_t_type_identifier(type_identifiers_);
                    }

                    ProtocolVersion_tPubSubType::ProtocolVersion_tPubSubType()
                    {
                        set_name("eprosima::fastdds::rtps::core::detail::ProtocolVersion_t");
                        uint32_t type_size = eprosima_fastdds_rtps_core_detail_ProtocolVersion_t_max_cdr_typesize;
                        type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                        max_serialized_type_size = type_size + 4; /*encapsulation*/
                        is_compute_key_provided = false;
                        uint32_t key_length = eprosima_fastdds_rtps_core_detail_ProtocolVersion_t_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_detail_ProtocolVersion_t_max_key_cdr_typesize : 16;
                        key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                        memset(key_buffer_, 0, key_length);
                    }

                    ProtocolVersion_tPubSubType::~ProtocolVersion_tPubSubType()
                    {
                        if (key_buffer_ != nullptr)
                        {
                            free(key_buffer_);
                        }
                    }

                    bool ProtocolVersion_tPubSubType::serialize(
                            const void* const data,
                            SerializedPayload_t& payload,
                            DataRepresentationId_t data_representation)
                    {
                        const ProtocolVersion_t* p_type = static_cast<const ProtocolVersion_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                        payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                        ser.set_encoding_flag(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                        try
                        {
                            // Serialize encapsulation
                            ser.serialize_encapsulation();
                            // Serialize the object.
                            ser << *p_type;
                            ser.set_dds_cdr_options({0,0});
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        // Get the serialized length
                        payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                        return true;
                    }

                    bool ProtocolVersion_tPubSubType::deserialize(
                            SerializedPayload_t& payload,
                            void* data)
                    {
                        try
                        {
                            // Convert DATA to pointer of your type
                            ProtocolVersion_t* p_type = static_cast<ProtocolVersion_t*>(data);

                            // Object that manages the raw buffer.
                            eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                            // Object that deserializes the data.
                            eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                            // Deserialize encapsulation.
                            deser.read_encapsulation();
                            payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                            // Deserialize the object.
                            deser >> *p_type;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        return true;
                    }

                    uint32_t ProtocolVersion_tPubSubType::calculate_serialized_size(
                            const void* const data,
                            DataRepresentationId_t data_representation)
                    {
                        try
                        {
                            eprosima::fastcdr::CdrSizeCalculator calculator(
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                            size_t current_alignment {0};
                            return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                        *static_cast<const ProtocolVersion_t*>(data), current_alignment)) +
                                    4u /*encapsulation*/;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return 0;
                        }
                    }

                    void* ProtocolVersion_tPubSubType::create_data()
                    {
                        return reinterpret_cast<void*>(new ProtocolVersion_t());
                    }

                    void ProtocolVersion_tPubSubType::delete_data(
                            void* data)
                    {
                        delete(reinterpret_cast<ProtocolVersion_t*>(data));
                    }

                    bool ProtocolVersion_tPubSubType::compute_key(
                            SerializedPayload_t& payload,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        ProtocolVersion_t data;
                        if (deserialize(payload, static_cast<void*>(&data)))
                        {
                            return compute_key(static_cast<void*>(&data), handle, force_md5);
                        }

                        return false;
                    }

                    bool ProtocolVersion_tPubSubType::compute_key(
                            const void* const data,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        const ProtocolVersion_t* p_type = static_cast<const ProtocolVersion_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                                eprosima_fastdds_rtps_core_detail_ProtocolVersion_t_max_key_cdr_typesize);

                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                        ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                        eprosima::fastcdr::serialize_key(ser, *p_type);
                        if (force_md5 || eprosima_fastdds_rtps_core_detail_ProtocolVersion_t_max_key_cdr_typesize > 16)
                        {
                            md5_.init();
                            md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                            md5_.finalize();
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = md5_.digest[i];
                            }
                        }
                        else
                        {
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = key_buffer_[i];
                            }
                        }
                        return true;
                    }

                    void ProtocolVersion_tPubSubType::register_type_object_representation()
                    {
                        register_ProtocolVersion_t_type_identifier(type_identifiers_);
                    }

                    VendorId_tPubSubType::VendorId_tPubSubType()
                    {
                        set_name("eprosima::fastdds::rtps::core::detail::VendorId_t");
                        uint32_t type_size = eprosima_fastdds_rtps_core_detail_VendorId_t_max_cdr_typesize;
                        type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                        max_serialized_type_size = type_size + 4; /*encapsulation*/
                        is_compute_key_provided = false;
                        uint32_t key_length = eprosima_fastdds_rtps_core_detail_VendorId_t_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_detail_VendorId_t_max_key_cdr_typesize : 16;
                        key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                        memset(key_buffer_, 0, key_length);
                    }

                    VendorId_tPubSubType::~VendorId_tPubSubType()
                    {
                        if (key_buffer_ != nullptr)
                        {
                            free(key_buffer_);
                        }
                    }

                    bool VendorId_tPubSubType::serialize(
                            const void* const data,
                            SerializedPayload_t& payload,
                            DataRepresentationId_t data_representation)
                    {
                        const VendorId_t* p_type = static_cast<const VendorId_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                        payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                        ser.set_encoding_flag(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                        try
                        {
                            // Serialize encapsulation
                            ser.serialize_encapsulation();
                            // Serialize the object.
                            ser << *p_type;
                            ser.set_dds_cdr_options({0,0});
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        // Get the serialized length
                        payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                        return true;
                    }

                    bool VendorId_tPubSubType::deserialize(
                            SerializedPayload_t& payload,
                            void* data)
                    {
                        try
                        {
                            // Convert DATA to pointer of your type
                            VendorId_t* p_type = static_cast<VendorId_t*>(data);

                            // Object that manages the raw buffer.
                            eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                            // Object that deserializes the data.
                            eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                            // Deserialize encapsulation.
                            deser.read_encapsulation();
                            payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                            // Deserialize the object.
                            deser >> *p_type;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        return true;
                    }

                    uint32_t VendorId_tPubSubType::calculate_serialized_size(
                            const void* const data,
                            DataRepresentationId_t data_representation)
                    {
                        try
                        {
                            eprosima::fastcdr::CdrSizeCalculator calculator(
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                            size_t current_alignment {0};
                            return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                        *static_cast<const VendorId_t*>(data), current_alignment)) +
                                    4u /*encapsulation*/;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return 0;
                        }
                    }

                    void* VendorId_tPubSubType::create_data()
                    {
                        return reinterpret_cast<void*>(new VendorId_t());
                    }

                    void VendorId_tPubSubType::delete_data(
                            void* data)
                    {
                        delete(reinterpret_cast<VendorId_t*>(data));
                    }

                    bool VendorId_tPubSubType::compute_key(
                            SerializedPayload_t& payload,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        VendorId_t data;
                        if (deserialize(payload, static_cast<void*>(&data)))
                        {
                            return compute_key(static_cast<void*>(&data), handle, force_md5);
                        }

                        return false;
                    }

                    bool VendorId_tPubSubType::compute_key(
                            const void* const data,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        const VendorId_t* p_type = static_cast<const VendorId_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                                eprosima_fastdds_rtps_core_detail_VendorId_t_max_key_cdr_typesize);

                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                        ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                        eprosima::fastcdr::serialize_key(ser, *p_type);
                        if (force_md5 || eprosima_fastdds_rtps_core_detail_VendorId_t_max_key_cdr_typesize > 16)
                        {
                            md5_.init();
                            md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                            md5_.finalize();
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = md5_.digest[i];
                            }
                        }
                        else
                        {
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = key_buffer_[i];
                            }
                        }
                        return true;
                    }

                    void VendorId_tPubSubType::register_type_object_representation()
                    {
                        register_VendorId_t_type_identifier(type_identifiers_);
                    }

                    GuidPrefix_tPubSubType::GuidPrefix_tPubSubType()
                    {
                        set_name("eprosima::fastdds::rtps::core::detail::GuidPrefix_t");
                        uint32_t type_size = eprosima_fastdds_rtps_core_detail_GuidPrefix_t_max_cdr_typesize;
                        type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                        max_serialized_type_size = type_size + 4; /*encapsulation*/
                        is_compute_key_provided = false;
                        uint32_t key_length = eprosima_fastdds_rtps_core_detail_GuidPrefix_t_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_detail_GuidPrefix_t_max_key_cdr_typesize : 16;
                        key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                        memset(key_buffer_, 0, key_length);
                    }

                    GuidPrefix_tPubSubType::~GuidPrefix_tPubSubType()
                    {
                        if (key_buffer_ != nullptr)
                        {
                            free(key_buffer_);
                        }
                    }

                    bool GuidPrefix_tPubSubType::serialize(
                            const void* const data,
                            SerializedPayload_t& payload,
                            DataRepresentationId_t data_representation)
                    {
                        const GuidPrefix_t* p_type = static_cast<const GuidPrefix_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                        payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                        ser.set_encoding_flag(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                        try
                        {
                            // Serialize encapsulation
                            ser.serialize_encapsulation();
                            // Serialize the object.
                            ser << *p_type;
                            ser.set_dds_cdr_options({0,0});
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        // Get the serialized length
                        payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                        return true;
                    }

                    bool GuidPrefix_tPubSubType::deserialize(
                            SerializedPayload_t& payload,
                            void* data)
                    {
                        try
                        {
                            // Convert DATA to pointer of your type
                            GuidPrefix_t* p_type = static_cast<GuidPrefix_t*>(data);

                            // Object that manages the raw buffer.
                            eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                            // Object that deserializes the data.
                            eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                            // Deserialize encapsulation.
                            deser.read_encapsulation();
                            payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                            // Deserialize the object.
                            deser >> *p_type;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        return true;
                    }

                    uint32_t GuidPrefix_tPubSubType::calculate_serialized_size(
                            const void* const data,
                            DataRepresentationId_t data_representation)
                    {
                        try
                        {
                            eprosima::fastcdr::CdrSizeCalculator calculator(
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                            size_t current_alignment {0};
                            return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                        *static_cast<const GuidPrefix_t*>(data), current_alignment)) +
                                    4u /*encapsulation*/;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return 0;
                        }
                    }

                    void* GuidPrefix_tPubSubType::create_data()
                    {
                        return reinterpret_cast<void*>(new GuidPrefix_t());
                    }

                    void GuidPrefix_tPubSubType::delete_data(
                            void* data)
                    {
                        delete(reinterpret_cast<GuidPrefix_t*>(data));
                    }

                    bool GuidPrefix_tPubSubType::compute_key(
                            SerializedPayload_t& payload,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        GuidPrefix_t data;
                        if (deserialize(payload, static_cast<void*>(&data)))
                        {
                            return compute_key(static_cast<void*>(&data), handle, force_md5);
                        }

                        return false;
                    }

                    bool GuidPrefix_tPubSubType::compute_key(
                            const void* const data,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        const GuidPrefix_t* p_type = static_cast<const GuidPrefix_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                                eprosima_fastdds_rtps_core_detail_GuidPrefix_t_max_key_cdr_typesize);

                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                        ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                        eprosima::fastcdr::serialize_key(ser, *p_type);
                        if (force_md5 || eprosima_fastdds_rtps_core_detail_GuidPrefix_t_max_key_cdr_typesize > 16)
                        {
                            md5_.init();
                            md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                            md5_.finalize();
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = md5_.digest[i];
                            }
                        }
                        else
                        {
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = key_buffer_[i];
                            }
                        }
                        return true;
                    }

                    void GuidPrefix_tPubSubType::register_type_object_representation()
                    {
                        register_GuidPrefix_t_type_identifier(type_identifiers_);
                    }

                    GUID_tPubSubType::GUID_tPubSubType()
                    {
                        set_name("eprosima::fastdds::rtps::core::detail::GUID_t");
                        uint32_t type_size = eprosima_fastdds_rtps_core_detail_GUID_t_max_cdr_typesize;
                        type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                        max_serialized_type_size = type_size + 4; /*encapsulation*/
                        is_compute_key_provided = false;
                        uint32_t key_length = eprosima_fastdds_rtps_core_detail_GUID_t_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_detail_GUID_t_max_key_cdr_typesize : 16;
                        key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                        memset(key_buffer_, 0, key_length);
                    }

                    GUID_tPubSubType::~GUID_tPubSubType()
                    {
                        if (key_buffer_ != nullptr)
                        {
                            free(key_buffer_);
                        }
                    }

                    bool GUID_tPubSubType::serialize(
                            const void* const data,
                            SerializedPayload_t& payload,
                            DataRepresentationId_t data_representation)
                    {
                        const GUID_t* p_type = static_cast<const GUID_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                        payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                        ser.set_encoding_flag(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                        try
                        {
                            // Serialize encapsulation
                            ser.serialize_encapsulation();
                            // Serialize the object.
                            ser << *p_type;
                            ser.set_dds_cdr_options({0,0});
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        // Get the serialized length
                        payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                        return true;
                    }

                    bool GUID_tPubSubType::deserialize(
                            SerializedPayload_t& payload,
                            void* data)
                    {
                        try
                        {
                            // Convert DATA to pointer of your type
                            GUID_t* p_type = static_cast<GUID_t*>(data);

                            // Object that manages the raw buffer.
                            eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                            // Object that deserializes the data.
                            eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                            // Deserialize encapsulation.
                            deser.read_encapsulation();
                            payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                            // Deserialize the object.
                            deser >> *p_type;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        return true;
                    }

                    uint32_t GUID_tPubSubType::calculate_serialized_size(
                            const void* const data,
                            DataRepresentationId_t data_representation)
                    {
                        try
                        {
                            eprosima::fastcdr::CdrSizeCalculator calculator(
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                            size_t current_alignment {0};
                            return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                        *static_cast<const GUID_t*>(data), current_alignment)) +
                                    4u /*encapsulation*/;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return 0;
                        }
                    }

                    void* GUID_tPubSubType::create_data()
                    {
                        return reinterpret_cast<void*>(new GUID_t());
                    }

                    void GUID_tPubSubType::delete_data(
                            void* data)
                    {
                        delete(reinterpret_cast<GUID_t*>(data));
                    }

                    bool GUID_tPubSubType::compute_key(
                            SerializedPayload_t& payload,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        GUID_t data;
                        if (deserialize(payload, static_cast<void*>(&data)))
                        {
                            return compute_key(static_cast<void*>(&data), handle, force_md5);
                        }

                        return false;
                    }

                    bool GUID_tPubSubType::compute_key(
                            const void* const data,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        const GUID_t* p_type = static_cast<const GUID_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                                eprosima_fastdds_rtps_core_detail_GUID_t_max_key_cdr_typesize);

                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                        ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                        eprosima::fastcdr::serialize_key(ser, *p_type);
                        if (force_md5 || eprosima_fastdds_rtps_core_detail_GUID_t_max_key_cdr_typesize > 16)
                        {
                            md5_.init();
                            md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                            md5_.finalize();
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = md5_.digest[i];
                            }
                        }
                        else
                        {
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = key_buffer_[i];
                            }
                        }
                        return true;
                    }

                    void GUID_tPubSubType::register_type_object_representation()
                    {
                        register_GUID_t_type_identifier(type_identifiers_);
                    }

                    SequenceNumber_tPubSubType::SequenceNumber_tPubSubType()
                    {
                        set_name("eprosima::fastdds::rtps::core::detail::SequenceNumber_t");
                        uint32_t type_size = eprosima_fastdds_rtps_core_detail_SequenceNumber_t_max_cdr_typesize;
                        type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                        max_serialized_type_size = type_size + 4; /*encapsulation*/
                        is_compute_key_provided = false;
                        uint32_t key_length = eprosima_fastdds_rtps_core_detail_SequenceNumber_t_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_detail_SequenceNumber_t_max_key_cdr_typesize : 16;
                        key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                        memset(key_buffer_, 0, key_length);
                    }

                    SequenceNumber_tPubSubType::~SequenceNumber_tPubSubType()
                    {
                        if (key_buffer_ != nullptr)
                        {
                            free(key_buffer_);
                        }
                    }

                    bool SequenceNumber_tPubSubType::serialize(
                            const void* const data,
                            SerializedPayload_t& payload,
                            DataRepresentationId_t data_representation)
                    {
                        const SequenceNumber_t* p_type = static_cast<const SequenceNumber_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                        payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                        ser.set_encoding_flag(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                        try
                        {
                            // Serialize encapsulation
                            ser.serialize_encapsulation();
                            // Serialize the object.
                            ser << *p_type;
                            ser.set_dds_cdr_options({0,0});
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        // Get the serialized length
                        payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                        return true;
                    }

                    bool SequenceNumber_tPubSubType::deserialize(
                            SerializedPayload_t& payload,
                            void* data)
                    {
                        try
                        {
                            // Convert DATA to pointer of your type
                            SequenceNumber_t* p_type = static_cast<SequenceNumber_t*>(data);

                            // Object that manages the raw buffer.
                            eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                            // Object that deserializes the data.
                            eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                            // Deserialize encapsulation.
                            deser.read_encapsulation();
                            payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                            // Deserialize the object.
                            deser >> *p_type;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        return true;
                    }

                    uint32_t SequenceNumber_tPubSubType::calculate_serialized_size(
                            const void* const data,
                            DataRepresentationId_t data_representation)
                    {
                        try
                        {
                            eprosima::fastcdr::CdrSizeCalculator calculator(
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                            size_t current_alignment {0};
                            return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                        *static_cast<const SequenceNumber_t*>(data), current_alignment)) +
                                    4u /*encapsulation*/;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return 0;
                        }
                    }

                    void* SequenceNumber_tPubSubType::create_data()
                    {
                        return reinterpret_cast<void*>(new SequenceNumber_t());
                    }

                    void SequenceNumber_tPubSubType::delete_data(
                            void* data)
                    {
                        delete(reinterpret_cast<SequenceNumber_t*>(data));
                    }

                    bool SequenceNumber_tPubSubType::compute_key(
                            SerializedPayload_t& payload,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        SequenceNumber_t data;
                        if (deserialize(payload, static_cast<void*>(&data)))
                        {
                            return compute_key(static_cast<void*>(&data), handle, force_md5);
                        }

                        return false;
                    }

                    bool SequenceNumber_tPubSubType::compute_key(
                            const void* const data,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        const SequenceNumber_t* p_type = static_cast<const SequenceNumber_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                                eprosima_fastdds_rtps_core_detail_SequenceNumber_t_max_key_cdr_typesize);

                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                        ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                        eprosima::fastcdr::serialize_key(ser, *p_type);
                        if (force_md5 || eprosima_fastdds_rtps_core_detail_SequenceNumber_t_max_key_cdr_typesize > 16)
                        {
                            md5_.init();
                            md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                            md5_.finalize();
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = md5_.digest[i];
                            }
                        }
                        else
                        {
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = key_buffer_[i];
                            }
                        }
                        return true;
                    }

                    void SequenceNumber_tPubSubType::register_type_object_representation()
                    {
                        register_SequenceNumber_t_type_identifier(type_identifiers_);
                    }

                    Count_tPubSubType::Count_tPubSubType()
                    {
                        set_name("eprosima::fastdds::rtps::core::detail::Count_t");
                        uint32_t type_size = eprosima_fastdds_rtps_core_detail_Count_t_max_cdr_typesize;
                        type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                        max_serialized_type_size = type_size + 4; /*encapsulation*/
                        is_compute_key_provided = false;
                        uint32_t key_length = eprosima_fastdds_rtps_core_detail_Count_t_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_detail_Count_t_max_key_cdr_typesize : 16;
                        key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                        memset(key_buffer_, 0, key_length);
                    }

                    Count_tPubSubType::~Count_tPubSubType()
                    {
                        if (key_buffer_ != nullptr)
                        {
                            free(key_buffer_);
                        }
                    }

                    bool Count_tPubSubType::serialize(
                            const void* const data,
                            SerializedPayload_t& payload,
                            DataRepresentationId_t data_representation)
                    {
                        const Count_t* p_type = static_cast<const Count_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                        payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                        ser.set_encoding_flag(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                        try
                        {
                            // Serialize encapsulation
                            ser.serialize_encapsulation();
                            // Serialize the object.
                            ser << *p_type;
                            ser.set_dds_cdr_options({0,0});
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        // Get the serialized length
                        payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                        return true;
                    }

                    bool Count_tPubSubType::deserialize(
                            SerializedPayload_t& payload,
                            void* data)
                    {
                        try
                        {
                            // Convert DATA to pointer of your type
                            Count_t* p_type = static_cast<Count_t*>(data);

                            // Object that manages the raw buffer.
                            eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                            // Object that deserializes the data.
                            eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                            // Deserialize encapsulation.
                            deser.read_encapsulation();
                            payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                            // Deserialize the object.
                            deser >> *p_type;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        return true;
                    }

                    uint32_t Count_tPubSubType::calculate_serialized_size(
                            const void* const data,
                            DataRepresentationId_t data_representation)
                    {
                        try
                        {
                            eprosima::fastcdr::CdrSizeCalculator calculator(
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                            size_t current_alignment {0};
                            return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                        *static_cast<const Count_t*>(data), current_alignment)) +
                                    4u /*encapsulation*/;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return 0;
                        }
                    }

                    void* Count_tPubSubType::create_data()
                    {
                        return reinterpret_cast<void*>(new Count_t());
                    }

                    void Count_tPubSubType::delete_data(
                            void* data)
                    {
                        delete(reinterpret_cast<Count_t*>(data));
                    }

                    bool Count_tPubSubType::compute_key(
                            SerializedPayload_t& payload,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        Count_t data;
                        if (deserialize(payload, static_cast<void*>(&data)))
                        {
                            return compute_key(static_cast<void*>(&data), handle, force_md5);
                        }

                        return false;
                    }

                    bool Count_tPubSubType::compute_key(
                            const void* const data,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        const Count_t* p_type = static_cast<const Count_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                                eprosima_fastdds_rtps_core_detail_Count_t_max_key_cdr_typesize);

                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                        ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                        eprosima::fastcdr::serialize_key(ser, *p_type);
                        if (force_md5 || eprosima_fastdds_rtps_core_detail_Count_t_max_key_cdr_typesize > 16)
                        {
                            md5_.init();
                            md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                            md5_.finalize();
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = md5_.digest[i];
                            }
                        }
                        else
                        {
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = key_buffer_[i];
                            }
                        }
                        return true;
                    }

                    void Count_tPubSubType::register_type_object_representation()
                    {
                        register_Count_t_type_identifier(type_identifiers_);
                    }

                    Time_tPubSubType::Time_tPubSubType()
                    {
                        set_name("eprosima::fastdds::rtps::core::detail::Time_t");
                        uint32_t type_size = eprosima_fastdds_rtps_core_detail_Time_t_max_cdr_typesize;
                        type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                        max_serialized_type_size = type_size + 4; /*encapsulation*/
                        is_compute_key_provided = false;
                        uint32_t key_length = eprosima_fastdds_rtps_core_detail_Time_t_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_detail_Time_t_max_key_cdr_typesize : 16;
                        key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                        memset(key_buffer_, 0, key_length);
                    }

                    Time_tPubSubType::~Time_tPubSubType()
                    {
                        if (key_buffer_ != nullptr)
                        {
                            free(key_buffer_);
                        }
                    }

                    bool Time_tPubSubType::serialize(
                            const void* const data,
                            SerializedPayload_t& payload,
                            DataRepresentationId_t data_representation)
                    {
                        const Time_t* p_type = static_cast<const Time_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                        payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                        ser.set_encoding_flag(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                        try
                        {
                            // Serialize encapsulation
                            ser.serialize_encapsulation();
                            // Serialize the object.
                            ser << *p_type;
                            ser.set_dds_cdr_options({0,0});
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        // Get the serialized length
                        payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                        return true;
                    }

                    bool Time_tPubSubType::deserialize(
                            SerializedPayload_t& payload,
                            void* data)
                    {
                        try
                        {
                            // Convert DATA to pointer of your type
                            Time_t* p_type = static_cast<Time_t*>(data);

                            // Object that manages the raw buffer.
                            eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                            // Object that deserializes the data.
                            eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                            // Deserialize encapsulation.
                            deser.read_encapsulation();
                            payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                            // Deserialize the object.
                            deser >> *p_type;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        return true;
                    }

                    uint32_t Time_tPubSubType::calculate_serialized_size(
                            const void* const data,
                            DataRepresentationId_t data_representation)
                    {
                        try
                        {
                            eprosima::fastcdr::CdrSizeCalculator calculator(
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                            size_t current_alignment {0};
                            return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                        *static_cast<const Time_t*>(data), current_alignment)) +
                                    4u /*encapsulation*/;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return 0;
                        }
                    }

                    void* Time_tPubSubType::create_data()
                    {
                        return reinterpret_cast<void*>(new Time_t());
                    }

                    void Time_tPubSubType::delete_data(
                            void* data)
                    {
                        delete(reinterpret_cast<Time_t*>(data));
                    }

                    bool Time_tPubSubType::compute_key(
                            SerializedPayload_t& payload,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        Time_t data;
                        if (deserialize(payload, static_cast<void*>(&data)))
                        {
                            return compute_key(static_cast<void*>(&data), handle, force_md5);
                        }

                        return false;
                    }

                    bool Time_tPubSubType::compute_key(
                            const void* const data,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        const Time_t* p_type = static_cast<const Time_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                                eprosima_fastdds_rtps_core_detail_Time_t_max_key_cdr_typesize);

                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                        ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                        eprosima::fastcdr::serialize_key(ser, *p_type);
                        if (force_md5 || eprosima_fastdds_rtps_core_detail_Time_t_max_key_cdr_typesize > 16)
                        {
                            md5_.init();
                            md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                            md5_.finalize();
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = md5_.digest[i];
                            }
                        }
                        else
                        {
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = key_buffer_[i];
                            }
                        }
                        return true;
                    }

                    void Time_tPubSubType::register_type_object_representation()
                    {
                        register_Time_t_type_identifier(type_identifiers_);
                    }

                    SequenceNumberSetPubSubType::SequenceNumberSetPubSubType()
                    {
                        set_name("eprosima::fastdds::rtps::core::detail::SequenceNumberSet");
                        uint32_t type_size = eprosima_fastdds_rtps_core_detail_SequenceNumberSet_max_cdr_typesize;
                        type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                        max_serialized_type_size = type_size + 4; /*encapsulation*/
                        is_compute_key_provided = false;
                        uint32_t key_length = eprosima_fastdds_rtps_core_detail_SequenceNumberSet_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_detail_SequenceNumberSet_max_key_cdr_typesize : 16;
                        key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                        memset(key_buffer_, 0, key_length);
                    }

                    SequenceNumberSetPubSubType::~SequenceNumberSetPubSubType()
                    {
                        if (key_buffer_ != nullptr)
                        {
                            free(key_buffer_);
                        }
                    }

                    bool SequenceNumberSetPubSubType::serialize(
                            const void* const data,
                            SerializedPayload_t& payload,
                            DataRepresentationId_t data_representation)
                    {
                        const SequenceNumberSet* p_type = static_cast<const SequenceNumberSet*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                        payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                        ser.set_encoding_flag(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                        try
                        {
                            // Serialize encapsulation
                            ser.serialize_encapsulation();
                            // Serialize the object.
                            ser << *p_type;
                            ser.set_dds_cdr_options({0,0});
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        // Get the serialized length
                        payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                        return true;
                    }

                    bool SequenceNumberSetPubSubType::deserialize(
                            SerializedPayload_t& payload,
                            void* data)
                    {
                        try
                        {
                            // Convert DATA to pointer of your type
                            SequenceNumberSet* p_type = static_cast<SequenceNumberSet*>(data);

                            // Object that manages the raw buffer.
                            eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                            // Object that deserializes the data.
                            eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                            // Deserialize encapsulation.
                            deser.read_encapsulation();
                            payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                            // Deserialize the object.
                            deser >> *p_type;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        return true;
                    }

                    uint32_t SequenceNumberSetPubSubType::calculate_serialized_size(
                            const void* const data,
                            DataRepresentationId_t data_representation)
                    {
                        try
                        {
                            eprosima::fastcdr::CdrSizeCalculator calculator(
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                            size_t current_alignment {0};
                            return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                        *static_cast<const SequenceNumberSet*>(data), current_alignment)) +
                                    4u /*encapsulation*/;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return 0;
                        }
                    }

                    void* SequenceNumberSetPubSubType::create_data()
                    {
                        return reinterpret_cast<void*>(new SequenceNumberSet());
                    }

                    void SequenceNumberSetPubSubType::delete_data(
                            void* data)
                    {
                        delete(reinterpret_cast<SequenceNumberSet*>(data));
                    }

                    bool SequenceNumberSetPubSubType::compute_key(
                            SerializedPayload_t& payload,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        SequenceNumberSet data;
                        if (deserialize(payload, static_cast<void*>(&data)))
                        {
                            return compute_key(static_cast<void*>(&data), handle, force_md5);
                        }

                        return false;
                    }

                    bool SequenceNumberSetPubSubType::compute_key(
                            const void* const data,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        const SequenceNumberSet* p_type = static_cast<const SequenceNumberSet*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                                eprosima_fastdds_rtps_core_detail_SequenceNumberSet_max_key_cdr_typesize);

                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                        ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                        eprosima::fastcdr::serialize_key(ser, *p_type);
                        if (force_md5 || eprosima_fastdds_rtps_core_detail_SequenceNumberSet_max_key_cdr_typesize > 16)
                        {
                            md5_.init();
                            md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                            md5_.finalize();
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = md5_.digest[i];
                            }
                        }
                        else
                        {
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = key_buffer_[i];
                            }
                        }
                        return true;
                    }

                    void SequenceNumberSetPubSubType::register_type_object_representation()
                    {
                        register_SequenceNumberSet_type_identifier(type_identifiers_);
                    }

                    Locator_tPubSubType::Locator_tPubSubType()
                    {
                        set_name("eprosima::fastdds::rtps::core::detail::Locator_t");
                        uint32_t type_size = eprosima_fastdds_rtps_core_detail_Locator_t_max_cdr_typesize;
                        type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                        max_serialized_type_size = type_size + 4; /*encapsulation*/
                        is_compute_key_provided = false;
                        uint32_t key_length = eprosima_fastdds_rtps_core_detail_Locator_t_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_detail_Locator_t_max_key_cdr_typesize : 16;
                        key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                        memset(key_buffer_, 0, key_length);
                    }

                    Locator_tPubSubType::~Locator_tPubSubType()
                    {
                        if (key_buffer_ != nullptr)
                        {
                            free(key_buffer_);
                        }
                    }

                    bool Locator_tPubSubType::serialize(
                            const void* const data,
                            SerializedPayload_t& payload,
                            DataRepresentationId_t data_representation)
                    {
                        const Locator_t* p_type = static_cast<const Locator_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                        payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                        ser.set_encoding_flag(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                        try
                        {
                            // Serialize encapsulation
                            ser.serialize_encapsulation();
                            // Serialize the object.
                            ser << *p_type;
                            ser.set_dds_cdr_options({0,0});
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        // Get the serialized length
                        payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                        return true;
                    }

                    bool Locator_tPubSubType::deserialize(
                            SerializedPayload_t& payload,
                            void* data)
                    {
                        try
                        {
                            // Convert DATA to pointer of your type
                            Locator_t* p_type = static_cast<Locator_t*>(data);

                            // Object that manages the raw buffer.
                            eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                            // Object that deserializes the data.
                            eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                            // Deserialize encapsulation.
                            deser.read_encapsulation();
                            payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                            // Deserialize the object.
                            deser >> *p_type;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        return true;
                    }

                    uint32_t Locator_tPubSubType::calculate_serialized_size(
                            const void* const data,
                            DataRepresentationId_t data_representation)
                    {
                        try
                        {
                            eprosima::fastcdr::CdrSizeCalculator calculator(
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                            size_t current_alignment {0};
                            return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                        *static_cast<const Locator_t*>(data), current_alignment)) +
                                    4u /*encapsulation*/;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return 0;
                        }
                    }

                    void* Locator_tPubSubType::create_data()
                    {
                        return reinterpret_cast<void*>(new Locator_t());
                    }

                    void Locator_tPubSubType::delete_data(
                            void* data)
                    {
                        delete(reinterpret_cast<Locator_t*>(data));
                    }

                    bool Locator_tPubSubType::compute_key(
                            SerializedPayload_t& payload,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        Locator_t data;
                        if (deserialize(payload, static_cast<void*>(&data)))
                        {
                            return compute_key(static_cast<void*>(&data), handle, force_md5);
                        }

                        return false;
                    }

                    bool Locator_tPubSubType::compute_key(
                            const void* const data,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        const Locator_t* p_type = static_cast<const Locator_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                                eprosima_fastdds_rtps_core_detail_Locator_t_max_key_cdr_typesize);

                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                        ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                        eprosima::fastcdr::serialize_key(ser, *p_type);
                        if (force_md5 || eprosima_fastdds_rtps_core_detail_Locator_t_max_key_cdr_typesize > 16)
                        {
                            md5_.init();
                            md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                            md5_.finalize();
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = md5_.digest[i];
                            }
                        }
                        else
                        {
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = key_buffer_[i];
                            }
                        }
                        return true;
                    }

                    void Locator_tPubSubType::register_type_object_representation()
                    {
                        register_Locator_t_type_identifier(type_identifiers_);
                    }

                    Duration_tPubSubType::Duration_tPubSubType()
                    {
                        set_name("eprosima::fastdds::rtps::core::detail::Duration_t");
                        uint32_t type_size = eprosima_fastdds_rtps_core_detail_Duration_t_max_cdr_typesize;
                        type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                        max_serialized_type_size = type_size + 4; /*encapsulation*/
                        is_compute_key_provided = false;
                        uint32_t key_length = eprosima_fastdds_rtps_core_detail_Duration_t_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_detail_Duration_t_max_key_cdr_typesize : 16;
                        key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                        memset(key_buffer_, 0, key_length);
                    }

                    Duration_tPubSubType::~Duration_tPubSubType()
                    {
                        if (key_buffer_ != nullptr)
                        {
                            free(key_buffer_);
                        }
                    }

                    bool Duration_tPubSubType::serialize(
                            const void* const data,
                            SerializedPayload_t& payload,
                            DataRepresentationId_t data_representation)
                    {
                        const Duration_t* p_type = static_cast<const Duration_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                        payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                        ser.set_encoding_flag(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                        try
                        {
                            // Serialize encapsulation
                            ser.serialize_encapsulation();
                            // Serialize the object.
                            ser << *p_type;
                            ser.set_dds_cdr_options({0,0});
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        // Get the serialized length
                        payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                        return true;
                    }

                    bool Duration_tPubSubType::deserialize(
                            SerializedPayload_t& payload,
                            void* data)
                    {
                        try
                        {
                            // Convert DATA to pointer of your type
                            Duration_t* p_type = static_cast<Duration_t*>(data);

                            // Object that manages the raw buffer.
                            eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                            // Object that deserializes the data.
                            eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                            // Deserialize encapsulation.
                            deser.read_encapsulation();
                            payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                            // Deserialize the object.
                            deser >> *p_type;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        return true;
                    }

                    uint32_t Duration_tPubSubType::calculate_serialized_size(
                            const void* const data,
                            DataRepresentationId_t data_representation)
                    {
                        try
                        {
                            eprosima::fastcdr::CdrSizeCalculator calculator(
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                            size_t current_alignment {0};
                            return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                        *static_cast<const Duration_t*>(data), current_alignment)) +
                                    4u /*encapsulation*/;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return 0;
                        }
                    }

                    void* Duration_tPubSubType::create_data()
                    {
                        return reinterpret_cast<void*>(new Duration_t());
                    }

                    void Duration_tPubSubType::delete_data(
                            void* data)
                    {
                        delete(reinterpret_cast<Duration_t*>(data));
                    }

                    bool Duration_tPubSubType::compute_key(
                            SerializedPayload_t& payload,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        Duration_t data;
                        if (deserialize(payload, static_cast<void*>(&data)))
                        {
                            return compute_key(static_cast<void*>(&data), handle, force_md5);
                        }

                        return false;
                    }

                    bool Duration_tPubSubType::compute_key(
                            const void* const data,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        const Duration_t* p_type = static_cast<const Duration_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                                eprosima_fastdds_rtps_core_detail_Duration_t_max_key_cdr_typesize);

                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                        ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                        eprosima::fastcdr::serialize_key(ser, *p_type);
                        if (force_md5 || eprosima_fastdds_rtps_core_detail_Duration_t_max_key_cdr_typesize > 16)
                        {
                            md5_.init();
                            md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                            md5_.finalize();
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = md5_.digest[i];
                            }
                        }
                        else
                        {
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = key_buffer_[i];
                            }
                        }
                        return true;
                    }

                    void Duration_tPubSubType::register_type_object_representation()
                    {
                        register_Duration_t_type_identifier(type_identifiers_);
                    }

                    StatusInfo_tPubSubType::StatusInfo_tPubSubType()
                    {
                        set_name("eprosima::fastdds::rtps::core::detail::StatusInfo_t");
                        uint32_t type_size = eprosima_fastdds_rtps_core_detail_StatusInfo_t_max_cdr_typesize;
                        type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                        max_serialized_type_size = type_size + 4; /*encapsulation*/
                        is_compute_key_provided = false;
                        uint32_t key_length = eprosima_fastdds_rtps_core_detail_StatusInfo_t_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_detail_StatusInfo_t_max_key_cdr_typesize : 16;
                        key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                        memset(key_buffer_, 0, key_length);
                    }

                    StatusInfo_tPubSubType::~StatusInfo_tPubSubType()
                    {
                        if (key_buffer_ != nullptr)
                        {
                            free(key_buffer_);
                        }
                    }

                    bool StatusInfo_tPubSubType::serialize(
                            const void* const data,
                            SerializedPayload_t& payload,
                            DataRepresentationId_t data_representation)
                    {
                        const StatusInfo_t* p_type = static_cast<const StatusInfo_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                        payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                        ser.set_encoding_flag(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                        try
                        {
                            // Serialize encapsulation
                            ser.serialize_encapsulation();
                            // Serialize the object.
                            ser << *p_type;
                            ser.set_dds_cdr_options({0,0});
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        // Get the serialized length
                        payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                        return true;
                    }

                    bool StatusInfo_tPubSubType::deserialize(
                            SerializedPayload_t& payload,
                            void* data)
                    {
                        try
                        {
                            // Convert DATA to pointer of your type
                            StatusInfo_t* p_type = static_cast<StatusInfo_t*>(data);

                            // Object that manages the raw buffer.
                            eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                            // Object that deserializes the data.
                            eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                            // Deserialize encapsulation.
                            deser.read_encapsulation();
                            payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                            // Deserialize the object.
                            deser >> *p_type;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        return true;
                    }

                    uint32_t StatusInfo_tPubSubType::calculate_serialized_size(
                            const void* const data,
                            DataRepresentationId_t data_representation)
                    {
                        try
                        {
                            eprosima::fastcdr::CdrSizeCalculator calculator(
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                            size_t current_alignment {0};
                            return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                        *static_cast<const StatusInfo_t*>(data), current_alignment)) +
                                    4u /*encapsulation*/;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return 0;
                        }
                    }

                    void* StatusInfo_tPubSubType::create_data()
                    {
                        return reinterpret_cast<void*>(new StatusInfo_t());
                    }

                    void StatusInfo_tPubSubType::delete_data(
                            void* data)
                    {
                        delete(reinterpret_cast<StatusInfo_t*>(data));
                    }

                    bool StatusInfo_tPubSubType::compute_key(
                            SerializedPayload_t& payload,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        StatusInfo_t data;
                        if (deserialize(payload, static_cast<void*>(&data)))
                        {
                            return compute_key(static_cast<void*>(&data), handle, force_md5);
                        }

                        return false;
                    }

                    bool StatusInfo_tPubSubType::compute_key(
                            const void* const data,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        const StatusInfo_t* p_type = static_cast<const StatusInfo_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                                eprosima_fastdds_rtps_core_detail_StatusInfo_t_max_key_cdr_typesize);

                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                        ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                        eprosima::fastcdr::serialize_key(ser, *p_type);
                        if (force_md5 || eprosima_fastdds_rtps_core_detail_StatusInfo_t_max_key_cdr_typesize > 16)
                        {
                            md5_.init();
                            md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                            md5_.finalize();
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = md5_.digest[i];
                            }
                        }
                        else
                        {
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = key_buffer_[i];
                            }
                        }
                        return true;
                    }

                    void StatusInfo_tPubSubType::register_type_object_representation()
                    {
                        register_StatusInfo_t_type_identifier(type_identifiers_);
                    }

                    KeyHash_tPubSubType::KeyHash_tPubSubType()
                    {
                        set_name("eprosima::fastdds::rtps::core::detail::KeyHash_t");
                        uint32_t type_size = eprosima_fastdds_rtps_core_detail_KeyHash_t_max_cdr_typesize;
                        type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                        max_serialized_type_size = type_size + 4; /*encapsulation*/
                        is_compute_key_provided = false;
                        uint32_t key_length = eprosima_fastdds_rtps_core_detail_KeyHash_t_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_detail_KeyHash_t_max_key_cdr_typesize : 16;
                        key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                        memset(key_buffer_, 0, key_length);
                    }

                    KeyHash_tPubSubType::~KeyHash_tPubSubType()
                    {
                        if (key_buffer_ != nullptr)
                        {
                            free(key_buffer_);
                        }
                    }

                    bool KeyHash_tPubSubType::serialize(
                            const void* const data,
                            SerializedPayload_t& payload,
                            DataRepresentationId_t data_representation)
                    {
                        const KeyHash_t* p_type = static_cast<const KeyHash_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                        payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                        ser.set_encoding_flag(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                        try
                        {
                            // Serialize encapsulation
                            ser.serialize_encapsulation();
                            // Serialize the object.
                            ser << *p_type;
                            ser.set_dds_cdr_options({0,0});
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        // Get the serialized length
                        payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                        return true;
                    }

                    bool KeyHash_tPubSubType::deserialize(
                            SerializedPayload_t& payload,
                            void* data)
                    {
                        try
                        {
                            // Convert DATA to pointer of your type
                            KeyHash_t* p_type = static_cast<KeyHash_t*>(data);

                            // Object that manages the raw buffer.
                            eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                            // Object that deserializes the data.
                            eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                            // Deserialize encapsulation.
                            deser.read_encapsulation();
                            payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                            // Deserialize the object.
                            deser >> *p_type;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        return true;
                    }

                    uint32_t KeyHash_tPubSubType::calculate_serialized_size(
                            const void* const data,
                            DataRepresentationId_t data_representation)
                    {
                        try
                        {
                            eprosima::fastcdr::CdrSizeCalculator calculator(
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                            size_t current_alignment {0};
                            return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                        *static_cast<const KeyHash_t*>(data), current_alignment)) +
                                    4u /*encapsulation*/;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return 0;
                        }
                    }

                    void* KeyHash_tPubSubType::create_data()
                    {
                        return reinterpret_cast<void*>(new KeyHash_t());
                    }

                    void KeyHash_tPubSubType::delete_data(
                            void* data)
                    {
                        delete(reinterpret_cast<KeyHash_t*>(data));
                    }

                    bool KeyHash_tPubSubType::compute_key(
                            SerializedPayload_t& payload,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        KeyHash_t data;
                        if (deserialize(payload, static_cast<void*>(&data)))
                        {
                            return compute_key(static_cast<void*>(&data), handle, force_md5);
                        }

                        return false;
                    }

                    bool KeyHash_tPubSubType::compute_key(
                            const void* const data,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        const KeyHash_t* p_type = static_cast<const KeyHash_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                                eprosima_fastdds_rtps_core_detail_KeyHash_t_max_key_cdr_typesize);

                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                        ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                        eprosima::fastcdr::serialize_key(ser, *p_type);
                        if (force_md5 || eprosima_fastdds_rtps_core_detail_KeyHash_t_max_key_cdr_typesize > 16)
                        {
                            md5_.init();
                            md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                            md5_.finalize();
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = md5_.digest[i];
                            }
                        }
                        else
                        {
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = key_buffer_[i];
                            }
                        }
                        return true;
                    }

                    void KeyHash_tPubSubType::register_type_object_representation()
                    {
                        register_KeyHash_t_type_identifier(type_identifiers_);
                    }

                    EntityName_tPubSubType::EntityName_tPubSubType()
                    {
                        set_name("eprosima::fastdds::rtps::core::detail::EntityName_t");
                        uint32_t type_size = eprosima_fastdds_rtps_core_detail_EntityName_t_max_cdr_typesize;
                        type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                        max_serialized_type_size = type_size + 4; /*encapsulation*/
                        is_compute_key_provided = false;
                        uint32_t key_length = eprosima_fastdds_rtps_core_detail_EntityName_t_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_detail_EntityName_t_max_key_cdr_typesize : 16;
                        key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                        memset(key_buffer_, 0, key_length);
                    }

                    EntityName_tPubSubType::~EntityName_tPubSubType()
                    {
                        if (key_buffer_ != nullptr)
                        {
                            free(key_buffer_);
                        }
                    }

                    bool EntityName_tPubSubType::serialize(
                            const void* const data,
                            SerializedPayload_t& payload,
                            DataRepresentationId_t data_representation)
                    {
                        const EntityName_t* p_type = static_cast<const EntityName_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                        payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                        ser.set_encoding_flag(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                        try
                        {
                            // Serialize encapsulation
                            ser.serialize_encapsulation();
                            // Serialize the object.
                            ser << *p_type;
                            ser.set_dds_cdr_options({0,0});
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        // Get the serialized length
                        payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                        return true;
                    }

                    bool EntityName_tPubSubType::deserialize(
                            SerializedPayload_t& payload,
                            void* data)
                    {
                        try
                        {
                            // Convert DATA to pointer of your type
                            EntityName_t* p_type = static_cast<EntityName_t*>(data);

                            // Object that manages the raw buffer.
                            eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                            // Object that deserializes the data.
                            eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                            // Deserialize encapsulation.
                            deser.read_encapsulation();
                            payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                            // Deserialize the object.
                            deser >> *p_type;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return false;
                        }

                        return true;
                    }

                    uint32_t EntityName_tPubSubType::calculate_serialized_size(
                            const void* const data,
                            DataRepresentationId_t data_representation)
                    {
                        try
                        {
                            eprosima::fastcdr::CdrSizeCalculator calculator(
                                data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                                eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                            size_t current_alignment {0};
                            return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                        *static_cast<const EntityName_t*>(data), current_alignment)) +
                                    4u /*encapsulation*/;
                        }
                        catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                        {
                            return 0;
                        }
                    }

                    void* EntityName_tPubSubType::create_data()
                    {
                        return reinterpret_cast<void*>(new EntityName_t());
                    }

                    void EntityName_tPubSubType::delete_data(
                            void* data)
                    {
                        delete(reinterpret_cast<EntityName_t*>(data));
                    }

                    bool EntityName_tPubSubType::compute_key(
                            SerializedPayload_t& payload,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        EntityName_t data;
                        if (deserialize(payload, static_cast<void*>(&data)))
                        {
                            return compute_key(static_cast<void*>(&data), handle, force_md5);
                        }

                        return false;
                    }

                    bool EntityName_tPubSubType::compute_key(
                            const void* const data,
                            InstanceHandle_t& handle,
                            bool force_md5)
                    {
                        if (!is_compute_key_provided)
                        {
                            return false;
                        }

                        const EntityName_t* p_type = static_cast<const EntityName_t*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                                eprosima_fastdds_rtps_core_detail_EntityName_t_max_key_cdr_typesize);

                        // Object that serializes the data.
                        eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                        ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                        eprosima::fastcdr::serialize_key(ser, *p_type);
                        if (force_md5 || eprosima_fastdds_rtps_core_detail_EntityName_t_max_key_cdr_typesize > 16)
                        {
                            md5_.init();
                            md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                            md5_.finalize();
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = md5_.digest[i];
                            }
                        }
                        else
                        {
                            for (uint8_t i = 0; i < 16; ++i)
                            {
                                handle.value[i] = key_buffer_[i];
                            }
                        }
                        return true;
                    }

                    void EntityName_tPubSubType::register_type_object_representation()
                    {
                        register_EntityName_t_type_identifier(type_identifiers_);
                    }

                } // namespace detail

                HeaderPubSubType::HeaderPubSubType()
                {
                    set_name("eprosima::fastdds::rtps::core::Header");
                    uint32_t type_size = eprosima_fastdds_rtps_core_Header_max_cdr_typesize;
                    type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                    max_serialized_type_size = type_size + 4; /*encapsulation*/
                    is_compute_key_provided = false;
                    uint32_t key_length = eprosima_fastdds_rtps_core_Header_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_Header_max_key_cdr_typesize : 16;
                    key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                    memset(key_buffer_, 0, key_length);
                }

                HeaderPubSubType::~HeaderPubSubType()
                {
                    if (key_buffer_ != nullptr)
                    {
                        free(key_buffer_);
                    }
                }

                bool HeaderPubSubType::serialize(
                        const void* const data,
                        SerializedPayload_t& payload,
                        DataRepresentationId_t data_representation)
                {
                    const Header* p_type = static_cast<const Header*>(data);

                    // Object that manages the raw buffer.
                    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                    // Object that serializes the data.
                    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                    payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                    ser.set_encoding_flag(
                        data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                        eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                        eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                    try
                    {
                        // Serialize encapsulation
                        ser.serialize_encapsulation();
                        // Serialize the object.
                        ser << *p_type;
                        ser.set_dds_cdr_options({0,0});
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return false;
                    }

                    // Get the serialized length
                    payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                    return true;
                }

                bool HeaderPubSubType::deserialize(
                        SerializedPayload_t& payload,
                        void* data)
                {
                    try
                    {
                        // Convert DATA to pointer of your type
                        Header* p_type = static_cast<Header*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                        // Object that deserializes the data.
                        eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                        // Deserialize encapsulation.
                        deser.read_encapsulation();
                        payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                        // Deserialize the object.
                        deser >> *p_type;
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return false;
                    }

                    return true;
                }

                uint32_t HeaderPubSubType::calculate_serialized_size(
                        const void* const data,
                        DataRepresentationId_t data_representation)
                {
                    try
                    {
                        eprosima::fastcdr::CdrSizeCalculator calculator(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                        size_t current_alignment {0};
                        return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                    *static_cast<const Header*>(data), current_alignment)) +
                                4u /*encapsulation*/;
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return 0;
                    }
                }

                void* HeaderPubSubType::create_data()
                {
                    return reinterpret_cast<void*>(new Header());
                }

                void HeaderPubSubType::delete_data(
                        void* data)
                {
                    delete(reinterpret_cast<Header*>(data));
                }

                bool HeaderPubSubType::compute_key(
                        SerializedPayload_t& payload,
                        InstanceHandle_t& handle,
                        bool force_md5)
                {
                    if (!is_compute_key_provided)
                    {
                        return false;
                    }

                    Header data;
                    if (deserialize(payload, static_cast<void*>(&data)))
                    {
                        return compute_key(static_cast<void*>(&data), handle, force_md5);
                    }

                    return false;
                }

                bool HeaderPubSubType::compute_key(
                        const void* const data,
                        InstanceHandle_t& handle,
                        bool force_md5)
                {
                    if (!is_compute_key_provided)
                    {
                        return false;
                    }

                    const Header* p_type = static_cast<const Header*>(data);

                    // Object that manages the raw buffer.
                    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                            eprosima_fastdds_rtps_core_Header_max_key_cdr_typesize);

                    // Object that serializes the data.
                    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                    ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                    eprosima::fastcdr::serialize_key(ser, *p_type);
                    if (force_md5 || eprosima_fastdds_rtps_core_Header_max_key_cdr_typesize > 16)
                    {
                        md5_.init();
                        md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                        md5_.finalize();
                        for (uint8_t i = 0; i < 16; ++i)
                        {
                            handle.value[i] = md5_.digest[i];
                        }
                    }
                    else
                    {
                        for (uint8_t i = 0; i < 16; ++i)
                        {
                            handle.value[i] = key_buffer_[i];
                        }
                    }
                    return true;
                }

                void HeaderPubSubType::register_type_object_representation()
                {
                    register_Header_type_identifier(type_identifiers_);
                }

                SubmessageHeaderPubSubType::SubmessageHeaderPubSubType()
                {
                    set_name("eprosima::fastdds::rtps::core::SubmessageHeader");
                    uint32_t type_size = eprosima_fastdds_rtps_core_SubmessageHeader_max_cdr_typesize;
                    type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                    max_serialized_type_size = type_size + 4; /*encapsulation*/
                    is_compute_key_provided = false;
                    uint32_t key_length = eprosima_fastdds_rtps_core_SubmessageHeader_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_SubmessageHeader_max_key_cdr_typesize : 16;
                    key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                    memset(key_buffer_, 0, key_length);
                }

                SubmessageHeaderPubSubType::~SubmessageHeaderPubSubType()
                {
                    if (key_buffer_ != nullptr)
                    {
                        free(key_buffer_);
                    }
                }

                bool SubmessageHeaderPubSubType::serialize(
                        const void* const data,
                        SerializedPayload_t& payload,
                        DataRepresentationId_t data_representation)
                {
                    const SubmessageHeader* p_type = static_cast<const SubmessageHeader*>(data);

                    // Object that manages the raw buffer.
                    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                    // Object that serializes the data.
                    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                    payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                    ser.set_encoding_flag(
                        data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                        eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                        eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                    try
                    {
                        // Serialize encapsulation
                        ser.serialize_encapsulation();
                        // Serialize the object.
                        ser << *p_type;
                        ser.set_dds_cdr_options({0,0});
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return false;
                    }

                    // Get the serialized length
                    payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                    return true;
                }

                bool SubmessageHeaderPubSubType::deserialize(
                        SerializedPayload_t& payload,
                        void* data)
                {
                    try
                    {
                        // Convert DATA to pointer of your type
                        SubmessageHeader* p_type = static_cast<SubmessageHeader*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                        // Object that deserializes the data.
                        eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                        // Deserialize encapsulation.
                        deser.read_encapsulation();
                        payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                        // Deserialize the object.
                        deser >> *p_type;
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return false;
                    }

                    return true;
                }

                uint32_t SubmessageHeaderPubSubType::calculate_serialized_size(
                        const void* const data,
                        DataRepresentationId_t data_representation)
                {
                    try
                    {
                        eprosima::fastcdr::CdrSizeCalculator calculator(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                        size_t current_alignment {0};
                        return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                    *static_cast<const SubmessageHeader*>(data), current_alignment)) +
                                4u /*encapsulation*/;
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return 0;
                    }
                }

                void* SubmessageHeaderPubSubType::create_data()
                {
                    return reinterpret_cast<void*>(new SubmessageHeader());
                }

                void SubmessageHeaderPubSubType::delete_data(
                        void* data)
                {
                    delete(reinterpret_cast<SubmessageHeader*>(data));
                }

                bool SubmessageHeaderPubSubType::compute_key(
                        SerializedPayload_t& payload,
                        InstanceHandle_t& handle,
                        bool force_md5)
                {
                    if (!is_compute_key_provided)
                    {
                        return false;
                    }

                    SubmessageHeader data;
                    if (deserialize(payload, static_cast<void*>(&data)))
                    {
                        return compute_key(static_cast<void*>(&data), handle, force_md5);
                    }

                    return false;
                }

                bool SubmessageHeaderPubSubType::compute_key(
                        const void* const data,
                        InstanceHandle_t& handle,
                        bool force_md5)
                {
                    if (!is_compute_key_provided)
                    {
                        return false;
                    }

                    const SubmessageHeader* p_type = static_cast<const SubmessageHeader*>(data);

                    // Object that manages the raw buffer.
                    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                            eprosima_fastdds_rtps_core_SubmessageHeader_max_key_cdr_typesize);

                    // Object that serializes the data.
                    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                    ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                    eprosima::fastcdr::serialize_key(ser, *p_type);
                    if (force_md5 || eprosima_fastdds_rtps_core_SubmessageHeader_max_key_cdr_typesize > 16)
                    {
                        md5_.init();
                        md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                        md5_.finalize();
                        for (uint8_t i = 0; i < 16; ++i)
                        {
                            handle.value[i] = md5_.digest[i];
                        }
                    }
                    else
                    {
                        for (uint8_t i = 0; i < 16; ++i)
                        {
                            handle.value[i] = key_buffer_[i];
                        }
                    }
                    return true;
                }

                void SubmessageHeaderPubSubType::register_type_object_representation()
                {
                    register_SubmessageHeader_type_identifier(type_identifiers_);
                }

                namespace SubmessageKind {
                } // namespace SubmessageKind

                AckNackSubmessagePubSubType::AckNackSubmessagePubSubType()
                {
                    set_name("eprosima::fastdds::rtps::core::AckNackSubmessage");
                    uint32_t type_size = eprosima_fastdds_rtps_core_AckNackSubmessage_max_cdr_typesize;
                    type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                    max_serialized_type_size = type_size + 4; /*encapsulation*/
                    is_compute_key_provided = false;
                    uint32_t key_length = eprosima_fastdds_rtps_core_AckNackSubmessage_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_AckNackSubmessage_max_key_cdr_typesize : 16;
                    key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                    memset(key_buffer_, 0, key_length);
                }

                AckNackSubmessagePubSubType::~AckNackSubmessagePubSubType()
                {
                    if (key_buffer_ != nullptr)
                    {
                        free(key_buffer_);
                    }
                }

                bool AckNackSubmessagePubSubType::serialize(
                        const void* const data,
                        SerializedPayload_t& payload,
                        DataRepresentationId_t data_representation)
                {
                    const AckNackSubmessage* p_type = static_cast<const AckNackSubmessage*>(data);

                    // Object that manages the raw buffer.
                    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                    // Object that serializes the data.
                    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                    payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                    ser.set_encoding_flag(
                        data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                        eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                        eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                    try
                    {
                        // Serialize encapsulation
                        ser.serialize_encapsulation();
                        // Serialize the object.
                        ser << *p_type;
                        ser.set_dds_cdr_options({0,0});
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return false;
                    }

                    // Get the serialized length
                    payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                    return true;
                }

                bool AckNackSubmessagePubSubType::deserialize(
                        SerializedPayload_t& payload,
                        void* data)
                {
                    try
                    {
                        // Convert DATA to pointer of your type
                        AckNackSubmessage* p_type = static_cast<AckNackSubmessage*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                        // Object that deserializes the data.
                        eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                        // Deserialize encapsulation.
                        deser.read_encapsulation();
                        payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                        // Deserialize the object.
                        deser >> *p_type;
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return false;
                    }

                    return true;
                }

                uint32_t AckNackSubmessagePubSubType::calculate_serialized_size(
                        const void* const data,
                        DataRepresentationId_t data_representation)
                {
                    try
                    {
                        eprosima::fastcdr::CdrSizeCalculator calculator(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                        size_t current_alignment {0};
                        return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                    *static_cast<const AckNackSubmessage*>(data), current_alignment)) +
                                4u /*encapsulation*/;
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return 0;
                    }
                }

                void* AckNackSubmessagePubSubType::create_data()
                {
                    return reinterpret_cast<void*>(new AckNackSubmessage());
                }

                void AckNackSubmessagePubSubType::delete_data(
                        void* data)
                {
                    delete(reinterpret_cast<AckNackSubmessage*>(data));
                }

                bool AckNackSubmessagePubSubType::compute_key(
                        SerializedPayload_t& payload,
                        InstanceHandle_t& handle,
                        bool force_md5)
                {
                    if (!is_compute_key_provided)
                    {
                        return false;
                    }

                    AckNackSubmessage data;
                    if (deserialize(payload, static_cast<void*>(&data)))
                    {
                        return compute_key(static_cast<void*>(&data), handle, force_md5);
                    }

                    return false;
                }

                bool AckNackSubmessagePubSubType::compute_key(
                        const void* const data,
                        InstanceHandle_t& handle,
                        bool force_md5)
                {
                    if (!is_compute_key_provided)
                    {
                        return false;
                    }

                    const AckNackSubmessage* p_type = static_cast<const AckNackSubmessage*>(data);

                    // Object that manages the raw buffer.
                    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                            eprosima_fastdds_rtps_core_AckNackSubmessage_max_key_cdr_typesize);

                    // Object that serializes the data.
                    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                    ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                    eprosima::fastcdr::serialize_key(ser, *p_type);
                    if (force_md5 || eprosima_fastdds_rtps_core_AckNackSubmessage_max_key_cdr_typesize > 16)
                    {
                        md5_.init();
                        md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                        md5_.finalize();
                        for (uint8_t i = 0; i < 16; ++i)
                        {
                            handle.value[i] = md5_.digest[i];
                        }
                    }
                    else
                    {
                        for (uint8_t i = 0; i < 16; ++i)
                        {
                            handle.value[i] = key_buffer_[i];
                        }
                    }
                    return true;
                }

                void AckNackSubmessagePubSubType::register_type_object_representation()
                {
                    register_AckNackSubmessage_type_identifier(type_identifiers_);
                }

                HeartBeatSubmessagePubSubType::HeartBeatSubmessagePubSubType()
                {
                    set_name("eprosima::fastdds::rtps::core::HeartBeatSubmessage");
                    uint32_t type_size = eprosima_fastdds_rtps_core_HeartBeatSubmessage_max_cdr_typesize;
                    type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                    max_serialized_type_size = type_size + 4; /*encapsulation*/
                    is_compute_key_provided = false;
                    uint32_t key_length = eprosima_fastdds_rtps_core_HeartBeatSubmessage_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_HeartBeatSubmessage_max_key_cdr_typesize : 16;
                    key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                    memset(key_buffer_, 0, key_length);
                }

                HeartBeatSubmessagePubSubType::~HeartBeatSubmessagePubSubType()
                {
                    if (key_buffer_ != nullptr)
                    {
                        free(key_buffer_);
                    }
                }

                bool HeartBeatSubmessagePubSubType::serialize(
                        const void* const data,
                        SerializedPayload_t& payload,
                        DataRepresentationId_t data_representation)
                {
                    const HeartBeatSubmessage* p_type = static_cast<const HeartBeatSubmessage*>(data);

                    // Object that manages the raw buffer.
                    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                    // Object that serializes the data.
                    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                    payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                    ser.set_encoding_flag(
                        data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                        eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                        eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                    try
                    {
                        // Serialize encapsulation
                        ser.serialize_encapsulation();
                        // Serialize the object.
                        ser << *p_type;
                        ser.set_dds_cdr_options({0,0});
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return false;
                    }

                    // Get the serialized length
                    payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                    return true;
                }

                bool HeartBeatSubmessagePubSubType::deserialize(
                        SerializedPayload_t& payload,
                        void* data)
                {
                    try
                    {
                        // Convert DATA to pointer of your type
                        HeartBeatSubmessage* p_type = static_cast<HeartBeatSubmessage*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                        // Object that deserializes the data.
                        eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                        // Deserialize encapsulation.
                        deser.read_encapsulation();
                        payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                        // Deserialize the object.
                        deser >> *p_type;
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return false;
                    }

                    return true;
                }

                uint32_t HeartBeatSubmessagePubSubType::calculate_serialized_size(
                        const void* const data,
                        DataRepresentationId_t data_representation)
                {
                    try
                    {
                        eprosima::fastcdr::CdrSizeCalculator calculator(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                        size_t current_alignment {0};
                        return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                    *static_cast<const HeartBeatSubmessage*>(data), current_alignment)) +
                                4u /*encapsulation*/;
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return 0;
                    }
                }

                void* HeartBeatSubmessagePubSubType::create_data()
                {
                    return reinterpret_cast<void*>(new HeartBeatSubmessage());
                }

                void HeartBeatSubmessagePubSubType::delete_data(
                        void* data)
                {
                    delete(reinterpret_cast<HeartBeatSubmessage*>(data));
                }

                bool HeartBeatSubmessagePubSubType::compute_key(
                        SerializedPayload_t& payload,
                        InstanceHandle_t& handle,
                        bool force_md5)
                {
                    if (!is_compute_key_provided)
                    {
                        return false;
                    }

                    HeartBeatSubmessage data;
                    if (deserialize(payload, static_cast<void*>(&data)))
                    {
                        return compute_key(static_cast<void*>(&data), handle, force_md5);
                    }

                    return false;
                }

                bool HeartBeatSubmessagePubSubType::compute_key(
                        const void* const data,
                        InstanceHandle_t& handle,
                        bool force_md5)
                {
                    if (!is_compute_key_provided)
                    {
                        return false;
                    }

                    const HeartBeatSubmessage* p_type = static_cast<const HeartBeatSubmessage*>(data);

                    // Object that manages the raw buffer.
                    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                            eprosima_fastdds_rtps_core_HeartBeatSubmessage_max_key_cdr_typesize);

                    // Object that serializes the data.
                    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                    ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                    eprosima::fastcdr::serialize_key(ser, *p_type);
                    if (force_md5 || eprosima_fastdds_rtps_core_HeartBeatSubmessage_max_key_cdr_typesize > 16)
                    {
                        md5_.init();
                        md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                        md5_.finalize();
                        for (uint8_t i = 0; i < 16; ++i)
                        {
                            handle.value[i] = md5_.digest[i];
                        }
                    }
                    else
                    {
                        for (uint8_t i = 0; i < 16; ++i)
                        {
                            handle.value[i] = key_buffer_[i];
                        }
                    }
                    return true;
                }

                void HeartBeatSubmessagePubSubType::register_type_object_representation()
                {
                    register_HeartBeatSubmessage_type_identifier(type_identifiers_);
                }

                InfoDestinationSubmessagePubSubType::InfoDestinationSubmessagePubSubType()
                {
                    set_name("eprosima::fastdds::rtps::core::InfoDestinationSubmessage");
                    uint32_t type_size = eprosima_fastdds_rtps_core_InfoDestinationSubmessage_max_cdr_typesize;
                    type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                    max_serialized_type_size = type_size + 4; /*encapsulation*/
                    is_compute_key_provided = false;
                    uint32_t key_length = eprosima_fastdds_rtps_core_InfoDestinationSubmessage_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_InfoDestinationSubmessage_max_key_cdr_typesize : 16;
                    key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                    memset(key_buffer_, 0, key_length);
                }

                InfoDestinationSubmessagePubSubType::~InfoDestinationSubmessagePubSubType()
                {
                    if (key_buffer_ != nullptr)
                    {
                        free(key_buffer_);
                    }
                }

                bool InfoDestinationSubmessagePubSubType::serialize(
                        const void* const data,
                        SerializedPayload_t& payload,
                        DataRepresentationId_t data_representation)
                {
                    const InfoDestinationSubmessage* p_type = static_cast<const InfoDestinationSubmessage*>(data);

                    // Object that manages the raw buffer.
                    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                    // Object that serializes the data.
                    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                    payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                    ser.set_encoding_flag(
                        data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                        eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                        eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                    try
                    {
                        // Serialize encapsulation
                        ser.serialize_encapsulation();
                        // Serialize the object.
                        ser << *p_type;
                        ser.set_dds_cdr_options({0,0});
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return false;
                    }

                    // Get the serialized length
                    payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                    return true;
                }

                bool InfoDestinationSubmessagePubSubType::deserialize(
                        SerializedPayload_t& payload,
                        void* data)
                {
                    try
                    {
                        // Convert DATA to pointer of your type
                        InfoDestinationSubmessage* p_type = static_cast<InfoDestinationSubmessage*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                        // Object that deserializes the data.
                        eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                        // Deserialize encapsulation.
                        deser.read_encapsulation();
                        payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                        // Deserialize the object.
                        deser >> *p_type;
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return false;
                    }

                    return true;
                }

                uint32_t InfoDestinationSubmessagePubSubType::calculate_serialized_size(
                        const void* const data,
                        DataRepresentationId_t data_representation)
                {
                    try
                    {
                        eprosima::fastcdr::CdrSizeCalculator calculator(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                        size_t current_alignment {0};
                        return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                    *static_cast<const InfoDestinationSubmessage*>(data), current_alignment)) +
                                4u /*encapsulation*/;
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return 0;
                    }
                }

                void* InfoDestinationSubmessagePubSubType::create_data()
                {
                    return reinterpret_cast<void*>(new InfoDestinationSubmessage());
                }

                void InfoDestinationSubmessagePubSubType::delete_data(
                        void* data)
                {
                    delete(reinterpret_cast<InfoDestinationSubmessage*>(data));
                }

                bool InfoDestinationSubmessagePubSubType::compute_key(
                        SerializedPayload_t& payload,
                        InstanceHandle_t& handle,
                        bool force_md5)
                {
                    if (!is_compute_key_provided)
                    {
                        return false;
                    }

                    InfoDestinationSubmessage data;
                    if (deserialize(payload, static_cast<void*>(&data)))
                    {
                        return compute_key(static_cast<void*>(&data), handle, force_md5);
                    }

                    return false;
                }

                bool InfoDestinationSubmessagePubSubType::compute_key(
                        const void* const data,
                        InstanceHandle_t& handle,
                        bool force_md5)
                {
                    if (!is_compute_key_provided)
                    {
                        return false;
                    }

                    const InfoDestinationSubmessage* p_type = static_cast<const InfoDestinationSubmessage*>(data);

                    // Object that manages the raw buffer.
                    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                            eprosima_fastdds_rtps_core_InfoDestinationSubmessage_max_key_cdr_typesize);

                    // Object that serializes the data.
                    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                    ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                    eprosima::fastcdr::serialize_key(ser, *p_type);
                    if (force_md5 || eprosima_fastdds_rtps_core_InfoDestinationSubmessage_max_key_cdr_typesize > 16)
                    {
                        md5_.init();
                        md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                        md5_.finalize();
                        for (uint8_t i = 0; i < 16; ++i)
                        {
                            handle.value[i] = md5_.digest[i];
                        }
                    }
                    else
                    {
                        for (uint8_t i = 0; i < 16; ++i)
                        {
                            handle.value[i] = key_buffer_[i];
                        }
                    }
                    return true;
                }

                void InfoDestinationSubmessagePubSubType::register_type_object_representation()
                {
                    register_InfoDestinationSubmessage_type_identifier(type_identifiers_);
                }

                InfoSourceSubmessagePubSubType::InfoSourceSubmessagePubSubType()
                {
                    set_name("eprosima::fastdds::rtps::core::InfoSourceSubmessage");
                    uint32_t type_size = eprosima_fastdds_rtps_core_InfoSourceSubmessage_max_cdr_typesize;
                    type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                    max_serialized_type_size = type_size + 4; /*encapsulation*/
                    is_compute_key_provided = false;
                    uint32_t key_length = eprosima_fastdds_rtps_core_InfoSourceSubmessage_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_InfoSourceSubmessage_max_key_cdr_typesize : 16;
                    key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                    memset(key_buffer_, 0, key_length);
                }

                InfoSourceSubmessagePubSubType::~InfoSourceSubmessagePubSubType()
                {
                    if (key_buffer_ != nullptr)
                    {
                        free(key_buffer_);
                    }
                }

                bool InfoSourceSubmessagePubSubType::serialize(
                        const void* const data,
                        SerializedPayload_t& payload,
                        DataRepresentationId_t data_representation)
                {
                    const InfoSourceSubmessage* p_type = static_cast<const InfoSourceSubmessage*>(data);

                    // Object that manages the raw buffer.
                    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                    // Object that serializes the data.
                    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                    payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                    ser.set_encoding_flag(
                        data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                        eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                        eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                    try
                    {
                        // Serialize encapsulation
                        ser.serialize_encapsulation();
                        // Serialize the object.
                        ser << *p_type;
                        ser.set_dds_cdr_options({0,0});
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return false;
                    }

                    // Get the serialized length
                    payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                    return true;
                }

                bool InfoSourceSubmessagePubSubType::deserialize(
                        SerializedPayload_t& payload,
                        void* data)
                {
                    try
                    {
                        // Convert DATA to pointer of your type
                        InfoSourceSubmessage* p_type = static_cast<InfoSourceSubmessage*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                        // Object that deserializes the data.
                        eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                        // Deserialize encapsulation.
                        deser.read_encapsulation();
                        payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                        // Deserialize the object.
                        deser >> *p_type;
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return false;
                    }

                    return true;
                }

                uint32_t InfoSourceSubmessagePubSubType::calculate_serialized_size(
                        const void* const data,
                        DataRepresentationId_t data_representation)
                {
                    try
                    {
                        eprosima::fastcdr::CdrSizeCalculator calculator(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                        size_t current_alignment {0};
                        return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                    *static_cast<const InfoSourceSubmessage*>(data), current_alignment)) +
                                4u /*encapsulation*/;
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return 0;
                    }
                }

                void* InfoSourceSubmessagePubSubType::create_data()
                {
                    return reinterpret_cast<void*>(new InfoSourceSubmessage());
                }

                void InfoSourceSubmessagePubSubType::delete_data(
                        void* data)
                {
                    delete(reinterpret_cast<InfoSourceSubmessage*>(data));
                }

                bool InfoSourceSubmessagePubSubType::compute_key(
                        SerializedPayload_t& payload,
                        InstanceHandle_t& handle,
                        bool force_md5)
                {
                    if (!is_compute_key_provided)
                    {
                        return false;
                    }

                    InfoSourceSubmessage data;
                    if (deserialize(payload, static_cast<void*>(&data)))
                    {
                        return compute_key(static_cast<void*>(&data), handle, force_md5);
                    }

                    return false;
                }

                bool InfoSourceSubmessagePubSubType::compute_key(
                        const void* const data,
                        InstanceHandle_t& handle,
                        bool force_md5)
                {
                    if (!is_compute_key_provided)
                    {
                        return false;
                    }

                    const InfoSourceSubmessage* p_type = static_cast<const InfoSourceSubmessage*>(data);

                    // Object that manages the raw buffer.
                    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                            eprosima_fastdds_rtps_core_InfoSourceSubmessage_max_key_cdr_typesize);

                    // Object that serializes the data.
                    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                    ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                    eprosima::fastcdr::serialize_key(ser, *p_type);
                    if (force_md5 || eprosima_fastdds_rtps_core_InfoSourceSubmessage_max_key_cdr_typesize > 16)
                    {
                        md5_.init();
                        md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                        md5_.finalize();
                        for (uint8_t i = 0; i < 16; ++i)
                        {
                            handle.value[i] = md5_.digest[i];
                        }
                    }
                    else
                    {
                        for (uint8_t i = 0; i < 16; ++i)
                        {
                            handle.value[i] = key_buffer_[i];
                        }
                    }
                    return true;
                }

                void InfoSourceSubmessagePubSubType::register_type_object_representation()
                {
                    register_InfoSourceSubmessage_type_identifier(type_identifiers_);
                }

                InfoTimestampSubmessagePubSubType::InfoTimestampSubmessagePubSubType()
                {
                    set_name("eprosima::fastdds::rtps::core::InfoTimestampSubmessage");
                    uint32_t type_size = eprosima_fastdds_rtps_core_InfoTimestampSubmessage_max_cdr_typesize;
                    type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                    max_serialized_type_size = type_size + 4; /*encapsulation*/
                    is_compute_key_provided = false;
                    uint32_t key_length = eprosima_fastdds_rtps_core_InfoTimestampSubmessage_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_InfoTimestampSubmessage_max_key_cdr_typesize : 16;
                    key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                    memset(key_buffer_, 0, key_length);
                }

                InfoTimestampSubmessagePubSubType::~InfoTimestampSubmessagePubSubType()
                {
                    if (key_buffer_ != nullptr)
                    {
                        free(key_buffer_);
                    }
                }

                bool InfoTimestampSubmessagePubSubType::serialize(
                        const void* const data,
                        SerializedPayload_t& payload,
                        DataRepresentationId_t data_representation)
                {
                    const InfoTimestampSubmessage* p_type = static_cast<const InfoTimestampSubmessage*>(data);

                    // Object that manages the raw buffer.
                    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                    // Object that serializes the data.
                    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                    payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                    ser.set_encoding_flag(
                        data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                        eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                        eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                    try
                    {
                        // Serialize encapsulation
                        ser.serialize_encapsulation();
                        // Serialize the object.
                        ser << *p_type;
                        ser.set_dds_cdr_options({0,0});
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return false;
                    }

                    // Get the serialized length
                    payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                    return true;
                }

                bool InfoTimestampSubmessagePubSubType::deserialize(
                        SerializedPayload_t& payload,
                        void* data)
                {
                    try
                    {
                        // Convert DATA to pointer of your type
                        InfoTimestampSubmessage* p_type = static_cast<InfoTimestampSubmessage*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                        // Object that deserializes the data.
                        eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                        // Deserialize encapsulation.
                        deser.read_encapsulation();
                        payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                        // Deserialize the object.
                        deser >> *p_type;
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return false;
                    }

                    return true;
                }

                uint32_t InfoTimestampSubmessagePubSubType::calculate_serialized_size(
                        const void* const data,
                        DataRepresentationId_t data_representation)
                {
                    try
                    {
                        eprosima::fastcdr::CdrSizeCalculator calculator(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                        size_t current_alignment {0};
                        return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                    *static_cast<const InfoTimestampSubmessage*>(data), current_alignment)) +
                                4u /*encapsulation*/;
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return 0;
                    }
                }

                void* InfoTimestampSubmessagePubSubType::create_data()
                {
                    return reinterpret_cast<void*>(new InfoTimestampSubmessage());
                }

                void InfoTimestampSubmessagePubSubType::delete_data(
                        void* data)
                {
                    delete(reinterpret_cast<InfoTimestampSubmessage*>(data));
                }

                bool InfoTimestampSubmessagePubSubType::compute_key(
                        SerializedPayload_t& payload,
                        InstanceHandle_t& handle,
                        bool force_md5)
                {
                    if (!is_compute_key_provided)
                    {
                        return false;
                    }

                    InfoTimestampSubmessage data;
                    if (deserialize(payload, static_cast<void*>(&data)))
                    {
                        return compute_key(static_cast<void*>(&data), handle, force_md5);
                    }

                    return false;
                }

                bool InfoTimestampSubmessagePubSubType::compute_key(
                        const void* const data,
                        InstanceHandle_t& handle,
                        bool force_md5)
                {
                    if (!is_compute_key_provided)
                    {
                        return false;
                    }

                    const InfoTimestampSubmessage* p_type = static_cast<const InfoTimestampSubmessage*>(data);

                    // Object that manages the raw buffer.
                    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                            eprosima_fastdds_rtps_core_InfoTimestampSubmessage_max_key_cdr_typesize);

                    // Object that serializes the data.
                    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                    ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                    eprosima::fastcdr::serialize_key(ser, *p_type);
                    if (force_md5 || eprosima_fastdds_rtps_core_InfoTimestampSubmessage_max_key_cdr_typesize > 16)
                    {
                        md5_.init();
                        md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                        md5_.finalize();
                        for (uint8_t i = 0; i < 16; ++i)
                        {
                            handle.value[i] = md5_.digest[i];
                        }
                    }
                    else
                    {
                        for (uint8_t i = 0; i < 16; ++i)
                        {
                            handle.value[i] = key_buffer_[i];
                        }
                    }
                    return true;
                }

                void InfoTimestampSubmessagePubSubType::register_type_object_representation()
                {
                    register_InfoTimestampSubmessage_type_identifier(type_identifiers_);
                }

                RTPSMessagePubSubType::RTPSMessagePubSubType()
                {
                    set_name("eprosima::fastdds::rtps::core::RTPSMessage");
                    uint32_t type_size = eprosima_fastdds_rtps_core_RTPSMessage_max_cdr_typesize;
                    type_size += static_cast<uint32_t>(eprosima::fastcdr::Cdr::alignment(type_size, 4)); /* possible submessage alignment */
                    max_serialized_type_size = type_size + 4; /*encapsulation*/
                    is_compute_key_provided = false;
                    uint32_t key_length = eprosima_fastdds_rtps_core_RTPSMessage_max_key_cdr_typesize > 16 ? eprosima_fastdds_rtps_core_RTPSMessage_max_key_cdr_typesize : 16;
                    key_buffer_ = reinterpret_cast<unsigned char*>(malloc(key_length));
                    memset(key_buffer_, 0, key_length);
                }

                RTPSMessagePubSubType::~RTPSMessagePubSubType()
                {
                    if (key_buffer_ != nullptr)
                    {
                        free(key_buffer_);
                    }
                }

                bool RTPSMessagePubSubType::serialize(
                        const void* const data,
                        SerializedPayload_t& payload,
                        DataRepresentationId_t data_representation)
                {
                    const RTPSMessage* p_type = static_cast<const RTPSMessage*>(data);

                    // Object that manages the raw buffer.
                    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.max_size);
                    // Object that serializes the data.
                    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN,
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::CdrVersion::XCDRv1 : eprosima::fastcdr::CdrVersion::XCDRv2);
                    payload.encapsulation = ser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;
                    ser.set_encoding_flag(
                        data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                        eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR  :
                        eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2);

                    try
                    {
                        // Serialize encapsulation
                        ser.serialize_encapsulation();
                        // Serialize the object.
                        ser << *p_type;
                        ser.set_dds_cdr_options({0,0});
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return false;
                    }

                    // Get the serialized length
                    payload.length = static_cast<uint32_t>(ser.get_serialized_data_length());
                    return true;
                }

                bool RTPSMessagePubSubType::deserialize(
                        SerializedPayload_t& payload,
                        void* data)
                {
                    try
                    {
                        // Convert DATA to pointer of your type
                        RTPSMessage* p_type = static_cast<RTPSMessage*>(data);

                        // Object that manages the raw buffer.
                        eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(payload.data), payload.length);

                        // Object that deserializes the data.
                        eprosima::fastcdr::Cdr deser(fastbuffer, eprosima::fastcdr::Cdr::DEFAULT_ENDIAN);

                        // Deserialize encapsulation.
                        deser.read_encapsulation();
                        payload.encapsulation = deser.endianness() == eprosima::fastcdr::Cdr::BIG_ENDIANNESS ? CDR_BE : CDR_LE;

                        // Deserialize the object.
                        deser >> *p_type;
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return false;
                    }

                    return true;
                }

                uint32_t RTPSMessagePubSubType::calculate_serialized_size(
                        const void* const data,
                        DataRepresentationId_t data_representation)
                {
                    try
                    {
                        eprosima::fastcdr::CdrSizeCalculator calculator(
                            data_representation == DataRepresentationId_t::XCDR_DATA_REPRESENTATION ?
                            eprosima::fastcdr::CdrVersion::XCDRv1 :eprosima::fastcdr::CdrVersion::XCDRv2);
                        size_t current_alignment {0};
                        return static_cast<uint32_t>(calculator.calculate_serialized_size(
                                    *static_cast<const RTPSMessage*>(data), current_alignment)) +
                                4u /*encapsulation*/;
                    }
                    catch (eprosima::fastcdr::exception::Exception& /*exception*/)
                    {
                        return 0;
                    }
                }

                void* RTPSMessagePubSubType::create_data()
                {
                    return reinterpret_cast<void*>(new RTPSMessage());
                }

                void RTPSMessagePubSubType::delete_data(
                        void* data)
                {
                    delete(reinterpret_cast<RTPSMessage*>(data));
                }

                bool RTPSMessagePubSubType::compute_key(
                        SerializedPayload_t& payload,
                        InstanceHandle_t& handle,
                        bool force_md5)
                {
                    if (!is_compute_key_provided)
                    {
                        return false;
                    }

                    RTPSMessage data;
                    if (deserialize(payload, static_cast<void*>(&data)))
                    {
                        return compute_key(static_cast<void*>(&data), handle, force_md5);
                    }

                    return false;
                }

                bool RTPSMessagePubSubType::compute_key(
                        const void* const data,
                        InstanceHandle_t& handle,
                        bool force_md5)
                {
                    if (!is_compute_key_provided)
                    {
                        return false;
                    }

                    const RTPSMessage* p_type = static_cast<const RTPSMessage*>(data);

                    // Object that manages the raw buffer.
                    eprosima::fastcdr::FastBuffer fastbuffer(reinterpret_cast<char*>(key_buffer_),
                            eprosima_fastdds_rtps_core_RTPSMessage_max_key_cdr_typesize);

                    // Object that serializes the data.
                    eprosima::fastcdr::Cdr ser(fastbuffer, eprosima::fastcdr::Cdr::BIG_ENDIANNESS, eprosima::fastcdr::CdrVersion::XCDRv2);
                    ser.set_encoding_flag(eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR2);
                    eprosima::fastcdr::serialize_key(ser, *p_type);
                    if (force_md5 || eprosima_fastdds_rtps_core_RTPSMessage_max_key_cdr_typesize > 16)
                    {
                        md5_.init();
                        md5_.update(key_buffer_, static_cast<unsigned int>(ser.get_serialized_data_length()));
                        md5_.finalize();
                        for (uint8_t i = 0; i < 16; ++i)
                        {
                            handle.value[i] = md5_.digest[i];
                        }
                    }
                    else
                    {
                        for (uint8_t i = 0; i < 16; ++i)
                        {
                            handle.value[i] = key_buffer_[i];
                        }
                    }
                    return true;
                }

                void RTPSMessagePubSubType::register_type_object_representation()
                {
                    register_RTPSMessage_type_identifier(type_identifiers_);
                }

            } // namespace core

        } // namespace rtps

    } // namespace fastdds

} // namespace eprosima


// Include auxiliary functions like for serializing/deserializing.
#include "core_typesCdrAux.ipp"
