/*
    Copyright (C) 2008, 2009 William Hart
    Copyright (C) 2010 Fredrik Johansson

    This file is part of FLINT.

    FLINT is free software: you can redistribute it and/or modify it under
    the terms of the GNU Lesser General Public License (LGPL) as published
    by the Free Software Foundation; either version 2.1 of the License, or
    (at your option) any later version.  See <https://www.gnu.org/licenses/>.
*/

#include "fmpz_factor.h"
#include "fmpz_vec.h"

void
fmpz_factor_clear(fmpz_factor_t factor)
{
    _fmpz_vec_clear(factor->p, factor->alloc);
    flint_free(factor->exp);
}
