//
// metadata.proto - File which contains all of the metadata structures which we
// write to metadata files. Must be compiled with protoc to use the library.
// Compilation can be invoked with go generate.
//
// Copyright 2017 Google Inc.
// Author: Joe Richey (joerichey@google.com)
//
// Licensed under the Apache License, Version 2.0 (the "License"); you may not
// use this file except in compliance with the License. You may obtain a copy of
// the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
// WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
// License for the specific language governing permissions and limitations under
// the License.

// If the *.proto file is modified, be sure to run "make gen" (at the project
// root) to recreate the *.pb.go file.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v3.6.1
// source: metadata/metadata.proto

package metadata

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies the method in which an outside secret is obtained for a Protector
type SourceType int32

const (
	SourceType_default           SourceType = 0
	SourceType_pam_passphrase    SourceType = 1
	SourceType_custom_passphrase SourceType = 2
	SourceType_raw_key           SourceType = 3
)

// Enum value maps for SourceType.
var (
	SourceType_name = map[int32]string{
		0: "default",
		1: "pam_passphrase",
		2: "custom_passphrase",
		3: "raw_key",
	}
	SourceType_value = map[string]int32{
		"default":           0,
		"pam_passphrase":    1,
		"custom_passphrase": 2,
		"raw_key":           3,
	}
)

func (x SourceType) Enum() *SourceType {
	p := new(SourceType)
	*p = x
	return p
}

func (x SourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_metadata_metadata_proto_enumTypes[0].Descriptor()
}

func (SourceType) Type() protoreflect.EnumType {
	return &file_metadata_metadata_proto_enumTypes[0]
}

func (x SourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SourceType.Descriptor instead.
func (SourceType) EnumDescriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{0}
}

// Type of encryption; should match declarations of unix.FSCRYPT_MODE
type EncryptionOptions_Mode int32

const (
	EncryptionOptions_default       EncryptionOptions_Mode = 0
	EncryptionOptions_AES_256_XTS   EncryptionOptions_Mode = 1
	EncryptionOptions_AES_256_GCM   EncryptionOptions_Mode = 2
	EncryptionOptions_AES_256_CBC   EncryptionOptions_Mode = 3
	EncryptionOptions_AES_256_CTS   EncryptionOptions_Mode = 4
	EncryptionOptions_AES_128_CBC   EncryptionOptions_Mode = 5
	EncryptionOptions_AES_128_CTS   EncryptionOptions_Mode = 6
	EncryptionOptions_Adiantum      EncryptionOptions_Mode = 9
	EncryptionOptions_AES_256_HCTR2 EncryptionOptions_Mode = 10
)

// Enum value maps for EncryptionOptions_Mode.
var (
	EncryptionOptions_Mode_name = map[int32]string{
		0:  "default",
		1:  "AES_256_XTS",
		2:  "AES_256_GCM",
		3:  "AES_256_CBC",
		4:  "AES_256_CTS",
		5:  "AES_128_CBC",
		6:  "AES_128_CTS",
		9:  "Adiantum",
		10: "AES_256_HCTR2",
	}
	EncryptionOptions_Mode_value = map[string]int32{
		"default":       0,
		"AES_256_XTS":   1,
		"AES_256_GCM":   2,
		"AES_256_CBC":   3,
		"AES_256_CTS":   4,
		"AES_128_CBC":   5,
		"AES_128_CTS":   6,
		"Adiantum":      9,
		"AES_256_HCTR2": 10,
	}
)

func (x EncryptionOptions_Mode) Enum() *EncryptionOptions_Mode {
	p := new(EncryptionOptions_Mode)
	*p = x
	return p
}

func (x EncryptionOptions_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EncryptionOptions_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_metadata_metadata_proto_enumTypes[1].Descriptor()
}

func (EncryptionOptions_Mode) Type() protoreflect.EnumType {
	return &file_metadata_metadata_proto_enumTypes[1]
}

func (x EncryptionOptions_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EncryptionOptions_Mode.Descriptor instead.
func (EncryptionOptions_Mode) EnumDescriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{3, 0}
}

// Cost parameters to be used in our hashing functions.
type HashingCosts struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Time        int64 `protobuf:"varint,2,opt,name=time,proto3" json:"time,omitempty"`
	Memory      int64 `protobuf:"varint,3,opt,name=memory,proto3" json:"memory,omitempty"`
	Parallelism int64 `protobuf:"varint,4,opt,name=parallelism,proto3" json:"parallelism,omitempty"`
	// If true, parallelism should no longer be truncated to 8 bits.
	TruncationFixed bool `protobuf:"varint,5,opt,name=truncation_fixed,json=truncationFixed,proto3" json:"truncation_fixed,omitempty"`
}

func (x *HashingCosts) Reset() {
	*x = HashingCosts{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metadata_metadata_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HashingCosts) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HashingCosts) ProtoMessage() {}

func (x *HashingCosts) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HashingCosts.ProtoReflect.Descriptor instead.
func (*HashingCosts) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{0}
}

func (x *HashingCosts) GetTime() int64 {
	if x != nil {
		return x.Time
	}
	return 0
}

func (x *HashingCosts) GetMemory() int64 {
	if x != nil {
		return x.Memory
	}
	return 0
}

func (x *HashingCosts) GetParallelism() int64 {
	if x != nil {
		return x.Parallelism
	}
	return 0
}

func (x *HashingCosts) GetTruncationFixed() bool {
	if x != nil {
		return x.TruncationFixed
	}
	return false
}

// This structure is used for our authenticated wrapping/unwrapping of keys.
type WrappedKeyData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	IV           []byte `protobuf:"bytes,1,opt,name=IV,proto3" json:"IV,omitempty"`
	EncryptedKey []byte `protobuf:"bytes,2,opt,name=encrypted_key,json=encryptedKey,proto3" json:"encrypted_key,omitempty"`
	Hmac         []byte `protobuf:"bytes,3,opt,name=hmac,proto3" json:"hmac,omitempty"`
}

func (x *WrappedKeyData) Reset() {
	*x = WrappedKeyData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metadata_metadata_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WrappedKeyData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WrappedKeyData) ProtoMessage() {}

func (x *WrappedKeyData) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WrappedKeyData.ProtoReflect.Descriptor instead.
func (*WrappedKeyData) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{1}
}

func (x *WrappedKeyData) GetIV() []byte {
	if x != nil {
		return x.IV
	}
	return nil
}

func (x *WrappedKeyData) GetEncryptedKey() []byte {
	if x != nil {
		return x.EncryptedKey
	}
	return nil
}

func (x *WrappedKeyData) GetHmac() []byte {
	if x != nil {
		return x.Hmac
	}
	return nil
}

// The associated data for each protector
type ProtectorData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ProtectorDescriptor string     `protobuf:"bytes,1,opt,name=protector_descriptor,json=protectorDescriptor,proto3" json:"protector_descriptor,omitempty"`
	Source              SourceType `protobuf:"varint,2,opt,name=source,proto3,enum=metadata.SourceType" json:"source,omitempty"`
	// These are only used by some of the protector types
	Name       string          `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	Costs      *HashingCosts   `protobuf:"bytes,4,opt,name=costs,proto3" json:"costs,omitempty"`
	Salt       []byte          `protobuf:"bytes,5,opt,name=salt,proto3" json:"salt,omitempty"`
	Uid        int64           `protobuf:"varint,6,opt,name=uid,proto3" json:"uid,omitempty"`
	WrappedKey *WrappedKeyData `protobuf:"bytes,7,opt,name=wrapped_key,json=wrappedKey,proto3" json:"wrapped_key,omitempty"`
}

func (x *ProtectorData) Reset() {
	*x = ProtectorData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metadata_metadata_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProtectorData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProtectorData) ProtoMessage() {}

func (x *ProtectorData) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProtectorData.ProtoReflect.Descriptor instead.
func (*ProtectorData) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{2}
}

func (x *ProtectorData) GetProtectorDescriptor() string {
	if x != nil {
		return x.ProtectorDescriptor
	}
	return ""
}

func (x *ProtectorData) GetSource() SourceType {
	if x != nil {
		return x.Source
	}
	return SourceType_default
}

func (x *ProtectorData) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ProtectorData) GetCosts() *HashingCosts {
	if x != nil {
		return x.Costs
	}
	return nil
}

func (x *ProtectorData) GetSalt() []byte {
	if x != nil {
		return x.Salt
	}
	return nil
}

func (x *ProtectorData) GetUid() int64 {
	if x != nil {
		return x.Uid
	}
	return 0
}

func (x *ProtectorData) GetWrappedKey() *WrappedKeyData {
	if x != nil {
		return x.WrappedKey
	}
	return nil
}

// Encryption policy specifics, corresponds to the fscrypt_policy struct
type EncryptionOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Padding       int64                  `protobuf:"varint,1,opt,name=padding,proto3" json:"padding,omitempty"`
	Contents      EncryptionOptions_Mode `protobuf:"varint,2,opt,name=contents,proto3,enum=metadata.EncryptionOptions_Mode" json:"contents,omitempty"`
	Filenames     EncryptionOptions_Mode `protobuf:"varint,3,opt,name=filenames,proto3,enum=metadata.EncryptionOptions_Mode" json:"filenames,omitempty"`
	PolicyVersion int64                  `protobuf:"varint,4,opt,name=policy_version,json=policyVersion,proto3" json:"policy_version,omitempty"`
}

func (x *EncryptionOptions) Reset() {
	*x = EncryptionOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metadata_metadata_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EncryptionOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncryptionOptions) ProtoMessage() {}

func (x *EncryptionOptions) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncryptionOptions.ProtoReflect.Descriptor instead.
func (*EncryptionOptions) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{3}
}

func (x *EncryptionOptions) GetPadding() int64 {
	if x != nil {
		return x.Padding
	}
	return 0
}

func (x *EncryptionOptions) GetContents() EncryptionOptions_Mode {
	if x != nil {
		return x.Contents
	}
	return EncryptionOptions_default
}

func (x *EncryptionOptions) GetFilenames() EncryptionOptions_Mode {
	if x != nil {
		return x.Filenames
	}
	return EncryptionOptions_default
}

func (x *EncryptionOptions) GetPolicyVersion() int64 {
	if x != nil {
		return x.PolicyVersion
	}
	return 0
}

type WrappedPolicyKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ProtectorDescriptor string          `protobuf:"bytes,1,opt,name=protector_descriptor,json=protectorDescriptor,proto3" json:"protector_descriptor,omitempty"`
	WrappedKey          *WrappedKeyData `protobuf:"bytes,2,opt,name=wrapped_key,json=wrappedKey,proto3" json:"wrapped_key,omitempty"`
}

func (x *WrappedPolicyKey) Reset() {
	*x = WrappedPolicyKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metadata_metadata_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WrappedPolicyKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WrappedPolicyKey) ProtoMessage() {}

func (x *WrappedPolicyKey) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WrappedPolicyKey.ProtoReflect.Descriptor instead.
func (*WrappedPolicyKey) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{4}
}

func (x *WrappedPolicyKey) GetProtectorDescriptor() string {
	if x != nil {
		return x.ProtectorDescriptor
	}
	return ""
}

func (x *WrappedPolicyKey) GetWrappedKey() *WrappedKeyData {
	if x != nil {
		return x.WrappedKey
	}
	return nil
}

// The associated data for each policy
type PolicyData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	KeyDescriptor     string              `protobuf:"bytes,1,opt,name=key_descriptor,json=keyDescriptor,proto3" json:"key_descriptor,omitempty"`
	Options           *EncryptionOptions  `protobuf:"bytes,2,opt,name=options,proto3" json:"options,omitempty"`
	WrappedPolicyKeys []*WrappedPolicyKey `protobuf:"bytes,3,rep,name=wrapped_policy_keys,json=wrappedPolicyKeys,proto3" json:"wrapped_policy_keys,omitempty"`
}

func (x *PolicyData) Reset() {
	*x = PolicyData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metadata_metadata_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyData) ProtoMessage() {}

func (x *PolicyData) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyData.ProtoReflect.Descriptor instead.
func (*PolicyData) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{5}
}

func (x *PolicyData) GetKeyDescriptor() string {
	if x != nil {
		return x.KeyDescriptor
	}
	return ""
}

func (x *PolicyData) GetOptions() *EncryptionOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *PolicyData) GetWrappedPolicyKeys() []*WrappedPolicyKey {
	if x != nil {
		return x.WrappedPolicyKeys
	}
	return nil
}

// Data stored in the config file
type Config struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Source                    SourceType         `protobuf:"varint,1,opt,name=source,proto3,enum=metadata.SourceType" json:"source,omitempty"`
	HashCosts                 *HashingCosts      `protobuf:"bytes,2,opt,name=hash_costs,json=hashCosts,proto3" json:"hash_costs,omitempty"`
	Options                   *EncryptionOptions `protobuf:"bytes,4,opt,name=options,proto3" json:"options,omitempty"`
	UseFsKeyringForV1Policies bool               `protobuf:"varint,5,opt,name=use_fs_keyring_for_v1_policies,json=useFsKeyringForV1Policies,proto3" json:"use_fs_keyring_for_v1_policies,omitempty"`
	AllowCrossUserMetadata    bool               `protobuf:"varint,6,opt,name=allow_cross_user_metadata,json=allowCrossUserMetadata,proto3" json:"allow_cross_user_metadata,omitempty"`
}

func (x *Config) Reset() {
	*x = Config{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metadata_metadata_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Config) ProtoMessage() {}

func (x *Config) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Config.ProtoReflect.Descriptor instead.
func (*Config) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{6}
}

func (x *Config) GetSource() SourceType {
	if x != nil {
		return x.Source
	}
	return SourceType_default
}

func (x *Config) GetHashCosts() *HashingCosts {
	if x != nil {
		return x.HashCosts
	}
	return nil
}

func (x *Config) GetOptions() *EncryptionOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *Config) GetUseFsKeyringForV1Policies() bool {
	if x != nil {
		return x.UseFsKeyringForV1Policies
	}
	return false
}

func (x *Config) GetAllowCrossUserMetadata() bool {
	if x != nil {
		return x.AllowCrossUserMetadata
	}
	return false
}

var File_metadata_metadata_proto protoreflect.FileDescriptor

var file_metadata_metadata_proto_rawDesc = []byte{
	0x0a, 0x17, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x22, 0x87, 0x01, 0x0a, 0x0c, 0x48, 0x61, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x73, 0x74, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x65, 0x6d, 0x6f,
	0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79,
	0x12, 0x20, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x69, 0x73, 0x6d, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x69,
	0x73, 0x6d, 0x12, 0x29, 0x0a, 0x10, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x66, 0x69, 0x78, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x74, 0x72,
	0x75, 0x6e, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x78, 0x65, 0x64, 0x22, 0x59, 0x0a,
	0x0e, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x44, 0x61, 0x74, 0x61, 0x12,
	0x0e, 0x0a, 0x02, 0x49, 0x56, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x02, 0x49, 0x56, 0x12,
	0x23, 0x0a, 0x0d, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0c, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65,
	0x64, 0x4b, 0x65, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x6d, 0x61, 0x63, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x04, 0x68, 0x6d, 0x61, 0x63, 0x22, 0x93, 0x02, 0x0a, 0x0d, 0x50, 0x72, 0x6f,
	0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x44, 0x61, 0x74, 0x61, 0x12, 0x31, 0x0a, 0x14, 0x70, 0x72,
	0x6f, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x2c, 0x0a,
	0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x14, 0x2e,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x2c, 0x0a, 0x05, 0x63, 0x6f, 0x73, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x73, 0x74, 0x73, 0x52, 0x05, 0x63, 0x6f, 0x73, 0x74, 0x73, 0x12, 0x12, 0x0a,
	0x04, 0x73, 0x61, 0x6c, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x73, 0x61, 0x6c,
	0x74, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03,
	0x75, 0x69, 0x64, 0x12, 0x39, 0x0a, 0x0b, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x6b,
	0x65, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x0a, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x22, 0xef,
	0x02, 0x0a, 0x11, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x3c,
	0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x20, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4d, 0x6f,
	0x64, 0x65, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3e, 0x0a, 0x09,
	0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x20, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4d, 0x6f, 0x64,
	0x65, 0x52, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x22, 0x9a, 0x01, 0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x0b, 0x0a, 0x07,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x45, 0x53,
	0x5f, 0x32, 0x35, 0x36, 0x5f, 0x58, 0x54, 0x53, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x45,
	0x53, 0x5f, 0x32, 0x35, 0x36, 0x5f, 0x47, 0x43, 0x4d, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x41,
	0x45, 0x53, 0x5f, 0x32, 0x35, 0x36, 0x5f, 0x43, 0x42, 0x43, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b,
	0x41, 0x45, 0x53, 0x5f, 0x32, 0x35, 0x36, 0x5f, 0x43, 0x54, 0x53, 0x10, 0x04, 0x12, 0x0f, 0x0a,
	0x0b, 0x41, 0x45, 0x53, 0x5f, 0x31, 0x32, 0x38, 0x5f, 0x43, 0x42, 0x43, 0x10, 0x05, 0x12, 0x0f,
	0x0a, 0x0b, 0x41, 0x45, 0x53, 0x5f, 0x31, 0x32, 0x38, 0x5f, 0x43, 0x54, 0x53, 0x10, 0x06, 0x12,
	0x0c, 0x0a, 0x08, 0x41, 0x64, 0x69, 0x61, 0x6e, 0x74, 0x75, 0x6d, 0x10, 0x09, 0x12, 0x11, 0x0a,
	0x0d, 0x41, 0x45, 0x53, 0x5f, 0x32, 0x35, 0x36, 0x5f, 0x48, 0x43, 0x54, 0x52, 0x32, 0x10, 0x0a,
	0x22, 0x80, 0x01, 0x0a, 0x10, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x4b, 0x65, 0x79, 0x12, 0x31, 0x0a, 0x14, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x13, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x44, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x39, 0x0a, 0x0b, 0x77, 0x72, 0x61, 0x70,
	0x70, 0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64,
	0x4b, 0x65, 0x79, 0x44, 0x61, 0x74, 0x61, 0x52, 0x0a, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64,
	0x4b, 0x65, 0x79, 0x22, 0xb6, 0x01, 0x0a, 0x0a, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x61,
	0x74, 0x61, 0x12, 0x25, 0x0a, 0x0e, 0x6b, 0x65, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6b, 0x65, 0x79, 0x44,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x35, 0x0a, 0x07, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x4a, 0x0a, 0x13, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b, 0x65, 0x79, 0x52, 0x11, 0x77, 0x72, 0x61, 0x70, 0x70,
	0x65, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4b, 0x65, 0x79, 0x73, 0x22, 0xb7, 0x02, 0x0a,
	0x06, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x14, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x06, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x35, 0x0a, 0x0a, 0x68, 0x61, 0x73, 0x68, 0x5f, 0x63, 0x6f,
	0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x73, 0x74,
	0x73, 0x52, 0x09, 0x68, 0x61, 0x73, 0x68, 0x43, 0x6f, 0x73, 0x74, 0x73, 0x12, 0x35, 0x0a, 0x07,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x41, 0x0a, 0x1e, 0x75, 0x73, 0x65, 0x5f, 0x66, 0x73, 0x5f, 0x6b, 0x65,
	0x79, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x6f, 0x72, 0x5f, 0x76, 0x31, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x75, 0x73, 0x65,
	0x46, 0x73, 0x4b, 0x65, 0x79, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x6f, 0x72, 0x56, 0x31, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x39, 0x0a, 0x19, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f,
	0x63, 0x72, 0x6f, 0x73, 0x73, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x43, 0x72, 0x6f, 0x73, 0x73, 0x55, 0x73, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2a, 0x51, 0x0a, 0x0a, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x10,
	0x00, 0x12, 0x12, 0x0a, 0x0e, 0x70, 0x61, 0x6d, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x70, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07,
	0x72, 0x61, 0x77, 0x5f, 0x6b, 0x65, 0x79, 0x10, 0x03, 0x42, 0x24, 0x5a, 0x22, 0x67, 0x69, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x66,
	0x73, 0x63, 0x72, 0x79, 0x70, 0x74, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_metadata_metadata_proto_rawDescOnce sync.Once
	file_metadata_metadata_proto_rawDescData = file_metadata_metadata_proto_rawDesc
)

func file_metadata_metadata_proto_rawDescGZIP() []byte {
	file_metadata_metadata_proto_rawDescOnce.Do(func() {
		file_metadata_metadata_proto_rawDescData = protoimpl.X.CompressGZIP(file_metadata_metadata_proto_rawDescData)
	})
	return file_metadata_metadata_proto_rawDescData
}

var file_metadata_metadata_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_metadata_metadata_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_metadata_metadata_proto_goTypes = []interface{}{
	(SourceType)(0),             // 0: metadata.SourceType
	(EncryptionOptions_Mode)(0), // 1: metadata.EncryptionOptions.Mode
	(*HashingCosts)(nil),        // 2: metadata.HashingCosts
	(*WrappedKeyData)(nil),      // 3: metadata.WrappedKeyData
	(*ProtectorData)(nil),       // 4: metadata.ProtectorData
	(*EncryptionOptions)(nil),   // 5: metadata.EncryptionOptions
	(*WrappedPolicyKey)(nil),    // 6: metadata.WrappedPolicyKey
	(*PolicyData)(nil),          // 7: metadata.PolicyData
	(*Config)(nil),              // 8: metadata.Config
}
var file_metadata_metadata_proto_depIdxs = []int32{
	0,  // 0: metadata.ProtectorData.source:type_name -> metadata.SourceType
	2,  // 1: metadata.ProtectorData.costs:type_name -> metadata.HashingCosts
	3,  // 2: metadata.ProtectorData.wrapped_key:type_name -> metadata.WrappedKeyData
	1,  // 3: metadata.EncryptionOptions.contents:type_name -> metadata.EncryptionOptions.Mode
	1,  // 4: metadata.EncryptionOptions.filenames:type_name -> metadata.EncryptionOptions.Mode
	3,  // 5: metadata.WrappedPolicyKey.wrapped_key:type_name -> metadata.WrappedKeyData
	5,  // 6: metadata.PolicyData.options:type_name -> metadata.EncryptionOptions
	6,  // 7: metadata.PolicyData.wrapped_policy_keys:type_name -> metadata.WrappedPolicyKey
	0,  // 8: metadata.Config.source:type_name -> metadata.SourceType
	2,  // 9: metadata.Config.hash_costs:type_name -> metadata.HashingCosts
	5,  // 10: metadata.Config.options:type_name -> metadata.EncryptionOptions
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_metadata_metadata_proto_init() }
func file_metadata_metadata_proto_init() {
	if File_metadata_metadata_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_metadata_metadata_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HashingCosts); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metadata_metadata_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WrappedKeyData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metadata_metadata_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProtectorData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metadata_metadata_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EncryptionOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metadata_metadata_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WrappedPolicyKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metadata_metadata_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metadata_metadata_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Config); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_metadata_metadata_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_metadata_metadata_proto_goTypes,
		DependencyIndexes: file_metadata_metadata_proto_depIdxs,
		EnumInfos:         file_metadata_metadata_proto_enumTypes,
		MessageInfos:      file_metadata_metadata_proto_msgTypes,
	}.Build()
	File_metadata_metadata_proto = out.File
	file_metadata_metadata_proto_rawDesc = nil
	file_metadata_metadata_proto_goTypes = nil
	file_metadata_metadata_proto_depIdxs = nil
}
