<!--- https://www.eclipse.org/security/ --->
_ISO 27005 defines vulnerability as:
 "A weakness of an asset or group of assets that can be exploited by one or more threats."_

## The Eclipse Security Team

The Eclipse Security Team provides help and advice to Eclipse projects
on vulnerability issues and is the first point of contact
for handling security vulnerabilities.
Members of the Security Team are committers on Eclipse Projects
and members of the Eclipse Architecture Council.

Contact the [Eclipse Security Team](mailto:security@eclipse.org).

**Note that, as a matter of policy, the security team does not open attachments.**

## Reporting a Security Vulnerability

Vulnerabilities can be reported either via email to the Eclipse Security Team
or directly with a project via the Eclipse Foundation's Bugzilla instance.

The general security mailing list address is security@eclipse.org.
Members of the Eclipse Security Team will receive messages sent to this address.
This address should be used only for reporting undisclosed vulnerabilities;
regular issue reports and questions unrelated to vulnerabilities in Eclipse software
will be ignored.
Note that this email address is not encrypted.

The community is also encouraged to report vulnerabilities using the
[Eclipse Foundation's Bugzilla instance](https://bugs.eclipse.org/bugs/enter_bug.cgi?product=Community&component=Vulnerability%20Reports&keywords=security&groups=Security_Advisories).
Note that you will require an Eclipse Foundation account to create an issue report,
but by doing so you will be able to participate directly in the resolution of the issue.

Issue reports related to vulnerabilities must be marked as "committers-only",
either automatically by clicking the provided link, by the reporter,
or by a committer during the triage process.
Note that issues marked "committers-only" are visible to all Eclipse committers.
By default, a "committers-only" issue is also accessible to the reporter
and individuals explicitly indicated in the "cc" list.

## Disclosure

Disclosure is initially limited to the reporter and all Eclipse Committers,
but is expanded to include other individuals, and the general public.
The timing and manner of disclosure is governed by the
[Eclipse Security Policy](https://www.eclipse.org/security/policy.php).

Publicly disclosed issues are listed on the
[Disclosed Vulnerabilities Page](https://www.eclipse.org/security/known.php).