/** @file mainpage.h
* @brief Definition of class Template
*
*/
/** @mainpage libaudiomask - Simultaneous audio mask threshold estimation library
*
* @authors Dr Matt R. Flax <flatmax\@>
*
* \image html masking.example.jpg
* \image latex masking.example.eps "Example Threshold"
*
* @section docs Academic
*
* This code also implements the roex auditory filters.
*
* Please read the article located on the debian file system file:///usr/shar/doc/libaudiomask-1.0/Flax.2000.Improved.Auditory.Masking.Models.pdf
* 
* It may also be found on the web http://www.assta.org/sst/SST-00/cache/SST-00-Chapter9-p2.pdf
* @section intro Introduction
* This example shows how to use Dr M.R. Flax's (2000) hybrid
* simultaneous audio masking class to find the masking threshold of a time domain signal.
* 
* The compilation of this file is demonstrated in Makefile.
* Run this file : ./AudioMaskerExample
* View the results of this file using www.octave.org by running the script view.m
* - simply type view once octave has started and you are in the suitable directory.
* 
* The input audio should be stored in the file INPUTFILENAME in text format - each sample seperated by a white space.
* 
* ========================= HOWTO ===============================
* \code
*     // First find the masking threshold
*     AudioMasker masker(sampleFreq, count); // Create the audio masker class using fs=sampleFreq and count filters
*     masker.excite(input, sampleCount); // find the mask for the array of input data which has sampleCount time samples.
* 
*     // Now do something with the masking threshold ...
* 
*     // The frequency domain mask is now located here
*     for (int j=0; j<count;j++)
*         masker.mask[j]; // This is the mask at each of the count frequencies of interest
* 
*     // A more sophisticated example - find the threshold for each Fourier bin
*     double fact=(double)sampleFreq/((double)sampleCount-1.0); // convert from an index to the equivalent * Fourier bin frequency
*     for (int j=0; j<halfSampleCount;j++){
*         cout<<"finding for freq "<<j*fact<<'\t'; // The frequency we are inspecting
*         double threshold=masker.findThreshold(j*fact); // The masking threshold
*         20*log10(threshold); // The threshold in decibels (dB)
*     }
* \endcode
*/


