with GNATCOLL.JSON; use GNATCOLL.JSON;
procedure JSON_UTF8 is
   V : JSON_Value;
begin

   --------------
   -- MB29-017 --
   --------------

   --  Unicode codepoint outside of signed short integer range

   V := Read ("""\ua726"""); --  U+A726 LATIN CAPITAL LETTER HENG

   --  Verify UTF-8 encoded value

   if Get (V) /= Character'Val (16#ea#)
               & Character'Val (16#9c#)
               & Character'Val (16#a6#)
   then
      raise Program_Error with "incorrect UTF-8 encoded value";
   end if;

   --------------
   -- N108-033 --
   --------------

   --  Incorrect encoding for U+0080

   V := Create (Character'Val (16#C2#) & Character'Val (16#80#));
   if Write (V) /= """\u0080""" then
      raise Program_Error with "incorrect encoded value";
   end if;

end JSON_UTF8;
