package org.jboss.cache.buddyreplication;

import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.BuddyReplicationConfig.BuddyLocatorConfig;
import org.jboss.cache.config.Dynamic;

import java.util.Properties;

/**
 * Type-specific configuration object for NextMemberBuddyLocator.
 */
public class NextMemberBuddyLocatorConfig extends BuddyLocatorConfig
{
   private static final long serialVersionUID = 2443438867383733851L;

   @Dynamic
   private int numBuddies = 1;
   @Dynamic
   private boolean ignoreColocatedBuddies = true;

   /**
    * Default constructor.
    */
   public NextMemberBuddyLocatorConfig()
   {
      setBuddyLocatorClass(NextMemberBuddyLocator.class.getName());
   }

   /**
    * Constructor for use by {@link NextMemberBuddyLocator#init(BuddyLocatorConfig)}.
    *
    * @param base the config passed in to <code>init()</code>.
    */
   NextMemberBuddyLocatorConfig(BuddyReplicationConfig.BuddyLocatorConfig base)
   {
      this();
      setBuddyLocatorProperties(base.getBuddyLocatorProperties());
   }

   @Override
   public String getBuddyLocatorClass()
   {
      return NextMemberBuddyLocator.class.getName();
   }

   @Override
   public void setBuddyLocatorClass(String buddyLocatorClass)
   {
      // ignore it
   }

   public boolean isIgnoreColocatedBuddies()
   {
      return ignoreColocatedBuddies;
   }

   public void setIgnoreColocatedBuddies(boolean ignoreColocatedBuddies)
   {
      testImmutability("ignoreColocatedBuddies");
      this.ignoreColocatedBuddies = ignoreColocatedBuddies;
   }

   public int getNumBuddies()
   {
      return numBuddies;
   }

   public void setNumBuddies(int numBuddies)
   {
      testImmutability("numBuddies");
      this.numBuddies = numBuddies;
   }

   @Override
   public void setBuddyLocatorProperties(Properties props)
   {
      super.setBuddyLocatorProperties(props);
      if (props != null)
      {
         String numBuddiesStr = props.getProperty("numBuddies");
         String ignoreColocatedBuddiesStr = props.getProperty("ignoreColocatedBuddies");
         if (numBuddiesStr != null) numBuddies = Integer.parseInt(numBuddiesStr);
         if (ignoreColocatedBuddiesStr != null)
         {
            ignoreColocatedBuddies = Boolean.valueOf(ignoreColocatedBuddiesStr);
         }
      }
   }

   @Override
   public boolean equals(Object obj)
   {
      if (this == obj)
         return true;

      if (obj instanceof NextMemberBuddyLocatorConfig)
      {
         NextMemberBuddyLocatorConfig other = (NextMemberBuddyLocatorConfig) obj;
         return (other.ignoreColocatedBuddies == this.ignoreColocatedBuddies)
               && (other.numBuddies == this.numBuddies);
      }
      return false;
   }

   @Override
   public int hashCode()
   {
      int result = 13;
      result = 23 * result + (ignoreColocatedBuddies ? 0 : 1);
      result = 23 * result + numBuddies;
      return result;
   }

   @Override
   public NextMemberBuddyLocatorConfig clone() throws CloneNotSupportedException
   {
      return (NextMemberBuddyLocatorConfig) super.clone();
   }


}