message("\n${BoldRed}WIN10-MINGW64 environment${ColourReset}\n")
message("Please run the configuration like this:")
message("cmake -G \"Unix Makefiles\" -DCMAKE_BUILD_TYPE=Release ../development")


set(CMAKE_C_IMPLICIT_INCLUDE_DIRECTORIES "c:/msys64/mingw64/include")
set(CMAKE_CXX_IMPLICIT_INCLUDE_DIRECTORIES "c:/msys64/mingw64/bin")


if(WIN32 OR _WIN32)
	message(STATUS "Building with WIN32 or _WIN32 defined and WIN10MINGW64 defined also.")
endif()


find_package(ZLIB REQUIRED)


find_package(Boost COMPONENTS iostreams thread filesystem chrono REQUIRED ) 


# see https://cmake.org/pipermail/cmake/2015-December/062166.html
set(CMAKE_NO_SYSTEM_FROM_IMPORTED 1)

# Specific library to link to:
message(STATUS "Add psapi.dll as a win64-specific link-time dependency.")
list(APPEND PLATFORM_SPECIFIC_LINK_LIBRARIES "psapi")

# On Win10 all the code is relocatable.
remove_definitions(-fPIC)

# Install cmake module
install(FILES ${CMAKE_MODULE_PATH}/FindPwizLite.cmake 
	DESTINATION ${CMAKE_INSTALL_LIBDIR}/cmake/pwizlite)

# Install cmake config
configure_file (${CMAKE_MODULE_PATH}/PwizLiteConfig.cmake.in
	${CMAKE_BINARY_DIR}/PwizLiteConfig.cmake)
install(FILES ${CMAKE_BINARY_DIR}/PwizLiteConfig.cmake 
	DESTINATION ${CMAKE_INSTALL_LIBDIR}/cmake/pwizlite)

# Install the PkgConfig config file
configure_file (${CMAKE_MODULE_PATH}/pkgconfig/libpwizlite.pc.in
	${CMAKE_BINARY_DIR}/libpwizlite.pc)
install(FILES ${CMAKE_BINARY_DIR}/libpwizlite.pc 
	DESTINATION ${CMAKE_INSTALL_LIBDIR}/pkgconfig)


