package org.apache.maven.plugin.war;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

/**
 * Generate the webapp in the WAR source directory.
 *
 * @goal inplace
 * @requiresDependencyResolution runtime
 * @threadSafe
 * @version $Id: WarInPlaceMojo.java 985625 2010-08-15 08:15:16Z dennisl $
 */
public class WarInPlaceMojo
    extends AbstractWarMojo
{
    public void execute()
        throws MojoExecutionException, MojoFailureException
    {
        getLog().info( "Generating webapp in source directory [" + getWarSourceDirectory() + "]" );

        buildExplodedWebapp( getWarSourceDirectory() );
    }
}