#line 6 "ncx.m4"
/* Do not edit this file. It is produced from the corresponding .m4 source */
#line 8
/*
 *  Copyright (C) 2014, Northwestern University and Argonne National Laboratory
 *  See COPYRIGHT notice in top-level directory.
 */
/* $Id: ncx.m4 2601 2016-11-07 04:54:42Z wkliao $ */

#ifdef __GNUC__
#pragma GCC diagnostic ignored "-Wunused-parameter"
#endif

#line 22

#line 26


#line 34

#line 41

#line 41
#if HAVE_CONFIG_H
#line 41
#include <config.h>
#line 41
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#line 53

#line 53
#pragma GCC diagnostic ignored "-Wdeprecated"
#line 53
#include "ncx.h"
#line 53
#include "nc3dispatch.h"

#line 72




#ifdef HAVE_INTTYPES_H
#include <inttypes.h> /* uint16_t, uint32_t, uint64_t */
#elif defined(HAVE_STDINT_H)
#include <stdint.h>   /* uint16_t, uint32_t, uint64_t */
#endif

#line 103

#line 121

/*
 * The only error code returned from subroutines in this file is NC_ERANGE,
 * if errors are detected.
 */

/*
 * An external data representation interface.
 */

/* alias poorly named limits.h macros */
#define  SHORT_MAX  SHRT_MAX
#define  SHORT_MIN  SHRT_MIN
#define USHORT_MAX USHRT_MAX
#ifndef LLONG_MAX
#   define LLONG_MAX	9223372036854775807LL
#   define LLONG_MIN	(-LLONG_MAX - 1LL)
#   define ULLONG_MAX	18446744073709551615ULL
#endif
#ifndef LONG_LONG_MAX
#define LONG_LONG_MAX LLONG_MAX
#endif
#ifndef LONGLONG_MAX
#define LONGLONG_MAX LONG_LONG_MAX
#endif
#ifndef LONG_LONG_MIN
#define LONG_LONG_MIN LLONG_MIN
#endif
#ifndef LONGLONG_MIN
#define LONGLONG_MIN LONG_LONG_MIN
#endif
#ifndef ULONG_LONG_MAX
#define ULONG_LONG_MAX ULLONG_MAX
#endif
#ifndef ULONGLONG_MAX
#define ULONGLONG_MAX ULONG_LONG_MAX
#endif
#include <float.h>
#ifndef FLT_MAX /* This POSIX macro missing on some systems */
# ifndef NO_IEEE_FLOAT
# define FLT_MAX 3.40282347e+38f
# else
# error "You will need to define FLT_MAX"
# endif
#endif
/* alias poorly named float.h macros */
#define FLOAT_MAX FLT_MAX
#define FLOAT_MIN (-FLT_MAX)
#define DOUBLE_MAX DBL_MAX
#define DOUBLE_MIN (-DBL_MAX)
#define FLOAT_MAX_EXP FLT_MAX_EXP
#define DOUBLE_MAX_EXP DBL_MAX_EXP
#include <assert.h>
#define UCHAR_MIN 0
#define Min(a,b) ((a) < (b) ? (a) : (b))
#define Max(a,b) ((a) > (b) ? (a) : (b))

#ifndef SIZEOF_UCHAR
#ifdef  SIZEOF_UNSIGNED_CHAR
#define SIZEOF_UCHAR SIZEOF_UNSIGNED_CHAR
#else
#error "unknown SIZEOF_UCHAR"
#endif
#endif

#ifndef SIZEOF_USHORT
#ifdef  SIZEOF_UNSIGNED_SHORT_INT
#define SIZEOF_USHORT SIZEOF_UNSIGNED_SHORT_INT
#elif defined(SIZEOF_UNSIGNED_SHORT)
#define SIZEOF_USHORT SIZEOF_UNSIGNED_SHORT
#else
#error "unknown SIZEOF_USHORT"
#endif
#endif

#ifndef SIZEOF_UINT
#ifdef  SIZEOF_UNSIGNED_INT
#define SIZEOF_UINT SIZEOF_UNSIGNED_INT
#else
#error "unknown SIZEOF_UINT"
#endif
#endif

#ifndef SIZEOF_LONGLONG
#ifdef  SIZEOF_LONG_LONG
#define SIZEOF_LONGLONG SIZEOF_LONG_LONG
#else
#error "unknown SIZEOF_LONGLONG"
#endif
#endif

#ifndef SIZEOF_INT64
#ifdef  SIZEOF_LONG_LONG
#define SIZEOF_INT64 SIZEOF_LONG_LONG
#elif defined(SIZEOF_LONGLONG)
#define SIZEOF_INT64 SIZEOF_LONGLONG
#else
#error "unknown SIZEOF_INT64"
#endif
#endif

#ifndef SIZEOF_ULONGLONG
#ifdef  SIZEOF_UNSIGNED_LONG_LONG
#define SIZEOF_ULONGLONG SIZEOF_UNSIGNED_LONG_LONG
#else
#error "unknown SIZEOF_ULONGLONG"
#endif
#endif

#ifndef SIZEOF_UINT64
#ifdef  SIZEOF_UNSIGNED_LONG_LONG
#define SIZEOF_UINT64 SIZEOF_UNSIGNED_LONG_LONG
#elif defined(SIZEOF_ULONGLONG)
#define SIZEOF_UINT64 SIZEOF_ULONGLONG
#else
#error "unknown SIZEOF_UINT64"
#endif
#endif

/*
 * If the machine's float domain is "smaller" than the external one
 * use the machine domain
 */
#if defined(FLT_MAX_EXP) && FLT_MAX_EXP < 128 /* 128 is X_FLT_MAX_EXP */
#undef X_FLOAT_MAX
# define X_FLOAT_MAX FLT_MAX
#undef X_FLOAT_MIN
# define X_FLOAT_MIN (-X_FLOAT_MAX)
#endif

#if defined(_SX) && _SX != 0 /* NEC SUPER UX */
#define LOOPCNT 256    /* must be no longer than hardware vector length */
#if _INT64
#undef  INT_MAX /* workaround cpp bug */
#define INT_MAX  X_INT_MAX
#undef  INT_MIN /* workaround cpp bug */
#define INT_MIN  X_INT_MIN
#undef  LONG_MAX /* workaround cpp bug */
#define LONG_MAX  X_INT_MAX
#undef  LONG_MIN /* workaround cpp bug */
#define LONG_MIN  X_INT_MIN
#elif _LONG64
#undef  LONG_MAX /* workaround cpp bug */
#define LONG_MAX  4294967295L
#undef  LONG_MIN /* workaround cpp bug */
#define LONG_MIN -4294967295L
#endif
#if !_FLOAT0
#error "FLOAT1 and FLOAT2 not supported"
#endif
#endif /* _SX */

static const char nada[X_ALIGN] = {0, 0, 0, 0};

#ifndef WORDS_BIGENDIAN
/* LITTLE_ENDIAN: DEC and intel */
/*
 * Routines to convert to BIG ENDIAN.
 * Optimize the swapn?b() and swap?b() routines aggressively.
 */

#define SWAP2(a) ( (((a) & 0xff) << 8) | \
                   (((a) >> 8) & 0xff) )

#define SWAP4(a) ( ((a) << 24) | \
                  (((a) <<  8) & 0x00ff0000) | \
                  (((a) >>  8) & 0x0000ff00) | \
                  (((a) >> 24) & 0x000000ff) )

#define SWAP8(a) ( (((a) & 0x00000000000000FFULL) << 56) | \
                   (((a) & 0x000000000000FF00ULL) << 40) | \
                   (((a) & 0x0000000000FF0000ULL) << 24) | \
                   (((a) & 0x00000000FF000000ULL) <<  8) | \
                   (((a) & 0x000000FF00000000ULL) >>  8) | \
                   (((a) & 0x0000FF0000000000ULL) >> 24) | \
                   (((a) & 0x00FF000000000000ULL) >> 40) | \
                   (((a) & 0xFF00000000000000ULL) >> 56) )

#if defined(_MSC_VER) && _MSC_VER < 1900
#define inline __inline
#endif

inline static void
swapn2b(void *dst, const void *src, size_t nn)
{
    /* it is OK if dst == src */
    int i;
    uint16_t *op = (uint16_t*) dst;
    uint16_t *ip = (uint16_t*) src;
    for (i=0; i<nn; i++) {
        op[i] = ip[i];
        op[i] = (uint16_t)SWAP2(op[i]);
    }
#if 0
	char *op = dst;
	const char *ip = src;

/* unroll the following to reduce loop overhead
 *
 *	while (nn-- > 0)
 *	{
 *		*op++ = *(++ip);
 *		*op++ = *(ip++ -1);
 *	}
 */
	while (nn > 3)
	{
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		nn -= 4;
	}
	while (nn-- > 0)
	{
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
	}
#endif
}

# ifndef vax
inline static void
swap4b(void *dst, const void *src)
{
    /* copy over, make the below swap in-place */
    uint32_t tmp = *(uint32_t*)src;
    tmp = SWAP4(tmp);
    memcpy(dst, &tmp, 4);

    /* Codes below will cause "break strict-aliasing rules" in gcc
    uint32_t *op = (uint32_t*)dst;
    *op = *(uint32_t*)src;
    *op = SWAP4(*op);
    */

    /* Below are copied from netCDF-4.
     * See https://bugtracking.unidata.ucar.edu/browse/NCF-338
     * Quote "One issue we are wrestling with is how compilers optimize this
     * code.  For some reason, we are actually needing to add an artificial
     * move to a 4 byte space to get it to work.  I think what is happening is
     * that the optimizer is bit shifting within a double, which is incorrect.
     * The following code actually does work correctly.
     *  This is in Linux land, gcc.
     *
     * However, the above in-place byte-swap does not appear affected by this.
     */
#if 0
    uint32_t *ip = (uint32_t*)src;
    uint32_t tempOut;  /* cannot use pointer when gcc O2 optimizer is used */
    tempOut = SWAP4(*ip);

    *(float *)dst = *(float *)(&tempOut);
#endif

    /* OLD implementation that results in four load and four store CPU
       instructions
    char *op = dst;
    const char *ip = src;
    op[0] = ip[3];
    op[1] = ip[2];
    op[2] = ip[1];
    op[3] = ip[0];
    */

}
# endif /* !vax */

inline static void
swapn4b(void *dst, const void *src, size_t nn)
{
    int i;
    uint32_t *op = (uint32_t*) dst;
    uint32_t *ip = (uint32_t*) src;
    for (i=0; i<nn; i++) {
        /* copy over, make the below swap in-place */
        op[i] = ip[i];
        op[i] = SWAP4(op[i]);
    }

#if 0
	char *op = dst;
	const char *ip = src;

/* unroll the following to reduce loop overhead
 *	while (nn-- > 0)
 *	{
 *		op[0] = ip[3];
 *		op[1] = ip[2];
 *		op[2] = ip[1];
 *		op[3] = ip[0];
 *		op += 4;
 *		ip += 4;
 *	}
 */
	while (nn > 3)
	{
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
		op[4] = ip[7];
		op[5] = ip[6];
		op[6] = ip[5];
		op[7] = ip[4];
		op[8] = ip[11];
		op[9] = ip[10];
		op[10] = ip[9];
		op[11] = ip[8];
		op[12] = ip[15];
		op[13] = ip[14];
		op[14] = ip[13];
		op[15] = ip[12];
		op += 16;
		ip += 16;
		nn -= 4;
	}
	while (nn-- > 0)
	{
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
		op += 4;
		ip += 4;
	}
#endif
}

# ifndef vax
inline static void
swap8b(void *dst, const void *src)
{
#ifdef FLOAT_WORDS_BIGENDIAN
    /* copy over, make the below swap in-place */
    *(uint64_t*)dst = *(uint64_t*)src;

    uint32_t *op = (uint32_t*)dst;
    *op = SWAP4(*op);
    op = (uint32_t*)((char*)dst+4);
    *op = SWAP4(*op);
#else
    uint64_t tmp = *(uint64_t*)src;
    tmp = SWAP8(tmp);
    memcpy(dst, &tmp, 8);

    /* Codes below will cause "break strict-aliasing rules" in gcc
    uint64_t *op = (uint64_t*)dst;
    *op = *(uint64_t*)src;
    *op = SWAP8(*op);
    */
#endif

#if 0
	char *op = dst;
	const char *ip = src;
#  ifndef FLOAT_WORDS_BIGENDIAN
	op[0] = ip[7];
	op[1] = ip[6];
	op[2] = ip[5];
	op[3] = ip[4];
	op[4] = ip[3];
	op[5] = ip[2];
	op[6] = ip[1];
	op[7] = ip[0];
#  else
	op[0] = ip[3];
	op[1] = ip[2];
	op[2] = ip[1];
	op[3] = ip[0];
	op[4] = ip[7];
	op[5] = ip[6];
	op[6] = ip[5];
	op[7] = ip[4];
#endif
#endif
}
# endif /* !vax */

# ifndef vax
inline static void
swapn8b(void *dst, const void *src, size_t nn)
{
#ifdef FLOAT_WORDS_BIGENDIAN
    int i;
    uint64_t *dst_p = (uint64_t*) dst;
    uint64_t *src_p = (uint64_t*) src;
    for (i=0; i<nn; i++) {
        /* copy over, make the below swap in-place */
        dst_p[i] = src_p[i];
        uint32_t *op = (uint32_t*)(&dst_p[i]);
        *op = SWAP4(*op);
        op = (uint32_t*)((char*)op+4);
        *op = SWAP4(*op);
    }
#else
    int i;
    uint64_t *op = (uint64_t*) dst;
    uint64_t *ip = (uint64_t*) src;
    for (i=0; i<nn; i++) {
        /* copy over, make the below swap in-place */
        op[i] = ip[i];
        op[i] = SWAP8(op[i]);
    }
#endif

#if 0
	char *op = dst;
	const char *ip = src;

/* unroll the following to reduce loop overhead
 *	while (nn-- > 0)
 *	{
 *		op[0] = ip[7];
 *		op[1] = ip[6];
 *		op[2] = ip[5];
 *		op[3] = ip[4];
 *		op[4] = ip[3];
 *		op[5] = ip[2];
 *		op[6] = ip[1];
 *		op[7] = ip[0];
 *		op += 8;
 *		ip += 8;
 *	}
 */
#  ifndef FLOAT_WORDS_BIGENDIAN
	while (nn > 1)
	{
		op[0] = ip[7];
		op[1] = ip[6];
		op[2] = ip[5];
		op[3] = ip[4];
		op[4] = ip[3];
		op[5] = ip[2];
		op[6] = ip[1];
		op[7] = ip[0];
		op[8] = ip[15];
		op[9] = ip[14];
		op[10] = ip[13];
		op[11] = ip[12];
		op[12] = ip[11];
		op[13] = ip[10];
		op[14] = ip[9];
		op[15] = ip[8];
		op += 16;
		ip += 16;
		nn -= 2;
	}
	while (nn-- > 0)
	{
		op[0] = ip[7];
		op[1] = ip[6];
		op[2] = ip[5];
		op[3] = ip[4];
		op[4] = ip[3];
		op[5] = ip[2];
		op[6] = ip[1];
		op[7] = ip[0];
		op += 8;
		ip += 8;
	}
#  else
	while (nn-- > 0)
	{
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
		op[4] = ip[7];
		op[5] = ip[6];
		op[6] = ip[5];
		op[7] = ip[4];
		op += 8;
		ip += 8;
	}
#endif
#endif
}
# endif /* !vax */

#endif /* LITTLE_ENDIAN */

#line 630

#line 634

#line 646

#line 661


/*
 * Primitive numeric conversion functions.
 */

#line 689

#line 737

#line 770

#line 816

/* x_schar */
/* x_uchar */

/* We don't implement any x_schar and x_uchar primitives. */


/* external NC_SHORT --------------------------------------------------------*/

#if SHORT_MAX == X_SHORT_MAX
typedef short ix_short;
#define SIZEOF_IX_SHORT SIZEOF_SHORT
#define IX_SHORT_MAX SHORT_MAX
#elif INT_MAX >= X_SHORT_MAX
typedef int ix_short;
#define SIZEOF_IX_SHORT SIZEOF_INT
#define IX_SHORT_MAX INT_MAX
#elif LONG_MAX >= X_SHORT_MAX
typedef long ix_short;
#define SIZEOF_IX_SHORT SIZEOF_LONG
#define IX_SHORT_MAX LONG_MAX
#elif LLONG_MAX >= X_SHORT_MAX
typedef long long ix_short;
#define SIZEOF_IX_SHORT SIZEOF_LONGLONG
#define IX_SHORT_MAX LLONG_MAX
#else
#error "ix_short implementation"
#endif

static void
get_ix_short(const void *xp, ix_short *ip)
{
	const uchar *cp = (const uchar *) xp;
	*ip = (ix_short)(*cp++ << 8);
#if SIZEOF_IX_SHORT > X_SIZEOF_SHORT
	if (*ip & 0x8000)
	{
		/* extern is negative */
		*ip |= (~(0xffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip = (ix_short)(*ip | *cp);
}

static void
put_ix_short(void *xp, const ix_short *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = (uchar)((*ip) >> 8);
	*cp   = (uchar)((*ip) & 0xff);
}

static int
#line 868
ncx_get_short_schar(const void *xp, schar *ip)
#line 868
{
#line 868
    int err=NC_NOERR;
#line 868
    ix_short xx = 0;
#line 868
    get_ix_short(xp, &xx);
#line 868

#line 868
#if IX_SHORT_MAX > SCHAR_MAX
#line 868
    if (xx > SCHAR_MAX || xx < SCHAR_MIN) {
#line 868
#ifdef ERANGE_FILL
#line 868
        *ip = NC_FILL_BYTE;
#line 868
        return NC_ERANGE;
#line 868
#else
#line 868
        err = NC_ERANGE;
#line 868
#endif
#line 868
    }
#line 868
#endif
#line 868

#line 868

#line 868
    *ip = (schar) xx;
#line 868
    return err;
#line 868
}
#line 868

static int
#line 869
ncx_get_short_short(const void *xp, short *ip)
#line 869
{
#line 869
    int err=NC_NOERR;
#line 869
#if SIZEOF_IX_SHORT == SIZEOF_SHORT && IX_SHORT_MAX == SHORT_MAX
#line 869
    get_ix_short(xp, (ix_short *)ip);
#line 869
#else
#line 869
    ix_short xx = 0;
#line 869
    get_ix_short(xp, &xx);
#line 869

#line 869
#if IX_SHORT_MAX > SHORT_MAX
#line 869
    if (xx > SHORT_MAX || xx < SHORT_MIN) {
#line 869
#ifdef ERANGE_FILL
#line 869
        *ip = NC_FILL_SHORT;
#line 869
        return NC_ERANGE;
#line 869
#else
#line 869
        err = NC_ERANGE;
#line 869
#endif
#line 869
    }
#line 869
#endif
#line 869

#line 869

#line 869
    *ip = (short) xx;
#line 869
#endif
#line 869
    return err;
#line 869
}
#line 869

static int
#line 870
ncx_get_short_int(const void *xp, int *ip)
#line 870
{
#line 870
    int err=NC_NOERR;
#line 870
#if SIZEOF_IX_SHORT == SIZEOF_INT && IX_SHORT_MAX == INT_MAX
#line 870
    get_ix_short(xp, (ix_short *)ip);
#line 870
#else
#line 870
    ix_short xx = 0;
#line 870
    get_ix_short(xp, &xx);
#line 870

#line 870
#if IX_SHORT_MAX > INT_MAX
#line 870
    if (xx > INT_MAX || xx < INT_MIN) {
#line 870
#ifdef ERANGE_FILL
#line 870
        *ip = NC_FILL_INT;
#line 870
        return NC_ERANGE;
#line 870
#else
#line 870
        err = NC_ERANGE;
#line 870
#endif
#line 870
    }
#line 870
#endif
#line 870

#line 870

#line 870
    *ip = (int) xx;
#line 870
#endif
#line 870
    return err;
#line 870
}
#line 870

static int
#line 871
ncx_get_short_long(const void *xp, long *ip)
#line 871
{
#line 871
    int err=NC_NOERR;
#line 871
#if SIZEOF_IX_SHORT == SIZEOF_LONG && IX_SHORT_MAX == LONG_MAX
#line 871
    get_ix_short(xp, (ix_short *)ip);
#line 871
#else
#line 871
    ix_short xx = 0;
#line 871
    get_ix_short(xp, &xx);
#line 871

#line 871
#if IX_SHORT_MAX > LONG_MAX
#line 871
    if (xx > LONG_MAX || xx < LONG_MIN) {
#line 871
#ifdef ERANGE_FILL
#line 871
        *ip = NC_FILL_INT;
#line 871
        return NC_ERANGE;
#line 871
#else
#line 871
        err = NC_ERANGE;
#line 871
#endif
#line 871
    }
#line 871
#endif
#line 871

#line 871

#line 871
    *ip = (long) xx;
#line 871
#endif
#line 871
    return err;
#line 871
}
#line 871

static int
#line 872
ncx_get_short_longlong(const void *xp, longlong *ip)
#line 872
{
#line 872
    int err=NC_NOERR;
#line 872
#if SIZEOF_IX_SHORT == SIZEOF_LONGLONG && IX_SHORT_MAX == LONGLONG_MAX
#line 872
    get_ix_short(xp, (ix_short *)ip);
#line 872
#else
#line 872
    ix_short xx = 0;
#line 872
    get_ix_short(xp, &xx);
#line 872

#line 872
#if IX_SHORT_MAX > LONGLONG_MAX
#line 872
    if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) {
#line 872
#ifdef ERANGE_FILL
#line 872
        *ip = NC_FILL_INT64;
#line 872
        return NC_ERANGE;
#line 872
#else
#line 872
        err = NC_ERANGE;
#line 872
#endif
#line 872
    }
#line 872
#endif
#line 872

#line 872

#line 872
    *ip = (longlong) xx;
#line 872
#endif
#line 872
    return err;
#line 872
}
#line 872

static int
#line 873
ncx_get_short_ushort(const void *xp, ushort *ip)
#line 873
{
#line 873
    int err=NC_NOERR;
#line 873
    ix_short xx = 0;
#line 873
    get_ix_short(xp, &xx);
#line 873

#line 873
#if IX_SHORT_MAX > USHORT_MAX
#line 873
    if (xx > USHORT_MAX) {
#line 873
#ifdef ERANGE_FILL
#line 873
        *ip = NC_FILL_USHORT;
#line 873
        return NC_ERANGE;
#line 873
#else
#line 873
        err = NC_ERANGE;
#line 873
#endif
#line 873
    }
#line 873
#endif
#line 873

#line 873
    if (xx < 0) {
#line 873
#ifdef ERANGE_FILL
#line 873
        *ip = NC_FILL_USHORT;
#line 873
        return NC_ERANGE;
#line 873
#else
#line 873
        err = NC_ERANGE; /* because ip is unsigned */
#line 873
#endif
#line 873
    }
#line 873
    *ip = (ushort) xx;
#line 873
    return err;
#line 873
}
#line 873

static int
#line 874
ncx_get_short_uchar(const void *xp, uchar *ip)
#line 874
{
#line 874
    int err=NC_NOERR;
#line 874
    ix_short xx = 0;
#line 874
    get_ix_short(xp, &xx);
#line 874

#line 874
#if IX_SHORT_MAX > UCHAR_MAX
#line 874
    if (xx > UCHAR_MAX) {
#line 874
#ifdef ERANGE_FILL
#line 874
        *ip = NC_FILL_UBYTE;
#line 874
        return NC_ERANGE;
#line 874
#else
#line 874
        err = NC_ERANGE;
#line 874
#endif
#line 874
    }
#line 874
#endif
#line 874

#line 874
    if (xx < 0) {
#line 874
#ifdef ERANGE_FILL
#line 874
        *ip = NC_FILL_UBYTE;
#line 874
        return NC_ERANGE;
#line 874
#else
#line 874
        err = NC_ERANGE; /* because ip is unsigned */
#line 874
#endif
#line 874
    }
#line 874
    *ip = (uchar) xx;
#line 874
    return err;
#line 874
}
#line 874

static int
#line 875
ncx_get_short_uint(const void *xp, uint *ip)
#line 875
{
#line 875
    int err=NC_NOERR;
#line 875
    ix_short xx = 0;
#line 875
    get_ix_short(xp, &xx);
#line 875

#line 875
#if IX_SHORT_MAX > UINT_MAX
#line 875
    if (xx > UINT_MAX) {
#line 875
#ifdef ERANGE_FILL
#line 875
        *ip = NC_FILL_UINT;
#line 875
        return NC_ERANGE;
#line 875
#else
#line 875
        err = NC_ERANGE;
#line 875
#endif
#line 875
    }
#line 875
#endif
#line 875

#line 875
    if (xx < 0) {
#line 875
#ifdef ERANGE_FILL
#line 875
        *ip = NC_FILL_UINT;
#line 875
        return NC_ERANGE;
#line 875
#else
#line 875
        err = NC_ERANGE; /* because ip is unsigned */
#line 875
#endif
#line 875
    }
#line 875
    *ip = (uint) xx;
#line 875
    return err;
#line 875
}
#line 875

static int
#line 876
ncx_get_short_ulonglong(const void *xp, ulonglong *ip)
#line 876
{
#line 876
    int err=NC_NOERR;
#line 876
    ix_short xx = 0;
#line 876
    get_ix_short(xp, &xx);
#line 876

#line 876
#if IX_SHORT_MAX > ULONGLONG_MAX
#line 876
    if (xx > ULONGLONG_MAX) {
#line 876
#ifdef ERANGE_FILL
#line 876
        *ip = NC_FILL_UINT64;
#line 876
        return NC_ERANGE;
#line 876
#else
#line 876
        err = NC_ERANGE;
#line 876
#endif
#line 876
    }
#line 876
#endif
#line 876

#line 876
    if (xx < 0) {
#line 876
#ifdef ERANGE_FILL
#line 876
        *ip = NC_FILL_UINT64;
#line 876
        return NC_ERANGE;
#line 876
#else
#line 876
        err = NC_ERANGE; /* because ip is unsigned */
#line 876
#endif
#line 876
    }
#line 876
    *ip = (ulonglong) xx;
#line 876
    return err;
#line 876
}
#line 876

static int
#line 877
ncx_get_short_float(const void *xp, float *ip)
#line 877
{
#line 877
	ix_short xx = 0;
#line 877
	get_ix_short(xp, &xx);
#line 877
	*ip = (float)xx;
#line 877
	return NC_NOERR;
#line 877
}
#line 877

static int
#line 878
ncx_get_short_double(const void *xp, double *ip)
#line 878
{
#line 878
	ix_short xx = 0;
#line 878
	get_ix_short(xp, &xx);
#line 878
	*ip = (double)xx;
#line 878
	return NC_NOERR;
#line 878
}
#line 878


static int
ncx_put_short_schar(void *xp, const schar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	if (*ip & 0x80)
		*cp++ = 0xff;
	else
		*cp++ = 0;
	*cp = (uchar)*ip;
	return NC_NOERR;
}

static int
ncx_put_short_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0;
	*cp = *ip;
	return NC_NOERR;
}

static int
#line 901
ncx_put_short_short(void *xp, const short *ip, void *fillp)
#line 901
{
#line 901
    int err=NC_NOERR;
#line 901
#if SIZEOF_IX_SHORT == SIZEOF_SHORT && IX_SHORT_MAX == SHORT_MAX
#line 901
    put_ix_short(xp, (const ix_short *)ip);
#line 901
#else
#line 901
    ix_short xx = NC_FILL_SHORT;
#line 901

#line 901
#if IX_SHORT_MAX < SHORT_MAX
#line 901
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 901
        
#line 901
#ifdef ERANGE_FILL
#line 901
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 901
#endif
#line 901
        err = NC_ERANGE;
#line 901
    }
#line 901
#ifdef ERANGE_FILL
#line 901
    else
#line 901
#endif
#line 901
#endif
#line 901
        xx = (ix_short)*ip;
#line 901

#line 901
    put_ix_short(xp, &xx);
#line 901
#endif
#line 901
    return err;
#line 901
}
#line 901

static int
#line 902
ncx_put_short_int(void *xp, const int *ip, void *fillp)
#line 902
{
#line 902
    int err=NC_NOERR;
#line 902
#if SIZEOF_IX_SHORT == SIZEOF_INT && IX_SHORT_MAX == INT_MAX
#line 902
    put_ix_short(xp, (const ix_short *)ip);
#line 902
#else
#line 902
    ix_short xx = NC_FILL_SHORT;
#line 902

#line 902
#if IX_SHORT_MAX < INT_MAX
#line 902
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 902
        
#line 902
#ifdef ERANGE_FILL
#line 902
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 902
#endif
#line 902
        err = NC_ERANGE;
#line 902
    }
#line 902
#ifdef ERANGE_FILL
#line 902
    else
#line 902
#endif
#line 902
#endif
#line 902
        xx = (ix_short)*ip;
#line 902

#line 902
    put_ix_short(xp, &xx);
#line 902
#endif
#line 902
    return err;
#line 902
}
#line 902

static int
#line 903
ncx_put_short_long(void *xp, const long *ip, void *fillp)
#line 903
{
#line 903
    int err=NC_NOERR;
#line 903
#if SIZEOF_IX_SHORT == SIZEOF_LONG && IX_SHORT_MAX == LONG_MAX
#line 903
    put_ix_short(xp, (const ix_short *)ip);
#line 903
#else
#line 903
    ix_short xx = NC_FILL_SHORT;
#line 903

#line 903
#if IX_SHORT_MAX < LONG_MAX
#line 903
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 903
        
#line 903
#ifdef ERANGE_FILL
#line 903
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 903
#endif
#line 903
        err = NC_ERANGE;
#line 903
    }
#line 903
#ifdef ERANGE_FILL
#line 903
    else
#line 903
#endif
#line 903
#endif
#line 903
        xx = (ix_short)*ip;
#line 903

#line 903
    put_ix_short(xp, &xx);
#line 903
#endif
#line 903
    return err;
#line 903
}
#line 903

static int
#line 904
ncx_put_short_longlong(void *xp, const longlong *ip, void *fillp)
#line 904
{
#line 904
    int err=NC_NOERR;
#line 904
#if SIZEOF_IX_SHORT == SIZEOF_LONGLONG && IX_SHORT_MAX == LONGLONG_MAX
#line 904
    put_ix_short(xp, (const ix_short *)ip);
#line 904
#else
#line 904
    ix_short xx = NC_FILL_SHORT;
#line 904

#line 904
#if IX_SHORT_MAX < LONGLONG_MAX
#line 904
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 904
        
#line 904
#ifdef ERANGE_FILL
#line 904
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 904
#endif
#line 904
        err = NC_ERANGE;
#line 904
    }
#line 904
#ifdef ERANGE_FILL
#line 904
    else
#line 904
#endif
#line 904
#endif
#line 904
        xx = (ix_short)*ip;
#line 904

#line 904
    put_ix_short(xp, &xx);
#line 904
#endif
#line 904
    return err;
#line 904
}
#line 904

static int
#line 905
ncx_put_short_ushort(void *xp, const ushort *ip, void *fillp)
#line 905
{
#line 905
    int err=NC_NOERR;
#line 905
    ix_short xx = NC_FILL_SHORT;
#line 905

#line 905
#if IX_SHORT_MAX < USHORT_MAX
#line 905
    if (*ip > IX_SHORT_MAX) {
#line 905
        
#line 905
#ifdef ERANGE_FILL
#line 905
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 905
#endif
#line 905
        err = NC_ERANGE;
#line 905
    }
#line 905
#ifdef ERANGE_FILL
#line 905
    else
#line 905
#endif
#line 905
#endif
#line 905
        xx = (ix_short)*ip;
#line 905

#line 905
    put_ix_short(xp, &xx);
#line 905
    return err;
#line 905
}
#line 905

static int
#line 906
ncx_put_short_uint(void *xp, const uint *ip, void *fillp)
#line 906
{
#line 906
    int err=NC_NOERR;
#line 906
    ix_short xx = NC_FILL_SHORT;
#line 906

#line 906
#if IX_SHORT_MAX < UINT_MAX
#line 906
    if (*ip > IX_SHORT_MAX) {
#line 906
        
#line 906
#ifdef ERANGE_FILL
#line 906
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 906
#endif
#line 906
        err = NC_ERANGE;
#line 906
    }
#line 906
#ifdef ERANGE_FILL
#line 906
    else
#line 906
#endif
#line 906
#endif
#line 906
        xx = (ix_short)*ip;
#line 906

#line 906
    put_ix_short(xp, &xx);
#line 906
    return err;
#line 906
}
#line 906

static int
#line 907
ncx_put_short_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 907
{
#line 907
    int err=NC_NOERR;
#line 907
    ix_short xx = NC_FILL_SHORT;
#line 907

#line 907
#if IX_SHORT_MAX < ULONGLONG_MAX
#line 907
    if (*ip > IX_SHORT_MAX) {
#line 907
        
#line 907
#ifdef ERANGE_FILL
#line 907
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 907
#endif
#line 907
        err = NC_ERANGE;
#line 907
    }
#line 907
#ifdef ERANGE_FILL
#line 907
    else
#line 907
#endif
#line 907
#endif
#line 907
        xx = (ix_short)*ip;
#line 907

#line 907
    put_ix_short(xp, &xx);
#line 907
    return err;
#line 907
}
#line 907

static int
#line 908
ncx_put_short_float(void *xp, const float *ip, void *fillp)
#line 908
{
#line 908
    int err=NC_NOERR;
#line 908
    ix_short xx = NC_FILL_SHORT;
#line 908

#line 908
    if (*ip > (double)X_SHORT_MAX || *ip < (double)X_SHORT_MIN) {
#line 908
        
#line 908
#ifdef ERANGE_FILL
#line 908
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 908
#endif
#line 908
        err = NC_ERANGE;
#line 908
    }
#line 908
#ifdef ERANGE_FILL
#line 908
    else
#line 908
#endif
#line 908
        xx = (ix_short)*ip;
#line 908

#line 908
    put_ix_short(xp, &xx);
#line 908
    return err;
#line 908
}
#line 908

static int
#line 909
ncx_put_short_double(void *xp, const double *ip, void *fillp)
#line 909
{
#line 909
    int err=NC_NOERR;
#line 909
    ix_short xx = NC_FILL_SHORT;
#line 909

#line 909
    if (*ip > X_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 909
        
#line 909
#ifdef ERANGE_FILL
#line 909
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 909
#endif
#line 909
        err = NC_ERANGE;
#line 909
    }
#line 909
#ifdef ERANGE_FILL
#line 909
    else
#line 909
#endif
#line 909
        xx = (ix_short)*ip;
#line 909

#line 909
    put_ix_short(xp, &xx);
#line 909
    return err;
#line 909
}
#line 909


/* external NC_USHORT -------------------------------------------------------*/

#if USHORT_MAX == X_USHORT_MAX
typedef unsigned short ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_USHORT
#define IX_USHORT_MAX USHORT_MAX
#elif UINT_MAX >= X_USHORT_MAX
typedef unsigned int ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_UINT
#define IX_USHORT_MAX UINT_MAX
#elif ULONG_MAX >= X_USHORT_MAX
typedef unsigned long ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_ULONG
#define IX_USHORT_MAX ULONG_MAX
#elif ULLONG_MAX >= X_USHORT_MAX
typedef unsigned long long ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_ULONGLONG
#define IX_USHORT_MAX ULLONG_MAX
#else
#error "ix_ushort implementation"
#endif

static void
get_ix_ushort(const void *xp, ix_ushort *ip)
{
	const uchar *cp = (const uchar *) xp;
	*ip = (ix_ushort)(*cp++ << 8);
#if SIZEOF_IX_SHORT > X_SIZEOF_SHORT
	if (*ip & 0x8000)
	{
		/* extern is negative */
		*ip |= (~(0xffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip = (ix_ushort)(*ip | *cp);
}

static void
put_ix_ushort(void *xp, const ix_ushort *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = (uchar)((*ip) >> 8);
	*cp   = (uchar)((*ip) & 0xff);
}

static int
#line 956
ncx_get_ushort_schar(const void *xp, schar *ip)
#line 956
{
#line 956
    int err=NC_NOERR;
#line 956
    ix_ushort xx = 0;
#line 956
    get_ix_ushort(xp, &xx);
#line 956

#line 956
#if IX_USHORT_MAX > SCHAR_MAX
#line 956
    if (xx > SCHAR_MAX) {
#line 956
#ifdef ERANGE_FILL
#line 956
        *ip = NC_FILL_BYTE;
#line 956
        return NC_ERANGE;
#line 956
#else
#line 956
        err = NC_ERANGE;
#line 956
#endif
#line 956
    }
#line 956
#endif
#line 956

#line 956

#line 956
    *ip = (schar) xx;
#line 956
    return err;
#line 956
}
#line 956

static int
#line 957
ncx_get_ushort_short(const void *xp, short *ip)
#line 957
{
#line 957
    int err=NC_NOERR;
#line 957
    ix_ushort xx = 0;
#line 957
    get_ix_ushort(xp, &xx);
#line 957

#line 957
#if IX_USHORT_MAX > SHORT_MAX
#line 957
    if (xx > SHORT_MAX) {
#line 957
#ifdef ERANGE_FILL
#line 957
        *ip = NC_FILL_SHORT;
#line 957
        return NC_ERANGE;
#line 957
#else
#line 957
        err = NC_ERANGE;
#line 957
#endif
#line 957
    }
#line 957
#endif
#line 957

#line 957

#line 957
    *ip = (short) xx;
#line 957
    return err;
#line 957
}
#line 957

static int
#line 958
ncx_get_ushort_int(const void *xp, int *ip)
#line 958
{
#line 958
    int err=NC_NOERR;
#line 958
    ix_ushort xx = 0;
#line 958
    get_ix_ushort(xp, &xx);
#line 958

#line 958
#if IX_USHORT_MAX > INT_MAX
#line 958
    if (xx > INT_MAX) {
#line 958
#ifdef ERANGE_FILL
#line 958
        *ip = NC_FILL_INT;
#line 958
        return NC_ERANGE;
#line 958
#else
#line 958
        err = NC_ERANGE;
#line 958
#endif
#line 958
    }
#line 958
#endif
#line 958

#line 958

#line 958
    *ip = (int) xx;
#line 958
    return err;
#line 958
}
#line 958

static int
#line 959
ncx_get_ushort_long(const void *xp, long *ip)
#line 959
{
#line 959
    int err=NC_NOERR;
#line 959
    ix_ushort xx = 0;
#line 959
    get_ix_ushort(xp, &xx);
#line 959

#line 959
#if IX_USHORT_MAX > LONG_MAX
#line 959
    if (xx > LONG_MAX) {
#line 959
#ifdef ERANGE_FILL
#line 959
        *ip = NC_FILL_INT;
#line 959
        return NC_ERANGE;
#line 959
#else
#line 959
        err = NC_ERANGE;
#line 959
#endif
#line 959
    }
#line 959
#endif
#line 959

#line 959

#line 959
    *ip = (long) xx;
#line 959
    return err;
#line 959
}
#line 959

static int
#line 960
ncx_get_ushort_longlong(const void *xp, longlong *ip)
#line 960
{
#line 960
    int err=NC_NOERR;
#line 960
    ix_ushort xx = 0;
#line 960
    get_ix_ushort(xp, &xx);
#line 960

#line 960
#if IX_USHORT_MAX > LONGLONG_MAX
#line 960
    if (xx > LONGLONG_MAX) {
#line 960
#ifdef ERANGE_FILL
#line 960
        *ip = NC_FILL_INT64;
#line 960
        return NC_ERANGE;
#line 960
#else
#line 960
        err = NC_ERANGE;
#line 960
#endif
#line 960
    }
#line 960
#endif
#line 960

#line 960

#line 960
    *ip = (longlong) xx;
#line 960
    return err;
#line 960
}
#line 960

static int
#line 961
ncx_get_ushort_ushort(const void *xp, ushort *ip)
#line 961
{
#line 961
    int err=NC_NOERR;
#line 961
#if SIZEOF_IX_USHORT == SIZEOF_USHORT && IX_USHORT_MAX == USHORT_MAX
#line 961
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 961
#else
#line 961
    ix_ushort xx = 0;
#line 961
    get_ix_ushort(xp, &xx);
#line 961

#line 961
#if IX_USHORT_MAX > USHORT_MAX
#line 961
    if (xx > USHORT_MAX) {
#line 961
#ifdef ERANGE_FILL
#line 961
        *ip = NC_FILL_USHORT;
#line 961
        return NC_ERANGE;
#line 961
#else
#line 961
        err = NC_ERANGE;
#line 961
#endif
#line 961
    }
#line 961
#endif
#line 961

#line 961

#line 961
    *ip = (ushort) xx;
#line 961
#endif
#line 961
    return err;
#line 961
}
#line 961

static int
#line 962
ncx_get_ushort_uchar(const void *xp, uchar *ip)
#line 962
{
#line 962
    int err=NC_NOERR;
#line 962
#if SIZEOF_IX_USHORT == SIZEOF_UCHAR && IX_USHORT_MAX == UCHAR_MAX
#line 962
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 962
#else
#line 962
    ix_ushort xx = 0;
#line 962
    get_ix_ushort(xp, &xx);
#line 962

#line 962
#if IX_USHORT_MAX > UCHAR_MAX
#line 962
    if (xx > UCHAR_MAX) {
#line 962
#ifdef ERANGE_FILL
#line 962
        *ip = NC_FILL_UBYTE;
#line 962
        return NC_ERANGE;
#line 962
#else
#line 962
        err = NC_ERANGE;
#line 962
#endif
#line 962
    }
#line 962
#endif
#line 962

#line 962

#line 962
    *ip = (uchar) xx;
#line 962
#endif
#line 962
    return err;
#line 962
}
#line 962

static int
#line 963
ncx_get_ushort_uint(const void *xp, uint *ip)
#line 963
{
#line 963
    int err=NC_NOERR;
#line 963
#if SIZEOF_IX_USHORT == SIZEOF_UINT && IX_USHORT_MAX == UINT_MAX
#line 963
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 963
#else
#line 963
    ix_ushort xx = 0;
#line 963
    get_ix_ushort(xp, &xx);
#line 963

#line 963
#if IX_USHORT_MAX > UINT_MAX
#line 963
    if (xx > UINT_MAX) {
#line 963
#ifdef ERANGE_FILL
#line 963
        *ip = NC_FILL_UINT;
#line 963
        return NC_ERANGE;
#line 963
#else
#line 963
        err = NC_ERANGE;
#line 963
#endif
#line 963
    }
#line 963
#endif
#line 963

#line 963

#line 963
    *ip = (uint) xx;
#line 963
#endif
#line 963
    return err;
#line 963
}
#line 963

static int
#line 964
ncx_get_ushort_ulonglong(const void *xp, ulonglong *ip)
#line 964
{
#line 964
    int err=NC_NOERR;
#line 964
#if SIZEOF_IX_USHORT == SIZEOF_ULONGLONG && IX_USHORT_MAX == ULONGLONG_MAX
#line 964
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 964
#else
#line 964
    ix_ushort xx = 0;
#line 964
    get_ix_ushort(xp, &xx);
#line 964

#line 964
#if IX_USHORT_MAX > ULONGLONG_MAX
#line 964
    if (xx > ULONGLONG_MAX) {
#line 964
#ifdef ERANGE_FILL
#line 964
        *ip = NC_FILL_UINT64;
#line 964
        return NC_ERANGE;
#line 964
#else
#line 964
        err = NC_ERANGE;
#line 964
#endif
#line 964
    }
#line 964
#endif
#line 964

#line 964

#line 964
    *ip = (ulonglong) xx;
#line 964
#endif
#line 964
    return err;
#line 964
}
#line 964

static int
#line 965
ncx_get_ushort_float(const void *xp, float *ip)
#line 965
{
#line 965
	ix_ushort xx = 0;
#line 965
	get_ix_ushort(xp, &xx);
#line 965
	*ip = (float)xx;
#line 965
	return NC_NOERR;
#line 965
}
#line 965

static int
#line 966
ncx_get_ushort_double(const void *xp, double *ip)
#line 966
{
#line 966
	ix_ushort xx = 0;
#line 966
	get_ix_ushort(xp, &xx);
#line 966
	*ip = (double)xx;
#line 966
	return NC_NOERR;
#line 966
}
#line 966


static int
ncx_put_ushort_schar(void *xp, const schar *ip, void *fillp)
{
    int err=NC_NOERR;
    uchar *cp;
    if (*ip < 0) {
#ifdef ERANGE_FILL
        if (fillp != NULL) memcpy(xp, fillp, 2);
#ifndef WORDS_BIGENDIAN
        swapn2b(xp, xp, 1);
#endif
        return NC_ERANGE;
#else
        err = NC_ERANGE;
#endif
    }

    cp = (uchar *) xp;
    if (*ip & 0x80)
        *cp++ = 0xff;
    else
        *cp++ = 0;
    *cp = (uchar)*ip;

    return err;
}

static int
ncx_put_ushort_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0;
	*cp = *ip;
	return NC_NOERR;
}

static int
#line 1004
ncx_put_ushort_short(void *xp, const short *ip, void *fillp)
#line 1004
{
#line 1004
    int err=NC_NOERR;
#line 1004
    ix_ushort xx = NC_FILL_USHORT;
#line 1004

#line 1004
#if IX_USHORT_MAX < SHORT_MAX
#line 1004
    if (*ip > IX_USHORT_MAX) {
#line 1004
        
#line 1004
#ifdef ERANGE_FILL
#line 1004
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1004
#endif
#line 1004
        err = NC_ERANGE;
#line 1004
    }
#line 1004
#ifdef ERANGE_FILL
#line 1004
    else
#line 1004
#endif
#line 1004
#endif
#line 1004
    if (*ip < 0) {
#line 1004
        
#line 1004
#ifdef ERANGE_FILL
#line 1004
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1004
#endif
#line 1004
        err = NC_ERANGE; /* because xp is unsigned */
#line 1004
    }
#line 1004
#ifdef ERANGE_FILL
#line 1004
    else
#line 1004
#endif
#line 1004
        xx = (ix_ushort)*ip;
#line 1004

#line 1004
    put_ix_ushort(xp, &xx);
#line 1004
    return err;
#line 1004
}
#line 1004

static int
#line 1005
ncx_put_ushort_int(void *xp, const int *ip, void *fillp)
#line 1005
{
#line 1005
    int err=NC_NOERR;
#line 1005
    ix_ushort xx = NC_FILL_USHORT;
#line 1005

#line 1005
#if IX_USHORT_MAX < INT_MAX
#line 1005
    if (*ip > IX_USHORT_MAX) {
#line 1005
        
#line 1005
#ifdef ERANGE_FILL
#line 1005
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1005
#endif
#line 1005
        err = NC_ERANGE;
#line 1005
    }
#line 1005
#ifdef ERANGE_FILL
#line 1005
    else
#line 1005
#endif
#line 1005
#endif
#line 1005
    if (*ip < 0) {
#line 1005
        
#line 1005
#ifdef ERANGE_FILL
#line 1005
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1005
#endif
#line 1005
        err = NC_ERANGE; /* because xp is unsigned */
#line 1005
    }
#line 1005
#ifdef ERANGE_FILL
#line 1005
    else
#line 1005
#endif
#line 1005
        xx = (ix_ushort)*ip;
#line 1005

#line 1005
    put_ix_ushort(xp, &xx);
#line 1005
    return err;
#line 1005
}
#line 1005

static int
#line 1006
ncx_put_ushort_long(void *xp, const long *ip, void *fillp)
#line 1006
{
#line 1006
    int err=NC_NOERR;
#line 1006
    ix_ushort xx = NC_FILL_USHORT;
#line 1006

#line 1006
#if IX_USHORT_MAX < LONG_MAX
#line 1006
    if (*ip > IX_USHORT_MAX) {
#line 1006
        
#line 1006
#ifdef ERANGE_FILL
#line 1006
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1006
#endif
#line 1006
        err = NC_ERANGE;
#line 1006
    }
#line 1006
#ifdef ERANGE_FILL
#line 1006
    else
#line 1006
#endif
#line 1006
#endif
#line 1006
    if (*ip < 0) {
#line 1006
        
#line 1006
#ifdef ERANGE_FILL
#line 1006
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1006
#endif
#line 1006
        err = NC_ERANGE; /* because xp is unsigned */
#line 1006
    }
#line 1006
#ifdef ERANGE_FILL
#line 1006
    else
#line 1006
#endif
#line 1006
        xx = (ix_ushort)*ip;
#line 1006

#line 1006
    put_ix_ushort(xp, &xx);
#line 1006
    return err;
#line 1006
}
#line 1006

static int
#line 1007
ncx_put_ushort_longlong(void *xp, const longlong *ip, void *fillp)
#line 1007
{
#line 1007
    int err=NC_NOERR;
#line 1007
    ix_ushort xx = NC_FILL_USHORT;
#line 1007

#line 1007
#if IX_USHORT_MAX < LONGLONG_MAX
#line 1007
    if (*ip > IX_USHORT_MAX) {
#line 1007
        
#line 1007
#ifdef ERANGE_FILL
#line 1007
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1007
#endif
#line 1007
        err = NC_ERANGE;
#line 1007
    }
#line 1007
#ifdef ERANGE_FILL
#line 1007
    else
#line 1007
#endif
#line 1007
#endif
#line 1007
    if (*ip < 0) {
#line 1007
        
#line 1007
#ifdef ERANGE_FILL
#line 1007
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1007
#endif
#line 1007
        err = NC_ERANGE; /* because xp is unsigned */
#line 1007
    }
#line 1007
#ifdef ERANGE_FILL
#line 1007
    else
#line 1007
#endif
#line 1007
        xx = (ix_ushort)*ip;
#line 1007

#line 1007
    put_ix_ushort(xp, &xx);
#line 1007
    return err;
#line 1007
}
#line 1007

static int
#line 1008
ncx_put_ushort_ushort(void *xp, const ushort *ip, void *fillp)
#line 1008
{
#line 1008
    int err=NC_NOERR;
#line 1008
#if SIZEOF_IX_USHORT == SIZEOF_USHORT && IX_USHORT_MAX == USHORT_MAX
#line 1008
    put_ix_ushort(xp, (const ix_ushort *)ip);
#line 1008
#else
#line 1008
    ix_ushort xx = NC_FILL_USHORT;
#line 1008

#line 1008
#if IX_USHORT_MAX < USHORT_MAX
#line 1008
    if (*ip > IX_USHORT_MAX) {
#line 1008
        
#line 1008
#ifdef ERANGE_FILL
#line 1008
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1008
#endif
#line 1008
        err = NC_ERANGE;
#line 1008
    }
#line 1008
#ifdef ERANGE_FILL
#line 1008
    else
#line 1008
#endif
#line 1008
#endif
#line 1008
        xx = (ix_ushort)*ip;
#line 1008

#line 1008
    put_ix_ushort(xp, &xx);
#line 1008
#endif
#line 1008
    return err;
#line 1008
}
#line 1008

static int
#line 1009
ncx_put_ushort_uint(void *xp, const uint *ip, void *fillp)
#line 1009
{
#line 1009
    int err=NC_NOERR;
#line 1009
#if SIZEOF_IX_USHORT == SIZEOF_UINT && IX_USHORT_MAX == UINT_MAX
#line 1009
    put_ix_ushort(xp, (const ix_ushort *)ip);
#line 1009
#else
#line 1009
    ix_ushort xx = NC_FILL_USHORT;
#line 1009

#line 1009
#if IX_USHORT_MAX < UINT_MAX
#line 1009
    if (*ip > IX_USHORT_MAX) {
#line 1009
        
#line 1009
#ifdef ERANGE_FILL
#line 1009
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1009
#endif
#line 1009
        err = NC_ERANGE;
#line 1009
    }
#line 1009
#ifdef ERANGE_FILL
#line 1009
    else
#line 1009
#endif
#line 1009
#endif
#line 1009
        xx = (ix_ushort)*ip;
#line 1009

#line 1009
    put_ix_ushort(xp, &xx);
#line 1009
#endif
#line 1009
    return err;
#line 1009
}
#line 1009

static int
#line 1010
ncx_put_ushort_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1010
{
#line 1010
    int err=NC_NOERR;
#line 1010
#if SIZEOF_IX_USHORT == SIZEOF_ULONGLONG && IX_USHORT_MAX == ULONGLONG_MAX
#line 1010
    put_ix_ushort(xp, (const ix_ushort *)ip);
#line 1010
#else
#line 1010
    ix_ushort xx = NC_FILL_USHORT;
#line 1010

#line 1010
#if IX_USHORT_MAX < ULONGLONG_MAX
#line 1010
    if (*ip > IX_USHORT_MAX) {
#line 1010
        
#line 1010
#ifdef ERANGE_FILL
#line 1010
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1010
#endif
#line 1010
        err = NC_ERANGE;
#line 1010
    }
#line 1010
#ifdef ERANGE_FILL
#line 1010
    else
#line 1010
#endif
#line 1010
#endif
#line 1010
        xx = (ix_ushort)*ip;
#line 1010

#line 1010
    put_ix_ushort(xp, &xx);
#line 1010
#endif
#line 1010
    return err;
#line 1010
}
#line 1010

static int
#line 1011
ncx_put_ushort_float(void *xp, const float *ip, void *fillp)
#line 1011
{
#line 1011
    int err=NC_NOERR;
#line 1011
    ix_ushort xx = NC_FILL_USHORT;
#line 1011

#line 1011
    if (*ip > (double)X_USHORT_MAX || *ip < 0) {
#line 1011
        
#line 1011
#ifdef ERANGE_FILL
#line 1011
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1011
#endif
#line 1011
        err = NC_ERANGE;
#line 1011
    }
#line 1011
#ifdef ERANGE_FILL
#line 1011
    else
#line 1011
#endif
#line 1011
        xx = (ix_ushort)*ip;
#line 1011

#line 1011
    put_ix_ushort(xp, &xx);
#line 1011
    return err;
#line 1011
}
#line 1011

static int
#line 1012
ncx_put_ushort_double(void *xp, const double *ip, void *fillp)
#line 1012
{
#line 1012
    int err=NC_NOERR;
#line 1012
    ix_ushort xx = NC_FILL_USHORT;
#line 1012

#line 1012
    if (*ip > X_USHORT_MAX || *ip < 0) {
#line 1012
        
#line 1012
#ifdef ERANGE_FILL
#line 1012
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1012
#endif
#line 1012
        err = NC_ERANGE;
#line 1012
    }
#line 1012
#ifdef ERANGE_FILL
#line 1012
    else
#line 1012
#endif
#line 1012
        xx = (ix_ushort)*ip;
#line 1012

#line 1012
    put_ix_ushort(xp, &xx);
#line 1012
    return err;
#line 1012
}
#line 1012


/* external NC_INT ----------------------------------------------------------*/

#if SHORT_MAX == X_INT_MAX
typedef short ix_int;
#define SIZEOF_IX_INT SIZEOF_SHORT
#define IX_INT_MAX SHORT_MAX
#elif INT_MAX  >= X_INT_MAX
typedef int ix_int;
#define SIZEOF_IX_INT SIZEOF_INT
#define IX_INT_MAX INT_MAX
#elif LONG_MAX  >= X_INT_MAX
typedef long ix_int;
#define SIZEOF_IX_INT SIZEOF_LONG
#define IX_INT_MAX LONG_MAX
#else
#error "ix_int implementation"
#endif


static void
get_ix_int(const void *xp, ix_int *ip)
{
	const uchar *cp = (const uchar *) xp;

#if INT_MAX  >= X_INT_MAX
	*ip = (ix_int)((unsigned)(*cp++) << 24);
#else
	*ip = *cp++ << 24;
#endif
#if SIZEOF_IX_INT > X_SIZEOF_INT
	if (*ip & 0x80000000)
	{
		/* extern is negative */
		*ip |= (~(0xffffffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip |= (*cp++ << 16);
	*ip |= (*cp++ << 8);
	*ip |= *cp;
}

static void
put_ix_int(void *xp, const ix_int *ip)
{
	uchar *cp = (uchar *) xp;

	*cp++ = (uchar)( (*ip) >> 24);
	*cp++ = (uchar)(((*ip) & 0x00ff0000) >> 16);
	*cp++ = (uchar)(((*ip) & 0x0000ff00) >>  8);
	*cp   = (uchar)( (*ip) & 0x000000ff);
}

#if X_SIZEOF_INT != SIZEOF_INT
static int
#line 1067
ncx_get_int_int(const void *xp, int *ip)
#line 1067
{
#line 1067
    int err=NC_NOERR;
#line 1067
#if SIZEOF_IX_INT == SIZEOF_INT && IX_INT_MAX == INT_MAX
#line 1067
    get_ix_int(xp, (ix_int *)ip);
#line 1067
#else
#line 1067
    ix_int xx = 0;
#line 1067
    get_ix_int(xp, &xx);
#line 1067

#line 1067
#if IX_INT_MAX > INT_MAX
#line 1067
    if (xx > INT_MAX || xx < INT_MIN) {
#line 1067
#ifdef ERANGE_FILL
#line 1067
        *ip = NC_FILL_INT;
#line 1067
        return NC_ERANGE;
#line 1067
#else
#line 1067
        err = NC_ERANGE;
#line 1067
#endif
#line 1067
    }
#line 1067
#endif
#line 1067

#line 1067

#line 1067
    *ip = (int) xx;
#line 1067
#endif
#line 1067
    return err;
#line 1067
}
#line 1067

#endif
static int
#line 1069
ncx_get_int_schar(const void *xp, schar *ip)
#line 1069
{
#line 1069
    int err=NC_NOERR;
#line 1069
    ix_int xx = 0;
#line 1069
    get_ix_int(xp, &xx);
#line 1069

#line 1069
#if IX_INT_MAX > SCHAR_MAX
#line 1069
    if (xx > SCHAR_MAX || xx < SCHAR_MIN) {
#line 1069
#ifdef ERANGE_FILL
#line 1069
        *ip = NC_FILL_BYTE;
#line 1069
        return NC_ERANGE;
#line 1069
#else
#line 1069
        err = NC_ERANGE;
#line 1069
#endif
#line 1069
    }
#line 1069
#endif
#line 1069

#line 1069

#line 1069
    *ip = (schar) xx;
#line 1069
    return err;
#line 1069
}
#line 1069

static int
#line 1070
ncx_get_int_short(const void *xp, short *ip)
#line 1070
{
#line 1070
    int err=NC_NOERR;
#line 1070
#if SIZEOF_IX_INT == SIZEOF_SHORT && IX_INT_MAX == SHORT_MAX
#line 1070
    get_ix_int(xp, (ix_int *)ip);
#line 1070
#else
#line 1070
    ix_int xx = 0;
#line 1070
    get_ix_int(xp, &xx);
#line 1070

#line 1070
#if IX_INT_MAX > SHORT_MAX
#line 1070
    if (xx > SHORT_MAX || xx < SHORT_MIN) {
#line 1070
#ifdef ERANGE_FILL
#line 1070
        *ip = NC_FILL_SHORT;
#line 1070
        return NC_ERANGE;
#line 1070
#else
#line 1070
        err = NC_ERANGE;
#line 1070
#endif
#line 1070
    }
#line 1070
#endif
#line 1070

#line 1070

#line 1070
    *ip = (short) xx;
#line 1070
#endif
#line 1070
    return err;
#line 1070
}
#line 1070

static int
#line 1071
ncx_get_int_long(const void *xp, long *ip)
#line 1071
{
#line 1071
    int err=NC_NOERR;
#line 1071
#if SIZEOF_IX_INT == SIZEOF_LONG && IX_INT_MAX == LONG_MAX
#line 1071
    get_ix_int(xp, (ix_int *)ip);
#line 1071
#else
#line 1071
    ix_int xx = 0;
#line 1071
    get_ix_int(xp, &xx);
#line 1071

#line 1071
#if IX_INT_MAX > LONG_MAX
#line 1071
    if (xx > LONG_MAX || xx < LONG_MIN) {
#line 1071
#ifdef ERANGE_FILL
#line 1071
        *ip = NC_FILL_INT;
#line 1071
        return NC_ERANGE;
#line 1071
#else
#line 1071
        err = NC_ERANGE;
#line 1071
#endif
#line 1071
    }
#line 1071
#endif
#line 1071

#line 1071

#line 1071
    *ip = (long) xx;
#line 1071
#endif
#line 1071
    return err;
#line 1071
}
#line 1071

static int
#line 1072
ncx_get_int_longlong(const void *xp, longlong *ip)
#line 1072
{
#line 1072
    int err=NC_NOERR;
#line 1072
#if SIZEOF_IX_INT == SIZEOF_LONGLONG && IX_INT_MAX == LONGLONG_MAX
#line 1072
    get_ix_int(xp, (ix_int *)ip);
#line 1072
#else
#line 1072
    ix_int xx = 0;
#line 1072
    get_ix_int(xp, &xx);
#line 1072

#line 1072
#if IX_INT_MAX > LONGLONG_MAX
#line 1072
    if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) {
#line 1072
#ifdef ERANGE_FILL
#line 1072
        *ip = NC_FILL_INT64;
#line 1072
        return NC_ERANGE;
#line 1072
#else
#line 1072
        err = NC_ERANGE;
#line 1072
#endif
#line 1072
    }
#line 1072
#endif
#line 1072

#line 1072

#line 1072
    *ip = (longlong) xx;
#line 1072
#endif
#line 1072
    return err;
#line 1072
}
#line 1072

static int
#line 1073
ncx_get_int_ushort(const void *xp, ushort *ip)
#line 1073
{
#line 1073
    int err=NC_NOERR;
#line 1073
    ix_int xx = 0;
#line 1073
    get_ix_int(xp, &xx);
#line 1073

#line 1073
#if IX_INT_MAX > USHORT_MAX
#line 1073
    if (xx > USHORT_MAX) {
#line 1073
#ifdef ERANGE_FILL
#line 1073
        *ip = NC_FILL_USHORT;
#line 1073
        return NC_ERANGE;
#line 1073
#else
#line 1073
        err = NC_ERANGE;
#line 1073
#endif
#line 1073
    }
#line 1073
#endif
#line 1073

#line 1073
    if (xx < 0) {
#line 1073
#ifdef ERANGE_FILL
#line 1073
        *ip = NC_FILL_USHORT;
#line 1073
        return NC_ERANGE;
#line 1073
#else
#line 1073
        err = NC_ERANGE; /* because ip is unsigned */
#line 1073
#endif
#line 1073
    }
#line 1073
    *ip = (ushort) xx;
#line 1073
    return err;
#line 1073
}
#line 1073

static int
#line 1074
ncx_get_int_uchar(const void *xp, uchar *ip)
#line 1074
{
#line 1074
    int err=NC_NOERR;
#line 1074
    ix_int xx = 0;
#line 1074
    get_ix_int(xp, &xx);
#line 1074

#line 1074
#if IX_INT_MAX > UCHAR_MAX
#line 1074
    if (xx > UCHAR_MAX) {
#line 1074
#ifdef ERANGE_FILL
#line 1074
        *ip = NC_FILL_UBYTE;
#line 1074
        return NC_ERANGE;
#line 1074
#else
#line 1074
        err = NC_ERANGE;
#line 1074
#endif
#line 1074
    }
#line 1074
#endif
#line 1074

#line 1074
    if (xx < 0) {
#line 1074
#ifdef ERANGE_FILL
#line 1074
        *ip = NC_FILL_UBYTE;
#line 1074
        return NC_ERANGE;
#line 1074
#else
#line 1074
        err = NC_ERANGE; /* because ip is unsigned */
#line 1074
#endif
#line 1074
    }
#line 1074
    *ip = (uchar) xx;
#line 1074
    return err;
#line 1074
}
#line 1074

static int
#line 1075
ncx_get_int_uint(const void *xp, uint *ip)
#line 1075
{
#line 1075
    int err=NC_NOERR;
#line 1075
    ix_int xx = 0;
#line 1075
    get_ix_int(xp, &xx);
#line 1075

#line 1075
#if IX_INT_MAX > UINT_MAX
#line 1075
    if (xx > UINT_MAX) {
#line 1075
#ifdef ERANGE_FILL
#line 1075
        *ip = NC_FILL_UINT;
#line 1075
        return NC_ERANGE;
#line 1075
#else
#line 1075
        err = NC_ERANGE;
#line 1075
#endif
#line 1075
    }
#line 1075
#endif
#line 1075

#line 1075
    if (xx < 0) {
#line 1075
#ifdef ERANGE_FILL
#line 1075
        *ip = NC_FILL_UINT;
#line 1075
        return NC_ERANGE;
#line 1075
#else
#line 1075
        err = NC_ERANGE; /* because ip is unsigned */
#line 1075
#endif
#line 1075
    }
#line 1075
    *ip = (uint) xx;
#line 1075
    return err;
#line 1075
}
#line 1075

static int
#line 1076
ncx_get_int_ulonglong(const void *xp, ulonglong *ip)
#line 1076
{
#line 1076
    int err=NC_NOERR;
#line 1076
    ix_int xx = 0;
#line 1076
    get_ix_int(xp, &xx);
#line 1076

#line 1076
#if IX_INT_MAX > ULONGLONG_MAX
#line 1076
    if (xx > ULONGLONG_MAX) {
#line 1076
#ifdef ERANGE_FILL
#line 1076
        *ip = NC_FILL_UINT64;
#line 1076
        return NC_ERANGE;
#line 1076
#else
#line 1076
        err = NC_ERANGE;
#line 1076
#endif
#line 1076
    }
#line 1076
#endif
#line 1076

#line 1076
    if (xx < 0) {
#line 1076
#ifdef ERANGE_FILL
#line 1076
        *ip = NC_FILL_UINT64;
#line 1076
        return NC_ERANGE;
#line 1076
#else
#line 1076
        err = NC_ERANGE; /* because ip is unsigned */
#line 1076
#endif
#line 1076
    }
#line 1076
    *ip = (ulonglong) xx;
#line 1076
    return err;
#line 1076
}
#line 1076

static int
#line 1077
ncx_get_int_float(const void *xp, float *ip)
#line 1077
{
#line 1077
	ix_int xx = 0;
#line 1077
	get_ix_int(xp, &xx);
#line 1077
	*ip = (float)xx;
#line 1077
	return NC_NOERR;
#line 1077
}
#line 1077

static int
#line 1078
ncx_get_int_double(const void *xp, double *ip)
#line 1078
{
#line 1078
	ix_int xx = 0;
#line 1078
	get_ix_int(xp, &xx);
#line 1078
	*ip = (double)xx;
#line 1078
	return NC_NOERR;
#line 1078
}
#line 1078


static int
ncx_put_int_schar(void *xp, const schar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	if (*ip & 0x80)
	{
		*cp++ = 0xff;
		*cp++ = 0xff;
		*cp++ = 0xff;
	}
	else
	{
		*cp++ = 0x00;
		*cp++ = 0x00;
		*cp++ = 0x00;
	}
	*cp = (uchar)*ip;
	return NC_NOERR;
}

static int
ncx_put_int_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp   = *ip;
	return NC_NOERR;
}

#if X_SIZEOF_INT != SIZEOF_INT
static int
#line 1112
ncx_put_int_int(void *xp, const int *ip, void *fillp)
#line 1112
{
#line 1112
    int err=NC_NOERR;
#line 1112
#if SIZEOF_IX_INT == SIZEOF_INT && IX_INT_MAX == INT_MAX
#line 1112
    put_ix_int(xp, (const ix_int *)ip);
#line 1112
#else
#line 1112
    ix_int xx = NC_FILL_INT;
#line 1112

#line 1112
#if IX_INT_MAX < INT_MAX
#line 1112
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 1112
        
#line 1112
#ifdef ERANGE_FILL
#line 1112
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1112
#endif
#line 1112
        err = NC_ERANGE;
#line 1112
    }
#line 1112
#ifdef ERANGE_FILL
#line 1112
    else
#line 1112
#endif
#line 1112
#endif
#line 1112
        xx = (ix_int)*ip;
#line 1112

#line 1112
    put_ix_int(xp, &xx);
#line 1112
#endif
#line 1112
    return err;
#line 1112
}
#line 1112

#endif
static int
#line 1114
ncx_put_int_short(void *xp, const short *ip, void *fillp)
#line 1114
{
#line 1114
    int err=NC_NOERR;
#line 1114
#if SIZEOF_IX_INT == SIZEOF_SHORT && IX_INT_MAX == SHORT_MAX
#line 1114
    put_ix_int(xp, (const ix_int *)ip);
#line 1114
#else
#line 1114
    ix_int xx = NC_FILL_INT;
#line 1114

#line 1114
#if IX_INT_MAX < SHORT_MAX
#line 1114
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 1114
        
#line 1114
#ifdef ERANGE_FILL
#line 1114
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1114
#endif
#line 1114
        err = NC_ERANGE;
#line 1114
    }
#line 1114
#ifdef ERANGE_FILL
#line 1114
    else
#line 1114
#endif
#line 1114
#endif
#line 1114
        xx = (ix_int)*ip;
#line 1114

#line 1114
    put_ix_int(xp, &xx);
#line 1114
#endif
#line 1114
    return err;
#line 1114
}
#line 1114

static int
#line 1115
ncx_put_int_long(void *xp, const long *ip, void *fillp)
#line 1115
{
#line 1115
    int err=NC_NOERR;
#line 1115
#if SIZEOF_IX_INT == SIZEOF_LONG && IX_INT_MAX == LONG_MAX
#line 1115
    put_ix_int(xp, (const ix_int *)ip);
#line 1115
#else
#line 1115
    ix_int xx = NC_FILL_INT;
#line 1115

#line 1115
#if IX_INT_MAX < LONG_MAX
#line 1115
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 1115
        
#line 1115
#ifdef ERANGE_FILL
#line 1115
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1115
#endif
#line 1115
        err = NC_ERANGE;
#line 1115
    }
#line 1115
#ifdef ERANGE_FILL
#line 1115
    else
#line 1115
#endif
#line 1115
#endif
#line 1115
        xx = (ix_int)*ip;
#line 1115

#line 1115
    put_ix_int(xp, &xx);
#line 1115
#endif
#line 1115
    return err;
#line 1115
}
#line 1115

static int
#line 1116
ncx_put_int_longlong(void *xp, const longlong *ip, void *fillp)
#line 1116
{
#line 1116
    int err=NC_NOERR;
#line 1116
#if SIZEOF_IX_INT == SIZEOF_LONGLONG && IX_INT_MAX == LONGLONG_MAX
#line 1116
    put_ix_int(xp, (const ix_int *)ip);
#line 1116
#else
#line 1116
    ix_int xx = NC_FILL_INT;
#line 1116

#line 1116
#if IX_INT_MAX < LONGLONG_MAX
#line 1116
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 1116
        
#line 1116
#ifdef ERANGE_FILL
#line 1116
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1116
#endif
#line 1116
        err = NC_ERANGE;
#line 1116
    }
#line 1116
#ifdef ERANGE_FILL
#line 1116
    else
#line 1116
#endif
#line 1116
#endif
#line 1116
        xx = (ix_int)*ip;
#line 1116

#line 1116
    put_ix_int(xp, &xx);
#line 1116
#endif
#line 1116
    return err;
#line 1116
}
#line 1116

static int
#line 1117
ncx_put_int_ushort(void *xp, const ushort *ip, void *fillp)
#line 1117
{
#line 1117
    int err=NC_NOERR;
#line 1117
    ix_int xx = NC_FILL_INT;
#line 1117

#line 1117
#if IX_INT_MAX < USHORT_MAX
#line 1117
    if (*ip > IX_INT_MAX) {
#line 1117
        
#line 1117
#ifdef ERANGE_FILL
#line 1117
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1117
#endif
#line 1117
        err = NC_ERANGE;
#line 1117
    }
#line 1117
#ifdef ERANGE_FILL
#line 1117
    else
#line 1117
#endif
#line 1117
#endif
#line 1117
        xx = (ix_int)*ip;
#line 1117

#line 1117
    put_ix_int(xp, &xx);
#line 1117
    return err;
#line 1117
}
#line 1117

static int
#line 1118
ncx_put_int_uint(void *xp, const uint *ip, void *fillp)
#line 1118
{
#line 1118
    int err=NC_NOERR;
#line 1118
    ix_int xx = NC_FILL_INT;
#line 1118

#line 1118
#if IX_INT_MAX < UINT_MAX
#line 1118
    if (*ip > IX_INT_MAX) {
#line 1118
        
#line 1118
#ifdef ERANGE_FILL
#line 1118
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1118
#endif
#line 1118
        err = NC_ERANGE;
#line 1118
    }
#line 1118
#ifdef ERANGE_FILL
#line 1118
    else
#line 1118
#endif
#line 1118
#endif
#line 1118
        xx = (ix_int)*ip;
#line 1118

#line 1118
    put_ix_int(xp, &xx);
#line 1118
    return err;
#line 1118
}
#line 1118

static int
#line 1119
ncx_put_int_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1119
{
#line 1119
    int err=NC_NOERR;
#line 1119
    ix_int xx = NC_FILL_INT;
#line 1119

#line 1119
#if IX_INT_MAX < ULONGLONG_MAX
#line 1119
    if (*ip > IX_INT_MAX) {
#line 1119
        
#line 1119
#ifdef ERANGE_FILL
#line 1119
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1119
#endif
#line 1119
        err = NC_ERANGE;
#line 1119
    }
#line 1119
#ifdef ERANGE_FILL
#line 1119
    else
#line 1119
#endif
#line 1119
#endif
#line 1119
        xx = (ix_int)*ip;
#line 1119

#line 1119
    put_ix_int(xp, &xx);
#line 1119
    return err;
#line 1119
}
#line 1119

static int
#line 1120
ncx_put_int_float(void *xp, const float *ip, void *fillp)
#line 1120
{
#line 1120
    int err=NC_NOERR;
#line 1120
    ix_int xx = NC_FILL_INT;
#line 1120

#line 1120
    if (*ip > (double)X_INT_MAX || *ip < (double)X_INT_MIN) {
#line 1120
        
#line 1120
#ifdef ERANGE_FILL
#line 1120
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1120
#endif
#line 1120
        err = NC_ERANGE;
#line 1120
    }
#line 1120
#ifdef ERANGE_FILL
#line 1120
    else
#line 1120
#endif
#line 1120
        xx = (ix_int)*ip;
#line 1120

#line 1120
    put_ix_int(xp, &xx);
#line 1120
    return err;
#line 1120
}
#line 1120

static int
#line 1121
ncx_put_int_double(void *xp, const double *ip, void *fillp)
#line 1121
{
#line 1121
    int err=NC_NOERR;
#line 1121
    ix_int xx = NC_FILL_INT;
#line 1121

#line 1121
    if (*ip > X_INT_MAX || *ip < X_INT_MIN) {
#line 1121
        
#line 1121
#ifdef ERANGE_FILL
#line 1121
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1121
#endif
#line 1121
        err = NC_ERANGE;
#line 1121
    }
#line 1121
#ifdef ERANGE_FILL
#line 1121
    else
#line 1121
#endif
#line 1121
        xx = (ix_int)*ip;
#line 1121

#line 1121
    put_ix_int(xp, &xx);
#line 1121
    return err;
#line 1121
}
#line 1121



/* external NC_UINT ---------------------------------------------------------*/

#if USHORT_MAX == X_UINT_MAX
typedef ushort ix_uint;
#define SIZEOF_IX_UINT SIZEOF_USHORT
#define IX_UINT_MAX USHORT_MAX
#elif UINT_MAX  >= X_UINT_MAX
typedef uint ix_uint;
#define SIZEOF_IX_UINT SIZEOF_UINT
#define IX_UINT_MAX UINT_MAX
#elif ULONG_MAX  >= X_UINT_MAX
typedef ulong ix_uint;
#define SIZEOF_IX_UINT SIZEOF_ULONG
#define IX_UINT_MAX ULONG_MAX
#else
#error "ix_uint implementation"
#endif


static void
get_ix_uint(const void *xp, ix_uint *ip)
{
	const uchar *cp = (const uchar *) xp;

	*ip = (ix_uint)(*cp++ << 24);
	*ip = (ix_uint)(*ip | (ix_uint)(*cp++ << 16));
	*ip = (ix_uint)(*ip | (ix_uint)(*cp++ << 8));
	*ip = (ix_uint)(*ip | *cp);
}

static void
put_ix_uint(void *xp, const ix_uint *ip)
{
	uchar *cp = (uchar *) xp;

	*cp++ = (uchar)((*ip) >> 24);
	*cp++ = (uchar)(((*ip) & 0x00ff0000) >> 16);
	*cp++ = (uchar)(((*ip) & 0x0000ff00) >>  8);
	*cp   = (uchar)( (*ip) & 0x000000ff);
}

#if X_SIZEOF_UINT != SIZEOF_UINT
static int
#line 1166
ncx_get_uint_uint(const void *xp, uint *ip)
#line 1166
{
#line 1166
    int err=NC_NOERR;
#line 1166
#if SIZEOF_IX_UINT == SIZEOF_UINT && IX_UINT_MAX == UINT_MAX
#line 1166
    get_ix_uint(xp, (ix_uint *)ip);
#line 1166
#else
#line 1166
    ix_uint xx = 0;
#line 1166
    get_ix_uint(xp, &xx);
#line 1166

#line 1166
#if IX_UINT_MAX > UINT_MAX
#line 1166
    if (xx > UINT_MAX) {
#line 1166
#ifdef ERANGE_FILL
#line 1166
        *ip = NC_FILL_UINT;
#line 1166
        return NC_ERANGE;
#line 1166
#else
#line 1166
        err = NC_ERANGE;
#line 1166
#endif
#line 1166
    }
#line 1166
#endif
#line 1166

#line 1166

#line 1166
    *ip = (uint) xx;
#line 1166
#endif
#line 1166
    return err;
#line 1166
}
#line 1166

#endif

static int
#line 1169
ncx_get_uint_schar(const void *xp, schar *ip)
#line 1169
{
#line 1169
    int err=NC_NOERR;
#line 1169
    ix_uint xx = 0;
#line 1169
    get_ix_uint(xp, &xx);
#line 1169

#line 1169
#if IX_UINT_MAX > SCHAR_MAX
#line 1169
    if (xx > SCHAR_MAX) {
#line 1169
#ifdef ERANGE_FILL
#line 1169
        *ip = NC_FILL_BYTE;
#line 1169
        return NC_ERANGE;
#line 1169
#else
#line 1169
        err = NC_ERANGE;
#line 1169
#endif
#line 1169
    }
#line 1169
#endif
#line 1169

#line 1169

#line 1169
    *ip = (schar) xx;
#line 1169
    return err;
#line 1169
}
#line 1169

static int
#line 1170
ncx_get_uint_short(const void *xp, short *ip)
#line 1170
{
#line 1170
    int err=NC_NOERR;
#line 1170
    ix_uint xx = 0;
#line 1170
    get_ix_uint(xp, &xx);
#line 1170

#line 1170
#if IX_UINT_MAX > SHORT_MAX
#line 1170
    if (xx > SHORT_MAX) {
#line 1170
#ifdef ERANGE_FILL
#line 1170
        *ip = NC_FILL_SHORT;
#line 1170
        return NC_ERANGE;
#line 1170
#else
#line 1170
        err = NC_ERANGE;
#line 1170
#endif
#line 1170
    }
#line 1170
#endif
#line 1170

#line 1170

#line 1170
    *ip = (short) xx;
#line 1170
    return err;
#line 1170
}
#line 1170

static int
#line 1171
ncx_get_uint_int(const void *xp, int *ip)
#line 1171
{
#line 1171
    int err=NC_NOERR;
#line 1171
    ix_uint xx = 0;
#line 1171
    get_ix_uint(xp, &xx);
#line 1171

#line 1171
#if IX_UINT_MAX > INT_MAX
#line 1171
    if (xx > INT_MAX) {
#line 1171
#ifdef ERANGE_FILL
#line 1171
        *ip = NC_FILL_INT;
#line 1171
        return NC_ERANGE;
#line 1171
#else
#line 1171
        err = NC_ERANGE;
#line 1171
#endif
#line 1171
    }
#line 1171
#endif
#line 1171

#line 1171

#line 1171
    *ip = (int) xx;
#line 1171
    return err;
#line 1171
}
#line 1171

static int
#line 1172
ncx_get_uint_long(const void *xp, long *ip)
#line 1172
{
#line 1172
    int err=NC_NOERR;
#line 1172
    ix_uint xx = 0;
#line 1172
    get_ix_uint(xp, &xx);
#line 1172

#line 1172
#if IX_UINT_MAX > LONG_MAX
#line 1172
    if (xx > LONG_MAX) {
#line 1172
#ifdef ERANGE_FILL
#line 1172
        *ip = NC_FILL_INT;
#line 1172
        return NC_ERANGE;
#line 1172
#else
#line 1172
        err = NC_ERANGE;
#line 1172
#endif
#line 1172
    }
#line 1172
#endif
#line 1172

#line 1172

#line 1172
    *ip = (long) xx;
#line 1172
    return err;
#line 1172
}
#line 1172

static int
#line 1173
ncx_get_uint_longlong(const void *xp, longlong *ip)
#line 1173
{
#line 1173
    int err=NC_NOERR;
#line 1173
    ix_uint xx = 0;
#line 1173
    get_ix_uint(xp, &xx);
#line 1173

#line 1173
#if IX_UINT_MAX > LONGLONG_MAX
#line 1173
    if (xx > LONGLONG_MAX) {
#line 1173
#ifdef ERANGE_FILL
#line 1173
        *ip = NC_FILL_INT64;
#line 1173
        return NC_ERANGE;
#line 1173
#else
#line 1173
        err = NC_ERANGE;
#line 1173
#endif
#line 1173
    }
#line 1173
#endif
#line 1173

#line 1173

#line 1173
    *ip = (longlong) xx;
#line 1173
    return err;
#line 1173
}
#line 1173

static int
#line 1174
ncx_get_uint_ushort(const void *xp, ushort *ip)
#line 1174
{
#line 1174
    int err=NC_NOERR;
#line 1174
#if SIZEOF_IX_UINT == SIZEOF_USHORT && IX_UINT_MAX == USHORT_MAX
#line 1174
    get_ix_uint(xp, (ix_uint *)ip);
#line 1174
#else
#line 1174
    ix_uint xx = 0;
#line 1174
    get_ix_uint(xp, &xx);
#line 1174

#line 1174
#if IX_UINT_MAX > USHORT_MAX
#line 1174
    if (xx > USHORT_MAX) {
#line 1174
#ifdef ERANGE_FILL
#line 1174
        *ip = NC_FILL_USHORT;
#line 1174
        return NC_ERANGE;
#line 1174
#else
#line 1174
        err = NC_ERANGE;
#line 1174
#endif
#line 1174
    }
#line 1174
#endif
#line 1174

#line 1174

#line 1174
    *ip = (ushort) xx;
#line 1174
#endif
#line 1174
    return err;
#line 1174
}
#line 1174

static int
#line 1175
ncx_get_uint_uchar(const void *xp, uchar *ip)
#line 1175
{
#line 1175
    int err=NC_NOERR;
#line 1175
#if SIZEOF_IX_UINT == SIZEOF_UCHAR && IX_UINT_MAX == UCHAR_MAX
#line 1175
    get_ix_uint(xp, (ix_uint *)ip);
#line 1175
#else
#line 1175
    ix_uint xx = 0;
#line 1175
    get_ix_uint(xp, &xx);
#line 1175

#line 1175
#if IX_UINT_MAX > UCHAR_MAX
#line 1175
    if (xx > UCHAR_MAX) {
#line 1175
#ifdef ERANGE_FILL
#line 1175
        *ip = NC_FILL_UBYTE;
#line 1175
        return NC_ERANGE;
#line 1175
#else
#line 1175
        err = NC_ERANGE;
#line 1175
#endif
#line 1175
    }
#line 1175
#endif
#line 1175

#line 1175

#line 1175
    *ip = (uchar) xx;
#line 1175
#endif
#line 1175
    return err;
#line 1175
}
#line 1175

static int
#line 1176
ncx_get_uint_ulonglong(const void *xp, ulonglong *ip)
#line 1176
{
#line 1176
    int err=NC_NOERR;
#line 1176
#if SIZEOF_IX_UINT == SIZEOF_ULONGLONG && IX_UINT_MAX == ULONGLONG_MAX
#line 1176
    get_ix_uint(xp, (ix_uint *)ip);
#line 1176
#else
#line 1176
    ix_uint xx = 0;
#line 1176
    get_ix_uint(xp, &xx);
#line 1176

#line 1176
#if IX_UINT_MAX > ULONGLONG_MAX
#line 1176
    if (xx > ULONGLONG_MAX) {
#line 1176
#ifdef ERANGE_FILL
#line 1176
        *ip = NC_FILL_UINT64;
#line 1176
        return NC_ERANGE;
#line 1176
#else
#line 1176
        err = NC_ERANGE;
#line 1176
#endif
#line 1176
    }
#line 1176
#endif
#line 1176

#line 1176

#line 1176
    *ip = (ulonglong) xx;
#line 1176
#endif
#line 1176
    return err;
#line 1176
}
#line 1176

static int
#line 1177
ncx_get_uint_float(const void *xp, float *ip)
#line 1177
{
#line 1177
	ix_uint xx = 0;
#line 1177
	get_ix_uint(xp, &xx);
#line 1177
	*ip = (float)xx;
#line 1177
	return NC_NOERR;
#line 1177
}
#line 1177

static int
#line 1178
ncx_get_uint_double(const void *xp, double *ip)
#line 1178
{
#line 1178
	ix_uint xx = 0;
#line 1178
	get_ix_uint(xp, &xx);
#line 1178
	*ip = (double)xx;
#line 1178
	return NC_NOERR;
#line 1178
}
#line 1178


static int
ncx_put_uint_schar(void *xp, const schar *ip, void *fillp)
{
    uchar *cp;
    if (*ip < 0) {
#ifdef ERANGE_FILL
        if (fillp != NULL) memcpy(xp, fillp, 4);
#ifndef WORDS_BIGENDIAN
        swapn4b(xp, xp, 1);
#endif
#endif
        return NC_ERANGE;
    }

    cp = (uchar *) xp;
    *cp++ = 0x00;
    *cp++ = 0x00;
    *cp++ = 0x00;
    *cp = (uchar)*ip;

    return NC_NOERR;
}

static int
ncx_put_uint_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp   = *ip;
	return NC_NOERR;
}

#if X_SIZEOF_UINT != SIZEOF_UINT
static int
#line 1215
ncx_put_uint_uint(void *xp, const uint *ip, void *fillp)
#line 1215
{
#line 1215
    int err=NC_NOERR;
#line 1215
#if SIZEOF_IX_UINT == SIZEOF_UINT && IX_UINT_MAX == UINT_MAX
#line 1215
    put_ix_uint(xp, (const ix_uint *)ip);
#line 1215
#else
#line 1215
    ix_uint xx = NC_FILL_UINT;
#line 1215

#line 1215
#if IX_UINT_MAX < UINT_MAX
#line 1215
    if (*ip > IX_UINT_MAX) {
#line 1215
        
#line 1215
#ifdef ERANGE_FILL
#line 1215
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1215
#endif
#line 1215
        err = NC_ERANGE;
#line 1215
    }
#line 1215
#ifdef ERANGE_FILL
#line 1215
    else
#line 1215
#endif
#line 1215
#endif
#line 1215
        xx = (ix_uint)*ip;
#line 1215

#line 1215
    put_ix_uint(xp, &xx);
#line 1215
#endif
#line 1215
    return err;
#line 1215
}
#line 1215

#endif

static int
#line 1218
ncx_put_uint_short(void *xp, const short *ip, void *fillp)
#line 1218
{
#line 1218
    int err=NC_NOERR;
#line 1218
    ix_uint xx = NC_FILL_UINT;
#line 1218

#line 1218
#if IX_UINT_MAX < SHORT_MAX
#line 1218
    if (*ip > IX_UINT_MAX) {
#line 1218
        
#line 1218
#ifdef ERANGE_FILL
#line 1218
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1218
#endif
#line 1218
        err = NC_ERANGE;
#line 1218
    }
#line 1218
#ifdef ERANGE_FILL
#line 1218
    else
#line 1218
#endif
#line 1218
#endif
#line 1218
    if (*ip < 0) {
#line 1218
        
#line 1218
#ifdef ERANGE_FILL
#line 1218
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1218
#endif
#line 1218
        err = NC_ERANGE; /* because xp is unsigned */
#line 1218
    }
#line 1218
#ifdef ERANGE_FILL
#line 1218
    else
#line 1218
#endif
#line 1218
        xx = (ix_uint)*ip;
#line 1218

#line 1218
    put_ix_uint(xp, &xx);
#line 1218
    return err;
#line 1218
}
#line 1218

static int
#line 1219
ncx_put_uint_int(void *xp, const int *ip, void *fillp)
#line 1219
{
#line 1219
    int err=NC_NOERR;
#line 1219
    ix_uint xx = NC_FILL_UINT;
#line 1219

#line 1219
#if IX_UINT_MAX < INT_MAX
#line 1219
    if (*ip > IX_UINT_MAX) {
#line 1219
        
#line 1219
#ifdef ERANGE_FILL
#line 1219
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1219
#endif
#line 1219
        err = NC_ERANGE;
#line 1219
    }
#line 1219
#ifdef ERANGE_FILL
#line 1219
    else
#line 1219
#endif
#line 1219
#endif
#line 1219
    if (*ip < 0) {
#line 1219
        
#line 1219
#ifdef ERANGE_FILL
#line 1219
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1219
#endif
#line 1219
        err = NC_ERANGE; /* because xp is unsigned */
#line 1219
    }
#line 1219
#ifdef ERANGE_FILL
#line 1219
    else
#line 1219
#endif
#line 1219
        xx = (ix_uint)*ip;
#line 1219

#line 1219
    put_ix_uint(xp, &xx);
#line 1219
    return err;
#line 1219
}
#line 1219

static int
#line 1220
ncx_put_uint_long(void *xp, const long *ip, void *fillp)
#line 1220
{
#line 1220
    int err=NC_NOERR;
#line 1220
    ix_uint xx = NC_FILL_UINT;
#line 1220

#line 1220
#if IX_UINT_MAX < LONG_MAX
#line 1220
    if (*ip > IX_UINT_MAX) {
#line 1220
        
#line 1220
#ifdef ERANGE_FILL
#line 1220
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1220
#endif
#line 1220
        err = NC_ERANGE;
#line 1220
    }
#line 1220
#ifdef ERANGE_FILL
#line 1220
    else
#line 1220
#endif
#line 1220
#endif
#line 1220
    if (*ip < 0) {
#line 1220
        
#line 1220
#ifdef ERANGE_FILL
#line 1220
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1220
#endif
#line 1220
        err = NC_ERANGE; /* because xp is unsigned */
#line 1220
    }
#line 1220
#ifdef ERANGE_FILL
#line 1220
    else
#line 1220
#endif
#line 1220
        xx = (ix_uint)*ip;
#line 1220

#line 1220
    put_ix_uint(xp, &xx);
#line 1220
    return err;
#line 1220
}
#line 1220

static int
#line 1221
ncx_put_uint_longlong(void *xp, const longlong *ip, void *fillp)
#line 1221
{
#line 1221
    int err=NC_NOERR;
#line 1221
    ix_uint xx = NC_FILL_UINT;
#line 1221

#line 1221
#if IX_UINT_MAX < LONGLONG_MAX
#line 1221
    if (*ip > IX_UINT_MAX) {
#line 1221
        
#line 1221
#ifdef ERANGE_FILL
#line 1221
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1221
#endif
#line 1221
        err = NC_ERANGE;
#line 1221
    }
#line 1221
#ifdef ERANGE_FILL
#line 1221
    else
#line 1221
#endif
#line 1221
#endif
#line 1221
    if (*ip < 0) {
#line 1221
        
#line 1221
#ifdef ERANGE_FILL
#line 1221
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1221
#endif
#line 1221
        err = NC_ERANGE; /* because xp is unsigned */
#line 1221
    }
#line 1221
#ifdef ERANGE_FILL
#line 1221
    else
#line 1221
#endif
#line 1221
        xx = (ix_uint)*ip;
#line 1221

#line 1221
    put_ix_uint(xp, &xx);
#line 1221
    return err;
#line 1221
}
#line 1221

static int
#line 1222
ncx_put_uint_ushort(void *xp, const ushort *ip, void *fillp)
#line 1222
{
#line 1222
    int err=NC_NOERR;
#line 1222
#if SIZEOF_IX_UINT == SIZEOF_USHORT && IX_UINT_MAX == USHORT_MAX
#line 1222
    put_ix_uint(xp, (const ix_uint *)ip);
#line 1222
#else
#line 1222
    ix_uint xx = NC_FILL_UINT;
#line 1222

#line 1222
#if IX_UINT_MAX < USHORT_MAX
#line 1222
    if (*ip > IX_UINT_MAX) {
#line 1222
        
#line 1222
#ifdef ERANGE_FILL
#line 1222
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1222
#endif
#line 1222
        err = NC_ERANGE;
#line 1222
    }
#line 1222
#ifdef ERANGE_FILL
#line 1222
    else
#line 1222
#endif
#line 1222
#endif
#line 1222
        xx = (ix_uint)*ip;
#line 1222

#line 1222
    put_ix_uint(xp, &xx);
#line 1222
#endif
#line 1222
    return err;
#line 1222
}
#line 1222

static int
#line 1223
ncx_put_uint_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1223
{
#line 1223
    int err=NC_NOERR;
#line 1223
#if SIZEOF_IX_UINT == SIZEOF_ULONGLONG && IX_UINT_MAX == ULONGLONG_MAX
#line 1223
    put_ix_uint(xp, (const ix_uint *)ip);
#line 1223
#else
#line 1223
    ix_uint xx = NC_FILL_UINT;
#line 1223

#line 1223
#if IX_UINT_MAX < ULONGLONG_MAX
#line 1223
    if (*ip > IX_UINT_MAX) {
#line 1223
        
#line 1223
#ifdef ERANGE_FILL
#line 1223
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1223
#endif
#line 1223
        err = NC_ERANGE;
#line 1223
    }
#line 1223
#ifdef ERANGE_FILL
#line 1223
    else
#line 1223
#endif
#line 1223
#endif
#line 1223
        xx = (ix_uint)*ip;
#line 1223

#line 1223
    put_ix_uint(xp, &xx);
#line 1223
#endif
#line 1223
    return err;
#line 1223
}
#line 1223

static int
#line 1224
ncx_put_uint_float(void *xp, const float *ip, void *fillp)
#line 1224
{
#line 1224
    int err=NC_NOERR;
#line 1224
    ix_uint xx = NC_FILL_UINT;
#line 1224

#line 1224
    if (*ip > (double)X_UINT_MAX || *ip < 0) {
#line 1224
        
#line 1224
#ifdef ERANGE_FILL
#line 1224
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1224
#endif
#line 1224
        err = NC_ERANGE;
#line 1224
    }
#line 1224
#ifdef ERANGE_FILL
#line 1224
    else
#line 1224
#endif
#line 1224
        xx = (ix_uint)*ip;
#line 1224

#line 1224
    put_ix_uint(xp, &xx);
#line 1224
    return err;
#line 1224
}
#line 1224

static int
#line 1225
ncx_put_uint_double(void *xp, const double *ip, void *fillp)
#line 1225
{
#line 1225
    int err=NC_NOERR;
#line 1225
    ix_uint xx = NC_FILL_UINT;
#line 1225

#line 1225
    if (*ip > X_UINT_MAX || *ip < 0) {
#line 1225
        
#line 1225
#ifdef ERANGE_FILL
#line 1225
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1225
#endif
#line 1225
        err = NC_ERANGE;
#line 1225
    }
#line 1225
#ifdef ERANGE_FILL
#line 1225
    else
#line 1225
#endif
#line 1225
        xx = (ix_uint)*ip;
#line 1225

#line 1225
    put_ix_uint(xp, &xx);
#line 1225
    return err;
#line 1225
}
#line 1225



/* external NC_FLOAT --------------------------------------------------------*/

#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)

inline static void
get_ix_float(const void *xp, float *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(ip, xp, SIZEOF_FLOAT);
#else
	swap4b(ip, xp);
#endif
}

inline static void
put_ix_float(void *xp, const float *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(xp, ip, X_SIZEOF_FLOAT);
#else
	swap4b(xp, ip);
#endif
}

#elif defined(vax) && vax != 0

/* What IEEE single precision floating point looks like on a Vax */
struct	ieee_single {
	unsigned int	exp_hi       : 7;
	unsigned int	sign         : 1;
	unsigned int 	mant_hi      : 7;
	unsigned int	exp_lo       : 1;
	unsigned int	mant_lo_hi   : 8;
	unsigned int	mant_lo_lo   : 8;
};

/* Vax single precision floating point */
struct	vax_single {
	unsigned int	mantissa1 : 7;
	unsigned int	exp       : 8;
	unsigned int	sign      : 1;
	unsigned int	mantissa2 : 16;
};

#define VAX_SNG_BIAS	0x81
#define IEEE_SNG_BIAS	0x7f

static struct sgl_limits {
	struct vax_single s;
	struct ieee_single ieee;
} max = {
	{ 0x7f, 0xff, 0x0, 0xffff },	/* Max Vax */
	{ 0x7f, 0x0, 0x0, 0x1, 0x0, 0x0 }		/* Max IEEE */
};
static struct sgl_limits min = {
	{ 0x0, 0x0, 0x0, 0x0 },	/* Min Vax */
	{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 }		/* Min IEEE */
};

#line 1339
static void
get_ix_float(const void *xp, float *ip)
{
		struct vax_single *const vsp = (struct vax_single *) ip;
#line 1342
		const struct ieee_single *const isp =
#line 1342
			 (const struct ieee_single *) xp;
#line 1342
		unsigned exp = isp->exp_hi << 1 | isp->exp_lo;
#line 1342

#line 1342
		switch(exp) {
#line 1342
		case 0 :
#line 1342
			/* ieee subnormal */
#line 1342
			if (isp->mant_hi == min.ieee.mant_hi
#line 1342
				&& isp->mant_lo_hi == min.ieee.mant_lo_hi
#line 1342
				&& isp->mant_lo_lo == min.ieee.mant_lo_lo)
#line 1342
			{
#line 1342
				*vsp = min.s;
#line 1342
			}
#line 1342
			else
#line 1342
			{
#line 1342
				unsigned mantissa = (isp->mant_hi << 16)
#line 1342
					 | isp->mant_lo_hi << 8
#line 1342
					 | isp->mant_lo_lo;
#line 1342
				unsigned tmp = mantissa >> 20;
#line 1342
				if (tmp >= 4) {
#line 1342
					vsp->exp = 2;
#line 1342
				} else if (tmp >= 2) {
#line 1342
					vsp->exp = 1;
#line 1342
				} else {
#line 1342
					*vsp = min.s;
#line 1342
					break;
#line 1342
				} /* else */
#line 1342
				tmp = mantissa - (1 << (20 + vsp->exp ));
#line 1342
				tmp <<= 3 - vsp->exp;
#line 1342
				vsp->mantissa2 = tmp;
#line 1342
				vsp->mantissa1 = (tmp >> 16);
#line 1342
			}
#line 1342
			break;
#line 1342
		case 0xfe :
#line 1342
		case 0xff :
#line 1342
			*vsp = max.s;
#line 1342
			break;
#line 1342
		default :
#line 1342
			vsp->exp = exp - IEEE_SNG_BIAS + VAX_SNG_BIAS;
#line 1342
			vsp->mantissa2 = isp->mant_lo_hi << 8 | isp->mant_lo_lo;
#line 1342
			vsp->mantissa1 = isp->mant_hi;
#line 1342
		}
#line 1342

#line 1342
		vsp->sign = isp->sign;
#line 1342

}

#line 1396

static void
put_ix_float(void *xp, const float *ip)
{
		const struct vax_single *const vsp =
#line 1400
			 (const struct vax_single *)ip;
#line 1400
		struct ieee_single *const isp = (struct ieee_single *) xp;
#line 1400

#line 1400
		switch(vsp->exp){
#line 1400
		case 0 :
#line 1400
			/* all vax float with zero exponent map to zero */
#line 1400
			*isp = min.ieee;
#line 1400
			break;
#line 1400
		case 2 :
#line 1400
		case 1 :
#line 1400
		{
#line 1400
			/* These will map to subnormals */
#line 1400
			unsigned mantissa = (vsp->mantissa1 << 16)
#line 1400
					 | vsp->mantissa2;
#line 1400
			mantissa >>= 3 - vsp->exp;
#line 1400
			mantissa += (1 << (20 + vsp->exp));
#line 1400
			isp->mant_lo_lo = mantissa;
#line 1400
			isp->mant_lo_hi = mantissa >> 8;
#line 1400
			isp->mant_hi = mantissa >> 16;
#line 1400
			isp->exp_lo = 0;
#line 1400
			isp->exp_hi = 0;
#line 1400
		}
#line 1400
			break;
#line 1400
		case 0xff : /* max.s.exp */
#line 1400
			if (vsp->mantissa2 == max.s.mantissa2 &&
#line 1400
			    vsp->mantissa1 == max.s.mantissa1)
#line 1400
			{
#line 1400
				/* map largest vax float to ieee infinity */
#line 1400
				*isp = max.ieee;
#line 1400
				break;
#line 1400
			} /* else, fall thru */
#line 1400
		default :
#line 1400
		{
#line 1400
			unsigned exp = vsp->exp - VAX_SNG_BIAS + IEEE_SNG_BIAS;
#line 1400
			isp->exp_hi = exp >> 1;
#line 1400
			isp->exp_lo = exp;
#line 1400
			isp->mant_lo_lo = vsp->mantissa2;
#line 1400
			isp->mant_lo_hi = vsp->mantissa2 >> 8;
#line 1400
			isp->mant_hi = vsp->mantissa1;
#line 1400
		}
#line 1400
		}
#line 1400

#line 1400
		isp->sign = vsp->sign;
#line 1400

}

	/* vax */
#elif defined(_CRAY) && !defined(__crayx1)

/*
 * Return the number of bytes until the next "word" boundary
 * N.B. This is based on the very weird YMP address structure,
 * which puts the address within a word in the leftmost 3 bits
 * of the address.
 */
static size_t
word_align(const void *vp)
{
	const size_t rem = ((size_t)vp >> (64 - 3)) & 0x7;
	return (rem != 0);
}

struct ieee_single_hi {
	unsigned int	sign	: 1;
	unsigned int	 exp	: 8;
	unsigned int	mant	:23;
	unsigned int	pad	:32;
};
typedef struct ieee_single_hi ieee_single_hi;

struct ieee_single_lo {
	unsigned int	pad	:32;
	unsigned int	sign	: 1;
	unsigned int	 exp	: 8;
	unsigned int	mant	:23;
};
typedef struct ieee_single_lo ieee_single_lo;

static const int ieee_single_bias = 0x7f;

struct ieee_double {
	unsigned int	sign	: 1;
	unsigned int	 exp	:11;
	unsigned int	mant	:52;
};
typedef struct ieee_double ieee_double;

static const int ieee_double_bias = 0x3ff;

#if defined(NO_IEEE_FLOAT)

struct cray_single {
	unsigned int	sign	: 1;
	unsigned int	 exp	:15;
	unsigned int	mant	:48;
};
typedef struct cray_single cray_single;

static const int cs_ieis_bias = 0x4000 - 0x7f;

static const int cs_id_bias = 0x4000 - 0x3ff;

#line 1535

static void
get_ix_float(const void *xp, float *ip)
{

	if (word_align(xp) == 0)
	{
		const ieee_single_hi *isp = (const ieee_single_hi *) xp;
		cray_single *csp = (cray_single *) ip;
#line 1543

#line 1543
		if (isp->exp == 0)
#line 1543
		{
#line 1543
			/* ieee subnormal */
#line 1543
			*ip = (double)isp->mant;
#line 1543
			if (isp->mant != 0)
#line 1543
			{
#line 1543
				csp->exp -= (ieee_single_bias + 22);
#line 1543
			}
#line 1543
		}
#line 1543
		else
#line 1543
		{
#line 1543
			csp->exp  = isp->exp + cs_ieis_bias + 1;
#line 1543
			csp->mant = isp->mant << (48 - 1 - 23);
#line 1543
			csp->mant |= (1 << (48 - 1));
#line 1543
		}
#line 1543
		csp->sign = isp->sign;
#line 1543

#line 1543

	}
	else
	{
		const ieee_single_lo *isp = (const ieee_single_lo *) xp;
		cray_single *csp = (cray_single *) ip;
#line 1548

#line 1548
		if (isp->exp == 0)
#line 1548
		{
#line 1548
			/* ieee subnormal */
#line 1548
			*ip = (double)isp->mant;
#line 1548
			if (isp->mant != 0)
#line 1548
			{
#line 1548
				csp->exp -= (ieee_single_bias + 22);
#line 1548
			}
#line 1548
		}
#line 1548
		else
#line 1548
		{
#line 1548
			csp->exp  = isp->exp + cs_ieis_bias + 1;
#line 1548
			csp->mant = isp->mant << (48 - 1 - 23);
#line 1548
			csp->mant |= (1 << (48 - 1));
#line 1548
		}
#line 1548
		csp->sign = isp->sign;
#line 1548

#line 1548

	}
}

static void
put_ix_float(void *xp, const float *ip)
{
	if (word_align(xp) == 0)
	{
		ieee_single_hi *isp = (ieee_single_hi*)xp;
	const cray_single *csp = (const cray_single *) ip;
#line 1558
	int ieee_exp = csp->exp - cs_ieis_bias -1;
#line 1558

#line 1558
	isp->sign = csp->sign;
#line 1558

#line 1558
	if (ieee_exp >= 0xff)
#line 1558
	{
#line 1558
		/* NC_ERANGE => ieee Inf */
#line 1558
		isp->exp = 0xff;
#line 1558
		isp->mant = 0x0;
#line 1558
	}
#line 1558
	else if (ieee_exp > 0)
#line 1558
	{
#line 1558
		/* normal ieee representation */
#line 1558
		isp->exp  = ieee_exp;
#line 1558
		/* assumes cray rep is in normal form */
#line 1558
		assert(csp->mant & 0x800000000000);
#line 1558
		isp->mant = (((csp->mant << 1) &
#line 1558
				0xffffffffffff) >> (48 - 23));
#line 1558
	}
#line 1558
	else if (ieee_exp > -23)
#line 1558
	{
#line 1558
		/* ieee subnormal, right shift */
#line 1558
		const int rshift = (48 - 23 - ieee_exp);
#line 1558

#line 1558
		isp->mant = csp->mant >> rshift;
#line 1558

#line 1558
#if 0
#line 1558
		if (csp->mant & (1 << (rshift -1)))
#line 1558
		{
#line 1558
			/* round up */
#line 1558
			isp->mant++;
#line 1558
		}
#line 1558
#endif
#line 1558

#line 1558
		isp->exp  = 0;
#line 1558
	}
#line 1558
	else
#line 1558
	{
#line 1558
		/* smaller than ieee can represent */
#line 1558
		isp->exp = 0;
#line 1558
		isp->mant = 0;
#line 1558
	}
#line 1558

	}
	else
	{
		ieee_single_lo *isp = (ieee_single_lo*)xp;
	const cray_single *csp = (const cray_single *) ip;
#line 1563
	int ieee_exp = csp->exp - cs_ieis_bias -1;
#line 1563

#line 1563
	isp->sign = csp->sign;
#line 1563

#line 1563
	if (ieee_exp >= 0xff)
#line 1563
	{
#line 1563
		/* NC_ERANGE => ieee Inf */
#line 1563
		isp->exp = 0xff;
#line 1563
		isp->mant = 0x0;
#line 1563
	}
#line 1563
	else if (ieee_exp > 0)
#line 1563
	{
#line 1563
		/* normal ieee representation */
#line 1563
		isp->exp  = ieee_exp;
#line 1563
		/* assumes cray rep is in normal form */
#line 1563
		assert(csp->mant & 0x800000000000);
#line 1563
		isp->mant = (((csp->mant << 1) &
#line 1563
				0xffffffffffff) >> (48 - 23));
#line 1563
	}
#line 1563
	else if (ieee_exp > -23)
#line 1563
	{
#line 1563
		/* ieee subnormal, right shift */
#line 1563
		const int rshift = (48 - 23 - ieee_exp);
#line 1563

#line 1563
		isp->mant = csp->mant >> rshift;
#line 1563

#line 1563
#if 0
#line 1563
		if (csp->mant & (1 << (rshift -1)))
#line 1563
		{
#line 1563
			/* round up */
#line 1563
			isp->mant++;
#line 1563
		}
#line 1563
#endif
#line 1563

#line 1563
		isp->exp  = 0;
#line 1563
	}
#line 1563
	else
#line 1563
	{
#line 1563
		/* smaller than ieee can represent */
#line 1563
		isp->exp = 0;
#line 1563
		isp->mant = 0;
#line 1563
	}
#line 1563

	}
}

#else
	/* IEEE Cray with only doubles */
static void
get_ix_float(const void *xp, float *ip)
{

	ieee_double *idp = (ieee_double *) ip;

	if (word_align(xp) == 0)
	{
		const ieee_single_hi *isp = (const ieee_single_hi *) xp;
		if (isp->exp == 0 && isp->mant == 0)
		{
			idp->exp = 0;
			idp->mant = 0;
		}
		else
		{
			idp->exp = isp->exp + (ieee_double_bias - ieee_single_bias);
			idp->mant = isp->mant << (52 - 23);
		}
		idp->sign = isp->sign;
	}
	else
	{
		const ieee_single_lo *isp = (const ieee_single_lo *) xp;
		if (isp->exp == 0 && isp->mant == 0)
		{
			idp->exp = 0;
			idp->mant = 0;
		}
		else
		{
			idp->exp = isp->exp + (ieee_double_bias - ieee_single_bias);
			idp->mant = isp->mant << (52 - 23);
		}
		idp->sign = isp->sign;
	}
}

static void
put_ix_float(void *xp, const float *ip)
{
	const ieee_double *idp = (const ieee_double *) ip;
	if (word_align(xp) == 0)
	{
		ieee_single_hi *isp = (ieee_single_hi*)xp;
		if (idp->exp > (ieee_double_bias - ieee_single_bias))
			isp->exp = idp->exp - (ieee_double_bias - ieee_single_bias);
		else
			isp->exp = 0;
		isp->mant = idp->mant >> (52 - 23);
		isp->sign = idp->sign;
	}
	else
	{
		ieee_single_lo *isp = (ieee_single_lo*)xp;
		if (idp->exp > (ieee_double_bias - ieee_single_bias))
			isp->exp = idp->exp - (ieee_double_bias - ieee_single_bias);
		else
			isp->exp = 0;
		isp->mant = idp->mant >> (52 - 23);
		isp->sign = idp->sign;
	}
}
#endif

#else
#error "ix_float implementation"
#endif

#if X_SIZEOF_FLOAT != SIZEOF_FLOAT || defined(NO_IEEE_FLOAT)
static int
ncx_get_float_float(const void *xp, float *ip, void *fillp)
{
	/* TODO */
	get_ix_float(xp, ip);
	return NC_NOERR;
}
#endif

#define ix_float float

static int
#line 1650
ncx_get_float_schar(const void *xp, schar *ip)
#line 1650
{
#line 1650
	ix_float xx = 0;
#line 1650
	get_ix_float(xp, &xx);
#line 1650
	if (xx > (double)SCHAR_MAX || xx < (double)SCHAR_MIN) {
#line 1650
#ifdef ERANGE_FILL
#line 1650
            *ip = NC_FILL_BYTE;
#line 1650
#endif
#line 1650
            return NC_ERANGE;
#line 1650
        }
#line 1650
	*ip = (schar)xx;
#line 1650
	return NC_NOERR;
#line 1650
}
#line 1650

static int
#line 1651
ncx_get_float_short(const void *xp, short *ip)
#line 1651
{
#line 1651
	ix_float xx = 0;
#line 1651
	get_ix_float(xp, &xx);
#line 1651
	if (xx > (double)SHORT_MAX || xx < (double)SHORT_MIN) {
#line 1651
#ifdef ERANGE_FILL
#line 1651
            *ip = NC_FILL_SHORT;
#line 1651
#endif
#line 1651
            return NC_ERANGE;
#line 1651
        }
#line 1651
	*ip = (short)xx;
#line 1651
	return NC_NOERR;
#line 1651
}
#line 1651

static int
#line 1652
ncx_get_float_int(const void *xp, int *ip)
#line 1652
{
#line 1652
	ix_float xx = 0;
#line 1652
	get_ix_float(xp, &xx);
#line 1652
	if (xx > (double)INT_MAX || xx < (double)INT_MIN) {
#line 1652
#ifdef ERANGE_FILL
#line 1652
            *ip = NC_FILL_INT;
#line 1652
#endif
#line 1652
            return NC_ERANGE;
#line 1652
        }
#line 1652
	*ip = (int)xx;
#line 1652
	return NC_NOERR;
#line 1652
}
#line 1652

static int
#line 1653
ncx_get_float_long(const void *xp, long *ip)
#line 1653
{
#line 1653
	ix_float xx = 0;
#line 1653
	get_ix_float(xp, &xx);
#line 1653
	if (xx > (double)LONG_MAX || xx < (double)LONG_MIN) {
#line 1653
#ifdef ERANGE_FILL
#line 1653
            *ip = NC_FILL_INT;
#line 1653
#endif
#line 1653
            return NC_ERANGE;
#line 1653
        }
#line 1653
	*ip = (long)xx;
#line 1653
	return NC_NOERR;
#line 1653
}
#line 1653

static int
#line 1654
ncx_get_float_double(const void *xp, double *ip)
#line 1654
{
#line 1654
	ix_float xx = 0;
#line 1654
	get_ix_float(xp, &xx);
#line 1654
	*ip = (double)xx;
#line 1654
	return NC_NOERR;
#line 1654
}
#line 1654

static int
#line 1655
ncx_get_float_longlong(const void *xp, longlong *ip)
#line 1655
{
#line 1655
	ix_float xx = 0;
#line 1655
	get_ix_float(xp, &xx);
#line 1655
	if (xx == LONGLONG_MAX)      *ip = LONGLONG_MAX;
#line 1655
	else if (xx == LONGLONG_MIN) *ip = LONGLONG_MIN;
#line 1655
	else if (xx > (double)LONGLONG_MAX || xx < (double)LONGLONG_MIN) {
#line 1655
#ifdef ERANGE_FILL
#line 1655
            *ip = NC_FILL_INT64;
#line 1655
#endif
#line 1655
            return NC_ERANGE;
#line 1655
        }
#line 1655
	else *ip = (longlong)xx;
#line 1655
	return NC_NOERR;
#line 1655
}
#line 1655

static int
#line 1656
ncx_get_float_uchar(const void *xp, uchar *ip)
#line 1656
{
#line 1656
	ix_float xx = 0;
#line 1656
	get_ix_float(xp, &xx);
#line 1656
	if (xx > (double)UCHAR_MAX || xx < 0) {
#line 1656
#ifdef ERANGE_FILL
#line 1656
            *ip = NC_FILL_UBYTE;
#line 1656
#endif
#line 1656
            return NC_ERANGE;
#line 1656
        }
#line 1656
	*ip = (uchar)xx;
#line 1656
	return NC_NOERR;
#line 1656
}
#line 1656

static int
#line 1657
ncx_get_float_ushort(const void *xp, ushort *ip)
#line 1657
{
#line 1657
	ix_float xx = 0;
#line 1657
	get_ix_float(xp, &xx);
#line 1657
	if (xx > (double)USHORT_MAX || xx < 0) {
#line 1657
#ifdef ERANGE_FILL
#line 1657
            *ip = NC_FILL_USHORT;
#line 1657
#endif
#line 1657
            return NC_ERANGE;
#line 1657
        }
#line 1657
	*ip = (ushort)xx;
#line 1657
	return NC_NOERR;
#line 1657
}
#line 1657

static int
#line 1658
ncx_get_float_uint(const void *xp, uint *ip)
#line 1658
{
#line 1658
	ix_float xx = 0;
#line 1658
	get_ix_float(xp, &xx);
#line 1658
	if (xx > (double)UINT_MAX || xx < 0) {
#line 1658
#ifdef ERANGE_FILL
#line 1658
            *ip = NC_FILL_UINT;
#line 1658
#endif
#line 1658
            return NC_ERANGE;
#line 1658
        }
#line 1658
	*ip = (uint)xx;
#line 1658
	return NC_NOERR;
#line 1658
}
#line 1658

static int
#line 1659
ncx_get_float_ulonglong(const void *xp, ulonglong *ip)
#line 1659
{
#line 1659
	ix_float xx = 0;
#line 1659
	get_ix_float(xp, &xx);
#line 1659
	if (xx == ULONGLONG_MAX)      *ip = ULONGLONG_MAX;
#line 1659
	else if (xx > (double)ULONGLONG_MAX || xx < 0) {
#line 1659
#ifdef ERANGE_FILL
#line 1659
            *ip = NC_FILL_UINT64;
#line 1659
#endif
#line 1659
            return NC_ERANGE;
#line 1659
        }
#line 1659
	else *ip = (ulonglong)xx;
#line 1659
	return NC_NOERR;
#line 1659
}
#line 1659


#if X_SIZEOF_FLOAT != SIZEOF_FLOAT || defined(NO_IEEE_FLOAT)
static int
ncx_put_float_float(void *xp, const float *ip, void *fillp)
{
    int err=NC_NOERR;
    float *_ip=ip;
#ifdef NO_IEEE_FLOAT
#ifdef ERANGE_FILL
    float tmp;
#endif
    if (*ip > X_FLOAT_MAX || *ip < X_FLOAT_MIN) {
        
#line 1672
#ifdef ERANGE_FILL
#line 1672
            if (fillp != NULL) memcpy(&tmp, fillp, 4);
#line 1672
#endif
#ifdef ERANGE_FILL
        _ip = &tmp;
#endif
        err = NC_ERANGE;
    }
#endif
    put_ix_float(xp, _ip);
    return err;
}
#endif

static int
#line 1684
ncx_put_float_schar(void *xp, const schar *ip, void *fillp)
#line 1684
{
#line 1684
    int err=NC_NOERR;
#line 1684
    ix_float xx = NC_FILL_FLOAT;
#line 1684

#line 1684
    
#line 1684
        xx = (ix_float)*ip;
#line 1684

#line 1684
    put_ix_float(xp, &xx);
#line 1684
    return err;
#line 1684
}
#line 1684

static int
#line 1685
ncx_put_float_short(void *xp, const short *ip, void *fillp)
#line 1685
{
#line 1685
    int err=NC_NOERR;
#line 1685
    ix_float xx = NC_FILL_FLOAT;
#line 1685

#line 1685
    
#line 1685
        xx = (ix_float)*ip;
#line 1685

#line 1685
    put_ix_float(xp, &xx);
#line 1685
    return err;
#line 1685
}
#line 1685

static int
#line 1686
ncx_put_float_int(void *xp, const int *ip, void *fillp)
#line 1686
{
#line 1686
    int err=NC_NOERR;
#line 1686
    ix_float xx = NC_FILL_FLOAT;
#line 1686

#line 1686
    
#line 1686
        xx = (ix_float)*ip;
#line 1686

#line 1686
    put_ix_float(xp, &xx);
#line 1686
    return err;
#line 1686
}
#line 1686

static int
#line 1687
ncx_put_float_long(void *xp, const long *ip, void *fillp)
#line 1687
{
#line 1687
    int err=NC_NOERR;
#line 1687
    ix_float xx = NC_FILL_FLOAT;
#line 1687

#line 1687
    
#line 1687
        xx = (ix_float)*ip;
#line 1687

#line 1687
    put_ix_float(xp, &xx);
#line 1687
    return err;
#line 1687
}
#line 1687

static int
#line 1688
ncx_put_float_double(void *xp, const double *ip, void *fillp)
#line 1688
{
#line 1688
    int err=NC_NOERR;
#line 1688
    ix_float xx = NC_FILL_FLOAT;
#line 1688

#line 1688
    if (*ip > X_FLOAT_MAX || *ip < X_FLOAT_MIN) {
#line 1688
        
#line 1688
#ifdef ERANGE_FILL
#line 1688
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1688
#endif
#line 1688
        err = NC_ERANGE;
#line 1688
    }
#line 1688
#ifdef ERANGE_FILL
#line 1688
    else
#line 1688
#endif
#line 1688
        xx = (ix_float)*ip;
#line 1688

#line 1688
    put_ix_float(xp, &xx);
#line 1688
    return err;
#line 1688
}
#line 1688

static int
#line 1689
ncx_put_float_longlong(void *xp, const longlong *ip, void *fillp)
#line 1689
{
#line 1689
    int err=NC_NOERR;
#line 1689
    ix_float xx = NC_FILL_FLOAT;
#line 1689

#line 1689
    
#line 1689
        xx = (ix_float)*ip;
#line 1689

#line 1689
    put_ix_float(xp, &xx);
#line 1689
    return err;
#line 1689
}
#line 1689

static int
#line 1690
ncx_put_float_uchar(void *xp, const uchar *ip, void *fillp)
#line 1690
{
#line 1690
    int err=NC_NOERR;
#line 1690
    ix_float xx = NC_FILL_FLOAT;
#line 1690

#line 1690
    
#line 1690
        xx = (ix_float)*ip;
#line 1690

#line 1690
    put_ix_float(xp, &xx);
#line 1690
    return err;
#line 1690
}
#line 1690

static int
#line 1691
ncx_put_float_ushort(void *xp, const ushort *ip, void *fillp)
#line 1691
{
#line 1691
    int err=NC_NOERR;
#line 1691
    ix_float xx = NC_FILL_FLOAT;
#line 1691

#line 1691
    
#line 1691
        xx = (ix_float)*ip;
#line 1691

#line 1691
    put_ix_float(xp, &xx);
#line 1691
    return err;
#line 1691
}
#line 1691

static int
#line 1692
ncx_put_float_uint(void *xp, const uint *ip, void *fillp)
#line 1692
{
#line 1692
    int err=NC_NOERR;
#line 1692
    ix_float xx = NC_FILL_FLOAT;
#line 1692

#line 1692
    
#line 1692
        xx = (ix_float)*ip;
#line 1692

#line 1692
    put_ix_float(xp, &xx);
#line 1692
    return err;
#line 1692
}
#line 1692

static int
#line 1693
ncx_put_float_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1693
{
#line 1693
    int err=NC_NOERR;
#line 1693
    ix_float xx = NC_FILL_FLOAT;
#line 1693

#line 1693
    
#line 1693
        xx = (ix_float)*ip;
#line 1693

#line 1693
    put_ix_float(xp, &xx);
#line 1693
    return err;
#line 1693
}
#line 1693



/* external NC_DOUBLE -------------------------------------------------------*/

#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE  && !defined(NO_IEEE_FLOAT)

static void
get_ix_double(const void *xp, double *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(ip, xp, SIZEOF_DOUBLE);
#else
	swap8b(ip, xp);
#endif
}

static void
put_ix_double(void *xp, const double *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(xp, ip, X_SIZEOF_DOUBLE);
#else
	swap8b(xp, ip);
#endif
}

#elif defined(vax) && vax != 0

/* What IEEE double precision floating point looks like on a Vax */
struct	ieee_double {
	unsigned int	exp_hi   : 7;
	unsigned int	sign     : 1;
	unsigned int 	mant_6   : 4;
	unsigned int	exp_lo   : 4;
	unsigned int	mant_5   : 8;
	unsigned int	mant_4   : 8;

	unsigned int	mant_lo  : 32;
};

/* Vax double precision floating point */
struct  vax_double {
	unsigned int	mantissa1 : 7;
	unsigned int	exp       : 8;
	unsigned int	sign      : 1;
	unsigned int	mantissa2 : 16;
	unsigned int	mantissa3 : 16;
	unsigned int	mantissa4 : 16;
};

#define VAX_DBL_BIAS	0x81
#define IEEE_DBL_BIAS	0x3ff
#define MASK(nbits)	((1 << nbits) - 1)

static const struct dbl_limits {
	struct	vax_double d;
	struct	ieee_double ieee;
} dbl_limits[2] = {
	{{ 0x7f, 0xff, 0x0, 0xffff, 0xffff, 0xffff },	/* Max Vax */
	{ 0x7f, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0}}, /* Max IEEE */
	{{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},		/* Min Vax */
	{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}}, /* Min IEEE */
};


#line 1807
static void
get_ix_double(const void *xp, double *ip)
{
	struct vax_double *const vdp =
#line 1810
			 (struct vax_double *)ip;
#line 1810
	const struct ieee_double *const idp =
#line 1810
			 (const struct ieee_double *) xp;
#line 1810
	{
#line 1810
		const struct dbl_limits *lim;
#line 1810
		int ii;
#line 1810
		for (ii = 0, lim = dbl_limits;
#line 1810
			ii < sizeof(dbl_limits)/sizeof(struct dbl_limits);
#line 1810
			ii++, lim++)
#line 1810
		{
#line 1810
			if ((idp->mant_lo == lim->ieee.mant_lo)
#line 1810
				&& (idp->mant_4 == lim->ieee.mant_4)
#line 1810
				&& (idp->mant_5 == lim->ieee.mant_5)
#line 1810
				&& (idp->mant_6 == lim->ieee.mant_6)
#line 1810
				&& (idp->exp_lo == lim->ieee.exp_lo)
#line 1810
				&& (idp->exp_hi == lim->ieee.exp_hi)
#line 1810
				)
#line 1810
			{
#line 1810
				*vdp = lim->d;
#line 1810
				goto doneit;
#line 1810
			}
#line 1810
		}
#line 1810
	}
#line 1810
	{
#line 1810
		unsigned exp = idp->exp_hi << 4 | idp->exp_lo;
#line 1810
		vdp->exp = exp - IEEE_DBL_BIAS + VAX_DBL_BIAS;
#line 1810
	}
#line 1810
	{
#line 1810
		unsigned mant_hi = ((idp->mant_6 << 16)
#line 1810
				 | (idp->mant_5 << 8)
#line 1810
				 | idp->mant_4);
#line 1810
		unsigned mant_lo = SWAP4(idp->mant_lo);
#line 1810
		vdp->mantissa1 = (mant_hi >> 13);
#line 1810
		vdp->mantissa2 = ((mant_hi & MASK(13)) << 3)
#line 1810
				| (mant_lo >> 29);
#line 1810
		vdp->mantissa3 = (mant_lo >> 13);
#line 1810
		vdp->mantissa4 = (mant_lo << 3);
#line 1810
	}
#line 1810
	doneit:
#line 1810
		vdp->sign = idp->sign;
#line 1810

}


#line 1880
static void
put_ix_double(void *xp, const double *ip)
{
	const struct vax_double *const vdp =
#line 1883
			(const struct vax_double *)ip;
#line 1883
	struct ieee_double *const idp =
#line 1883
			 (struct ieee_double *) xp;
#line 1883

#line 1883
	if ((vdp->mantissa4 > (dbl_limits[0].d.mantissa4 - 3)) &&
#line 1883
		(vdp->mantissa3 == dbl_limits[0].d.mantissa3) &&
#line 1883
		(vdp->mantissa2 == dbl_limits[0].d.mantissa2) &&
#line 1883
		(vdp->mantissa1 == dbl_limits[0].d.mantissa1) &&
#line 1883
		(vdp->exp == dbl_limits[0].d.exp))
#line 1883
	{
#line 1883
		*idp = dbl_limits[0].ieee;
#line 1883
		goto shipit;
#line 1883
	}
#line 1883
	if ((vdp->mantissa4 == dbl_limits[1].d.mantissa4) &&
#line 1883
		(vdp->mantissa3 == dbl_limits[1].d.mantissa3) &&
#line 1883
		(vdp->mantissa2 == dbl_limits[1].d.mantissa2) &&
#line 1883
		(vdp->mantissa1 == dbl_limits[1].d.mantissa1) &&
#line 1883
		(vdp->exp == dbl_limits[1].d.exp))
#line 1883
	{
#line 1883
		*idp = dbl_limits[1].ieee;
#line 1883
		goto shipit;
#line 1883
	}
#line 1883

#line 1883
	{
#line 1883
		unsigned exp = vdp->exp - VAX_DBL_BIAS + IEEE_DBL_BIAS;
#line 1883

#line 1883
		unsigned mant_lo = ((vdp->mantissa2 & MASK(3)) << 29) |
#line 1883
			(vdp->mantissa3 << 13) |
#line 1883
			((vdp->mantissa4 >> 3) & MASK(13));
#line 1883

#line 1883
		unsigned mant_hi = (vdp->mantissa1 << 13)
#line 1883
				 | (vdp->mantissa2 >> 3);
#line 1883

#line 1883
		if ((vdp->mantissa4 & 7) > 4)
#line 1883
		{
#line 1883
			/* round up */
#line 1883
			mant_lo++;
#line 1883
			if (mant_lo == 0)
#line 1883
			{
#line 1883
				mant_hi++;
#line 1883
				if (mant_hi > 0xffffff)
#line 1883
				{
#line 1883
					mant_hi = 0;
#line 1883
					exp++;
#line 1883
				}
#line 1883
			}
#line 1883
		}
#line 1883

#line 1883
		idp->mant_lo = SWAP4(mant_lo);
#line 1883
		idp->mant_6 = mant_hi >> 16;
#line 1883
		idp->mant_5 = (mant_hi & 0xff00) >> 8;
#line 1883
		idp->mant_4 = mant_hi;
#line 1883
		idp->exp_hi = exp >> 4;
#line 1883
		idp->exp_lo = exp;
#line 1883
	}
#line 1883

#line 1883
	shipit:
#line 1883
		idp->sign = vdp->sign;
#line 1883

}

	/* vax */
#elif defined(_CRAY) && !defined(__crayx1)

static void
get_ix_double(const void *xp, double *ip)
{
	const ieee_double *idp = (const ieee_double *) xp;
	cray_single *csp = (cray_single *) ip;

	if (idp->exp == 0)
	{
		/* ieee subnormal */
		*ip = (double)idp->mant;
		if (idp->mant != 0)
		{
			csp->exp -= (ieee_double_bias + 51);
		}
	}
	else
	{
		csp->exp  = idp->exp + cs_id_bias + 1;
		csp->mant = idp->mant >> (52 - 48 + 1);
		csp->mant |= (1 << (48 - 1));
	}
	csp->sign = idp->sign;
}

static void
put_ix_double(void *xp, const double *ip)
{
	ieee_double *idp = (ieee_double *) xp;
	const cray_single *csp = (const cray_single *) ip;

	int ieee_exp = csp->exp - cs_id_bias -1;

	idp->sign = csp->sign;

	if (ieee_exp >= 0x7ff)
	{
		/* NC_ERANGE => ieee Inf */
		idp->exp = 0x7ff;
		idp->mant = 0x0;
	}
	else if (ieee_exp > 0)
	{
		/* normal ieee representation */
		idp->exp  = ieee_exp;
		/* assumes cray rep is in normal form */
		assert(csp->mant & 0x800000000000);
		idp->mant = (((csp->mant << 1) &
				0xffffffffffff) << (52 - 48));
	}
	else if (ieee_exp >= (-(52 -48)))
	{
		/* ieee subnormal, left shift */
		const int lshift = (52 - 48) + ieee_exp;
		idp->mant = csp->mant << lshift;
		idp->exp  = 0;
	}
	else if (ieee_exp >= -52)
	{
		/* ieee subnormal, right shift */
		const int rshift = (- (52 - 48) - ieee_exp);

		idp->mant = csp->mant >> rshift;

#if 0
		if (csp->mant & (1 << (rshift -1)))
		{
			/* round up */
			idp->mant++;
		}
#endif

		idp->exp  = 0;
	}
	else
	{
		/* smaller than ieee can represent */
		idp->exp = 0;
		idp->mant = 0;
	}
}
#else
#error "ix_double implementation"
#endif

#define ix_double double

static int
#line 1975
ncx_get_double_schar(const void *xp, schar *ip)
#line 1975
{
#line 1975
	ix_double xx = 0;
#line 1975
	get_ix_double(xp, &xx);
#line 1975
	if (xx > (double)SCHAR_MAX || xx < (double)SCHAR_MIN) {
#line 1975
#ifdef ERANGE_FILL
#line 1975
            *ip = NC_FILL_BYTE;
#line 1975
#endif
#line 1975
            return NC_ERANGE;
#line 1975
        }
#line 1975
	*ip = (schar)xx;
#line 1975
	return NC_NOERR;
#line 1975
}
#line 1975

static int
#line 1976
ncx_get_double_short(const void *xp, short *ip)
#line 1976
{
#line 1976
	ix_double xx = 0;
#line 1976
	get_ix_double(xp, &xx);
#line 1976
	if (xx > (double)SHORT_MAX || xx < (double)SHORT_MIN) {
#line 1976
#ifdef ERANGE_FILL
#line 1976
            *ip = NC_FILL_SHORT;
#line 1976
#endif
#line 1976
            return NC_ERANGE;
#line 1976
        }
#line 1976
	*ip = (short)xx;
#line 1976
	return NC_NOERR;
#line 1976
}
#line 1976

static int
#line 1977
ncx_get_double_int(const void *xp, int *ip)
#line 1977
{
#line 1977
	ix_double xx = 0;
#line 1977
	get_ix_double(xp, &xx);
#line 1977
	if (xx > (double)INT_MAX || xx < (double)INT_MIN) {
#line 1977
#ifdef ERANGE_FILL
#line 1977
            *ip = NC_FILL_INT;
#line 1977
#endif
#line 1977
            return NC_ERANGE;
#line 1977
        }
#line 1977
	*ip = (int)xx;
#line 1977
	return NC_NOERR;
#line 1977
}
#line 1977

static int
#line 1978
ncx_get_double_long(const void *xp, long *ip)
#line 1978
{
#line 1978
	ix_double xx = 0;
#line 1978
	get_ix_double(xp, &xx);
#line 1978
	if (xx > (double)LONG_MAX || xx < (double)LONG_MIN) {
#line 1978
#ifdef ERANGE_FILL
#line 1978
            *ip = NC_FILL_INT;
#line 1978
#endif
#line 1978
            return NC_ERANGE;
#line 1978
        }
#line 1978
	*ip = (long)xx;
#line 1978
	return NC_NOERR;
#line 1978
}
#line 1978

static int
#line 1979
ncx_get_double_longlong(const void *xp, longlong *ip)
#line 1979
{
#line 1979
	ix_double xx = 0;
#line 1979
	get_ix_double(xp, &xx);
#line 1979
	if (xx == LONGLONG_MAX)      *ip = LONGLONG_MAX;
#line 1979
	else if (xx == LONGLONG_MIN) *ip = LONGLONG_MIN;
#line 1979
	else if (xx > (double)LONGLONG_MAX || xx < (double)LONGLONG_MIN) {
#line 1979
#ifdef ERANGE_FILL
#line 1979
            *ip = NC_FILL_INT64;
#line 1979
#endif
#line 1979
            return NC_ERANGE;
#line 1979
        }
#line 1979
	else *ip = (longlong)xx;
#line 1979
	return NC_NOERR;
#line 1979
}
#line 1979

static int
#line 1980
ncx_get_double_uchar(const void *xp, uchar *ip)
#line 1980
{
#line 1980
	ix_double xx = 0;
#line 1980
	get_ix_double(xp, &xx);
#line 1980
	if (xx > (double)UCHAR_MAX || xx < 0) {
#line 1980
#ifdef ERANGE_FILL
#line 1980
            *ip = NC_FILL_UBYTE;
#line 1980
#endif
#line 1980
            return NC_ERANGE;
#line 1980
        }
#line 1980
	*ip = (uchar)xx;
#line 1980
	return NC_NOERR;
#line 1980
}
#line 1980

static int
#line 1981
ncx_get_double_ushort(const void *xp, ushort *ip)
#line 1981
{
#line 1981
	ix_double xx = 0;
#line 1981
	get_ix_double(xp, &xx);
#line 1981
	if (xx > (double)USHORT_MAX || xx < 0) {
#line 1981
#ifdef ERANGE_FILL
#line 1981
            *ip = NC_FILL_USHORT;
#line 1981
#endif
#line 1981
            return NC_ERANGE;
#line 1981
        }
#line 1981
	*ip = (ushort)xx;
#line 1981
	return NC_NOERR;
#line 1981
}
#line 1981

static int
#line 1982
ncx_get_double_uint(const void *xp, uint *ip)
#line 1982
{
#line 1982
	ix_double xx = 0;
#line 1982
	get_ix_double(xp, &xx);
#line 1982
	if (xx > (double)UINT_MAX || xx < 0) {
#line 1982
#ifdef ERANGE_FILL
#line 1982
            *ip = NC_FILL_UINT;
#line 1982
#endif
#line 1982
            return NC_ERANGE;
#line 1982
        }
#line 1982
	*ip = (uint)xx;
#line 1982
	return NC_NOERR;
#line 1982
}
#line 1982

static int
#line 1983
ncx_get_double_ulonglong(const void *xp, ulonglong *ip)
#line 1983
{
#line 1983
	ix_double xx = 0;
#line 1983
	get_ix_double(xp, &xx);
#line 1983
	if (xx == ULONGLONG_MAX)      *ip = ULONGLONG_MAX;
#line 1983
	else if (xx > (double)ULONGLONG_MAX || xx < 0) {
#line 1983
#ifdef ERANGE_FILL
#line 1983
            *ip = NC_FILL_UINT64;
#line 1983
#endif
#line 1983
            return NC_ERANGE;
#line 1983
        }
#line 1983
	else *ip = (ulonglong)xx;
#line 1983
	return NC_NOERR;
#line 1983
}
#line 1983


static int
ncx_get_double_float(const void *xp, float *ip)
{
    double xx = 0.0;
    get_ix_double(xp, &xx);
    if (xx > FLT_MAX) {
#ifdef ERANGE_FILL
        *ip = NC_FILL_FLOAT;
#else
        *ip = FLT_MAX;
#endif
        return NC_ERANGE;
    }
    if (xx < (-FLT_MAX)) {
#ifdef ERANGE_FILL
        *ip = NC_FILL_FLOAT;
#else
        *ip = (-FLT_MAX);
#endif
        return NC_ERANGE;
    }
    *ip = (float) xx;
    return NC_NOERR;
}

#if X_SIZEOF_DOUBLE != SIZEOF_DOUBLE  || defined(NO_IEEE_FLOAT)
static int
ncx_get_double_double(const void *xp, double *ip, void *fillp)
{
	/* TODO */
	get_ix_double(xp, ip);
	return NC_NOERR;
}
#endif

static int
#line 2020
ncx_put_double_schar(void *xp, const schar *ip, void *fillp)
#line 2020
{
#line 2020
    int err=NC_NOERR;
#line 2020
    ix_double xx = NC_FILL_DOUBLE;
#line 2020

#line 2020
    
#line 2020
        xx = (ix_double)*ip;
#line 2020

#line 2020
    put_ix_double(xp, &xx);
#line 2020
    return err;
#line 2020
}
#line 2020

static int
#line 2021
ncx_put_double_uchar(void *xp, const uchar *ip, void *fillp)
#line 2021
{
#line 2021
    int err=NC_NOERR;
#line 2021
    ix_double xx = NC_FILL_DOUBLE;
#line 2021

#line 2021
    
#line 2021
        xx = (ix_double)*ip;
#line 2021

#line 2021
    put_ix_double(xp, &xx);
#line 2021
    return err;
#line 2021
}
#line 2021

static int
#line 2022
ncx_put_double_short(void *xp, const short *ip, void *fillp)
#line 2022
{
#line 2022
    int err=NC_NOERR;
#line 2022
    ix_double xx = NC_FILL_DOUBLE;
#line 2022

#line 2022
    
#line 2022
        xx = (ix_double)*ip;
#line 2022

#line 2022
    put_ix_double(xp, &xx);
#line 2022
    return err;
#line 2022
}
#line 2022

static int
#line 2023
ncx_put_double_ushort(void *xp, const ushort *ip, void *fillp)
#line 2023
{
#line 2023
    int err=NC_NOERR;
#line 2023
    ix_double xx = NC_FILL_DOUBLE;
#line 2023

#line 2023
    
#line 2023
        xx = (ix_double)*ip;
#line 2023

#line 2023
    put_ix_double(xp, &xx);
#line 2023
    return err;
#line 2023
}
#line 2023

static int
#line 2024
ncx_put_double_int(void *xp, const int *ip, void *fillp)
#line 2024
{
#line 2024
    int err=NC_NOERR;
#line 2024
    ix_double xx = NC_FILL_DOUBLE;
#line 2024

#line 2024
    
#line 2024
        xx = (ix_double)*ip;
#line 2024

#line 2024
    put_ix_double(xp, &xx);
#line 2024
    return err;
#line 2024
}
#line 2024

static int
#line 2025
ncx_put_double_long(void *xp, const long *ip, void *fillp)
#line 2025
{
#line 2025
    int err=NC_NOERR;
#line 2025
    ix_double xx = NC_FILL_DOUBLE;
#line 2025

#line 2025
    
#line 2025
        xx = (ix_double)*ip;
#line 2025

#line 2025
    put_ix_double(xp, &xx);
#line 2025
    return err;
#line 2025
}
#line 2025

static int
#line 2026
ncx_put_double_uint(void *xp, const uint *ip, void *fillp)
#line 2026
{
#line 2026
    int err=NC_NOERR;
#line 2026
    ix_double xx = NC_FILL_DOUBLE;
#line 2026

#line 2026
    
#line 2026
        xx = (ix_double)*ip;
#line 2026

#line 2026
    put_ix_double(xp, &xx);
#line 2026
    return err;
#line 2026
}
#line 2026

static int
#line 2027
ncx_put_double_longlong(void *xp, const longlong *ip, void *fillp)
#line 2027
{
#line 2027
    int err=NC_NOERR;
#line 2027
    ix_double xx = NC_FILL_DOUBLE;
#line 2027

#line 2027
    
#line 2027
        xx = (ix_double)*ip;
#line 2027

#line 2027
    put_ix_double(xp, &xx);
#line 2027
    return err;
#line 2027
}
#line 2027

static int
#line 2028
ncx_put_double_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 2028
{
#line 2028
    int err=NC_NOERR;
#line 2028
    ix_double xx = NC_FILL_DOUBLE;
#line 2028

#line 2028
    
#line 2028
        xx = (ix_double)*ip;
#line 2028

#line 2028
    put_ix_double(xp, &xx);
#line 2028
    return err;
#line 2028
}
#line 2028


static int
ncx_put_double_float(void *xp, const float *ip, void *fillp)
{
    int err=NC_NOERR;
    double xx = NC_FILL_DOUBLE;
#if 1	/* TODO: figure this out (if condition below will never be true)*/
    if ((double)(*ip) > X_DOUBLE_MAX || (double)(*ip) < X_DOUBLE_MIN) {
        
#line 2037
#ifdef ERANGE_FILL
#line 2037
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2037
#endif
        err = NC_ERANGE;
    }
#ifdef ERANGE_FILL
    else
#endif
#endif
        xx = (double) *ip;

    put_ix_double(xp, &xx);
    return err;
}

#if X_SIZEOF_DOUBLE != SIZEOF_DOUBLE  || defined(NO_IEEE_FLOAT)
static int
ncx_put_double_double(void *xp, const double *ip, void *fillp)
{
    int err=NC_NOERR;
    double *_ip = ip;
#ifdef NO_IEEE_FLOAT
#ifdef ERANGE_FILL
    double tmp=NC_FILL_DOUBLE;
#endif
    if (*ip > X_DOUBLE_MAX || *ip < X_DOUBLE_MIN) {
        
#line 2061
#ifdef ERANGE_FILL
#line 2061
            if (fillp != NULL) memcpy(&tmp, fillp, 8);
#line 2061
#endif
#ifdef ERANGE_FILL
        _ip = &tmp;
#endif
        err = NC_ERANGE;
    }
#endif
    put_ix_double(xp, _ip);
    return err;
}
#endif


/* external NC_INT64 --------------------------------------------------------*/

#if SHORT_MAX == X_INT64_MAX
typedef short ix_int64;
#define SIZEOF_IX_INT64 SIZEOF_SHORT
#define IX_INT64_MAX SHORT_MAX
#elif LONG_LONG_MAX  >= X_INT64_MAX
typedef longlong ix_int64;
#define SIZEOF_IX_INT64 SIZEOF_LONGLONG
#define IX_INT64_MAX LONG_LONG_MAX
#elif LONG_MAX  >= X_INT64_MAX
typedef long ix_int64;
#define SIZEOF_IX_INT64 SIZEOF_LONG
#define IX_INT64_MAX LONG_MAX
#else
#error "ix_int64 implementation"
#endif


static void
get_ix_int64(const void *xp, ix_int64 *ip)
{
    const uchar *cp = (const uchar *) xp;

    *ip  = ((ix_int64)(*cp++) << 56);
    *ip |= ((ix_int64)(*cp++) << 48);
    *ip |= ((ix_int64)(*cp++) << 40);
    *ip |= ((ix_int64)(*cp++) << 32);
    *ip |= ((ix_int64)(*cp++) << 24);
    *ip |= ((ix_int64)(*cp++) << 16);
    *ip |= ((ix_int64)(*cp++) <<  8);
    *ip |=  (ix_int64)*cp;
}

static void
put_ix_int64(void *xp, const ix_int64 *ip)
{
    uchar *cp = (uchar *) xp;

    *cp++ = (uchar)((*ip) >> 56);
    *cp++ = (uchar)(((*ip) & 0x00ff000000000000LL) >> 48);
    *cp++ = (uchar)(((*ip) & 0x0000ff0000000000LL) >> 40);
    *cp++ = (uchar)(((*ip) & 0x000000ff00000000LL) >> 32);
    *cp++ = (uchar)(((*ip) & 0x00000000ff000000LL) >> 24);
    *cp++ = (uchar)(((*ip) & 0x0000000000ff0000LL) >> 16);
    *cp++ = (uchar)(((*ip) & 0x000000000000ff00LL) >>  8);
    *cp   = (uchar)( (*ip) & 0x00000000000000ffLL);
}

#if X_SIZEOF_INT64 != SIZEOF_LONGLONG
static int
#line 2124
ncx_get_longlong_longlong(const void *xp, longlong *ip)
#line 2124
{
#line 2124
    int err=NC_NOERR;
#line 2124
#if SIZEOF_IX_INT64 == SIZEOF_LONGLONG && IX_INT64_MAX == LONGLONG_MAX
#line 2124
    get_ix_int64(xp, (ix_int64 *)ip);
#line 2124
#else
#line 2124
    ix_int64 xx = 0;
#line 2124
    get_ix_int64(xp, &xx);
#line 2124

#line 2124
#if IX_INT64_MAX > LONGLONG_MAX
#line 2124
    if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) {
#line 2124
#ifdef ERANGE_FILL
#line 2124
        *ip = NC_FILL_INT64;
#line 2124
        return NC_ERANGE;
#line 2124
#else
#line 2124
        err = NC_ERANGE;
#line 2124
#endif
#line 2124
    }
#line 2124
#endif
#line 2124

#line 2124

#line 2124
    *ip = (longlong) xx;
#line 2124
#endif
#line 2124
    return err;
#line 2124
}
#line 2124

#endif
static int
#line 2126
ncx_get_longlong_schar(const void *xp, schar *ip)
#line 2126
{
#line 2126
    int err=NC_NOERR;
#line 2126
    ix_int64 xx = 0;
#line 2126
    get_ix_int64(xp, &xx);
#line 2126

#line 2126
#if IX_INT64_MAX > SCHAR_MAX
#line 2126
    if (xx > SCHAR_MAX || xx < SCHAR_MIN) {
#line 2126
#ifdef ERANGE_FILL
#line 2126
        *ip = NC_FILL_BYTE;
#line 2126
        return NC_ERANGE;
#line 2126
#else
#line 2126
        err = NC_ERANGE;
#line 2126
#endif
#line 2126
    }
#line 2126
#endif
#line 2126

#line 2126

#line 2126
    *ip = (schar) xx;
#line 2126
    return err;
#line 2126
}
#line 2126

static int
#line 2127
ncx_get_longlong_short(const void *xp, short *ip)
#line 2127
{
#line 2127
    int err=NC_NOERR;
#line 2127
#if SIZEOF_IX_INT64 == SIZEOF_SHORT && IX_INT64_MAX == SHORT_MAX
#line 2127
    get_ix_int64(xp, (ix_int64 *)ip);
#line 2127
#else
#line 2127
    ix_int64 xx = 0;
#line 2127
    get_ix_int64(xp, &xx);
#line 2127

#line 2127
#if IX_INT64_MAX > SHORT_MAX
#line 2127
    if (xx > SHORT_MAX || xx < SHORT_MIN) {
#line 2127
#ifdef ERANGE_FILL
#line 2127
        *ip = NC_FILL_SHORT;
#line 2127
        return NC_ERANGE;
#line 2127
#else
#line 2127
        err = NC_ERANGE;
#line 2127
#endif
#line 2127
    }
#line 2127
#endif
#line 2127

#line 2127

#line 2127
    *ip = (short) xx;
#line 2127
#endif
#line 2127
    return err;
#line 2127
}
#line 2127

static int
#line 2128
ncx_get_longlong_int(const void *xp, int *ip)
#line 2128
{
#line 2128
    int err=NC_NOERR;
#line 2128
#if SIZEOF_IX_INT64 == SIZEOF_INT && IX_INT64_MAX == INT_MAX
#line 2128
    get_ix_int64(xp, (ix_int64 *)ip);
#line 2128
#else
#line 2128
    ix_int64 xx = 0;
#line 2128
    get_ix_int64(xp, &xx);
#line 2128

#line 2128
#if IX_INT64_MAX > INT_MAX
#line 2128
    if (xx > INT_MAX || xx < INT_MIN) {
#line 2128
#ifdef ERANGE_FILL
#line 2128
        *ip = NC_FILL_INT;
#line 2128
        return NC_ERANGE;
#line 2128
#else
#line 2128
        err = NC_ERANGE;
#line 2128
#endif
#line 2128
    }
#line 2128
#endif
#line 2128

#line 2128

#line 2128
    *ip = (int) xx;
#line 2128
#endif
#line 2128
    return err;
#line 2128
}
#line 2128

static int
#line 2129
ncx_get_longlong_long(const void *xp, long *ip)
#line 2129
{
#line 2129
    int err=NC_NOERR;
#line 2129
#if SIZEOF_IX_INT64 == SIZEOF_LONG && IX_INT64_MAX == LONG_MAX
#line 2129
    get_ix_int64(xp, (ix_int64 *)ip);
#line 2129
#else
#line 2129
    ix_int64 xx = 0;
#line 2129
    get_ix_int64(xp, &xx);
#line 2129

#line 2129
#if IX_INT64_MAX > LONG_MAX
#line 2129
    if (xx > LONG_MAX || xx < LONG_MIN) {
#line 2129
#ifdef ERANGE_FILL
#line 2129
        *ip = NC_FILL_INT;
#line 2129
        return NC_ERANGE;
#line 2129
#else
#line 2129
        err = NC_ERANGE;
#line 2129
#endif
#line 2129
    }
#line 2129
#endif
#line 2129

#line 2129

#line 2129
    *ip = (long) xx;
#line 2129
#endif
#line 2129
    return err;
#line 2129
}
#line 2129

static int
#line 2130
ncx_get_longlong_ushort(const void *xp, ushort *ip)
#line 2130
{
#line 2130
    int err=NC_NOERR;
#line 2130
    ix_int64 xx = 0;
#line 2130
    get_ix_int64(xp, &xx);
#line 2130

#line 2130
#if IX_INT64_MAX > USHORT_MAX
#line 2130
    if (xx > USHORT_MAX) {
#line 2130
#ifdef ERANGE_FILL
#line 2130
        *ip = NC_FILL_USHORT;
#line 2130
        return NC_ERANGE;
#line 2130
#else
#line 2130
        err = NC_ERANGE;
#line 2130
#endif
#line 2130
    }
#line 2130
#endif
#line 2130

#line 2130
    if (xx < 0) {
#line 2130
#ifdef ERANGE_FILL
#line 2130
        *ip = NC_FILL_USHORT;
#line 2130
        return NC_ERANGE;
#line 2130
#else
#line 2130
        err = NC_ERANGE; /* because ip is unsigned */
#line 2130
#endif
#line 2130
    }
#line 2130
    *ip = (ushort) xx;
#line 2130
    return err;
#line 2130
}
#line 2130

static int
#line 2131
ncx_get_longlong_uchar(const void *xp, uchar *ip)
#line 2131
{
#line 2131
    int err=NC_NOERR;
#line 2131
    ix_int64 xx = 0;
#line 2131
    get_ix_int64(xp, &xx);
#line 2131

#line 2131
#if IX_INT64_MAX > UCHAR_MAX
#line 2131
    if (xx > UCHAR_MAX) {
#line 2131
#ifdef ERANGE_FILL
#line 2131
        *ip = NC_FILL_UBYTE;
#line 2131
        return NC_ERANGE;
#line 2131
#else
#line 2131
        err = NC_ERANGE;
#line 2131
#endif
#line 2131
    }
#line 2131
#endif
#line 2131

#line 2131
    if (xx < 0) {
#line 2131
#ifdef ERANGE_FILL
#line 2131
        *ip = NC_FILL_UBYTE;
#line 2131
        return NC_ERANGE;
#line 2131
#else
#line 2131
        err = NC_ERANGE; /* because ip is unsigned */
#line 2131
#endif
#line 2131
    }
#line 2131
    *ip = (uchar) xx;
#line 2131
    return err;
#line 2131
}
#line 2131

static int
#line 2132
ncx_get_longlong_uint(const void *xp, uint *ip)
#line 2132
{
#line 2132
    int err=NC_NOERR;
#line 2132
    ix_int64 xx = 0;
#line 2132
    get_ix_int64(xp, &xx);
#line 2132

#line 2132
#if IX_INT64_MAX > UINT_MAX
#line 2132
    if (xx > UINT_MAX) {
#line 2132
#ifdef ERANGE_FILL
#line 2132
        *ip = NC_FILL_UINT;
#line 2132
        return NC_ERANGE;
#line 2132
#else
#line 2132
        err = NC_ERANGE;
#line 2132
#endif
#line 2132
    }
#line 2132
#endif
#line 2132

#line 2132
    if (xx < 0) {
#line 2132
#ifdef ERANGE_FILL
#line 2132
        *ip = NC_FILL_UINT;
#line 2132
        return NC_ERANGE;
#line 2132
#else
#line 2132
        err = NC_ERANGE; /* because ip is unsigned */
#line 2132
#endif
#line 2132
    }
#line 2132
    *ip = (uint) xx;
#line 2132
    return err;
#line 2132
}
#line 2132

static int
#line 2133
ncx_get_longlong_ulonglong(const void *xp, ulonglong *ip)
#line 2133
{
#line 2133
    int err=NC_NOERR;
#line 2133
    ix_int64 xx = 0;
#line 2133
    get_ix_int64(xp, &xx);
#line 2133

#line 2133
#if IX_INT64_MAX > ULONGLONG_MAX
#line 2133
    if (xx > ULONGLONG_MAX) {
#line 2133
#ifdef ERANGE_FILL
#line 2133
        *ip = NC_FILL_UINT64;
#line 2133
        return NC_ERANGE;
#line 2133
#else
#line 2133
        err = NC_ERANGE;
#line 2133
#endif
#line 2133
    }
#line 2133
#endif
#line 2133

#line 2133
    if (xx < 0) {
#line 2133
#ifdef ERANGE_FILL
#line 2133
        *ip = NC_FILL_UINT64;
#line 2133
        return NC_ERANGE;
#line 2133
#else
#line 2133
        err = NC_ERANGE; /* because ip is unsigned */
#line 2133
#endif
#line 2133
    }
#line 2133
    *ip = (ulonglong) xx;
#line 2133
    return err;
#line 2133
}
#line 2133

static int
#line 2134
ncx_get_longlong_float(const void *xp, float *ip)
#line 2134
{
#line 2134
	ix_int64 xx = 0;
#line 2134
	get_ix_int64(xp, &xx);
#line 2134
	*ip = (float)xx;
#line 2134
	return NC_NOERR;
#line 2134
}
#line 2134

static int
#line 2135
ncx_get_longlong_double(const void *xp, double *ip)
#line 2135
{
#line 2135
	ix_int64 xx = 0;
#line 2135
	get_ix_int64(xp, &xx);
#line 2135
	*ip = (double)xx;
#line 2135
	return NC_NOERR;
#line 2135
}
#line 2135


#if X_SIZEOF_INT64 != SIZEOF_LONGLONG
static int
#line 2138
ncx_put_longlong_longlong(void *xp, const longlong *ip, void *fillp)
#line 2138
{
#line 2138
    int err=NC_NOERR;
#line 2138
#if SIZEOF_IX_INT64 == SIZEOF_LONGLONG && IX_INT64_MAX == LONGLONG_MAX
#line 2138
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 2138
#else
#line 2138
    ix_int64 xx = NC_FILL_INT64;
#line 2138

#line 2138
#if IX_INT64_MAX < LONGLONG_MAX
#line 2138
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 2138
        
#line 2138
#ifdef ERANGE_FILL
#line 2138
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2138
#endif
#line 2138
        err = NC_ERANGE;
#line 2138
    }
#line 2138
#ifdef ERANGE_FILL
#line 2138
    else
#line 2138
#endif
#line 2138
#endif
#line 2138
        xx = (ix_int64)*ip;
#line 2138

#line 2138
    put_ix_int64(xp, &xx);
#line 2138
#endif
#line 2138
    return err;
#line 2138
}
#line 2138

#endif
static int
#line 2140
ncx_put_longlong_schar(void *xp, const schar *ip, void *fillp)
#line 2140
{
#line 2140
    int err=NC_NOERR;
#line 2140
    ix_int64 xx = NC_FILL_INT64;
#line 2140

#line 2140
#if IX_INT64_MAX < SCHAR_MAX
#line 2140
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 2140
        
#line 2140
#ifdef ERANGE_FILL
#line 2140
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2140
#endif
#line 2140
        err = NC_ERANGE;
#line 2140
    }
#line 2140
#ifdef ERANGE_FILL
#line 2140
    else
#line 2140
#endif
#line 2140
#endif
#line 2140
        xx = (ix_int64)*ip;
#line 2140

#line 2140
    put_ix_int64(xp, &xx);
#line 2140
    return err;
#line 2140
}
#line 2140

static int
#line 2141
ncx_put_longlong_short(void *xp, const short *ip, void *fillp)
#line 2141
{
#line 2141
    int err=NC_NOERR;
#line 2141
#if SIZEOF_IX_INT64 == SIZEOF_SHORT && IX_INT64_MAX == SHORT_MAX
#line 2141
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 2141
#else
#line 2141
    ix_int64 xx = NC_FILL_INT64;
#line 2141

#line 2141
#if IX_INT64_MAX < SHORT_MAX
#line 2141
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 2141
        
#line 2141
#ifdef ERANGE_FILL
#line 2141
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2141
#endif
#line 2141
        err = NC_ERANGE;
#line 2141
    }
#line 2141
#ifdef ERANGE_FILL
#line 2141
    else
#line 2141
#endif
#line 2141
#endif
#line 2141
        xx = (ix_int64)*ip;
#line 2141

#line 2141
    put_ix_int64(xp, &xx);
#line 2141
#endif
#line 2141
    return err;
#line 2141
}
#line 2141

static int
#line 2142
ncx_put_longlong_int(void *xp, const int *ip, void *fillp)
#line 2142
{
#line 2142
    int err=NC_NOERR;
#line 2142
#if SIZEOF_IX_INT64 == SIZEOF_INT && IX_INT64_MAX == INT_MAX
#line 2142
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 2142
#else
#line 2142
    ix_int64 xx = NC_FILL_INT64;
#line 2142

#line 2142
#if IX_INT64_MAX < INT_MAX
#line 2142
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 2142
        
#line 2142
#ifdef ERANGE_FILL
#line 2142
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2142
#endif
#line 2142
        err = NC_ERANGE;
#line 2142
    }
#line 2142
#ifdef ERANGE_FILL
#line 2142
    else
#line 2142
#endif
#line 2142
#endif
#line 2142
        xx = (ix_int64)*ip;
#line 2142

#line 2142
    put_ix_int64(xp, &xx);
#line 2142
#endif
#line 2142
    return err;
#line 2142
}
#line 2142

static int
#line 2143
ncx_put_longlong_long(void *xp, const long *ip, void *fillp)
#line 2143
{
#line 2143
    int err=NC_NOERR;
#line 2143
#if SIZEOF_IX_INT64 == SIZEOF_LONG && IX_INT64_MAX == LONG_MAX
#line 2143
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 2143
#else
#line 2143
    ix_int64 xx = NC_FILL_INT64;
#line 2143

#line 2143
#if IX_INT64_MAX < LONG_MAX
#line 2143
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 2143
        
#line 2143
#ifdef ERANGE_FILL
#line 2143
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2143
#endif
#line 2143
        err = NC_ERANGE;
#line 2143
    }
#line 2143
#ifdef ERANGE_FILL
#line 2143
    else
#line 2143
#endif
#line 2143
#endif
#line 2143
        xx = (ix_int64)*ip;
#line 2143

#line 2143
    put_ix_int64(xp, &xx);
#line 2143
#endif
#line 2143
    return err;
#line 2143
}
#line 2143

static int
#line 2144
ncx_put_longlong_ushort(void *xp, const ushort *ip, void *fillp)
#line 2144
{
#line 2144
    int err=NC_NOERR;
#line 2144
    ix_int64 xx = NC_FILL_INT64;
#line 2144

#line 2144
#if IX_INT64_MAX < USHORT_MAX
#line 2144
    if (*ip > IX_INT64_MAX) {
#line 2144
        
#line 2144
#ifdef ERANGE_FILL
#line 2144
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2144
#endif
#line 2144
        err = NC_ERANGE;
#line 2144
    }
#line 2144
#ifdef ERANGE_FILL
#line 2144
    else
#line 2144
#endif
#line 2144
#endif
#line 2144
        xx = (ix_int64)*ip;
#line 2144

#line 2144
    put_ix_int64(xp, &xx);
#line 2144
    return err;
#line 2144
}
#line 2144

static int
#line 2145
ncx_put_longlong_uchar(void *xp, const uchar *ip, void *fillp)
#line 2145
{
#line 2145
    int err=NC_NOERR;
#line 2145
    ix_int64 xx = NC_FILL_INT64;
#line 2145

#line 2145
#if IX_INT64_MAX < UCHAR_MAX
#line 2145
    if (*ip > IX_INT64_MAX) {
#line 2145
        
#line 2145
#ifdef ERANGE_FILL
#line 2145
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2145
#endif
#line 2145
        err = NC_ERANGE;
#line 2145
    }
#line 2145
#ifdef ERANGE_FILL
#line 2145
    else
#line 2145
#endif
#line 2145
#endif
#line 2145
        xx = (ix_int64)*ip;
#line 2145

#line 2145
    put_ix_int64(xp, &xx);
#line 2145
    return err;
#line 2145
}
#line 2145

static int
#line 2146
ncx_put_longlong_uint(void *xp, const uint *ip, void *fillp)
#line 2146
{
#line 2146
    int err=NC_NOERR;
#line 2146
    ix_int64 xx = NC_FILL_INT64;
#line 2146

#line 2146
#if IX_INT64_MAX < UINT_MAX
#line 2146
    if (*ip > IX_INT64_MAX) {
#line 2146
        
#line 2146
#ifdef ERANGE_FILL
#line 2146
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2146
#endif
#line 2146
        err = NC_ERANGE;
#line 2146
    }
#line 2146
#ifdef ERANGE_FILL
#line 2146
    else
#line 2146
#endif
#line 2146
#endif
#line 2146
        xx = (ix_int64)*ip;
#line 2146

#line 2146
    put_ix_int64(xp, &xx);
#line 2146
    return err;
#line 2146
}
#line 2146

static int
#line 2147
ncx_put_longlong_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 2147
{
#line 2147
    int err=NC_NOERR;
#line 2147
    ix_int64 xx = NC_FILL_INT64;
#line 2147

#line 2147
#if IX_INT64_MAX < ULONGLONG_MAX
#line 2147
    if (*ip > IX_INT64_MAX) {
#line 2147
        
#line 2147
#ifdef ERANGE_FILL
#line 2147
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2147
#endif
#line 2147
        err = NC_ERANGE;
#line 2147
    }
#line 2147
#ifdef ERANGE_FILL
#line 2147
    else
#line 2147
#endif
#line 2147
#endif
#line 2147
        xx = (ix_int64)*ip;
#line 2147

#line 2147
    put_ix_int64(xp, &xx);
#line 2147
    return err;
#line 2147
}
#line 2147

static int
#line 2148
ncx_put_longlong_float(void *xp, const float *ip, void *fillp)
#line 2148
{
#line 2148
    int err=NC_NOERR;
#line 2148
    ix_int64 xx = NC_FILL_INT64;
#line 2148

#line 2148
    if (*ip > (double)X_INT64_MAX || *ip < (double)X_INT64_MIN) {
#line 2148
        
#line 2148
#ifdef ERANGE_FILL
#line 2148
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2148
#endif
#line 2148
        err = NC_ERANGE;
#line 2148
    }
#line 2148
#ifdef ERANGE_FILL
#line 2148
    else
#line 2148
#endif
#line 2148
        xx = (ix_int64)*ip;
#line 2148

#line 2148
    put_ix_int64(xp, &xx);
#line 2148
    return err;
#line 2148
}
#line 2148

static int
#line 2149
ncx_put_longlong_double(void *xp, const double *ip, void *fillp)
#line 2149
{
#line 2149
    int err=NC_NOERR;
#line 2149
    ix_int64 xx = NC_FILL_INT64;
#line 2149

#line 2149
    if (*ip > X_INT64_MAX || *ip < X_INT64_MIN) {
#line 2149
        
#line 2149
#ifdef ERANGE_FILL
#line 2149
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2149
#endif
#line 2149
        err = NC_ERANGE;
#line 2149
    }
#line 2149
#ifdef ERANGE_FILL
#line 2149
    else
#line 2149
#endif
#line 2149
        xx = (ix_int64)*ip;
#line 2149

#line 2149
    put_ix_int64(xp, &xx);
#line 2149
    return err;
#line 2149
}
#line 2149



/* external NC_UINT64 -------------------------------------------------------*/

#if USHORT_MAX == X_UINT64_MAX
typedef ushort ix_uint64;
#define SIZEOF_IX_UINT64 SIZEOF_USHORT
#define IX_UINT64_MAX USHORT_MAX
#elif ULONG_LONG_MAX  >= X_UINT64_MAX
typedef ulonglong ix_uint64;
#define SIZEOF_IX_UINT64 SIZEOF_ULONGLONG
#define IX_UINT64_MAX ULONG_LONG_MAX
#elif ULONG_MAX  >= X_UINT64_MAX
typedef ulong ix_uint64;
#define SIZEOF_IX_UINT64 SIZEOF_ULONG
#define IX_UINT64_MAX ULONG_MAX
#else
#error "ix_uint64 implementation"
#endif


static void
get_ix_uint64(const void *xp, ix_uint64 *ip)
{
    const uchar *cp = (const uchar *) xp;

    *ip  = ((ix_uint64)(*cp++) << 56);
    *ip |= ((ix_uint64)(*cp++) << 48);
    *ip |= ((ix_uint64)(*cp++) << 40);
    *ip |= ((ix_uint64)(*cp++) << 32);
    *ip |= ((ix_uint64)(*cp++) << 24);
    *ip |= ((ix_uint64)(*cp++) << 16);
    *ip |= ((ix_uint64)(*cp++) <<  8);
    *ip |=  (ix_uint64)*cp;
}

static void
put_ix_uint64(void *xp, const ix_uint64 *ip)
{
    uchar *cp = (uchar *) xp;

    *cp++ = (uchar)((*ip) >> 56);
    *cp++ = (uchar)(((*ip) & 0x00ff000000000000ULL) >> 48);
    *cp++ = (uchar)(((*ip) & 0x0000ff0000000000ULL) >> 40);
    *cp++ = (uchar)(((*ip) & 0x000000ff00000000ULL) >> 32);
    *cp++ = (uchar)(((*ip) & 0x00000000ff000000ULL) >> 24);
    *cp++ = (uchar)(((*ip) & 0x0000000000ff0000ULL) >> 16);
    *cp++ = (uchar)(((*ip) & 0x000000000000ff00ULL) >>  8);
    *cp   = (uchar)( (*ip) & 0x00000000000000ffULL);
}

#if X_SIZEOF_UINT64 != SIZEOF_ULONGLONG
static int
#line 2202
ncx_get_ulonglong_ulonglong(const void *xp, ulonglong *ip)
#line 2202
{
#line 2202
    int err=NC_NOERR;
#line 2202
#if SIZEOF_IX_UINT64 == SIZEOF_ULONGLONG && IX_UINT64_MAX == ULONGLONG_MAX
#line 2202
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 2202
#else
#line 2202
    ix_uint64 xx = 0;
#line 2202
    get_ix_uint64(xp, &xx);
#line 2202

#line 2202
#if IX_UINT64_MAX > ULONGLONG_MAX
#line 2202
    if (xx > ULONGLONG_MAX) {
#line 2202
#ifdef ERANGE_FILL
#line 2202
        *ip = NC_FILL_UINT64;
#line 2202
        return NC_ERANGE;
#line 2202
#else
#line 2202
        err = NC_ERANGE;
#line 2202
#endif
#line 2202
    }
#line 2202
#endif
#line 2202

#line 2202

#line 2202
    *ip = (ulonglong) xx;
#line 2202
#endif
#line 2202
    return err;
#line 2202
}
#line 2202

#endif
static int
#line 2204
ncx_get_ulonglong_schar(const void *xp, schar *ip)
#line 2204
{
#line 2204
    int err=NC_NOERR;
#line 2204
    ix_uint64 xx = 0;
#line 2204
    get_ix_uint64(xp, &xx);
#line 2204

#line 2204
#if IX_UINT64_MAX > SCHAR_MAX
#line 2204
    if (xx > SCHAR_MAX) {
#line 2204
#ifdef ERANGE_FILL
#line 2204
        *ip = NC_FILL_BYTE;
#line 2204
        return NC_ERANGE;
#line 2204
#else
#line 2204
        err = NC_ERANGE;
#line 2204
#endif
#line 2204
    }
#line 2204
#endif
#line 2204

#line 2204

#line 2204
    *ip = (schar) xx;
#line 2204
    return err;
#line 2204
}
#line 2204

static int
#line 2205
ncx_get_ulonglong_short(const void *xp, short *ip)
#line 2205
{
#line 2205
    int err=NC_NOERR;
#line 2205
    ix_uint64 xx = 0;
#line 2205
    get_ix_uint64(xp, &xx);
#line 2205

#line 2205
#if IX_UINT64_MAX > SHORT_MAX
#line 2205
    if (xx > SHORT_MAX) {
#line 2205
#ifdef ERANGE_FILL
#line 2205
        *ip = NC_FILL_SHORT;
#line 2205
        return NC_ERANGE;
#line 2205
#else
#line 2205
        err = NC_ERANGE;
#line 2205
#endif
#line 2205
    }
#line 2205
#endif
#line 2205

#line 2205

#line 2205
    *ip = (short) xx;
#line 2205
    return err;
#line 2205
}
#line 2205

static int
#line 2206
ncx_get_ulonglong_int(const void *xp, int *ip)
#line 2206
{
#line 2206
    int err=NC_NOERR;
#line 2206
    ix_uint64 xx = 0;
#line 2206
    get_ix_uint64(xp, &xx);
#line 2206

#line 2206
#if IX_UINT64_MAX > INT_MAX
#line 2206
    if (xx > INT_MAX) {
#line 2206
#ifdef ERANGE_FILL
#line 2206
        *ip = NC_FILL_INT;
#line 2206
        return NC_ERANGE;
#line 2206
#else
#line 2206
        err = NC_ERANGE;
#line 2206
#endif
#line 2206
    }
#line 2206
#endif
#line 2206

#line 2206

#line 2206
    *ip = (int) xx;
#line 2206
    return err;
#line 2206
}
#line 2206

static int
#line 2207
ncx_get_ulonglong_long(const void *xp, long *ip)
#line 2207
{
#line 2207
    int err=NC_NOERR;
#line 2207
    ix_uint64 xx = 0;
#line 2207
    get_ix_uint64(xp, &xx);
#line 2207

#line 2207
#if IX_UINT64_MAX > LONG_MAX
#line 2207
    if (xx > LONG_MAX) {
#line 2207
#ifdef ERANGE_FILL
#line 2207
        *ip = NC_FILL_INT;
#line 2207
        return NC_ERANGE;
#line 2207
#else
#line 2207
        err = NC_ERANGE;
#line 2207
#endif
#line 2207
    }
#line 2207
#endif
#line 2207

#line 2207

#line 2207
    *ip = (long) xx;
#line 2207
    return err;
#line 2207
}
#line 2207

static int
#line 2208
ncx_get_ulonglong_longlong(const void *xp, longlong *ip)
#line 2208
{
#line 2208
    int err=NC_NOERR;
#line 2208
    ix_uint64 xx = 0;
#line 2208
    get_ix_uint64(xp, &xx);
#line 2208

#line 2208
#if IX_UINT64_MAX > LONGLONG_MAX
#line 2208
    if (xx > LONGLONG_MAX) {
#line 2208
#ifdef ERANGE_FILL
#line 2208
        *ip = NC_FILL_INT64;
#line 2208
        return NC_ERANGE;
#line 2208
#else
#line 2208
        err = NC_ERANGE;
#line 2208
#endif
#line 2208
    }
#line 2208
#endif
#line 2208

#line 2208

#line 2208
    *ip = (longlong) xx;
#line 2208
    return err;
#line 2208
}
#line 2208

static int
#line 2209
ncx_get_ulonglong_ushort(const void *xp, ushort *ip)
#line 2209
{
#line 2209
    int err=NC_NOERR;
#line 2209
#if SIZEOF_IX_UINT64 == SIZEOF_USHORT && IX_UINT64_MAX == USHORT_MAX
#line 2209
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 2209
#else
#line 2209
    ix_uint64 xx = 0;
#line 2209
    get_ix_uint64(xp, &xx);
#line 2209

#line 2209
#if IX_UINT64_MAX > USHORT_MAX
#line 2209
    if (xx > USHORT_MAX) {
#line 2209
#ifdef ERANGE_FILL
#line 2209
        *ip = NC_FILL_USHORT;
#line 2209
        return NC_ERANGE;
#line 2209
#else
#line 2209
        err = NC_ERANGE;
#line 2209
#endif
#line 2209
    }
#line 2209
#endif
#line 2209

#line 2209

#line 2209
    *ip = (ushort) xx;
#line 2209
#endif
#line 2209
    return err;
#line 2209
}
#line 2209

static int
#line 2210
ncx_get_ulonglong_uchar(const void *xp, uchar *ip)
#line 2210
{
#line 2210
    int err=NC_NOERR;
#line 2210
#if SIZEOF_IX_UINT64 == SIZEOF_UCHAR && IX_UINT64_MAX == UCHAR_MAX
#line 2210
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 2210
#else
#line 2210
    ix_uint64 xx = 0;
#line 2210
    get_ix_uint64(xp, &xx);
#line 2210

#line 2210
#if IX_UINT64_MAX > UCHAR_MAX
#line 2210
    if (xx > UCHAR_MAX) {
#line 2210
#ifdef ERANGE_FILL
#line 2210
        *ip = NC_FILL_UBYTE;
#line 2210
        return NC_ERANGE;
#line 2210
#else
#line 2210
        err = NC_ERANGE;
#line 2210
#endif
#line 2210
    }
#line 2210
#endif
#line 2210

#line 2210

#line 2210
    *ip = (uchar) xx;
#line 2210
#endif
#line 2210
    return err;
#line 2210
}
#line 2210

static int
#line 2211
ncx_get_ulonglong_uint(const void *xp, uint *ip)
#line 2211
{
#line 2211
    int err=NC_NOERR;
#line 2211
#if SIZEOF_IX_UINT64 == SIZEOF_UINT && IX_UINT64_MAX == UINT_MAX
#line 2211
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 2211
#else
#line 2211
    ix_uint64 xx = 0;
#line 2211
    get_ix_uint64(xp, &xx);
#line 2211

#line 2211
#if IX_UINT64_MAX > UINT_MAX
#line 2211
    if (xx > UINT_MAX) {
#line 2211
#ifdef ERANGE_FILL
#line 2211
        *ip = NC_FILL_UINT;
#line 2211
        return NC_ERANGE;
#line 2211
#else
#line 2211
        err = NC_ERANGE;
#line 2211
#endif
#line 2211
    }
#line 2211
#endif
#line 2211

#line 2211

#line 2211
    *ip = (uint) xx;
#line 2211
#endif
#line 2211
    return err;
#line 2211
}
#line 2211

static int
#line 2212
ncx_get_ulonglong_float(const void *xp, float *ip)
#line 2212
{
#line 2212
	ix_uint64 xx = 0;
#line 2212
	get_ix_uint64(xp, &xx);
#line 2212
	*ip = (float)xx;
#line 2212
	return NC_NOERR;
#line 2212
}
#line 2212

static int
#line 2213
ncx_get_ulonglong_double(const void *xp, double *ip)
#line 2213
{
#line 2213
	ix_uint64 xx = 0;
#line 2213
	get_ix_uint64(xp, &xx);
#line 2213
	*ip = (double)xx;
#line 2213
	return NC_NOERR;
#line 2213
}
#line 2213


#if X_SIZEOF_UINT64 != SIZEOF_ULONGLONG
static int
#line 2216
ncx_put_ulonglong_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 2216
{
#line 2216
    int err=NC_NOERR;
#line 2216
#if SIZEOF_IX_UINT64 == SIZEOF_ULONGLONG && IX_UINT64_MAX == ULONGLONG_MAX
#line 2216
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 2216
#else
#line 2216
    ix_uint64 xx = NC_FILL_UINT64;
#line 2216

#line 2216
#if IX_UINT64_MAX < ULONGLONG_MAX
#line 2216
    if (*ip > IX_UINT64_MAX) {
#line 2216
        
#line 2216
#ifdef ERANGE_FILL
#line 2216
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2216
#endif
#line 2216
        err = NC_ERANGE;
#line 2216
    }
#line 2216
#ifdef ERANGE_FILL
#line 2216
    else
#line 2216
#endif
#line 2216
#endif
#line 2216
        xx = (ix_uint64)*ip;
#line 2216

#line 2216
    put_ix_uint64(xp, &xx);
#line 2216
#endif
#line 2216
    return err;
#line 2216
}
#line 2216

#endif
static int
#line 2218
ncx_put_ulonglong_schar(void *xp, const schar *ip, void *fillp)
#line 2218
{
#line 2218
    int err=NC_NOERR;
#line 2218
    ix_uint64 xx = NC_FILL_UINT64;
#line 2218

#line 2218
#if IX_UINT64_MAX < SCHAR_MAX
#line 2218
    if (*ip > IX_UINT64_MAX) {
#line 2218
        
#line 2218
#ifdef ERANGE_FILL
#line 2218
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2218
#endif
#line 2218
        err = NC_ERANGE;
#line 2218
    }
#line 2218
#ifdef ERANGE_FILL
#line 2218
    else
#line 2218
#endif
#line 2218
#endif
#line 2218
    if (*ip < 0) {
#line 2218
        
#line 2218
#ifdef ERANGE_FILL
#line 2218
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2218
#endif
#line 2218
        err = NC_ERANGE; /* because xp is unsigned */
#line 2218
    }
#line 2218
#ifdef ERANGE_FILL
#line 2218
    else
#line 2218
#endif
#line 2218
        xx = (ix_uint64)*ip;
#line 2218

#line 2218
    put_ix_uint64(xp, &xx);
#line 2218
    return err;
#line 2218
}
#line 2218

static int
#line 2219
ncx_put_ulonglong_short(void *xp, const short *ip, void *fillp)
#line 2219
{
#line 2219
    int err=NC_NOERR;
#line 2219
    ix_uint64 xx = NC_FILL_UINT64;
#line 2219

#line 2219
#if IX_UINT64_MAX < SHORT_MAX
#line 2219
    if (*ip > IX_UINT64_MAX) {
#line 2219
        
#line 2219
#ifdef ERANGE_FILL
#line 2219
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2219
#endif
#line 2219
        err = NC_ERANGE;
#line 2219
    }
#line 2219
#ifdef ERANGE_FILL
#line 2219
    else
#line 2219
#endif
#line 2219
#endif
#line 2219
    if (*ip < 0) {
#line 2219
        
#line 2219
#ifdef ERANGE_FILL
#line 2219
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2219
#endif
#line 2219
        err = NC_ERANGE; /* because xp is unsigned */
#line 2219
    }
#line 2219
#ifdef ERANGE_FILL
#line 2219
    else
#line 2219
#endif
#line 2219
        xx = (ix_uint64)*ip;
#line 2219

#line 2219
    put_ix_uint64(xp, &xx);
#line 2219
    return err;
#line 2219
}
#line 2219

static int
#line 2220
ncx_put_ulonglong_int(void *xp, const int *ip, void *fillp)
#line 2220
{
#line 2220
    int err=NC_NOERR;
#line 2220
    ix_uint64 xx = NC_FILL_UINT64;
#line 2220

#line 2220
#if IX_UINT64_MAX < INT_MAX
#line 2220
    if (*ip > IX_UINT64_MAX) {
#line 2220
        
#line 2220
#ifdef ERANGE_FILL
#line 2220
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2220
#endif
#line 2220
        err = NC_ERANGE;
#line 2220
    }
#line 2220
#ifdef ERANGE_FILL
#line 2220
    else
#line 2220
#endif
#line 2220
#endif
#line 2220
    if (*ip < 0) {
#line 2220
        
#line 2220
#ifdef ERANGE_FILL
#line 2220
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2220
#endif
#line 2220
        err = NC_ERANGE; /* because xp is unsigned */
#line 2220
    }
#line 2220
#ifdef ERANGE_FILL
#line 2220
    else
#line 2220
#endif
#line 2220
        xx = (ix_uint64)*ip;
#line 2220

#line 2220
    put_ix_uint64(xp, &xx);
#line 2220
    return err;
#line 2220
}
#line 2220

static int
#line 2221
ncx_put_ulonglong_long(void *xp, const long *ip, void *fillp)
#line 2221
{
#line 2221
    int err=NC_NOERR;
#line 2221
    ix_uint64 xx = NC_FILL_UINT64;
#line 2221

#line 2221
#if IX_UINT64_MAX < LONG_MAX
#line 2221
    if (*ip > IX_UINT64_MAX) {
#line 2221
        
#line 2221
#ifdef ERANGE_FILL
#line 2221
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2221
#endif
#line 2221
        err = NC_ERANGE;
#line 2221
    }
#line 2221
#ifdef ERANGE_FILL
#line 2221
    else
#line 2221
#endif
#line 2221
#endif
#line 2221
    if (*ip < 0) {
#line 2221
        
#line 2221
#ifdef ERANGE_FILL
#line 2221
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2221
#endif
#line 2221
        err = NC_ERANGE; /* because xp is unsigned */
#line 2221
    }
#line 2221
#ifdef ERANGE_FILL
#line 2221
    else
#line 2221
#endif
#line 2221
        xx = (ix_uint64)*ip;
#line 2221

#line 2221
    put_ix_uint64(xp, &xx);
#line 2221
    return err;
#line 2221
}
#line 2221

static int
#line 2222
ncx_put_ulonglong_longlong(void *xp, const longlong *ip, void *fillp)
#line 2222
{
#line 2222
    int err=NC_NOERR;
#line 2222
    ix_uint64 xx = NC_FILL_UINT64;
#line 2222

#line 2222
#if IX_UINT64_MAX < LONGLONG_MAX
#line 2222
    if (*ip > IX_UINT64_MAX) {
#line 2222
        
#line 2222
#ifdef ERANGE_FILL
#line 2222
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2222
#endif
#line 2222
        err = NC_ERANGE;
#line 2222
    }
#line 2222
#ifdef ERANGE_FILL
#line 2222
    else
#line 2222
#endif
#line 2222
#endif
#line 2222
    if (*ip < 0) {
#line 2222
        
#line 2222
#ifdef ERANGE_FILL
#line 2222
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2222
#endif
#line 2222
        err = NC_ERANGE; /* because xp is unsigned */
#line 2222
    }
#line 2222
#ifdef ERANGE_FILL
#line 2222
    else
#line 2222
#endif
#line 2222
        xx = (ix_uint64)*ip;
#line 2222

#line 2222
    put_ix_uint64(xp, &xx);
#line 2222
    return err;
#line 2222
}
#line 2222

static int
#line 2223
ncx_put_ulonglong_uchar(void *xp, const uchar *ip, void *fillp)
#line 2223
{
#line 2223
    int err=NC_NOERR;
#line 2223
#if SIZEOF_IX_UINT64 == SIZEOF_UCHAR && IX_UINT64_MAX == UCHAR_MAX
#line 2223
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 2223
#else
#line 2223
    ix_uint64 xx = NC_FILL_UINT64;
#line 2223

#line 2223
#if IX_UINT64_MAX < UCHAR_MAX
#line 2223
    if (*ip > IX_UINT64_MAX) {
#line 2223
        
#line 2223
#ifdef ERANGE_FILL
#line 2223
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2223
#endif
#line 2223
        err = NC_ERANGE;
#line 2223
    }
#line 2223
#ifdef ERANGE_FILL
#line 2223
    else
#line 2223
#endif
#line 2223
#endif
#line 2223
        xx = (ix_uint64)*ip;
#line 2223

#line 2223
    put_ix_uint64(xp, &xx);
#line 2223
#endif
#line 2223
    return err;
#line 2223
}
#line 2223

static int
#line 2224
ncx_put_ulonglong_ushort(void *xp, const ushort *ip, void *fillp)
#line 2224
{
#line 2224
    int err=NC_NOERR;
#line 2224
#if SIZEOF_IX_UINT64 == SIZEOF_USHORT && IX_UINT64_MAX == USHORT_MAX
#line 2224
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 2224
#else
#line 2224
    ix_uint64 xx = NC_FILL_UINT64;
#line 2224

#line 2224
#if IX_UINT64_MAX < USHORT_MAX
#line 2224
    if (*ip > IX_UINT64_MAX) {
#line 2224
        
#line 2224
#ifdef ERANGE_FILL
#line 2224
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2224
#endif
#line 2224
        err = NC_ERANGE;
#line 2224
    }
#line 2224
#ifdef ERANGE_FILL
#line 2224
    else
#line 2224
#endif
#line 2224
#endif
#line 2224
        xx = (ix_uint64)*ip;
#line 2224

#line 2224
    put_ix_uint64(xp, &xx);
#line 2224
#endif
#line 2224
    return err;
#line 2224
}
#line 2224

static int
#line 2225
ncx_put_ulonglong_uint(void *xp, const uint *ip, void *fillp)
#line 2225
{
#line 2225
    int err=NC_NOERR;
#line 2225
#if SIZEOF_IX_UINT64 == SIZEOF_UINT && IX_UINT64_MAX == UINT_MAX
#line 2225
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 2225
#else
#line 2225
    ix_uint64 xx = NC_FILL_UINT64;
#line 2225

#line 2225
#if IX_UINT64_MAX < UINT_MAX
#line 2225
    if (*ip > IX_UINT64_MAX) {
#line 2225
        
#line 2225
#ifdef ERANGE_FILL
#line 2225
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2225
#endif
#line 2225
        err = NC_ERANGE;
#line 2225
    }
#line 2225
#ifdef ERANGE_FILL
#line 2225
    else
#line 2225
#endif
#line 2225
#endif
#line 2225
        xx = (ix_uint64)*ip;
#line 2225

#line 2225
    put_ix_uint64(xp, &xx);
#line 2225
#endif
#line 2225
    return err;
#line 2225
}
#line 2225

static int
#line 2226
ncx_put_ulonglong_float(void *xp, const float *ip, void *fillp)
#line 2226
{
#line 2226
    int err=NC_NOERR;
#line 2226
    ix_uint64 xx = NC_FILL_UINT64;
#line 2226

#line 2226
    if (*ip > (double)X_UINT64_MAX || *ip < 0) {
#line 2226
        
#line 2226
#ifdef ERANGE_FILL
#line 2226
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2226
#endif
#line 2226
        err = NC_ERANGE;
#line 2226
    }
#line 2226
#ifdef ERANGE_FILL
#line 2226
    else
#line 2226
#endif
#line 2226
        xx = (ix_uint64)*ip;
#line 2226

#line 2226
    put_ix_uint64(xp, &xx);
#line 2226
    return err;
#line 2226
}
#line 2226

static int
#line 2227
ncx_put_ulonglong_double(void *xp, const double *ip, void *fillp)
#line 2227
{
#line 2227
    int err=NC_NOERR;
#line 2227
    ix_uint64 xx = NC_FILL_UINT64;
#line 2227

#line 2227
    if (*ip > X_UINT64_MAX || *ip < 0) {
#line 2227
        
#line 2227
#ifdef ERANGE_FILL
#line 2227
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2227
#endif
#line 2227
        err = NC_ERANGE;
#line 2227
    }
#line 2227
#ifdef ERANGE_FILL
#line 2227
    else
#line 2227
#endif
#line 2227
        xx = (ix_uint64)*ip;
#line 2227

#line 2227
    put_ix_uint64(xp, &xx);
#line 2227
    return err;
#line 2227
}
#line 2227



/* x_size_t */

#if SIZEOF_SIZE_T < X_SIZEOF_SIZE_T
#error "x_size_t implementation"
/* netcdf requires size_t which can hold a values from 0 to 2^32 -1 */
#endif

int
ncx_put_size_t(void **xpp, const size_t *ulp)
{
	/* similar to put_ix_int() */
	uchar *cp = (uchar *) *xpp;
	assert(*ulp <= X_SIZE_MAX);

	*cp++ = (uchar)((*ulp) >> 24);
	*cp++ = (uchar)(((*ulp) & 0x00ff0000) >> 16);
	*cp++ = (uchar)(((*ulp) & 0x0000ff00) >>  8);
	*cp   = (uchar)((*ulp) & 0x000000ff);

	*xpp = (void *)((char *)(*xpp) + X_SIZEOF_SIZE_T);
	return NC_NOERR;
}

int
ncx_get_size_t(const void **xpp,  size_t *ulp)
{
	/* similar to get_ix_int */
	const uchar *cp = (const uchar *) *xpp;

	*ulp  = (unsigned)(*cp++) << 24;
	*ulp |= (*cp++ << 16);
	*ulp |= (*cp++ << 8);
	*ulp |= *cp;

	*xpp = (const void *)((const char *)(*xpp) + X_SIZEOF_SIZE_T);
	return NC_NOERR;
}

/* x_off_t */

int
ncx_put_off_t(void **xpp, const off_t *lp, size_t sizeof_off_t)
{
	/* similar to put_ix_int() */
	uchar *cp = (uchar *) *xpp;

	/* No negative offsets stored in netcdf */
	if (*lp < 0) {
	  /* Assume this is an overflow of a 32-bit int... */
	  return NC_ERANGE;
	}

	assert(sizeof_off_t == 4 || sizeof_off_t == 8);

	if (sizeof_off_t == 4) {
		*cp++ = (uchar) ((*lp)               >> 24);
		*cp++ = (uchar)(((*lp) & 0x00ff0000) >> 16);
		*cp++ = (uchar)(((*lp) & 0x0000ff00) >>  8);
		*cp   = (uchar)( (*lp) & 0x000000ff);
	} else {
#if SIZEOF_OFF_T == 4
/* Write a 64-bit offset on a system with only a 32-bit offset */
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;

		*cp++ = (uchar)(((*lp) & 0xff000000) >> 24);
		*cp++ = (uchar)(((*lp) & 0x00ff0000) >> 16);
		*cp++ = (uchar)(((*lp) & 0x0000ff00) >>  8);
		*cp   = (uchar)( (*lp) & 0x000000ff);
#else
		*cp++ = (uchar) ((*lp)                          >> 56);
		*cp++ = (uchar)(((*lp) & 0x00ff000000000000LL) >> 48);
		*cp++ = (uchar)(((*lp) & 0x0000ff0000000000LL) >> 40);
		*cp++ = (uchar)(((*lp) & 0x000000ff00000000LL) >> 32);
		*cp++ = (uchar)(((*lp) & 0x00000000ff000000LL) >> 24);
		*cp++ = (uchar)(((*lp) & 0x0000000000ff0000LL) >> 16);
		*cp++ = (uchar)(((*lp) & 0x000000000000ff00LL) >>  8);
		*cp   = (uchar)( (*lp) & 0x00000000000000ffLL);
#endif
	}
	*xpp = (void *)((char *)(*xpp) + sizeof_off_t);
	return NC_NOERR;
}

int
ncx_get_off_t(const void **xpp, off_t *lp, size_t sizeof_off_t)
{
	/* similar to get_ix_int() */
	const uchar *cp = (const uchar *) *xpp;
	assert(sizeof_off_t == 4 || sizeof_off_t == 8);

 	if (sizeof_off_t == 4) {
		*lp =  (off_t)(*cp++ << 24);
		*lp |= (off_t)(*cp++ << 16);
		*lp |= (off_t)(*cp++ <<  8);
		*lp |= (off_t)*cp;
	} else {
#if SIZEOF_OFF_T == 4
/* Read a 64-bit offset on a system with only a 32-bit offset */
/* If the offset overflows, set an error code and return */
		*lp =  ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |= ((off_t)(*cp++));
/*
 * lp now contains the upper 32-bits of the 64-bit offset.  if lp is
 * not zero, then the dataset is larger than can be represented
 * on this system.  Set an error code and return.
 */
		if (*lp != 0) {
		  return NC_ERANGE;
		}

		*lp  = ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |=  (off_t)*cp;

		if (*lp < 0) {
		  /*
		   * If this fails, then the offset is >2^31, but less
		   * than 2^32 which is not allowed, but is not caught
		   * by the previous check
		   */
		  return NC_ERANGE;
		}
#else
		*lp =  ((off_t)(*cp++) << 56);
		*lp |= ((off_t)(*cp++) << 48);
		*lp |= ((off_t)(*cp++) << 40);
		*lp |= ((off_t)(*cp++) << 32);
		*lp |= ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |=  (off_t)*cp;
#endif
	}
	*xpp = (const void *)((const char *)(*xpp) + sizeof_off_t);
	return NC_NOERR;
}

/*----< ncx_get_uint32() >------------------------------------------*/
int
ncx_get_uint32(const void **xpp, uint *ip)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(ip, *xpp, SIZEOF_UINT);
#else
    const uchar *cp = (const uchar *) *xpp;

    *ip = (uint)(*cp++ << 24);
    *ip = (uint)(*ip | (uint)(*cp++ << 16));
    *ip = (uint)(*ip | (uint)(*cp++ <<  8));
    *ip = (uint)(*ip | *cp);
#endif
    /* advance *xpp 4 bytes */
    *xpp = (void *)((const char *)(*xpp) + 4);

    return NC_NOERR;
}

/*----< ncx_get_uint64() >------------------------------------------*/
int
ncx_get_uint64(const void **xpp, unsigned long long *ullp)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(ullp, *xpp, SIZEOF_UINT64);
#else
    const uchar *cp = (const uchar *) *xpp;

    /* below is the same as calling swap8b(ullp, *xpp) */
    *ullp = (unsigned long long)(*cp++) << 56;
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 48);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 40);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 32);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 24);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 16);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) <<  8);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp));
#endif
    /* advance *xpp 8 bytes */
    *xpp = (void *)((const char *)(*xpp) + 8);

    return NC_NOERR;
}

/*---< ncx_put_uint32() >-------------------------------------------*/
/* copy the contents of ip (an unsigned 32-bit integer) to xpp in Big Endian
 * form and advance *xpp 4 bytes
 */
int
ncx_put_uint32(void **xpp, const unsigned int ip)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(*xpp, &ip, X_SIZEOF_UINT);
#else
    /* bitwise shifts below are to produce an integer in Big Endian */
    uchar *cp = (uchar *) *xpp;
    *cp++ = (uchar)((ip & 0xff000000) >> 24);
    *cp++ = (uchar)((ip & 0x00ff0000) >> 16);
    *cp++ = (uchar)((ip & 0x0000ff00) >>  8);
    *cp   = (uchar)( ip & 0x000000ff);
#endif
    /* advance *xpp 4 bytes */
    *xpp  = (void *)((char *)(*xpp) + 4);

    return NC_NOERR;
}

/*---< ncx_put_uint64() >-------------------------------------------*/
/* copy the contents of ip (an unsigned 64-bit integer) to xpp in Big Endian
 * form and advance *xpp 8 bytes
 */
int
ncx_put_uint64(void **xpp, const unsigned long long ip)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(*xpp, &ip, X_SIZEOF_UINT64);
#else
    uchar *cp = (uchar *) *xpp;
    /* below is the same as calling swap8b(*xpp, &ip) */
    *cp++ = (uchar) (ip                         >> 56);
    *cp++ = (uchar)((ip & 0x00ff000000000000LL) >> 48);
    *cp++ = (uchar)((ip & 0x0000ff0000000000LL) >> 40);
    *cp++ = (uchar)((ip & 0x000000ff00000000LL) >> 32);
    *cp++ = (uchar)((ip & 0x00000000ff000000LL) >> 24);
    *cp++ = (uchar)((ip & 0x0000000000ff0000LL) >> 16);
    *cp++ = (uchar)((ip & 0x000000000000ff00LL) >>  8);
    *cp   = (uchar) (ip & 0x00000000000000ffLL);
#endif
    /* advance *xpp 8 bytes */
    *xpp  = (void *)((char *)(*xpp) + 8);

    return NC_NOERR;
}


/*
 * Aggregate numeric conversion functions.
 */
#line 2483

#line 2886

#line 2892

/* schar ---------------------------------------------------------------------*/

#line 2896
int
ncx_getn_schar_schar(const void **xpp, size_t nelems, schar *tp)
{
		(void) memcpy(tp, *xpp, (size_t)nelems);
#line 2899
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2899
	return NC_NOERR;
#line 2899

}
int
#line 2901
ncx_getn_schar_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2901
{
#line 2901
    int status = NC_NOERR;
#line 2901
    schar *xp = (schar *)(*xpp);
#line 2901

#line 2901
    while (nelems-- != 0) {
#line 2901
        
#line 2901
        if (*xp < 0) {
#line 2901
#ifdef ERANGE_FILL
#line 2901
            *tp = NC_FILL_UBYTE;
#line 2901
#endif
#line 2901
            status = NC_ERANGE; /* because tp is unsigned */
#line 2901
            
#line 2901
#ifdef ERANGE_FILL
#line 2901
            xp++; tp++; continue;
#line 2901
#endif
#line 2901
        }
#line 2901
        *tp++ = (uchar) (signed) (*xp++);  /* type cast from schar to uchar */
#line 2901
    }
#line 2901

#line 2901
    *xpp = (const void *)xp;
#line 2901
    return status;
#line 2901
}
#line 2901

int
#line 2902
ncx_getn_schar_short(const void **xpp, size_t nelems, short *tp)
#line 2902
{
#line 2902
    int status = NC_NOERR;
#line 2902
    schar *xp = (schar *)(*xpp);
#line 2902

#line 2902
    while (nelems-- != 0) {
#line 2902
        
#line 2902
        *tp++ = (short)  (*xp++);  /* type cast from schar to short */
#line 2902
    }
#line 2902

#line 2902
    *xpp = (const void *)xp;
#line 2902
    return status;
#line 2902
}
#line 2902

int
#line 2903
ncx_getn_schar_int(const void **xpp, size_t nelems, int *tp)
#line 2903
{
#line 2903
    int status = NC_NOERR;
#line 2903
    schar *xp = (schar *)(*xpp);
#line 2903

#line 2903
    while (nelems-- != 0) {
#line 2903
        
#line 2903
        *tp++ = (int)  (*xp++);  /* type cast from schar to int */
#line 2903
    }
#line 2903

#line 2903
    *xpp = (const void *)xp;
#line 2903
    return status;
#line 2903
}
#line 2903

int
#line 2904
ncx_getn_schar_long(const void **xpp, size_t nelems, long *tp)
#line 2904
{
#line 2904
    int status = NC_NOERR;
#line 2904
    schar *xp = (schar *)(*xpp);
#line 2904

#line 2904
    while (nelems-- != 0) {
#line 2904
        
#line 2904
        *tp++ = (long)  (*xp++);  /* type cast from schar to long */
#line 2904
    }
#line 2904

#line 2904
    *xpp = (const void *)xp;
#line 2904
    return status;
#line 2904
}
#line 2904

int
#line 2905
ncx_getn_schar_float(const void **xpp, size_t nelems, float *tp)
#line 2905
{
#line 2905
    int status = NC_NOERR;
#line 2905
    schar *xp = (schar *)(*xpp);
#line 2905

#line 2905
    while (nelems-- != 0) {
#line 2905
        
#line 2905
        *tp++ = (float)  (*xp++);  /* type cast from schar to float */
#line 2905
    }
#line 2905

#line 2905
    *xpp = (const void *)xp;
#line 2905
    return status;
#line 2905
}
#line 2905

int
#line 2906
ncx_getn_schar_double(const void **xpp, size_t nelems, double *tp)
#line 2906
{
#line 2906
    int status = NC_NOERR;
#line 2906
    schar *xp = (schar *)(*xpp);
#line 2906

#line 2906
    while (nelems-- != 0) {
#line 2906
        
#line 2906
        *tp++ = (double)  (*xp++);  /* type cast from schar to double */
#line 2906
    }
#line 2906

#line 2906
    *xpp = (const void *)xp;
#line 2906
    return status;
#line 2906
}
#line 2906

int
#line 2907
ncx_getn_schar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2907
{
#line 2907
    int status = NC_NOERR;
#line 2907
    schar *xp = (schar *)(*xpp);
#line 2907

#line 2907
    while (nelems-- != 0) {
#line 2907
        
#line 2907
        *tp++ = (longlong)  (*xp++);  /* type cast from schar to longlong */
#line 2907
    }
#line 2907

#line 2907
    *xpp = (const void *)xp;
#line 2907
    return status;
#line 2907
}
#line 2907

int
#line 2908
ncx_getn_schar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2908
{
#line 2908
    int status = NC_NOERR;
#line 2908
    schar *xp = (schar *)(*xpp);
#line 2908

#line 2908
    while (nelems-- != 0) {
#line 2908
        
#line 2908
        if (*xp < 0) {
#line 2908
#ifdef ERANGE_FILL
#line 2908
            *tp = NC_FILL_USHORT;
#line 2908
#endif
#line 2908
            status = NC_ERANGE; /* because tp is unsigned */
#line 2908
            
#line 2908
#ifdef ERANGE_FILL
#line 2908
            xp++; tp++; continue;
#line 2908
#endif
#line 2908
        }
#line 2908
        *tp++ = (ushort) (signed) (*xp++);  /* type cast from schar to ushort */
#line 2908
    }
#line 2908

#line 2908
    *xpp = (const void *)xp;
#line 2908
    return status;
#line 2908
}
#line 2908

int
#line 2909
ncx_getn_schar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2909
{
#line 2909
    int status = NC_NOERR;
#line 2909
    schar *xp = (schar *)(*xpp);
#line 2909

#line 2909
    while (nelems-- != 0) {
#line 2909
        
#line 2909
        if (*xp < 0) {
#line 2909
#ifdef ERANGE_FILL
#line 2909
            *tp = NC_FILL_UINT;
#line 2909
#endif
#line 2909
            status = NC_ERANGE; /* because tp is unsigned */
#line 2909
            
#line 2909
#ifdef ERANGE_FILL
#line 2909
            xp++; tp++; continue;
#line 2909
#endif
#line 2909
        }
#line 2909
        *tp++ = (uint) (signed) (*xp++);  /* type cast from schar to uint */
#line 2909
    }
#line 2909

#line 2909
    *xpp = (const void *)xp;
#line 2909
    return status;
#line 2909
}
#line 2909

int
#line 2910
ncx_getn_schar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2910
{
#line 2910
    int status = NC_NOERR;
#line 2910
    schar *xp = (schar *)(*xpp);
#line 2910

#line 2910
    while (nelems-- != 0) {
#line 2910
        
#line 2910
        if (*xp < 0) {
#line 2910
#ifdef ERANGE_FILL
#line 2910
            *tp = NC_FILL_UINT64;
#line 2910
#endif
#line 2910
            status = NC_ERANGE; /* because tp is unsigned */
#line 2910
            
#line 2910
#ifdef ERANGE_FILL
#line 2910
            xp++; tp++; continue;
#line 2910
#endif
#line 2910
        }
#line 2910
        *tp++ = (ulonglong) (signed) (*xp++);  /* type cast from schar to ulonglong */
#line 2910
    }
#line 2910

#line 2910
    *xpp = (const void *)xp;
#line 2910
    return status;
#line 2910
}
#line 2910


#line 2913
int
ncx_pad_getn_schar_schar(const void **xpp, size_t nelems, schar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2916

#line 2916
	if (rndup)
#line 2916
		rndup = X_ALIGN - rndup;
#line 2916

#line 2916
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 2916
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 2916

#line 2916
	return NC_NOERR;
#line 2916

}
int
#line 2918
ncx_pad_getn_schar_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2918
{
#line 2918
    int status = NC_NOERR;
#line 2918
    size_t rndup = nelems % X_ALIGN;
#line 2918
    schar *xp = (schar *) *xpp;
#line 2918

#line 2918
    if (rndup)
#line 2918
        rndup = X_ALIGN - rndup;
#line 2918

#line 2918
    while (nelems-- != 0) {
#line 2918
        
#line 2918
        if (*xp < 0) {
#line 2918
#ifdef ERANGE_FILL
#line 2918
            *tp = NC_FILL_UBYTE;
#line 2918
#endif
#line 2918
            status = NC_ERANGE; /* because tp is unsigned */
#line 2918
            
#line 2918
#ifdef ERANGE_FILL
#line 2918
            xp++; tp++; continue;
#line 2918
#endif
#line 2918
        }
#line 2918
        *tp++ = (uchar) (signed) (*xp++);  /* type cast from schar to uchar */
#line 2918
    }
#line 2918

#line 2918
    *xpp = (void *)(xp + rndup);
#line 2918
    return status;
#line 2918
}
#line 2918

int
#line 2919
ncx_pad_getn_schar_short(const void **xpp, size_t nelems, short *tp)
#line 2919
{
#line 2919
    int status = NC_NOERR;
#line 2919
    size_t rndup = nelems % X_ALIGN;
#line 2919
    schar *xp = (schar *) *xpp;
#line 2919

#line 2919
    if (rndup)
#line 2919
        rndup = X_ALIGN - rndup;
#line 2919

#line 2919
    while (nelems-- != 0) {
#line 2919
        
#line 2919
        *tp++ = (short)  (*xp++);  /* type cast from schar to short */
#line 2919
    }
#line 2919

#line 2919
    *xpp = (void *)(xp + rndup);
#line 2919
    return status;
#line 2919
}
#line 2919

int
#line 2920
ncx_pad_getn_schar_int(const void **xpp, size_t nelems, int *tp)
#line 2920
{
#line 2920
    int status = NC_NOERR;
#line 2920
    size_t rndup = nelems % X_ALIGN;
#line 2920
    schar *xp = (schar *) *xpp;
#line 2920

#line 2920
    if (rndup)
#line 2920
        rndup = X_ALIGN - rndup;
#line 2920

#line 2920
    while (nelems-- != 0) {
#line 2920
        
#line 2920
        *tp++ = (int)  (*xp++);  /* type cast from schar to int */
#line 2920
    }
#line 2920

#line 2920
    *xpp = (void *)(xp + rndup);
#line 2920
    return status;
#line 2920
}
#line 2920

int
#line 2921
ncx_pad_getn_schar_long(const void **xpp, size_t nelems, long *tp)
#line 2921
{
#line 2921
    int status = NC_NOERR;
#line 2921
    size_t rndup = nelems % X_ALIGN;
#line 2921
    schar *xp = (schar *) *xpp;
#line 2921

#line 2921
    if (rndup)
#line 2921
        rndup = X_ALIGN - rndup;
#line 2921

#line 2921
    while (nelems-- != 0) {
#line 2921
        
#line 2921
        *tp++ = (long)  (*xp++);  /* type cast from schar to long */
#line 2921
    }
#line 2921

#line 2921
    *xpp = (void *)(xp + rndup);
#line 2921
    return status;
#line 2921
}
#line 2921

int
#line 2922
ncx_pad_getn_schar_float(const void **xpp, size_t nelems, float *tp)
#line 2922
{
#line 2922
    int status = NC_NOERR;
#line 2922
    size_t rndup = nelems % X_ALIGN;
#line 2922
    schar *xp = (schar *) *xpp;
#line 2922

#line 2922
    if (rndup)
#line 2922
        rndup = X_ALIGN - rndup;
#line 2922

#line 2922
    while (nelems-- != 0) {
#line 2922
        
#line 2922
        *tp++ = (float)  (*xp++);  /* type cast from schar to float */
#line 2922
    }
#line 2922

#line 2922
    *xpp = (void *)(xp + rndup);
#line 2922
    return status;
#line 2922
}
#line 2922

int
#line 2923
ncx_pad_getn_schar_double(const void **xpp, size_t nelems, double *tp)
#line 2923
{
#line 2923
    int status = NC_NOERR;
#line 2923
    size_t rndup = nelems % X_ALIGN;
#line 2923
    schar *xp = (schar *) *xpp;
#line 2923

#line 2923
    if (rndup)
#line 2923
        rndup = X_ALIGN - rndup;
#line 2923

#line 2923
    while (nelems-- != 0) {
#line 2923
        
#line 2923
        *tp++ = (double)  (*xp++);  /* type cast from schar to double */
#line 2923
    }
#line 2923

#line 2923
    *xpp = (void *)(xp + rndup);
#line 2923
    return status;
#line 2923
}
#line 2923

int
#line 2924
ncx_pad_getn_schar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2924
{
#line 2924
    int status = NC_NOERR;
#line 2924
    size_t rndup = nelems % X_ALIGN;
#line 2924
    schar *xp = (schar *) *xpp;
#line 2924

#line 2924
    if (rndup)
#line 2924
        rndup = X_ALIGN - rndup;
#line 2924

#line 2924
    while (nelems-- != 0) {
#line 2924
        
#line 2924
        *tp++ = (longlong)  (*xp++);  /* type cast from schar to longlong */
#line 2924
    }
#line 2924

#line 2924
    *xpp = (void *)(xp + rndup);
#line 2924
    return status;
#line 2924
}
#line 2924

int
#line 2925
ncx_pad_getn_schar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2925
{
#line 2925
    int status = NC_NOERR;
#line 2925
    size_t rndup = nelems % X_ALIGN;
#line 2925
    schar *xp = (schar *) *xpp;
#line 2925

#line 2925
    if (rndup)
#line 2925
        rndup = X_ALIGN - rndup;
#line 2925

#line 2925
    while (nelems-- != 0) {
#line 2925
        
#line 2925
        if (*xp < 0) {
#line 2925
#ifdef ERANGE_FILL
#line 2925
            *tp = NC_FILL_USHORT;
#line 2925
#endif
#line 2925
            status = NC_ERANGE; /* because tp is unsigned */
#line 2925
            
#line 2925
#ifdef ERANGE_FILL
#line 2925
            xp++; tp++; continue;
#line 2925
#endif
#line 2925
        }
#line 2925
        *tp++ = (ushort) (signed) (*xp++);  /* type cast from schar to ushort */
#line 2925
    }
#line 2925

#line 2925
    *xpp = (void *)(xp + rndup);
#line 2925
    return status;
#line 2925
}
#line 2925

int
#line 2926
ncx_pad_getn_schar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2926
{
#line 2926
    int status = NC_NOERR;
#line 2926
    size_t rndup = nelems % X_ALIGN;
#line 2926
    schar *xp = (schar *) *xpp;
#line 2926

#line 2926
    if (rndup)
#line 2926
        rndup = X_ALIGN - rndup;
#line 2926

#line 2926
    while (nelems-- != 0) {
#line 2926
        
#line 2926
        if (*xp < 0) {
#line 2926
#ifdef ERANGE_FILL
#line 2926
            *tp = NC_FILL_UINT;
#line 2926
#endif
#line 2926
            status = NC_ERANGE; /* because tp is unsigned */
#line 2926
            
#line 2926
#ifdef ERANGE_FILL
#line 2926
            xp++; tp++; continue;
#line 2926
#endif
#line 2926
        }
#line 2926
        *tp++ = (uint) (signed) (*xp++);  /* type cast from schar to uint */
#line 2926
    }
#line 2926

#line 2926
    *xpp = (void *)(xp + rndup);
#line 2926
    return status;
#line 2926
}
#line 2926

int
#line 2927
ncx_pad_getn_schar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2927
{
#line 2927
    int status = NC_NOERR;
#line 2927
    size_t rndup = nelems % X_ALIGN;
#line 2927
    schar *xp = (schar *) *xpp;
#line 2927

#line 2927
    if (rndup)
#line 2927
        rndup = X_ALIGN - rndup;
#line 2927

#line 2927
    while (nelems-- != 0) {
#line 2927
        
#line 2927
        if (*xp < 0) {
#line 2927
#ifdef ERANGE_FILL
#line 2927
            *tp = NC_FILL_UINT64;
#line 2927
#endif
#line 2927
            status = NC_ERANGE; /* because tp is unsigned */
#line 2927
            
#line 2927
#ifdef ERANGE_FILL
#line 2927
            xp++; tp++; continue;
#line 2927
#endif
#line 2927
        }
#line 2927
        *tp++ = (ulonglong) (signed) (*xp++);  /* type cast from schar to ulonglong */
#line 2927
    }
#line 2927

#line 2927
    *xpp = (void *)(xp + rndup);
#line 2927
    return status;
#line 2927
}
#line 2927


#line 2930
int
ncx_putn_schar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
		(void) memcpy(*xpp, tp, (size_t)nelems);
#line 2933
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2933

#line 2933
	return NC_NOERR;
#line 2933

}
int
#line 2935
ncx_putn_schar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 2935
{
#line 2935
    int status = NC_NOERR;
#line 2935
    schar *xp = (schar *) *xpp;
#line 2935

#line 2935
    while (nelems-- != 0) {
#line 2935
        if (*tp > (uchar)X_SCHAR_MAX ) {
#line 2935
            
#line 2935
#ifdef ERANGE_FILL
#line 2935
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2935
#endif
#line 2935
            status = NC_ERANGE;
#line 2935
            
#line 2935
#ifdef ERANGE_FILL
#line 2935
            xp++; tp++; continue;
#line 2935
#endif
#line 2935
        }
#line 2935
        *xp++ = (schar)  *tp++; /* type cast from uchar to schar */
#line 2935
    }
#line 2935

#line 2935
    *xpp = (void *)xp;
#line 2935
    return status;
#line 2935
}
#line 2935

int
#line 2936
ncx_putn_schar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 2936
{
#line 2936
    int status = NC_NOERR;
#line 2936
    schar *xp = (schar *) *xpp;
#line 2936

#line 2936
    while (nelems-- != 0) {
#line 2936
        if (*tp > (short)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2936
            
#line 2936
#ifdef ERANGE_FILL
#line 2936
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2936
#endif
#line 2936
            status = NC_ERANGE;
#line 2936
            
#line 2936
#ifdef ERANGE_FILL
#line 2936
            xp++; tp++; continue;
#line 2936
#endif
#line 2936
        }
#line 2936
        *xp++ = (schar)  *tp++; /* type cast from short to schar */
#line 2936
    }
#line 2936

#line 2936
    *xpp = (void *)xp;
#line 2936
    return status;
#line 2936
}
#line 2936

int
#line 2937
ncx_putn_schar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 2937
{
#line 2937
    int status = NC_NOERR;
#line 2937
    schar *xp = (schar *) *xpp;
#line 2937

#line 2937
    while (nelems-- != 0) {
#line 2937
        if (*tp > (int)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2937
            
#line 2937
#ifdef ERANGE_FILL
#line 2937
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2937
#endif
#line 2937
            status = NC_ERANGE;
#line 2937
            
#line 2937
#ifdef ERANGE_FILL
#line 2937
            xp++; tp++; continue;
#line 2937
#endif
#line 2937
        }
#line 2937
        *xp++ = (schar)  *tp++; /* type cast from int to schar */
#line 2937
    }
#line 2937

#line 2937
    *xpp = (void *)xp;
#line 2937
    return status;
#line 2937
}
#line 2937

int
#line 2938
ncx_putn_schar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 2938
{
#line 2938
    int status = NC_NOERR;
#line 2938
    schar *xp = (schar *) *xpp;
#line 2938

#line 2938
    while (nelems-- != 0) {
#line 2938
        if (*tp > (long)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2938
            
#line 2938
#ifdef ERANGE_FILL
#line 2938
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2938
#endif
#line 2938
            status = NC_ERANGE;
#line 2938
            
#line 2938
#ifdef ERANGE_FILL
#line 2938
            xp++; tp++; continue;
#line 2938
#endif
#line 2938
        }
#line 2938
        *xp++ = (schar)  *tp++; /* type cast from long to schar */
#line 2938
    }
#line 2938

#line 2938
    *xpp = (void *)xp;
#line 2938
    return status;
#line 2938
}
#line 2938

int
#line 2939
ncx_putn_schar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 2939
{
#line 2939
    int status = NC_NOERR;
#line 2939
    schar *xp = (schar *) *xpp;
#line 2939

#line 2939
    while (nelems-- != 0) {
#line 2939
        if (*tp > (float)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2939
            
#line 2939
#ifdef ERANGE_FILL
#line 2939
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2939
#endif
#line 2939
            status = NC_ERANGE;
#line 2939
            
#line 2939
#ifdef ERANGE_FILL
#line 2939
            xp++; tp++; continue;
#line 2939
#endif
#line 2939
        }
#line 2939
        *xp++ = (schar)  *tp++; /* type cast from float to schar */
#line 2939
    }
#line 2939

#line 2939
    *xpp = (void *)xp;
#line 2939
    return status;
#line 2939
}
#line 2939

int
#line 2940
ncx_putn_schar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 2940
{
#line 2940
    int status = NC_NOERR;
#line 2940
    schar *xp = (schar *) *xpp;
#line 2940

#line 2940
    while (nelems-- != 0) {
#line 2940
        if (*tp > (double)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2940
            
#line 2940
#ifdef ERANGE_FILL
#line 2940
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2940
#endif
#line 2940
            status = NC_ERANGE;
#line 2940
            
#line 2940
#ifdef ERANGE_FILL
#line 2940
            xp++; tp++; continue;
#line 2940
#endif
#line 2940
        }
#line 2940
        *xp++ = (schar)  *tp++; /* type cast from double to schar */
#line 2940
    }
#line 2940

#line 2940
    *xpp = (void *)xp;
#line 2940
    return status;
#line 2940
}
#line 2940

int
#line 2941
ncx_putn_schar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 2941
{
#line 2941
    int status = NC_NOERR;
#line 2941
    schar *xp = (schar *) *xpp;
#line 2941

#line 2941
    while (nelems-- != 0) {
#line 2941
        if (*tp > (longlong)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2941
            
#line 2941
#ifdef ERANGE_FILL
#line 2941
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2941
#endif
#line 2941
            status = NC_ERANGE;
#line 2941
            
#line 2941
#ifdef ERANGE_FILL
#line 2941
            xp++; tp++; continue;
#line 2941
#endif
#line 2941
        }
#line 2941
        *xp++ = (schar)  *tp++; /* type cast from longlong to schar */
#line 2941
    }
#line 2941

#line 2941
    *xpp = (void *)xp;
#line 2941
    return status;
#line 2941
}
#line 2941

int
#line 2942
ncx_putn_schar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 2942
{
#line 2942
    int status = NC_NOERR;
#line 2942
    schar *xp = (schar *) *xpp;
#line 2942

#line 2942
    while (nelems-- != 0) {
#line 2942
        if (*tp > (ushort)X_SCHAR_MAX ) {
#line 2942
            
#line 2942
#ifdef ERANGE_FILL
#line 2942
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2942
#endif
#line 2942
            status = NC_ERANGE;
#line 2942
            
#line 2942
#ifdef ERANGE_FILL
#line 2942
            xp++; tp++; continue;
#line 2942
#endif
#line 2942
        }
#line 2942
        *xp++ = (schar)  *tp++; /* type cast from ushort to schar */
#line 2942
    }
#line 2942

#line 2942
    *xpp = (void *)xp;
#line 2942
    return status;
#line 2942
}
#line 2942

int
#line 2943
ncx_putn_schar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 2943
{
#line 2943
    int status = NC_NOERR;
#line 2943
    schar *xp = (schar *) *xpp;
#line 2943

#line 2943
    while (nelems-- != 0) {
#line 2943
        if (*tp > (uint)X_SCHAR_MAX ) {
#line 2943
            
#line 2943
#ifdef ERANGE_FILL
#line 2943
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2943
#endif
#line 2943
            status = NC_ERANGE;
#line 2943
            
#line 2943
#ifdef ERANGE_FILL
#line 2943
            xp++; tp++; continue;
#line 2943
#endif
#line 2943
        }
#line 2943
        *xp++ = (schar)  *tp++; /* type cast from uint to schar */
#line 2943
    }
#line 2943

#line 2943
    *xpp = (void *)xp;
#line 2943
    return status;
#line 2943
}
#line 2943

int
#line 2944
ncx_putn_schar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 2944
{
#line 2944
    int status = NC_NOERR;
#line 2944
    schar *xp = (schar *) *xpp;
#line 2944

#line 2944
    while (nelems-- != 0) {
#line 2944
        if (*tp > (ulonglong)X_SCHAR_MAX ) {
#line 2944
            
#line 2944
#ifdef ERANGE_FILL
#line 2944
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2944
#endif
#line 2944
            status = NC_ERANGE;
#line 2944
            
#line 2944
#ifdef ERANGE_FILL
#line 2944
            xp++; tp++; continue;
#line 2944
#endif
#line 2944
        }
#line 2944
        *xp++ = (schar)  *tp++; /* type cast from ulonglong to schar */
#line 2944
    }
#line 2944

#line 2944
    *xpp = (void *)xp;
#line 2944
    return status;
#line 2944
}
#line 2944


#line 2947
int
ncx_pad_putn_schar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2950

#line 2950
	if (rndup)
#line 2950
		rndup = X_ALIGN - rndup;
#line 2950

#line 2950
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 2950
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2950

#line 2950
	if (rndup)
#line 2950
	{
#line 2950
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 2950
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 2950
	}
#line 2950

#line 2950
	return NC_NOERR;
#line 2950

}
int
#line 2952
ncx_pad_putn_schar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 2952
{
#line 2952
    int status = NC_NOERR;
#line 2952
    size_t rndup = nelems % X_ALIGN;
#line 2952
    schar *xp = (schar *) *xpp;
#line 2952

#line 2952
    if (rndup) rndup = X_ALIGN - rndup;
#line 2952

#line 2952
    while (nelems-- != 0) {
#line 2952
        if (*tp > (uchar)X_SCHAR_MAX ) {
#line 2952
            
#line 2952
#ifdef ERANGE_FILL
#line 2952
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2952
#endif
#line 2952
            status = NC_ERANGE;
#line 2952
            
#line 2952
#ifdef ERANGE_FILL
#line 2952
            xp++; tp++; continue;
#line 2952
#endif
#line 2952
        }
#line 2952
        *xp++ = (schar)  *tp++; /* type cast from uchar to schar */
#line 2952
    }
#line 2952

#line 2952

#line 2952
    if (rndup) {
#line 2952
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2952
        xp += rndup;
#line 2952
    }
#line 2952

#line 2952
    *xpp = (void *)xp;
#line 2952
    return status;
#line 2952
}
#line 2952

int
#line 2953
ncx_pad_putn_schar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 2953
{
#line 2953
    int status = NC_NOERR;
#line 2953
    size_t rndup = nelems % X_ALIGN;
#line 2953
    schar *xp = (schar *) *xpp;
#line 2953

#line 2953
    if (rndup) rndup = X_ALIGN - rndup;
#line 2953

#line 2953
    while (nelems-- != 0) {
#line 2953
        if (*tp > (short)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2953
            
#line 2953
#ifdef ERANGE_FILL
#line 2953
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2953
#endif
#line 2953
            status = NC_ERANGE;
#line 2953
            
#line 2953
#ifdef ERANGE_FILL
#line 2953
            xp++; tp++; continue;
#line 2953
#endif
#line 2953
        }
#line 2953
        *xp++ = (schar)  *tp++; /* type cast from short to schar */
#line 2953
    }
#line 2953

#line 2953

#line 2953
    if (rndup) {
#line 2953
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2953
        xp += rndup;
#line 2953
    }
#line 2953

#line 2953
    *xpp = (void *)xp;
#line 2953
    return status;
#line 2953
}
#line 2953

int
#line 2954
ncx_pad_putn_schar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 2954
{
#line 2954
    int status = NC_NOERR;
#line 2954
    size_t rndup = nelems % X_ALIGN;
#line 2954
    schar *xp = (schar *) *xpp;
#line 2954

#line 2954
    if (rndup) rndup = X_ALIGN - rndup;
#line 2954

#line 2954
    while (nelems-- != 0) {
#line 2954
        if (*tp > (int)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2954
            
#line 2954
#ifdef ERANGE_FILL
#line 2954
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2954
#endif
#line 2954
            status = NC_ERANGE;
#line 2954
            
#line 2954
#ifdef ERANGE_FILL
#line 2954
            xp++; tp++; continue;
#line 2954
#endif
#line 2954
        }
#line 2954
        *xp++ = (schar)  *tp++; /* type cast from int to schar */
#line 2954
    }
#line 2954

#line 2954

#line 2954
    if (rndup) {
#line 2954
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2954
        xp += rndup;
#line 2954
    }
#line 2954

#line 2954
    *xpp = (void *)xp;
#line 2954
    return status;
#line 2954
}
#line 2954

int
#line 2955
ncx_pad_putn_schar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 2955
{
#line 2955
    int status = NC_NOERR;
#line 2955
    size_t rndup = nelems % X_ALIGN;
#line 2955
    schar *xp = (schar *) *xpp;
#line 2955

#line 2955
    if (rndup) rndup = X_ALIGN - rndup;
#line 2955

#line 2955
    while (nelems-- != 0) {
#line 2955
        if (*tp > (long)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2955
            
#line 2955
#ifdef ERANGE_FILL
#line 2955
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2955
#endif
#line 2955
            status = NC_ERANGE;
#line 2955
            
#line 2955
#ifdef ERANGE_FILL
#line 2955
            xp++; tp++; continue;
#line 2955
#endif
#line 2955
        }
#line 2955
        *xp++ = (schar)  *tp++; /* type cast from long to schar */
#line 2955
    }
#line 2955

#line 2955

#line 2955
    if (rndup) {
#line 2955
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2955
        xp += rndup;
#line 2955
    }
#line 2955

#line 2955
    *xpp = (void *)xp;
#line 2955
    return status;
#line 2955
}
#line 2955

int
#line 2956
ncx_pad_putn_schar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 2956
{
#line 2956
    int status = NC_NOERR;
#line 2956
    size_t rndup = nelems % X_ALIGN;
#line 2956
    schar *xp = (schar *) *xpp;
#line 2956

#line 2956
    if (rndup) rndup = X_ALIGN - rndup;
#line 2956

#line 2956
    while (nelems-- != 0) {
#line 2956
        if (*tp > (float)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2956
            
#line 2956
#ifdef ERANGE_FILL
#line 2956
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2956
#endif
#line 2956
            status = NC_ERANGE;
#line 2956
            
#line 2956
#ifdef ERANGE_FILL
#line 2956
            xp++; tp++; continue;
#line 2956
#endif
#line 2956
        }
#line 2956
        *xp++ = (schar)  *tp++; /* type cast from float to schar */
#line 2956
    }
#line 2956

#line 2956

#line 2956
    if (rndup) {
#line 2956
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2956
        xp += rndup;
#line 2956
    }
#line 2956

#line 2956
    *xpp = (void *)xp;
#line 2956
    return status;
#line 2956
}
#line 2956

int
#line 2957
ncx_pad_putn_schar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 2957
{
#line 2957
    int status = NC_NOERR;
#line 2957
    size_t rndup = nelems % X_ALIGN;
#line 2957
    schar *xp = (schar *) *xpp;
#line 2957

#line 2957
    if (rndup) rndup = X_ALIGN - rndup;
#line 2957

#line 2957
    while (nelems-- != 0) {
#line 2957
        if (*tp > (double)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2957
            
#line 2957
#ifdef ERANGE_FILL
#line 2957
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2957
#endif
#line 2957
            status = NC_ERANGE;
#line 2957
            
#line 2957
#ifdef ERANGE_FILL
#line 2957
            xp++; tp++; continue;
#line 2957
#endif
#line 2957
        }
#line 2957
        *xp++ = (schar)  *tp++; /* type cast from double to schar */
#line 2957
    }
#line 2957

#line 2957

#line 2957
    if (rndup) {
#line 2957
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2957
        xp += rndup;
#line 2957
    }
#line 2957

#line 2957
    *xpp = (void *)xp;
#line 2957
    return status;
#line 2957
}
#line 2957

int
#line 2958
ncx_pad_putn_schar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 2958
{
#line 2958
    int status = NC_NOERR;
#line 2958
    size_t rndup = nelems % X_ALIGN;
#line 2958
    schar *xp = (schar *) *xpp;
#line 2958

#line 2958
    if (rndup) rndup = X_ALIGN - rndup;
#line 2958

#line 2958
    while (nelems-- != 0) {
#line 2958
        if (*tp > (longlong)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2958
            
#line 2958
#ifdef ERANGE_FILL
#line 2958
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2958
#endif
#line 2958
            status = NC_ERANGE;
#line 2958
            
#line 2958
#ifdef ERANGE_FILL
#line 2958
            xp++; tp++; continue;
#line 2958
#endif
#line 2958
        }
#line 2958
        *xp++ = (schar)  *tp++; /* type cast from longlong to schar */
#line 2958
    }
#line 2958

#line 2958

#line 2958
    if (rndup) {
#line 2958
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2958
        xp += rndup;
#line 2958
    }
#line 2958

#line 2958
    *xpp = (void *)xp;
#line 2958
    return status;
#line 2958
}
#line 2958

int
#line 2959
ncx_pad_putn_schar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 2959
{
#line 2959
    int status = NC_NOERR;
#line 2959
    size_t rndup = nelems % X_ALIGN;
#line 2959
    schar *xp = (schar *) *xpp;
#line 2959

#line 2959
    if (rndup) rndup = X_ALIGN - rndup;
#line 2959

#line 2959
    while (nelems-- != 0) {
#line 2959
        if (*tp > (ushort)X_SCHAR_MAX ) {
#line 2959
            
#line 2959
#ifdef ERANGE_FILL
#line 2959
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2959
#endif
#line 2959
            status = NC_ERANGE;
#line 2959
            
#line 2959
#ifdef ERANGE_FILL
#line 2959
            xp++; tp++; continue;
#line 2959
#endif
#line 2959
        }
#line 2959
        *xp++ = (schar)  *tp++; /* type cast from ushort to schar */
#line 2959
    }
#line 2959

#line 2959

#line 2959
    if (rndup) {
#line 2959
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2959
        xp += rndup;
#line 2959
    }
#line 2959

#line 2959
    *xpp = (void *)xp;
#line 2959
    return status;
#line 2959
}
#line 2959

int
#line 2960
ncx_pad_putn_schar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 2960
{
#line 2960
    int status = NC_NOERR;
#line 2960
    size_t rndup = nelems % X_ALIGN;
#line 2960
    schar *xp = (schar *) *xpp;
#line 2960

#line 2960
    if (rndup) rndup = X_ALIGN - rndup;
#line 2960

#line 2960
    while (nelems-- != 0) {
#line 2960
        if (*tp > (uint)X_SCHAR_MAX ) {
#line 2960
            
#line 2960
#ifdef ERANGE_FILL
#line 2960
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2960
#endif
#line 2960
            status = NC_ERANGE;
#line 2960
            
#line 2960
#ifdef ERANGE_FILL
#line 2960
            xp++; tp++; continue;
#line 2960
#endif
#line 2960
        }
#line 2960
        *xp++ = (schar)  *tp++; /* type cast from uint to schar */
#line 2960
    }
#line 2960

#line 2960

#line 2960
    if (rndup) {
#line 2960
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2960
        xp += rndup;
#line 2960
    }
#line 2960

#line 2960
    *xpp = (void *)xp;
#line 2960
    return status;
#line 2960
}
#line 2960

int
#line 2961
ncx_pad_putn_schar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 2961
{
#line 2961
    int status = NC_NOERR;
#line 2961
    size_t rndup = nelems % X_ALIGN;
#line 2961
    schar *xp = (schar *) *xpp;
#line 2961

#line 2961
    if (rndup) rndup = X_ALIGN - rndup;
#line 2961

#line 2961
    while (nelems-- != 0) {
#line 2961
        if (*tp > (ulonglong)X_SCHAR_MAX ) {
#line 2961
            
#line 2961
#ifdef ERANGE_FILL
#line 2961
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2961
#endif
#line 2961
            status = NC_ERANGE;
#line 2961
            
#line 2961
#ifdef ERANGE_FILL
#line 2961
            xp++; tp++; continue;
#line 2961
#endif
#line 2961
        }
#line 2961
        *xp++ = (schar)  *tp++; /* type cast from ulonglong to schar */
#line 2961
    }
#line 2961

#line 2961

#line 2961
    if (rndup) {
#line 2961
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2961
        xp += rndup;
#line 2961
    }
#line 2961

#line 2961
    *xpp = (void *)xp;
#line 2961
    return status;
#line 2961
}
#line 2961



/* uchar ---------------------------------------------------------------------*/
#line 2967
int
ncx_getn_uchar_schar(const void **xpp, size_t nelems, schar *tp)
{
    int status = NC_NOERR;
    uchar *xp = (uchar *)(*xpp);

    while (nelems-- != 0) {
        if (*xp > SCHAR_MAX) {
            *tp = NC_FILL_BYTE;
       	    status = NC_ERANGE;
            
#line 2977
#ifdef ERANGE_FILL
#line 2977
            xp++; tp++; continue;
#line 2977
#endif
        }
	*tp++ = (schar) *xp++; /* type cast from uchar to schar */
    }

    *xpp = (const void *)xp;
    return status;
}
#line 2986
int
ncx_getn_uchar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		(void) memcpy(tp, *xpp, (size_t)nelems);
#line 2989
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2989
	return NC_NOERR;
#line 2989

}
int
#line 2991
ncx_getn_uchar_short(const void **xpp, size_t nelems, short *tp)
#line 2991
{
#line 2991
    int status = NC_NOERR;
#line 2991
    uchar *xp = (uchar *)(*xpp);
#line 2991

#line 2991
    while (nelems-- != 0) {
#line 2991
        
#line 2991
        *tp++ = (short)  (*xp++);  /* type cast from uchar to short */
#line 2991
    }
#line 2991

#line 2991
    *xpp = (const void *)xp;
#line 2991
    return status;
#line 2991
}
#line 2991

int
#line 2992
ncx_getn_uchar_int(const void **xpp, size_t nelems, int *tp)
#line 2992
{
#line 2992
    int status = NC_NOERR;
#line 2992
    uchar *xp = (uchar *)(*xpp);
#line 2992

#line 2992
    while (nelems-- != 0) {
#line 2992
        
#line 2992
        *tp++ = (int)  (*xp++);  /* type cast from uchar to int */
#line 2992
    }
#line 2992

#line 2992
    *xpp = (const void *)xp;
#line 2992
    return status;
#line 2992
}
#line 2992

int
#line 2993
ncx_getn_uchar_long(const void **xpp, size_t nelems, long *tp)
#line 2993
{
#line 2993
    int status = NC_NOERR;
#line 2993
    uchar *xp = (uchar *)(*xpp);
#line 2993

#line 2993
    while (nelems-- != 0) {
#line 2993
        
#line 2993
        *tp++ = (long)  (*xp++);  /* type cast from uchar to long */
#line 2993
    }
#line 2993

#line 2993
    *xpp = (const void *)xp;
#line 2993
    return status;
#line 2993
}
#line 2993

int
#line 2994
ncx_getn_uchar_float(const void **xpp, size_t nelems, float *tp)
#line 2994
{
#line 2994
    int status = NC_NOERR;
#line 2994
    uchar *xp = (uchar *)(*xpp);
#line 2994

#line 2994
    while (nelems-- != 0) {
#line 2994
        
#line 2994
        *tp++ = (float)  (*xp++);  /* type cast from uchar to float */
#line 2994
    }
#line 2994

#line 2994
    *xpp = (const void *)xp;
#line 2994
    return status;
#line 2994
}
#line 2994

int
#line 2995
ncx_getn_uchar_double(const void **xpp, size_t nelems, double *tp)
#line 2995
{
#line 2995
    int status = NC_NOERR;
#line 2995
    uchar *xp = (uchar *)(*xpp);
#line 2995

#line 2995
    while (nelems-- != 0) {
#line 2995
        
#line 2995
        *tp++ = (double)  (*xp++);  /* type cast from uchar to double */
#line 2995
    }
#line 2995

#line 2995
    *xpp = (const void *)xp;
#line 2995
    return status;
#line 2995
}
#line 2995

int
#line 2996
ncx_getn_uchar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2996
{
#line 2996
    int status = NC_NOERR;
#line 2996
    uchar *xp = (uchar *)(*xpp);
#line 2996

#line 2996
    while (nelems-- != 0) {
#line 2996
        
#line 2996
        *tp++ = (longlong)  (*xp++);  /* type cast from uchar to longlong */
#line 2996
    }
#line 2996

#line 2996
    *xpp = (const void *)xp;
#line 2996
    return status;
#line 2996
}
#line 2996

int
#line 2997
ncx_getn_uchar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2997
{
#line 2997
    int status = NC_NOERR;
#line 2997
    uchar *xp = (uchar *)(*xpp);
#line 2997

#line 2997
    while (nelems-- != 0) {
#line 2997
        
#line 2997
        *tp++ = (ushort)  (*xp++);  /* type cast from uchar to ushort */
#line 2997
    }
#line 2997

#line 2997
    *xpp = (const void *)xp;
#line 2997
    return status;
#line 2997
}
#line 2997

int
#line 2998
ncx_getn_uchar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2998
{
#line 2998
    int status = NC_NOERR;
#line 2998
    uchar *xp = (uchar *)(*xpp);
#line 2998

#line 2998
    while (nelems-- != 0) {
#line 2998
        
#line 2998
        *tp++ = (uint)  (*xp++);  /* type cast from uchar to uint */
#line 2998
    }
#line 2998

#line 2998
    *xpp = (const void *)xp;
#line 2998
    return status;
#line 2998
}
#line 2998

int
#line 2999
ncx_getn_uchar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2999
{
#line 2999
    int status = NC_NOERR;
#line 2999
    uchar *xp = (uchar *)(*xpp);
#line 2999

#line 2999
    while (nelems-- != 0) {
#line 2999
        
#line 2999
        *tp++ = (ulonglong)  (*xp++);  /* type cast from uchar to ulonglong */
#line 2999
    }
#line 2999

#line 2999
    *xpp = (const void *)xp;
#line 2999
    return status;
#line 2999
}
#line 2999


#line 3002
int
ncx_pad_getn_uchar_schar(const void **xpp, size_t nelems, schar *tp)
{
    int status = NC_NOERR;
    size_t rndup = nelems % X_ALIGN;
    uchar *xp = (uchar *) *xpp;

    if (rndup) rndup = X_ALIGN - rndup;

    while (nelems-- != 0) {
        if (*xp > SCHAR_MAX) {
            *tp = NC_FILL_BYTE;
            status = NC_ERANGE;
            
#line 3015
#ifdef ERANGE_FILL
#line 3015
            xp++; tp++; continue;
#line 3015
#endif
        }
        *tp++ = (schar) *xp++; /* type cast from uchar to schar */
    }

    *xpp = (void *)(xp + rndup);
    return status;
}
#line 3024
int
ncx_pad_getn_uchar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 3027

#line 3027
	if (rndup)
#line 3027
		rndup = X_ALIGN - rndup;
#line 3027

#line 3027
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3027
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 3027

#line 3027
	return NC_NOERR;
#line 3027

}
int
#line 3029
ncx_pad_getn_uchar_short(const void **xpp, size_t nelems, short *tp)
#line 3029
{
#line 3029
    int status = NC_NOERR;
#line 3029
    size_t rndup = nelems % X_ALIGN;
#line 3029
    uchar *xp = (uchar *) *xpp;
#line 3029

#line 3029
    if (rndup)
#line 3029
        rndup = X_ALIGN - rndup;
#line 3029

#line 3029
    while (nelems-- != 0) {
#line 3029
        
#line 3029
        *tp++ = (short)  (*xp++);  /* type cast from uchar to short */
#line 3029
    }
#line 3029

#line 3029
    *xpp = (void *)(xp + rndup);
#line 3029
    return status;
#line 3029
}
#line 3029

int
#line 3030
ncx_pad_getn_uchar_int(const void **xpp, size_t nelems, int *tp)
#line 3030
{
#line 3030
    int status = NC_NOERR;
#line 3030
    size_t rndup = nelems % X_ALIGN;
#line 3030
    uchar *xp = (uchar *) *xpp;
#line 3030

#line 3030
    if (rndup)
#line 3030
        rndup = X_ALIGN - rndup;
#line 3030

#line 3030
    while (nelems-- != 0) {
#line 3030
        
#line 3030
        *tp++ = (int)  (*xp++);  /* type cast from uchar to int */
#line 3030
    }
#line 3030

#line 3030
    *xpp = (void *)(xp + rndup);
#line 3030
    return status;
#line 3030
}
#line 3030

int
#line 3031
ncx_pad_getn_uchar_long(const void **xpp, size_t nelems, long *tp)
#line 3031
{
#line 3031
    int status = NC_NOERR;
#line 3031
    size_t rndup = nelems % X_ALIGN;
#line 3031
    uchar *xp = (uchar *) *xpp;
#line 3031

#line 3031
    if (rndup)
#line 3031
        rndup = X_ALIGN - rndup;
#line 3031

#line 3031
    while (nelems-- != 0) {
#line 3031
        
#line 3031
        *tp++ = (long)  (*xp++);  /* type cast from uchar to long */
#line 3031
    }
#line 3031

#line 3031
    *xpp = (void *)(xp + rndup);
#line 3031
    return status;
#line 3031
}
#line 3031

int
#line 3032
ncx_pad_getn_uchar_float(const void **xpp, size_t nelems, float *tp)
#line 3032
{
#line 3032
    int status = NC_NOERR;
#line 3032
    size_t rndup = nelems % X_ALIGN;
#line 3032
    uchar *xp = (uchar *) *xpp;
#line 3032

#line 3032
    if (rndup)
#line 3032
        rndup = X_ALIGN - rndup;
#line 3032

#line 3032
    while (nelems-- != 0) {
#line 3032
        
#line 3032
        *tp++ = (float)  (*xp++);  /* type cast from uchar to float */
#line 3032
    }
#line 3032

#line 3032
    *xpp = (void *)(xp + rndup);
#line 3032
    return status;
#line 3032
}
#line 3032

int
#line 3033
ncx_pad_getn_uchar_double(const void **xpp, size_t nelems, double *tp)
#line 3033
{
#line 3033
    int status = NC_NOERR;
#line 3033
    size_t rndup = nelems % X_ALIGN;
#line 3033
    uchar *xp = (uchar *) *xpp;
#line 3033

#line 3033
    if (rndup)
#line 3033
        rndup = X_ALIGN - rndup;
#line 3033

#line 3033
    while (nelems-- != 0) {
#line 3033
        
#line 3033
        *tp++ = (double)  (*xp++);  /* type cast from uchar to double */
#line 3033
    }
#line 3033

#line 3033
    *xpp = (void *)(xp + rndup);
#line 3033
    return status;
#line 3033
}
#line 3033

int
#line 3034
ncx_pad_getn_uchar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3034
{
#line 3034
    int status = NC_NOERR;
#line 3034
    size_t rndup = nelems % X_ALIGN;
#line 3034
    uchar *xp = (uchar *) *xpp;
#line 3034

#line 3034
    if (rndup)
#line 3034
        rndup = X_ALIGN - rndup;
#line 3034

#line 3034
    while (nelems-- != 0) {
#line 3034
        
#line 3034
        *tp++ = (longlong)  (*xp++);  /* type cast from uchar to longlong */
#line 3034
    }
#line 3034

#line 3034
    *xpp = (void *)(xp + rndup);
#line 3034
    return status;
#line 3034
}
#line 3034

int
#line 3035
ncx_pad_getn_uchar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3035
{
#line 3035
    int status = NC_NOERR;
#line 3035
    size_t rndup = nelems % X_ALIGN;
#line 3035
    uchar *xp = (uchar *) *xpp;
#line 3035

#line 3035
    if (rndup)
#line 3035
        rndup = X_ALIGN - rndup;
#line 3035

#line 3035
    while (nelems-- != 0) {
#line 3035
        
#line 3035
        *tp++ = (ushort)  (*xp++);  /* type cast from uchar to ushort */
#line 3035
    }
#line 3035

#line 3035
    *xpp = (void *)(xp + rndup);
#line 3035
    return status;
#line 3035
}
#line 3035

int
#line 3036
ncx_pad_getn_uchar_uint(const void **xpp, size_t nelems, uint *tp)
#line 3036
{
#line 3036
    int status = NC_NOERR;
#line 3036
    size_t rndup = nelems % X_ALIGN;
#line 3036
    uchar *xp = (uchar *) *xpp;
#line 3036

#line 3036
    if (rndup)
#line 3036
        rndup = X_ALIGN - rndup;
#line 3036

#line 3036
    while (nelems-- != 0) {
#line 3036
        
#line 3036
        *tp++ = (uint)  (*xp++);  /* type cast from uchar to uint */
#line 3036
    }
#line 3036

#line 3036
    *xpp = (void *)(xp + rndup);
#line 3036
    return status;
#line 3036
}
#line 3036

int
#line 3037
ncx_pad_getn_uchar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3037
{
#line 3037
    int status = NC_NOERR;
#line 3037
    size_t rndup = nelems % X_ALIGN;
#line 3037
    uchar *xp = (uchar *) *xpp;
#line 3037

#line 3037
    if (rndup)
#line 3037
        rndup = X_ALIGN - rndup;
#line 3037

#line 3037
    while (nelems-- != 0) {
#line 3037
        
#line 3037
        *tp++ = (ulonglong)  (*xp++);  /* type cast from uchar to ulonglong */
#line 3037
    }
#line 3037

#line 3037
    *xpp = (void *)(xp + rndup);
#line 3037
    return status;
#line 3037
}
#line 3037


#line 3040
int
ncx_putn_uchar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
    int status = NC_NOERR;
    uchar *xp = (uchar *) *xpp;

    while (nelems-- != 0) {
        if (*tp < 0) {
            
#line 3048
#ifdef ERANGE_FILL
#line 3048
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3048
#endif
            status = NC_ERANGE;
            
#line 3050
#ifdef ERANGE_FILL
#line 3050
            xp++; tp++; continue;
#line 3050
#endif
        }
        *xp++ = (uchar) (signed) *tp++; /* type cast from schar to uchar */
    }

    *xpp = (void *)xp;
    return status;
}
#line 3059
int
ncx_putn_uchar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
{
		(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3062
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3062

#line 3062
	return NC_NOERR;
#line 3062

}
int
#line 3064
ncx_putn_uchar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3064
{
#line 3064
    int status = NC_NOERR;
#line 3064
    uchar *xp = (uchar *) *xpp;
#line 3064

#line 3064
    while (nelems-- != 0) {
#line 3064
        if (*tp > (short)X_UCHAR_MAX || *tp < 0) {
#line 3064
            
#line 3064
#ifdef ERANGE_FILL
#line 3064
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3064
#endif
#line 3064
            status = NC_ERANGE;
#line 3064
            
#line 3064
#ifdef ERANGE_FILL
#line 3064
            xp++; tp++; continue;
#line 3064
#endif
#line 3064
        }
#line 3064
        *xp++ = (uchar) (signed) *tp++; /* type cast from short to uchar */
#line 3064
    }
#line 3064

#line 3064
    *xpp = (void *)xp;
#line 3064
    return status;
#line 3064
}
#line 3064

int
#line 3065
ncx_putn_uchar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3065
{
#line 3065
    int status = NC_NOERR;
#line 3065
    uchar *xp = (uchar *) *xpp;
#line 3065

#line 3065
    while (nelems-- != 0) {
#line 3065
        if (*tp > (int)X_UCHAR_MAX || *tp < 0) {
#line 3065
            
#line 3065
#ifdef ERANGE_FILL
#line 3065
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3065
#endif
#line 3065
            status = NC_ERANGE;
#line 3065
            
#line 3065
#ifdef ERANGE_FILL
#line 3065
            xp++; tp++; continue;
#line 3065
#endif
#line 3065
        }
#line 3065
        *xp++ = (uchar) (signed) *tp++; /* type cast from int to uchar */
#line 3065
    }
#line 3065

#line 3065
    *xpp = (void *)xp;
#line 3065
    return status;
#line 3065
}
#line 3065

int
#line 3066
ncx_putn_uchar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3066
{
#line 3066
    int status = NC_NOERR;
#line 3066
    uchar *xp = (uchar *) *xpp;
#line 3066

#line 3066
    while (nelems-- != 0) {
#line 3066
        if (*tp > (long)X_UCHAR_MAX || *tp < 0) {
#line 3066
            
#line 3066
#ifdef ERANGE_FILL
#line 3066
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3066
#endif
#line 3066
            status = NC_ERANGE;
#line 3066
            
#line 3066
#ifdef ERANGE_FILL
#line 3066
            xp++; tp++; continue;
#line 3066
#endif
#line 3066
        }
#line 3066
        *xp++ = (uchar) (signed) *tp++; /* type cast from long to uchar */
#line 3066
    }
#line 3066

#line 3066
    *xpp = (void *)xp;
#line 3066
    return status;
#line 3066
}
#line 3066

int
#line 3067
ncx_putn_uchar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3067
{
#line 3067
    int status = NC_NOERR;
#line 3067
    uchar *xp = (uchar *) *xpp;
#line 3067

#line 3067
    while (nelems-- != 0) {
#line 3067
        if (*tp > (float)X_UCHAR_MAX || *tp < 0) {
#line 3067
            
#line 3067
#ifdef ERANGE_FILL
#line 3067
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3067
#endif
#line 3067
            status = NC_ERANGE;
#line 3067
            
#line 3067
#ifdef ERANGE_FILL
#line 3067
            xp++; tp++; continue;
#line 3067
#endif
#line 3067
        }
#line 3067
        *xp++ = (uchar) (signed) *tp++; /* type cast from float to uchar */
#line 3067
    }
#line 3067

#line 3067
    *xpp = (void *)xp;
#line 3067
    return status;
#line 3067
}
#line 3067

int
#line 3068
ncx_putn_uchar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3068
{
#line 3068
    int status = NC_NOERR;
#line 3068
    uchar *xp = (uchar *) *xpp;
#line 3068

#line 3068
    while (nelems-- != 0) {
#line 3068
        if (*tp > (double)X_UCHAR_MAX || *tp < 0) {
#line 3068
            
#line 3068
#ifdef ERANGE_FILL
#line 3068
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3068
#endif
#line 3068
            status = NC_ERANGE;
#line 3068
            
#line 3068
#ifdef ERANGE_FILL
#line 3068
            xp++; tp++; continue;
#line 3068
#endif
#line 3068
        }
#line 3068
        *xp++ = (uchar) (signed) *tp++; /* type cast from double to uchar */
#line 3068
    }
#line 3068

#line 3068
    *xpp = (void *)xp;
#line 3068
    return status;
#line 3068
}
#line 3068

int
#line 3069
ncx_putn_uchar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3069
{
#line 3069
    int status = NC_NOERR;
#line 3069
    uchar *xp = (uchar *) *xpp;
#line 3069

#line 3069
    while (nelems-- != 0) {
#line 3069
        if (*tp > (longlong)X_UCHAR_MAX || *tp < 0) {
#line 3069
            
#line 3069
#ifdef ERANGE_FILL
#line 3069
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3069
#endif
#line 3069
            status = NC_ERANGE;
#line 3069
            
#line 3069
#ifdef ERANGE_FILL
#line 3069
            xp++; tp++; continue;
#line 3069
#endif
#line 3069
        }
#line 3069
        *xp++ = (uchar) (signed) *tp++; /* type cast from longlong to uchar */
#line 3069
    }
#line 3069

#line 3069
    *xpp = (void *)xp;
#line 3069
    return status;
#line 3069
}
#line 3069

int
#line 3070
ncx_putn_uchar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3070
{
#line 3070
    int status = NC_NOERR;
#line 3070
    uchar *xp = (uchar *) *xpp;
#line 3070

#line 3070
    while (nelems-- != 0) {
#line 3070
        if (*tp > (ushort)X_UCHAR_MAX ) {
#line 3070
            
#line 3070
#ifdef ERANGE_FILL
#line 3070
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3070
#endif
#line 3070
            status = NC_ERANGE;
#line 3070
            
#line 3070
#ifdef ERANGE_FILL
#line 3070
            xp++; tp++; continue;
#line 3070
#endif
#line 3070
        }
#line 3070
        *xp++ = (uchar)  *tp++; /* type cast from ushort to uchar */
#line 3070
    }
#line 3070

#line 3070
    *xpp = (void *)xp;
#line 3070
    return status;
#line 3070
}
#line 3070

int
#line 3071
ncx_putn_uchar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3071
{
#line 3071
    int status = NC_NOERR;
#line 3071
    uchar *xp = (uchar *) *xpp;
#line 3071

#line 3071
    while (nelems-- != 0) {
#line 3071
        if (*tp > (uint)X_UCHAR_MAX ) {
#line 3071
            
#line 3071
#ifdef ERANGE_FILL
#line 3071
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3071
#endif
#line 3071
            status = NC_ERANGE;
#line 3071
            
#line 3071
#ifdef ERANGE_FILL
#line 3071
            xp++; tp++; continue;
#line 3071
#endif
#line 3071
        }
#line 3071
        *xp++ = (uchar)  *tp++; /* type cast from uint to uchar */
#line 3071
    }
#line 3071

#line 3071
    *xpp = (void *)xp;
#line 3071
    return status;
#line 3071
}
#line 3071

int
#line 3072
ncx_putn_uchar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3072
{
#line 3072
    int status = NC_NOERR;
#line 3072
    uchar *xp = (uchar *) *xpp;
#line 3072

#line 3072
    while (nelems-- != 0) {
#line 3072
        if (*tp > (ulonglong)X_UCHAR_MAX ) {
#line 3072
            
#line 3072
#ifdef ERANGE_FILL
#line 3072
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3072
#endif
#line 3072
            status = NC_ERANGE;
#line 3072
            
#line 3072
#ifdef ERANGE_FILL
#line 3072
            xp++; tp++; continue;
#line 3072
#endif
#line 3072
        }
#line 3072
        *xp++ = (uchar)  *tp++; /* type cast from ulonglong to uchar */
#line 3072
    }
#line 3072

#line 3072
    *xpp = (void *)xp;
#line 3072
    return status;
#line 3072
}
#line 3072


#line 3075
int
ncx_pad_putn_uchar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
    int status = NC_NOERR;
    size_t rndup = nelems % X_ALIGN;
    uchar *xp = (uchar *) *xpp;

    if (rndup) rndup = X_ALIGN - rndup;

    while (nelems-- != 0) {
        if (*tp < 0) {
            
#line 3086
#ifdef ERANGE_FILL
#line 3086
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3086
#endif
            status = NC_ERANGE;
            
#line 3088
#ifdef ERANGE_FILL
#line 3088
            xp++; tp++; continue;
#line 3088
#endif
        }
        *xp++ = (uchar) (signed) *tp++; /* type cast from schar to uchar */
    }

    if (rndup) {
        (void) memcpy(xp, nada, (size_t)rndup);
        xp += rndup;
    }

    *xpp = (void *)xp;
    return status;
}
#line 3102
int
ncx_pad_putn_uchar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
{
		size_t rndup = nelems % X_ALIGN;
#line 3105

#line 3105
	if (rndup)
#line 3105
		rndup = X_ALIGN - rndup;
#line 3105

#line 3105
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3105
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3105

#line 3105
	if (rndup)
#line 3105
	{
#line 3105
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 3105
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 3105
	}
#line 3105

#line 3105
	return NC_NOERR;
#line 3105

}
int
#line 3107
ncx_pad_putn_uchar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3107
{
#line 3107
    int status = NC_NOERR;
#line 3107
    size_t rndup = nelems % X_ALIGN;
#line 3107
    uchar *xp = (uchar *) *xpp;
#line 3107

#line 3107
    if (rndup) rndup = X_ALIGN - rndup;
#line 3107

#line 3107
    while (nelems-- != 0) {
#line 3107
        if (*tp > (short)X_UCHAR_MAX || *tp < 0) {
#line 3107
            
#line 3107
#ifdef ERANGE_FILL
#line 3107
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3107
#endif
#line 3107
            status = NC_ERANGE;
#line 3107
            
#line 3107
#ifdef ERANGE_FILL
#line 3107
            xp++; tp++; continue;
#line 3107
#endif
#line 3107
        }
#line 3107
        *xp++ = (uchar) (signed) *tp++; /* type cast from short to uchar */
#line 3107
    }
#line 3107

#line 3107

#line 3107
    if (rndup) {
#line 3107
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3107
        xp += rndup;
#line 3107
    }
#line 3107

#line 3107
    *xpp = (void *)xp;
#line 3107
    return status;
#line 3107
}
#line 3107

int
#line 3108
ncx_pad_putn_uchar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3108
{
#line 3108
    int status = NC_NOERR;
#line 3108
    size_t rndup = nelems % X_ALIGN;
#line 3108
    uchar *xp = (uchar *) *xpp;
#line 3108

#line 3108
    if (rndup) rndup = X_ALIGN - rndup;
#line 3108

#line 3108
    while (nelems-- != 0) {
#line 3108
        if (*tp > (int)X_UCHAR_MAX || *tp < 0) {
#line 3108
            
#line 3108
#ifdef ERANGE_FILL
#line 3108
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3108
#endif
#line 3108
            status = NC_ERANGE;
#line 3108
            
#line 3108
#ifdef ERANGE_FILL
#line 3108
            xp++; tp++; continue;
#line 3108
#endif
#line 3108
        }
#line 3108
        *xp++ = (uchar) (signed) *tp++; /* type cast from int to uchar */
#line 3108
    }
#line 3108

#line 3108

#line 3108
    if (rndup) {
#line 3108
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3108
        xp += rndup;
#line 3108
    }
#line 3108

#line 3108
    *xpp = (void *)xp;
#line 3108
    return status;
#line 3108
}
#line 3108

int
#line 3109
ncx_pad_putn_uchar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3109
{
#line 3109
    int status = NC_NOERR;
#line 3109
    size_t rndup = nelems % X_ALIGN;
#line 3109
    uchar *xp = (uchar *) *xpp;
#line 3109

#line 3109
    if (rndup) rndup = X_ALIGN - rndup;
#line 3109

#line 3109
    while (nelems-- != 0) {
#line 3109
        if (*tp > (long)X_UCHAR_MAX || *tp < 0) {
#line 3109
            
#line 3109
#ifdef ERANGE_FILL
#line 3109
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3109
#endif
#line 3109
            status = NC_ERANGE;
#line 3109
            
#line 3109
#ifdef ERANGE_FILL
#line 3109
            xp++; tp++; continue;
#line 3109
#endif
#line 3109
        }
#line 3109
        *xp++ = (uchar) (signed) *tp++; /* type cast from long to uchar */
#line 3109
    }
#line 3109

#line 3109

#line 3109
    if (rndup) {
#line 3109
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3109
        xp += rndup;
#line 3109
    }
#line 3109

#line 3109
    *xpp = (void *)xp;
#line 3109
    return status;
#line 3109
}
#line 3109

int
#line 3110
ncx_pad_putn_uchar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3110
{
#line 3110
    int status = NC_NOERR;
#line 3110
    size_t rndup = nelems % X_ALIGN;
#line 3110
    uchar *xp = (uchar *) *xpp;
#line 3110

#line 3110
    if (rndup) rndup = X_ALIGN - rndup;
#line 3110

#line 3110
    while (nelems-- != 0) {
#line 3110
        if (*tp > (float)X_UCHAR_MAX || *tp < 0) {
#line 3110
            
#line 3110
#ifdef ERANGE_FILL
#line 3110
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3110
#endif
#line 3110
            status = NC_ERANGE;
#line 3110
            
#line 3110
#ifdef ERANGE_FILL
#line 3110
            xp++; tp++; continue;
#line 3110
#endif
#line 3110
        }
#line 3110
        *xp++ = (uchar) (signed) *tp++; /* type cast from float to uchar */
#line 3110
    }
#line 3110

#line 3110

#line 3110
    if (rndup) {
#line 3110
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3110
        xp += rndup;
#line 3110
    }
#line 3110

#line 3110
    *xpp = (void *)xp;
#line 3110
    return status;
#line 3110
}
#line 3110

int
#line 3111
ncx_pad_putn_uchar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3111
{
#line 3111
    int status = NC_NOERR;
#line 3111
    size_t rndup = nelems % X_ALIGN;
#line 3111
    uchar *xp = (uchar *) *xpp;
#line 3111

#line 3111
    if (rndup) rndup = X_ALIGN - rndup;
#line 3111

#line 3111
    while (nelems-- != 0) {
#line 3111
        if (*tp > (double)X_UCHAR_MAX || *tp < 0) {
#line 3111
            
#line 3111
#ifdef ERANGE_FILL
#line 3111
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3111
#endif
#line 3111
            status = NC_ERANGE;
#line 3111
            
#line 3111
#ifdef ERANGE_FILL
#line 3111
            xp++; tp++; continue;
#line 3111
#endif
#line 3111
        }
#line 3111
        *xp++ = (uchar) (signed) *tp++; /* type cast from double to uchar */
#line 3111
    }
#line 3111

#line 3111

#line 3111
    if (rndup) {
#line 3111
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3111
        xp += rndup;
#line 3111
    }
#line 3111

#line 3111
    *xpp = (void *)xp;
#line 3111
    return status;
#line 3111
}
#line 3111

int
#line 3112
ncx_pad_putn_uchar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3112
{
#line 3112
    int status = NC_NOERR;
#line 3112
    size_t rndup = nelems % X_ALIGN;
#line 3112
    uchar *xp = (uchar *) *xpp;
#line 3112

#line 3112
    if (rndup) rndup = X_ALIGN - rndup;
#line 3112

#line 3112
    while (nelems-- != 0) {
#line 3112
        if (*tp > (longlong)X_UCHAR_MAX || *tp < 0) {
#line 3112
            
#line 3112
#ifdef ERANGE_FILL
#line 3112
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3112
#endif
#line 3112
            status = NC_ERANGE;
#line 3112
            
#line 3112
#ifdef ERANGE_FILL
#line 3112
            xp++; tp++; continue;
#line 3112
#endif
#line 3112
        }
#line 3112
        *xp++ = (uchar) (signed) *tp++; /* type cast from longlong to uchar */
#line 3112
    }
#line 3112

#line 3112

#line 3112
    if (rndup) {
#line 3112
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3112
        xp += rndup;
#line 3112
    }
#line 3112

#line 3112
    *xpp = (void *)xp;
#line 3112
    return status;
#line 3112
}
#line 3112

int
#line 3113
ncx_pad_putn_uchar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3113
{
#line 3113
    int status = NC_NOERR;
#line 3113
    size_t rndup = nelems % X_ALIGN;
#line 3113
    uchar *xp = (uchar *) *xpp;
#line 3113

#line 3113
    if (rndup) rndup = X_ALIGN - rndup;
#line 3113

#line 3113
    while (nelems-- != 0) {
#line 3113
        if (*tp > (ushort)X_UCHAR_MAX ) {
#line 3113
            
#line 3113
#ifdef ERANGE_FILL
#line 3113
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3113
#endif
#line 3113
            status = NC_ERANGE;
#line 3113
            
#line 3113
#ifdef ERANGE_FILL
#line 3113
            xp++; tp++; continue;
#line 3113
#endif
#line 3113
        }
#line 3113
        *xp++ = (uchar)  *tp++; /* type cast from ushort to uchar */
#line 3113
    }
#line 3113

#line 3113

#line 3113
    if (rndup) {
#line 3113
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3113
        xp += rndup;
#line 3113
    }
#line 3113

#line 3113
    *xpp = (void *)xp;
#line 3113
    return status;
#line 3113
}
#line 3113

int
#line 3114
ncx_pad_putn_uchar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3114
{
#line 3114
    int status = NC_NOERR;
#line 3114
    size_t rndup = nelems % X_ALIGN;
#line 3114
    uchar *xp = (uchar *) *xpp;
#line 3114

#line 3114
    if (rndup) rndup = X_ALIGN - rndup;
#line 3114

#line 3114
    while (nelems-- != 0) {
#line 3114
        if (*tp > (uint)X_UCHAR_MAX ) {
#line 3114
            
#line 3114
#ifdef ERANGE_FILL
#line 3114
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3114
#endif
#line 3114
            status = NC_ERANGE;
#line 3114
            
#line 3114
#ifdef ERANGE_FILL
#line 3114
            xp++; tp++; continue;
#line 3114
#endif
#line 3114
        }
#line 3114
        *xp++ = (uchar)  *tp++; /* type cast from uint to uchar */
#line 3114
    }
#line 3114

#line 3114

#line 3114
    if (rndup) {
#line 3114
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3114
        xp += rndup;
#line 3114
    }
#line 3114

#line 3114
    *xpp = (void *)xp;
#line 3114
    return status;
#line 3114
}
#line 3114

int
#line 3115
ncx_pad_putn_uchar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3115
{
#line 3115
    int status = NC_NOERR;
#line 3115
    size_t rndup = nelems % X_ALIGN;
#line 3115
    uchar *xp = (uchar *) *xpp;
#line 3115

#line 3115
    if (rndup) rndup = X_ALIGN - rndup;
#line 3115

#line 3115
    while (nelems-- != 0) {
#line 3115
        if (*tp > (ulonglong)X_UCHAR_MAX ) {
#line 3115
            
#line 3115
#ifdef ERANGE_FILL
#line 3115
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3115
#endif
#line 3115
            status = NC_ERANGE;
#line 3115
            
#line 3115
#ifdef ERANGE_FILL
#line 3115
            xp++; tp++; continue;
#line 3115
#endif
#line 3115
        }
#line 3115
        *xp++ = (uchar)  *tp++; /* type cast from ulonglong to uchar */
#line 3115
    }
#line 3115

#line 3115

#line 3115
    if (rndup) {
#line 3115
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3115
        xp += rndup;
#line 3115
    }
#line 3115

#line 3115
    *xpp = (void *)xp;
#line 3115
    return status;
#line 3115
}
#line 3115


/* short ---------------------------------------------------------------------*/

#if X_SIZEOF_SHORT == SIZEOF_SHORT
/* optimized version */
int
ncx_getn_short_short(const void **xpp, size_t nelems, short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_SHORT);
# else
	swapn2b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_SHORT);
	return NC_NOERR;
}
#else
int
#line 3133
ncx_getn_short_short(const void **xpp, size_t nelems, short *tp)
#line 3133
{
#line 3133
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3133

#line 3133
 /* basic algorithm is:
#line 3133
  *   - ensure sane alignment of input data
#line 3133
  *   - copy (conversion happens automatically) input data
#line 3133
  *     to output
#line 3133
  *   - update xpp to point at next unconverted input, and tp to point
#line 3133
  *     at next location for converted output
#line 3133
  */
#line 3133
  long i, j, ni;
#line 3133
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3133
  short *xp;
#line 3133
  int nrange = 0;         /* number of range errors */
#line 3133
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3133
  long cxp = (long) *((char**)xpp);
#line 3133

#line 3133
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3133
  /* sjl: manually stripmine so we can limit amount of
#line 3133
   * vector work space reserved to LOOPCNT elements. Also
#line 3133
   * makes vectorisation easy */
#line 3133
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3133
    ni=Min(nelems-j,LOOPCNT);
#line 3133
    if (realign) {
#line 3133
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3133
      xp = tmp;
#line 3133
    } else {
#line 3133
      xp = (short *) *xpp;
#line 3133
    }
#line 3133
   /* copy the next block */
#line 3133
#pragma cdir loopcnt=LOOPCNT
#line 3133
#pragma cdir shortloop
#line 3133
    for (i=0; i<ni; i++) {
#line 3133
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3133
     /* test for range errors (not always needed but do it anyway) */
#line 3133
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3133
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3133
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3133
    }
#line 3133
   /* update xpp and tp */
#line 3133
    if (realign) xp = (short *) *xpp;
#line 3133
    xp += ni;
#line 3133
    tp += ni;
#line 3133
    *xpp = (void*)xp;
#line 3133
  }
#line 3133
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3133

#line 3133
#else   /* not SX */
#line 3133
	const char *xp = (const char *) *xpp;
#line 3133
	int status = NC_NOERR;
#line 3133

#line 3133
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3133
	{
#line 3133
		const int lstatus = ncx_get_short_short(xp, tp);
#line 3133
		if (status == NC_NOERR) /* report the first encountered error */
#line 3133
			status = lstatus;
#line 3133
	}
#line 3133

#line 3133
	*xpp = (const void *)xp;
#line 3133
	return status;
#line 3133
#endif
#line 3133
}
#line 3133

#endif
int
#line 3135
ncx_getn_short_schar(const void **xpp, size_t nelems, schar *tp)
#line 3135
{
#line 3135
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3135

#line 3135
 /* basic algorithm is:
#line 3135
  *   - ensure sane alignment of input data
#line 3135
  *   - copy (conversion happens automatically) input data
#line 3135
  *     to output
#line 3135
  *   - update xpp to point at next unconverted input, and tp to point
#line 3135
  *     at next location for converted output
#line 3135
  */
#line 3135
  long i, j, ni;
#line 3135
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3135
  short *xp;
#line 3135
  int nrange = 0;         /* number of range errors */
#line 3135
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3135
  long cxp = (long) *((char**)xpp);
#line 3135

#line 3135
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3135
  /* sjl: manually stripmine so we can limit amount of
#line 3135
   * vector work space reserved to LOOPCNT elements. Also
#line 3135
   * makes vectorisation easy */
#line 3135
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3135
    ni=Min(nelems-j,LOOPCNT);
#line 3135
    if (realign) {
#line 3135
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3135
      xp = tmp;
#line 3135
    } else {
#line 3135
      xp = (short *) *xpp;
#line 3135
    }
#line 3135
   /* copy the next block */
#line 3135
#pragma cdir loopcnt=LOOPCNT
#line 3135
#pragma cdir shortloop
#line 3135
    for (i=0; i<ni; i++) {
#line 3135
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3135
     /* test for range errors (not always needed but do it anyway) */
#line 3135
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3135
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3135
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3135
    }
#line 3135
   /* update xpp and tp */
#line 3135
    if (realign) xp = (short *) *xpp;
#line 3135
    xp += ni;
#line 3135
    tp += ni;
#line 3135
    *xpp = (void*)xp;
#line 3135
  }
#line 3135
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3135

#line 3135
#else   /* not SX */
#line 3135
	const char *xp = (const char *) *xpp;
#line 3135
	int status = NC_NOERR;
#line 3135

#line 3135
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3135
	{
#line 3135
		const int lstatus = ncx_get_short_schar(xp, tp);
#line 3135
		if (status == NC_NOERR) /* report the first encountered error */
#line 3135
			status = lstatus;
#line 3135
	}
#line 3135

#line 3135
	*xpp = (const void *)xp;
#line 3135
	return status;
#line 3135
#endif
#line 3135
}
#line 3135

int
#line 3136
ncx_getn_short_int(const void **xpp, size_t nelems, int *tp)
#line 3136
{
#line 3136
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3136

#line 3136
 /* basic algorithm is:
#line 3136
  *   - ensure sane alignment of input data
#line 3136
  *   - copy (conversion happens automatically) input data
#line 3136
  *     to output
#line 3136
  *   - update xpp to point at next unconverted input, and tp to point
#line 3136
  *     at next location for converted output
#line 3136
  */
#line 3136
  long i, j, ni;
#line 3136
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3136
  short *xp;
#line 3136
  int nrange = 0;         /* number of range errors */
#line 3136
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3136
  long cxp = (long) *((char**)xpp);
#line 3136

#line 3136
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3136
  /* sjl: manually stripmine so we can limit amount of
#line 3136
   * vector work space reserved to LOOPCNT elements. Also
#line 3136
   * makes vectorisation easy */
#line 3136
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3136
    ni=Min(nelems-j,LOOPCNT);
#line 3136
    if (realign) {
#line 3136
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3136
      xp = tmp;
#line 3136
    } else {
#line 3136
      xp = (short *) *xpp;
#line 3136
    }
#line 3136
   /* copy the next block */
#line 3136
#pragma cdir loopcnt=LOOPCNT
#line 3136
#pragma cdir shortloop
#line 3136
    for (i=0; i<ni; i++) {
#line 3136
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3136
     /* test for range errors (not always needed but do it anyway) */
#line 3136
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3136
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3136
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3136
    }
#line 3136
   /* update xpp and tp */
#line 3136
    if (realign) xp = (short *) *xpp;
#line 3136
    xp += ni;
#line 3136
    tp += ni;
#line 3136
    *xpp = (void*)xp;
#line 3136
  }
#line 3136
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3136

#line 3136
#else   /* not SX */
#line 3136
	const char *xp = (const char *) *xpp;
#line 3136
	int status = NC_NOERR;
#line 3136

#line 3136
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3136
	{
#line 3136
		const int lstatus = ncx_get_short_int(xp, tp);
#line 3136
		if (status == NC_NOERR) /* report the first encountered error */
#line 3136
			status = lstatus;
#line 3136
	}
#line 3136

#line 3136
	*xpp = (const void *)xp;
#line 3136
	return status;
#line 3136
#endif
#line 3136
}
#line 3136

int
#line 3137
ncx_getn_short_long(const void **xpp, size_t nelems, long *tp)
#line 3137
{
#line 3137
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3137

#line 3137
 /* basic algorithm is:
#line 3137
  *   - ensure sane alignment of input data
#line 3137
  *   - copy (conversion happens automatically) input data
#line 3137
  *     to output
#line 3137
  *   - update xpp to point at next unconverted input, and tp to point
#line 3137
  *     at next location for converted output
#line 3137
  */
#line 3137
  long i, j, ni;
#line 3137
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3137
  short *xp;
#line 3137
  int nrange = 0;         /* number of range errors */
#line 3137
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3137
  long cxp = (long) *((char**)xpp);
#line 3137

#line 3137
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3137
  /* sjl: manually stripmine so we can limit amount of
#line 3137
   * vector work space reserved to LOOPCNT elements. Also
#line 3137
   * makes vectorisation easy */
#line 3137
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3137
    ni=Min(nelems-j,LOOPCNT);
#line 3137
    if (realign) {
#line 3137
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3137
      xp = tmp;
#line 3137
    } else {
#line 3137
      xp = (short *) *xpp;
#line 3137
    }
#line 3137
   /* copy the next block */
#line 3137
#pragma cdir loopcnt=LOOPCNT
#line 3137
#pragma cdir shortloop
#line 3137
    for (i=0; i<ni; i++) {
#line 3137
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3137
     /* test for range errors (not always needed but do it anyway) */
#line 3137
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3137
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3137
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3137
    }
#line 3137
   /* update xpp and tp */
#line 3137
    if (realign) xp = (short *) *xpp;
#line 3137
    xp += ni;
#line 3137
    tp += ni;
#line 3137
    *xpp = (void*)xp;
#line 3137
  }
#line 3137
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3137

#line 3137
#else   /* not SX */
#line 3137
	const char *xp = (const char *) *xpp;
#line 3137
	int status = NC_NOERR;
#line 3137

#line 3137
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3137
	{
#line 3137
		const int lstatus = ncx_get_short_long(xp, tp);
#line 3137
		if (status == NC_NOERR) /* report the first encountered error */
#line 3137
			status = lstatus;
#line 3137
	}
#line 3137

#line 3137
	*xpp = (const void *)xp;
#line 3137
	return status;
#line 3137
#endif
#line 3137
}
#line 3137

int
#line 3138
ncx_getn_short_float(const void **xpp, size_t nelems, float *tp)
#line 3138
{
#line 3138
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3138

#line 3138
 /* basic algorithm is:
#line 3138
  *   - ensure sane alignment of input data
#line 3138
  *   - copy (conversion happens automatically) input data
#line 3138
  *     to output
#line 3138
  *   - update xpp to point at next unconverted input, and tp to point
#line 3138
  *     at next location for converted output
#line 3138
  */
#line 3138
  long i, j, ni;
#line 3138
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3138
  short *xp;
#line 3138
  int nrange = 0;         /* number of range errors */
#line 3138
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3138
  long cxp = (long) *((char**)xpp);
#line 3138

#line 3138
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3138
  /* sjl: manually stripmine so we can limit amount of
#line 3138
   * vector work space reserved to LOOPCNT elements. Also
#line 3138
   * makes vectorisation easy */
#line 3138
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3138
    ni=Min(nelems-j,LOOPCNT);
#line 3138
    if (realign) {
#line 3138
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3138
      xp = tmp;
#line 3138
    } else {
#line 3138
      xp = (short *) *xpp;
#line 3138
    }
#line 3138
   /* copy the next block */
#line 3138
#pragma cdir loopcnt=LOOPCNT
#line 3138
#pragma cdir shortloop
#line 3138
    for (i=0; i<ni; i++) {
#line 3138
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3138
     /* test for range errors (not always needed but do it anyway) */
#line 3138
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3138
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3138
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3138
    }
#line 3138
   /* update xpp and tp */
#line 3138
    if (realign) xp = (short *) *xpp;
#line 3138
    xp += ni;
#line 3138
    tp += ni;
#line 3138
    *xpp = (void*)xp;
#line 3138
  }
#line 3138
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3138

#line 3138
#else   /* not SX */
#line 3138
	const char *xp = (const char *) *xpp;
#line 3138
	int status = NC_NOERR;
#line 3138

#line 3138
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3138
	{
#line 3138
		const int lstatus = ncx_get_short_float(xp, tp);
#line 3138
		if (status == NC_NOERR) /* report the first encountered error */
#line 3138
			status = lstatus;
#line 3138
	}
#line 3138

#line 3138
	*xpp = (const void *)xp;
#line 3138
	return status;
#line 3138
#endif
#line 3138
}
#line 3138

int
#line 3139
ncx_getn_short_double(const void **xpp, size_t nelems, double *tp)
#line 3139
{
#line 3139
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3139

#line 3139
 /* basic algorithm is:
#line 3139
  *   - ensure sane alignment of input data
#line 3139
  *   - copy (conversion happens automatically) input data
#line 3139
  *     to output
#line 3139
  *   - update xpp to point at next unconverted input, and tp to point
#line 3139
  *     at next location for converted output
#line 3139
  */
#line 3139
  long i, j, ni;
#line 3139
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3139
  short *xp;
#line 3139
  int nrange = 0;         /* number of range errors */
#line 3139
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3139
  long cxp = (long) *((char**)xpp);
#line 3139

#line 3139
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3139
  /* sjl: manually stripmine so we can limit amount of
#line 3139
   * vector work space reserved to LOOPCNT elements. Also
#line 3139
   * makes vectorisation easy */
#line 3139
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3139
    ni=Min(nelems-j,LOOPCNT);
#line 3139
    if (realign) {
#line 3139
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3139
      xp = tmp;
#line 3139
    } else {
#line 3139
      xp = (short *) *xpp;
#line 3139
    }
#line 3139
   /* copy the next block */
#line 3139
#pragma cdir loopcnt=LOOPCNT
#line 3139
#pragma cdir shortloop
#line 3139
    for (i=0; i<ni; i++) {
#line 3139
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3139
     /* test for range errors (not always needed but do it anyway) */
#line 3139
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3139
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3139
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3139
    }
#line 3139
   /* update xpp and tp */
#line 3139
    if (realign) xp = (short *) *xpp;
#line 3139
    xp += ni;
#line 3139
    tp += ni;
#line 3139
    *xpp = (void*)xp;
#line 3139
  }
#line 3139
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3139

#line 3139
#else   /* not SX */
#line 3139
	const char *xp = (const char *) *xpp;
#line 3139
	int status = NC_NOERR;
#line 3139

#line 3139
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3139
	{
#line 3139
		const int lstatus = ncx_get_short_double(xp, tp);
#line 3139
		if (status == NC_NOERR) /* report the first encountered error */
#line 3139
			status = lstatus;
#line 3139
	}
#line 3139

#line 3139
	*xpp = (const void *)xp;
#line 3139
	return status;
#line 3139
#endif
#line 3139
}
#line 3139

int
#line 3140
ncx_getn_short_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3140
{
#line 3140
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3140

#line 3140
 /* basic algorithm is:
#line 3140
  *   - ensure sane alignment of input data
#line 3140
  *   - copy (conversion happens automatically) input data
#line 3140
  *     to output
#line 3140
  *   - update xpp to point at next unconverted input, and tp to point
#line 3140
  *     at next location for converted output
#line 3140
  */
#line 3140
  long i, j, ni;
#line 3140
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3140
  short *xp;
#line 3140
  int nrange = 0;         /* number of range errors */
#line 3140
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3140
  long cxp = (long) *((char**)xpp);
#line 3140

#line 3140
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3140
  /* sjl: manually stripmine so we can limit amount of
#line 3140
   * vector work space reserved to LOOPCNT elements. Also
#line 3140
   * makes vectorisation easy */
#line 3140
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3140
    ni=Min(nelems-j,LOOPCNT);
#line 3140
    if (realign) {
#line 3140
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3140
      xp = tmp;
#line 3140
    } else {
#line 3140
      xp = (short *) *xpp;
#line 3140
    }
#line 3140
   /* copy the next block */
#line 3140
#pragma cdir loopcnt=LOOPCNT
#line 3140
#pragma cdir shortloop
#line 3140
    for (i=0; i<ni; i++) {
#line 3140
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3140
     /* test for range errors (not always needed but do it anyway) */
#line 3140
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3140
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3140
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3140
    }
#line 3140
   /* update xpp and tp */
#line 3140
    if (realign) xp = (short *) *xpp;
#line 3140
    xp += ni;
#line 3140
    tp += ni;
#line 3140
    *xpp = (void*)xp;
#line 3140
  }
#line 3140
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3140

#line 3140
#else   /* not SX */
#line 3140
	const char *xp = (const char *) *xpp;
#line 3140
	int status = NC_NOERR;
#line 3140

#line 3140
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3140
	{
#line 3140
		const int lstatus = ncx_get_short_longlong(xp, tp);
#line 3140
		if (status == NC_NOERR) /* report the first encountered error */
#line 3140
			status = lstatus;
#line 3140
	}
#line 3140

#line 3140
	*xpp = (const void *)xp;
#line 3140
	return status;
#line 3140
#endif
#line 3140
}
#line 3140

int
#line 3141
ncx_getn_short_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3141
{
#line 3141
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3141

#line 3141
 /* basic algorithm is:
#line 3141
  *   - ensure sane alignment of input data
#line 3141
  *   - copy (conversion happens automatically) input data
#line 3141
  *     to output
#line 3141
  *   - update xpp to point at next unconverted input, and tp to point
#line 3141
  *     at next location for converted output
#line 3141
  */
#line 3141
  long i, j, ni;
#line 3141
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3141
  short *xp;
#line 3141
  int nrange = 0;         /* number of range errors */
#line 3141
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3141
  long cxp = (long) *((char**)xpp);
#line 3141

#line 3141
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3141
  /* sjl: manually stripmine so we can limit amount of
#line 3141
   * vector work space reserved to LOOPCNT elements. Also
#line 3141
   * makes vectorisation easy */
#line 3141
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3141
    ni=Min(nelems-j,LOOPCNT);
#line 3141
    if (realign) {
#line 3141
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3141
      xp = tmp;
#line 3141
    } else {
#line 3141
      xp = (short *) *xpp;
#line 3141
    }
#line 3141
   /* copy the next block */
#line 3141
#pragma cdir loopcnt=LOOPCNT
#line 3141
#pragma cdir shortloop
#line 3141
    for (i=0; i<ni; i++) {
#line 3141
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3141
     /* test for range errors (not always needed but do it anyway) */
#line 3141
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3141
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3141
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3141
    }
#line 3141
   /* update xpp and tp */
#line 3141
    if (realign) xp = (short *) *xpp;
#line 3141
    xp += ni;
#line 3141
    tp += ni;
#line 3141
    *xpp = (void*)xp;
#line 3141
  }
#line 3141
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3141

#line 3141
#else   /* not SX */
#line 3141
	const char *xp = (const char *) *xpp;
#line 3141
	int status = NC_NOERR;
#line 3141

#line 3141
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3141
	{
#line 3141
		const int lstatus = ncx_get_short_uchar(xp, tp);
#line 3141
		if (status == NC_NOERR) /* report the first encountered error */
#line 3141
			status = lstatus;
#line 3141
	}
#line 3141

#line 3141
	*xpp = (const void *)xp;
#line 3141
	return status;
#line 3141
#endif
#line 3141
}
#line 3141

int
#line 3142
ncx_getn_short_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3142
{
#line 3142
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3142

#line 3142
 /* basic algorithm is:
#line 3142
  *   - ensure sane alignment of input data
#line 3142
  *   - copy (conversion happens automatically) input data
#line 3142
  *     to output
#line 3142
  *   - update xpp to point at next unconverted input, and tp to point
#line 3142
  *     at next location for converted output
#line 3142
  */
#line 3142
  long i, j, ni;
#line 3142
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3142
  short *xp;
#line 3142
  int nrange = 0;         /* number of range errors */
#line 3142
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3142
  long cxp = (long) *((char**)xpp);
#line 3142

#line 3142
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3142
  /* sjl: manually stripmine so we can limit amount of
#line 3142
   * vector work space reserved to LOOPCNT elements. Also
#line 3142
   * makes vectorisation easy */
#line 3142
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3142
    ni=Min(nelems-j,LOOPCNT);
#line 3142
    if (realign) {
#line 3142
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3142
      xp = tmp;
#line 3142
    } else {
#line 3142
      xp = (short *) *xpp;
#line 3142
    }
#line 3142
   /* copy the next block */
#line 3142
#pragma cdir loopcnt=LOOPCNT
#line 3142
#pragma cdir shortloop
#line 3142
    for (i=0; i<ni; i++) {
#line 3142
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3142
     /* test for range errors (not always needed but do it anyway) */
#line 3142
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3142
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3142
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3142
    }
#line 3142
   /* update xpp and tp */
#line 3142
    if (realign) xp = (short *) *xpp;
#line 3142
    xp += ni;
#line 3142
    tp += ni;
#line 3142
    *xpp = (void*)xp;
#line 3142
  }
#line 3142
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3142

#line 3142
#else   /* not SX */
#line 3142
	const char *xp = (const char *) *xpp;
#line 3142
	int status = NC_NOERR;
#line 3142

#line 3142
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3142
	{
#line 3142
		const int lstatus = ncx_get_short_ushort(xp, tp);
#line 3142
		if (status == NC_NOERR) /* report the first encountered error */
#line 3142
			status = lstatus;
#line 3142
	}
#line 3142

#line 3142
	*xpp = (const void *)xp;
#line 3142
	return status;
#line 3142
#endif
#line 3142
}
#line 3142

int
#line 3143
ncx_getn_short_uint(const void **xpp, size_t nelems, uint *tp)
#line 3143
{
#line 3143
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3143

#line 3143
 /* basic algorithm is:
#line 3143
  *   - ensure sane alignment of input data
#line 3143
  *   - copy (conversion happens automatically) input data
#line 3143
  *     to output
#line 3143
  *   - update xpp to point at next unconverted input, and tp to point
#line 3143
  *     at next location for converted output
#line 3143
  */
#line 3143
  long i, j, ni;
#line 3143
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3143
  short *xp;
#line 3143
  int nrange = 0;         /* number of range errors */
#line 3143
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3143
  long cxp = (long) *((char**)xpp);
#line 3143

#line 3143
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3143
  /* sjl: manually stripmine so we can limit amount of
#line 3143
   * vector work space reserved to LOOPCNT elements. Also
#line 3143
   * makes vectorisation easy */
#line 3143
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3143
    ni=Min(nelems-j,LOOPCNT);
#line 3143
    if (realign) {
#line 3143
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3143
      xp = tmp;
#line 3143
    } else {
#line 3143
      xp = (short *) *xpp;
#line 3143
    }
#line 3143
   /* copy the next block */
#line 3143
#pragma cdir loopcnt=LOOPCNT
#line 3143
#pragma cdir shortloop
#line 3143
    for (i=0; i<ni; i++) {
#line 3143
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3143
     /* test for range errors (not always needed but do it anyway) */
#line 3143
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3143
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3143
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3143
    }
#line 3143
   /* update xpp and tp */
#line 3143
    if (realign) xp = (short *) *xpp;
#line 3143
    xp += ni;
#line 3143
    tp += ni;
#line 3143
    *xpp = (void*)xp;
#line 3143
  }
#line 3143
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3143

#line 3143
#else   /* not SX */
#line 3143
	const char *xp = (const char *) *xpp;
#line 3143
	int status = NC_NOERR;
#line 3143

#line 3143
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3143
	{
#line 3143
		const int lstatus = ncx_get_short_uint(xp, tp);
#line 3143
		if (status == NC_NOERR) /* report the first encountered error */
#line 3143
			status = lstatus;
#line 3143
	}
#line 3143

#line 3143
	*xpp = (const void *)xp;
#line 3143
	return status;
#line 3143
#endif
#line 3143
}
#line 3143

int
#line 3144
ncx_getn_short_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3144
{
#line 3144
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3144

#line 3144
 /* basic algorithm is:
#line 3144
  *   - ensure sane alignment of input data
#line 3144
  *   - copy (conversion happens automatically) input data
#line 3144
  *     to output
#line 3144
  *   - update xpp to point at next unconverted input, and tp to point
#line 3144
  *     at next location for converted output
#line 3144
  */
#line 3144
  long i, j, ni;
#line 3144
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3144
  short *xp;
#line 3144
  int nrange = 0;         /* number of range errors */
#line 3144
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3144
  long cxp = (long) *((char**)xpp);
#line 3144

#line 3144
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3144
  /* sjl: manually stripmine so we can limit amount of
#line 3144
   * vector work space reserved to LOOPCNT elements. Also
#line 3144
   * makes vectorisation easy */
#line 3144
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3144
    ni=Min(nelems-j,LOOPCNT);
#line 3144
    if (realign) {
#line 3144
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3144
      xp = tmp;
#line 3144
    } else {
#line 3144
      xp = (short *) *xpp;
#line 3144
    }
#line 3144
   /* copy the next block */
#line 3144
#pragma cdir loopcnt=LOOPCNT
#line 3144
#pragma cdir shortloop
#line 3144
    for (i=0; i<ni; i++) {
#line 3144
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3144
     /* test for range errors (not always needed but do it anyway) */
#line 3144
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3144
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3144
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3144
    }
#line 3144
   /* update xpp and tp */
#line 3144
    if (realign) xp = (short *) *xpp;
#line 3144
    xp += ni;
#line 3144
    tp += ni;
#line 3144
    *xpp = (void*)xp;
#line 3144
  }
#line 3144
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3144

#line 3144
#else   /* not SX */
#line 3144
	const char *xp = (const char *) *xpp;
#line 3144
	int status = NC_NOERR;
#line 3144

#line 3144
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3144
	{
#line 3144
		const int lstatus = ncx_get_short_ulonglong(xp, tp);
#line 3144
		if (status == NC_NOERR) /* report the first encountered error */
#line 3144
			status = lstatus;
#line 3144
	}
#line 3144

#line 3144
	*xpp = (const void *)xp;
#line 3144
	return status;
#line 3144
#endif
#line 3144
}
#line 3144


int
#line 3146
ncx_pad_getn_short_schar(const void **xpp, size_t nelems, schar *tp)
#line 3146
{
#line 3146
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3146

#line 3146
	const char *xp = (const char *) *xpp;
#line 3146
	int status = NC_NOERR;
#line 3146

#line 3146
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3146
	{
#line 3146
		const int lstatus = ncx_get_short_schar(xp, tp);
#line 3146
		if (status == NC_NOERR) /* report the first encountered error */
#line 3146
			status = lstatus;
#line 3146
	}
#line 3146

#line 3146
	if (rndup != 0)
#line 3146
		xp += X_SIZEOF_SHORT;
#line 3146

#line 3146
	*xpp = (void *)xp;
#line 3146
	return status;
#line 3146
}
#line 3146

int
#line 3147
ncx_pad_getn_short_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3147
{
#line 3147
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3147

#line 3147
	const char *xp = (const char *) *xpp;
#line 3147
	int status = NC_NOERR;
#line 3147

#line 3147
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3147
	{
#line 3147
		const int lstatus = ncx_get_short_uchar(xp, tp);
#line 3147
		if (status == NC_NOERR) /* report the first encountered error */
#line 3147
			status = lstatus;
#line 3147
	}
#line 3147

#line 3147
	if (rndup != 0)
#line 3147
		xp += X_SIZEOF_SHORT;
#line 3147

#line 3147
	*xpp = (void *)xp;
#line 3147
	return status;
#line 3147
}
#line 3147

int
#line 3148
ncx_pad_getn_short_short(const void **xpp, size_t nelems, short *tp)
#line 3148
{
#line 3148
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3148

#line 3148
	const char *xp = (const char *) *xpp;
#line 3148
	int status = NC_NOERR;
#line 3148

#line 3148
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3148
	{
#line 3148
		const int lstatus = ncx_get_short_short(xp, tp);
#line 3148
		if (status == NC_NOERR) /* report the first encountered error */
#line 3148
			status = lstatus;
#line 3148
	}
#line 3148

#line 3148
	if (rndup != 0)
#line 3148
		xp += X_SIZEOF_SHORT;
#line 3148

#line 3148
	*xpp = (void *)xp;
#line 3148
	return status;
#line 3148
}
#line 3148

int
#line 3149
ncx_pad_getn_short_int(const void **xpp, size_t nelems, int *tp)
#line 3149
{
#line 3149
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3149

#line 3149
	const char *xp = (const char *) *xpp;
#line 3149
	int status = NC_NOERR;
#line 3149

#line 3149
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3149
	{
#line 3149
		const int lstatus = ncx_get_short_int(xp, tp);
#line 3149
		if (status == NC_NOERR) /* report the first encountered error */
#line 3149
			status = lstatus;
#line 3149
	}
#line 3149

#line 3149
	if (rndup != 0)
#line 3149
		xp += X_SIZEOF_SHORT;
#line 3149

#line 3149
	*xpp = (void *)xp;
#line 3149
	return status;
#line 3149
}
#line 3149

int
#line 3150
ncx_pad_getn_short_long(const void **xpp, size_t nelems, long *tp)
#line 3150
{
#line 3150
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3150

#line 3150
	const char *xp = (const char *) *xpp;
#line 3150
	int status = NC_NOERR;
#line 3150

#line 3150
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3150
	{
#line 3150
		const int lstatus = ncx_get_short_long(xp, tp);
#line 3150
		if (status == NC_NOERR) /* report the first encountered error */
#line 3150
			status = lstatus;
#line 3150
	}
#line 3150

#line 3150
	if (rndup != 0)
#line 3150
		xp += X_SIZEOF_SHORT;
#line 3150

#line 3150
	*xpp = (void *)xp;
#line 3150
	return status;
#line 3150
}
#line 3150

int
#line 3151
ncx_pad_getn_short_float(const void **xpp, size_t nelems, float *tp)
#line 3151
{
#line 3151
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3151

#line 3151
	const char *xp = (const char *) *xpp;
#line 3151
	int status = NC_NOERR;
#line 3151

#line 3151
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3151
	{
#line 3151
		const int lstatus = ncx_get_short_float(xp, tp);
#line 3151
		if (status == NC_NOERR) /* report the first encountered error */
#line 3151
			status = lstatus;
#line 3151
	}
#line 3151

#line 3151
	if (rndup != 0)
#line 3151
		xp += X_SIZEOF_SHORT;
#line 3151

#line 3151
	*xpp = (void *)xp;
#line 3151
	return status;
#line 3151
}
#line 3151

int
#line 3152
ncx_pad_getn_short_double(const void **xpp, size_t nelems, double *tp)
#line 3152
{
#line 3152
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3152

#line 3152
	const char *xp = (const char *) *xpp;
#line 3152
	int status = NC_NOERR;
#line 3152

#line 3152
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3152
	{
#line 3152
		const int lstatus = ncx_get_short_double(xp, tp);
#line 3152
		if (status == NC_NOERR) /* report the first encountered error */
#line 3152
			status = lstatus;
#line 3152
	}
#line 3152

#line 3152
	if (rndup != 0)
#line 3152
		xp += X_SIZEOF_SHORT;
#line 3152

#line 3152
	*xpp = (void *)xp;
#line 3152
	return status;
#line 3152
}
#line 3152

int
#line 3153
ncx_pad_getn_short_uint(const void **xpp, size_t nelems, uint *tp)
#line 3153
{
#line 3153
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3153

#line 3153
	const char *xp = (const char *) *xpp;
#line 3153
	int status = NC_NOERR;
#line 3153

#line 3153
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3153
	{
#line 3153
		const int lstatus = ncx_get_short_uint(xp, tp);
#line 3153
		if (status == NC_NOERR) /* report the first encountered error */
#line 3153
			status = lstatus;
#line 3153
	}
#line 3153

#line 3153
	if (rndup != 0)
#line 3153
		xp += X_SIZEOF_SHORT;
#line 3153

#line 3153
	*xpp = (void *)xp;
#line 3153
	return status;
#line 3153
}
#line 3153

int
#line 3154
ncx_pad_getn_short_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3154
{
#line 3154
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3154

#line 3154
	const char *xp = (const char *) *xpp;
#line 3154
	int status = NC_NOERR;
#line 3154

#line 3154
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3154
	{
#line 3154
		const int lstatus = ncx_get_short_longlong(xp, tp);
#line 3154
		if (status == NC_NOERR) /* report the first encountered error */
#line 3154
			status = lstatus;
#line 3154
	}
#line 3154

#line 3154
	if (rndup != 0)
#line 3154
		xp += X_SIZEOF_SHORT;
#line 3154

#line 3154
	*xpp = (void *)xp;
#line 3154
	return status;
#line 3154
}
#line 3154

int
#line 3155
ncx_pad_getn_short_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3155
{
#line 3155
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3155

#line 3155
	const char *xp = (const char *) *xpp;
#line 3155
	int status = NC_NOERR;
#line 3155

#line 3155
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3155
	{
#line 3155
		const int lstatus = ncx_get_short_ulonglong(xp, tp);
#line 3155
		if (status == NC_NOERR) /* report the first encountered error */
#line 3155
			status = lstatus;
#line 3155
	}
#line 3155

#line 3155
	if (rndup != 0)
#line 3155
		xp += X_SIZEOF_SHORT;
#line 3155

#line 3155
	*xpp = (void *)xp;
#line 3155
	return status;
#line 3155
}
#line 3155

int
#line 3156
ncx_pad_getn_short_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3156
{
#line 3156
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3156

#line 3156
	const char *xp = (const char *) *xpp;
#line 3156
	int status = NC_NOERR;
#line 3156

#line 3156
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3156
	{
#line 3156
		const int lstatus = ncx_get_short_ushort(xp, tp);
#line 3156
		if (status == NC_NOERR) /* report the first encountered error */
#line 3156
			status = lstatus;
#line 3156
	}
#line 3156

#line 3156
	if (rndup != 0)
#line 3156
		xp += X_SIZEOF_SHORT;
#line 3156

#line 3156
	*xpp = (void *)xp;
#line 3156
	return status;
#line 3156
}
#line 3156


#if X_SIZEOF_SHORT == SIZEOF_SHORT
/* optimized version */
int
ncx_putn_short_short(void **xpp, size_t nelems, const short *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_SHORT);
# else
	swapn2b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_SHORT);
	return NC_NOERR;
}
#else
int
#line 3172
ncx_putn_short_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3172
{
#line 3172
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3172

#line 3172
 /* basic algorithm is:
#line 3172
  *   - ensure sane alignment of output data
#line 3172
  *   - copy (conversion happens automatically) input data
#line 3172
  *     to output
#line 3172
  *   - update tp to point at next unconverted input, and xpp to point
#line 3172
  *     at next location for converted output
#line 3172
  */
#line 3172
  long i, j, ni;
#line 3172
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3172
  short *xp;
#line 3172
  int nrange = 0;         /* number of range errors */
#line 3172
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3172
  long cxp = (long) *((char**)xpp);
#line 3172

#line 3172
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3172
  /* sjl: manually stripmine so we can limit amount of
#line 3172
   * vector work space reserved to LOOPCNT elements. Also
#line 3172
   * makes vectorisation easy */
#line 3172
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3172
    ni=Min(nelems-j,LOOPCNT);
#line 3172
    if (realign) {
#line 3172
      xp = tmp;
#line 3172
    } else {
#line 3172
      xp = (short *) *xpp;
#line 3172
    }
#line 3172
   /* copy the next block */
#line 3172
#pragma cdir loopcnt=LOOPCNT
#line 3172
#pragma cdir shortloop
#line 3172
    for (i=0; i<ni; i++) {
#line 3172
      /* the normal case: */
#line 3172
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3172
     /* test for range errors (not always needed but do it anyway) */
#line 3172
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3172
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3172
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3172
    }
#line 3172
   /* copy workspace back if necessary */
#line 3172
    if (realign) {
#line 3172
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3172
      xp = (short *) *xpp;
#line 3172
    }
#line 3172
   /* update xpp and tp */
#line 3172
    xp += ni;
#line 3172
    tp += ni;
#line 3172
    *xpp = (void*)xp;
#line 3172
  }
#line 3172
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3172

#line 3172
#else   /* not SX */
#line 3172

#line 3172
	char *xp = (char *) *xpp;
#line 3172
	int status = NC_NOERR;
#line 3172

#line 3172
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3172
	{
#line 3172
		int lstatus = ncx_put_short_short(xp, tp, fillp);
#line 3172
		if (status == NC_NOERR) /* report the first encountered error */
#line 3172
			status = lstatus;
#line 3172
	}
#line 3172

#line 3172
	*xpp = (void *)xp;
#line 3172
	return status;
#line 3172
#endif
#line 3172
}
#line 3172

#endif
int
#line 3174
ncx_putn_short_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3174
{
#line 3174
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3174

#line 3174
 /* basic algorithm is:
#line 3174
  *   - ensure sane alignment of output data
#line 3174
  *   - copy (conversion happens automatically) input data
#line 3174
  *     to output
#line 3174
  *   - update tp to point at next unconverted input, and xpp to point
#line 3174
  *     at next location for converted output
#line 3174
  */
#line 3174
  long i, j, ni;
#line 3174
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3174
  short *xp;
#line 3174
  int nrange = 0;         /* number of range errors */
#line 3174
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3174
  long cxp = (long) *((char**)xpp);
#line 3174

#line 3174
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3174
  /* sjl: manually stripmine so we can limit amount of
#line 3174
   * vector work space reserved to LOOPCNT elements. Also
#line 3174
   * makes vectorisation easy */
#line 3174
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3174
    ni=Min(nelems-j,LOOPCNT);
#line 3174
    if (realign) {
#line 3174
      xp = tmp;
#line 3174
    } else {
#line 3174
      xp = (short *) *xpp;
#line 3174
    }
#line 3174
   /* copy the next block */
#line 3174
#pragma cdir loopcnt=LOOPCNT
#line 3174
#pragma cdir shortloop
#line 3174
    for (i=0; i<ni; i++) {
#line 3174
      /* the normal case: */
#line 3174
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3174
     /* test for range errors (not always needed but do it anyway) */
#line 3174
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3174
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3174
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3174
    }
#line 3174
   /* copy workspace back if necessary */
#line 3174
    if (realign) {
#line 3174
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3174
      xp = (short *) *xpp;
#line 3174
    }
#line 3174
   /* update xpp and tp */
#line 3174
    xp += ni;
#line 3174
    tp += ni;
#line 3174
    *xpp = (void*)xp;
#line 3174
  }
#line 3174
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3174

#line 3174
#else   /* not SX */
#line 3174

#line 3174
	char *xp = (char *) *xpp;
#line 3174
	int status = NC_NOERR;
#line 3174

#line 3174
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3174
	{
#line 3174
		int lstatus = ncx_put_short_schar(xp, tp, fillp);
#line 3174
		if (status == NC_NOERR) /* report the first encountered error */
#line 3174
			status = lstatus;
#line 3174
	}
#line 3174

#line 3174
	*xpp = (void *)xp;
#line 3174
	return status;
#line 3174
#endif
#line 3174
}
#line 3174

int
#line 3175
ncx_putn_short_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3175
{
#line 3175
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3175

#line 3175
 /* basic algorithm is:
#line 3175
  *   - ensure sane alignment of output data
#line 3175
  *   - copy (conversion happens automatically) input data
#line 3175
  *     to output
#line 3175
  *   - update tp to point at next unconverted input, and xpp to point
#line 3175
  *     at next location for converted output
#line 3175
  */
#line 3175
  long i, j, ni;
#line 3175
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3175
  short *xp;
#line 3175
  int nrange = 0;         /* number of range errors */
#line 3175
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3175
  long cxp = (long) *((char**)xpp);
#line 3175

#line 3175
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3175
  /* sjl: manually stripmine so we can limit amount of
#line 3175
   * vector work space reserved to LOOPCNT elements. Also
#line 3175
   * makes vectorisation easy */
#line 3175
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3175
    ni=Min(nelems-j,LOOPCNT);
#line 3175
    if (realign) {
#line 3175
      xp = tmp;
#line 3175
    } else {
#line 3175
      xp = (short *) *xpp;
#line 3175
    }
#line 3175
   /* copy the next block */
#line 3175
#pragma cdir loopcnt=LOOPCNT
#line 3175
#pragma cdir shortloop
#line 3175
    for (i=0; i<ni; i++) {
#line 3175
      /* the normal case: */
#line 3175
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3175
     /* test for range errors (not always needed but do it anyway) */
#line 3175
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3175
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3175
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3175
    }
#line 3175
   /* copy workspace back if necessary */
#line 3175
    if (realign) {
#line 3175
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3175
      xp = (short *) *xpp;
#line 3175
    }
#line 3175
   /* update xpp and tp */
#line 3175
    xp += ni;
#line 3175
    tp += ni;
#line 3175
    *xpp = (void*)xp;
#line 3175
  }
#line 3175
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3175

#line 3175
#else   /* not SX */
#line 3175

#line 3175
	char *xp = (char *) *xpp;
#line 3175
	int status = NC_NOERR;
#line 3175

#line 3175
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3175
	{
#line 3175
		int lstatus = ncx_put_short_int(xp, tp, fillp);
#line 3175
		if (status == NC_NOERR) /* report the first encountered error */
#line 3175
			status = lstatus;
#line 3175
	}
#line 3175

#line 3175
	*xpp = (void *)xp;
#line 3175
	return status;
#line 3175
#endif
#line 3175
}
#line 3175

int
#line 3176
ncx_putn_short_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3176
{
#line 3176
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3176

#line 3176
 /* basic algorithm is:
#line 3176
  *   - ensure sane alignment of output data
#line 3176
  *   - copy (conversion happens automatically) input data
#line 3176
  *     to output
#line 3176
  *   - update tp to point at next unconverted input, and xpp to point
#line 3176
  *     at next location for converted output
#line 3176
  */
#line 3176
  long i, j, ni;
#line 3176
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3176
  short *xp;
#line 3176
  int nrange = 0;         /* number of range errors */
#line 3176
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3176
  long cxp = (long) *((char**)xpp);
#line 3176

#line 3176
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3176
  /* sjl: manually stripmine so we can limit amount of
#line 3176
   * vector work space reserved to LOOPCNT elements. Also
#line 3176
   * makes vectorisation easy */
#line 3176
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3176
    ni=Min(nelems-j,LOOPCNT);
#line 3176
    if (realign) {
#line 3176
      xp = tmp;
#line 3176
    } else {
#line 3176
      xp = (short *) *xpp;
#line 3176
    }
#line 3176
   /* copy the next block */
#line 3176
#pragma cdir loopcnt=LOOPCNT
#line 3176
#pragma cdir shortloop
#line 3176
    for (i=0; i<ni; i++) {
#line 3176
      /* the normal case: */
#line 3176
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3176
     /* test for range errors (not always needed but do it anyway) */
#line 3176
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3176
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3176
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3176
    }
#line 3176
   /* copy workspace back if necessary */
#line 3176
    if (realign) {
#line 3176
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3176
      xp = (short *) *xpp;
#line 3176
    }
#line 3176
   /* update xpp and tp */
#line 3176
    xp += ni;
#line 3176
    tp += ni;
#line 3176
    *xpp = (void*)xp;
#line 3176
  }
#line 3176
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3176

#line 3176
#else   /* not SX */
#line 3176

#line 3176
	char *xp = (char *) *xpp;
#line 3176
	int status = NC_NOERR;
#line 3176

#line 3176
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3176
	{
#line 3176
		int lstatus = ncx_put_short_long(xp, tp, fillp);
#line 3176
		if (status == NC_NOERR) /* report the first encountered error */
#line 3176
			status = lstatus;
#line 3176
	}
#line 3176

#line 3176
	*xpp = (void *)xp;
#line 3176
	return status;
#line 3176
#endif
#line 3176
}
#line 3176

int
#line 3177
ncx_putn_short_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3177
{
#line 3177
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3177

#line 3177
 /* basic algorithm is:
#line 3177
  *   - ensure sane alignment of output data
#line 3177
  *   - copy (conversion happens automatically) input data
#line 3177
  *     to output
#line 3177
  *   - update tp to point at next unconverted input, and xpp to point
#line 3177
  *     at next location for converted output
#line 3177
  */
#line 3177
  long i, j, ni;
#line 3177
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3177
  short *xp;
#line 3177
  int nrange = 0;         /* number of range errors */
#line 3177
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3177
  long cxp = (long) *((char**)xpp);
#line 3177

#line 3177
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3177
  /* sjl: manually stripmine so we can limit amount of
#line 3177
   * vector work space reserved to LOOPCNT elements. Also
#line 3177
   * makes vectorisation easy */
#line 3177
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3177
    ni=Min(nelems-j,LOOPCNT);
#line 3177
    if (realign) {
#line 3177
      xp = tmp;
#line 3177
    } else {
#line 3177
      xp = (short *) *xpp;
#line 3177
    }
#line 3177
   /* copy the next block */
#line 3177
#pragma cdir loopcnt=LOOPCNT
#line 3177
#pragma cdir shortloop
#line 3177
    for (i=0; i<ni; i++) {
#line 3177
      /* the normal case: */
#line 3177
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3177
     /* test for range errors (not always needed but do it anyway) */
#line 3177
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3177
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3177
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3177
    }
#line 3177
   /* copy workspace back if necessary */
#line 3177
    if (realign) {
#line 3177
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3177
      xp = (short *) *xpp;
#line 3177
    }
#line 3177
   /* update xpp and tp */
#line 3177
    xp += ni;
#line 3177
    tp += ni;
#line 3177
    *xpp = (void*)xp;
#line 3177
  }
#line 3177
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3177

#line 3177
#else   /* not SX */
#line 3177

#line 3177
	char *xp = (char *) *xpp;
#line 3177
	int status = NC_NOERR;
#line 3177

#line 3177
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3177
	{
#line 3177
		int lstatus = ncx_put_short_float(xp, tp, fillp);
#line 3177
		if (status == NC_NOERR) /* report the first encountered error */
#line 3177
			status = lstatus;
#line 3177
	}
#line 3177

#line 3177
	*xpp = (void *)xp;
#line 3177
	return status;
#line 3177
#endif
#line 3177
}
#line 3177

int
#line 3178
ncx_putn_short_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3178
{
#line 3178
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3178

#line 3178
 /* basic algorithm is:
#line 3178
  *   - ensure sane alignment of output data
#line 3178
  *   - copy (conversion happens automatically) input data
#line 3178
  *     to output
#line 3178
  *   - update tp to point at next unconverted input, and xpp to point
#line 3178
  *     at next location for converted output
#line 3178
  */
#line 3178
  long i, j, ni;
#line 3178
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3178
  short *xp;
#line 3178
  int nrange = 0;         /* number of range errors */
#line 3178
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3178
  long cxp = (long) *((char**)xpp);
#line 3178

#line 3178
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3178
  /* sjl: manually stripmine so we can limit amount of
#line 3178
   * vector work space reserved to LOOPCNT elements. Also
#line 3178
   * makes vectorisation easy */
#line 3178
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3178
    ni=Min(nelems-j,LOOPCNT);
#line 3178
    if (realign) {
#line 3178
      xp = tmp;
#line 3178
    } else {
#line 3178
      xp = (short *) *xpp;
#line 3178
    }
#line 3178
   /* copy the next block */
#line 3178
#pragma cdir loopcnt=LOOPCNT
#line 3178
#pragma cdir shortloop
#line 3178
    for (i=0; i<ni; i++) {
#line 3178
      /* the normal case: */
#line 3178
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3178
     /* test for range errors (not always needed but do it anyway) */
#line 3178
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3178
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3178
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3178
    }
#line 3178
   /* copy workspace back if necessary */
#line 3178
    if (realign) {
#line 3178
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3178
      xp = (short *) *xpp;
#line 3178
    }
#line 3178
   /* update xpp and tp */
#line 3178
    xp += ni;
#line 3178
    tp += ni;
#line 3178
    *xpp = (void*)xp;
#line 3178
  }
#line 3178
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3178

#line 3178
#else   /* not SX */
#line 3178

#line 3178
	char *xp = (char *) *xpp;
#line 3178
	int status = NC_NOERR;
#line 3178

#line 3178
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3178
	{
#line 3178
		int lstatus = ncx_put_short_double(xp, tp, fillp);
#line 3178
		if (status == NC_NOERR) /* report the first encountered error */
#line 3178
			status = lstatus;
#line 3178
	}
#line 3178

#line 3178
	*xpp = (void *)xp;
#line 3178
	return status;
#line 3178
#endif
#line 3178
}
#line 3178

int
#line 3179
ncx_putn_short_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3179
{
#line 3179
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3179

#line 3179
 /* basic algorithm is:
#line 3179
  *   - ensure sane alignment of output data
#line 3179
  *   - copy (conversion happens automatically) input data
#line 3179
  *     to output
#line 3179
  *   - update tp to point at next unconverted input, and xpp to point
#line 3179
  *     at next location for converted output
#line 3179
  */
#line 3179
  long i, j, ni;
#line 3179
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3179
  short *xp;
#line 3179
  int nrange = 0;         /* number of range errors */
#line 3179
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3179
  long cxp = (long) *((char**)xpp);
#line 3179

#line 3179
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3179
  /* sjl: manually stripmine so we can limit amount of
#line 3179
   * vector work space reserved to LOOPCNT elements. Also
#line 3179
   * makes vectorisation easy */
#line 3179
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3179
    ni=Min(nelems-j,LOOPCNT);
#line 3179
    if (realign) {
#line 3179
      xp = tmp;
#line 3179
    } else {
#line 3179
      xp = (short *) *xpp;
#line 3179
    }
#line 3179
   /* copy the next block */
#line 3179
#pragma cdir loopcnt=LOOPCNT
#line 3179
#pragma cdir shortloop
#line 3179
    for (i=0; i<ni; i++) {
#line 3179
      /* the normal case: */
#line 3179
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3179
     /* test for range errors (not always needed but do it anyway) */
#line 3179
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3179
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3179
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3179
    }
#line 3179
   /* copy workspace back if necessary */
#line 3179
    if (realign) {
#line 3179
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3179
      xp = (short *) *xpp;
#line 3179
    }
#line 3179
   /* update xpp and tp */
#line 3179
    xp += ni;
#line 3179
    tp += ni;
#line 3179
    *xpp = (void*)xp;
#line 3179
  }
#line 3179
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3179

#line 3179
#else   /* not SX */
#line 3179

#line 3179
	char *xp = (char *) *xpp;
#line 3179
	int status = NC_NOERR;
#line 3179

#line 3179
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3179
	{
#line 3179
		int lstatus = ncx_put_short_longlong(xp, tp, fillp);
#line 3179
		if (status == NC_NOERR) /* report the first encountered error */
#line 3179
			status = lstatus;
#line 3179
	}
#line 3179

#line 3179
	*xpp = (void *)xp;
#line 3179
	return status;
#line 3179
#endif
#line 3179
}
#line 3179

int
#line 3180
ncx_putn_short_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3180
{
#line 3180
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3180

#line 3180
 /* basic algorithm is:
#line 3180
  *   - ensure sane alignment of output data
#line 3180
  *   - copy (conversion happens automatically) input data
#line 3180
  *     to output
#line 3180
  *   - update tp to point at next unconverted input, and xpp to point
#line 3180
  *     at next location for converted output
#line 3180
  */
#line 3180
  long i, j, ni;
#line 3180
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3180
  short *xp;
#line 3180
  int nrange = 0;         /* number of range errors */
#line 3180
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3180
  long cxp = (long) *((char**)xpp);
#line 3180

#line 3180
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3180
  /* sjl: manually stripmine so we can limit amount of
#line 3180
   * vector work space reserved to LOOPCNT elements. Also
#line 3180
   * makes vectorisation easy */
#line 3180
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3180
    ni=Min(nelems-j,LOOPCNT);
#line 3180
    if (realign) {
#line 3180
      xp = tmp;
#line 3180
    } else {
#line 3180
      xp = (short *) *xpp;
#line 3180
    }
#line 3180
   /* copy the next block */
#line 3180
#pragma cdir loopcnt=LOOPCNT
#line 3180
#pragma cdir shortloop
#line 3180
    for (i=0; i<ni; i++) {
#line 3180
      /* the normal case: */
#line 3180
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3180
     /* test for range errors (not always needed but do it anyway) */
#line 3180
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3180
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3180
      nrange += tp[i] > X_SHORT_MAX ;
#line 3180
    }
#line 3180
   /* copy workspace back if necessary */
#line 3180
    if (realign) {
#line 3180
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3180
      xp = (short *) *xpp;
#line 3180
    }
#line 3180
   /* update xpp and tp */
#line 3180
    xp += ni;
#line 3180
    tp += ni;
#line 3180
    *xpp = (void*)xp;
#line 3180
  }
#line 3180
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3180

#line 3180
#else   /* not SX */
#line 3180

#line 3180
	char *xp = (char *) *xpp;
#line 3180
	int status = NC_NOERR;
#line 3180

#line 3180
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3180
	{
#line 3180
		int lstatus = ncx_put_short_uchar(xp, tp, fillp);
#line 3180
		if (status == NC_NOERR) /* report the first encountered error */
#line 3180
			status = lstatus;
#line 3180
	}
#line 3180

#line 3180
	*xpp = (void *)xp;
#line 3180
	return status;
#line 3180
#endif
#line 3180
}
#line 3180

int
#line 3181
ncx_putn_short_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3181
{
#line 3181
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3181

#line 3181
 /* basic algorithm is:
#line 3181
  *   - ensure sane alignment of output data
#line 3181
  *   - copy (conversion happens automatically) input data
#line 3181
  *     to output
#line 3181
  *   - update tp to point at next unconverted input, and xpp to point
#line 3181
  *     at next location for converted output
#line 3181
  */
#line 3181
  long i, j, ni;
#line 3181
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3181
  short *xp;
#line 3181
  int nrange = 0;         /* number of range errors */
#line 3181
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3181
  long cxp = (long) *((char**)xpp);
#line 3181

#line 3181
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3181
  /* sjl: manually stripmine so we can limit amount of
#line 3181
   * vector work space reserved to LOOPCNT elements. Also
#line 3181
   * makes vectorisation easy */
#line 3181
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3181
    ni=Min(nelems-j,LOOPCNT);
#line 3181
    if (realign) {
#line 3181
      xp = tmp;
#line 3181
    } else {
#line 3181
      xp = (short *) *xpp;
#line 3181
    }
#line 3181
   /* copy the next block */
#line 3181
#pragma cdir loopcnt=LOOPCNT
#line 3181
#pragma cdir shortloop
#line 3181
    for (i=0; i<ni; i++) {
#line 3181
      /* the normal case: */
#line 3181
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3181
     /* test for range errors (not always needed but do it anyway) */
#line 3181
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3181
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3181
      nrange += tp[i] > X_SHORT_MAX ;
#line 3181
    }
#line 3181
   /* copy workspace back if necessary */
#line 3181
    if (realign) {
#line 3181
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3181
      xp = (short *) *xpp;
#line 3181
    }
#line 3181
   /* update xpp and tp */
#line 3181
    xp += ni;
#line 3181
    tp += ni;
#line 3181
    *xpp = (void*)xp;
#line 3181
  }
#line 3181
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3181

#line 3181
#else   /* not SX */
#line 3181

#line 3181
	char *xp = (char *) *xpp;
#line 3181
	int status = NC_NOERR;
#line 3181

#line 3181
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3181
	{
#line 3181
		int lstatus = ncx_put_short_uint(xp, tp, fillp);
#line 3181
		if (status == NC_NOERR) /* report the first encountered error */
#line 3181
			status = lstatus;
#line 3181
	}
#line 3181

#line 3181
	*xpp = (void *)xp;
#line 3181
	return status;
#line 3181
#endif
#line 3181
}
#line 3181

int
#line 3182
ncx_putn_short_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3182
{
#line 3182
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3182

#line 3182
 /* basic algorithm is:
#line 3182
  *   - ensure sane alignment of output data
#line 3182
  *   - copy (conversion happens automatically) input data
#line 3182
  *     to output
#line 3182
  *   - update tp to point at next unconverted input, and xpp to point
#line 3182
  *     at next location for converted output
#line 3182
  */
#line 3182
  long i, j, ni;
#line 3182
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3182
  short *xp;
#line 3182
  int nrange = 0;         /* number of range errors */
#line 3182
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3182
  long cxp = (long) *((char**)xpp);
#line 3182

#line 3182
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3182
  /* sjl: manually stripmine so we can limit amount of
#line 3182
   * vector work space reserved to LOOPCNT elements. Also
#line 3182
   * makes vectorisation easy */
#line 3182
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3182
    ni=Min(nelems-j,LOOPCNT);
#line 3182
    if (realign) {
#line 3182
      xp = tmp;
#line 3182
    } else {
#line 3182
      xp = (short *) *xpp;
#line 3182
    }
#line 3182
   /* copy the next block */
#line 3182
#pragma cdir loopcnt=LOOPCNT
#line 3182
#pragma cdir shortloop
#line 3182
    for (i=0; i<ni; i++) {
#line 3182
      /* the normal case: */
#line 3182
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3182
     /* test for range errors (not always needed but do it anyway) */
#line 3182
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3182
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3182
      nrange += tp[i] > X_SHORT_MAX ;
#line 3182
    }
#line 3182
   /* copy workspace back if necessary */
#line 3182
    if (realign) {
#line 3182
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3182
      xp = (short *) *xpp;
#line 3182
    }
#line 3182
   /* update xpp and tp */
#line 3182
    xp += ni;
#line 3182
    tp += ni;
#line 3182
    *xpp = (void*)xp;
#line 3182
  }
#line 3182
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3182

#line 3182
#else   /* not SX */
#line 3182

#line 3182
	char *xp = (char *) *xpp;
#line 3182
	int status = NC_NOERR;
#line 3182

#line 3182
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3182
	{
#line 3182
		int lstatus = ncx_put_short_ulonglong(xp, tp, fillp);
#line 3182
		if (status == NC_NOERR) /* report the first encountered error */
#line 3182
			status = lstatus;
#line 3182
	}
#line 3182

#line 3182
	*xpp = (void *)xp;
#line 3182
	return status;
#line 3182
#endif
#line 3182
}
#line 3182

int
#line 3183
ncx_putn_short_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3183
{
#line 3183
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3183

#line 3183
 /* basic algorithm is:
#line 3183
  *   - ensure sane alignment of output data
#line 3183
  *   - copy (conversion happens automatically) input data
#line 3183
  *     to output
#line 3183
  *   - update tp to point at next unconverted input, and xpp to point
#line 3183
  *     at next location for converted output
#line 3183
  */
#line 3183
  long i, j, ni;
#line 3183
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3183
  short *xp;
#line 3183
  int nrange = 0;         /* number of range errors */
#line 3183
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3183
  long cxp = (long) *((char**)xpp);
#line 3183

#line 3183
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3183
  /* sjl: manually stripmine so we can limit amount of
#line 3183
   * vector work space reserved to LOOPCNT elements. Also
#line 3183
   * makes vectorisation easy */
#line 3183
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3183
    ni=Min(nelems-j,LOOPCNT);
#line 3183
    if (realign) {
#line 3183
      xp = tmp;
#line 3183
    } else {
#line 3183
      xp = (short *) *xpp;
#line 3183
    }
#line 3183
   /* copy the next block */
#line 3183
#pragma cdir loopcnt=LOOPCNT
#line 3183
#pragma cdir shortloop
#line 3183
    for (i=0; i<ni; i++) {
#line 3183
      /* the normal case: */
#line 3183
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3183
     /* test for range errors (not always needed but do it anyway) */
#line 3183
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3183
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3183
      nrange += tp[i] > X_SHORT_MAX ;
#line 3183
    }
#line 3183
   /* copy workspace back if necessary */
#line 3183
    if (realign) {
#line 3183
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3183
      xp = (short *) *xpp;
#line 3183
    }
#line 3183
   /* update xpp and tp */
#line 3183
    xp += ni;
#line 3183
    tp += ni;
#line 3183
    *xpp = (void*)xp;
#line 3183
  }
#line 3183
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3183

#line 3183
#else   /* not SX */
#line 3183

#line 3183
	char *xp = (char *) *xpp;
#line 3183
	int status = NC_NOERR;
#line 3183

#line 3183
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3183
	{
#line 3183
		int lstatus = ncx_put_short_ushort(xp, tp, fillp);
#line 3183
		if (status == NC_NOERR) /* report the first encountered error */
#line 3183
			status = lstatus;
#line 3183
	}
#line 3183

#line 3183
	*xpp = (void *)xp;
#line 3183
	return status;
#line 3183
#endif
#line 3183
}
#line 3183


int
#line 3185
ncx_pad_putn_short_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3185
{
#line 3185
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3185

#line 3185
	char *xp = (char *) *xpp;
#line 3185
	int status = NC_NOERR;
#line 3185

#line 3185
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3185
	{
#line 3185
		int lstatus = ncx_put_short_schar(xp, tp, fillp);
#line 3185
		if (status == NC_NOERR) /* report the first encountered error */
#line 3185
			status = lstatus;
#line 3185
	}
#line 3185

#line 3185
	if (rndup != 0)
#line 3185
	{
#line 3185
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3185
		xp += X_SIZEOF_SHORT;
#line 3185
	}
#line 3185

#line 3185
	*xpp = (void *)xp;
#line 3185
	return status;
#line 3185
}
#line 3185

int
#line 3186
ncx_pad_putn_short_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3186
{
#line 3186
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3186

#line 3186
	char *xp = (char *) *xpp;
#line 3186
	int status = NC_NOERR;
#line 3186

#line 3186
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3186
	{
#line 3186
		int lstatus = ncx_put_short_uchar(xp, tp, fillp);
#line 3186
		if (status == NC_NOERR) /* report the first encountered error */
#line 3186
			status = lstatus;
#line 3186
	}
#line 3186

#line 3186
	if (rndup != 0)
#line 3186
	{
#line 3186
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3186
		xp += X_SIZEOF_SHORT;
#line 3186
	}
#line 3186

#line 3186
	*xpp = (void *)xp;
#line 3186
	return status;
#line 3186
}
#line 3186

int
#line 3187
ncx_pad_putn_short_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3187
{
#line 3187
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3187

#line 3187
	char *xp = (char *) *xpp;
#line 3187
	int status = NC_NOERR;
#line 3187

#line 3187
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3187
	{
#line 3187
		int lstatus = ncx_put_short_short(xp, tp, fillp);
#line 3187
		if (status == NC_NOERR) /* report the first encountered error */
#line 3187
			status = lstatus;
#line 3187
	}
#line 3187

#line 3187
	if (rndup != 0)
#line 3187
	{
#line 3187
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3187
		xp += X_SIZEOF_SHORT;
#line 3187
	}
#line 3187

#line 3187
	*xpp = (void *)xp;
#line 3187
	return status;
#line 3187
}
#line 3187

int
#line 3188
ncx_pad_putn_short_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3188
{
#line 3188
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3188

#line 3188
	char *xp = (char *) *xpp;
#line 3188
	int status = NC_NOERR;
#line 3188

#line 3188
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3188
	{
#line 3188
		int lstatus = ncx_put_short_int(xp, tp, fillp);
#line 3188
		if (status == NC_NOERR) /* report the first encountered error */
#line 3188
			status = lstatus;
#line 3188
	}
#line 3188

#line 3188
	if (rndup != 0)
#line 3188
	{
#line 3188
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3188
		xp += X_SIZEOF_SHORT;
#line 3188
	}
#line 3188

#line 3188
	*xpp = (void *)xp;
#line 3188
	return status;
#line 3188
}
#line 3188

int
#line 3189
ncx_pad_putn_short_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3189
{
#line 3189
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3189

#line 3189
	char *xp = (char *) *xpp;
#line 3189
	int status = NC_NOERR;
#line 3189

#line 3189
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3189
	{
#line 3189
		int lstatus = ncx_put_short_long(xp, tp, fillp);
#line 3189
		if (status == NC_NOERR) /* report the first encountered error */
#line 3189
			status = lstatus;
#line 3189
	}
#line 3189

#line 3189
	if (rndup != 0)
#line 3189
	{
#line 3189
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3189
		xp += X_SIZEOF_SHORT;
#line 3189
	}
#line 3189

#line 3189
	*xpp = (void *)xp;
#line 3189
	return status;
#line 3189
}
#line 3189

int
#line 3190
ncx_pad_putn_short_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3190
{
#line 3190
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3190

#line 3190
	char *xp = (char *) *xpp;
#line 3190
	int status = NC_NOERR;
#line 3190

#line 3190
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3190
	{
#line 3190
		int lstatus = ncx_put_short_float(xp, tp, fillp);
#line 3190
		if (status == NC_NOERR) /* report the first encountered error */
#line 3190
			status = lstatus;
#line 3190
	}
#line 3190

#line 3190
	if (rndup != 0)
#line 3190
	{
#line 3190
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3190
		xp += X_SIZEOF_SHORT;
#line 3190
	}
#line 3190

#line 3190
	*xpp = (void *)xp;
#line 3190
	return status;
#line 3190
}
#line 3190

int
#line 3191
ncx_pad_putn_short_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3191
{
#line 3191
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3191

#line 3191
	char *xp = (char *) *xpp;
#line 3191
	int status = NC_NOERR;
#line 3191

#line 3191
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3191
	{
#line 3191
		int lstatus = ncx_put_short_double(xp, tp, fillp);
#line 3191
		if (status == NC_NOERR) /* report the first encountered error */
#line 3191
			status = lstatus;
#line 3191
	}
#line 3191

#line 3191
	if (rndup != 0)
#line 3191
	{
#line 3191
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3191
		xp += X_SIZEOF_SHORT;
#line 3191
	}
#line 3191

#line 3191
	*xpp = (void *)xp;
#line 3191
	return status;
#line 3191
}
#line 3191

int
#line 3192
ncx_pad_putn_short_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3192
{
#line 3192
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3192

#line 3192
	char *xp = (char *) *xpp;
#line 3192
	int status = NC_NOERR;
#line 3192

#line 3192
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3192
	{
#line 3192
		int lstatus = ncx_put_short_uint(xp, tp, fillp);
#line 3192
		if (status == NC_NOERR) /* report the first encountered error */
#line 3192
			status = lstatus;
#line 3192
	}
#line 3192

#line 3192
	if (rndup != 0)
#line 3192
	{
#line 3192
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3192
		xp += X_SIZEOF_SHORT;
#line 3192
	}
#line 3192

#line 3192
	*xpp = (void *)xp;
#line 3192
	return status;
#line 3192
}
#line 3192

int
#line 3193
ncx_pad_putn_short_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3193
{
#line 3193
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3193

#line 3193
	char *xp = (char *) *xpp;
#line 3193
	int status = NC_NOERR;
#line 3193

#line 3193
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3193
	{
#line 3193
		int lstatus = ncx_put_short_longlong(xp, tp, fillp);
#line 3193
		if (status == NC_NOERR) /* report the first encountered error */
#line 3193
			status = lstatus;
#line 3193
	}
#line 3193

#line 3193
	if (rndup != 0)
#line 3193
	{
#line 3193
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3193
		xp += X_SIZEOF_SHORT;
#line 3193
	}
#line 3193

#line 3193
	*xpp = (void *)xp;
#line 3193
	return status;
#line 3193
}
#line 3193

int
#line 3194
ncx_pad_putn_short_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3194
{
#line 3194
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3194

#line 3194
	char *xp = (char *) *xpp;
#line 3194
	int status = NC_NOERR;
#line 3194

#line 3194
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3194
	{
#line 3194
		int lstatus = ncx_put_short_ulonglong(xp, tp, fillp);
#line 3194
		if (status == NC_NOERR) /* report the first encountered error */
#line 3194
			status = lstatus;
#line 3194
	}
#line 3194

#line 3194
	if (rndup != 0)
#line 3194
	{
#line 3194
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3194
		xp += X_SIZEOF_SHORT;
#line 3194
	}
#line 3194

#line 3194
	*xpp = (void *)xp;
#line 3194
	return status;
#line 3194
}
#line 3194

int
#line 3195
ncx_pad_putn_short_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3195
{
#line 3195
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3195

#line 3195
	char *xp = (char *) *xpp;
#line 3195
	int status = NC_NOERR;
#line 3195

#line 3195
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3195
	{
#line 3195
		int lstatus = ncx_put_short_ushort(xp, tp, fillp);
#line 3195
		if (status == NC_NOERR) /* report the first encountered error */
#line 3195
			status = lstatus;
#line 3195
	}
#line 3195

#line 3195
	if (rndup != 0)
#line 3195
	{
#line 3195
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3195
		xp += X_SIZEOF_SHORT;
#line 3195
	}
#line 3195

#line 3195
	*xpp = (void *)xp;
#line 3195
	return status;
#line 3195
}
#line 3195



/* ushort --------------------------------------------------------------------*/

#if X_SIZEOF_USHORT == SIZEOF_USHORT
/* optimized version */
int
ncx_getn_ushort_ushort(const void **xpp, size_t nelems, unsigned short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_USHORT);
# else
	swapn2b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_USHORT);
	return NC_NOERR;
}
#else
int
#line 3214
ncx_getn_ushort_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3214
{
#line 3214
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3214

#line 3214
 /* basic algorithm is:
#line 3214
  *   - ensure sane alignment of input data
#line 3214
  *   - copy (conversion happens automatically) input data
#line 3214
  *     to output
#line 3214
  *   - update xpp to point at next unconverted input, and tp to point
#line 3214
  *     at next location for converted output
#line 3214
  */
#line 3214
  long i, j, ni;
#line 3214
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3214
  ushort *xp;
#line 3214
  int nrange = 0;         /* number of range errors */
#line 3214
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3214
  long cxp = (long) *((char**)xpp);
#line 3214

#line 3214
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3214
  /* sjl: manually stripmine so we can limit amount of
#line 3214
   * vector work space reserved to LOOPCNT elements. Also
#line 3214
   * makes vectorisation easy */
#line 3214
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3214
    ni=Min(nelems-j,LOOPCNT);
#line 3214
    if (realign) {
#line 3214
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3214
      xp = tmp;
#line 3214
    } else {
#line 3214
      xp = (ushort *) *xpp;
#line 3214
    }
#line 3214
   /* copy the next block */
#line 3214
#pragma cdir loopcnt=LOOPCNT
#line 3214
#pragma cdir shortloop
#line 3214
    for (i=0; i<ni; i++) {
#line 3214
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3214
     /* test for range errors (not always needed but do it anyway) */
#line 3214
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3214
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3214
      nrange += xp[i] > USHORT_MAX ;
#line 3214
    }
#line 3214
   /* update xpp and tp */
#line 3214
    if (realign) xp = (ushort *) *xpp;
#line 3214
    xp += ni;
#line 3214
    tp += ni;
#line 3214
    *xpp = (void*)xp;
#line 3214
  }
#line 3214
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3214

#line 3214
#else   /* not SX */
#line 3214
	const char *xp = (const char *) *xpp;
#line 3214
	int status = NC_NOERR;
#line 3214

#line 3214
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3214
	{
#line 3214
		const int lstatus = ncx_get_ushort_ushort(xp, tp);
#line 3214
		if (status == NC_NOERR) /* report the first encountered error */
#line 3214
			status = lstatus;
#line 3214
	}
#line 3214

#line 3214
	*xpp = (const void *)xp;
#line 3214
	return status;
#line 3214
#endif
#line 3214
}
#line 3214

#endif
int
#line 3216
ncx_getn_ushort_schar(const void **xpp, size_t nelems, schar *tp)
#line 3216
{
#line 3216
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3216

#line 3216
 /* basic algorithm is:
#line 3216
  *   - ensure sane alignment of input data
#line 3216
  *   - copy (conversion happens automatically) input data
#line 3216
  *     to output
#line 3216
  *   - update xpp to point at next unconverted input, and tp to point
#line 3216
  *     at next location for converted output
#line 3216
  */
#line 3216
  long i, j, ni;
#line 3216
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3216
  ushort *xp;
#line 3216
  int nrange = 0;         /* number of range errors */
#line 3216
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3216
  long cxp = (long) *((char**)xpp);
#line 3216

#line 3216
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3216
  /* sjl: manually stripmine so we can limit amount of
#line 3216
   * vector work space reserved to LOOPCNT elements. Also
#line 3216
   * makes vectorisation easy */
#line 3216
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3216
    ni=Min(nelems-j,LOOPCNT);
#line 3216
    if (realign) {
#line 3216
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3216
      xp = tmp;
#line 3216
    } else {
#line 3216
      xp = (ushort *) *xpp;
#line 3216
    }
#line 3216
   /* copy the next block */
#line 3216
#pragma cdir loopcnt=LOOPCNT
#line 3216
#pragma cdir shortloop
#line 3216
    for (i=0; i<ni; i++) {
#line 3216
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3216
     /* test for range errors (not always needed but do it anyway) */
#line 3216
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3216
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3216
      nrange += xp[i] > SCHAR_MAX ;
#line 3216
    }
#line 3216
   /* update xpp and tp */
#line 3216
    if (realign) xp = (ushort *) *xpp;
#line 3216
    xp += ni;
#line 3216
    tp += ni;
#line 3216
    *xpp = (void*)xp;
#line 3216
  }
#line 3216
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3216

#line 3216
#else   /* not SX */
#line 3216
	const char *xp = (const char *) *xpp;
#line 3216
	int status = NC_NOERR;
#line 3216

#line 3216
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3216
	{
#line 3216
		const int lstatus = ncx_get_ushort_schar(xp, tp);
#line 3216
		if (status == NC_NOERR) /* report the first encountered error */
#line 3216
			status = lstatus;
#line 3216
	}
#line 3216

#line 3216
	*xpp = (const void *)xp;
#line 3216
	return status;
#line 3216
#endif
#line 3216
}
#line 3216

int
#line 3217
ncx_getn_ushort_short(const void **xpp, size_t nelems, short *tp)
#line 3217
{
#line 3217
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3217

#line 3217
 /* basic algorithm is:
#line 3217
  *   - ensure sane alignment of input data
#line 3217
  *   - copy (conversion happens automatically) input data
#line 3217
  *     to output
#line 3217
  *   - update xpp to point at next unconverted input, and tp to point
#line 3217
  *     at next location for converted output
#line 3217
  */
#line 3217
  long i, j, ni;
#line 3217
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3217
  ushort *xp;
#line 3217
  int nrange = 0;         /* number of range errors */
#line 3217
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3217
  long cxp = (long) *((char**)xpp);
#line 3217

#line 3217
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3217
  /* sjl: manually stripmine so we can limit amount of
#line 3217
   * vector work space reserved to LOOPCNT elements. Also
#line 3217
   * makes vectorisation easy */
#line 3217
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3217
    ni=Min(nelems-j,LOOPCNT);
#line 3217
    if (realign) {
#line 3217
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3217
      xp = tmp;
#line 3217
    } else {
#line 3217
      xp = (ushort *) *xpp;
#line 3217
    }
#line 3217
   /* copy the next block */
#line 3217
#pragma cdir loopcnt=LOOPCNT
#line 3217
#pragma cdir shortloop
#line 3217
    for (i=0; i<ni; i++) {
#line 3217
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3217
     /* test for range errors (not always needed but do it anyway) */
#line 3217
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3217
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3217
      nrange += xp[i] > SHORT_MAX ;
#line 3217
    }
#line 3217
   /* update xpp and tp */
#line 3217
    if (realign) xp = (ushort *) *xpp;
#line 3217
    xp += ni;
#line 3217
    tp += ni;
#line 3217
    *xpp = (void*)xp;
#line 3217
  }
#line 3217
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3217

#line 3217
#else   /* not SX */
#line 3217
	const char *xp = (const char *) *xpp;
#line 3217
	int status = NC_NOERR;
#line 3217

#line 3217
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3217
	{
#line 3217
		const int lstatus = ncx_get_ushort_short(xp, tp);
#line 3217
		if (status == NC_NOERR) /* report the first encountered error */
#line 3217
			status = lstatus;
#line 3217
	}
#line 3217

#line 3217
	*xpp = (const void *)xp;
#line 3217
	return status;
#line 3217
#endif
#line 3217
}
#line 3217

int
#line 3218
ncx_getn_ushort_int(const void **xpp, size_t nelems, int *tp)
#line 3218
{
#line 3218
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3218

#line 3218
 /* basic algorithm is:
#line 3218
  *   - ensure sane alignment of input data
#line 3218
  *   - copy (conversion happens automatically) input data
#line 3218
  *     to output
#line 3218
  *   - update xpp to point at next unconverted input, and tp to point
#line 3218
  *     at next location for converted output
#line 3218
  */
#line 3218
  long i, j, ni;
#line 3218
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3218
  ushort *xp;
#line 3218
  int nrange = 0;         /* number of range errors */
#line 3218
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3218
  long cxp = (long) *((char**)xpp);
#line 3218

#line 3218
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3218
  /* sjl: manually stripmine so we can limit amount of
#line 3218
   * vector work space reserved to LOOPCNT elements. Also
#line 3218
   * makes vectorisation easy */
#line 3218
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3218
    ni=Min(nelems-j,LOOPCNT);
#line 3218
    if (realign) {
#line 3218
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3218
      xp = tmp;
#line 3218
    } else {
#line 3218
      xp = (ushort *) *xpp;
#line 3218
    }
#line 3218
   /* copy the next block */
#line 3218
#pragma cdir loopcnt=LOOPCNT
#line 3218
#pragma cdir shortloop
#line 3218
    for (i=0; i<ni; i++) {
#line 3218
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3218
     /* test for range errors (not always needed but do it anyway) */
#line 3218
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3218
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3218
      nrange += xp[i] > INT_MAX ;
#line 3218
    }
#line 3218
   /* update xpp and tp */
#line 3218
    if (realign) xp = (ushort *) *xpp;
#line 3218
    xp += ni;
#line 3218
    tp += ni;
#line 3218
    *xpp = (void*)xp;
#line 3218
  }
#line 3218
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3218

#line 3218
#else   /* not SX */
#line 3218
	const char *xp = (const char *) *xpp;
#line 3218
	int status = NC_NOERR;
#line 3218

#line 3218
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3218
	{
#line 3218
		const int lstatus = ncx_get_ushort_int(xp, tp);
#line 3218
		if (status == NC_NOERR) /* report the first encountered error */
#line 3218
			status = lstatus;
#line 3218
	}
#line 3218

#line 3218
	*xpp = (const void *)xp;
#line 3218
	return status;
#line 3218
#endif
#line 3218
}
#line 3218

int
#line 3219
ncx_getn_ushort_long(const void **xpp, size_t nelems, long *tp)
#line 3219
{
#line 3219
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3219

#line 3219
 /* basic algorithm is:
#line 3219
  *   - ensure sane alignment of input data
#line 3219
  *   - copy (conversion happens automatically) input data
#line 3219
  *     to output
#line 3219
  *   - update xpp to point at next unconverted input, and tp to point
#line 3219
  *     at next location for converted output
#line 3219
  */
#line 3219
  long i, j, ni;
#line 3219
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3219
  ushort *xp;
#line 3219
  int nrange = 0;         /* number of range errors */
#line 3219
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3219
  long cxp = (long) *((char**)xpp);
#line 3219

#line 3219
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3219
  /* sjl: manually stripmine so we can limit amount of
#line 3219
   * vector work space reserved to LOOPCNT elements. Also
#line 3219
   * makes vectorisation easy */
#line 3219
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3219
    ni=Min(nelems-j,LOOPCNT);
#line 3219
    if (realign) {
#line 3219
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3219
      xp = tmp;
#line 3219
    } else {
#line 3219
      xp = (ushort *) *xpp;
#line 3219
    }
#line 3219
   /* copy the next block */
#line 3219
#pragma cdir loopcnt=LOOPCNT
#line 3219
#pragma cdir shortloop
#line 3219
    for (i=0; i<ni; i++) {
#line 3219
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3219
     /* test for range errors (not always needed but do it anyway) */
#line 3219
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3219
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3219
      nrange += xp[i] > LONG_MAX ;
#line 3219
    }
#line 3219
   /* update xpp and tp */
#line 3219
    if (realign) xp = (ushort *) *xpp;
#line 3219
    xp += ni;
#line 3219
    tp += ni;
#line 3219
    *xpp = (void*)xp;
#line 3219
  }
#line 3219
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3219

#line 3219
#else   /* not SX */
#line 3219
	const char *xp = (const char *) *xpp;
#line 3219
	int status = NC_NOERR;
#line 3219

#line 3219
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3219
	{
#line 3219
		const int lstatus = ncx_get_ushort_long(xp, tp);
#line 3219
		if (status == NC_NOERR) /* report the first encountered error */
#line 3219
			status = lstatus;
#line 3219
	}
#line 3219

#line 3219
	*xpp = (const void *)xp;
#line 3219
	return status;
#line 3219
#endif
#line 3219
}
#line 3219

int
#line 3220
ncx_getn_ushort_float(const void **xpp, size_t nelems, float *tp)
#line 3220
{
#line 3220
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3220

#line 3220
 /* basic algorithm is:
#line 3220
  *   - ensure sane alignment of input data
#line 3220
  *   - copy (conversion happens automatically) input data
#line 3220
  *     to output
#line 3220
  *   - update xpp to point at next unconverted input, and tp to point
#line 3220
  *     at next location for converted output
#line 3220
  */
#line 3220
  long i, j, ni;
#line 3220
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3220
  ushort *xp;
#line 3220
  int nrange = 0;         /* number of range errors */
#line 3220
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3220
  long cxp = (long) *((char**)xpp);
#line 3220

#line 3220
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3220
  /* sjl: manually stripmine so we can limit amount of
#line 3220
   * vector work space reserved to LOOPCNT elements. Also
#line 3220
   * makes vectorisation easy */
#line 3220
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3220
    ni=Min(nelems-j,LOOPCNT);
#line 3220
    if (realign) {
#line 3220
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3220
      xp = tmp;
#line 3220
    } else {
#line 3220
      xp = (ushort *) *xpp;
#line 3220
    }
#line 3220
   /* copy the next block */
#line 3220
#pragma cdir loopcnt=LOOPCNT
#line 3220
#pragma cdir shortloop
#line 3220
    for (i=0; i<ni; i++) {
#line 3220
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3220
     /* test for range errors (not always needed but do it anyway) */
#line 3220
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3220
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3220
      nrange += xp[i] > FLOAT_MAX ;
#line 3220
    }
#line 3220
   /* update xpp and tp */
#line 3220
    if (realign) xp = (ushort *) *xpp;
#line 3220
    xp += ni;
#line 3220
    tp += ni;
#line 3220
    *xpp = (void*)xp;
#line 3220
  }
#line 3220
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3220

#line 3220
#else   /* not SX */
#line 3220
	const char *xp = (const char *) *xpp;
#line 3220
	int status = NC_NOERR;
#line 3220

#line 3220
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3220
	{
#line 3220
		const int lstatus = ncx_get_ushort_float(xp, tp);
#line 3220
		if (status == NC_NOERR) /* report the first encountered error */
#line 3220
			status = lstatus;
#line 3220
	}
#line 3220

#line 3220
	*xpp = (const void *)xp;
#line 3220
	return status;
#line 3220
#endif
#line 3220
}
#line 3220

int
#line 3221
ncx_getn_ushort_double(const void **xpp, size_t nelems, double *tp)
#line 3221
{
#line 3221
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3221

#line 3221
 /* basic algorithm is:
#line 3221
  *   - ensure sane alignment of input data
#line 3221
  *   - copy (conversion happens automatically) input data
#line 3221
  *     to output
#line 3221
  *   - update xpp to point at next unconverted input, and tp to point
#line 3221
  *     at next location for converted output
#line 3221
  */
#line 3221
  long i, j, ni;
#line 3221
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3221
  ushort *xp;
#line 3221
  int nrange = 0;         /* number of range errors */
#line 3221
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3221
  long cxp = (long) *((char**)xpp);
#line 3221

#line 3221
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3221
  /* sjl: manually stripmine so we can limit amount of
#line 3221
   * vector work space reserved to LOOPCNT elements. Also
#line 3221
   * makes vectorisation easy */
#line 3221
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3221
    ni=Min(nelems-j,LOOPCNT);
#line 3221
    if (realign) {
#line 3221
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3221
      xp = tmp;
#line 3221
    } else {
#line 3221
      xp = (ushort *) *xpp;
#line 3221
    }
#line 3221
   /* copy the next block */
#line 3221
#pragma cdir loopcnt=LOOPCNT
#line 3221
#pragma cdir shortloop
#line 3221
    for (i=0; i<ni; i++) {
#line 3221
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3221
     /* test for range errors (not always needed but do it anyway) */
#line 3221
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3221
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3221
      nrange += xp[i] > DOUBLE_MAX ;
#line 3221
    }
#line 3221
   /* update xpp and tp */
#line 3221
    if (realign) xp = (ushort *) *xpp;
#line 3221
    xp += ni;
#line 3221
    tp += ni;
#line 3221
    *xpp = (void*)xp;
#line 3221
  }
#line 3221
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3221

#line 3221
#else   /* not SX */
#line 3221
	const char *xp = (const char *) *xpp;
#line 3221
	int status = NC_NOERR;
#line 3221

#line 3221
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3221
	{
#line 3221
		const int lstatus = ncx_get_ushort_double(xp, tp);
#line 3221
		if (status == NC_NOERR) /* report the first encountered error */
#line 3221
			status = lstatus;
#line 3221
	}
#line 3221

#line 3221
	*xpp = (const void *)xp;
#line 3221
	return status;
#line 3221
#endif
#line 3221
}
#line 3221

int
#line 3222
ncx_getn_ushort_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3222
{
#line 3222
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3222

#line 3222
 /* basic algorithm is:
#line 3222
  *   - ensure sane alignment of input data
#line 3222
  *   - copy (conversion happens automatically) input data
#line 3222
  *     to output
#line 3222
  *   - update xpp to point at next unconverted input, and tp to point
#line 3222
  *     at next location for converted output
#line 3222
  */
#line 3222
  long i, j, ni;
#line 3222
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3222
  ushort *xp;
#line 3222
  int nrange = 0;         /* number of range errors */
#line 3222
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3222
  long cxp = (long) *((char**)xpp);
#line 3222

#line 3222
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3222
  /* sjl: manually stripmine so we can limit amount of
#line 3222
   * vector work space reserved to LOOPCNT elements. Also
#line 3222
   * makes vectorisation easy */
#line 3222
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3222
    ni=Min(nelems-j,LOOPCNT);
#line 3222
    if (realign) {
#line 3222
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3222
      xp = tmp;
#line 3222
    } else {
#line 3222
      xp = (ushort *) *xpp;
#line 3222
    }
#line 3222
   /* copy the next block */
#line 3222
#pragma cdir loopcnt=LOOPCNT
#line 3222
#pragma cdir shortloop
#line 3222
    for (i=0; i<ni; i++) {
#line 3222
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3222
     /* test for range errors (not always needed but do it anyway) */
#line 3222
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3222
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3222
      nrange += xp[i] > LONGLONG_MAX ;
#line 3222
    }
#line 3222
   /* update xpp and tp */
#line 3222
    if (realign) xp = (ushort *) *xpp;
#line 3222
    xp += ni;
#line 3222
    tp += ni;
#line 3222
    *xpp = (void*)xp;
#line 3222
  }
#line 3222
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3222

#line 3222
#else   /* not SX */
#line 3222
	const char *xp = (const char *) *xpp;
#line 3222
	int status = NC_NOERR;
#line 3222

#line 3222
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3222
	{
#line 3222
		const int lstatus = ncx_get_ushort_longlong(xp, tp);
#line 3222
		if (status == NC_NOERR) /* report the first encountered error */
#line 3222
			status = lstatus;
#line 3222
	}
#line 3222

#line 3222
	*xpp = (const void *)xp;
#line 3222
	return status;
#line 3222
#endif
#line 3222
}
#line 3222

int
#line 3223
ncx_getn_ushort_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3223
{
#line 3223
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3223

#line 3223
 /* basic algorithm is:
#line 3223
  *   - ensure sane alignment of input data
#line 3223
  *   - copy (conversion happens automatically) input data
#line 3223
  *     to output
#line 3223
  *   - update xpp to point at next unconverted input, and tp to point
#line 3223
  *     at next location for converted output
#line 3223
  */
#line 3223
  long i, j, ni;
#line 3223
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3223
  ushort *xp;
#line 3223
  int nrange = 0;         /* number of range errors */
#line 3223
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3223
  long cxp = (long) *((char**)xpp);
#line 3223

#line 3223
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3223
  /* sjl: manually stripmine so we can limit amount of
#line 3223
   * vector work space reserved to LOOPCNT elements. Also
#line 3223
   * makes vectorisation easy */
#line 3223
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3223
    ni=Min(nelems-j,LOOPCNT);
#line 3223
    if (realign) {
#line 3223
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3223
      xp = tmp;
#line 3223
    } else {
#line 3223
      xp = (ushort *) *xpp;
#line 3223
    }
#line 3223
   /* copy the next block */
#line 3223
#pragma cdir loopcnt=LOOPCNT
#line 3223
#pragma cdir shortloop
#line 3223
    for (i=0; i<ni; i++) {
#line 3223
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3223
     /* test for range errors (not always needed but do it anyway) */
#line 3223
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3223
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3223
      nrange += xp[i] > UCHAR_MAX ;
#line 3223
    }
#line 3223
   /* update xpp and tp */
#line 3223
    if (realign) xp = (ushort *) *xpp;
#line 3223
    xp += ni;
#line 3223
    tp += ni;
#line 3223
    *xpp = (void*)xp;
#line 3223
  }
#line 3223
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3223

#line 3223
#else   /* not SX */
#line 3223
	const char *xp = (const char *) *xpp;
#line 3223
	int status = NC_NOERR;
#line 3223

#line 3223
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3223
	{
#line 3223
		const int lstatus = ncx_get_ushort_uchar(xp, tp);
#line 3223
		if (status == NC_NOERR) /* report the first encountered error */
#line 3223
			status = lstatus;
#line 3223
	}
#line 3223

#line 3223
	*xpp = (const void *)xp;
#line 3223
	return status;
#line 3223
#endif
#line 3223
}
#line 3223

int
#line 3224
ncx_getn_ushort_uint(const void **xpp, size_t nelems, uint *tp)
#line 3224
{
#line 3224
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3224

#line 3224
 /* basic algorithm is:
#line 3224
  *   - ensure sane alignment of input data
#line 3224
  *   - copy (conversion happens automatically) input data
#line 3224
  *     to output
#line 3224
  *   - update xpp to point at next unconverted input, and tp to point
#line 3224
  *     at next location for converted output
#line 3224
  */
#line 3224
  long i, j, ni;
#line 3224
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3224
  ushort *xp;
#line 3224
  int nrange = 0;         /* number of range errors */
#line 3224
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3224
  long cxp = (long) *((char**)xpp);
#line 3224

#line 3224
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3224
  /* sjl: manually stripmine so we can limit amount of
#line 3224
   * vector work space reserved to LOOPCNT elements. Also
#line 3224
   * makes vectorisation easy */
#line 3224
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3224
    ni=Min(nelems-j,LOOPCNT);
#line 3224
    if (realign) {
#line 3224
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3224
      xp = tmp;
#line 3224
    } else {
#line 3224
      xp = (ushort *) *xpp;
#line 3224
    }
#line 3224
   /* copy the next block */
#line 3224
#pragma cdir loopcnt=LOOPCNT
#line 3224
#pragma cdir shortloop
#line 3224
    for (i=0; i<ni; i++) {
#line 3224
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3224
     /* test for range errors (not always needed but do it anyway) */
#line 3224
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3224
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3224
      nrange += xp[i] > UINT_MAX ;
#line 3224
    }
#line 3224
   /* update xpp and tp */
#line 3224
    if (realign) xp = (ushort *) *xpp;
#line 3224
    xp += ni;
#line 3224
    tp += ni;
#line 3224
    *xpp = (void*)xp;
#line 3224
  }
#line 3224
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3224

#line 3224
#else   /* not SX */
#line 3224
	const char *xp = (const char *) *xpp;
#line 3224
	int status = NC_NOERR;
#line 3224

#line 3224
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3224
	{
#line 3224
		const int lstatus = ncx_get_ushort_uint(xp, tp);
#line 3224
		if (status == NC_NOERR) /* report the first encountered error */
#line 3224
			status = lstatus;
#line 3224
	}
#line 3224

#line 3224
	*xpp = (const void *)xp;
#line 3224
	return status;
#line 3224
#endif
#line 3224
}
#line 3224

int
#line 3225
ncx_getn_ushort_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3225
{
#line 3225
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3225

#line 3225
 /* basic algorithm is:
#line 3225
  *   - ensure sane alignment of input data
#line 3225
  *   - copy (conversion happens automatically) input data
#line 3225
  *     to output
#line 3225
  *   - update xpp to point at next unconverted input, and tp to point
#line 3225
  *     at next location for converted output
#line 3225
  */
#line 3225
  long i, j, ni;
#line 3225
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3225
  ushort *xp;
#line 3225
  int nrange = 0;         /* number of range errors */
#line 3225
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3225
  long cxp = (long) *((char**)xpp);
#line 3225

#line 3225
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3225
  /* sjl: manually stripmine so we can limit amount of
#line 3225
   * vector work space reserved to LOOPCNT elements. Also
#line 3225
   * makes vectorisation easy */
#line 3225
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3225
    ni=Min(nelems-j,LOOPCNT);
#line 3225
    if (realign) {
#line 3225
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3225
      xp = tmp;
#line 3225
    } else {
#line 3225
      xp = (ushort *) *xpp;
#line 3225
    }
#line 3225
   /* copy the next block */
#line 3225
#pragma cdir loopcnt=LOOPCNT
#line 3225
#pragma cdir shortloop
#line 3225
    for (i=0; i<ni; i++) {
#line 3225
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3225
     /* test for range errors (not always needed but do it anyway) */
#line 3225
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3225
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3225
      nrange += xp[i] > ULONGLONG_MAX ;
#line 3225
    }
#line 3225
   /* update xpp and tp */
#line 3225
    if (realign) xp = (ushort *) *xpp;
#line 3225
    xp += ni;
#line 3225
    tp += ni;
#line 3225
    *xpp = (void*)xp;
#line 3225
  }
#line 3225
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3225

#line 3225
#else   /* not SX */
#line 3225
	const char *xp = (const char *) *xpp;
#line 3225
	int status = NC_NOERR;
#line 3225

#line 3225
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3225
	{
#line 3225
		const int lstatus = ncx_get_ushort_ulonglong(xp, tp);
#line 3225
		if (status == NC_NOERR) /* report the first encountered error */
#line 3225
			status = lstatus;
#line 3225
	}
#line 3225

#line 3225
	*xpp = (const void *)xp;
#line 3225
	return status;
#line 3225
#endif
#line 3225
}
#line 3225


int
#line 3227
ncx_pad_getn_ushort_schar(const void **xpp, size_t nelems, schar *tp)
#line 3227
{
#line 3227
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3227

#line 3227
	const char *xp = (const char *) *xpp;
#line 3227
	int status = NC_NOERR;
#line 3227

#line 3227
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3227
	{
#line 3227
		const int lstatus = ncx_get_ushort_schar(xp, tp);
#line 3227
		if (status == NC_NOERR) /* report the first encountered error */
#line 3227
			status = lstatus;
#line 3227
	}
#line 3227

#line 3227
	if (rndup != 0)
#line 3227
		xp += X_SIZEOF_USHORT;
#line 3227

#line 3227
	*xpp = (void *)xp;
#line 3227
	return status;
#line 3227
}
#line 3227

int
#line 3228
ncx_pad_getn_ushort_short(const void **xpp, size_t nelems, short *tp)
#line 3228
{
#line 3228
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3228

#line 3228
	const char *xp = (const char *) *xpp;
#line 3228
	int status = NC_NOERR;
#line 3228

#line 3228
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3228
	{
#line 3228
		const int lstatus = ncx_get_ushort_short(xp, tp);
#line 3228
		if (status == NC_NOERR) /* report the first encountered error */
#line 3228
			status = lstatus;
#line 3228
	}
#line 3228

#line 3228
	if (rndup != 0)
#line 3228
		xp += X_SIZEOF_USHORT;
#line 3228

#line 3228
	*xpp = (void *)xp;
#line 3228
	return status;
#line 3228
}
#line 3228

int
#line 3229
ncx_pad_getn_ushort_int(const void **xpp, size_t nelems, int *tp)
#line 3229
{
#line 3229
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3229

#line 3229
	const char *xp = (const char *) *xpp;
#line 3229
	int status = NC_NOERR;
#line 3229

#line 3229
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3229
	{
#line 3229
		const int lstatus = ncx_get_ushort_int(xp, tp);
#line 3229
		if (status == NC_NOERR) /* report the first encountered error */
#line 3229
			status = lstatus;
#line 3229
	}
#line 3229

#line 3229
	if (rndup != 0)
#line 3229
		xp += X_SIZEOF_USHORT;
#line 3229

#line 3229
	*xpp = (void *)xp;
#line 3229
	return status;
#line 3229
}
#line 3229

int
#line 3230
ncx_pad_getn_ushort_long(const void **xpp, size_t nelems, long *tp)
#line 3230
{
#line 3230
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3230

#line 3230
	const char *xp = (const char *) *xpp;
#line 3230
	int status = NC_NOERR;
#line 3230

#line 3230
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3230
	{
#line 3230
		const int lstatus = ncx_get_ushort_long(xp, tp);
#line 3230
		if (status == NC_NOERR) /* report the first encountered error */
#line 3230
			status = lstatus;
#line 3230
	}
#line 3230

#line 3230
	if (rndup != 0)
#line 3230
		xp += X_SIZEOF_USHORT;
#line 3230

#line 3230
	*xpp = (void *)xp;
#line 3230
	return status;
#line 3230
}
#line 3230

int
#line 3231
ncx_pad_getn_ushort_float(const void **xpp, size_t nelems, float *tp)
#line 3231
{
#line 3231
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3231

#line 3231
	const char *xp = (const char *) *xpp;
#line 3231
	int status = NC_NOERR;
#line 3231

#line 3231
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3231
	{
#line 3231
		const int lstatus = ncx_get_ushort_float(xp, tp);
#line 3231
		if (status == NC_NOERR) /* report the first encountered error */
#line 3231
			status = lstatus;
#line 3231
	}
#line 3231

#line 3231
	if (rndup != 0)
#line 3231
		xp += X_SIZEOF_USHORT;
#line 3231

#line 3231
	*xpp = (void *)xp;
#line 3231
	return status;
#line 3231
}
#line 3231

int
#line 3232
ncx_pad_getn_ushort_double(const void **xpp, size_t nelems, double *tp)
#line 3232
{
#line 3232
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3232

#line 3232
	const char *xp = (const char *) *xpp;
#line 3232
	int status = NC_NOERR;
#line 3232

#line 3232
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3232
	{
#line 3232
		const int lstatus = ncx_get_ushort_double(xp, tp);
#line 3232
		if (status == NC_NOERR) /* report the first encountered error */
#line 3232
			status = lstatus;
#line 3232
	}
#line 3232

#line 3232
	if (rndup != 0)
#line 3232
		xp += X_SIZEOF_USHORT;
#line 3232

#line 3232
	*xpp = (void *)xp;
#line 3232
	return status;
#line 3232
}
#line 3232

int
#line 3233
ncx_pad_getn_ushort_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3233
{
#line 3233
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3233

#line 3233
	const char *xp = (const char *) *xpp;
#line 3233
	int status = NC_NOERR;
#line 3233

#line 3233
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3233
	{
#line 3233
		const int lstatus = ncx_get_ushort_uchar(xp, tp);
#line 3233
		if (status == NC_NOERR) /* report the first encountered error */
#line 3233
			status = lstatus;
#line 3233
	}
#line 3233

#line 3233
	if (rndup != 0)
#line 3233
		xp += X_SIZEOF_USHORT;
#line 3233

#line 3233
	*xpp = (void *)xp;
#line 3233
	return status;
#line 3233
}
#line 3233

int
#line 3234
ncx_pad_getn_ushort_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3234
{
#line 3234
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3234

#line 3234
	const char *xp = (const char *) *xpp;
#line 3234
	int status = NC_NOERR;
#line 3234

#line 3234
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3234
	{
#line 3234
		const int lstatus = ncx_get_ushort_ushort(xp, tp);
#line 3234
		if (status == NC_NOERR) /* report the first encountered error */
#line 3234
			status = lstatus;
#line 3234
	}
#line 3234

#line 3234
	if (rndup != 0)
#line 3234
		xp += X_SIZEOF_USHORT;
#line 3234

#line 3234
	*xpp = (void *)xp;
#line 3234
	return status;
#line 3234
}
#line 3234

int
#line 3235
ncx_pad_getn_ushort_uint(const void **xpp, size_t nelems, uint *tp)
#line 3235
{
#line 3235
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3235

#line 3235
	const char *xp = (const char *) *xpp;
#line 3235
	int status = NC_NOERR;
#line 3235

#line 3235
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3235
	{
#line 3235
		const int lstatus = ncx_get_ushort_uint(xp, tp);
#line 3235
		if (status == NC_NOERR) /* report the first encountered error */
#line 3235
			status = lstatus;
#line 3235
	}
#line 3235

#line 3235
	if (rndup != 0)
#line 3235
		xp += X_SIZEOF_USHORT;
#line 3235

#line 3235
	*xpp = (void *)xp;
#line 3235
	return status;
#line 3235
}
#line 3235

int
#line 3236
ncx_pad_getn_ushort_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3236
{
#line 3236
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3236

#line 3236
	const char *xp = (const char *) *xpp;
#line 3236
	int status = NC_NOERR;
#line 3236

#line 3236
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3236
	{
#line 3236
		const int lstatus = ncx_get_ushort_longlong(xp, tp);
#line 3236
		if (status == NC_NOERR) /* report the first encountered error */
#line 3236
			status = lstatus;
#line 3236
	}
#line 3236

#line 3236
	if (rndup != 0)
#line 3236
		xp += X_SIZEOF_USHORT;
#line 3236

#line 3236
	*xpp = (void *)xp;
#line 3236
	return status;
#line 3236
}
#line 3236

int
#line 3237
ncx_pad_getn_ushort_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3237
{
#line 3237
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3237

#line 3237
	const char *xp = (const char *) *xpp;
#line 3237
	int status = NC_NOERR;
#line 3237

#line 3237
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3237
	{
#line 3237
		const int lstatus = ncx_get_ushort_ulonglong(xp, tp);
#line 3237
		if (status == NC_NOERR) /* report the first encountered error */
#line 3237
			status = lstatus;
#line 3237
	}
#line 3237

#line 3237
	if (rndup != 0)
#line 3237
		xp += X_SIZEOF_USHORT;
#line 3237

#line 3237
	*xpp = (void *)xp;
#line 3237
	return status;
#line 3237
}
#line 3237


#if X_SIZEOF_USHORT == SIZEOF_USHORT
/* optimized version */
int
ncx_putn_ushort_ushort(void **xpp, size_t nelems, const unsigned short *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_USHORT);
# else
	swapn2b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_USHORT);
	return NC_NOERR;
}
#else
int
#line 3253
ncx_putn_ushort_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3253
{
#line 3253
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3253

#line 3253
 /* basic algorithm is:
#line 3253
  *   - ensure sane alignment of output data
#line 3253
  *   - copy (conversion happens automatically) input data
#line 3253
  *     to output
#line 3253
  *   - update tp to point at next unconverted input, and xpp to point
#line 3253
  *     at next location for converted output
#line 3253
  */
#line 3253
  long i, j, ni;
#line 3253
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3253
  ushort *xp;
#line 3253
  int nrange = 0;         /* number of range errors */
#line 3253
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3253
  long cxp = (long) *((char**)xpp);
#line 3253

#line 3253
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3253
  /* sjl: manually stripmine so we can limit amount of
#line 3253
   * vector work space reserved to LOOPCNT elements. Also
#line 3253
   * makes vectorisation easy */
#line 3253
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3253
    ni=Min(nelems-j,LOOPCNT);
#line 3253
    if (realign) {
#line 3253
      xp = tmp;
#line 3253
    } else {
#line 3253
      xp = (ushort *) *xpp;
#line 3253
    }
#line 3253
   /* copy the next block */
#line 3253
#pragma cdir loopcnt=LOOPCNT
#line 3253
#pragma cdir shortloop
#line 3253
    for (i=0; i<ni; i++) {
#line 3253
      /* the normal case: */
#line 3253
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3253
     /* test for range errors (not always needed but do it anyway) */
#line 3253
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3253
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3253
      nrange += tp[i] > X_USHORT_MAX ;
#line 3253
    }
#line 3253
   /* copy workspace back if necessary */
#line 3253
    if (realign) {
#line 3253
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3253
      xp = (ushort *) *xpp;
#line 3253
    }
#line 3253
   /* update xpp and tp */
#line 3253
    xp += ni;
#line 3253
    tp += ni;
#line 3253
    *xpp = (void*)xp;
#line 3253
  }
#line 3253
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3253

#line 3253
#else   /* not SX */
#line 3253

#line 3253
	char *xp = (char *) *xpp;
#line 3253
	int status = NC_NOERR;
#line 3253

#line 3253
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3253
	{
#line 3253
		int lstatus = ncx_put_ushort_ushort(xp, tp, fillp);
#line 3253
		if (status == NC_NOERR) /* report the first encountered error */
#line 3253
			status = lstatus;
#line 3253
	}
#line 3253

#line 3253
	*xpp = (void *)xp;
#line 3253
	return status;
#line 3253
#endif
#line 3253
}
#line 3253

#endif
int
#line 3255
ncx_putn_ushort_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3255
{
#line 3255
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3255

#line 3255
 /* basic algorithm is:
#line 3255
  *   - ensure sane alignment of output data
#line 3255
  *   - copy (conversion happens automatically) input data
#line 3255
  *     to output
#line 3255
  *   - update tp to point at next unconverted input, and xpp to point
#line 3255
  *     at next location for converted output
#line 3255
  */
#line 3255
  long i, j, ni;
#line 3255
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3255
  ushort *xp;
#line 3255
  int nrange = 0;         /* number of range errors */
#line 3255
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3255
  long cxp = (long) *((char**)xpp);
#line 3255

#line 3255
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3255
  /* sjl: manually stripmine so we can limit amount of
#line 3255
   * vector work space reserved to LOOPCNT elements. Also
#line 3255
   * makes vectorisation easy */
#line 3255
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3255
    ni=Min(nelems-j,LOOPCNT);
#line 3255
    if (realign) {
#line 3255
      xp = tmp;
#line 3255
    } else {
#line 3255
      xp = (ushort *) *xpp;
#line 3255
    }
#line 3255
   /* copy the next block */
#line 3255
#pragma cdir loopcnt=LOOPCNT
#line 3255
#pragma cdir shortloop
#line 3255
    for (i=0; i<ni; i++) {
#line 3255
      /* the normal case: */
#line 3255
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3255
     /* test for range errors (not always needed but do it anyway) */
#line 3255
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3255
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3255
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3255
    }
#line 3255
   /* copy workspace back if necessary */
#line 3255
    if (realign) {
#line 3255
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3255
      xp = (ushort *) *xpp;
#line 3255
    }
#line 3255
   /* update xpp and tp */
#line 3255
    xp += ni;
#line 3255
    tp += ni;
#line 3255
    *xpp = (void*)xp;
#line 3255
  }
#line 3255
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3255

#line 3255
#else   /* not SX */
#line 3255

#line 3255
	char *xp = (char *) *xpp;
#line 3255
	int status = NC_NOERR;
#line 3255

#line 3255
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3255
	{
#line 3255
		int lstatus = ncx_put_ushort_schar(xp, tp, fillp);
#line 3255
		if (status == NC_NOERR) /* report the first encountered error */
#line 3255
			status = lstatus;
#line 3255
	}
#line 3255

#line 3255
	*xpp = (void *)xp;
#line 3255
	return status;
#line 3255
#endif
#line 3255
}
#line 3255

int
#line 3256
ncx_putn_ushort_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3256
{
#line 3256
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3256

#line 3256
 /* basic algorithm is:
#line 3256
  *   - ensure sane alignment of output data
#line 3256
  *   - copy (conversion happens automatically) input data
#line 3256
  *     to output
#line 3256
  *   - update tp to point at next unconverted input, and xpp to point
#line 3256
  *     at next location for converted output
#line 3256
  */
#line 3256
  long i, j, ni;
#line 3256
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3256
  ushort *xp;
#line 3256
  int nrange = 0;         /* number of range errors */
#line 3256
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3256
  long cxp = (long) *((char**)xpp);
#line 3256

#line 3256
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3256
  /* sjl: manually stripmine so we can limit amount of
#line 3256
   * vector work space reserved to LOOPCNT elements. Also
#line 3256
   * makes vectorisation easy */
#line 3256
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3256
    ni=Min(nelems-j,LOOPCNT);
#line 3256
    if (realign) {
#line 3256
      xp = tmp;
#line 3256
    } else {
#line 3256
      xp = (ushort *) *xpp;
#line 3256
    }
#line 3256
   /* copy the next block */
#line 3256
#pragma cdir loopcnt=LOOPCNT
#line 3256
#pragma cdir shortloop
#line 3256
    for (i=0; i<ni; i++) {
#line 3256
      /* the normal case: */
#line 3256
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3256
     /* test for range errors (not always needed but do it anyway) */
#line 3256
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3256
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3256
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3256
    }
#line 3256
   /* copy workspace back if necessary */
#line 3256
    if (realign) {
#line 3256
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3256
      xp = (ushort *) *xpp;
#line 3256
    }
#line 3256
   /* update xpp and tp */
#line 3256
    xp += ni;
#line 3256
    tp += ni;
#line 3256
    *xpp = (void*)xp;
#line 3256
  }
#line 3256
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3256

#line 3256
#else   /* not SX */
#line 3256

#line 3256
	char *xp = (char *) *xpp;
#line 3256
	int status = NC_NOERR;
#line 3256

#line 3256
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3256
	{
#line 3256
		int lstatus = ncx_put_ushort_short(xp, tp, fillp);
#line 3256
		if (status == NC_NOERR) /* report the first encountered error */
#line 3256
			status = lstatus;
#line 3256
	}
#line 3256

#line 3256
	*xpp = (void *)xp;
#line 3256
	return status;
#line 3256
#endif
#line 3256
}
#line 3256

int
#line 3257
ncx_putn_ushort_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3257
{
#line 3257
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3257

#line 3257
 /* basic algorithm is:
#line 3257
  *   - ensure sane alignment of output data
#line 3257
  *   - copy (conversion happens automatically) input data
#line 3257
  *     to output
#line 3257
  *   - update tp to point at next unconverted input, and xpp to point
#line 3257
  *     at next location for converted output
#line 3257
  */
#line 3257
  long i, j, ni;
#line 3257
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3257
  ushort *xp;
#line 3257
  int nrange = 0;         /* number of range errors */
#line 3257
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3257
  long cxp = (long) *((char**)xpp);
#line 3257

#line 3257
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3257
  /* sjl: manually stripmine so we can limit amount of
#line 3257
   * vector work space reserved to LOOPCNT elements. Also
#line 3257
   * makes vectorisation easy */
#line 3257
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3257
    ni=Min(nelems-j,LOOPCNT);
#line 3257
    if (realign) {
#line 3257
      xp = tmp;
#line 3257
    } else {
#line 3257
      xp = (ushort *) *xpp;
#line 3257
    }
#line 3257
   /* copy the next block */
#line 3257
#pragma cdir loopcnt=LOOPCNT
#line 3257
#pragma cdir shortloop
#line 3257
    for (i=0; i<ni; i++) {
#line 3257
      /* the normal case: */
#line 3257
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3257
     /* test for range errors (not always needed but do it anyway) */
#line 3257
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3257
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3257
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3257
    }
#line 3257
   /* copy workspace back if necessary */
#line 3257
    if (realign) {
#line 3257
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3257
      xp = (ushort *) *xpp;
#line 3257
    }
#line 3257
   /* update xpp and tp */
#line 3257
    xp += ni;
#line 3257
    tp += ni;
#line 3257
    *xpp = (void*)xp;
#line 3257
  }
#line 3257
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3257

#line 3257
#else   /* not SX */
#line 3257

#line 3257
	char *xp = (char *) *xpp;
#line 3257
	int status = NC_NOERR;
#line 3257

#line 3257
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3257
	{
#line 3257
		int lstatus = ncx_put_ushort_int(xp, tp, fillp);
#line 3257
		if (status == NC_NOERR) /* report the first encountered error */
#line 3257
			status = lstatus;
#line 3257
	}
#line 3257

#line 3257
	*xpp = (void *)xp;
#line 3257
	return status;
#line 3257
#endif
#line 3257
}
#line 3257

int
#line 3258
ncx_putn_ushort_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3258
{
#line 3258
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3258

#line 3258
 /* basic algorithm is:
#line 3258
  *   - ensure sane alignment of output data
#line 3258
  *   - copy (conversion happens automatically) input data
#line 3258
  *     to output
#line 3258
  *   - update tp to point at next unconverted input, and xpp to point
#line 3258
  *     at next location for converted output
#line 3258
  */
#line 3258
  long i, j, ni;
#line 3258
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3258
  ushort *xp;
#line 3258
  int nrange = 0;         /* number of range errors */
#line 3258
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3258
  long cxp = (long) *((char**)xpp);
#line 3258

#line 3258
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3258
  /* sjl: manually stripmine so we can limit amount of
#line 3258
   * vector work space reserved to LOOPCNT elements. Also
#line 3258
   * makes vectorisation easy */
#line 3258
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3258
    ni=Min(nelems-j,LOOPCNT);
#line 3258
    if (realign) {
#line 3258
      xp = tmp;
#line 3258
    } else {
#line 3258
      xp = (ushort *) *xpp;
#line 3258
    }
#line 3258
   /* copy the next block */
#line 3258
#pragma cdir loopcnt=LOOPCNT
#line 3258
#pragma cdir shortloop
#line 3258
    for (i=0; i<ni; i++) {
#line 3258
      /* the normal case: */
#line 3258
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3258
     /* test for range errors (not always needed but do it anyway) */
#line 3258
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3258
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3258
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3258
    }
#line 3258
   /* copy workspace back if necessary */
#line 3258
    if (realign) {
#line 3258
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3258
      xp = (ushort *) *xpp;
#line 3258
    }
#line 3258
   /* update xpp and tp */
#line 3258
    xp += ni;
#line 3258
    tp += ni;
#line 3258
    *xpp = (void*)xp;
#line 3258
  }
#line 3258
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3258

#line 3258
#else   /* not SX */
#line 3258

#line 3258
	char *xp = (char *) *xpp;
#line 3258
	int status = NC_NOERR;
#line 3258

#line 3258
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3258
	{
#line 3258
		int lstatus = ncx_put_ushort_long(xp, tp, fillp);
#line 3258
		if (status == NC_NOERR) /* report the first encountered error */
#line 3258
			status = lstatus;
#line 3258
	}
#line 3258

#line 3258
	*xpp = (void *)xp;
#line 3258
	return status;
#line 3258
#endif
#line 3258
}
#line 3258

int
#line 3259
ncx_putn_ushort_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3259
{
#line 3259
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3259

#line 3259
 /* basic algorithm is:
#line 3259
  *   - ensure sane alignment of output data
#line 3259
  *   - copy (conversion happens automatically) input data
#line 3259
  *     to output
#line 3259
  *   - update tp to point at next unconverted input, and xpp to point
#line 3259
  *     at next location for converted output
#line 3259
  */
#line 3259
  long i, j, ni;
#line 3259
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3259
  ushort *xp;
#line 3259
  int nrange = 0;         /* number of range errors */
#line 3259
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3259
  long cxp = (long) *((char**)xpp);
#line 3259

#line 3259
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3259
  /* sjl: manually stripmine so we can limit amount of
#line 3259
   * vector work space reserved to LOOPCNT elements. Also
#line 3259
   * makes vectorisation easy */
#line 3259
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3259
    ni=Min(nelems-j,LOOPCNT);
#line 3259
    if (realign) {
#line 3259
      xp = tmp;
#line 3259
    } else {
#line 3259
      xp = (ushort *) *xpp;
#line 3259
    }
#line 3259
   /* copy the next block */
#line 3259
#pragma cdir loopcnt=LOOPCNT
#line 3259
#pragma cdir shortloop
#line 3259
    for (i=0; i<ni; i++) {
#line 3259
      /* the normal case: */
#line 3259
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3259
     /* test for range errors (not always needed but do it anyway) */
#line 3259
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3259
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3259
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3259
    }
#line 3259
   /* copy workspace back if necessary */
#line 3259
    if (realign) {
#line 3259
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3259
      xp = (ushort *) *xpp;
#line 3259
    }
#line 3259
   /* update xpp and tp */
#line 3259
    xp += ni;
#line 3259
    tp += ni;
#line 3259
    *xpp = (void*)xp;
#line 3259
  }
#line 3259
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3259

#line 3259
#else   /* not SX */
#line 3259

#line 3259
	char *xp = (char *) *xpp;
#line 3259
	int status = NC_NOERR;
#line 3259

#line 3259
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3259
	{
#line 3259
		int lstatus = ncx_put_ushort_float(xp, tp, fillp);
#line 3259
		if (status == NC_NOERR) /* report the first encountered error */
#line 3259
			status = lstatus;
#line 3259
	}
#line 3259

#line 3259
	*xpp = (void *)xp;
#line 3259
	return status;
#line 3259
#endif
#line 3259
}
#line 3259

int
#line 3260
ncx_putn_ushort_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3260
{
#line 3260
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3260

#line 3260
 /* basic algorithm is:
#line 3260
  *   - ensure sane alignment of output data
#line 3260
  *   - copy (conversion happens automatically) input data
#line 3260
  *     to output
#line 3260
  *   - update tp to point at next unconverted input, and xpp to point
#line 3260
  *     at next location for converted output
#line 3260
  */
#line 3260
  long i, j, ni;
#line 3260
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3260
  ushort *xp;
#line 3260
  int nrange = 0;         /* number of range errors */
#line 3260
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3260
  long cxp = (long) *((char**)xpp);
#line 3260

#line 3260
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3260
  /* sjl: manually stripmine so we can limit amount of
#line 3260
   * vector work space reserved to LOOPCNT elements. Also
#line 3260
   * makes vectorisation easy */
#line 3260
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3260
    ni=Min(nelems-j,LOOPCNT);
#line 3260
    if (realign) {
#line 3260
      xp = tmp;
#line 3260
    } else {
#line 3260
      xp = (ushort *) *xpp;
#line 3260
    }
#line 3260
   /* copy the next block */
#line 3260
#pragma cdir loopcnt=LOOPCNT
#line 3260
#pragma cdir shortloop
#line 3260
    for (i=0; i<ni; i++) {
#line 3260
      /* the normal case: */
#line 3260
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3260
     /* test for range errors (not always needed but do it anyway) */
#line 3260
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3260
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3260
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3260
    }
#line 3260
   /* copy workspace back if necessary */
#line 3260
    if (realign) {
#line 3260
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3260
      xp = (ushort *) *xpp;
#line 3260
    }
#line 3260
   /* update xpp and tp */
#line 3260
    xp += ni;
#line 3260
    tp += ni;
#line 3260
    *xpp = (void*)xp;
#line 3260
  }
#line 3260
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3260

#line 3260
#else   /* not SX */
#line 3260

#line 3260
	char *xp = (char *) *xpp;
#line 3260
	int status = NC_NOERR;
#line 3260

#line 3260
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3260
	{
#line 3260
		int lstatus = ncx_put_ushort_double(xp, tp, fillp);
#line 3260
		if (status == NC_NOERR) /* report the first encountered error */
#line 3260
			status = lstatus;
#line 3260
	}
#line 3260

#line 3260
	*xpp = (void *)xp;
#line 3260
	return status;
#line 3260
#endif
#line 3260
}
#line 3260

int
#line 3261
ncx_putn_ushort_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3261
{
#line 3261
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3261

#line 3261
 /* basic algorithm is:
#line 3261
  *   - ensure sane alignment of output data
#line 3261
  *   - copy (conversion happens automatically) input data
#line 3261
  *     to output
#line 3261
  *   - update tp to point at next unconverted input, and xpp to point
#line 3261
  *     at next location for converted output
#line 3261
  */
#line 3261
  long i, j, ni;
#line 3261
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3261
  ushort *xp;
#line 3261
  int nrange = 0;         /* number of range errors */
#line 3261
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3261
  long cxp = (long) *((char**)xpp);
#line 3261

#line 3261
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3261
  /* sjl: manually stripmine so we can limit amount of
#line 3261
   * vector work space reserved to LOOPCNT elements. Also
#line 3261
   * makes vectorisation easy */
#line 3261
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3261
    ni=Min(nelems-j,LOOPCNT);
#line 3261
    if (realign) {
#line 3261
      xp = tmp;
#line 3261
    } else {
#line 3261
      xp = (ushort *) *xpp;
#line 3261
    }
#line 3261
   /* copy the next block */
#line 3261
#pragma cdir loopcnt=LOOPCNT
#line 3261
#pragma cdir shortloop
#line 3261
    for (i=0; i<ni; i++) {
#line 3261
      /* the normal case: */
#line 3261
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3261
     /* test for range errors (not always needed but do it anyway) */
#line 3261
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3261
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3261
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3261
    }
#line 3261
   /* copy workspace back if necessary */
#line 3261
    if (realign) {
#line 3261
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3261
      xp = (ushort *) *xpp;
#line 3261
    }
#line 3261
   /* update xpp and tp */
#line 3261
    xp += ni;
#line 3261
    tp += ni;
#line 3261
    *xpp = (void*)xp;
#line 3261
  }
#line 3261
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3261

#line 3261
#else   /* not SX */
#line 3261

#line 3261
	char *xp = (char *) *xpp;
#line 3261
	int status = NC_NOERR;
#line 3261

#line 3261
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3261
	{
#line 3261
		int lstatus = ncx_put_ushort_longlong(xp, tp, fillp);
#line 3261
		if (status == NC_NOERR) /* report the first encountered error */
#line 3261
			status = lstatus;
#line 3261
	}
#line 3261

#line 3261
	*xpp = (void *)xp;
#line 3261
	return status;
#line 3261
#endif
#line 3261
}
#line 3261

int
#line 3262
ncx_putn_ushort_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3262
{
#line 3262
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3262

#line 3262
 /* basic algorithm is:
#line 3262
  *   - ensure sane alignment of output data
#line 3262
  *   - copy (conversion happens automatically) input data
#line 3262
  *     to output
#line 3262
  *   - update tp to point at next unconverted input, and xpp to point
#line 3262
  *     at next location for converted output
#line 3262
  */
#line 3262
  long i, j, ni;
#line 3262
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3262
  ushort *xp;
#line 3262
  int nrange = 0;         /* number of range errors */
#line 3262
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3262
  long cxp = (long) *((char**)xpp);
#line 3262

#line 3262
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3262
  /* sjl: manually stripmine so we can limit amount of
#line 3262
   * vector work space reserved to LOOPCNT elements. Also
#line 3262
   * makes vectorisation easy */
#line 3262
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3262
    ni=Min(nelems-j,LOOPCNT);
#line 3262
    if (realign) {
#line 3262
      xp = tmp;
#line 3262
    } else {
#line 3262
      xp = (ushort *) *xpp;
#line 3262
    }
#line 3262
   /* copy the next block */
#line 3262
#pragma cdir loopcnt=LOOPCNT
#line 3262
#pragma cdir shortloop
#line 3262
    for (i=0; i<ni; i++) {
#line 3262
      /* the normal case: */
#line 3262
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3262
     /* test for range errors (not always needed but do it anyway) */
#line 3262
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3262
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3262
      nrange += tp[i] > X_USHORT_MAX ;
#line 3262
    }
#line 3262
   /* copy workspace back if necessary */
#line 3262
    if (realign) {
#line 3262
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3262
      xp = (ushort *) *xpp;
#line 3262
    }
#line 3262
   /* update xpp and tp */
#line 3262
    xp += ni;
#line 3262
    tp += ni;
#line 3262
    *xpp = (void*)xp;
#line 3262
  }
#line 3262
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3262

#line 3262
#else   /* not SX */
#line 3262

#line 3262
	char *xp = (char *) *xpp;
#line 3262
	int status = NC_NOERR;
#line 3262

#line 3262
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3262
	{
#line 3262
		int lstatus = ncx_put_ushort_uchar(xp, tp, fillp);
#line 3262
		if (status == NC_NOERR) /* report the first encountered error */
#line 3262
			status = lstatus;
#line 3262
	}
#line 3262

#line 3262
	*xpp = (void *)xp;
#line 3262
	return status;
#line 3262
#endif
#line 3262
}
#line 3262

int
#line 3263
ncx_putn_ushort_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3263
{
#line 3263
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3263

#line 3263
 /* basic algorithm is:
#line 3263
  *   - ensure sane alignment of output data
#line 3263
  *   - copy (conversion happens automatically) input data
#line 3263
  *     to output
#line 3263
  *   - update tp to point at next unconverted input, and xpp to point
#line 3263
  *     at next location for converted output
#line 3263
  */
#line 3263
  long i, j, ni;
#line 3263
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3263
  ushort *xp;
#line 3263
  int nrange = 0;         /* number of range errors */
#line 3263
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3263
  long cxp = (long) *((char**)xpp);
#line 3263

#line 3263
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3263
  /* sjl: manually stripmine so we can limit amount of
#line 3263
   * vector work space reserved to LOOPCNT elements. Also
#line 3263
   * makes vectorisation easy */
#line 3263
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3263
    ni=Min(nelems-j,LOOPCNT);
#line 3263
    if (realign) {
#line 3263
      xp = tmp;
#line 3263
    } else {
#line 3263
      xp = (ushort *) *xpp;
#line 3263
    }
#line 3263
   /* copy the next block */
#line 3263
#pragma cdir loopcnt=LOOPCNT
#line 3263
#pragma cdir shortloop
#line 3263
    for (i=0; i<ni; i++) {
#line 3263
      /* the normal case: */
#line 3263
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3263
     /* test for range errors (not always needed but do it anyway) */
#line 3263
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3263
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3263
      nrange += tp[i] > X_USHORT_MAX ;
#line 3263
    }
#line 3263
   /* copy workspace back if necessary */
#line 3263
    if (realign) {
#line 3263
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3263
      xp = (ushort *) *xpp;
#line 3263
    }
#line 3263
   /* update xpp and tp */
#line 3263
    xp += ni;
#line 3263
    tp += ni;
#line 3263
    *xpp = (void*)xp;
#line 3263
  }
#line 3263
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3263

#line 3263
#else   /* not SX */
#line 3263

#line 3263
	char *xp = (char *) *xpp;
#line 3263
	int status = NC_NOERR;
#line 3263

#line 3263
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3263
	{
#line 3263
		int lstatus = ncx_put_ushort_uint(xp, tp, fillp);
#line 3263
		if (status == NC_NOERR) /* report the first encountered error */
#line 3263
			status = lstatus;
#line 3263
	}
#line 3263

#line 3263
	*xpp = (void *)xp;
#line 3263
	return status;
#line 3263
#endif
#line 3263
}
#line 3263

int
#line 3264
ncx_putn_ushort_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3264
{
#line 3264
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3264

#line 3264
 /* basic algorithm is:
#line 3264
  *   - ensure sane alignment of output data
#line 3264
  *   - copy (conversion happens automatically) input data
#line 3264
  *     to output
#line 3264
  *   - update tp to point at next unconverted input, and xpp to point
#line 3264
  *     at next location for converted output
#line 3264
  */
#line 3264
  long i, j, ni;
#line 3264
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3264
  ushort *xp;
#line 3264
  int nrange = 0;         /* number of range errors */
#line 3264
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3264
  long cxp = (long) *((char**)xpp);
#line 3264

#line 3264
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3264
  /* sjl: manually stripmine so we can limit amount of
#line 3264
   * vector work space reserved to LOOPCNT elements. Also
#line 3264
   * makes vectorisation easy */
#line 3264
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3264
    ni=Min(nelems-j,LOOPCNT);
#line 3264
    if (realign) {
#line 3264
      xp = tmp;
#line 3264
    } else {
#line 3264
      xp = (ushort *) *xpp;
#line 3264
    }
#line 3264
   /* copy the next block */
#line 3264
#pragma cdir loopcnt=LOOPCNT
#line 3264
#pragma cdir shortloop
#line 3264
    for (i=0; i<ni; i++) {
#line 3264
      /* the normal case: */
#line 3264
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3264
     /* test for range errors (not always needed but do it anyway) */
#line 3264
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3264
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3264
      nrange += tp[i] > X_USHORT_MAX ;
#line 3264
    }
#line 3264
   /* copy workspace back if necessary */
#line 3264
    if (realign) {
#line 3264
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3264
      xp = (ushort *) *xpp;
#line 3264
    }
#line 3264
   /* update xpp and tp */
#line 3264
    xp += ni;
#line 3264
    tp += ni;
#line 3264
    *xpp = (void*)xp;
#line 3264
  }
#line 3264
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3264

#line 3264
#else   /* not SX */
#line 3264

#line 3264
	char *xp = (char *) *xpp;
#line 3264
	int status = NC_NOERR;
#line 3264

#line 3264
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3264
	{
#line 3264
		int lstatus = ncx_put_ushort_ulonglong(xp, tp, fillp);
#line 3264
		if (status == NC_NOERR) /* report the first encountered error */
#line 3264
			status = lstatus;
#line 3264
	}
#line 3264

#line 3264
	*xpp = (void *)xp;
#line 3264
	return status;
#line 3264
#endif
#line 3264
}
#line 3264


int
#line 3266
ncx_pad_putn_ushort_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3266
{
#line 3266
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3266

#line 3266
	char *xp = (char *) *xpp;
#line 3266
	int status = NC_NOERR;
#line 3266

#line 3266
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3266
	{
#line 3266
		int lstatus = ncx_put_ushort_schar(xp, tp, fillp);
#line 3266
		if (status == NC_NOERR) /* report the first encountered error */
#line 3266
			status = lstatus;
#line 3266
	}
#line 3266

#line 3266
	if (rndup != 0)
#line 3266
	{
#line 3266
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3266
		xp += X_SIZEOF_USHORT;
#line 3266
	}
#line 3266

#line 3266
	*xpp = (void *)xp;
#line 3266
	return status;
#line 3266
}
#line 3266

int
#line 3267
ncx_pad_putn_ushort_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3267
{
#line 3267
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3267

#line 3267
	char *xp = (char *) *xpp;
#line 3267
	int status = NC_NOERR;
#line 3267

#line 3267
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3267
	{
#line 3267
		int lstatus = ncx_put_ushort_uchar(xp, tp, fillp);
#line 3267
		if (status == NC_NOERR) /* report the first encountered error */
#line 3267
			status = lstatus;
#line 3267
	}
#line 3267

#line 3267
	if (rndup != 0)
#line 3267
	{
#line 3267
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3267
		xp += X_SIZEOF_USHORT;
#line 3267
	}
#line 3267

#line 3267
	*xpp = (void *)xp;
#line 3267
	return status;
#line 3267
}
#line 3267

int
#line 3268
ncx_pad_putn_ushort_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3268
{
#line 3268
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3268

#line 3268
	char *xp = (char *) *xpp;
#line 3268
	int status = NC_NOERR;
#line 3268

#line 3268
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3268
	{
#line 3268
		int lstatus = ncx_put_ushort_short(xp, tp, fillp);
#line 3268
		if (status == NC_NOERR) /* report the first encountered error */
#line 3268
			status = lstatus;
#line 3268
	}
#line 3268

#line 3268
	if (rndup != 0)
#line 3268
	{
#line 3268
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3268
		xp += X_SIZEOF_USHORT;
#line 3268
	}
#line 3268

#line 3268
	*xpp = (void *)xp;
#line 3268
	return status;
#line 3268
}
#line 3268

int
#line 3269
ncx_pad_putn_ushort_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3269
{
#line 3269
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3269

#line 3269
	char *xp = (char *) *xpp;
#line 3269
	int status = NC_NOERR;
#line 3269

#line 3269
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3269
	{
#line 3269
		int lstatus = ncx_put_ushort_int(xp, tp, fillp);
#line 3269
		if (status == NC_NOERR) /* report the first encountered error */
#line 3269
			status = lstatus;
#line 3269
	}
#line 3269

#line 3269
	if (rndup != 0)
#line 3269
	{
#line 3269
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3269
		xp += X_SIZEOF_USHORT;
#line 3269
	}
#line 3269

#line 3269
	*xpp = (void *)xp;
#line 3269
	return status;
#line 3269
}
#line 3269

int
#line 3270
ncx_pad_putn_ushort_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3270
{
#line 3270
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3270

#line 3270
	char *xp = (char *) *xpp;
#line 3270
	int status = NC_NOERR;
#line 3270

#line 3270
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3270
	{
#line 3270
		int lstatus = ncx_put_ushort_long(xp, tp, fillp);
#line 3270
		if (status == NC_NOERR) /* report the first encountered error */
#line 3270
			status = lstatus;
#line 3270
	}
#line 3270

#line 3270
	if (rndup != 0)
#line 3270
	{
#line 3270
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3270
		xp += X_SIZEOF_USHORT;
#line 3270
	}
#line 3270

#line 3270
	*xpp = (void *)xp;
#line 3270
	return status;
#line 3270
}
#line 3270

int
#line 3271
ncx_pad_putn_ushort_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3271
{
#line 3271
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3271

#line 3271
	char *xp = (char *) *xpp;
#line 3271
	int status = NC_NOERR;
#line 3271

#line 3271
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3271
	{
#line 3271
		int lstatus = ncx_put_ushort_float(xp, tp, fillp);
#line 3271
		if (status == NC_NOERR) /* report the first encountered error */
#line 3271
			status = lstatus;
#line 3271
	}
#line 3271

#line 3271
	if (rndup != 0)
#line 3271
	{
#line 3271
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3271
		xp += X_SIZEOF_USHORT;
#line 3271
	}
#line 3271

#line 3271
	*xpp = (void *)xp;
#line 3271
	return status;
#line 3271
}
#line 3271

int
#line 3272
ncx_pad_putn_ushort_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3272
{
#line 3272
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3272

#line 3272
	char *xp = (char *) *xpp;
#line 3272
	int status = NC_NOERR;
#line 3272

#line 3272
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3272
	{
#line 3272
		int lstatus = ncx_put_ushort_double(xp, tp, fillp);
#line 3272
		if (status == NC_NOERR) /* report the first encountered error */
#line 3272
			status = lstatus;
#line 3272
	}
#line 3272

#line 3272
	if (rndup != 0)
#line 3272
	{
#line 3272
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3272
		xp += X_SIZEOF_USHORT;
#line 3272
	}
#line 3272

#line 3272
	*xpp = (void *)xp;
#line 3272
	return status;
#line 3272
}
#line 3272

int
#line 3273
ncx_pad_putn_ushort_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3273
{
#line 3273
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3273

#line 3273
	char *xp = (char *) *xpp;
#line 3273
	int status = NC_NOERR;
#line 3273

#line 3273
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3273
	{
#line 3273
		int lstatus = ncx_put_ushort_uint(xp, tp, fillp);
#line 3273
		if (status == NC_NOERR) /* report the first encountered error */
#line 3273
			status = lstatus;
#line 3273
	}
#line 3273

#line 3273
	if (rndup != 0)
#line 3273
	{
#line 3273
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3273
		xp += X_SIZEOF_USHORT;
#line 3273
	}
#line 3273

#line 3273
	*xpp = (void *)xp;
#line 3273
	return status;
#line 3273
}
#line 3273

int
#line 3274
ncx_pad_putn_ushort_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3274
{
#line 3274
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3274

#line 3274
	char *xp = (char *) *xpp;
#line 3274
	int status = NC_NOERR;
#line 3274

#line 3274
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3274
	{
#line 3274
		int lstatus = ncx_put_ushort_longlong(xp, tp, fillp);
#line 3274
		if (status == NC_NOERR) /* report the first encountered error */
#line 3274
			status = lstatus;
#line 3274
	}
#line 3274

#line 3274
	if (rndup != 0)
#line 3274
	{
#line 3274
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3274
		xp += X_SIZEOF_USHORT;
#line 3274
	}
#line 3274

#line 3274
	*xpp = (void *)xp;
#line 3274
	return status;
#line 3274
}
#line 3274

int
#line 3275
ncx_pad_putn_ushort_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3275
{
#line 3275
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3275

#line 3275
	char *xp = (char *) *xpp;
#line 3275
	int status = NC_NOERR;
#line 3275

#line 3275
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3275
	{
#line 3275
		int lstatus = ncx_put_ushort_ulonglong(xp, tp, fillp);
#line 3275
		if (status == NC_NOERR) /* report the first encountered error */
#line 3275
			status = lstatus;
#line 3275
	}
#line 3275

#line 3275
	if (rndup != 0)
#line 3275
	{
#line 3275
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3275
		xp += X_SIZEOF_USHORT;
#line 3275
	}
#line 3275

#line 3275
	*xpp = (void *)xp;
#line 3275
	return status;
#line 3275
}
#line 3275

int
#line 3276
ncx_pad_putn_ushort_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3276
{
#line 3276
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3276

#line 3276
	char *xp = (char *) *xpp;
#line 3276
	int status = NC_NOERR;
#line 3276

#line 3276
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3276
	{
#line 3276
		int lstatus = ncx_put_ushort_ushort(xp, tp, fillp);
#line 3276
		if (status == NC_NOERR) /* report the first encountered error */
#line 3276
			status = lstatus;
#line 3276
	}
#line 3276

#line 3276
	if (rndup != 0)
#line 3276
	{
#line 3276
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3276
		xp += X_SIZEOF_USHORT;
#line 3276
	}
#line 3276

#line 3276
	*xpp = (void *)xp;
#line 3276
	return status;
#line 3276
}
#line 3276



/* int -----------------------------------------------------------------------*/

#if X_SIZEOF_INT == SIZEOF_INT
/* optimized version */
int
ncx_getn_int_int(const void **xpp, size_t nelems, int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_INT);
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_INT);
	return NC_NOERR;
}
#else
int
#line 3295
ncx_getn_int_int(const void **xpp, size_t nelems, int *tp)
#line 3295
{
#line 3295
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3295

#line 3295
 /* basic algorithm is:
#line 3295
  *   - ensure sane alignment of input data
#line 3295
  *   - copy (conversion happens automatically) input data
#line 3295
  *     to output
#line 3295
  *   - update xpp to point at next unconverted input, and tp to point
#line 3295
  *     at next location for converted output
#line 3295
  */
#line 3295
  long i, j, ni;
#line 3295
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3295
  int *xp;
#line 3295
  int nrange = 0;         /* number of range errors */
#line 3295
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3295
  long cxp = (long) *((char**)xpp);
#line 3295

#line 3295
  realign = (cxp & 7) % SIZEOF_INT;
#line 3295
  /* sjl: manually stripmine so we can limit amount of
#line 3295
   * vector work space reserved to LOOPCNT elements. Also
#line 3295
   * makes vectorisation easy */
#line 3295
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3295
    ni=Min(nelems-j,LOOPCNT);
#line 3295
    if (realign) {
#line 3295
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3295
      xp = tmp;
#line 3295
    } else {
#line 3295
      xp = (int *) *xpp;
#line 3295
    }
#line 3295
   /* copy the next block */
#line 3295
#pragma cdir loopcnt=LOOPCNT
#line 3295
#pragma cdir shortloop
#line 3295
    for (i=0; i<ni; i++) {
#line 3295
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3295
     /* test for range errors (not always needed but do it anyway) */
#line 3295
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3295
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3295
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3295
    }
#line 3295
   /* update xpp and tp */
#line 3295
    if (realign) xp = (int *) *xpp;
#line 3295
    xp += ni;
#line 3295
    tp += ni;
#line 3295
    *xpp = (void*)xp;
#line 3295
  }
#line 3295
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3295

#line 3295
#else   /* not SX */
#line 3295
	const char *xp = (const char *) *xpp;
#line 3295
	int status = NC_NOERR;
#line 3295

#line 3295
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3295
	{
#line 3295
		const int lstatus = ncx_get_int_int(xp, tp);
#line 3295
		if (status == NC_NOERR) /* report the first encountered error */
#line 3295
			status = lstatus;
#line 3295
	}
#line 3295

#line 3295
	*xpp = (const void *)xp;
#line 3295
	return status;
#line 3295
#endif
#line 3295
}
#line 3295

#endif
int
#line 3297
ncx_getn_int_schar(const void **xpp, size_t nelems, schar *tp)
#line 3297
{
#line 3297
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3297

#line 3297
 /* basic algorithm is:
#line 3297
  *   - ensure sane alignment of input data
#line 3297
  *   - copy (conversion happens automatically) input data
#line 3297
  *     to output
#line 3297
  *   - update xpp to point at next unconverted input, and tp to point
#line 3297
  *     at next location for converted output
#line 3297
  */
#line 3297
  long i, j, ni;
#line 3297
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3297
  int *xp;
#line 3297
  int nrange = 0;         /* number of range errors */
#line 3297
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3297
  long cxp = (long) *((char**)xpp);
#line 3297

#line 3297
  realign = (cxp & 7) % SIZEOF_INT;
#line 3297
  /* sjl: manually stripmine so we can limit amount of
#line 3297
   * vector work space reserved to LOOPCNT elements. Also
#line 3297
   * makes vectorisation easy */
#line 3297
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3297
    ni=Min(nelems-j,LOOPCNT);
#line 3297
    if (realign) {
#line 3297
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3297
      xp = tmp;
#line 3297
    } else {
#line 3297
      xp = (int *) *xpp;
#line 3297
    }
#line 3297
   /* copy the next block */
#line 3297
#pragma cdir loopcnt=LOOPCNT
#line 3297
#pragma cdir shortloop
#line 3297
    for (i=0; i<ni; i++) {
#line 3297
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3297
     /* test for range errors (not always needed but do it anyway) */
#line 3297
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3297
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3297
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3297
    }
#line 3297
   /* update xpp and tp */
#line 3297
    if (realign) xp = (int *) *xpp;
#line 3297
    xp += ni;
#line 3297
    tp += ni;
#line 3297
    *xpp = (void*)xp;
#line 3297
  }
#line 3297
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3297

#line 3297
#else   /* not SX */
#line 3297
	const char *xp = (const char *) *xpp;
#line 3297
	int status = NC_NOERR;
#line 3297

#line 3297
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3297
	{
#line 3297
		const int lstatus = ncx_get_int_schar(xp, tp);
#line 3297
		if (status == NC_NOERR) /* report the first encountered error */
#line 3297
			status = lstatus;
#line 3297
	}
#line 3297

#line 3297
	*xpp = (const void *)xp;
#line 3297
	return status;
#line 3297
#endif
#line 3297
}
#line 3297

int
#line 3298
ncx_getn_int_short(const void **xpp, size_t nelems, short *tp)
#line 3298
{
#line 3298
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3298

#line 3298
 /* basic algorithm is:
#line 3298
  *   - ensure sane alignment of input data
#line 3298
  *   - copy (conversion happens automatically) input data
#line 3298
  *     to output
#line 3298
  *   - update xpp to point at next unconverted input, and tp to point
#line 3298
  *     at next location for converted output
#line 3298
  */
#line 3298
  long i, j, ni;
#line 3298
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3298
  int *xp;
#line 3298
  int nrange = 0;         /* number of range errors */
#line 3298
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3298
  long cxp = (long) *((char**)xpp);
#line 3298

#line 3298
  realign = (cxp & 7) % SIZEOF_INT;
#line 3298
  /* sjl: manually stripmine so we can limit amount of
#line 3298
   * vector work space reserved to LOOPCNT elements. Also
#line 3298
   * makes vectorisation easy */
#line 3298
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3298
    ni=Min(nelems-j,LOOPCNT);
#line 3298
    if (realign) {
#line 3298
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3298
      xp = tmp;
#line 3298
    } else {
#line 3298
      xp = (int *) *xpp;
#line 3298
    }
#line 3298
   /* copy the next block */
#line 3298
#pragma cdir loopcnt=LOOPCNT
#line 3298
#pragma cdir shortloop
#line 3298
    for (i=0; i<ni; i++) {
#line 3298
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3298
     /* test for range errors (not always needed but do it anyway) */
#line 3298
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3298
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3298
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3298
    }
#line 3298
   /* update xpp and tp */
#line 3298
    if (realign) xp = (int *) *xpp;
#line 3298
    xp += ni;
#line 3298
    tp += ni;
#line 3298
    *xpp = (void*)xp;
#line 3298
  }
#line 3298
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3298

#line 3298
#else   /* not SX */
#line 3298
	const char *xp = (const char *) *xpp;
#line 3298
	int status = NC_NOERR;
#line 3298

#line 3298
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3298
	{
#line 3298
		const int lstatus = ncx_get_int_short(xp, tp);
#line 3298
		if (status == NC_NOERR) /* report the first encountered error */
#line 3298
			status = lstatus;
#line 3298
	}
#line 3298

#line 3298
	*xpp = (const void *)xp;
#line 3298
	return status;
#line 3298
#endif
#line 3298
}
#line 3298

int
#line 3299
ncx_getn_int_long(const void **xpp, size_t nelems, long *tp)
#line 3299
{
#line 3299
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3299

#line 3299
 /* basic algorithm is:
#line 3299
  *   - ensure sane alignment of input data
#line 3299
  *   - copy (conversion happens automatically) input data
#line 3299
  *     to output
#line 3299
  *   - update xpp to point at next unconverted input, and tp to point
#line 3299
  *     at next location for converted output
#line 3299
  */
#line 3299
  long i, j, ni;
#line 3299
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3299
  int *xp;
#line 3299
  int nrange = 0;         /* number of range errors */
#line 3299
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3299
  long cxp = (long) *((char**)xpp);
#line 3299

#line 3299
  realign = (cxp & 7) % SIZEOF_INT;
#line 3299
  /* sjl: manually stripmine so we can limit amount of
#line 3299
   * vector work space reserved to LOOPCNT elements. Also
#line 3299
   * makes vectorisation easy */
#line 3299
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3299
    ni=Min(nelems-j,LOOPCNT);
#line 3299
    if (realign) {
#line 3299
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3299
      xp = tmp;
#line 3299
    } else {
#line 3299
      xp = (int *) *xpp;
#line 3299
    }
#line 3299
   /* copy the next block */
#line 3299
#pragma cdir loopcnt=LOOPCNT
#line 3299
#pragma cdir shortloop
#line 3299
    for (i=0; i<ni; i++) {
#line 3299
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3299
     /* test for range errors (not always needed but do it anyway) */
#line 3299
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3299
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3299
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3299
    }
#line 3299
   /* update xpp and tp */
#line 3299
    if (realign) xp = (int *) *xpp;
#line 3299
    xp += ni;
#line 3299
    tp += ni;
#line 3299
    *xpp = (void*)xp;
#line 3299
  }
#line 3299
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3299

#line 3299
#else   /* not SX */
#line 3299
	const char *xp = (const char *) *xpp;
#line 3299
	int status = NC_NOERR;
#line 3299

#line 3299
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3299
	{
#line 3299
		const int lstatus = ncx_get_int_long(xp, tp);
#line 3299
		if (status == NC_NOERR) /* report the first encountered error */
#line 3299
			status = lstatus;
#line 3299
	}
#line 3299

#line 3299
	*xpp = (const void *)xp;
#line 3299
	return status;
#line 3299
#endif
#line 3299
}
#line 3299

int
#line 3300
ncx_getn_int_float(const void **xpp, size_t nelems, float *tp)
#line 3300
{
#line 3300
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3300

#line 3300
 /* basic algorithm is:
#line 3300
  *   - ensure sane alignment of input data
#line 3300
  *   - copy (conversion happens automatically) input data
#line 3300
  *     to output
#line 3300
  *   - update xpp to point at next unconverted input, and tp to point
#line 3300
  *     at next location for converted output
#line 3300
  */
#line 3300
  long i, j, ni;
#line 3300
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3300
  int *xp;
#line 3300
  int nrange = 0;         /* number of range errors */
#line 3300
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3300
  long cxp = (long) *((char**)xpp);
#line 3300

#line 3300
  realign = (cxp & 7) % SIZEOF_INT;
#line 3300
  /* sjl: manually stripmine so we can limit amount of
#line 3300
   * vector work space reserved to LOOPCNT elements. Also
#line 3300
   * makes vectorisation easy */
#line 3300
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3300
    ni=Min(nelems-j,LOOPCNT);
#line 3300
    if (realign) {
#line 3300
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3300
      xp = tmp;
#line 3300
    } else {
#line 3300
      xp = (int *) *xpp;
#line 3300
    }
#line 3300
   /* copy the next block */
#line 3300
#pragma cdir loopcnt=LOOPCNT
#line 3300
#pragma cdir shortloop
#line 3300
    for (i=0; i<ni; i++) {
#line 3300
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3300
     /* test for range errors (not always needed but do it anyway) */
#line 3300
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3300
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3300
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3300
    }
#line 3300
   /* update xpp and tp */
#line 3300
    if (realign) xp = (int *) *xpp;
#line 3300
    xp += ni;
#line 3300
    tp += ni;
#line 3300
    *xpp = (void*)xp;
#line 3300
  }
#line 3300
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3300

#line 3300
#else   /* not SX */
#line 3300
	const char *xp = (const char *) *xpp;
#line 3300
	int status = NC_NOERR;
#line 3300

#line 3300
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3300
	{
#line 3300
		const int lstatus = ncx_get_int_float(xp, tp);
#line 3300
		if (status == NC_NOERR) /* report the first encountered error */
#line 3300
			status = lstatus;
#line 3300
	}
#line 3300

#line 3300
	*xpp = (const void *)xp;
#line 3300
	return status;
#line 3300
#endif
#line 3300
}
#line 3300

int
#line 3301
ncx_getn_int_double(const void **xpp, size_t nelems, double *tp)
#line 3301
{
#line 3301
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3301

#line 3301
 /* basic algorithm is:
#line 3301
  *   - ensure sane alignment of input data
#line 3301
  *   - copy (conversion happens automatically) input data
#line 3301
  *     to output
#line 3301
  *   - update xpp to point at next unconverted input, and tp to point
#line 3301
  *     at next location for converted output
#line 3301
  */
#line 3301
  long i, j, ni;
#line 3301
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3301
  int *xp;
#line 3301
  int nrange = 0;         /* number of range errors */
#line 3301
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3301
  long cxp = (long) *((char**)xpp);
#line 3301

#line 3301
  realign = (cxp & 7) % SIZEOF_INT;
#line 3301
  /* sjl: manually stripmine so we can limit amount of
#line 3301
   * vector work space reserved to LOOPCNT elements. Also
#line 3301
   * makes vectorisation easy */
#line 3301
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3301
    ni=Min(nelems-j,LOOPCNT);
#line 3301
    if (realign) {
#line 3301
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3301
      xp = tmp;
#line 3301
    } else {
#line 3301
      xp = (int *) *xpp;
#line 3301
    }
#line 3301
   /* copy the next block */
#line 3301
#pragma cdir loopcnt=LOOPCNT
#line 3301
#pragma cdir shortloop
#line 3301
    for (i=0; i<ni; i++) {
#line 3301
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3301
     /* test for range errors (not always needed but do it anyway) */
#line 3301
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3301
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3301
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3301
    }
#line 3301
   /* update xpp and tp */
#line 3301
    if (realign) xp = (int *) *xpp;
#line 3301
    xp += ni;
#line 3301
    tp += ni;
#line 3301
    *xpp = (void*)xp;
#line 3301
  }
#line 3301
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3301

#line 3301
#else   /* not SX */
#line 3301
	const char *xp = (const char *) *xpp;
#line 3301
	int status = NC_NOERR;
#line 3301

#line 3301
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3301
	{
#line 3301
		const int lstatus = ncx_get_int_double(xp, tp);
#line 3301
		if (status == NC_NOERR) /* report the first encountered error */
#line 3301
			status = lstatus;
#line 3301
	}
#line 3301

#line 3301
	*xpp = (const void *)xp;
#line 3301
	return status;
#line 3301
#endif
#line 3301
}
#line 3301

int
#line 3302
ncx_getn_int_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3302
{
#line 3302
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3302

#line 3302
 /* basic algorithm is:
#line 3302
  *   - ensure sane alignment of input data
#line 3302
  *   - copy (conversion happens automatically) input data
#line 3302
  *     to output
#line 3302
  *   - update xpp to point at next unconverted input, and tp to point
#line 3302
  *     at next location for converted output
#line 3302
  */
#line 3302
  long i, j, ni;
#line 3302
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3302
  int *xp;
#line 3302
  int nrange = 0;         /* number of range errors */
#line 3302
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3302
  long cxp = (long) *((char**)xpp);
#line 3302

#line 3302
  realign = (cxp & 7) % SIZEOF_INT;
#line 3302
  /* sjl: manually stripmine so we can limit amount of
#line 3302
   * vector work space reserved to LOOPCNT elements. Also
#line 3302
   * makes vectorisation easy */
#line 3302
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3302
    ni=Min(nelems-j,LOOPCNT);
#line 3302
    if (realign) {
#line 3302
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3302
      xp = tmp;
#line 3302
    } else {
#line 3302
      xp = (int *) *xpp;
#line 3302
    }
#line 3302
   /* copy the next block */
#line 3302
#pragma cdir loopcnt=LOOPCNT
#line 3302
#pragma cdir shortloop
#line 3302
    for (i=0; i<ni; i++) {
#line 3302
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3302
     /* test for range errors (not always needed but do it anyway) */
#line 3302
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3302
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3302
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3302
    }
#line 3302
   /* update xpp and tp */
#line 3302
    if (realign) xp = (int *) *xpp;
#line 3302
    xp += ni;
#line 3302
    tp += ni;
#line 3302
    *xpp = (void*)xp;
#line 3302
  }
#line 3302
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3302

#line 3302
#else   /* not SX */
#line 3302
	const char *xp = (const char *) *xpp;
#line 3302
	int status = NC_NOERR;
#line 3302

#line 3302
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3302
	{
#line 3302
		const int lstatus = ncx_get_int_longlong(xp, tp);
#line 3302
		if (status == NC_NOERR) /* report the first encountered error */
#line 3302
			status = lstatus;
#line 3302
	}
#line 3302

#line 3302
	*xpp = (const void *)xp;
#line 3302
	return status;
#line 3302
#endif
#line 3302
}
#line 3302

int
#line 3303
ncx_getn_int_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3303
{
#line 3303
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3303

#line 3303
 /* basic algorithm is:
#line 3303
  *   - ensure sane alignment of input data
#line 3303
  *   - copy (conversion happens automatically) input data
#line 3303
  *     to output
#line 3303
  *   - update xpp to point at next unconverted input, and tp to point
#line 3303
  *     at next location for converted output
#line 3303
  */
#line 3303
  long i, j, ni;
#line 3303
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3303
  int *xp;
#line 3303
  int nrange = 0;         /* number of range errors */
#line 3303
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3303
  long cxp = (long) *((char**)xpp);
#line 3303

#line 3303
  realign = (cxp & 7) % SIZEOF_INT;
#line 3303
  /* sjl: manually stripmine so we can limit amount of
#line 3303
   * vector work space reserved to LOOPCNT elements. Also
#line 3303
   * makes vectorisation easy */
#line 3303
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3303
    ni=Min(nelems-j,LOOPCNT);
#line 3303
    if (realign) {
#line 3303
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3303
      xp = tmp;
#line 3303
    } else {
#line 3303
      xp = (int *) *xpp;
#line 3303
    }
#line 3303
   /* copy the next block */
#line 3303
#pragma cdir loopcnt=LOOPCNT
#line 3303
#pragma cdir shortloop
#line 3303
    for (i=0; i<ni; i++) {
#line 3303
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3303
     /* test for range errors (not always needed but do it anyway) */
#line 3303
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3303
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3303
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3303
    }
#line 3303
   /* update xpp and tp */
#line 3303
    if (realign) xp = (int *) *xpp;
#line 3303
    xp += ni;
#line 3303
    tp += ni;
#line 3303
    *xpp = (void*)xp;
#line 3303
  }
#line 3303
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3303

#line 3303
#else   /* not SX */
#line 3303
	const char *xp = (const char *) *xpp;
#line 3303
	int status = NC_NOERR;
#line 3303

#line 3303
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3303
	{
#line 3303
		const int lstatus = ncx_get_int_uchar(xp, tp);
#line 3303
		if (status == NC_NOERR) /* report the first encountered error */
#line 3303
			status = lstatus;
#line 3303
	}
#line 3303

#line 3303
	*xpp = (const void *)xp;
#line 3303
	return status;
#line 3303
#endif
#line 3303
}
#line 3303

int
#line 3304
ncx_getn_int_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3304
{
#line 3304
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3304

#line 3304
 /* basic algorithm is:
#line 3304
  *   - ensure sane alignment of input data
#line 3304
  *   - copy (conversion happens automatically) input data
#line 3304
  *     to output
#line 3304
  *   - update xpp to point at next unconverted input, and tp to point
#line 3304
  *     at next location for converted output
#line 3304
  */
#line 3304
  long i, j, ni;
#line 3304
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3304
  int *xp;
#line 3304
  int nrange = 0;         /* number of range errors */
#line 3304
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3304
  long cxp = (long) *((char**)xpp);
#line 3304

#line 3304
  realign = (cxp & 7) % SIZEOF_INT;
#line 3304
  /* sjl: manually stripmine so we can limit amount of
#line 3304
   * vector work space reserved to LOOPCNT elements. Also
#line 3304
   * makes vectorisation easy */
#line 3304
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3304
    ni=Min(nelems-j,LOOPCNT);
#line 3304
    if (realign) {
#line 3304
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3304
      xp = tmp;
#line 3304
    } else {
#line 3304
      xp = (int *) *xpp;
#line 3304
    }
#line 3304
   /* copy the next block */
#line 3304
#pragma cdir loopcnt=LOOPCNT
#line 3304
#pragma cdir shortloop
#line 3304
    for (i=0; i<ni; i++) {
#line 3304
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3304
     /* test for range errors (not always needed but do it anyway) */
#line 3304
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3304
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3304
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3304
    }
#line 3304
   /* update xpp and tp */
#line 3304
    if (realign) xp = (int *) *xpp;
#line 3304
    xp += ni;
#line 3304
    tp += ni;
#line 3304
    *xpp = (void*)xp;
#line 3304
  }
#line 3304
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3304

#line 3304
#else   /* not SX */
#line 3304
	const char *xp = (const char *) *xpp;
#line 3304
	int status = NC_NOERR;
#line 3304

#line 3304
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3304
	{
#line 3304
		const int lstatus = ncx_get_int_ushort(xp, tp);
#line 3304
		if (status == NC_NOERR) /* report the first encountered error */
#line 3304
			status = lstatus;
#line 3304
	}
#line 3304

#line 3304
	*xpp = (const void *)xp;
#line 3304
	return status;
#line 3304
#endif
#line 3304
}
#line 3304

int
#line 3305
ncx_getn_int_uint(const void **xpp, size_t nelems, uint *tp)
#line 3305
{
#line 3305
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3305

#line 3305
 /* basic algorithm is:
#line 3305
  *   - ensure sane alignment of input data
#line 3305
  *   - copy (conversion happens automatically) input data
#line 3305
  *     to output
#line 3305
  *   - update xpp to point at next unconverted input, and tp to point
#line 3305
  *     at next location for converted output
#line 3305
  */
#line 3305
  long i, j, ni;
#line 3305
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3305
  int *xp;
#line 3305
  int nrange = 0;         /* number of range errors */
#line 3305
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3305
  long cxp = (long) *((char**)xpp);
#line 3305

#line 3305
  realign = (cxp & 7) % SIZEOF_INT;
#line 3305
  /* sjl: manually stripmine so we can limit amount of
#line 3305
   * vector work space reserved to LOOPCNT elements. Also
#line 3305
   * makes vectorisation easy */
#line 3305
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3305
    ni=Min(nelems-j,LOOPCNT);
#line 3305
    if (realign) {
#line 3305
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3305
      xp = tmp;
#line 3305
    } else {
#line 3305
      xp = (int *) *xpp;
#line 3305
    }
#line 3305
   /* copy the next block */
#line 3305
#pragma cdir loopcnt=LOOPCNT
#line 3305
#pragma cdir shortloop
#line 3305
    for (i=0; i<ni; i++) {
#line 3305
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3305
     /* test for range errors (not always needed but do it anyway) */
#line 3305
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3305
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3305
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3305
    }
#line 3305
   /* update xpp and tp */
#line 3305
    if (realign) xp = (int *) *xpp;
#line 3305
    xp += ni;
#line 3305
    tp += ni;
#line 3305
    *xpp = (void*)xp;
#line 3305
  }
#line 3305
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3305

#line 3305
#else   /* not SX */
#line 3305
	const char *xp = (const char *) *xpp;
#line 3305
	int status = NC_NOERR;
#line 3305

#line 3305
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3305
	{
#line 3305
		const int lstatus = ncx_get_int_uint(xp, tp);
#line 3305
		if (status == NC_NOERR) /* report the first encountered error */
#line 3305
			status = lstatus;
#line 3305
	}
#line 3305

#line 3305
	*xpp = (const void *)xp;
#line 3305
	return status;
#line 3305
#endif
#line 3305
}
#line 3305

int
#line 3306
ncx_getn_int_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3306
{
#line 3306
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3306

#line 3306
 /* basic algorithm is:
#line 3306
  *   - ensure sane alignment of input data
#line 3306
  *   - copy (conversion happens automatically) input data
#line 3306
  *     to output
#line 3306
  *   - update xpp to point at next unconverted input, and tp to point
#line 3306
  *     at next location for converted output
#line 3306
  */
#line 3306
  long i, j, ni;
#line 3306
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3306
  int *xp;
#line 3306
  int nrange = 0;         /* number of range errors */
#line 3306
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3306
  long cxp = (long) *((char**)xpp);
#line 3306

#line 3306
  realign = (cxp & 7) % SIZEOF_INT;
#line 3306
  /* sjl: manually stripmine so we can limit amount of
#line 3306
   * vector work space reserved to LOOPCNT elements. Also
#line 3306
   * makes vectorisation easy */
#line 3306
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3306
    ni=Min(nelems-j,LOOPCNT);
#line 3306
    if (realign) {
#line 3306
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3306
      xp = tmp;
#line 3306
    } else {
#line 3306
      xp = (int *) *xpp;
#line 3306
    }
#line 3306
   /* copy the next block */
#line 3306
#pragma cdir loopcnt=LOOPCNT
#line 3306
#pragma cdir shortloop
#line 3306
    for (i=0; i<ni; i++) {
#line 3306
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3306
     /* test for range errors (not always needed but do it anyway) */
#line 3306
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3306
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3306
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3306
    }
#line 3306
   /* update xpp and tp */
#line 3306
    if (realign) xp = (int *) *xpp;
#line 3306
    xp += ni;
#line 3306
    tp += ni;
#line 3306
    *xpp = (void*)xp;
#line 3306
  }
#line 3306
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3306

#line 3306
#else   /* not SX */
#line 3306
	const char *xp = (const char *) *xpp;
#line 3306
	int status = NC_NOERR;
#line 3306

#line 3306
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3306
	{
#line 3306
		const int lstatus = ncx_get_int_ulonglong(xp, tp);
#line 3306
		if (status == NC_NOERR) /* report the first encountered error */
#line 3306
			status = lstatus;
#line 3306
	}
#line 3306

#line 3306
	*xpp = (const void *)xp;
#line 3306
	return status;
#line 3306
#endif
#line 3306
}
#line 3306


#if X_SIZEOF_INT == SIZEOF_INT
/* optimized version */
int
ncx_putn_int_int(void **xpp, size_t nelems, const int *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_INT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_INT);
	return NC_NOERR;
}
#else
int
#line 3322
ncx_putn_int_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3322
{
#line 3322
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3322

#line 3322
 /* basic algorithm is:
#line 3322
  *   - ensure sane alignment of output data
#line 3322
  *   - copy (conversion happens automatically) input data
#line 3322
  *     to output
#line 3322
  *   - update tp to point at next unconverted input, and xpp to point
#line 3322
  *     at next location for converted output
#line 3322
  */
#line 3322
  long i, j, ni;
#line 3322
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3322
  int *xp;
#line 3322
  int nrange = 0;         /* number of range errors */
#line 3322
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3322
  long cxp = (long) *((char**)xpp);
#line 3322

#line 3322
  realign = (cxp & 7) % SIZEOF_INT;
#line 3322
  /* sjl: manually stripmine so we can limit amount of
#line 3322
   * vector work space reserved to LOOPCNT elements. Also
#line 3322
   * makes vectorisation easy */
#line 3322
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3322
    ni=Min(nelems-j,LOOPCNT);
#line 3322
    if (realign) {
#line 3322
      xp = tmp;
#line 3322
    } else {
#line 3322
      xp = (int *) *xpp;
#line 3322
    }
#line 3322
   /* copy the next block */
#line 3322
#pragma cdir loopcnt=LOOPCNT
#line 3322
#pragma cdir shortloop
#line 3322
    for (i=0; i<ni; i++) {
#line 3322
      /* the normal case: */
#line 3322
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3322
     /* test for range errors (not always needed but do it anyway) */
#line 3322
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3322
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3322
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3322
    }
#line 3322
   /* copy workspace back if necessary */
#line 3322
    if (realign) {
#line 3322
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3322
      xp = (int *) *xpp;
#line 3322
    }
#line 3322
   /* update xpp and tp */
#line 3322
    xp += ni;
#line 3322
    tp += ni;
#line 3322
    *xpp = (void*)xp;
#line 3322
  }
#line 3322
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3322

#line 3322
#else   /* not SX */
#line 3322

#line 3322
	char *xp = (char *) *xpp;
#line 3322
	int status = NC_NOERR;
#line 3322

#line 3322
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3322
	{
#line 3322
		int lstatus = ncx_put_int_int(xp, tp, fillp);
#line 3322
		if (status == NC_NOERR) /* report the first encountered error */
#line 3322
			status = lstatus;
#line 3322
	}
#line 3322

#line 3322
	*xpp = (void *)xp;
#line 3322
	return status;
#line 3322
#endif
#line 3322
}
#line 3322

#endif
int
#line 3324
ncx_putn_int_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3324
{
#line 3324
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3324

#line 3324
 /* basic algorithm is:
#line 3324
  *   - ensure sane alignment of output data
#line 3324
  *   - copy (conversion happens automatically) input data
#line 3324
  *     to output
#line 3324
  *   - update tp to point at next unconverted input, and xpp to point
#line 3324
  *     at next location for converted output
#line 3324
  */
#line 3324
  long i, j, ni;
#line 3324
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3324
  int *xp;
#line 3324
  int nrange = 0;         /* number of range errors */
#line 3324
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3324
  long cxp = (long) *((char**)xpp);
#line 3324

#line 3324
  realign = (cxp & 7) % SIZEOF_INT;
#line 3324
  /* sjl: manually stripmine so we can limit amount of
#line 3324
   * vector work space reserved to LOOPCNT elements. Also
#line 3324
   * makes vectorisation easy */
#line 3324
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3324
    ni=Min(nelems-j,LOOPCNT);
#line 3324
    if (realign) {
#line 3324
      xp = tmp;
#line 3324
    } else {
#line 3324
      xp = (int *) *xpp;
#line 3324
    }
#line 3324
   /* copy the next block */
#line 3324
#pragma cdir loopcnt=LOOPCNT
#line 3324
#pragma cdir shortloop
#line 3324
    for (i=0; i<ni; i++) {
#line 3324
      /* the normal case: */
#line 3324
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3324
     /* test for range errors (not always needed but do it anyway) */
#line 3324
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3324
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3324
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3324
    }
#line 3324
   /* copy workspace back if necessary */
#line 3324
    if (realign) {
#line 3324
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3324
      xp = (int *) *xpp;
#line 3324
    }
#line 3324
   /* update xpp and tp */
#line 3324
    xp += ni;
#line 3324
    tp += ni;
#line 3324
    *xpp = (void*)xp;
#line 3324
  }
#line 3324
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3324

#line 3324
#else   /* not SX */
#line 3324

#line 3324
	char *xp = (char *) *xpp;
#line 3324
	int status = NC_NOERR;
#line 3324

#line 3324
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3324
	{
#line 3324
		int lstatus = ncx_put_int_schar(xp, tp, fillp);
#line 3324
		if (status == NC_NOERR) /* report the first encountered error */
#line 3324
			status = lstatus;
#line 3324
	}
#line 3324

#line 3324
	*xpp = (void *)xp;
#line 3324
	return status;
#line 3324
#endif
#line 3324
}
#line 3324

int
#line 3325
ncx_putn_int_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3325
{
#line 3325
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3325

#line 3325
 /* basic algorithm is:
#line 3325
  *   - ensure sane alignment of output data
#line 3325
  *   - copy (conversion happens automatically) input data
#line 3325
  *     to output
#line 3325
  *   - update tp to point at next unconverted input, and xpp to point
#line 3325
  *     at next location for converted output
#line 3325
  */
#line 3325
  long i, j, ni;
#line 3325
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3325
  int *xp;
#line 3325
  int nrange = 0;         /* number of range errors */
#line 3325
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3325
  long cxp = (long) *((char**)xpp);
#line 3325

#line 3325
  realign = (cxp & 7) % SIZEOF_INT;
#line 3325
  /* sjl: manually stripmine so we can limit amount of
#line 3325
   * vector work space reserved to LOOPCNT elements. Also
#line 3325
   * makes vectorisation easy */
#line 3325
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3325
    ni=Min(nelems-j,LOOPCNT);
#line 3325
    if (realign) {
#line 3325
      xp = tmp;
#line 3325
    } else {
#line 3325
      xp = (int *) *xpp;
#line 3325
    }
#line 3325
   /* copy the next block */
#line 3325
#pragma cdir loopcnt=LOOPCNT
#line 3325
#pragma cdir shortloop
#line 3325
    for (i=0; i<ni; i++) {
#line 3325
      /* the normal case: */
#line 3325
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3325
     /* test for range errors (not always needed but do it anyway) */
#line 3325
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3325
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3325
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3325
    }
#line 3325
   /* copy workspace back if necessary */
#line 3325
    if (realign) {
#line 3325
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3325
      xp = (int *) *xpp;
#line 3325
    }
#line 3325
   /* update xpp and tp */
#line 3325
    xp += ni;
#line 3325
    tp += ni;
#line 3325
    *xpp = (void*)xp;
#line 3325
  }
#line 3325
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3325

#line 3325
#else   /* not SX */
#line 3325

#line 3325
	char *xp = (char *) *xpp;
#line 3325
	int status = NC_NOERR;
#line 3325

#line 3325
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3325
	{
#line 3325
		int lstatus = ncx_put_int_short(xp, tp, fillp);
#line 3325
		if (status == NC_NOERR) /* report the first encountered error */
#line 3325
			status = lstatus;
#line 3325
	}
#line 3325

#line 3325
	*xpp = (void *)xp;
#line 3325
	return status;
#line 3325
#endif
#line 3325
}
#line 3325

int
#line 3326
ncx_putn_int_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3326
{
#line 3326
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3326

#line 3326
 /* basic algorithm is:
#line 3326
  *   - ensure sane alignment of output data
#line 3326
  *   - copy (conversion happens automatically) input data
#line 3326
  *     to output
#line 3326
  *   - update tp to point at next unconverted input, and xpp to point
#line 3326
  *     at next location for converted output
#line 3326
  */
#line 3326
  long i, j, ni;
#line 3326
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3326
  int *xp;
#line 3326
  int nrange = 0;         /* number of range errors */
#line 3326
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3326
  long cxp = (long) *((char**)xpp);
#line 3326

#line 3326
  realign = (cxp & 7) % SIZEOF_INT;
#line 3326
  /* sjl: manually stripmine so we can limit amount of
#line 3326
   * vector work space reserved to LOOPCNT elements. Also
#line 3326
   * makes vectorisation easy */
#line 3326
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3326
    ni=Min(nelems-j,LOOPCNT);
#line 3326
    if (realign) {
#line 3326
      xp = tmp;
#line 3326
    } else {
#line 3326
      xp = (int *) *xpp;
#line 3326
    }
#line 3326
   /* copy the next block */
#line 3326
#pragma cdir loopcnt=LOOPCNT
#line 3326
#pragma cdir shortloop
#line 3326
    for (i=0; i<ni; i++) {
#line 3326
      /* the normal case: */
#line 3326
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3326
     /* test for range errors (not always needed but do it anyway) */
#line 3326
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3326
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3326
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3326
    }
#line 3326
   /* copy workspace back if necessary */
#line 3326
    if (realign) {
#line 3326
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3326
      xp = (int *) *xpp;
#line 3326
    }
#line 3326
   /* update xpp and tp */
#line 3326
    xp += ni;
#line 3326
    tp += ni;
#line 3326
    *xpp = (void*)xp;
#line 3326
  }
#line 3326
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3326

#line 3326
#else   /* not SX */
#line 3326

#line 3326
	char *xp = (char *) *xpp;
#line 3326
	int status = NC_NOERR;
#line 3326

#line 3326
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3326
	{
#line 3326
		int lstatus = ncx_put_int_long(xp, tp, fillp);
#line 3326
		if (status == NC_NOERR) /* report the first encountered error */
#line 3326
			status = lstatus;
#line 3326
	}
#line 3326

#line 3326
	*xpp = (void *)xp;
#line 3326
	return status;
#line 3326
#endif
#line 3326
}
#line 3326

int
#line 3327
ncx_putn_int_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3327
{
#line 3327
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3327

#line 3327
 /* basic algorithm is:
#line 3327
  *   - ensure sane alignment of output data
#line 3327
  *   - copy (conversion happens automatically) input data
#line 3327
  *     to output
#line 3327
  *   - update tp to point at next unconverted input, and xpp to point
#line 3327
  *     at next location for converted output
#line 3327
  */
#line 3327
  long i, j, ni;
#line 3327
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3327
  int *xp;
#line 3327
  double d;               /* special case for ncx_putn_int_float */
#line 3327
  int nrange = 0;         /* number of range errors */
#line 3327
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3327
  long cxp = (long) *((char**)xpp);
#line 3327

#line 3327
  realign = (cxp & 7) % SIZEOF_INT;
#line 3327
  /* sjl: manually stripmine so we can limit amount of
#line 3327
   * vector work space reserved to LOOPCNT elements. Also
#line 3327
   * makes vectorisation easy */
#line 3327
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3327
    ni=Min(nelems-j,LOOPCNT);
#line 3327
    if (realign) {
#line 3327
      xp = tmp;
#line 3327
    } else {
#line 3327
      xp = (int *) *xpp;
#line 3327
    }
#line 3327
   /* copy the next block */
#line 3327
#pragma cdir loopcnt=LOOPCNT
#line 3327
#pragma cdir shortloop
#line 3327
    for (i=0; i<ni; i++) {
#line 3327
      /* for some reason int to float, for putn, requires a special case */
#line 3327
      d = tp[i];
#line 3327
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) d));
#line 3327
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3327
    }
#line 3327
   /* copy workspace back if necessary */
#line 3327
    if (realign) {
#line 3327
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3327
      xp = (int *) *xpp;
#line 3327
    }
#line 3327
   /* update xpp and tp */
#line 3327
    xp += ni;
#line 3327
    tp += ni;
#line 3327
    *xpp = (void*)xp;
#line 3327
  }
#line 3327
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3327

#line 3327
#else   /* not SX */
#line 3327

#line 3327
	char *xp = (char *) *xpp;
#line 3327
	int status = NC_NOERR;
#line 3327

#line 3327
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3327
	{
#line 3327
		int lstatus = ncx_put_int_float(xp, tp, fillp);
#line 3327
		if (status == NC_NOERR) /* report the first encountered error */
#line 3327
			status = lstatus;
#line 3327
	}
#line 3327

#line 3327
	*xpp = (void *)xp;
#line 3327
	return status;
#line 3327
#endif
#line 3327
}
#line 3327

int
#line 3328
ncx_putn_int_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3328
{
#line 3328
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3328

#line 3328
 /* basic algorithm is:
#line 3328
  *   - ensure sane alignment of output data
#line 3328
  *   - copy (conversion happens automatically) input data
#line 3328
  *     to output
#line 3328
  *   - update tp to point at next unconverted input, and xpp to point
#line 3328
  *     at next location for converted output
#line 3328
  */
#line 3328
  long i, j, ni;
#line 3328
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3328
  int *xp;
#line 3328
  int nrange = 0;         /* number of range errors */
#line 3328
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3328
  long cxp = (long) *((char**)xpp);
#line 3328

#line 3328
  realign = (cxp & 7) % SIZEOF_INT;
#line 3328
  /* sjl: manually stripmine so we can limit amount of
#line 3328
   * vector work space reserved to LOOPCNT elements. Also
#line 3328
   * makes vectorisation easy */
#line 3328
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3328
    ni=Min(nelems-j,LOOPCNT);
#line 3328
    if (realign) {
#line 3328
      xp = tmp;
#line 3328
    } else {
#line 3328
      xp = (int *) *xpp;
#line 3328
    }
#line 3328
   /* copy the next block */
#line 3328
#pragma cdir loopcnt=LOOPCNT
#line 3328
#pragma cdir shortloop
#line 3328
    for (i=0; i<ni; i++) {
#line 3328
      /* the normal case: */
#line 3328
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3328
     /* test for range errors (not always needed but do it anyway) */
#line 3328
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3328
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3328
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3328
    }
#line 3328
   /* copy workspace back if necessary */
#line 3328
    if (realign) {
#line 3328
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3328
      xp = (int *) *xpp;
#line 3328
    }
#line 3328
   /* update xpp and tp */
#line 3328
    xp += ni;
#line 3328
    tp += ni;
#line 3328
    *xpp = (void*)xp;
#line 3328
  }
#line 3328
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3328

#line 3328
#else   /* not SX */
#line 3328

#line 3328
	char *xp = (char *) *xpp;
#line 3328
	int status = NC_NOERR;
#line 3328

#line 3328
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3328
	{
#line 3328
		int lstatus = ncx_put_int_double(xp, tp, fillp);
#line 3328
		if (status == NC_NOERR) /* report the first encountered error */
#line 3328
			status = lstatus;
#line 3328
	}
#line 3328

#line 3328
	*xpp = (void *)xp;
#line 3328
	return status;
#line 3328
#endif
#line 3328
}
#line 3328

int
#line 3329
ncx_putn_int_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3329
{
#line 3329
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3329

#line 3329
 /* basic algorithm is:
#line 3329
  *   - ensure sane alignment of output data
#line 3329
  *   - copy (conversion happens automatically) input data
#line 3329
  *     to output
#line 3329
  *   - update tp to point at next unconverted input, and xpp to point
#line 3329
  *     at next location for converted output
#line 3329
  */
#line 3329
  long i, j, ni;
#line 3329
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3329
  int *xp;
#line 3329
  int nrange = 0;         /* number of range errors */
#line 3329
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3329
  long cxp = (long) *((char**)xpp);
#line 3329

#line 3329
  realign = (cxp & 7) % SIZEOF_INT;
#line 3329
  /* sjl: manually stripmine so we can limit amount of
#line 3329
   * vector work space reserved to LOOPCNT elements. Also
#line 3329
   * makes vectorisation easy */
#line 3329
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3329
    ni=Min(nelems-j,LOOPCNT);
#line 3329
    if (realign) {
#line 3329
      xp = tmp;
#line 3329
    } else {
#line 3329
      xp = (int *) *xpp;
#line 3329
    }
#line 3329
   /* copy the next block */
#line 3329
#pragma cdir loopcnt=LOOPCNT
#line 3329
#pragma cdir shortloop
#line 3329
    for (i=0; i<ni; i++) {
#line 3329
      /* the normal case: */
#line 3329
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3329
     /* test for range errors (not always needed but do it anyway) */
#line 3329
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3329
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3329
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3329
    }
#line 3329
   /* copy workspace back if necessary */
#line 3329
    if (realign) {
#line 3329
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3329
      xp = (int *) *xpp;
#line 3329
    }
#line 3329
   /* update xpp and tp */
#line 3329
    xp += ni;
#line 3329
    tp += ni;
#line 3329
    *xpp = (void*)xp;
#line 3329
  }
#line 3329
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3329

#line 3329
#else   /* not SX */
#line 3329

#line 3329
	char *xp = (char *) *xpp;
#line 3329
	int status = NC_NOERR;
#line 3329

#line 3329
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3329
	{
#line 3329
		int lstatus = ncx_put_int_longlong(xp, tp, fillp);
#line 3329
		if (status == NC_NOERR) /* report the first encountered error */
#line 3329
			status = lstatus;
#line 3329
	}
#line 3329

#line 3329
	*xpp = (void *)xp;
#line 3329
	return status;
#line 3329
#endif
#line 3329
}
#line 3329

int
#line 3330
ncx_putn_int_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3330
{
#line 3330
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3330

#line 3330
 /* basic algorithm is:
#line 3330
  *   - ensure sane alignment of output data
#line 3330
  *   - copy (conversion happens automatically) input data
#line 3330
  *     to output
#line 3330
  *   - update tp to point at next unconverted input, and xpp to point
#line 3330
  *     at next location for converted output
#line 3330
  */
#line 3330
  long i, j, ni;
#line 3330
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3330
  int *xp;
#line 3330
  int nrange = 0;         /* number of range errors */
#line 3330
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3330
  long cxp = (long) *((char**)xpp);
#line 3330

#line 3330
  realign = (cxp & 7) % SIZEOF_INT;
#line 3330
  /* sjl: manually stripmine so we can limit amount of
#line 3330
   * vector work space reserved to LOOPCNT elements. Also
#line 3330
   * makes vectorisation easy */
#line 3330
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3330
    ni=Min(nelems-j,LOOPCNT);
#line 3330
    if (realign) {
#line 3330
      xp = tmp;
#line 3330
    } else {
#line 3330
      xp = (int *) *xpp;
#line 3330
    }
#line 3330
   /* copy the next block */
#line 3330
#pragma cdir loopcnt=LOOPCNT
#line 3330
#pragma cdir shortloop
#line 3330
    for (i=0; i<ni; i++) {
#line 3330
      /* the normal case: */
#line 3330
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3330
     /* test for range errors (not always needed but do it anyway) */
#line 3330
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3330
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3330
      nrange += tp[i] > X_INT_MAX ;
#line 3330
    }
#line 3330
   /* copy workspace back if necessary */
#line 3330
    if (realign) {
#line 3330
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3330
      xp = (int *) *xpp;
#line 3330
    }
#line 3330
   /* update xpp and tp */
#line 3330
    xp += ni;
#line 3330
    tp += ni;
#line 3330
    *xpp = (void*)xp;
#line 3330
  }
#line 3330
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3330

#line 3330
#else   /* not SX */
#line 3330

#line 3330
	char *xp = (char *) *xpp;
#line 3330
	int status = NC_NOERR;
#line 3330

#line 3330
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3330
	{
#line 3330
		int lstatus = ncx_put_int_uchar(xp, tp, fillp);
#line 3330
		if (status == NC_NOERR) /* report the first encountered error */
#line 3330
			status = lstatus;
#line 3330
	}
#line 3330

#line 3330
	*xpp = (void *)xp;
#line 3330
	return status;
#line 3330
#endif
#line 3330
}
#line 3330

int
#line 3331
ncx_putn_int_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3331
{
#line 3331
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3331

#line 3331
 /* basic algorithm is:
#line 3331
  *   - ensure sane alignment of output data
#line 3331
  *   - copy (conversion happens automatically) input data
#line 3331
  *     to output
#line 3331
  *   - update tp to point at next unconverted input, and xpp to point
#line 3331
  *     at next location for converted output
#line 3331
  */
#line 3331
  long i, j, ni;
#line 3331
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3331
  int *xp;
#line 3331
  int nrange = 0;         /* number of range errors */
#line 3331
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3331
  long cxp = (long) *((char**)xpp);
#line 3331

#line 3331
  realign = (cxp & 7) % SIZEOF_INT;
#line 3331
  /* sjl: manually stripmine so we can limit amount of
#line 3331
   * vector work space reserved to LOOPCNT elements. Also
#line 3331
   * makes vectorisation easy */
#line 3331
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3331
    ni=Min(nelems-j,LOOPCNT);
#line 3331
    if (realign) {
#line 3331
      xp = tmp;
#line 3331
    } else {
#line 3331
      xp = (int *) *xpp;
#line 3331
    }
#line 3331
   /* copy the next block */
#line 3331
#pragma cdir loopcnt=LOOPCNT
#line 3331
#pragma cdir shortloop
#line 3331
    for (i=0; i<ni; i++) {
#line 3331
      /* the normal case: */
#line 3331
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3331
     /* test for range errors (not always needed but do it anyway) */
#line 3331
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3331
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3331
      nrange += tp[i] > X_INT_MAX ;
#line 3331
    }
#line 3331
   /* copy workspace back if necessary */
#line 3331
    if (realign) {
#line 3331
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3331
      xp = (int *) *xpp;
#line 3331
    }
#line 3331
   /* update xpp and tp */
#line 3331
    xp += ni;
#line 3331
    tp += ni;
#line 3331
    *xpp = (void*)xp;
#line 3331
  }
#line 3331
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3331

#line 3331
#else   /* not SX */
#line 3331

#line 3331
	char *xp = (char *) *xpp;
#line 3331
	int status = NC_NOERR;
#line 3331

#line 3331
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3331
	{
#line 3331
		int lstatus = ncx_put_int_ushort(xp, tp, fillp);
#line 3331
		if (status == NC_NOERR) /* report the first encountered error */
#line 3331
			status = lstatus;
#line 3331
	}
#line 3331

#line 3331
	*xpp = (void *)xp;
#line 3331
	return status;
#line 3331
#endif
#line 3331
}
#line 3331

int
#line 3332
ncx_putn_int_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3332
{
#line 3332
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3332

#line 3332
 /* basic algorithm is:
#line 3332
  *   - ensure sane alignment of output data
#line 3332
  *   - copy (conversion happens automatically) input data
#line 3332
  *     to output
#line 3332
  *   - update tp to point at next unconverted input, and xpp to point
#line 3332
  *     at next location for converted output
#line 3332
  */
#line 3332
  long i, j, ni;
#line 3332
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3332
  int *xp;
#line 3332
  int nrange = 0;         /* number of range errors */
#line 3332
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3332
  long cxp = (long) *((char**)xpp);
#line 3332

#line 3332
  realign = (cxp & 7) % SIZEOF_INT;
#line 3332
  /* sjl: manually stripmine so we can limit amount of
#line 3332
   * vector work space reserved to LOOPCNT elements. Also
#line 3332
   * makes vectorisation easy */
#line 3332
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3332
    ni=Min(nelems-j,LOOPCNT);
#line 3332
    if (realign) {
#line 3332
      xp = tmp;
#line 3332
    } else {
#line 3332
      xp = (int *) *xpp;
#line 3332
    }
#line 3332
   /* copy the next block */
#line 3332
#pragma cdir loopcnt=LOOPCNT
#line 3332
#pragma cdir shortloop
#line 3332
    for (i=0; i<ni; i++) {
#line 3332
      /* the normal case: */
#line 3332
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3332
     /* test for range errors (not always needed but do it anyway) */
#line 3332
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3332
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3332
      nrange += tp[i] > X_INT_MAX ;
#line 3332
    }
#line 3332
   /* copy workspace back if necessary */
#line 3332
    if (realign) {
#line 3332
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3332
      xp = (int *) *xpp;
#line 3332
    }
#line 3332
   /* update xpp and tp */
#line 3332
    xp += ni;
#line 3332
    tp += ni;
#line 3332
    *xpp = (void*)xp;
#line 3332
  }
#line 3332
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3332

#line 3332
#else   /* not SX */
#line 3332

#line 3332
	char *xp = (char *) *xpp;
#line 3332
	int status = NC_NOERR;
#line 3332

#line 3332
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3332
	{
#line 3332
		int lstatus = ncx_put_int_uint(xp, tp, fillp);
#line 3332
		if (status == NC_NOERR) /* report the first encountered error */
#line 3332
			status = lstatus;
#line 3332
	}
#line 3332

#line 3332
	*xpp = (void *)xp;
#line 3332
	return status;
#line 3332
#endif
#line 3332
}
#line 3332

int
#line 3333
ncx_putn_int_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3333
{
#line 3333
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3333

#line 3333
 /* basic algorithm is:
#line 3333
  *   - ensure sane alignment of output data
#line 3333
  *   - copy (conversion happens automatically) input data
#line 3333
  *     to output
#line 3333
  *   - update tp to point at next unconverted input, and xpp to point
#line 3333
  *     at next location for converted output
#line 3333
  */
#line 3333
  long i, j, ni;
#line 3333
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3333
  int *xp;
#line 3333
  int nrange = 0;         /* number of range errors */
#line 3333
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3333
  long cxp = (long) *((char**)xpp);
#line 3333

#line 3333
  realign = (cxp & 7) % SIZEOF_INT;
#line 3333
  /* sjl: manually stripmine so we can limit amount of
#line 3333
   * vector work space reserved to LOOPCNT elements. Also
#line 3333
   * makes vectorisation easy */
#line 3333
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3333
    ni=Min(nelems-j,LOOPCNT);
#line 3333
    if (realign) {
#line 3333
      xp = tmp;
#line 3333
    } else {
#line 3333
      xp = (int *) *xpp;
#line 3333
    }
#line 3333
   /* copy the next block */
#line 3333
#pragma cdir loopcnt=LOOPCNT
#line 3333
#pragma cdir shortloop
#line 3333
    for (i=0; i<ni; i++) {
#line 3333
      /* the normal case: */
#line 3333
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3333
     /* test for range errors (not always needed but do it anyway) */
#line 3333
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3333
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3333
      nrange += tp[i] > X_INT_MAX ;
#line 3333
    }
#line 3333
   /* copy workspace back if necessary */
#line 3333
    if (realign) {
#line 3333
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3333
      xp = (int *) *xpp;
#line 3333
    }
#line 3333
   /* update xpp and tp */
#line 3333
    xp += ni;
#line 3333
    tp += ni;
#line 3333
    *xpp = (void*)xp;
#line 3333
  }
#line 3333
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3333

#line 3333
#else   /* not SX */
#line 3333

#line 3333
	char *xp = (char *) *xpp;
#line 3333
	int status = NC_NOERR;
#line 3333

#line 3333
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3333
	{
#line 3333
		int lstatus = ncx_put_int_ulonglong(xp, tp, fillp);
#line 3333
		if (status == NC_NOERR) /* report the first encountered error */
#line 3333
			status = lstatus;
#line 3333
	}
#line 3333

#line 3333
	*xpp = (void *)xp;
#line 3333
	return status;
#line 3333
#endif
#line 3333
}
#line 3333


/* uint ----------------------------------------------------------------------*/

#if X_SIZEOF_UINT == SIZEOF_UINT
/* optimized version */
int
ncx_getn_uint_uint(const void **xpp, size_t nelems, unsigned int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_UINT);
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_UINT);
	return NC_NOERR;
}
#else
int
#line 3351
ncx_getn_uint_uint(const void **xpp, size_t nelems, uint *tp)
#line 3351
{
#line 3351
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3351

#line 3351
 /* basic algorithm is:
#line 3351
  *   - ensure sane alignment of input data
#line 3351
  *   - copy (conversion happens automatically) input data
#line 3351
  *     to output
#line 3351
  *   - update xpp to point at next unconverted input, and tp to point
#line 3351
  *     at next location for converted output
#line 3351
  */
#line 3351
  long i, j, ni;
#line 3351
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3351
  uint *xp;
#line 3351
  int nrange = 0;         /* number of range errors */
#line 3351
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3351
  long cxp = (long) *((char**)xpp);
#line 3351

#line 3351
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3351
  /* sjl: manually stripmine so we can limit amount of
#line 3351
   * vector work space reserved to LOOPCNT elements. Also
#line 3351
   * makes vectorisation easy */
#line 3351
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3351
    ni=Min(nelems-j,LOOPCNT);
#line 3351
    if (realign) {
#line 3351
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3351
      xp = tmp;
#line 3351
    } else {
#line 3351
      xp = (uint *) *xpp;
#line 3351
    }
#line 3351
   /* copy the next block */
#line 3351
#pragma cdir loopcnt=LOOPCNT
#line 3351
#pragma cdir shortloop
#line 3351
    for (i=0; i<ni; i++) {
#line 3351
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3351
     /* test for range errors (not always needed but do it anyway) */
#line 3351
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3351
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3351
      nrange += xp[i] > UINT_MAX ;
#line 3351
    }
#line 3351
   /* update xpp and tp */
#line 3351
    if (realign) xp = (uint *) *xpp;
#line 3351
    xp += ni;
#line 3351
    tp += ni;
#line 3351
    *xpp = (void*)xp;
#line 3351
  }
#line 3351
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3351

#line 3351
#else   /* not SX */
#line 3351
	const char *xp = (const char *) *xpp;
#line 3351
	int status = NC_NOERR;
#line 3351

#line 3351
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3351
	{
#line 3351
		const int lstatus = ncx_get_uint_uint(xp, tp);
#line 3351
		if (status == NC_NOERR) /* report the first encountered error */
#line 3351
			status = lstatus;
#line 3351
	}
#line 3351

#line 3351
	*xpp = (const void *)xp;
#line 3351
	return status;
#line 3351
#endif
#line 3351
}
#line 3351

#endif
int
#line 3353
ncx_getn_uint_schar(const void **xpp, size_t nelems, schar *tp)
#line 3353
{
#line 3353
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3353

#line 3353
 /* basic algorithm is:
#line 3353
  *   - ensure sane alignment of input data
#line 3353
  *   - copy (conversion happens automatically) input data
#line 3353
  *     to output
#line 3353
  *   - update xpp to point at next unconverted input, and tp to point
#line 3353
  *     at next location for converted output
#line 3353
  */
#line 3353
  long i, j, ni;
#line 3353
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3353
  uint *xp;
#line 3353
  int nrange = 0;         /* number of range errors */
#line 3353
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3353
  long cxp = (long) *((char**)xpp);
#line 3353

#line 3353
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3353
  /* sjl: manually stripmine so we can limit amount of
#line 3353
   * vector work space reserved to LOOPCNT elements. Also
#line 3353
   * makes vectorisation easy */
#line 3353
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3353
    ni=Min(nelems-j,LOOPCNT);
#line 3353
    if (realign) {
#line 3353
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3353
      xp = tmp;
#line 3353
    } else {
#line 3353
      xp = (uint *) *xpp;
#line 3353
    }
#line 3353
   /* copy the next block */
#line 3353
#pragma cdir loopcnt=LOOPCNT
#line 3353
#pragma cdir shortloop
#line 3353
    for (i=0; i<ni; i++) {
#line 3353
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3353
     /* test for range errors (not always needed but do it anyway) */
#line 3353
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3353
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3353
      nrange += xp[i] > SCHAR_MAX ;
#line 3353
    }
#line 3353
   /* update xpp and tp */
#line 3353
    if (realign) xp = (uint *) *xpp;
#line 3353
    xp += ni;
#line 3353
    tp += ni;
#line 3353
    *xpp = (void*)xp;
#line 3353
  }
#line 3353
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3353

#line 3353
#else   /* not SX */
#line 3353
	const char *xp = (const char *) *xpp;
#line 3353
	int status = NC_NOERR;
#line 3353

#line 3353
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3353
	{
#line 3353
		const int lstatus = ncx_get_uint_schar(xp, tp);
#line 3353
		if (status == NC_NOERR) /* report the first encountered error */
#line 3353
			status = lstatus;
#line 3353
	}
#line 3353

#line 3353
	*xpp = (const void *)xp;
#line 3353
	return status;
#line 3353
#endif
#line 3353
}
#line 3353

int
#line 3354
ncx_getn_uint_short(const void **xpp, size_t nelems, short *tp)
#line 3354
{
#line 3354
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3354

#line 3354
 /* basic algorithm is:
#line 3354
  *   - ensure sane alignment of input data
#line 3354
  *   - copy (conversion happens automatically) input data
#line 3354
  *     to output
#line 3354
  *   - update xpp to point at next unconverted input, and tp to point
#line 3354
  *     at next location for converted output
#line 3354
  */
#line 3354
  long i, j, ni;
#line 3354
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3354
  uint *xp;
#line 3354
  int nrange = 0;         /* number of range errors */
#line 3354
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3354
  long cxp = (long) *((char**)xpp);
#line 3354

#line 3354
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3354
  /* sjl: manually stripmine so we can limit amount of
#line 3354
   * vector work space reserved to LOOPCNT elements. Also
#line 3354
   * makes vectorisation easy */
#line 3354
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3354
    ni=Min(nelems-j,LOOPCNT);
#line 3354
    if (realign) {
#line 3354
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3354
      xp = tmp;
#line 3354
    } else {
#line 3354
      xp = (uint *) *xpp;
#line 3354
    }
#line 3354
   /* copy the next block */
#line 3354
#pragma cdir loopcnt=LOOPCNT
#line 3354
#pragma cdir shortloop
#line 3354
    for (i=0; i<ni; i++) {
#line 3354
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3354
     /* test for range errors (not always needed but do it anyway) */
#line 3354
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3354
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3354
      nrange += xp[i] > SHORT_MAX ;
#line 3354
    }
#line 3354
   /* update xpp and tp */
#line 3354
    if (realign) xp = (uint *) *xpp;
#line 3354
    xp += ni;
#line 3354
    tp += ni;
#line 3354
    *xpp = (void*)xp;
#line 3354
  }
#line 3354
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3354

#line 3354
#else   /* not SX */
#line 3354
	const char *xp = (const char *) *xpp;
#line 3354
	int status = NC_NOERR;
#line 3354

#line 3354
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3354
	{
#line 3354
		const int lstatus = ncx_get_uint_short(xp, tp);
#line 3354
		if (status == NC_NOERR) /* report the first encountered error */
#line 3354
			status = lstatus;
#line 3354
	}
#line 3354

#line 3354
	*xpp = (const void *)xp;
#line 3354
	return status;
#line 3354
#endif
#line 3354
}
#line 3354

int
#line 3355
ncx_getn_uint_int(const void **xpp, size_t nelems, int *tp)
#line 3355
{
#line 3355
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3355

#line 3355
 /* basic algorithm is:
#line 3355
  *   - ensure sane alignment of input data
#line 3355
  *   - copy (conversion happens automatically) input data
#line 3355
  *     to output
#line 3355
  *   - update xpp to point at next unconverted input, and tp to point
#line 3355
  *     at next location for converted output
#line 3355
  */
#line 3355
  long i, j, ni;
#line 3355
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3355
  uint *xp;
#line 3355
  int nrange = 0;         /* number of range errors */
#line 3355
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3355
  long cxp = (long) *((char**)xpp);
#line 3355

#line 3355
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3355
  /* sjl: manually stripmine so we can limit amount of
#line 3355
   * vector work space reserved to LOOPCNT elements. Also
#line 3355
   * makes vectorisation easy */
#line 3355
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3355
    ni=Min(nelems-j,LOOPCNT);
#line 3355
    if (realign) {
#line 3355
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3355
      xp = tmp;
#line 3355
    } else {
#line 3355
      xp = (uint *) *xpp;
#line 3355
    }
#line 3355
   /* copy the next block */
#line 3355
#pragma cdir loopcnt=LOOPCNT
#line 3355
#pragma cdir shortloop
#line 3355
    for (i=0; i<ni; i++) {
#line 3355
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3355
     /* test for range errors (not always needed but do it anyway) */
#line 3355
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3355
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3355
      nrange += xp[i] > INT_MAX ;
#line 3355
    }
#line 3355
   /* update xpp and tp */
#line 3355
    if (realign) xp = (uint *) *xpp;
#line 3355
    xp += ni;
#line 3355
    tp += ni;
#line 3355
    *xpp = (void*)xp;
#line 3355
  }
#line 3355
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3355

#line 3355
#else   /* not SX */
#line 3355
	const char *xp = (const char *) *xpp;
#line 3355
	int status = NC_NOERR;
#line 3355

#line 3355
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3355
	{
#line 3355
		const int lstatus = ncx_get_uint_int(xp, tp);
#line 3355
		if (status == NC_NOERR) /* report the first encountered error */
#line 3355
			status = lstatus;
#line 3355
	}
#line 3355

#line 3355
	*xpp = (const void *)xp;
#line 3355
	return status;
#line 3355
#endif
#line 3355
}
#line 3355

int
#line 3356
ncx_getn_uint_long(const void **xpp, size_t nelems, long *tp)
#line 3356
{
#line 3356
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3356

#line 3356
 /* basic algorithm is:
#line 3356
  *   - ensure sane alignment of input data
#line 3356
  *   - copy (conversion happens automatically) input data
#line 3356
  *     to output
#line 3356
  *   - update xpp to point at next unconverted input, and tp to point
#line 3356
  *     at next location for converted output
#line 3356
  */
#line 3356
  long i, j, ni;
#line 3356
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3356
  uint *xp;
#line 3356
  int nrange = 0;         /* number of range errors */
#line 3356
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3356
  long cxp = (long) *((char**)xpp);
#line 3356

#line 3356
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3356
  /* sjl: manually stripmine so we can limit amount of
#line 3356
   * vector work space reserved to LOOPCNT elements. Also
#line 3356
   * makes vectorisation easy */
#line 3356
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3356
    ni=Min(nelems-j,LOOPCNT);
#line 3356
    if (realign) {
#line 3356
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3356
      xp = tmp;
#line 3356
    } else {
#line 3356
      xp = (uint *) *xpp;
#line 3356
    }
#line 3356
   /* copy the next block */
#line 3356
#pragma cdir loopcnt=LOOPCNT
#line 3356
#pragma cdir shortloop
#line 3356
    for (i=0; i<ni; i++) {
#line 3356
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3356
     /* test for range errors (not always needed but do it anyway) */
#line 3356
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3356
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3356
      nrange += xp[i] > LONG_MAX ;
#line 3356
    }
#line 3356
   /* update xpp and tp */
#line 3356
    if (realign) xp = (uint *) *xpp;
#line 3356
    xp += ni;
#line 3356
    tp += ni;
#line 3356
    *xpp = (void*)xp;
#line 3356
  }
#line 3356
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3356

#line 3356
#else   /* not SX */
#line 3356
	const char *xp = (const char *) *xpp;
#line 3356
	int status = NC_NOERR;
#line 3356

#line 3356
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3356
	{
#line 3356
		const int lstatus = ncx_get_uint_long(xp, tp);
#line 3356
		if (status == NC_NOERR) /* report the first encountered error */
#line 3356
			status = lstatus;
#line 3356
	}
#line 3356

#line 3356
	*xpp = (const void *)xp;
#line 3356
	return status;
#line 3356
#endif
#line 3356
}
#line 3356

int
#line 3357
ncx_getn_uint_float(const void **xpp, size_t nelems, float *tp)
#line 3357
{
#line 3357
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3357

#line 3357
 /* basic algorithm is:
#line 3357
  *   - ensure sane alignment of input data
#line 3357
  *   - copy (conversion happens automatically) input data
#line 3357
  *     to output
#line 3357
  *   - update xpp to point at next unconverted input, and tp to point
#line 3357
  *     at next location for converted output
#line 3357
  */
#line 3357
  long i, j, ni;
#line 3357
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3357
  uint *xp;
#line 3357
  int nrange = 0;         /* number of range errors */
#line 3357
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3357
  long cxp = (long) *((char**)xpp);
#line 3357

#line 3357
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3357
  /* sjl: manually stripmine so we can limit amount of
#line 3357
   * vector work space reserved to LOOPCNT elements. Also
#line 3357
   * makes vectorisation easy */
#line 3357
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3357
    ni=Min(nelems-j,LOOPCNT);
#line 3357
    if (realign) {
#line 3357
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3357
      xp = tmp;
#line 3357
    } else {
#line 3357
      xp = (uint *) *xpp;
#line 3357
    }
#line 3357
   /* copy the next block */
#line 3357
#pragma cdir loopcnt=LOOPCNT
#line 3357
#pragma cdir shortloop
#line 3357
    for (i=0; i<ni; i++) {
#line 3357
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3357
     /* test for range errors (not always needed but do it anyway) */
#line 3357
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3357
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3357
      nrange += xp[i] > FLOAT_MAX ;
#line 3357
    }
#line 3357
   /* update xpp and tp */
#line 3357
    if (realign) xp = (uint *) *xpp;
#line 3357
    xp += ni;
#line 3357
    tp += ni;
#line 3357
    *xpp = (void*)xp;
#line 3357
  }
#line 3357
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3357

#line 3357
#else   /* not SX */
#line 3357
	const char *xp = (const char *) *xpp;
#line 3357
	int status = NC_NOERR;
#line 3357

#line 3357
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3357
	{
#line 3357
		const int lstatus = ncx_get_uint_float(xp, tp);
#line 3357
		if (status == NC_NOERR) /* report the first encountered error */
#line 3357
			status = lstatus;
#line 3357
	}
#line 3357

#line 3357
	*xpp = (const void *)xp;
#line 3357
	return status;
#line 3357
#endif
#line 3357
}
#line 3357

int
#line 3358
ncx_getn_uint_double(const void **xpp, size_t nelems, double *tp)
#line 3358
{
#line 3358
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3358

#line 3358
 /* basic algorithm is:
#line 3358
  *   - ensure sane alignment of input data
#line 3358
  *   - copy (conversion happens automatically) input data
#line 3358
  *     to output
#line 3358
  *   - update xpp to point at next unconverted input, and tp to point
#line 3358
  *     at next location for converted output
#line 3358
  */
#line 3358
  long i, j, ni;
#line 3358
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3358
  uint *xp;
#line 3358
  int nrange = 0;         /* number of range errors */
#line 3358
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3358
  long cxp = (long) *((char**)xpp);
#line 3358

#line 3358
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3358
  /* sjl: manually stripmine so we can limit amount of
#line 3358
   * vector work space reserved to LOOPCNT elements. Also
#line 3358
   * makes vectorisation easy */
#line 3358
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3358
    ni=Min(nelems-j,LOOPCNT);
#line 3358
    if (realign) {
#line 3358
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3358
      xp = tmp;
#line 3358
    } else {
#line 3358
      xp = (uint *) *xpp;
#line 3358
    }
#line 3358
   /* copy the next block */
#line 3358
#pragma cdir loopcnt=LOOPCNT
#line 3358
#pragma cdir shortloop
#line 3358
    for (i=0; i<ni; i++) {
#line 3358
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3358
     /* test for range errors (not always needed but do it anyway) */
#line 3358
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3358
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3358
      nrange += xp[i] > DOUBLE_MAX ;
#line 3358
    }
#line 3358
   /* update xpp and tp */
#line 3358
    if (realign) xp = (uint *) *xpp;
#line 3358
    xp += ni;
#line 3358
    tp += ni;
#line 3358
    *xpp = (void*)xp;
#line 3358
  }
#line 3358
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3358

#line 3358
#else   /* not SX */
#line 3358
	const char *xp = (const char *) *xpp;
#line 3358
	int status = NC_NOERR;
#line 3358

#line 3358
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3358
	{
#line 3358
		const int lstatus = ncx_get_uint_double(xp, tp);
#line 3358
		if (status == NC_NOERR) /* report the first encountered error */
#line 3358
			status = lstatus;
#line 3358
	}
#line 3358

#line 3358
	*xpp = (const void *)xp;
#line 3358
	return status;
#line 3358
#endif
#line 3358
}
#line 3358

int
#line 3359
ncx_getn_uint_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3359
{
#line 3359
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3359

#line 3359
 /* basic algorithm is:
#line 3359
  *   - ensure sane alignment of input data
#line 3359
  *   - copy (conversion happens automatically) input data
#line 3359
  *     to output
#line 3359
  *   - update xpp to point at next unconverted input, and tp to point
#line 3359
  *     at next location for converted output
#line 3359
  */
#line 3359
  long i, j, ni;
#line 3359
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3359
  uint *xp;
#line 3359
  int nrange = 0;         /* number of range errors */
#line 3359
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3359
  long cxp = (long) *((char**)xpp);
#line 3359

#line 3359
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3359
  /* sjl: manually stripmine so we can limit amount of
#line 3359
   * vector work space reserved to LOOPCNT elements. Also
#line 3359
   * makes vectorisation easy */
#line 3359
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3359
    ni=Min(nelems-j,LOOPCNT);
#line 3359
    if (realign) {
#line 3359
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3359
      xp = tmp;
#line 3359
    } else {
#line 3359
      xp = (uint *) *xpp;
#line 3359
    }
#line 3359
   /* copy the next block */
#line 3359
#pragma cdir loopcnt=LOOPCNT
#line 3359
#pragma cdir shortloop
#line 3359
    for (i=0; i<ni; i++) {
#line 3359
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3359
     /* test for range errors (not always needed but do it anyway) */
#line 3359
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3359
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3359
      nrange += xp[i] > LONGLONG_MAX ;
#line 3359
    }
#line 3359
   /* update xpp and tp */
#line 3359
    if (realign) xp = (uint *) *xpp;
#line 3359
    xp += ni;
#line 3359
    tp += ni;
#line 3359
    *xpp = (void*)xp;
#line 3359
  }
#line 3359
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3359

#line 3359
#else   /* not SX */
#line 3359
	const char *xp = (const char *) *xpp;
#line 3359
	int status = NC_NOERR;
#line 3359

#line 3359
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3359
	{
#line 3359
		const int lstatus = ncx_get_uint_longlong(xp, tp);
#line 3359
		if (status == NC_NOERR) /* report the first encountered error */
#line 3359
			status = lstatus;
#line 3359
	}
#line 3359

#line 3359
	*xpp = (const void *)xp;
#line 3359
	return status;
#line 3359
#endif
#line 3359
}
#line 3359

int
#line 3360
ncx_getn_uint_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3360
{
#line 3360
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3360

#line 3360
 /* basic algorithm is:
#line 3360
  *   - ensure sane alignment of input data
#line 3360
  *   - copy (conversion happens automatically) input data
#line 3360
  *     to output
#line 3360
  *   - update xpp to point at next unconverted input, and tp to point
#line 3360
  *     at next location for converted output
#line 3360
  */
#line 3360
  long i, j, ni;
#line 3360
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3360
  uint *xp;
#line 3360
  int nrange = 0;         /* number of range errors */
#line 3360
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3360
  long cxp = (long) *((char**)xpp);
#line 3360

#line 3360
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3360
  /* sjl: manually stripmine so we can limit amount of
#line 3360
   * vector work space reserved to LOOPCNT elements. Also
#line 3360
   * makes vectorisation easy */
#line 3360
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3360
    ni=Min(nelems-j,LOOPCNT);
#line 3360
    if (realign) {
#line 3360
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3360
      xp = tmp;
#line 3360
    } else {
#line 3360
      xp = (uint *) *xpp;
#line 3360
    }
#line 3360
   /* copy the next block */
#line 3360
#pragma cdir loopcnt=LOOPCNT
#line 3360
#pragma cdir shortloop
#line 3360
    for (i=0; i<ni; i++) {
#line 3360
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3360
     /* test for range errors (not always needed but do it anyway) */
#line 3360
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3360
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3360
      nrange += xp[i] > UCHAR_MAX ;
#line 3360
    }
#line 3360
   /* update xpp and tp */
#line 3360
    if (realign) xp = (uint *) *xpp;
#line 3360
    xp += ni;
#line 3360
    tp += ni;
#line 3360
    *xpp = (void*)xp;
#line 3360
  }
#line 3360
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3360

#line 3360
#else   /* not SX */
#line 3360
	const char *xp = (const char *) *xpp;
#line 3360
	int status = NC_NOERR;
#line 3360

#line 3360
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3360
	{
#line 3360
		const int lstatus = ncx_get_uint_uchar(xp, tp);
#line 3360
		if (status == NC_NOERR) /* report the first encountered error */
#line 3360
			status = lstatus;
#line 3360
	}
#line 3360

#line 3360
	*xpp = (const void *)xp;
#line 3360
	return status;
#line 3360
#endif
#line 3360
}
#line 3360

int
#line 3361
ncx_getn_uint_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3361
{
#line 3361
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3361

#line 3361
 /* basic algorithm is:
#line 3361
  *   - ensure sane alignment of input data
#line 3361
  *   - copy (conversion happens automatically) input data
#line 3361
  *     to output
#line 3361
  *   - update xpp to point at next unconverted input, and tp to point
#line 3361
  *     at next location for converted output
#line 3361
  */
#line 3361
  long i, j, ni;
#line 3361
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3361
  uint *xp;
#line 3361
  int nrange = 0;         /* number of range errors */
#line 3361
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3361
  long cxp = (long) *((char**)xpp);
#line 3361

#line 3361
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3361
  /* sjl: manually stripmine so we can limit amount of
#line 3361
   * vector work space reserved to LOOPCNT elements. Also
#line 3361
   * makes vectorisation easy */
#line 3361
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3361
    ni=Min(nelems-j,LOOPCNT);
#line 3361
    if (realign) {
#line 3361
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3361
      xp = tmp;
#line 3361
    } else {
#line 3361
      xp = (uint *) *xpp;
#line 3361
    }
#line 3361
   /* copy the next block */
#line 3361
#pragma cdir loopcnt=LOOPCNT
#line 3361
#pragma cdir shortloop
#line 3361
    for (i=0; i<ni; i++) {
#line 3361
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3361
     /* test for range errors (not always needed but do it anyway) */
#line 3361
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3361
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3361
      nrange += xp[i] > USHORT_MAX ;
#line 3361
    }
#line 3361
   /* update xpp and tp */
#line 3361
    if (realign) xp = (uint *) *xpp;
#line 3361
    xp += ni;
#line 3361
    tp += ni;
#line 3361
    *xpp = (void*)xp;
#line 3361
  }
#line 3361
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3361

#line 3361
#else   /* not SX */
#line 3361
	const char *xp = (const char *) *xpp;
#line 3361
	int status = NC_NOERR;
#line 3361

#line 3361
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3361
	{
#line 3361
		const int lstatus = ncx_get_uint_ushort(xp, tp);
#line 3361
		if (status == NC_NOERR) /* report the first encountered error */
#line 3361
			status = lstatus;
#line 3361
	}
#line 3361

#line 3361
	*xpp = (const void *)xp;
#line 3361
	return status;
#line 3361
#endif
#line 3361
}
#line 3361

int
#line 3362
ncx_getn_uint_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3362
{
#line 3362
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3362

#line 3362
 /* basic algorithm is:
#line 3362
  *   - ensure sane alignment of input data
#line 3362
  *   - copy (conversion happens automatically) input data
#line 3362
  *     to output
#line 3362
  *   - update xpp to point at next unconverted input, and tp to point
#line 3362
  *     at next location for converted output
#line 3362
  */
#line 3362
  long i, j, ni;
#line 3362
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3362
  uint *xp;
#line 3362
  int nrange = 0;         /* number of range errors */
#line 3362
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3362
  long cxp = (long) *((char**)xpp);
#line 3362

#line 3362
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3362
  /* sjl: manually stripmine so we can limit amount of
#line 3362
   * vector work space reserved to LOOPCNT elements. Also
#line 3362
   * makes vectorisation easy */
#line 3362
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3362
    ni=Min(nelems-j,LOOPCNT);
#line 3362
    if (realign) {
#line 3362
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3362
      xp = tmp;
#line 3362
    } else {
#line 3362
      xp = (uint *) *xpp;
#line 3362
    }
#line 3362
   /* copy the next block */
#line 3362
#pragma cdir loopcnt=LOOPCNT
#line 3362
#pragma cdir shortloop
#line 3362
    for (i=0; i<ni; i++) {
#line 3362
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3362
     /* test for range errors (not always needed but do it anyway) */
#line 3362
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3362
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3362
      nrange += xp[i] > ULONGLONG_MAX ;
#line 3362
    }
#line 3362
   /* update xpp and tp */
#line 3362
    if (realign) xp = (uint *) *xpp;
#line 3362
    xp += ni;
#line 3362
    tp += ni;
#line 3362
    *xpp = (void*)xp;
#line 3362
  }
#line 3362
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3362

#line 3362
#else   /* not SX */
#line 3362
	const char *xp = (const char *) *xpp;
#line 3362
	int status = NC_NOERR;
#line 3362

#line 3362
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3362
	{
#line 3362
		const int lstatus = ncx_get_uint_ulonglong(xp, tp);
#line 3362
		if (status == NC_NOERR) /* report the first encountered error */
#line 3362
			status = lstatus;
#line 3362
	}
#line 3362

#line 3362
	*xpp = (const void *)xp;
#line 3362
	return status;
#line 3362
#endif
#line 3362
}
#line 3362


#if X_SIZEOF_UINT == SIZEOF_UINT
/* optimized version */
int
ncx_putn_uint_uint(void **xpp, size_t nelems, const unsigned int *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_UINT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_UINT);
	return NC_NOERR;
}
#else
int
#line 3378
ncx_putn_uint_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3378
{
#line 3378
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3378

#line 3378
 /* basic algorithm is:
#line 3378
  *   - ensure sane alignment of output data
#line 3378
  *   - copy (conversion happens automatically) input data
#line 3378
  *     to output
#line 3378
  *   - update tp to point at next unconverted input, and xpp to point
#line 3378
  *     at next location for converted output
#line 3378
  */
#line 3378
  long i, j, ni;
#line 3378
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3378
  uint *xp;
#line 3378
  int nrange = 0;         /* number of range errors */
#line 3378
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3378
  long cxp = (long) *((char**)xpp);
#line 3378

#line 3378
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3378
  /* sjl: manually stripmine so we can limit amount of
#line 3378
   * vector work space reserved to LOOPCNT elements. Also
#line 3378
   * makes vectorisation easy */
#line 3378
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3378
    ni=Min(nelems-j,LOOPCNT);
#line 3378
    if (realign) {
#line 3378
      xp = tmp;
#line 3378
    } else {
#line 3378
      xp = (uint *) *xpp;
#line 3378
    }
#line 3378
   /* copy the next block */
#line 3378
#pragma cdir loopcnt=LOOPCNT
#line 3378
#pragma cdir shortloop
#line 3378
    for (i=0; i<ni; i++) {
#line 3378
      /* the normal case: */
#line 3378
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3378
     /* test for range errors (not always needed but do it anyway) */
#line 3378
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3378
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3378
      nrange += tp[i] > X_UINT_MAX ;
#line 3378
    }
#line 3378
   /* copy workspace back if necessary */
#line 3378
    if (realign) {
#line 3378
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3378
      xp = (uint *) *xpp;
#line 3378
    }
#line 3378
   /* update xpp and tp */
#line 3378
    xp += ni;
#line 3378
    tp += ni;
#line 3378
    *xpp = (void*)xp;
#line 3378
  }
#line 3378
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3378

#line 3378
#else   /* not SX */
#line 3378

#line 3378
	char *xp = (char *) *xpp;
#line 3378
	int status = NC_NOERR;
#line 3378

#line 3378
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3378
	{
#line 3378
		int lstatus = ncx_put_uint_uint(xp, tp, fillp);
#line 3378
		if (status == NC_NOERR) /* report the first encountered error */
#line 3378
			status = lstatus;
#line 3378
	}
#line 3378

#line 3378
	*xpp = (void *)xp;
#line 3378
	return status;
#line 3378
#endif
#line 3378
}
#line 3378

#endif
int
#line 3380
ncx_putn_uint_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3380
{
#line 3380
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3380

#line 3380
 /* basic algorithm is:
#line 3380
  *   - ensure sane alignment of output data
#line 3380
  *   - copy (conversion happens automatically) input data
#line 3380
  *     to output
#line 3380
  *   - update tp to point at next unconverted input, and xpp to point
#line 3380
  *     at next location for converted output
#line 3380
  */
#line 3380
  long i, j, ni;
#line 3380
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3380
  uint *xp;
#line 3380
  int nrange = 0;         /* number of range errors */
#line 3380
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3380
  long cxp = (long) *((char**)xpp);
#line 3380

#line 3380
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3380
  /* sjl: manually stripmine so we can limit amount of
#line 3380
   * vector work space reserved to LOOPCNT elements. Also
#line 3380
   * makes vectorisation easy */
#line 3380
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3380
    ni=Min(nelems-j,LOOPCNT);
#line 3380
    if (realign) {
#line 3380
      xp = tmp;
#line 3380
    } else {
#line 3380
      xp = (uint *) *xpp;
#line 3380
    }
#line 3380
   /* copy the next block */
#line 3380
#pragma cdir loopcnt=LOOPCNT
#line 3380
#pragma cdir shortloop
#line 3380
    for (i=0; i<ni; i++) {
#line 3380
      /* the normal case: */
#line 3380
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3380
     /* test for range errors (not always needed but do it anyway) */
#line 3380
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3380
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3380
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3380
    }
#line 3380
   /* copy workspace back if necessary */
#line 3380
    if (realign) {
#line 3380
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3380
      xp = (uint *) *xpp;
#line 3380
    }
#line 3380
   /* update xpp and tp */
#line 3380
    xp += ni;
#line 3380
    tp += ni;
#line 3380
    *xpp = (void*)xp;
#line 3380
  }
#line 3380
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3380

#line 3380
#else   /* not SX */
#line 3380

#line 3380
	char *xp = (char *) *xpp;
#line 3380
	int status = NC_NOERR;
#line 3380

#line 3380
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3380
	{
#line 3380
		int lstatus = ncx_put_uint_schar(xp, tp, fillp);
#line 3380
		if (status == NC_NOERR) /* report the first encountered error */
#line 3380
			status = lstatus;
#line 3380
	}
#line 3380

#line 3380
	*xpp = (void *)xp;
#line 3380
	return status;
#line 3380
#endif
#line 3380
}
#line 3380

int
#line 3381
ncx_putn_uint_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3381
{
#line 3381
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3381

#line 3381
 /* basic algorithm is:
#line 3381
  *   - ensure sane alignment of output data
#line 3381
  *   - copy (conversion happens automatically) input data
#line 3381
  *     to output
#line 3381
  *   - update tp to point at next unconverted input, and xpp to point
#line 3381
  *     at next location for converted output
#line 3381
  */
#line 3381
  long i, j, ni;
#line 3381
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3381
  uint *xp;
#line 3381
  int nrange = 0;         /* number of range errors */
#line 3381
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3381
  long cxp = (long) *((char**)xpp);
#line 3381

#line 3381
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3381
  /* sjl: manually stripmine so we can limit amount of
#line 3381
   * vector work space reserved to LOOPCNT elements. Also
#line 3381
   * makes vectorisation easy */
#line 3381
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3381
    ni=Min(nelems-j,LOOPCNT);
#line 3381
    if (realign) {
#line 3381
      xp = tmp;
#line 3381
    } else {
#line 3381
      xp = (uint *) *xpp;
#line 3381
    }
#line 3381
   /* copy the next block */
#line 3381
#pragma cdir loopcnt=LOOPCNT
#line 3381
#pragma cdir shortloop
#line 3381
    for (i=0; i<ni; i++) {
#line 3381
      /* the normal case: */
#line 3381
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3381
     /* test for range errors (not always needed but do it anyway) */
#line 3381
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3381
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3381
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3381
    }
#line 3381
   /* copy workspace back if necessary */
#line 3381
    if (realign) {
#line 3381
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3381
      xp = (uint *) *xpp;
#line 3381
    }
#line 3381
   /* update xpp and tp */
#line 3381
    xp += ni;
#line 3381
    tp += ni;
#line 3381
    *xpp = (void*)xp;
#line 3381
  }
#line 3381
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3381

#line 3381
#else   /* not SX */
#line 3381

#line 3381
	char *xp = (char *) *xpp;
#line 3381
	int status = NC_NOERR;
#line 3381

#line 3381
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3381
	{
#line 3381
		int lstatus = ncx_put_uint_short(xp, tp, fillp);
#line 3381
		if (status == NC_NOERR) /* report the first encountered error */
#line 3381
			status = lstatus;
#line 3381
	}
#line 3381

#line 3381
	*xpp = (void *)xp;
#line 3381
	return status;
#line 3381
#endif
#line 3381
}
#line 3381

int
#line 3382
ncx_putn_uint_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3382
{
#line 3382
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3382

#line 3382
 /* basic algorithm is:
#line 3382
  *   - ensure sane alignment of output data
#line 3382
  *   - copy (conversion happens automatically) input data
#line 3382
  *     to output
#line 3382
  *   - update tp to point at next unconverted input, and xpp to point
#line 3382
  *     at next location for converted output
#line 3382
  */
#line 3382
  long i, j, ni;
#line 3382
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3382
  uint *xp;
#line 3382
  int nrange = 0;         /* number of range errors */
#line 3382
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3382
  long cxp = (long) *((char**)xpp);
#line 3382

#line 3382
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3382
  /* sjl: manually stripmine so we can limit amount of
#line 3382
   * vector work space reserved to LOOPCNT elements. Also
#line 3382
   * makes vectorisation easy */
#line 3382
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3382
    ni=Min(nelems-j,LOOPCNT);
#line 3382
    if (realign) {
#line 3382
      xp = tmp;
#line 3382
    } else {
#line 3382
      xp = (uint *) *xpp;
#line 3382
    }
#line 3382
   /* copy the next block */
#line 3382
#pragma cdir loopcnt=LOOPCNT
#line 3382
#pragma cdir shortloop
#line 3382
    for (i=0; i<ni; i++) {
#line 3382
      /* the normal case: */
#line 3382
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3382
     /* test for range errors (not always needed but do it anyway) */
#line 3382
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3382
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3382
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3382
    }
#line 3382
   /* copy workspace back if necessary */
#line 3382
    if (realign) {
#line 3382
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3382
      xp = (uint *) *xpp;
#line 3382
    }
#line 3382
   /* update xpp and tp */
#line 3382
    xp += ni;
#line 3382
    tp += ni;
#line 3382
    *xpp = (void*)xp;
#line 3382
  }
#line 3382
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3382

#line 3382
#else   /* not SX */
#line 3382

#line 3382
	char *xp = (char *) *xpp;
#line 3382
	int status = NC_NOERR;
#line 3382

#line 3382
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3382
	{
#line 3382
		int lstatus = ncx_put_uint_int(xp, tp, fillp);
#line 3382
		if (status == NC_NOERR) /* report the first encountered error */
#line 3382
			status = lstatus;
#line 3382
	}
#line 3382

#line 3382
	*xpp = (void *)xp;
#line 3382
	return status;
#line 3382
#endif
#line 3382
}
#line 3382

int
#line 3383
ncx_putn_uint_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3383
{
#line 3383
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3383

#line 3383
 /* basic algorithm is:
#line 3383
  *   - ensure sane alignment of output data
#line 3383
  *   - copy (conversion happens automatically) input data
#line 3383
  *     to output
#line 3383
  *   - update tp to point at next unconverted input, and xpp to point
#line 3383
  *     at next location for converted output
#line 3383
  */
#line 3383
  long i, j, ni;
#line 3383
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3383
  uint *xp;
#line 3383
  int nrange = 0;         /* number of range errors */
#line 3383
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3383
  long cxp = (long) *((char**)xpp);
#line 3383

#line 3383
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3383
  /* sjl: manually stripmine so we can limit amount of
#line 3383
   * vector work space reserved to LOOPCNT elements. Also
#line 3383
   * makes vectorisation easy */
#line 3383
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3383
    ni=Min(nelems-j,LOOPCNT);
#line 3383
    if (realign) {
#line 3383
      xp = tmp;
#line 3383
    } else {
#line 3383
      xp = (uint *) *xpp;
#line 3383
    }
#line 3383
   /* copy the next block */
#line 3383
#pragma cdir loopcnt=LOOPCNT
#line 3383
#pragma cdir shortloop
#line 3383
    for (i=0; i<ni; i++) {
#line 3383
      /* the normal case: */
#line 3383
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3383
     /* test for range errors (not always needed but do it anyway) */
#line 3383
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3383
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3383
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3383
    }
#line 3383
   /* copy workspace back if necessary */
#line 3383
    if (realign) {
#line 3383
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3383
      xp = (uint *) *xpp;
#line 3383
    }
#line 3383
   /* update xpp and tp */
#line 3383
    xp += ni;
#line 3383
    tp += ni;
#line 3383
    *xpp = (void*)xp;
#line 3383
  }
#line 3383
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3383

#line 3383
#else   /* not SX */
#line 3383

#line 3383
	char *xp = (char *) *xpp;
#line 3383
	int status = NC_NOERR;
#line 3383

#line 3383
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3383
	{
#line 3383
		int lstatus = ncx_put_uint_long(xp, tp, fillp);
#line 3383
		if (status == NC_NOERR) /* report the first encountered error */
#line 3383
			status = lstatus;
#line 3383
	}
#line 3383

#line 3383
	*xpp = (void *)xp;
#line 3383
	return status;
#line 3383
#endif
#line 3383
}
#line 3383

int
#line 3384
ncx_putn_uint_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3384
{
#line 3384
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3384

#line 3384
 /* basic algorithm is:
#line 3384
  *   - ensure sane alignment of output data
#line 3384
  *   - copy (conversion happens automatically) input data
#line 3384
  *     to output
#line 3384
  *   - update tp to point at next unconverted input, and xpp to point
#line 3384
  *     at next location for converted output
#line 3384
  */
#line 3384
  long i, j, ni;
#line 3384
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3384
  uint *xp;
#line 3384
  int nrange = 0;         /* number of range errors */
#line 3384
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3384
  long cxp = (long) *((char**)xpp);
#line 3384

#line 3384
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3384
  /* sjl: manually stripmine so we can limit amount of
#line 3384
   * vector work space reserved to LOOPCNT elements. Also
#line 3384
   * makes vectorisation easy */
#line 3384
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3384
    ni=Min(nelems-j,LOOPCNT);
#line 3384
    if (realign) {
#line 3384
      xp = tmp;
#line 3384
    } else {
#line 3384
      xp = (uint *) *xpp;
#line 3384
    }
#line 3384
   /* copy the next block */
#line 3384
#pragma cdir loopcnt=LOOPCNT
#line 3384
#pragma cdir shortloop
#line 3384
    for (i=0; i<ni; i++) {
#line 3384
      /* the normal case: */
#line 3384
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3384
     /* test for range errors (not always needed but do it anyway) */
#line 3384
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3384
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3384
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3384
    }
#line 3384
   /* copy workspace back if necessary */
#line 3384
    if (realign) {
#line 3384
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3384
      xp = (uint *) *xpp;
#line 3384
    }
#line 3384
   /* update xpp and tp */
#line 3384
    xp += ni;
#line 3384
    tp += ni;
#line 3384
    *xpp = (void*)xp;
#line 3384
  }
#line 3384
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3384

#line 3384
#else   /* not SX */
#line 3384

#line 3384
	char *xp = (char *) *xpp;
#line 3384
	int status = NC_NOERR;
#line 3384

#line 3384
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3384
	{
#line 3384
		int lstatus = ncx_put_uint_float(xp, tp, fillp);
#line 3384
		if (status == NC_NOERR) /* report the first encountered error */
#line 3384
			status = lstatus;
#line 3384
	}
#line 3384

#line 3384
	*xpp = (void *)xp;
#line 3384
	return status;
#line 3384
#endif
#line 3384
}
#line 3384

int
#line 3385
ncx_putn_uint_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3385
{
#line 3385
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3385

#line 3385
 /* basic algorithm is:
#line 3385
  *   - ensure sane alignment of output data
#line 3385
  *   - copy (conversion happens automatically) input data
#line 3385
  *     to output
#line 3385
  *   - update tp to point at next unconverted input, and xpp to point
#line 3385
  *     at next location for converted output
#line 3385
  */
#line 3385
  long i, j, ni;
#line 3385
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3385
  uint *xp;
#line 3385
  int nrange = 0;         /* number of range errors */
#line 3385
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3385
  long cxp = (long) *((char**)xpp);
#line 3385

#line 3385
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3385
  /* sjl: manually stripmine so we can limit amount of
#line 3385
   * vector work space reserved to LOOPCNT elements. Also
#line 3385
   * makes vectorisation easy */
#line 3385
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3385
    ni=Min(nelems-j,LOOPCNT);
#line 3385
    if (realign) {
#line 3385
      xp = tmp;
#line 3385
    } else {
#line 3385
      xp = (uint *) *xpp;
#line 3385
    }
#line 3385
   /* copy the next block */
#line 3385
#pragma cdir loopcnt=LOOPCNT
#line 3385
#pragma cdir shortloop
#line 3385
    for (i=0; i<ni; i++) {
#line 3385
      /* the normal case: */
#line 3385
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3385
     /* test for range errors (not always needed but do it anyway) */
#line 3385
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3385
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3385
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3385
    }
#line 3385
   /* copy workspace back if necessary */
#line 3385
    if (realign) {
#line 3385
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3385
      xp = (uint *) *xpp;
#line 3385
    }
#line 3385
   /* update xpp and tp */
#line 3385
    xp += ni;
#line 3385
    tp += ni;
#line 3385
    *xpp = (void*)xp;
#line 3385
  }
#line 3385
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3385

#line 3385
#else   /* not SX */
#line 3385

#line 3385
	char *xp = (char *) *xpp;
#line 3385
	int status = NC_NOERR;
#line 3385

#line 3385
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3385
	{
#line 3385
		int lstatus = ncx_put_uint_double(xp, tp, fillp);
#line 3385
		if (status == NC_NOERR) /* report the first encountered error */
#line 3385
			status = lstatus;
#line 3385
	}
#line 3385

#line 3385
	*xpp = (void *)xp;
#line 3385
	return status;
#line 3385
#endif
#line 3385
}
#line 3385

int
#line 3386
ncx_putn_uint_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3386
{
#line 3386
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3386

#line 3386
 /* basic algorithm is:
#line 3386
  *   - ensure sane alignment of output data
#line 3386
  *   - copy (conversion happens automatically) input data
#line 3386
  *     to output
#line 3386
  *   - update tp to point at next unconverted input, and xpp to point
#line 3386
  *     at next location for converted output
#line 3386
  */
#line 3386
  long i, j, ni;
#line 3386
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3386
  uint *xp;
#line 3386
  int nrange = 0;         /* number of range errors */
#line 3386
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3386
  long cxp = (long) *((char**)xpp);
#line 3386

#line 3386
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3386
  /* sjl: manually stripmine so we can limit amount of
#line 3386
   * vector work space reserved to LOOPCNT elements. Also
#line 3386
   * makes vectorisation easy */
#line 3386
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3386
    ni=Min(nelems-j,LOOPCNT);
#line 3386
    if (realign) {
#line 3386
      xp = tmp;
#line 3386
    } else {
#line 3386
      xp = (uint *) *xpp;
#line 3386
    }
#line 3386
   /* copy the next block */
#line 3386
#pragma cdir loopcnt=LOOPCNT
#line 3386
#pragma cdir shortloop
#line 3386
    for (i=0; i<ni; i++) {
#line 3386
      /* the normal case: */
#line 3386
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3386
     /* test for range errors (not always needed but do it anyway) */
#line 3386
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3386
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3386
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3386
    }
#line 3386
   /* copy workspace back if necessary */
#line 3386
    if (realign) {
#line 3386
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3386
      xp = (uint *) *xpp;
#line 3386
    }
#line 3386
   /* update xpp and tp */
#line 3386
    xp += ni;
#line 3386
    tp += ni;
#line 3386
    *xpp = (void*)xp;
#line 3386
  }
#line 3386
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3386

#line 3386
#else   /* not SX */
#line 3386

#line 3386
	char *xp = (char *) *xpp;
#line 3386
	int status = NC_NOERR;
#line 3386

#line 3386
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3386
	{
#line 3386
		int lstatus = ncx_put_uint_longlong(xp, tp, fillp);
#line 3386
		if (status == NC_NOERR) /* report the first encountered error */
#line 3386
			status = lstatus;
#line 3386
	}
#line 3386

#line 3386
	*xpp = (void *)xp;
#line 3386
	return status;
#line 3386
#endif
#line 3386
}
#line 3386

int
#line 3387
ncx_putn_uint_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3387
{
#line 3387
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3387

#line 3387
 /* basic algorithm is:
#line 3387
  *   - ensure sane alignment of output data
#line 3387
  *   - copy (conversion happens automatically) input data
#line 3387
  *     to output
#line 3387
  *   - update tp to point at next unconverted input, and xpp to point
#line 3387
  *     at next location for converted output
#line 3387
  */
#line 3387
  long i, j, ni;
#line 3387
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3387
  uint *xp;
#line 3387
  int nrange = 0;         /* number of range errors */
#line 3387
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3387
  long cxp = (long) *((char**)xpp);
#line 3387

#line 3387
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3387
  /* sjl: manually stripmine so we can limit amount of
#line 3387
   * vector work space reserved to LOOPCNT elements. Also
#line 3387
   * makes vectorisation easy */
#line 3387
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3387
    ni=Min(nelems-j,LOOPCNT);
#line 3387
    if (realign) {
#line 3387
      xp = tmp;
#line 3387
    } else {
#line 3387
      xp = (uint *) *xpp;
#line 3387
    }
#line 3387
   /* copy the next block */
#line 3387
#pragma cdir loopcnt=LOOPCNT
#line 3387
#pragma cdir shortloop
#line 3387
    for (i=0; i<ni; i++) {
#line 3387
      /* the normal case: */
#line 3387
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3387
     /* test for range errors (not always needed but do it anyway) */
#line 3387
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3387
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3387
      nrange += tp[i] > X_UINT_MAX ;
#line 3387
    }
#line 3387
   /* copy workspace back if necessary */
#line 3387
    if (realign) {
#line 3387
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3387
      xp = (uint *) *xpp;
#line 3387
    }
#line 3387
   /* update xpp and tp */
#line 3387
    xp += ni;
#line 3387
    tp += ni;
#line 3387
    *xpp = (void*)xp;
#line 3387
  }
#line 3387
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3387

#line 3387
#else   /* not SX */
#line 3387

#line 3387
	char *xp = (char *) *xpp;
#line 3387
	int status = NC_NOERR;
#line 3387

#line 3387
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3387
	{
#line 3387
		int lstatus = ncx_put_uint_uchar(xp, tp, fillp);
#line 3387
		if (status == NC_NOERR) /* report the first encountered error */
#line 3387
			status = lstatus;
#line 3387
	}
#line 3387

#line 3387
	*xpp = (void *)xp;
#line 3387
	return status;
#line 3387
#endif
#line 3387
}
#line 3387

int
#line 3388
ncx_putn_uint_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3388
{
#line 3388
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3388

#line 3388
 /* basic algorithm is:
#line 3388
  *   - ensure sane alignment of output data
#line 3388
  *   - copy (conversion happens automatically) input data
#line 3388
  *     to output
#line 3388
  *   - update tp to point at next unconverted input, and xpp to point
#line 3388
  *     at next location for converted output
#line 3388
  */
#line 3388
  long i, j, ni;
#line 3388
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3388
  uint *xp;
#line 3388
  int nrange = 0;         /* number of range errors */
#line 3388
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3388
  long cxp = (long) *((char**)xpp);
#line 3388

#line 3388
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3388
  /* sjl: manually stripmine so we can limit amount of
#line 3388
   * vector work space reserved to LOOPCNT elements. Also
#line 3388
   * makes vectorisation easy */
#line 3388
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3388
    ni=Min(nelems-j,LOOPCNT);
#line 3388
    if (realign) {
#line 3388
      xp = tmp;
#line 3388
    } else {
#line 3388
      xp = (uint *) *xpp;
#line 3388
    }
#line 3388
   /* copy the next block */
#line 3388
#pragma cdir loopcnt=LOOPCNT
#line 3388
#pragma cdir shortloop
#line 3388
    for (i=0; i<ni; i++) {
#line 3388
      /* the normal case: */
#line 3388
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3388
     /* test for range errors (not always needed but do it anyway) */
#line 3388
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3388
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3388
      nrange += tp[i] > X_UINT_MAX ;
#line 3388
    }
#line 3388
   /* copy workspace back if necessary */
#line 3388
    if (realign) {
#line 3388
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3388
      xp = (uint *) *xpp;
#line 3388
    }
#line 3388
   /* update xpp and tp */
#line 3388
    xp += ni;
#line 3388
    tp += ni;
#line 3388
    *xpp = (void*)xp;
#line 3388
  }
#line 3388
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3388

#line 3388
#else   /* not SX */
#line 3388

#line 3388
	char *xp = (char *) *xpp;
#line 3388
	int status = NC_NOERR;
#line 3388

#line 3388
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3388
	{
#line 3388
		int lstatus = ncx_put_uint_ushort(xp, tp, fillp);
#line 3388
		if (status == NC_NOERR) /* report the first encountered error */
#line 3388
			status = lstatus;
#line 3388
	}
#line 3388

#line 3388
	*xpp = (void *)xp;
#line 3388
	return status;
#line 3388
#endif
#line 3388
}
#line 3388

int
#line 3389
ncx_putn_uint_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3389
{
#line 3389
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3389

#line 3389
 /* basic algorithm is:
#line 3389
  *   - ensure sane alignment of output data
#line 3389
  *   - copy (conversion happens automatically) input data
#line 3389
  *     to output
#line 3389
  *   - update tp to point at next unconverted input, and xpp to point
#line 3389
  *     at next location for converted output
#line 3389
  */
#line 3389
  long i, j, ni;
#line 3389
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3389
  uint *xp;
#line 3389
  int nrange = 0;         /* number of range errors */
#line 3389
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3389
  long cxp = (long) *((char**)xpp);
#line 3389

#line 3389
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3389
  /* sjl: manually stripmine so we can limit amount of
#line 3389
   * vector work space reserved to LOOPCNT elements. Also
#line 3389
   * makes vectorisation easy */
#line 3389
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3389
    ni=Min(nelems-j,LOOPCNT);
#line 3389
    if (realign) {
#line 3389
      xp = tmp;
#line 3389
    } else {
#line 3389
      xp = (uint *) *xpp;
#line 3389
    }
#line 3389
   /* copy the next block */
#line 3389
#pragma cdir loopcnt=LOOPCNT
#line 3389
#pragma cdir shortloop
#line 3389
    for (i=0; i<ni; i++) {
#line 3389
      /* the normal case: */
#line 3389
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3389
     /* test for range errors (not always needed but do it anyway) */
#line 3389
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3389
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3389
      nrange += tp[i] > X_UINT_MAX ;
#line 3389
    }
#line 3389
   /* copy workspace back if necessary */
#line 3389
    if (realign) {
#line 3389
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3389
      xp = (uint *) *xpp;
#line 3389
    }
#line 3389
   /* update xpp and tp */
#line 3389
    xp += ni;
#line 3389
    tp += ni;
#line 3389
    *xpp = (void*)xp;
#line 3389
  }
#line 3389
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3389

#line 3389
#else   /* not SX */
#line 3389

#line 3389
	char *xp = (char *) *xpp;
#line 3389
	int status = NC_NOERR;
#line 3389

#line 3389
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3389
	{
#line 3389
		int lstatus = ncx_put_uint_ulonglong(xp, tp, fillp);
#line 3389
		if (status == NC_NOERR) /* report the first encountered error */
#line 3389
			status = lstatus;
#line 3389
	}
#line 3389

#line 3389
	*xpp = (void *)xp;
#line 3389
	return status;
#line 3389
#endif
#line 3389
}
#line 3389



/* float ---------------------------------------------------------------------*/

#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_getn_float_float(const void **xpp, size_t nelems, float *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_FLOAT);
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_FLOAT);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
int
ncx_getn_float_float(const void **xpp, size_t nfloats, float *ip)
{
	float *const end = ip + nfloats;

	while (ip < end)
	{
		struct vax_single *const vsp = (struct vax_single *) ip;
#line 3415
		const struct ieee_single *const isp =
#line 3415
			 (const struct ieee_single *) (*xpp);
#line 3415
		unsigned exp = isp->exp_hi << 1 | isp->exp_lo;
#line 3415

#line 3415
		switch(exp) {
#line 3415
		case 0 :
#line 3415
			/* ieee subnormal */
#line 3415
			if (isp->mant_hi == min.ieee.mant_hi
#line 3415
				&& isp->mant_lo_hi == min.ieee.mant_lo_hi
#line 3415
				&& isp->mant_lo_lo == min.ieee.mant_lo_lo)
#line 3415
			{
#line 3415
				*vsp = min.s;
#line 3415
			}
#line 3415
			else
#line 3415
			{
#line 3415
				unsigned mantissa = (isp->mant_hi << 16)
#line 3415
					 | isp->mant_lo_hi << 8
#line 3415
					 | isp->mant_lo_lo;
#line 3415
				unsigned tmp = mantissa >> 20;
#line 3415
				if (tmp >= 4) {
#line 3415
					vsp->exp = 2;
#line 3415
				} else if (tmp >= 2) {
#line 3415
					vsp->exp = 1;
#line 3415
				} else {
#line 3415
					*vsp = min.s;
#line 3415
					break;
#line 3415
				} /* else */
#line 3415
				tmp = mantissa - (1 << (20 + vsp->exp ));
#line 3415
				tmp <<= 3 - vsp->exp;
#line 3415
				vsp->mantissa2 = tmp;
#line 3415
				vsp->mantissa1 = (tmp >> 16);
#line 3415
			}
#line 3415
			break;
#line 3415
		case 0xfe :
#line 3415
		case 0xff :
#line 3415
			*vsp = max.s;
#line 3415
			break;
#line 3415
		default :
#line 3415
			vsp->exp = exp - IEEE_SNG_BIAS + VAX_SNG_BIAS;
#line 3415
			vsp->mantissa2 = isp->mant_lo_hi << 8 | isp->mant_lo_lo;
#line 3415
			vsp->mantissa1 = isp->mant_hi;
#line 3415
		}
#line 3415

#line 3415
		vsp->sign = isp->sign;
#line 3415


		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_FLOAT;
	}
	return NC_NOERR;
}
#else
int
ncx_getn_float_float(const void **xpp, size_t nelems, float *tp)
{
	const char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		const int lstatus = ncx_get_float_float(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
}

#endif
int
#line 3441
ncx_getn_float_schar(const void **xpp, size_t nelems, schar *tp)
#line 3441
{
#line 3441
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3441

#line 3441
 /* basic algorithm is:
#line 3441
  *   - ensure sane alignment of input data
#line 3441
  *   - copy (conversion happens automatically) input data
#line 3441
  *     to output
#line 3441
  *   - update xpp to point at next unconverted input, and tp to point
#line 3441
  *     at next location for converted output
#line 3441
  */
#line 3441
  long i, j, ni;
#line 3441
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3441
  float *xp;
#line 3441
  int nrange = 0;         /* number of range errors */
#line 3441
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3441
  long cxp = (long) *((char**)xpp);
#line 3441

#line 3441
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3441
  /* sjl: manually stripmine so we can limit amount of
#line 3441
   * vector work space reserved to LOOPCNT elements. Also
#line 3441
   * makes vectorisation easy */
#line 3441
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3441
    ni=Min(nelems-j,LOOPCNT);
#line 3441
    if (realign) {
#line 3441
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3441
      xp = tmp;
#line 3441
    } else {
#line 3441
      xp = (float *) *xpp;
#line 3441
    }
#line 3441
   /* copy the next block */
#line 3441
#pragma cdir loopcnt=LOOPCNT
#line 3441
#pragma cdir shortloop
#line 3441
    for (i=0; i<ni; i++) {
#line 3441
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3441
     /* test for range errors (not always needed but do it anyway) */
#line 3441
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3441
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3441
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3441
    }
#line 3441
   /* update xpp and tp */
#line 3441
    if (realign) xp = (float *) *xpp;
#line 3441
    xp += ni;
#line 3441
    tp += ni;
#line 3441
    *xpp = (void*)xp;
#line 3441
  }
#line 3441
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3441

#line 3441
#else   /* not SX */
#line 3441
	const char *xp = (const char *) *xpp;
#line 3441
	int status = NC_NOERR;
#line 3441

#line 3441
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3441
	{
#line 3441
		const int lstatus = ncx_get_float_schar(xp, tp);
#line 3441
		if (status == NC_NOERR) /* report the first encountered error */
#line 3441
			status = lstatus;
#line 3441
	}
#line 3441

#line 3441
	*xpp = (const void *)xp;
#line 3441
	return status;
#line 3441
#endif
#line 3441
}
#line 3441

int
#line 3442
ncx_getn_float_short(const void **xpp, size_t nelems, short *tp)
#line 3442
{
#line 3442
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3442

#line 3442
 /* basic algorithm is:
#line 3442
  *   - ensure sane alignment of input data
#line 3442
  *   - copy (conversion happens automatically) input data
#line 3442
  *     to output
#line 3442
  *   - update xpp to point at next unconverted input, and tp to point
#line 3442
  *     at next location for converted output
#line 3442
  */
#line 3442
  long i, j, ni;
#line 3442
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3442
  float *xp;
#line 3442
  int nrange = 0;         /* number of range errors */
#line 3442
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3442
  long cxp = (long) *((char**)xpp);
#line 3442

#line 3442
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3442
  /* sjl: manually stripmine so we can limit amount of
#line 3442
   * vector work space reserved to LOOPCNT elements. Also
#line 3442
   * makes vectorisation easy */
#line 3442
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3442
    ni=Min(nelems-j,LOOPCNT);
#line 3442
    if (realign) {
#line 3442
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3442
      xp = tmp;
#line 3442
    } else {
#line 3442
      xp = (float *) *xpp;
#line 3442
    }
#line 3442
   /* copy the next block */
#line 3442
#pragma cdir loopcnt=LOOPCNT
#line 3442
#pragma cdir shortloop
#line 3442
    for (i=0; i<ni; i++) {
#line 3442
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3442
     /* test for range errors (not always needed but do it anyway) */
#line 3442
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3442
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3442
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3442
    }
#line 3442
   /* update xpp and tp */
#line 3442
    if (realign) xp = (float *) *xpp;
#line 3442
    xp += ni;
#line 3442
    tp += ni;
#line 3442
    *xpp = (void*)xp;
#line 3442
  }
#line 3442
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3442

#line 3442
#else   /* not SX */
#line 3442
	const char *xp = (const char *) *xpp;
#line 3442
	int status = NC_NOERR;
#line 3442

#line 3442
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3442
	{
#line 3442
		const int lstatus = ncx_get_float_short(xp, tp);
#line 3442
		if (status == NC_NOERR) /* report the first encountered error */
#line 3442
			status = lstatus;
#line 3442
	}
#line 3442

#line 3442
	*xpp = (const void *)xp;
#line 3442
	return status;
#line 3442
#endif
#line 3442
}
#line 3442

int
#line 3443
ncx_getn_float_int(const void **xpp, size_t nelems, int *tp)
#line 3443
{
#line 3443
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3443

#line 3443
 /* basic algorithm is:
#line 3443
  *   - ensure sane alignment of input data
#line 3443
  *   - copy (conversion happens automatically) input data
#line 3443
  *     to output
#line 3443
  *   - update xpp to point at next unconverted input, and tp to point
#line 3443
  *     at next location for converted output
#line 3443
  */
#line 3443
  long i, j, ni;
#line 3443
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3443
  float *xp;
#line 3443
  int nrange = 0;         /* number of range errors */
#line 3443
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3443
  long cxp = (long) *((char**)xpp);
#line 3443

#line 3443
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3443
  /* sjl: manually stripmine so we can limit amount of
#line 3443
   * vector work space reserved to LOOPCNT elements. Also
#line 3443
   * makes vectorisation easy */
#line 3443
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3443
    ni=Min(nelems-j,LOOPCNT);
#line 3443
    if (realign) {
#line 3443
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3443
      xp = tmp;
#line 3443
    } else {
#line 3443
      xp = (float *) *xpp;
#line 3443
    }
#line 3443
   /* copy the next block */
#line 3443
#pragma cdir loopcnt=LOOPCNT
#line 3443
#pragma cdir shortloop
#line 3443
    for (i=0; i<ni; i++) {
#line 3443
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3443
     /* test for range errors (not always needed but do it anyway) */
#line 3443
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3443
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3443
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3443
    }
#line 3443
   /* update xpp and tp */
#line 3443
    if (realign) xp = (float *) *xpp;
#line 3443
    xp += ni;
#line 3443
    tp += ni;
#line 3443
    *xpp = (void*)xp;
#line 3443
  }
#line 3443
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3443

#line 3443
#else   /* not SX */
#line 3443
	const char *xp = (const char *) *xpp;
#line 3443
	int status = NC_NOERR;
#line 3443

#line 3443
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3443
	{
#line 3443
		const int lstatus = ncx_get_float_int(xp, tp);
#line 3443
		if (status == NC_NOERR) /* report the first encountered error */
#line 3443
			status = lstatus;
#line 3443
	}
#line 3443

#line 3443
	*xpp = (const void *)xp;
#line 3443
	return status;
#line 3443
#endif
#line 3443
}
#line 3443

int
#line 3444
ncx_getn_float_long(const void **xpp, size_t nelems, long *tp)
#line 3444
{
#line 3444
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3444

#line 3444
 /* basic algorithm is:
#line 3444
  *   - ensure sane alignment of input data
#line 3444
  *   - copy (conversion happens automatically) input data
#line 3444
  *     to output
#line 3444
  *   - update xpp to point at next unconverted input, and tp to point
#line 3444
  *     at next location for converted output
#line 3444
  */
#line 3444
  long i, j, ni;
#line 3444
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3444
  float *xp;
#line 3444
  int nrange = 0;         /* number of range errors */
#line 3444
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3444
  long cxp = (long) *((char**)xpp);
#line 3444

#line 3444
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3444
  /* sjl: manually stripmine so we can limit amount of
#line 3444
   * vector work space reserved to LOOPCNT elements. Also
#line 3444
   * makes vectorisation easy */
#line 3444
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3444
    ni=Min(nelems-j,LOOPCNT);
#line 3444
    if (realign) {
#line 3444
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3444
      xp = tmp;
#line 3444
    } else {
#line 3444
      xp = (float *) *xpp;
#line 3444
    }
#line 3444
   /* copy the next block */
#line 3444
#pragma cdir loopcnt=LOOPCNT
#line 3444
#pragma cdir shortloop
#line 3444
    for (i=0; i<ni; i++) {
#line 3444
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3444
     /* test for range errors (not always needed but do it anyway) */
#line 3444
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3444
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3444
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3444
    }
#line 3444
   /* update xpp and tp */
#line 3444
    if (realign) xp = (float *) *xpp;
#line 3444
    xp += ni;
#line 3444
    tp += ni;
#line 3444
    *xpp = (void*)xp;
#line 3444
  }
#line 3444
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3444

#line 3444
#else   /* not SX */
#line 3444
	const char *xp = (const char *) *xpp;
#line 3444
	int status = NC_NOERR;
#line 3444

#line 3444
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3444
	{
#line 3444
		const int lstatus = ncx_get_float_long(xp, tp);
#line 3444
		if (status == NC_NOERR) /* report the first encountered error */
#line 3444
			status = lstatus;
#line 3444
	}
#line 3444

#line 3444
	*xpp = (const void *)xp;
#line 3444
	return status;
#line 3444
#endif
#line 3444
}
#line 3444

int
#line 3445
ncx_getn_float_double(const void **xpp, size_t nelems, double *tp)
#line 3445
{
#line 3445
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3445

#line 3445
 /* basic algorithm is:
#line 3445
  *   - ensure sane alignment of input data
#line 3445
  *   - copy (conversion happens automatically) input data
#line 3445
  *     to output
#line 3445
  *   - update xpp to point at next unconverted input, and tp to point
#line 3445
  *     at next location for converted output
#line 3445
  */
#line 3445
  long i, j, ni;
#line 3445
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3445
  float *xp;
#line 3445
  int nrange = 0;         /* number of range errors */
#line 3445
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3445
  long cxp = (long) *((char**)xpp);
#line 3445

#line 3445
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3445
  /* sjl: manually stripmine so we can limit amount of
#line 3445
   * vector work space reserved to LOOPCNT elements. Also
#line 3445
   * makes vectorisation easy */
#line 3445
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3445
    ni=Min(nelems-j,LOOPCNT);
#line 3445
    if (realign) {
#line 3445
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3445
      xp = tmp;
#line 3445
    } else {
#line 3445
      xp = (float *) *xpp;
#line 3445
    }
#line 3445
   /* copy the next block */
#line 3445
#pragma cdir loopcnt=LOOPCNT
#line 3445
#pragma cdir shortloop
#line 3445
    for (i=0; i<ni; i++) {
#line 3445
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3445
     /* test for range errors (not always needed but do it anyway) */
#line 3445
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3445
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3445
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3445
    }
#line 3445
   /* update xpp and tp */
#line 3445
    if (realign) xp = (float *) *xpp;
#line 3445
    xp += ni;
#line 3445
    tp += ni;
#line 3445
    *xpp = (void*)xp;
#line 3445
  }
#line 3445
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3445

#line 3445
#else   /* not SX */
#line 3445
	const char *xp = (const char *) *xpp;
#line 3445
	int status = NC_NOERR;
#line 3445

#line 3445
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3445
	{
#line 3445
		const int lstatus = ncx_get_float_double(xp, tp);
#line 3445
		if (status == NC_NOERR) /* report the first encountered error */
#line 3445
			status = lstatus;
#line 3445
	}
#line 3445

#line 3445
	*xpp = (const void *)xp;
#line 3445
	return status;
#line 3445
#endif
#line 3445
}
#line 3445

int
#line 3446
ncx_getn_float_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3446
{
#line 3446
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3446

#line 3446
 /* basic algorithm is:
#line 3446
  *   - ensure sane alignment of input data
#line 3446
  *   - copy (conversion happens automatically) input data
#line 3446
  *     to output
#line 3446
  *   - update xpp to point at next unconverted input, and tp to point
#line 3446
  *     at next location for converted output
#line 3446
  */
#line 3446
  long i, j, ni;
#line 3446
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3446
  float *xp;
#line 3446
  int nrange = 0;         /* number of range errors */
#line 3446
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3446
  long cxp = (long) *((char**)xpp);
#line 3446

#line 3446
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3446
  /* sjl: manually stripmine so we can limit amount of
#line 3446
   * vector work space reserved to LOOPCNT elements. Also
#line 3446
   * makes vectorisation easy */
#line 3446
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3446
    ni=Min(nelems-j,LOOPCNT);
#line 3446
    if (realign) {
#line 3446
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3446
      xp = tmp;
#line 3446
    } else {
#line 3446
      xp = (float *) *xpp;
#line 3446
    }
#line 3446
   /* copy the next block */
#line 3446
#pragma cdir loopcnt=LOOPCNT
#line 3446
#pragma cdir shortloop
#line 3446
    for (i=0; i<ni; i++) {
#line 3446
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3446
     /* test for range errors (not always needed but do it anyway) */
#line 3446
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3446
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3446
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3446
    }
#line 3446
   /* update xpp and tp */
#line 3446
    if (realign) xp = (float *) *xpp;
#line 3446
    xp += ni;
#line 3446
    tp += ni;
#line 3446
    *xpp = (void*)xp;
#line 3446
  }
#line 3446
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3446

#line 3446
#else   /* not SX */
#line 3446
	const char *xp = (const char *) *xpp;
#line 3446
	int status = NC_NOERR;
#line 3446

#line 3446
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3446
	{
#line 3446
		const int lstatus = ncx_get_float_longlong(xp, tp);
#line 3446
		if (status == NC_NOERR) /* report the first encountered error */
#line 3446
			status = lstatus;
#line 3446
	}
#line 3446

#line 3446
	*xpp = (const void *)xp;
#line 3446
	return status;
#line 3446
#endif
#line 3446
}
#line 3446

int
#line 3447
ncx_getn_float_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3447
{
#line 3447
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3447

#line 3447
 /* basic algorithm is:
#line 3447
  *   - ensure sane alignment of input data
#line 3447
  *   - copy (conversion happens automatically) input data
#line 3447
  *     to output
#line 3447
  *   - update xpp to point at next unconverted input, and tp to point
#line 3447
  *     at next location for converted output
#line 3447
  */
#line 3447
  long i, j, ni;
#line 3447
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3447
  float *xp;
#line 3447
  int nrange = 0;         /* number of range errors */
#line 3447
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3447
  long cxp = (long) *((char**)xpp);
#line 3447

#line 3447
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3447
  /* sjl: manually stripmine so we can limit amount of
#line 3447
   * vector work space reserved to LOOPCNT elements. Also
#line 3447
   * makes vectorisation easy */
#line 3447
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3447
    ni=Min(nelems-j,LOOPCNT);
#line 3447
    if (realign) {
#line 3447
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3447
      xp = tmp;
#line 3447
    } else {
#line 3447
      xp = (float *) *xpp;
#line 3447
    }
#line 3447
   /* copy the next block */
#line 3447
#pragma cdir loopcnt=LOOPCNT
#line 3447
#pragma cdir shortloop
#line 3447
    for (i=0; i<ni; i++) {
#line 3447
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3447
     /* test for range errors (not always needed but do it anyway) */
#line 3447
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3447
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3447
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3447
    }
#line 3447
   /* update xpp and tp */
#line 3447
    if (realign) xp = (float *) *xpp;
#line 3447
    xp += ni;
#line 3447
    tp += ni;
#line 3447
    *xpp = (void*)xp;
#line 3447
  }
#line 3447
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3447

#line 3447
#else   /* not SX */
#line 3447
	const char *xp = (const char *) *xpp;
#line 3447
	int status = NC_NOERR;
#line 3447

#line 3447
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3447
	{
#line 3447
		const int lstatus = ncx_get_float_ushort(xp, tp);
#line 3447
		if (status == NC_NOERR) /* report the first encountered error */
#line 3447
			status = lstatus;
#line 3447
	}
#line 3447

#line 3447
	*xpp = (const void *)xp;
#line 3447
	return status;
#line 3447
#endif
#line 3447
}
#line 3447

int
#line 3448
ncx_getn_float_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3448
{
#line 3448
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3448

#line 3448
 /* basic algorithm is:
#line 3448
  *   - ensure sane alignment of input data
#line 3448
  *   - copy (conversion happens automatically) input data
#line 3448
  *     to output
#line 3448
  *   - update xpp to point at next unconverted input, and tp to point
#line 3448
  *     at next location for converted output
#line 3448
  */
#line 3448
  long i, j, ni;
#line 3448
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3448
  float *xp;
#line 3448
  int nrange = 0;         /* number of range errors */
#line 3448
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3448
  long cxp = (long) *((char**)xpp);
#line 3448

#line 3448
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3448
  /* sjl: manually stripmine so we can limit amount of
#line 3448
   * vector work space reserved to LOOPCNT elements. Also
#line 3448
   * makes vectorisation easy */
#line 3448
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3448
    ni=Min(nelems-j,LOOPCNT);
#line 3448
    if (realign) {
#line 3448
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3448
      xp = tmp;
#line 3448
    } else {
#line 3448
      xp = (float *) *xpp;
#line 3448
    }
#line 3448
   /* copy the next block */
#line 3448
#pragma cdir loopcnt=LOOPCNT
#line 3448
#pragma cdir shortloop
#line 3448
    for (i=0; i<ni; i++) {
#line 3448
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3448
     /* test for range errors (not always needed but do it anyway) */
#line 3448
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3448
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3448
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3448
    }
#line 3448
   /* update xpp and tp */
#line 3448
    if (realign) xp = (float *) *xpp;
#line 3448
    xp += ni;
#line 3448
    tp += ni;
#line 3448
    *xpp = (void*)xp;
#line 3448
  }
#line 3448
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3448

#line 3448
#else   /* not SX */
#line 3448
	const char *xp = (const char *) *xpp;
#line 3448
	int status = NC_NOERR;
#line 3448

#line 3448
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3448
	{
#line 3448
		const int lstatus = ncx_get_float_uchar(xp, tp);
#line 3448
		if (status == NC_NOERR) /* report the first encountered error */
#line 3448
			status = lstatus;
#line 3448
	}
#line 3448

#line 3448
	*xpp = (const void *)xp;
#line 3448
	return status;
#line 3448
#endif
#line 3448
}
#line 3448

int
#line 3449
ncx_getn_float_uint(const void **xpp, size_t nelems, uint *tp)
#line 3449
{
#line 3449
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3449

#line 3449
 /* basic algorithm is:
#line 3449
  *   - ensure sane alignment of input data
#line 3449
  *   - copy (conversion happens automatically) input data
#line 3449
  *     to output
#line 3449
  *   - update xpp to point at next unconverted input, and tp to point
#line 3449
  *     at next location for converted output
#line 3449
  */
#line 3449
  long i, j, ni;
#line 3449
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3449
  float *xp;
#line 3449
  int nrange = 0;         /* number of range errors */
#line 3449
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3449
  long cxp = (long) *((char**)xpp);
#line 3449

#line 3449
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3449
  /* sjl: manually stripmine so we can limit amount of
#line 3449
   * vector work space reserved to LOOPCNT elements. Also
#line 3449
   * makes vectorisation easy */
#line 3449
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3449
    ni=Min(nelems-j,LOOPCNT);
#line 3449
    if (realign) {
#line 3449
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3449
      xp = tmp;
#line 3449
    } else {
#line 3449
      xp = (float *) *xpp;
#line 3449
    }
#line 3449
   /* copy the next block */
#line 3449
#pragma cdir loopcnt=LOOPCNT
#line 3449
#pragma cdir shortloop
#line 3449
    for (i=0; i<ni; i++) {
#line 3449
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3449
     /* test for range errors (not always needed but do it anyway) */
#line 3449
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3449
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3449
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3449
    }
#line 3449
   /* update xpp and tp */
#line 3449
    if (realign) xp = (float *) *xpp;
#line 3449
    xp += ni;
#line 3449
    tp += ni;
#line 3449
    *xpp = (void*)xp;
#line 3449
  }
#line 3449
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3449

#line 3449
#else   /* not SX */
#line 3449
	const char *xp = (const char *) *xpp;
#line 3449
	int status = NC_NOERR;
#line 3449

#line 3449
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3449
	{
#line 3449
		const int lstatus = ncx_get_float_uint(xp, tp);
#line 3449
		if (status == NC_NOERR) /* report the first encountered error */
#line 3449
			status = lstatus;
#line 3449
	}
#line 3449

#line 3449
	*xpp = (const void *)xp;
#line 3449
	return status;
#line 3449
#endif
#line 3449
}
#line 3449

int
#line 3450
ncx_getn_float_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3450
{
#line 3450
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3450

#line 3450
 /* basic algorithm is:
#line 3450
  *   - ensure sane alignment of input data
#line 3450
  *   - copy (conversion happens automatically) input data
#line 3450
  *     to output
#line 3450
  *   - update xpp to point at next unconverted input, and tp to point
#line 3450
  *     at next location for converted output
#line 3450
  */
#line 3450
  long i, j, ni;
#line 3450
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3450
  float *xp;
#line 3450
  int nrange = 0;         /* number of range errors */
#line 3450
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3450
  long cxp = (long) *((char**)xpp);
#line 3450

#line 3450
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3450
  /* sjl: manually stripmine so we can limit amount of
#line 3450
   * vector work space reserved to LOOPCNT elements. Also
#line 3450
   * makes vectorisation easy */
#line 3450
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3450
    ni=Min(nelems-j,LOOPCNT);
#line 3450
    if (realign) {
#line 3450
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3450
      xp = tmp;
#line 3450
    } else {
#line 3450
      xp = (float *) *xpp;
#line 3450
    }
#line 3450
   /* copy the next block */
#line 3450
#pragma cdir loopcnt=LOOPCNT
#line 3450
#pragma cdir shortloop
#line 3450
    for (i=0; i<ni; i++) {
#line 3450
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3450
     /* test for range errors (not always needed but do it anyway) */
#line 3450
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3450
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3450
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3450
    }
#line 3450
   /* update xpp and tp */
#line 3450
    if (realign) xp = (float *) *xpp;
#line 3450
    xp += ni;
#line 3450
    tp += ni;
#line 3450
    *xpp = (void*)xp;
#line 3450
  }
#line 3450
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3450

#line 3450
#else   /* not SX */
#line 3450
	const char *xp = (const char *) *xpp;
#line 3450
	int status = NC_NOERR;
#line 3450

#line 3450
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3450
	{
#line 3450
		const int lstatus = ncx_get_float_ulonglong(xp, tp);
#line 3450
		if (status == NC_NOERR) /* report the first encountered error */
#line 3450
			status = lstatus;
#line 3450
	}
#line 3450

#line 3450
	*xpp = (const void *)xp;
#line 3450
	return status;
#line 3450
#endif
#line 3450
}
#line 3450


int
ncx_putn_float_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)
/* optimized version */
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_FLOAT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_FLOAT);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
{
	const float *const end = tp + nelems;

	while (tp < end) {
				const struct vax_single *const vsp =
#line 3470
			 (const struct vax_single *)ip;
#line 3470
		struct ieee_single *const isp = (struct ieee_single *) (*xpp);
#line 3470

#line 3470
		switch(vsp->exp){
#line 3470
		case 0 :
#line 3470
			/* all vax float with zero exponent map to zero */
#line 3470
			*isp = min.ieee;
#line 3470
			break;
#line 3470
		case 2 :
#line 3470
		case 1 :
#line 3470
		{
#line 3470
			/* These will map to subnormals */
#line 3470
			unsigned mantissa = (vsp->mantissa1 << 16)
#line 3470
					 | vsp->mantissa2;
#line 3470
			mantissa >>= 3 - vsp->exp;
#line 3470
			mantissa += (1 << (20 + vsp->exp));
#line 3470
			isp->mant_lo_lo = mantissa;
#line 3470
			isp->mant_lo_hi = mantissa >> 8;
#line 3470
			isp->mant_hi = mantissa >> 16;
#line 3470
			isp->exp_lo = 0;
#line 3470
			isp->exp_hi = 0;
#line 3470
		}
#line 3470
			break;
#line 3470
		case 0xff : /* max.s.exp */
#line 3470
			if (vsp->mantissa2 == max.s.mantissa2 &&
#line 3470
			    vsp->mantissa1 == max.s.mantissa1)
#line 3470
			{
#line 3470
				/* map largest vax float to ieee infinity */
#line 3470
				*isp = max.ieee;
#line 3470
				break;
#line 3470
			} /* else, fall thru */
#line 3470
		default :
#line 3470
		{
#line 3470
			unsigned exp = vsp->exp - VAX_SNG_BIAS + IEEE_SNG_BIAS;
#line 3470
			isp->exp_hi = exp >> 1;
#line 3470
			isp->exp_lo = exp;
#line 3470
			isp->mant_lo_lo = vsp->mantissa2;
#line 3470
			isp->mant_lo_hi = vsp->mantissa2 >> 8;
#line 3470
			isp->mant_hi = vsp->mantissa1;
#line 3470
		}
#line 3470
		}
#line 3470

#line 3470
		isp->sign = vsp->sign;
#line 3470

		tp++;
		*xpp = (char *)(*xpp) + X_SIZEOF_FLOAT;
	}
	return NC_NOERR;
}
#else
{
	char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++) {
		int lstatus = ncx_put_float_float(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
}
#endif
int
#line 3491
ncx_putn_float_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3491
{
#line 3491
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3491

#line 3491
 /* basic algorithm is:
#line 3491
  *   - ensure sane alignment of output data
#line 3491
  *   - copy (conversion happens automatically) input data
#line 3491
  *     to output
#line 3491
  *   - update tp to point at next unconverted input, and xpp to point
#line 3491
  *     at next location for converted output
#line 3491
  */
#line 3491
  long i, j, ni;
#line 3491
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3491
  float *xp;
#line 3491
  int nrange = 0;         /* number of range errors */
#line 3491
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3491
  long cxp = (long) *((char**)xpp);
#line 3491

#line 3491
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3491
  /* sjl: manually stripmine so we can limit amount of
#line 3491
   * vector work space reserved to LOOPCNT elements. Also
#line 3491
   * makes vectorisation easy */
#line 3491
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3491
    ni=Min(nelems-j,LOOPCNT);
#line 3491
    if (realign) {
#line 3491
      xp = tmp;
#line 3491
    } else {
#line 3491
      xp = (float *) *xpp;
#line 3491
    }
#line 3491
   /* copy the next block */
#line 3491
#pragma cdir loopcnt=LOOPCNT
#line 3491
#pragma cdir shortloop
#line 3491
    for (i=0; i<ni; i++) {
#line 3491
      /* the normal case: */
#line 3491
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3491
     /* test for range errors (not always needed but do it anyway) */
#line 3491
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3491
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3491
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3491
    }
#line 3491
   /* copy workspace back if necessary */
#line 3491
    if (realign) {
#line 3491
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3491
      xp = (float *) *xpp;
#line 3491
    }
#line 3491
   /* update xpp and tp */
#line 3491
    xp += ni;
#line 3491
    tp += ni;
#line 3491
    *xpp = (void*)xp;
#line 3491
  }
#line 3491
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3491

#line 3491
#else   /* not SX */
#line 3491

#line 3491
	char *xp = (char *) *xpp;
#line 3491
	int status = NC_NOERR;
#line 3491

#line 3491
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3491
	{
#line 3491
		int lstatus = ncx_put_float_schar(xp, tp, fillp);
#line 3491
		if (status == NC_NOERR) /* report the first encountered error */
#line 3491
			status = lstatus;
#line 3491
	}
#line 3491

#line 3491
	*xpp = (void *)xp;
#line 3491
	return status;
#line 3491
#endif
#line 3491
}
#line 3491

int
#line 3492
ncx_putn_float_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3492
{
#line 3492
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3492

#line 3492
 /* basic algorithm is:
#line 3492
  *   - ensure sane alignment of output data
#line 3492
  *   - copy (conversion happens automatically) input data
#line 3492
  *     to output
#line 3492
  *   - update tp to point at next unconverted input, and xpp to point
#line 3492
  *     at next location for converted output
#line 3492
  */
#line 3492
  long i, j, ni;
#line 3492
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3492
  float *xp;
#line 3492
  int nrange = 0;         /* number of range errors */
#line 3492
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3492
  long cxp = (long) *((char**)xpp);
#line 3492

#line 3492
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3492
  /* sjl: manually stripmine so we can limit amount of
#line 3492
   * vector work space reserved to LOOPCNT elements. Also
#line 3492
   * makes vectorisation easy */
#line 3492
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3492
    ni=Min(nelems-j,LOOPCNT);
#line 3492
    if (realign) {
#line 3492
      xp = tmp;
#line 3492
    } else {
#line 3492
      xp = (float *) *xpp;
#line 3492
    }
#line 3492
   /* copy the next block */
#line 3492
#pragma cdir loopcnt=LOOPCNT
#line 3492
#pragma cdir shortloop
#line 3492
    for (i=0; i<ni; i++) {
#line 3492
      /* the normal case: */
#line 3492
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3492
     /* test for range errors (not always needed but do it anyway) */
#line 3492
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3492
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3492
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3492
    }
#line 3492
   /* copy workspace back if necessary */
#line 3492
    if (realign) {
#line 3492
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3492
      xp = (float *) *xpp;
#line 3492
    }
#line 3492
   /* update xpp and tp */
#line 3492
    xp += ni;
#line 3492
    tp += ni;
#line 3492
    *xpp = (void*)xp;
#line 3492
  }
#line 3492
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3492

#line 3492
#else   /* not SX */
#line 3492

#line 3492
	char *xp = (char *) *xpp;
#line 3492
	int status = NC_NOERR;
#line 3492

#line 3492
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3492
	{
#line 3492
		int lstatus = ncx_put_float_short(xp, tp, fillp);
#line 3492
		if (status == NC_NOERR) /* report the first encountered error */
#line 3492
			status = lstatus;
#line 3492
	}
#line 3492

#line 3492
	*xpp = (void *)xp;
#line 3492
	return status;
#line 3492
#endif
#line 3492
}
#line 3492

int
#line 3493
ncx_putn_float_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3493
{
#line 3493
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3493

#line 3493
 /* basic algorithm is:
#line 3493
  *   - ensure sane alignment of output data
#line 3493
  *   - copy (conversion happens automatically) input data
#line 3493
  *     to output
#line 3493
  *   - update tp to point at next unconverted input, and xpp to point
#line 3493
  *     at next location for converted output
#line 3493
  */
#line 3493
  long i, j, ni;
#line 3493
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3493
  float *xp;
#line 3493
  int nrange = 0;         /* number of range errors */
#line 3493
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3493
  long cxp = (long) *((char**)xpp);
#line 3493

#line 3493
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3493
  /* sjl: manually stripmine so we can limit amount of
#line 3493
   * vector work space reserved to LOOPCNT elements. Also
#line 3493
   * makes vectorisation easy */
#line 3493
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3493
    ni=Min(nelems-j,LOOPCNT);
#line 3493
    if (realign) {
#line 3493
      xp = tmp;
#line 3493
    } else {
#line 3493
      xp = (float *) *xpp;
#line 3493
    }
#line 3493
   /* copy the next block */
#line 3493
#pragma cdir loopcnt=LOOPCNT
#line 3493
#pragma cdir shortloop
#line 3493
    for (i=0; i<ni; i++) {
#line 3493
      /* the normal case: */
#line 3493
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3493
     /* test for range errors (not always needed but do it anyway) */
#line 3493
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3493
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3493
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3493
    }
#line 3493
   /* copy workspace back if necessary */
#line 3493
    if (realign) {
#line 3493
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3493
      xp = (float *) *xpp;
#line 3493
    }
#line 3493
   /* update xpp and tp */
#line 3493
    xp += ni;
#line 3493
    tp += ni;
#line 3493
    *xpp = (void*)xp;
#line 3493
  }
#line 3493
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3493

#line 3493
#else   /* not SX */
#line 3493

#line 3493
	char *xp = (char *) *xpp;
#line 3493
	int status = NC_NOERR;
#line 3493

#line 3493
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3493
	{
#line 3493
		int lstatus = ncx_put_float_int(xp, tp, fillp);
#line 3493
		if (status == NC_NOERR) /* report the first encountered error */
#line 3493
			status = lstatus;
#line 3493
	}
#line 3493

#line 3493
	*xpp = (void *)xp;
#line 3493
	return status;
#line 3493
#endif
#line 3493
}
#line 3493

int
#line 3494
ncx_putn_float_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3494
{
#line 3494
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3494

#line 3494
 /* basic algorithm is:
#line 3494
  *   - ensure sane alignment of output data
#line 3494
  *   - copy (conversion happens automatically) input data
#line 3494
  *     to output
#line 3494
  *   - update tp to point at next unconverted input, and xpp to point
#line 3494
  *     at next location for converted output
#line 3494
  */
#line 3494
  long i, j, ni;
#line 3494
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3494
  float *xp;
#line 3494
  int nrange = 0;         /* number of range errors */
#line 3494
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3494
  long cxp = (long) *((char**)xpp);
#line 3494

#line 3494
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3494
  /* sjl: manually stripmine so we can limit amount of
#line 3494
   * vector work space reserved to LOOPCNT elements. Also
#line 3494
   * makes vectorisation easy */
#line 3494
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3494
    ni=Min(nelems-j,LOOPCNT);
#line 3494
    if (realign) {
#line 3494
      xp = tmp;
#line 3494
    } else {
#line 3494
      xp = (float *) *xpp;
#line 3494
    }
#line 3494
   /* copy the next block */
#line 3494
#pragma cdir loopcnt=LOOPCNT
#line 3494
#pragma cdir shortloop
#line 3494
    for (i=0; i<ni; i++) {
#line 3494
      /* the normal case: */
#line 3494
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3494
     /* test for range errors (not always needed but do it anyway) */
#line 3494
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3494
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3494
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3494
    }
#line 3494
   /* copy workspace back if necessary */
#line 3494
    if (realign) {
#line 3494
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3494
      xp = (float *) *xpp;
#line 3494
    }
#line 3494
   /* update xpp and tp */
#line 3494
    xp += ni;
#line 3494
    tp += ni;
#line 3494
    *xpp = (void*)xp;
#line 3494
  }
#line 3494
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3494

#line 3494
#else   /* not SX */
#line 3494

#line 3494
	char *xp = (char *) *xpp;
#line 3494
	int status = NC_NOERR;
#line 3494

#line 3494
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3494
	{
#line 3494
		int lstatus = ncx_put_float_long(xp, tp, fillp);
#line 3494
		if (status == NC_NOERR) /* report the first encountered error */
#line 3494
			status = lstatus;
#line 3494
	}
#line 3494

#line 3494
	*xpp = (void *)xp;
#line 3494
	return status;
#line 3494
#endif
#line 3494
}
#line 3494

int
#line 3495
ncx_putn_float_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3495
{
#line 3495
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3495

#line 3495
 /* basic algorithm is:
#line 3495
  *   - ensure sane alignment of output data
#line 3495
  *   - copy (conversion happens automatically) input data
#line 3495
  *     to output
#line 3495
  *   - update tp to point at next unconverted input, and xpp to point
#line 3495
  *     at next location for converted output
#line 3495
  */
#line 3495
  long i, j, ni;
#line 3495
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3495
  float *xp;
#line 3495
  int nrange = 0;         /* number of range errors */
#line 3495
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3495
  long cxp = (long) *((char**)xpp);
#line 3495

#line 3495
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3495
  /* sjl: manually stripmine so we can limit amount of
#line 3495
   * vector work space reserved to LOOPCNT elements. Also
#line 3495
   * makes vectorisation easy */
#line 3495
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3495
    ni=Min(nelems-j,LOOPCNT);
#line 3495
    if (realign) {
#line 3495
      xp = tmp;
#line 3495
    } else {
#line 3495
      xp = (float *) *xpp;
#line 3495
    }
#line 3495
   /* copy the next block */
#line 3495
#pragma cdir loopcnt=LOOPCNT
#line 3495
#pragma cdir shortloop
#line 3495
    for (i=0; i<ni; i++) {
#line 3495
      /* the normal case: */
#line 3495
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3495
     /* test for range errors (not always needed but do it anyway) */
#line 3495
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3495
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3495
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3495
    }
#line 3495
   /* copy workspace back if necessary */
#line 3495
    if (realign) {
#line 3495
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3495
      xp = (float *) *xpp;
#line 3495
    }
#line 3495
   /* update xpp and tp */
#line 3495
    xp += ni;
#line 3495
    tp += ni;
#line 3495
    *xpp = (void*)xp;
#line 3495
  }
#line 3495
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3495

#line 3495
#else   /* not SX */
#line 3495

#line 3495
	char *xp = (char *) *xpp;
#line 3495
	int status = NC_NOERR;
#line 3495

#line 3495
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3495
	{
#line 3495
		int lstatus = ncx_put_float_double(xp, tp, fillp);
#line 3495
		if (status == NC_NOERR) /* report the first encountered error */
#line 3495
			status = lstatus;
#line 3495
	}
#line 3495

#line 3495
	*xpp = (void *)xp;
#line 3495
	return status;
#line 3495
#endif
#line 3495
}
#line 3495

int
#line 3496
ncx_putn_float_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3496
{
#line 3496
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3496

#line 3496
 /* basic algorithm is:
#line 3496
  *   - ensure sane alignment of output data
#line 3496
  *   - copy (conversion happens automatically) input data
#line 3496
  *     to output
#line 3496
  *   - update tp to point at next unconverted input, and xpp to point
#line 3496
  *     at next location for converted output
#line 3496
  */
#line 3496
  long i, j, ni;
#line 3496
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3496
  float *xp;
#line 3496
  int nrange = 0;         /* number of range errors */
#line 3496
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3496
  long cxp = (long) *((char**)xpp);
#line 3496

#line 3496
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3496
  /* sjl: manually stripmine so we can limit amount of
#line 3496
   * vector work space reserved to LOOPCNT elements. Also
#line 3496
   * makes vectorisation easy */
#line 3496
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3496
    ni=Min(nelems-j,LOOPCNT);
#line 3496
    if (realign) {
#line 3496
      xp = tmp;
#line 3496
    } else {
#line 3496
      xp = (float *) *xpp;
#line 3496
    }
#line 3496
   /* copy the next block */
#line 3496
#pragma cdir loopcnt=LOOPCNT
#line 3496
#pragma cdir shortloop
#line 3496
    for (i=0; i<ni; i++) {
#line 3496
      /* the normal case: */
#line 3496
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3496
     /* test for range errors (not always needed but do it anyway) */
#line 3496
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3496
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3496
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3496
    }
#line 3496
   /* copy workspace back if necessary */
#line 3496
    if (realign) {
#line 3496
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3496
      xp = (float *) *xpp;
#line 3496
    }
#line 3496
   /* update xpp and tp */
#line 3496
    xp += ni;
#line 3496
    tp += ni;
#line 3496
    *xpp = (void*)xp;
#line 3496
  }
#line 3496
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3496

#line 3496
#else   /* not SX */
#line 3496

#line 3496
	char *xp = (char *) *xpp;
#line 3496
	int status = NC_NOERR;
#line 3496

#line 3496
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3496
	{
#line 3496
		int lstatus = ncx_put_float_longlong(xp, tp, fillp);
#line 3496
		if (status == NC_NOERR) /* report the first encountered error */
#line 3496
			status = lstatus;
#line 3496
	}
#line 3496

#line 3496
	*xpp = (void *)xp;
#line 3496
	return status;
#line 3496
#endif
#line 3496
}
#line 3496

int
#line 3497
ncx_putn_float_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3497
{
#line 3497
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3497

#line 3497
 /* basic algorithm is:
#line 3497
  *   - ensure sane alignment of output data
#line 3497
  *   - copy (conversion happens automatically) input data
#line 3497
  *     to output
#line 3497
  *   - update tp to point at next unconverted input, and xpp to point
#line 3497
  *     at next location for converted output
#line 3497
  */
#line 3497
  long i, j, ni;
#line 3497
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3497
  float *xp;
#line 3497
  int nrange = 0;         /* number of range errors */
#line 3497
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3497
  long cxp = (long) *((char**)xpp);
#line 3497

#line 3497
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3497
  /* sjl: manually stripmine so we can limit amount of
#line 3497
   * vector work space reserved to LOOPCNT elements. Also
#line 3497
   * makes vectorisation easy */
#line 3497
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3497
    ni=Min(nelems-j,LOOPCNT);
#line 3497
    if (realign) {
#line 3497
      xp = tmp;
#line 3497
    } else {
#line 3497
      xp = (float *) *xpp;
#line 3497
    }
#line 3497
   /* copy the next block */
#line 3497
#pragma cdir loopcnt=LOOPCNT
#line 3497
#pragma cdir shortloop
#line 3497
    for (i=0; i<ni; i++) {
#line 3497
      /* the normal case: */
#line 3497
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3497
     /* test for range errors (not always needed but do it anyway) */
#line 3497
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3497
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3497
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3497
    }
#line 3497
   /* copy workspace back if necessary */
#line 3497
    if (realign) {
#line 3497
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3497
      xp = (float *) *xpp;
#line 3497
    }
#line 3497
   /* update xpp and tp */
#line 3497
    xp += ni;
#line 3497
    tp += ni;
#line 3497
    *xpp = (void*)xp;
#line 3497
  }
#line 3497
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3497

#line 3497
#else   /* not SX */
#line 3497

#line 3497
	char *xp = (char *) *xpp;
#line 3497
	int status = NC_NOERR;
#line 3497

#line 3497
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3497
	{
#line 3497
		int lstatus = ncx_put_float_uchar(xp, tp, fillp);
#line 3497
		if (status == NC_NOERR) /* report the first encountered error */
#line 3497
			status = lstatus;
#line 3497
	}
#line 3497

#line 3497
	*xpp = (void *)xp;
#line 3497
	return status;
#line 3497
#endif
#line 3497
}
#line 3497

int
#line 3498
ncx_putn_float_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3498
{
#line 3498
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3498

#line 3498
 /* basic algorithm is:
#line 3498
  *   - ensure sane alignment of output data
#line 3498
  *   - copy (conversion happens automatically) input data
#line 3498
  *     to output
#line 3498
  *   - update tp to point at next unconverted input, and xpp to point
#line 3498
  *     at next location for converted output
#line 3498
  */
#line 3498
  long i, j, ni;
#line 3498
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3498
  float *xp;
#line 3498
  int nrange = 0;         /* number of range errors */
#line 3498
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3498
  long cxp = (long) *((char**)xpp);
#line 3498

#line 3498
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3498
  /* sjl: manually stripmine so we can limit amount of
#line 3498
   * vector work space reserved to LOOPCNT elements. Also
#line 3498
   * makes vectorisation easy */
#line 3498
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3498
    ni=Min(nelems-j,LOOPCNT);
#line 3498
    if (realign) {
#line 3498
      xp = tmp;
#line 3498
    } else {
#line 3498
      xp = (float *) *xpp;
#line 3498
    }
#line 3498
   /* copy the next block */
#line 3498
#pragma cdir loopcnt=LOOPCNT
#line 3498
#pragma cdir shortloop
#line 3498
    for (i=0; i<ni; i++) {
#line 3498
      /* the normal case: */
#line 3498
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3498
     /* test for range errors (not always needed but do it anyway) */
#line 3498
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3498
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3498
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3498
    }
#line 3498
   /* copy workspace back if necessary */
#line 3498
    if (realign) {
#line 3498
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3498
      xp = (float *) *xpp;
#line 3498
    }
#line 3498
   /* update xpp and tp */
#line 3498
    xp += ni;
#line 3498
    tp += ni;
#line 3498
    *xpp = (void*)xp;
#line 3498
  }
#line 3498
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3498

#line 3498
#else   /* not SX */
#line 3498

#line 3498
	char *xp = (char *) *xpp;
#line 3498
	int status = NC_NOERR;
#line 3498

#line 3498
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3498
	{
#line 3498
		int lstatus = ncx_put_float_ushort(xp, tp, fillp);
#line 3498
		if (status == NC_NOERR) /* report the first encountered error */
#line 3498
			status = lstatus;
#line 3498
	}
#line 3498

#line 3498
	*xpp = (void *)xp;
#line 3498
	return status;
#line 3498
#endif
#line 3498
}
#line 3498

int
#line 3499
ncx_putn_float_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3499
{
#line 3499
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3499

#line 3499
 /* basic algorithm is:
#line 3499
  *   - ensure sane alignment of output data
#line 3499
  *   - copy (conversion happens automatically) input data
#line 3499
  *     to output
#line 3499
  *   - update tp to point at next unconverted input, and xpp to point
#line 3499
  *     at next location for converted output
#line 3499
  */
#line 3499
  long i, j, ni;
#line 3499
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3499
  float *xp;
#line 3499
  int nrange = 0;         /* number of range errors */
#line 3499
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3499
  long cxp = (long) *((char**)xpp);
#line 3499

#line 3499
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3499
  /* sjl: manually stripmine so we can limit amount of
#line 3499
   * vector work space reserved to LOOPCNT elements. Also
#line 3499
   * makes vectorisation easy */
#line 3499
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3499
    ni=Min(nelems-j,LOOPCNT);
#line 3499
    if (realign) {
#line 3499
      xp = tmp;
#line 3499
    } else {
#line 3499
      xp = (float *) *xpp;
#line 3499
    }
#line 3499
   /* copy the next block */
#line 3499
#pragma cdir loopcnt=LOOPCNT
#line 3499
#pragma cdir shortloop
#line 3499
    for (i=0; i<ni; i++) {
#line 3499
      /* the normal case: */
#line 3499
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3499
     /* test for range errors (not always needed but do it anyway) */
#line 3499
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3499
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3499
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3499
    }
#line 3499
   /* copy workspace back if necessary */
#line 3499
    if (realign) {
#line 3499
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3499
      xp = (float *) *xpp;
#line 3499
    }
#line 3499
   /* update xpp and tp */
#line 3499
    xp += ni;
#line 3499
    tp += ni;
#line 3499
    *xpp = (void*)xp;
#line 3499
  }
#line 3499
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3499

#line 3499
#else   /* not SX */
#line 3499

#line 3499
	char *xp = (char *) *xpp;
#line 3499
	int status = NC_NOERR;
#line 3499

#line 3499
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3499
	{
#line 3499
		int lstatus = ncx_put_float_uint(xp, tp, fillp);
#line 3499
		if (status == NC_NOERR) /* report the first encountered error */
#line 3499
			status = lstatus;
#line 3499
	}
#line 3499

#line 3499
	*xpp = (void *)xp;
#line 3499
	return status;
#line 3499
#endif
#line 3499
}
#line 3499

int
#line 3500
ncx_putn_float_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3500
{
#line 3500
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3500

#line 3500
 /* basic algorithm is:
#line 3500
  *   - ensure sane alignment of output data
#line 3500
  *   - copy (conversion happens automatically) input data
#line 3500
  *     to output
#line 3500
  *   - update tp to point at next unconverted input, and xpp to point
#line 3500
  *     at next location for converted output
#line 3500
  */
#line 3500
  long i, j, ni;
#line 3500
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3500
  float *xp;
#line 3500
  int nrange = 0;         /* number of range errors */
#line 3500
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3500
  long cxp = (long) *((char**)xpp);
#line 3500

#line 3500
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3500
  /* sjl: manually stripmine so we can limit amount of
#line 3500
   * vector work space reserved to LOOPCNT elements. Also
#line 3500
   * makes vectorisation easy */
#line 3500
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3500
    ni=Min(nelems-j,LOOPCNT);
#line 3500
    if (realign) {
#line 3500
      xp = tmp;
#line 3500
    } else {
#line 3500
      xp = (float *) *xpp;
#line 3500
    }
#line 3500
   /* copy the next block */
#line 3500
#pragma cdir loopcnt=LOOPCNT
#line 3500
#pragma cdir shortloop
#line 3500
    for (i=0; i<ni; i++) {
#line 3500
      /* the normal case: */
#line 3500
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3500
     /* test for range errors (not always needed but do it anyway) */
#line 3500
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3500
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3500
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3500
    }
#line 3500
   /* copy workspace back if necessary */
#line 3500
    if (realign) {
#line 3500
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3500
      xp = (float *) *xpp;
#line 3500
    }
#line 3500
   /* update xpp and tp */
#line 3500
    xp += ni;
#line 3500
    tp += ni;
#line 3500
    *xpp = (void*)xp;
#line 3500
  }
#line 3500
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3500

#line 3500
#else   /* not SX */
#line 3500

#line 3500
	char *xp = (char *) *xpp;
#line 3500
	int status = NC_NOERR;
#line 3500

#line 3500
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3500
	{
#line 3500
		int lstatus = ncx_put_float_ulonglong(xp, tp, fillp);
#line 3500
		if (status == NC_NOERR) /* report the first encountered error */
#line 3500
			status = lstatus;
#line 3500
	}
#line 3500

#line 3500
	*xpp = (void *)xp;
#line 3500
	return status;
#line 3500
#endif
#line 3500
}
#line 3500


/* double --------------------------------------------------------------------*/

#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_getn_double_double(const void **xpp, size_t nelems, double *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_DOUBLE);
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_DOUBLE);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
int
ncx_getn_double_double(const void **xpp, size_t ndoubles, double *ip)
{
	double *const end = ip + ndoubles;

	while (ip < end)
	{
	struct vax_double *const vdp =
#line 3525
			 (struct vax_double *)ip;
#line 3525
	const struct ieee_double *const idp =
#line 3525
			 (const struct ieee_double *) (*xpp);
#line 3525
	{
#line 3525
		const struct dbl_limits *lim;
#line 3525
		int ii;
#line 3525
		for (ii = 0, lim = dbl_limits;
#line 3525
			ii < sizeof(dbl_limits)/sizeof(struct dbl_limits);
#line 3525
			ii++, lim++)
#line 3525
		{
#line 3525
			if ((idp->mant_lo == lim->ieee.mant_lo)
#line 3525
				&& (idp->mant_4 == lim->ieee.mant_4)
#line 3525
				&& (idp->mant_5 == lim->ieee.mant_5)
#line 3525
				&& (idp->mant_6 == lim->ieee.mant_6)
#line 3525
				&& (idp->exp_lo == lim->ieee.exp_lo)
#line 3525
				&& (idp->exp_hi == lim->ieee.exp_hi)
#line 3525
				)
#line 3525
			{
#line 3525
				*vdp = lim->d;
#line 3525
				goto doneit;
#line 3525
			}
#line 3525
		}
#line 3525
	}
#line 3525
	{
#line 3525
		unsigned exp = idp->exp_hi << 4 | idp->exp_lo;
#line 3525
		vdp->exp = exp - IEEE_DBL_BIAS + VAX_DBL_BIAS;
#line 3525
	}
#line 3525
	{
#line 3525
		unsigned mant_hi = ((idp->mant_6 << 16)
#line 3525
				 | (idp->mant_5 << 8)
#line 3525
				 | idp->mant_4);
#line 3525
		unsigned mant_lo = SWAP4(idp->mant_lo);
#line 3525
		vdp->mantissa1 = (mant_hi >> 13);
#line 3525
		vdp->mantissa2 = ((mant_hi & MASK(13)) << 3)
#line 3525
				| (mant_lo >> 29);
#line 3525
		vdp->mantissa3 = (mant_lo >> 13);
#line 3525
		vdp->mantissa4 = (mant_lo << 3);
#line 3525
	}
#line 3525
	doneit:
#line 3525
		vdp->sign = idp->sign;
#line 3525

		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_DOUBLE;
	}
	return NC_NOERR;
}
	/* vax */
#else
int
ncx_getn_double_double(const void **xpp, size_t nelems, double *tp)
{
	const char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		const int lstatus = ncx_get_double_double(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
}
#endif
int
#line 3550
ncx_getn_double_schar(const void **xpp, size_t nelems, schar *tp)
#line 3550
{
#line 3550
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3550

#line 3550
 /* basic algorithm is:
#line 3550
  *   - ensure sane alignment of input data
#line 3550
  *   - copy (conversion happens automatically) input data
#line 3550
  *     to output
#line 3550
  *   - update xpp to point at next unconverted input, and tp to point
#line 3550
  *     at next location for converted output
#line 3550
  */
#line 3550
  long i, j, ni;
#line 3550
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3550
  double *xp;
#line 3550
  int nrange = 0;         /* number of range errors */
#line 3550
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3550
  long cxp = (long) *((char**)xpp);
#line 3550

#line 3550
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3550
  /* sjl: manually stripmine so we can limit amount of
#line 3550
   * vector work space reserved to LOOPCNT elements. Also
#line 3550
   * makes vectorisation easy */
#line 3550
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3550
    ni=Min(nelems-j,LOOPCNT);
#line 3550
    if (realign) {
#line 3550
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3550
      xp = tmp;
#line 3550
    } else {
#line 3550
      xp = (double *) *xpp;
#line 3550
    }
#line 3550
   /* copy the next block */
#line 3550
#pragma cdir loopcnt=LOOPCNT
#line 3550
#pragma cdir shortloop
#line 3550
    for (i=0; i<ni; i++) {
#line 3550
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3550
     /* test for range errors (not always needed but do it anyway) */
#line 3550
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3550
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3550
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3550
    }
#line 3550
   /* update xpp and tp */
#line 3550
    if (realign) xp = (double *) *xpp;
#line 3550
    xp += ni;
#line 3550
    tp += ni;
#line 3550
    *xpp = (void*)xp;
#line 3550
  }
#line 3550
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3550

#line 3550
#else   /* not SX */
#line 3550
	const char *xp = (const char *) *xpp;
#line 3550
	int status = NC_NOERR;
#line 3550

#line 3550
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3550
	{
#line 3550
		const int lstatus = ncx_get_double_schar(xp, tp);
#line 3550
		if (status == NC_NOERR) /* report the first encountered error */
#line 3550
			status = lstatus;
#line 3550
	}
#line 3550

#line 3550
	*xpp = (const void *)xp;
#line 3550
	return status;
#line 3550
#endif
#line 3550
}
#line 3550

int
#line 3551
ncx_getn_double_short(const void **xpp, size_t nelems, short *tp)
#line 3551
{
#line 3551
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3551

#line 3551
 /* basic algorithm is:
#line 3551
  *   - ensure sane alignment of input data
#line 3551
  *   - copy (conversion happens automatically) input data
#line 3551
  *     to output
#line 3551
  *   - update xpp to point at next unconverted input, and tp to point
#line 3551
  *     at next location for converted output
#line 3551
  */
#line 3551
  long i, j, ni;
#line 3551
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3551
  double *xp;
#line 3551
  int nrange = 0;         /* number of range errors */
#line 3551
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3551
  long cxp = (long) *((char**)xpp);
#line 3551

#line 3551
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3551
  /* sjl: manually stripmine so we can limit amount of
#line 3551
   * vector work space reserved to LOOPCNT elements. Also
#line 3551
   * makes vectorisation easy */
#line 3551
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3551
    ni=Min(nelems-j,LOOPCNT);
#line 3551
    if (realign) {
#line 3551
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3551
      xp = tmp;
#line 3551
    } else {
#line 3551
      xp = (double *) *xpp;
#line 3551
    }
#line 3551
   /* copy the next block */
#line 3551
#pragma cdir loopcnt=LOOPCNT
#line 3551
#pragma cdir shortloop
#line 3551
    for (i=0; i<ni; i++) {
#line 3551
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3551
     /* test for range errors (not always needed but do it anyway) */
#line 3551
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3551
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3551
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3551
    }
#line 3551
   /* update xpp and tp */
#line 3551
    if (realign) xp = (double *) *xpp;
#line 3551
    xp += ni;
#line 3551
    tp += ni;
#line 3551
    *xpp = (void*)xp;
#line 3551
  }
#line 3551
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3551

#line 3551
#else   /* not SX */
#line 3551
	const char *xp = (const char *) *xpp;
#line 3551
	int status = NC_NOERR;
#line 3551

#line 3551
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3551
	{
#line 3551
		const int lstatus = ncx_get_double_short(xp, tp);
#line 3551
		if (status == NC_NOERR) /* report the first encountered error */
#line 3551
			status = lstatus;
#line 3551
	}
#line 3551

#line 3551
	*xpp = (const void *)xp;
#line 3551
	return status;
#line 3551
#endif
#line 3551
}
#line 3551

int
#line 3552
ncx_getn_double_int(const void **xpp, size_t nelems, int *tp)
#line 3552
{
#line 3552
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3552

#line 3552
 /* basic algorithm is:
#line 3552
  *   - ensure sane alignment of input data
#line 3552
  *   - copy (conversion happens automatically) input data
#line 3552
  *     to output
#line 3552
  *   - update xpp to point at next unconverted input, and tp to point
#line 3552
  *     at next location for converted output
#line 3552
  */
#line 3552
  long i, j, ni;
#line 3552
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3552
  double *xp;
#line 3552
  int nrange = 0;         /* number of range errors */
#line 3552
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3552
  long cxp = (long) *((char**)xpp);
#line 3552

#line 3552
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3552
  /* sjl: manually stripmine so we can limit amount of
#line 3552
   * vector work space reserved to LOOPCNT elements. Also
#line 3552
   * makes vectorisation easy */
#line 3552
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3552
    ni=Min(nelems-j,LOOPCNT);
#line 3552
    if (realign) {
#line 3552
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3552
      xp = tmp;
#line 3552
    } else {
#line 3552
      xp = (double *) *xpp;
#line 3552
    }
#line 3552
   /* copy the next block */
#line 3552
#pragma cdir loopcnt=LOOPCNT
#line 3552
#pragma cdir shortloop
#line 3552
    for (i=0; i<ni; i++) {
#line 3552
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3552
     /* test for range errors (not always needed but do it anyway) */
#line 3552
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3552
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3552
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3552
    }
#line 3552
   /* update xpp and tp */
#line 3552
    if (realign) xp = (double *) *xpp;
#line 3552
    xp += ni;
#line 3552
    tp += ni;
#line 3552
    *xpp = (void*)xp;
#line 3552
  }
#line 3552
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3552

#line 3552
#else   /* not SX */
#line 3552
	const char *xp = (const char *) *xpp;
#line 3552
	int status = NC_NOERR;
#line 3552

#line 3552
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3552
	{
#line 3552
		const int lstatus = ncx_get_double_int(xp, tp);
#line 3552
		if (status == NC_NOERR) /* report the first encountered error */
#line 3552
			status = lstatus;
#line 3552
	}
#line 3552

#line 3552
	*xpp = (const void *)xp;
#line 3552
	return status;
#line 3552
#endif
#line 3552
}
#line 3552

int
#line 3553
ncx_getn_double_long(const void **xpp, size_t nelems, long *tp)
#line 3553
{
#line 3553
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3553

#line 3553
 /* basic algorithm is:
#line 3553
  *   - ensure sane alignment of input data
#line 3553
  *   - copy (conversion happens automatically) input data
#line 3553
  *     to output
#line 3553
  *   - update xpp to point at next unconverted input, and tp to point
#line 3553
  *     at next location for converted output
#line 3553
  */
#line 3553
  long i, j, ni;
#line 3553
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3553
  double *xp;
#line 3553
  int nrange = 0;         /* number of range errors */
#line 3553
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3553
  long cxp = (long) *((char**)xpp);
#line 3553

#line 3553
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3553
  /* sjl: manually stripmine so we can limit amount of
#line 3553
   * vector work space reserved to LOOPCNT elements. Also
#line 3553
   * makes vectorisation easy */
#line 3553
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3553
    ni=Min(nelems-j,LOOPCNT);
#line 3553
    if (realign) {
#line 3553
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3553
      xp = tmp;
#line 3553
    } else {
#line 3553
      xp = (double *) *xpp;
#line 3553
    }
#line 3553
   /* copy the next block */
#line 3553
#pragma cdir loopcnt=LOOPCNT
#line 3553
#pragma cdir shortloop
#line 3553
    for (i=0; i<ni; i++) {
#line 3553
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3553
     /* test for range errors (not always needed but do it anyway) */
#line 3553
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3553
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3553
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3553
    }
#line 3553
   /* update xpp and tp */
#line 3553
    if (realign) xp = (double *) *xpp;
#line 3553
    xp += ni;
#line 3553
    tp += ni;
#line 3553
    *xpp = (void*)xp;
#line 3553
  }
#line 3553
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3553

#line 3553
#else   /* not SX */
#line 3553
	const char *xp = (const char *) *xpp;
#line 3553
	int status = NC_NOERR;
#line 3553

#line 3553
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3553
	{
#line 3553
		const int lstatus = ncx_get_double_long(xp, tp);
#line 3553
		if (status == NC_NOERR) /* report the first encountered error */
#line 3553
			status = lstatus;
#line 3553
	}
#line 3553

#line 3553
	*xpp = (const void *)xp;
#line 3553
	return status;
#line 3553
#endif
#line 3553
}
#line 3553

int
#line 3554
ncx_getn_double_float(const void **xpp, size_t nelems, float *tp)
#line 3554
{
#line 3554
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3554

#line 3554
 /* basic algorithm is:
#line 3554
  *   - ensure sane alignment of input data
#line 3554
  *   - copy (conversion happens automatically) input data
#line 3554
  *     to output
#line 3554
  *   - update xpp to point at next unconverted input, and tp to point
#line 3554
  *     at next location for converted output
#line 3554
  */
#line 3554
  long i, j, ni;
#line 3554
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3554
  double *xp;
#line 3554
  int nrange = 0;         /* number of range errors */
#line 3554
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3554
  long cxp = (long) *((char**)xpp);
#line 3554

#line 3554
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3554
  /* sjl: manually stripmine so we can limit amount of
#line 3554
   * vector work space reserved to LOOPCNT elements. Also
#line 3554
   * makes vectorisation easy */
#line 3554
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3554
    ni=Min(nelems-j,LOOPCNT);
#line 3554
    if (realign) {
#line 3554
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3554
      xp = tmp;
#line 3554
    } else {
#line 3554
      xp = (double *) *xpp;
#line 3554
    }
#line 3554
   /* copy the next block */
#line 3554
#pragma cdir loopcnt=LOOPCNT
#line 3554
#pragma cdir shortloop
#line 3554
    for (i=0; i<ni; i++) {
#line 3554
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3554
     /* test for range errors (not always needed but do it anyway) */
#line 3554
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3554
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3554
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3554
    }
#line 3554
   /* update xpp and tp */
#line 3554
    if (realign) xp = (double *) *xpp;
#line 3554
    xp += ni;
#line 3554
    tp += ni;
#line 3554
    *xpp = (void*)xp;
#line 3554
  }
#line 3554
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3554

#line 3554
#else   /* not SX */
#line 3554
	const char *xp = (const char *) *xpp;
#line 3554
	int status = NC_NOERR;
#line 3554

#line 3554
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3554
	{
#line 3554
		const int lstatus = ncx_get_double_float(xp, tp);
#line 3554
		if (status == NC_NOERR) /* report the first encountered error */
#line 3554
			status = lstatus;
#line 3554
	}
#line 3554

#line 3554
	*xpp = (const void *)xp;
#line 3554
	return status;
#line 3554
#endif
#line 3554
}
#line 3554

int
#line 3555
ncx_getn_double_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3555
{
#line 3555
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3555

#line 3555
 /* basic algorithm is:
#line 3555
  *   - ensure sane alignment of input data
#line 3555
  *   - copy (conversion happens automatically) input data
#line 3555
  *     to output
#line 3555
  *   - update xpp to point at next unconverted input, and tp to point
#line 3555
  *     at next location for converted output
#line 3555
  */
#line 3555
  long i, j, ni;
#line 3555
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3555
  double *xp;
#line 3555
  int nrange = 0;         /* number of range errors */
#line 3555
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3555
  long cxp = (long) *((char**)xpp);
#line 3555

#line 3555
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3555
  /* sjl: manually stripmine so we can limit amount of
#line 3555
   * vector work space reserved to LOOPCNT elements. Also
#line 3555
   * makes vectorisation easy */
#line 3555
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3555
    ni=Min(nelems-j,LOOPCNT);
#line 3555
    if (realign) {
#line 3555
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3555
      xp = tmp;
#line 3555
    } else {
#line 3555
      xp = (double *) *xpp;
#line 3555
    }
#line 3555
   /* copy the next block */
#line 3555
#pragma cdir loopcnt=LOOPCNT
#line 3555
#pragma cdir shortloop
#line 3555
    for (i=0; i<ni; i++) {
#line 3555
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3555
     /* test for range errors (not always needed but do it anyway) */
#line 3555
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3555
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3555
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3555
    }
#line 3555
   /* update xpp and tp */
#line 3555
    if (realign) xp = (double *) *xpp;
#line 3555
    xp += ni;
#line 3555
    tp += ni;
#line 3555
    *xpp = (void*)xp;
#line 3555
  }
#line 3555
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3555

#line 3555
#else   /* not SX */
#line 3555
	const char *xp = (const char *) *xpp;
#line 3555
	int status = NC_NOERR;
#line 3555

#line 3555
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3555
	{
#line 3555
		const int lstatus = ncx_get_double_longlong(xp, tp);
#line 3555
		if (status == NC_NOERR) /* report the first encountered error */
#line 3555
			status = lstatus;
#line 3555
	}
#line 3555

#line 3555
	*xpp = (const void *)xp;
#line 3555
	return status;
#line 3555
#endif
#line 3555
}
#line 3555

int
#line 3556
ncx_getn_double_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3556
{
#line 3556
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3556

#line 3556
 /* basic algorithm is:
#line 3556
  *   - ensure sane alignment of input data
#line 3556
  *   - copy (conversion happens automatically) input data
#line 3556
  *     to output
#line 3556
  *   - update xpp to point at next unconverted input, and tp to point
#line 3556
  *     at next location for converted output
#line 3556
  */
#line 3556
  long i, j, ni;
#line 3556
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3556
  double *xp;
#line 3556
  int nrange = 0;         /* number of range errors */
#line 3556
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3556
  long cxp = (long) *((char**)xpp);
#line 3556

#line 3556
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3556
  /* sjl: manually stripmine so we can limit amount of
#line 3556
   * vector work space reserved to LOOPCNT elements. Also
#line 3556
   * makes vectorisation easy */
#line 3556
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3556
    ni=Min(nelems-j,LOOPCNT);
#line 3556
    if (realign) {
#line 3556
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3556
      xp = tmp;
#line 3556
    } else {
#line 3556
      xp = (double *) *xpp;
#line 3556
    }
#line 3556
   /* copy the next block */
#line 3556
#pragma cdir loopcnt=LOOPCNT
#line 3556
#pragma cdir shortloop
#line 3556
    for (i=0; i<ni; i++) {
#line 3556
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3556
     /* test for range errors (not always needed but do it anyway) */
#line 3556
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3556
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3556
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3556
    }
#line 3556
   /* update xpp and tp */
#line 3556
    if (realign) xp = (double *) *xpp;
#line 3556
    xp += ni;
#line 3556
    tp += ni;
#line 3556
    *xpp = (void*)xp;
#line 3556
  }
#line 3556
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3556

#line 3556
#else   /* not SX */
#line 3556
	const char *xp = (const char *) *xpp;
#line 3556
	int status = NC_NOERR;
#line 3556

#line 3556
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3556
	{
#line 3556
		const int lstatus = ncx_get_double_uchar(xp, tp);
#line 3556
		if (status == NC_NOERR) /* report the first encountered error */
#line 3556
			status = lstatus;
#line 3556
	}
#line 3556

#line 3556
	*xpp = (const void *)xp;
#line 3556
	return status;
#line 3556
#endif
#line 3556
}
#line 3556

int
#line 3557
ncx_getn_double_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3557
{
#line 3557
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3557

#line 3557
 /* basic algorithm is:
#line 3557
  *   - ensure sane alignment of input data
#line 3557
  *   - copy (conversion happens automatically) input data
#line 3557
  *     to output
#line 3557
  *   - update xpp to point at next unconverted input, and tp to point
#line 3557
  *     at next location for converted output
#line 3557
  */
#line 3557
  long i, j, ni;
#line 3557
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3557
  double *xp;
#line 3557
  int nrange = 0;         /* number of range errors */
#line 3557
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3557
  long cxp = (long) *((char**)xpp);
#line 3557

#line 3557
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3557
  /* sjl: manually stripmine so we can limit amount of
#line 3557
   * vector work space reserved to LOOPCNT elements. Also
#line 3557
   * makes vectorisation easy */
#line 3557
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3557
    ni=Min(nelems-j,LOOPCNT);
#line 3557
    if (realign) {
#line 3557
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3557
      xp = tmp;
#line 3557
    } else {
#line 3557
      xp = (double *) *xpp;
#line 3557
    }
#line 3557
   /* copy the next block */
#line 3557
#pragma cdir loopcnt=LOOPCNT
#line 3557
#pragma cdir shortloop
#line 3557
    for (i=0; i<ni; i++) {
#line 3557
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3557
     /* test for range errors (not always needed but do it anyway) */
#line 3557
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3557
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3557
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3557
    }
#line 3557
   /* update xpp and tp */
#line 3557
    if (realign) xp = (double *) *xpp;
#line 3557
    xp += ni;
#line 3557
    tp += ni;
#line 3557
    *xpp = (void*)xp;
#line 3557
  }
#line 3557
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3557

#line 3557
#else   /* not SX */
#line 3557
	const char *xp = (const char *) *xpp;
#line 3557
	int status = NC_NOERR;
#line 3557

#line 3557
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3557
	{
#line 3557
		const int lstatus = ncx_get_double_ushort(xp, tp);
#line 3557
		if (status == NC_NOERR) /* report the first encountered error */
#line 3557
			status = lstatus;
#line 3557
	}
#line 3557

#line 3557
	*xpp = (const void *)xp;
#line 3557
	return status;
#line 3557
#endif
#line 3557
}
#line 3557

int
#line 3558
ncx_getn_double_uint(const void **xpp, size_t nelems, uint *tp)
#line 3558
{
#line 3558
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3558

#line 3558
 /* basic algorithm is:
#line 3558
  *   - ensure sane alignment of input data
#line 3558
  *   - copy (conversion happens automatically) input data
#line 3558
  *     to output
#line 3558
  *   - update xpp to point at next unconverted input, and tp to point
#line 3558
  *     at next location for converted output
#line 3558
  */
#line 3558
  long i, j, ni;
#line 3558
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3558
  double *xp;
#line 3558
  int nrange = 0;         /* number of range errors */
#line 3558
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3558
  long cxp = (long) *((char**)xpp);
#line 3558

#line 3558
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3558
  /* sjl: manually stripmine so we can limit amount of
#line 3558
   * vector work space reserved to LOOPCNT elements. Also
#line 3558
   * makes vectorisation easy */
#line 3558
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3558
    ni=Min(nelems-j,LOOPCNT);
#line 3558
    if (realign) {
#line 3558
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3558
      xp = tmp;
#line 3558
    } else {
#line 3558
      xp = (double *) *xpp;
#line 3558
    }
#line 3558
   /* copy the next block */
#line 3558
#pragma cdir loopcnt=LOOPCNT
#line 3558
#pragma cdir shortloop
#line 3558
    for (i=0; i<ni; i++) {
#line 3558
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3558
     /* test for range errors (not always needed but do it anyway) */
#line 3558
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3558
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3558
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3558
    }
#line 3558
   /* update xpp and tp */
#line 3558
    if (realign) xp = (double *) *xpp;
#line 3558
    xp += ni;
#line 3558
    tp += ni;
#line 3558
    *xpp = (void*)xp;
#line 3558
  }
#line 3558
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3558

#line 3558
#else   /* not SX */
#line 3558
	const char *xp = (const char *) *xpp;
#line 3558
	int status = NC_NOERR;
#line 3558

#line 3558
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3558
	{
#line 3558
		const int lstatus = ncx_get_double_uint(xp, tp);
#line 3558
		if (status == NC_NOERR) /* report the first encountered error */
#line 3558
			status = lstatus;
#line 3558
	}
#line 3558

#line 3558
	*xpp = (const void *)xp;
#line 3558
	return status;
#line 3558
#endif
#line 3558
}
#line 3558

int
#line 3559
ncx_getn_double_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3559
{
#line 3559
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3559

#line 3559
 /* basic algorithm is:
#line 3559
  *   - ensure sane alignment of input data
#line 3559
  *   - copy (conversion happens automatically) input data
#line 3559
  *     to output
#line 3559
  *   - update xpp to point at next unconverted input, and tp to point
#line 3559
  *     at next location for converted output
#line 3559
  */
#line 3559
  long i, j, ni;
#line 3559
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3559
  double *xp;
#line 3559
  int nrange = 0;         /* number of range errors */
#line 3559
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3559
  long cxp = (long) *((char**)xpp);
#line 3559

#line 3559
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3559
  /* sjl: manually stripmine so we can limit amount of
#line 3559
   * vector work space reserved to LOOPCNT elements. Also
#line 3559
   * makes vectorisation easy */
#line 3559
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3559
    ni=Min(nelems-j,LOOPCNT);
#line 3559
    if (realign) {
#line 3559
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3559
      xp = tmp;
#line 3559
    } else {
#line 3559
      xp = (double *) *xpp;
#line 3559
    }
#line 3559
   /* copy the next block */
#line 3559
#pragma cdir loopcnt=LOOPCNT
#line 3559
#pragma cdir shortloop
#line 3559
    for (i=0; i<ni; i++) {
#line 3559
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3559
     /* test for range errors (not always needed but do it anyway) */
#line 3559
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3559
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3559
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3559
    }
#line 3559
   /* update xpp and tp */
#line 3559
    if (realign) xp = (double *) *xpp;
#line 3559
    xp += ni;
#line 3559
    tp += ni;
#line 3559
    *xpp = (void*)xp;
#line 3559
  }
#line 3559
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3559

#line 3559
#else   /* not SX */
#line 3559
	const char *xp = (const char *) *xpp;
#line 3559
	int status = NC_NOERR;
#line 3559

#line 3559
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3559
	{
#line 3559
		const int lstatus = ncx_get_double_ulonglong(xp, tp);
#line 3559
		if (status == NC_NOERR) /* report the first encountered error */
#line 3559
			status = lstatus;
#line 3559
	}
#line 3559

#line 3559
	*xpp = (const void *)xp;
#line 3559
	return status;
#line 3559
#endif
#line 3559
}
#line 3559


#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_putn_double_double(void **xpp, size_t nelems, const double *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_DOUBLE);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_DOUBLE);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
int
ncx_putn_double_double(void **xpp, size_t ndoubles, const double *ip, void *fillp)
{
	const double *const end = ip + ndoubles;

	while (ip < end)
	{
	const struct vax_double *const vdp =
#line 3582
			(const struct vax_double *)ip;
#line 3582
	struct ieee_double *const idp =
#line 3582
			 (struct ieee_double *) (*xpp);
#line 3582

#line 3582
	if ((vdp->mantissa4 > (dbl_limits[0].d.mantissa4 - 3)) &&
#line 3582
		(vdp->mantissa3 == dbl_limits[0].d.mantissa3) &&
#line 3582
		(vdp->mantissa2 == dbl_limits[0].d.mantissa2) &&
#line 3582
		(vdp->mantissa1 == dbl_limits[0].d.mantissa1) &&
#line 3582
		(vdp->exp == dbl_limits[0].d.exp))
#line 3582
	{
#line 3582
		*idp = dbl_limits[0].ieee;
#line 3582
		goto shipit;
#line 3582
	}
#line 3582
	if ((vdp->mantissa4 == dbl_limits[1].d.mantissa4) &&
#line 3582
		(vdp->mantissa3 == dbl_limits[1].d.mantissa3) &&
#line 3582
		(vdp->mantissa2 == dbl_limits[1].d.mantissa2) &&
#line 3582
		(vdp->mantissa1 == dbl_limits[1].d.mantissa1) &&
#line 3582
		(vdp->exp == dbl_limits[1].d.exp))
#line 3582
	{
#line 3582
		*idp = dbl_limits[1].ieee;
#line 3582
		goto shipit;
#line 3582
	}
#line 3582

#line 3582
	{
#line 3582
		unsigned exp = vdp->exp - VAX_DBL_BIAS + IEEE_DBL_BIAS;
#line 3582

#line 3582
		unsigned mant_lo = ((vdp->mantissa2 & MASK(3)) << 29) |
#line 3582
			(vdp->mantissa3 << 13) |
#line 3582
			((vdp->mantissa4 >> 3) & MASK(13));
#line 3582

#line 3582
		unsigned mant_hi = (vdp->mantissa1 << 13)
#line 3582
				 | (vdp->mantissa2 >> 3);
#line 3582

#line 3582
		if ((vdp->mantissa4 & 7) > 4)
#line 3582
		{
#line 3582
			/* round up */
#line 3582
			mant_lo++;
#line 3582
			if (mant_lo == 0)
#line 3582
			{
#line 3582
				mant_hi++;
#line 3582
				if (mant_hi > 0xffffff)
#line 3582
				{
#line 3582
					mant_hi = 0;
#line 3582
					exp++;
#line 3582
				}
#line 3582
			}
#line 3582
		}
#line 3582

#line 3582
		idp->mant_lo = SWAP4(mant_lo);
#line 3582
		idp->mant_6 = mant_hi >> 16;
#line 3582
		idp->mant_5 = (mant_hi & 0xff00) >> 8;
#line 3582
		idp->mant_4 = mant_hi;
#line 3582
		idp->exp_hi = exp >> 4;
#line 3582
		idp->exp_lo = exp;
#line 3582
	}
#line 3582

#line 3582
	shipit:
#line 3582
		idp->sign = vdp->sign;
#line 3582

		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_DOUBLE;
	}
	return NC_NOERR;
}
	/* vax */
#else
int
ncx_putn_double_double(void **xpp, size_t nelems, const double *tp, void *fillp)
{
	char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		int lstatus = ncx_put_double_double(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
}
#endif
int
#line 3607
ncx_putn_double_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3607
{
#line 3607
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3607

#line 3607
 /* basic algorithm is:
#line 3607
  *   - ensure sane alignment of output data
#line 3607
  *   - copy (conversion happens automatically) input data
#line 3607
  *     to output
#line 3607
  *   - update tp to point at next unconverted input, and xpp to point
#line 3607
  *     at next location for converted output
#line 3607
  */
#line 3607
  long i, j, ni;
#line 3607
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3607
  double *xp;
#line 3607
  int nrange = 0;         /* number of range errors */
#line 3607
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3607
  long cxp = (long) *((char**)xpp);
#line 3607

#line 3607
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3607
  /* sjl: manually stripmine so we can limit amount of
#line 3607
   * vector work space reserved to LOOPCNT elements. Also
#line 3607
   * makes vectorisation easy */
#line 3607
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3607
    ni=Min(nelems-j,LOOPCNT);
#line 3607
    if (realign) {
#line 3607
      xp = tmp;
#line 3607
    } else {
#line 3607
      xp = (double *) *xpp;
#line 3607
    }
#line 3607
   /* copy the next block */
#line 3607
#pragma cdir loopcnt=LOOPCNT
#line 3607
#pragma cdir shortloop
#line 3607
    for (i=0; i<ni; i++) {
#line 3607
      /* the normal case: */
#line 3607
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3607
     /* test for range errors (not always needed but do it anyway) */
#line 3607
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3607
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3607
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3607
    }
#line 3607
   /* copy workspace back if necessary */
#line 3607
    if (realign) {
#line 3607
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3607
      xp = (double *) *xpp;
#line 3607
    }
#line 3607
   /* update xpp and tp */
#line 3607
    xp += ni;
#line 3607
    tp += ni;
#line 3607
    *xpp = (void*)xp;
#line 3607
  }
#line 3607
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3607

#line 3607
#else   /* not SX */
#line 3607

#line 3607
	char *xp = (char *) *xpp;
#line 3607
	int status = NC_NOERR;
#line 3607

#line 3607
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3607
	{
#line 3607
		int lstatus = ncx_put_double_schar(xp, tp, fillp);
#line 3607
		if (status == NC_NOERR) /* report the first encountered error */
#line 3607
			status = lstatus;
#line 3607
	}
#line 3607

#line 3607
	*xpp = (void *)xp;
#line 3607
	return status;
#line 3607
#endif
#line 3607
}
#line 3607

int
#line 3608
ncx_putn_double_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3608
{
#line 3608
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3608

#line 3608
 /* basic algorithm is:
#line 3608
  *   - ensure sane alignment of output data
#line 3608
  *   - copy (conversion happens automatically) input data
#line 3608
  *     to output
#line 3608
  *   - update tp to point at next unconverted input, and xpp to point
#line 3608
  *     at next location for converted output
#line 3608
  */
#line 3608
  long i, j, ni;
#line 3608
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3608
  double *xp;
#line 3608
  int nrange = 0;         /* number of range errors */
#line 3608
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3608
  long cxp = (long) *((char**)xpp);
#line 3608

#line 3608
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3608
  /* sjl: manually stripmine so we can limit amount of
#line 3608
   * vector work space reserved to LOOPCNT elements. Also
#line 3608
   * makes vectorisation easy */
#line 3608
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3608
    ni=Min(nelems-j,LOOPCNT);
#line 3608
    if (realign) {
#line 3608
      xp = tmp;
#line 3608
    } else {
#line 3608
      xp = (double *) *xpp;
#line 3608
    }
#line 3608
   /* copy the next block */
#line 3608
#pragma cdir loopcnt=LOOPCNT
#line 3608
#pragma cdir shortloop
#line 3608
    for (i=0; i<ni; i++) {
#line 3608
      /* the normal case: */
#line 3608
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3608
     /* test for range errors (not always needed but do it anyway) */
#line 3608
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3608
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3608
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3608
    }
#line 3608
   /* copy workspace back if necessary */
#line 3608
    if (realign) {
#line 3608
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3608
      xp = (double *) *xpp;
#line 3608
    }
#line 3608
   /* update xpp and tp */
#line 3608
    xp += ni;
#line 3608
    tp += ni;
#line 3608
    *xpp = (void*)xp;
#line 3608
  }
#line 3608
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3608

#line 3608
#else   /* not SX */
#line 3608

#line 3608
	char *xp = (char *) *xpp;
#line 3608
	int status = NC_NOERR;
#line 3608

#line 3608
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3608
	{
#line 3608
		int lstatus = ncx_put_double_short(xp, tp, fillp);
#line 3608
		if (status == NC_NOERR) /* report the first encountered error */
#line 3608
			status = lstatus;
#line 3608
	}
#line 3608

#line 3608
	*xpp = (void *)xp;
#line 3608
	return status;
#line 3608
#endif
#line 3608
}
#line 3608

int
#line 3609
ncx_putn_double_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3609
{
#line 3609
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3609

#line 3609
 /* basic algorithm is:
#line 3609
  *   - ensure sane alignment of output data
#line 3609
  *   - copy (conversion happens automatically) input data
#line 3609
  *     to output
#line 3609
  *   - update tp to point at next unconverted input, and xpp to point
#line 3609
  *     at next location for converted output
#line 3609
  */
#line 3609
  long i, j, ni;
#line 3609
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3609
  double *xp;
#line 3609
  int nrange = 0;         /* number of range errors */
#line 3609
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3609
  long cxp = (long) *((char**)xpp);
#line 3609

#line 3609
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3609
  /* sjl: manually stripmine so we can limit amount of
#line 3609
   * vector work space reserved to LOOPCNT elements. Also
#line 3609
   * makes vectorisation easy */
#line 3609
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3609
    ni=Min(nelems-j,LOOPCNT);
#line 3609
    if (realign) {
#line 3609
      xp = tmp;
#line 3609
    } else {
#line 3609
      xp = (double *) *xpp;
#line 3609
    }
#line 3609
   /* copy the next block */
#line 3609
#pragma cdir loopcnt=LOOPCNT
#line 3609
#pragma cdir shortloop
#line 3609
    for (i=0; i<ni; i++) {
#line 3609
      /* the normal case: */
#line 3609
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3609
     /* test for range errors (not always needed but do it anyway) */
#line 3609
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3609
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3609
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3609
    }
#line 3609
   /* copy workspace back if necessary */
#line 3609
    if (realign) {
#line 3609
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3609
      xp = (double *) *xpp;
#line 3609
    }
#line 3609
   /* update xpp and tp */
#line 3609
    xp += ni;
#line 3609
    tp += ni;
#line 3609
    *xpp = (void*)xp;
#line 3609
  }
#line 3609
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3609

#line 3609
#else   /* not SX */
#line 3609

#line 3609
	char *xp = (char *) *xpp;
#line 3609
	int status = NC_NOERR;
#line 3609

#line 3609
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3609
	{
#line 3609
		int lstatus = ncx_put_double_int(xp, tp, fillp);
#line 3609
		if (status == NC_NOERR) /* report the first encountered error */
#line 3609
			status = lstatus;
#line 3609
	}
#line 3609

#line 3609
	*xpp = (void *)xp;
#line 3609
	return status;
#line 3609
#endif
#line 3609
}
#line 3609

int
#line 3610
ncx_putn_double_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3610
{
#line 3610
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3610

#line 3610
 /* basic algorithm is:
#line 3610
  *   - ensure sane alignment of output data
#line 3610
  *   - copy (conversion happens automatically) input data
#line 3610
  *     to output
#line 3610
  *   - update tp to point at next unconverted input, and xpp to point
#line 3610
  *     at next location for converted output
#line 3610
  */
#line 3610
  long i, j, ni;
#line 3610
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3610
  double *xp;
#line 3610
  int nrange = 0;         /* number of range errors */
#line 3610
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3610
  long cxp = (long) *((char**)xpp);
#line 3610

#line 3610
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3610
  /* sjl: manually stripmine so we can limit amount of
#line 3610
   * vector work space reserved to LOOPCNT elements. Also
#line 3610
   * makes vectorisation easy */
#line 3610
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3610
    ni=Min(nelems-j,LOOPCNT);
#line 3610
    if (realign) {
#line 3610
      xp = tmp;
#line 3610
    } else {
#line 3610
      xp = (double *) *xpp;
#line 3610
    }
#line 3610
   /* copy the next block */
#line 3610
#pragma cdir loopcnt=LOOPCNT
#line 3610
#pragma cdir shortloop
#line 3610
    for (i=0; i<ni; i++) {
#line 3610
      /* the normal case: */
#line 3610
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3610
     /* test for range errors (not always needed but do it anyway) */
#line 3610
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3610
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3610
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3610
    }
#line 3610
   /* copy workspace back if necessary */
#line 3610
    if (realign) {
#line 3610
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3610
      xp = (double *) *xpp;
#line 3610
    }
#line 3610
   /* update xpp and tp */
#line 3610
    xp += ni;
#line 3610
    tp += ni;
#line 3610
    *xpp = (void*)xp;
#line 3610
  }
#line 3610
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3610

#line 3610
#else   /* not SX */
#line 3610

#line 3610
	char *xp = (char *) *xpp;
#line 3610
	int status = NC_NOERR;
#line 3610

#line 3610
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3610
	{
#line 3610
		int lstatus = ncx_put_double_long(xp, tp, fillp);
#line 3610
		if (status == NC_NOERR) /* report the first encountered error */
#line 3610
			status = lstatus;
#line 3610
	}
#line 3610

#line 3610
	*xpp = (void *)xp;
#line 3610
	return status;
#line 3610
#endif
#line 3610
}
#line 3610

int
#line 3611
ncx_putn_double_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3611
{
#line 3611
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3611

#line 3611
 /* basic algorithm is:
#line 3611
  *   - ensure sane alignment of output data
#line 3611
  *   - copy (conversion happens automatically) input data
#line 3611
  *     to output
#line 3611
  *   - update tp to point at next unconverted input, and xpp to point
#line 3611
  *     at next location for converted output
#line 3611
  */
#line 3611
  long i, j, ni;
#line 3611
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3611
  double *xp;
#line 3611
  int nrange = 0;         /* number of range errors */
#line 3611
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3611
  long cxp = (long) *((char**)xpp);
#line 3611

#line 3611
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3611
  /* sjl: manually stripmine so we can limit amount of
#line 3611
   * vector work space reserved to LOOPCNT elements. Also
#line 3611
   * makes vectorisation easy */
#line 3611
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3611
    ni=Min(nelems-j,LOOPCNT);
#line 3611
    if (realign) {
#line 3611
      xp = tmp;
#line 3611
    } else {
#line 3611
      xp = (double *) *xpp;
#line 3611
    }
#line 3611
   /* copy the next block */
#line 3611
#pragma cdir loopcnt=LOOPCNT
#line 3611
#pragma cdir shortloop
#line 3611
    for (i=0; i<ni; i++) {
#line 3611
      /* the normal case: */
#line 3611
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3611
     /* test for range errors (not always needed but do it anyway) */
#line 3611
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3611
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3611
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3611
    }
#line 3611
   /* copy workspace back if necessary */
#line 3611
    if (realign) {
#line 3611
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3611
      xp = (double *) *xpp;
#line 3611
    }
#line 3611
   /* update xpp and tp */
#line 3611
    xp += ni;
#line 3611
    tp += ni;
#line 3611
    *xpp = (void*)xp;
#line 3611
  }
#line 3611
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3611

#line 3611
#else   /* not SX */
#line 3611

#line 3611
	char *xp = (char *) *xpp;
#line 3611
	int status = NC_NOERR;
#line 3611

#line 3611
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3611
	{
#line 3611
		int lstatus = ncx_put_double_float(xp, tp, fillp);
#line 3611
		if (status == NC_NOERR) /* report the first encountered error */
#line 3611
			status = lstatus;
#line 3611
	}
#line 3611

#line 3611
	*xpp = (void *)xp;
#line 3611
	return status;
#line 3611
#endif
#line 3611
}
#line 3611

int
#line 3612
ncx_putn_double_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3612
{
#line 3612
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3612

#line 3612
 /* basic algorithm is:
#line 3612
  *   - ensure sane alignment of output data
#line 3612
  *   - copy (conversion happens automatically) input data
#line 3612
  *     to output
#line 3612
  *   - update tp to point at next unconverted input, and xpp to point
#line 3612
  *     at next location for converted output
#line 3612
  */
#line 3612
  long i, j, ni;
#line 3612
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3612
  double *xp;
#line 3612
  int nrange = 0;         /* number of range errors */
#line 3612
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3612
  long cxp = (long) *((char**)xpp);
#line 3612

#line 3612
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3612
  /* sjl: manually stripmine so we can limit amount of
#line 3612
   * vector work space reserved to LOOPCNT elements. Also
#line 3612
   * makes vectorisation easy */
#line 3612
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3612
    ni=Min(nelems-j,LOOPCNT);
#line 3612
    if (realign) {
#line 3612
      xp = tmp;
#line 3612
    } else {
#line 3612
      xp = (double *) *xpp;
#line 3612
    }
#line 3612
   /* copy the next block */
#line 3612
#pragma cdir loopcnt=LOOPCNT
#line 3612
#pragma cdir shortloop
#line 3612
    for (i=0; i<ni; i++) {
#line 3612
      /* the normal case: */
#line 3612
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3612
     /* test for range errors (not always needed but do it anyway) */
#line 3612
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3612
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3612
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3612
    }
#line 3612
   /* copy workspace back if necessary */
#line 3612
    if (realign) {
#line 3612
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3612
      xp = (double *) *xpp;
#line 3612
    }
#line 3612
   /* update xpp and tp */
#line 3612
    xp += ni;
#line 3612
    tp += ni;
#line 3612
    *xpp = (void*)xp;
#line 3612
  }
#line 3612
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3612

#line 3612
#else   /* not SX */
#line 3612

#line 3612
	char *xp = (char *) *xpp;
#line 3612
	int status = NC_NOERR;
#line 3612

#line 3612
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3612
	{
#line 3612
		int lstatus = ncx_put_double_longlong(xp, tp, fillp);
#line 3612
		if (status == NC_NOERR) /* report the first encountered error */
#line 3612
			status = lstatus;
#line 3612
	}
#line 3612

#line 3612
	*xpp = (void *)xp;
#line 3612
	return status;
#line 3612
#endif
#line 3612
}
#line 3612

int
#line 3613
ncx_putn_double_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3613
{
#line 3613
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3613

#line 3613
 /* basic algorithm is:
#line 3613
  *   - ensure sane alignment of output data
#line 3613
  *   - copy (conversion happens automatically) input data
#line 3613
  *     to output
#line 3613
  *   - update tp to point at next unconverted input, and xpp to point
#line 3613
  *     at next location for converted output
#line 3613
  */
#line 3613
  long i, j, ni;
#line 3613
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3613
  double *xp;
#line 3613
  int nrange = 0;         /* number of range errors */
#line 3613
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3613
  long cxp = (long) *((char**)xpp);
#line 3613

#line 3613
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3613
  /* sjl: manually stripmine so we can limit amount of
#line 3613
   * vector work space reserved to LOOPCNT elements. Also
#line 3613
   * makes vectorisation easy */
#line 3613
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3613
    ni=Min(nelems-j,LOOPCNT);
#line 3613
    if (realign) {
#line 3613
      xp = tmp;
#line 3613
    } else {
#line 3613
      xp = (double *) *xpp;
#line 3613
    }
#line 3613
   /* copy the next block */
#line 3613
#pragma cdir loopcnt=LOOPCNT
#line 3613
#pragma cdir shortloop
#line 3613
    for (i=0; i<ni; i++) {
#line 3613
      /* the normal case: */
#line 3613
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3613
     /* test for range errors (not always needed but do it anyway) */
#line 3613
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3613
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3613
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3613
    }
#line 3613
   /* copy workspace back if necessary */
#line 3613
    if (realign) {
#line 3613
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3613
      xp = (double *) *xpp;
#line 3613
    }
#line 3613
   /* update xpp and tp */
#line 3613
    xp += ni;
#line 3613
    tp += ni;
#line 3613
    *xpp = (void*)xp;
#line 3613
  }
#line 3613
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3613

#line 3613
#else   /* not SX */
#line 3613

#line 3613
	char *xp = (char *) *xpp;
#line 3613
	int status = NC_NOERR;
#line 3613

#line 3613
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3613
	{
#line 3613
		int lstatus = ncx_put_double_uchar(xp, tp, fillp);
#line 3613
		if (status == NC_NOERR) /* report the first encountered error */
#line 3613
			status = lstatus;
#line 3613
	}
#line 3613

#line 3613
	*xpp = (void *)xp;
#line 3613
	return status;
#line 3613
#endif
#line 3613
}
#line 3613

int
#line 3614
ncx_putn_double_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3614
{
#line 3614
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3614

#line 3614
 /* basic algorithm is:
#line 3614
  *   - ensure sane alignment of output data
#line 3614
  *   - copy (conversion happens automatically) input data
#line 3614
  *     to output
#line 3614
  *   - update tp to point at next unconverted input, and xpp to point
#line 3614
  *     at next location for converted output
#line 3614
  */
#line 3614
  long i, j, ni;
#line 3614
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3614
  double *xp;
#line 3614
  int nrange = 0;         /* number of range errors */
#line 3614
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3614
  long cxp = (long) *((char**)xpp);
#line 3614

#line 3614
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3614
  /* sjl: manually stripmine so we can limit amount of
#line 3614
   * vector work space reserved to LOOPCNT elements. Also
#line 3614
   * makes vectorisation easy */
#line 3614
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3614
    ni=Min(nelems-j,LOOPCNT);
#line 3614
    if (realign) {
#line 3614
      xp = tmp;
#line 3614
    } else {
#line 3614
      xp = (double *) *xpp;
#line 3614
    }
#line 3614
   /* copy the next block */
#line 3614
#pragma cdir loopcnt=LOOPCNT
#line 3614
#pragma cdir shortloop
#line 3614
    for (i=0; i<ni; i++) {
#line 3614
      /* the normal case: */
#line 3614
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3614
     /* test for range errors (not always needed but do it anyway) */
#line 3614
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3614
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3614
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3614
    }
#line 3614
   /* copy workspace back if necessary */
#line 3614
    if (realign) {
#line 3614
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3614
      xp = (double *) *xpp;
#line 3614
    }
#line 3614
   /* update xpp and tp */
#line 3614
    xp += ni;
#line 3614
    tp += ni;
#line 3614
    *xpp = (void*)xp;
#line 3614
  }
#line 3614
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3614

#line 3614
#else   /* not SX */
#line 3614

#line 3614
	char *xp = (char *) *xpp;
#line 3614
	int status = NC_NOERR;
#line 3614

#line 3614
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3614
	{
#line 3614
		int lstatus = ncx_put_double_ushort(xp, tp, fillp);
#line 3614
		if (status == NC_NOERR) /* report the first encountered error */
#line 3614
			status = lstatus;
#line 3614
	}
#line 3614

#line 3614
	*xpp = (void *)xp;
#line 3614
	return status;
#line 3614
#endif
#line 3614
}
#line 3614

int
#line 3615
ncx_putn_double_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3615
{
#line 3615
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3615

#line 3615
 /* basic algorithm is:
#line 3615
  *   - ensure sane alignment of output data
#line 3615
  *   - copy (conversion happens automatically) input data
#line 3615
  *     to output
#line 3615
  *   - update tp to point at next unconverted input, and xpp to point
#line 3615
  *     at next location for converted output
#line 3615
  */
#line 3615
  long i, j, ni;
#line 3615
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3615
  double *xp;
#line 3615
  int nrange = 0;         /* number of range errors */
#line 3615
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3615
  long cxp = (long) *((char**)xpp);
#line 3615

#line 3615
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3615
  /* sjl: manually stripmine so we can limit amount of
#line 3615
   * vector work space reserved to LOOPCNT elements. Also
#line 3615
   * makes vectorisation easy */
#line 3615
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3615
    ni=Min(nelems-j,LOOPCNT);
#line 3615
    if (realign) {
#line 3615
      xp = tmp;
#line 3615
    } else {
#line 3615
      xp = (double *) *xpp;
#line 3615
    }
#line 3615
   /* copy the next block */
#line 3615
#pragma cdir loopcnt=LOOPCNT
#line 3615
#pragma cdir shortloop
#line 3615
    for (i=0; i<ni; i++) {
#line 3615
      /* the normal case: */
#line 3615
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3615
     /* test for range errors (not always needed but do it anyway) */
#line 3615
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3615
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3615
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3615
    }
#line 3615
   /* copy workspace back if necessary */
#line 3615
    if (realign) {
#line 3615
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3615
      xp = (double *) *xpp;
#line 3615
    }
#line 3615
   /* update xpp and tp */
#line 3615
    xp += ni;
#line 3615
    tp += ni;
#line 3615
    *xpp = (void*)xp;
#line 3615
  }
#line 3615
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3615

#line 3615
#else   /* not SX */
#line 3615

#line 3615
	char *xp = (char *) *xpp;
#line 3615
	int status = NC_NOERR;
#line 3615

#line 3615
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3615
	{
#line 3615
		int lstatus = ncx_put_double_uint(xp, tp, fillp);
#line 3615
		if (status == NC_NOERR) /* report the first encountered error */
#line 3615
			status = lstatus;
#line 3615
	}
#line 3615

#line 3615
	*xpp = (void *)xp;
#line 3615
	return status;
#line 3615
#endif
#line 3615
}
#line 3615

int
#line 3616
ncx_putn_double_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3616
{
#line 3616
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3616

#line 3616
 /* basic algorithm is:
#line 3616
  *   - ensure sane alignment of output data
#line 3616
  *   - copy (conversion happens automatically) input data
#line 3616
  *     to output
#line 3616
  *   - update tp to point at next unconverted input, and xpp to point
#line 3616
  *     at next location for converted output
#line 3616
  */
#line 3616
  long i, j, ni;
#line 3616
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3616
  double *xp;
#line 3616
  int nrange = 0;         /* number of range errors */
#line 3616
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3616
  long cxp = (long) *((char**)xpp);
#line 3616

#line 3616
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3616
  /* sjl: manually stripmine so we can limit amount of
#line 3616
   * vector work space reserved to LOOPCNT elements. Also
#line 3616
   * makes vectorisation easy */
#line 3616
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3616
    ni=Min(nelems-j,LOOPCNT);
#line 3616
    if (realign) {
#line 3616
      xp = tmp;
#line 3616
    } else {
#line 3616
      xp = (double *) *xpp;
#line 3616
    }
#line 3616
   /* copy the next block */
#line 3616
#pragma cdir loopcnt=LOOPCNT
#line 3616
#pragma cdir shortloop
#line 3616
    for (i=0; i<ni; i++) {
#line 3616
      /* the normal case: */
#line 3616
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3616
     /* test for range errors (not always needed but do it anyway) */
#line 3616
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3616
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3616
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3616
    }
#line 3616
   /* copy workspace back if necessary */
#line 3616
    if (realign) {
#line 3616
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3616
      xp = (double *) *xpp;
#line 3616
    }
#line 3616
   /* update xpp and tp */
#line 3616
    xp += ni;
#line 3616
    tp += ni;
#line 3616
    *xpp = (void*)xp;
#line 3616
  }
#line 3616
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3616

#line 3616
#else   /* not SX */
#line 3616

#line 3616
	char *xp = (char *) *xpp;
#line 3616
	int status = NC_NOERR;
#line 3616

#line 3616
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3616
	{
#line 3616
		int lstatus = ncx_put_double_ulonglong(xp, tp, fillp);
#line 3616
		if (status == NC_NOERR) /* report the first encountered error */
#line 3616
			status = lstatus;
#line 3616
	}
#line 3616

#line 3616
	*xpp = (void *)xp;
#line 3616
	return status;
#line 3616
#endif
#line 3616
}
#line 3616



/* longlong ------------------------------------------------------------------*/

#if X_SIZEOF_INT64 == SIZEOF_LONGLONG
/* optimized version */
int
ncx_getn_longlong_longlong(const void **xpp, size_t nelems, long long *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_LONG_LONG);
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_INT64);
	return NC_NOERR;
}
#else
int
#line 3635
ncx_getn_longlong_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3635
{
#line 3635
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3635

#line 3635
 /* basic algorithm is:
#line 3635
  *   - ensure sane alignment of input data
#line 3635
  *   - copy (conversion happens automatically) input data
#line 3635
  *     to output
#line 3635
  *   - update xpp to point at next unconverted input, and tp to point
#line 3635
  *     at next location for converted output
#line 3635
  */
#line 3635
  long i, j, ni;
#line 3635
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3635
  int64 *xp;
#line 3635
  int nrange = 0;         /* number of range errors */
#line 3635
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3635
  long cxp = (long) *((char**)xpp);
#line 3635

#line 3635
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3635
  /* sjl: manually stripmine so we can limit amount of
#line 3635
   * vector work space reserved to LOOPCNT elements. Also
#line 3635
   * makes vectorisation easy */
#line 3635
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3635
    ni=Min(nelems-j,LOOPCNT);
#line 3635
    if (realign) {
#line 3635
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3635
      xp = tmp;
#line 3635
    } else {
#line 3635
      xp = (int64 *) *xpp;
#line 3635
    }
#line 3635
   /* copy the next block */
#line 3635
#pragma cdir loopcnt=LOOPCNT
#line 3635
#pragma cdir shortloop
#line 3635
    for (i=0; i<ni; i++) {
#line 3635
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3635
     /* test for range errors (not always needed but do it anyway) */
#line 3635
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3635
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3635
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3635
    }
#line 3635
   /* update xpp and tp */
#line 3635
    if (realign) xp = (int64 *) *xpp;
#line 3635
    xp += ni;
#line 3635
    tp += ni;
#line 3635
    *xpp = (void*)xp;
#line 3635
  }
#line 3635
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3635

#line 3635
#else   /* not SX */
#line 3635
	const char *xp = (const char *) *xpp;
#line 3635
	int status = NC_NOERR;
#line 3635

#line 3635
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3635
	{
#line 3635
		const int lstatus = ncx_get_longlong_longlong(xp, tp);
#line 3635
		if (status == NC_NOERR) /* report the first encountered error */
#line 3635
			status = lstatus;
#line 3635
	}
#line 3635

#line 3635
	*xpp = (const void *)xp;
#line 3635
	return status;
#line 3635
#endif
#line 3635
}
#line 3635

#endif
int
#line 3637
ncx_getn_longlong_schar(const void **xpp, size_t nelems, schar *tp)
#line 3637
{
#line 3637
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3637

#line 3637
 /* basic algorithm is:
#line 3637
  *   - ensure sane alignment of input data
#line 3637
  *   - copy (conversion happens automatically) input data
#line 3637
  *     to output
#line 3637
  *   - update xpp to point at next unconverted input, and tp to point
#line 3637
  *     at next location for converted output
#line 3637
  */
#line 3637
  long i, j, ni;
#line 3637
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3637
  int64 *xp;
#line 3637
  int nrange = 0;         /* number of range errors */
#line 3637
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3637
  long cxp = (long) *((char**)xpp);
#line 3637

#line 3637
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3637
  /* sjl: manually stripmine so we can limit amount of
#line 3637
   * vector work space reserved to LOOPCNT elements. Also
#line 3637
   * makes vectorisation easy */
#line 3637
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3637
    ni=Min(nelems-j,LOOPCNT);
#line 3637
    if (realign) {
#line 3637
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3637
      xp = tmp;
#line 3637
    } else {
#line 3637
      xp = (int64 *) *xpp;
#line 3637
    }
#line 3637
   /* copy the next block */
#line 3637
#pragma cdir loopcnt=LOOPCNT
#line 3637
#pragma cdir shortloop
#line 3637
    for (i=0; i<ni; i++) {
#line 3637
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3637
     /* test for range errors (not always needed but do it anyway) */
#line 3637
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3637
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3637
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3637
    }
#line 3637
   /* update xpp and tp */
#line 3637
    if (realign) xp = (int64 *) *xpp;
#line 3637
    xp += ni;
#line 3637
    tp += ni;
#line 3637
    *xpp = (void*)xp;
#line 3637
  }
#line 3637
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3637

#line 3637
#else   /* not SX */
#line 3637
	const char *xp = (const char *) *xpp;
#line 3637
	int status = NC_NOERR;
#line 3637

#line 3637
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3637
	{
#line 3637
		const int lstatus = ncx_get_longlong_schar(xp, tp);
#line 3637
		if (status == NC_NOERR) /* report the first encountered error */
#line 3637
			status = lstatus;
#line 3637
	}
#line 3637

#line 3637
	*xpp = (const void *)xp;
#line 3637
	return status;
#line 3637
#endif
#line 3637
}
#line 3637

int
#line 3638
ncx_getn_longlong_short(const void **xpp, size_t nelems, short *tp)
#line 3638
{
#line 3638
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3638

#line 3638
 /* basic algorithm is:
#line 3638
  *   - ensure sane alignment of input data
#line 3638
  *   - copy (conversion happens automatically) input data
#line 3638
  *     to output
#line 3638
  *   - update xpp to point at next unconverted input, and tp to point
#line 3638
  *     at next location for converted output
#line 3638
  */
#line 3638
  long i, j, ni;
#line 3638
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3638
  int64 *xp;
#line 3638
  int nrange = 0;         /* number of range errors */
#line 3638
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3638
  long cxp = (long) *((char**)xpp);
#line 3638

#line 3638
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3638
  /* sjl: manually stripmine so we can limit amount of
#line 3638
   * vector work space reserved to LOOPCNT elements. Also
#line 3638
   * makes vectorisation easy */
#line 3638
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3638
    ni=Min(nelems-j,LOOPCNT);
#line 3638
    if (realign) {
#line 3638
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3638
      xp = tmp;
#line 3638
    } else {
#line 3638
      xp = (int64 *) *xpp;
#line 3638
    }
#line 3638
   /* copy the next block */
#line 3638
#pragma cdir loopcnt=LOOPCNT
#line 3638
#pragma cdir shortloop
#line 3638
    for (i=0; i<ni; i++) {
#line 3638
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3638
     /* test for range errors (not always needed but do it anyway) */
#line 3638
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3638
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3638
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3638
    }
#line 3638
   /* update xpp and tp */
#line 3638
    if (realign) xp = (int64 *) *xpp;
#line 3638
    xp += ni;
#line 3638
    tp += ni;
#line 3638
    *xpp = (void*)xp;
#line 3638
  }
#line 3638
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3638

#line 3638
#else   /* not SX */
#line 3638
	const char *xp = (const char *) *xpp;
#line 3638
	int status = NC_NOERR;
#line 3638

#line 3638
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3638
	{
#line 3638
		const int lstatus = ncx_get_longlong_short(xp, tp);
#line 3638
		if (status == NC_NOERR) /* report the first encountered error */
#line 3638
			status = lstatus;
#line 3638
	}
#line 3638

#line 3638
	*xpp = (const void *)xp;
#line 3638
	return status;
#line 3638
#endif
#line 3638
}
#line 3638

int
#line 3639
ncx_getn_longlong_int(const void **xpp, size_t nelems, int *tp)
#line 3639
{
#line 3639
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3639

#line 3639
 /* basic algorithm is:
#line 3639
  *   - ensure sane alignment of input data
#line 3639
  *   - copy (conversion happens automatically) input data
#line 3639
  *     to output
#line 3639
  *   - update xpp to point at next unconverted input, and tp to point
#line 3639
  *     at next location for converted output
#line 3639
  */
#line 3639
  long i, j, ni;
#line 3639
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3639
  int64 *xp;
#line 3639
  int nrange = 0;         /* number of range errors */
#line 3639
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3639
  long cxp = (long) *((char**)xpp);
#line 3639

#line 3639
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3639
  /* sjl: manually stripmine so we can limit amount of
#line 3639
   * vector work space reserved to LOOPCNT elements. Also
#line 3639
   * makes vectorisation easy */
#line 3639
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3639
    ni=Min(nelems-j,LOOPCNT);
#line 3639
    if (realign) {
#line 3639
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3639
      xp = tmp;
#line 3639
    } else {
#line 3639
      xp = (int64 *) *xpp;
#line 3639
    }
#line 3639
   /* copy the next block */
#line 3639
#pragma cdir loopcnt=LOOPCNT
#line 3639
#pragma cdir shortloop
#line 3639
    for (i=0; i<ni; i++) {
#line 3639
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3639
     /* test for range errors (not always needed but do it anyway) */
#line 3639
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3639
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3639
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3639
    }
#line 3639
   /* update xpp and tp */
#line 3639
    if (realign) xp = (int64 *) *xpp;
#line 3639
    xp += ni;
#line 3639
    tp += ni;
#line 3639
    *xpp = (void*)xp;
#line 3639
  }
#line 3639
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3639

#line 3639
#else   /* not SX */
#line 3639
	const char *xp = (const char *) *xpp;
#line 3639
	int status = NC_NOERR;
#line 3639

#line 3639
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3639
	{
#line 3639
		const int lstatus = ncx_get_longlong_int(xp, tp);
#line 3639
		if (status == NC_NOERR) /* report the first encountered error */
#line 3639
			status = lstatus;
#line 3639
	}
#line 3639

#line 3639
	*xpp = (const void *)xp;
#line 3639
	return status;
#line 3639
#endif
#line 3639
}
#line 3639

int
#line 3640
ncx_getn_longlong_long(const void **xpp, size_t nelems, long *tp)
#line 3640
{
#line 3640
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3640

#line 3640
 /* basic algorithm is:
#line 3640
  *   - ensure sane alignment of input data
#line 3640
  *   - copy (conversion happens automatically) input data
#line 3640
  *     to output
#line 3640
  *   - update xpp to point at next unconverted input, and tp to point
#line 3640
  *     at next location for converted output
#line 3640
  */
#line 3640
  long i, j, ni;
#line 3640
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3640
  int64 *xp;
#line 3640
  int nrange = 0;         /* number of range errors */
#line 3640
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3640
  long cxp = (long) *((char**)xpp);
#line 3640

#line 3640
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3640
  /* sjl: manually stripmine so we can limit amount of
#line 3640
   * vector work space reserved to LOOPCNT elements. Also
#line 3640
   * makes vectorisation easy */
#line 3640
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3640
    ni=Min(nelems-j,LOOPCNT);
#line 3640
    if (realign) {
#line 3640
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3640
      xp = tmp;
#line 3640
    } else {
#line 3640
      xp = (int64 *) *xpp;
#line 3640
    }
#line 3640
   /* copy the next block */
#line 3640
#pragma cdir loopcnt=LOOPCNT
#line 3640
#pragma cdir shortloop
#line 3640
    for (i=0; i<ni; i++) {
#line 3640
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3640
     /* test for range errors (not always needed but do it anyway) */
#line 3640
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3640
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3640
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3640
    }
#line 3640
   /* update xpp and tp */
#line 3640
    if (realign) xp = (int64 *) *xpp;
#line 3640
    xp += ni;
#line 3640
    tp += ni;
#line 3640
    *xpp = (void*)xp;
#line 3640
  }
#line 3640
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3640

#line 3640
#else   /* not SX */
#line 3640
	const char *xp = (const char *) *xpp;
#line 3640
	int status = NC_NOERR;
#line 3640

#line 3640
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3640
	{
#line 3640
		const int lstatus = ncx_get_longlong_long(xp, tp);
#line 3640
		if (status == NC_NOERR) /* report the first encountered error */
#line 3640
			status = lstatus;
#line 3640
	}
#line 3640

#line 3640
	*xpp = (const void *)xp;
#line 3640
	return status;
#line 3640
#endif
#line 3640
}
#line 3640

int
#line 3641
ncx_getn_longlong_float(const void **xpp, size_t nelems, float *tp)
#line 3641
{
#line 3641
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3641

#line 3641
 /* basic algorithm is:
#line 3641
  *   - ensure sane alignment of input data
#line 3641
  *   - copy (conversion happens automatically) input data
#line 3641
  *     to output
#line 3641
  *   - update xpp to point at next unconverted input, and tp to point
#line 3641
  *     at next location for converted output
#line 3641
  */
#line 3641
  long i, j, ni;
#line 3641
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3641
  int64 *xp;
#line 3641
  int nrange = 0;         /* number of range errors */
#line 3641
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3641
  long cxp = (long) *((char**)xpp);
#line 3641

#line 3641
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3641
  /* sjl: manually stripmine so we can limit amount of
#line 3641
   * vector work space reserved to LOOPCNT elements. Also
#line 3641
   * makes vectorisation easy */
#line 3641
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3641
    ni=Min(nelems-j,LOOPCNT);
#line 3641
    if (realign) {
#line 3641
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3641
      xp = tmp;
#line 3641
    } else {
#line 3641
      xp = (int64 *) *xpp;
#line 3641
    }
#line 3641
   /* copy the next block */
#line 3641
#pragma cdir loopcnt=LOOPCNT
#line 3641
#pragma cdir shortloop
#line 3641
    for (i=0; i<ni; i++) {
#line 3641
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3641
     /* test for range errors (not always needed but do it anyway) */
#line 3641
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3641
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3641
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3641
    }
#line 3641
   /* update xpp and tp */
#line 3641
    if (realign) xp = (int64 *) *xpp;
#line 3641
    xp += ni;
#line 3641
    tp += ni;
#line 3641
    *xpp = (void*)xp;
#line 3641
  }
#line 3641
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3641

#line 3641
#else   /* not SX */
#line 3641
	const char *xp = (const char *) *xpp;
#line 3641
	int status = NC_NOERR;
#line 3641

#line 3641
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3641
	{
#line 3641
		const int lstatus = ncx_get_longlong_float(xp, tp);
#line 3641
		if (status == NC_NOERR) /* report the first encountered error */
#line 3641
			status = lstatus;
#line 3641
	}
#line 3641

#line 3641
	*xpp = (const void *)xp;
#line 3641
	return status;
#line 3641
#endif
#line 3641
}
#line 3641

int
#line 3642
ncx_getn_longlong_double(const void **xpp, size_t nelems, double *tp)
#line 3642
{
#line 3642
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3642

#line 3642
 /* basic algorithm is:
#line 3642
  *   - ensure sane alignment of input data
#line 3642
  *   - copy (conversion happens automatically) input data
#line 3642
  *     to output
#line 3642
  *   - update xpp to point at next unconverted input, and tp to point
#line 3642
  *     at next location for converted output
#line 3642
  */
#line 3642
  long i, j, ni;
#line 3642
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3642
  int64 *xp;
#line 3642
  int nrange = 0;         /* number of range errors */
#line 3642
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3642
  long cxp = (long) *((char**)xpp);
#line 3642

#line 3642
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3642
  /* sjl: manually stripmine so we can limit amount of
#line 3642
   * vector work space reserved to LOOPCNT elements. Also
#line 3642
   * makes vectorisation easy */
#line 3642
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3642
    ni=Min(nelems-j,LOOPCNT);
#line 3642
    if (realign) {
#line 3642
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3642
      xp = tmp;
#line 3642
    } else {
#line 3642
      xp = (int64 *) *xpp;
#line 3642
    }
#line 3642
   /* copy the next block */
#line 3642
#pragma cdir loopcnt=LOOPCNT
#line 3642
#pragma cdir shortloop
#line 3642
    for (i=0; i<ni; i++) {
#line 3642
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3642
     /* test for range errors (not always needed but do it anyway) */
#line 3642
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3642
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3642
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3642
    }
#line 3642
   /* update xpp and tp */
#line 3642
    if (realign) xp = (int64 *) *xpp;
#line 3642
    xp += ni;
#line 3642
    tp += ni;
#line 3642
    *xpp = (void*)xp;
#line 3642
  }
#line 3642
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3642

#line 3642
#else   /* not SX */
#line 3642
	const char *xp = (const char *) *xpp;
#line 3642
	int status = NC_NOERR;
#line 3642

#line 3642
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3642
	{
#line 3642
		const int lstatus = ncx_get_longlong_double(xp, tp);
#line 3642
		if (status == NC_NOERR) /* report the first encountered error */
#line 3642
			status = lstatus;
#line 3642
	}
#line 3642

#line 3642
	*xpp = (const void *)xp;
#line 3642
	return status;
#line 3642
#endif
#line 3642
}
#line 3642

int
#line 3643
ncx_getn_longlong_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3643
{
#line 3643
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3643

#line 3643
 /* basic algorithm is:
#line 3643
  *   - ensure sane alignment of input data
#line 3643
  *   - copy (conversion happens automatically) input data
#line 3643
  *     to output
#line 3643
  *   - update xpp to point at next unconverted input, and tp to point
#line 3643
  *     at next location for converted output
#line 3643
  */
#line 3643
  long i, j, ni;
#line 3643
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3643
  int64 *xp;
#line 3643
  int nrange = 0;         /* number of range errors */
#line 3643
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3643
  long cxp = (long) *((char**)xpp);
#line 3643

#line 3643
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3643
  /* sjl: manually stripmine so we can limit amount of
#line 3643
   * vector work space reserved to LOOPCNT elements. Also
#line 3643
   * makes vectorisation easy */
#line 3643
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3643
    ni=Min(nelems-j,LOOPCNT);
#line 3643
    if (realign) {
#line 3643
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3643
      xp = tmp;
#line 3643
    } else {
#line 3643
      xp = (int64 *) *xpp;
#line 3643
    }
#line 3643
   /* copy the next block */
#line 3643
#pragma cdir loopcnt=LOOPCNT
#line 3643
#pragma cdir shortloop
#line 3643
    for (i=0; i<ni; i++) {
#line 3643
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3643
     /* test for range errors (not always needed but do it anyway) */
#line 3643
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3643
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3643
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3643
    }
#line 3643
   /* update xpp and tp */
#line 3643
    if (realign) xp = (int64 *) *xpp;
#line 3643
    xp += ni;
#line 3643
    tp += ni;
#line 3643
    *xpp = (void*)xp;
#line 3643
  }
#line 3643
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3643

#line 3643
#else   /* not SX */
#line 3643
	const char *xp = (const char *) *xpp;
#line 3643
	int status = NC_NOERR;
#line 3643

#line 3643
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3643
	{
#line 3643
		const int lstatus = ncx_get_longlong_uchar(xp, tp);
#line 3643
		if (status == NC_NOERR) /* report the first encountered error */
#line 3643
			status = lstatus;
#line 3643
	}
#line 3643

#line 3643
	*xpp = (const void *)xp;
#line 3643
	return status;
#line 3643
#endif
#line 3643
}
#line 3643

int
#line 3644
ncx_getn_longlong_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3644
{
#line 3644
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3644

#line 3644
 /* basic algorithm is:
#line 3644
  *   - ensure sane alignment of input data
#line 3644
  *   - copy (conversion happens automatically) input data
#line 3644
  *     to output
#line 3644
  *   - update xpp to point at next unconverted input, and tp to point
#line 3644
  *     at next location for converted output
#line 3644
  */
#line 3644
  long i, j, ni;
#line 3644
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3644
  int64 *xp;
#line 3644
  int nrange = 0;         /* number of range errors */
#line 3644
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3644
  long cxp = (long) *((char**)xpp);
#line 3644

#line 3644
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3644
  /* sjl: manually stripmine so we can limit amount of
#line 3644
   * vector work space reserved to LOOPCNT elements. Also
#line 3644
   * makes vectorisation easy */
#line 3644
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3644
    ni=Min(nelems-j,LOOPCNT);
#line 3644
    if (realign) {
#line 3644
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3644
      xp = tmp;
#line 3644
    } else {
#line 3644
      xp = (int64 *) *xpp;
#line 3644
    }
#line 3644
   /* copy the next block */
#line 3644
#pragma cdir loopcnt=LOOPCNT
#line 3644
#pragma cdir shortloop
#line 3644
    for (i=0; i<ni; i++) {
#line 3644
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3644
     /* test for range errors (not always needed but do it anyway) */
#line 3644
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3644
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3644
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3644
    }
#line 3644
   /* update xpp and tp */
#line 3644
    if (realign) xp = (int64 *) *xpp;
#line 3644
    xp += ni;
#line 3644
    tp += ni;
#line 3644
    *xpp = (void*)xp;
#line 3644
  }
#line 3644
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3644

#line 3644
#else   /* not SX */
#line 3644
	const char *xp = (const char *) *xpp;
#line 3644
	int status = NC_NOERR;
#line 3644

#line 3644
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3644
	{
#line 3644
		const int lstatus = ncx_get_longlong_ushort(xp, tp);
#line 3644
		if (status == NC_NOERR) /* report the first encountered error */
#line 3644
			status = lstatus;
#line 3644
	}
#line 3644

#line 3644
	*xpp = (const void *)xp;
#line 3644
	return status;
#line 3644
#endif
#line 3644
}
#line 3644

int
#line 3645
ncx_getn_longlong_uint(const void **xpp, size_t nelems, uint *tp)
#line 3645
{
#line 3645
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3645

#line 3645
 /* basic algorithm is:
#line 3645
  *   - ensure sane alignment of input data
#line 3645
  *   - copy (conversion happens automatically) input data
#line 3645
  *     to output
#line 3645
  *   - update xpp to point at next unconverted input, and tp to point
#line 3645
  *     at next location for converted output
#line 3645
  */
#line 3645
  long i, j, ni;
#line 3645
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3645
  int64 *xp;
#line 3645
  int nrange = 0;         /* number of range errors */
#line 3645
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3645
  long cxp = (long) *((char**)xpp);
#line 3645

#line 3645
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3645
  /* sjl: manually stripmine so we can limit amount of
#line 3645
   * vector work space reserved to LOOPCNT elements. Also
#line 3645
   * makes vectorisation easy */
#line 3645
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3645
    ni=Min(nelems-j,LOOPCNT);
#line 3645
    if (realign) {
#line 3645
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3645
      xp = tmp;
#line 3645
    } else {
#line 3645
      xp = (int64 *) *xpp;
#line 3645
    }
#line 3645
   /* copy the next block */
#line 3645
#pragma cdir loopcnt=LOOPCNT
#line 3645
#pragma cdir shortloop
#line 3645
    for (i=0; i<ni; i++) {
#line 3645
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3645
     /* test for range errors (not always needed but do it anyway) */
#line 3645
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3645
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3645
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3645
    }
#line 3645
   /* update xpp and tp */
#line 3645
    if (realign) xp = (int64 *) *xpp;
#line 3645
    xp += ni;
#line 3645
    tp += ni;
#line 3645
    *xpp = (void*)xp;
#line 3645
  }
#line 3645
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3645

#line 3645
#else   /* not SX */
#line 3645
	const char *xp = (const char *) *xpp;
#line 3645
	int status = NC_NOERR;
#line 3645

#line 3645
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3645
	{
#line 3645
		const int lstatus = ncx_get_longlong_uint(xp, tp);
#line 3645
		if (status == NC_NOERR) /* report the first encountered error */
#line 3645
			status = lstatus;
#line 3645
	}
#line 3645

#line 3645
	*xpp = (const void *)xp;
#line 3645
	return status;
#line 3645
#endif
#line 3645
}
#line 3645

int
#line 3646
ncx_getn_longlong_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3646
{
#line 3646
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3646

#line 3646
 /* basic algorithm is:
#line 3646
  *   - ensure sane alignment of input data
#line 3646
  *   - copy (conversion happens automatically) input data
#line 3646
  *     to output
#line 3646
  *   - update xpp to point at next unconverted input, and tp to point
#line 3646
  *     at next location for converted output
#line 3646
  */
#line 3646
  long i, j, ni;
#line 3646
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3646
  int64 *xp;
#line 3646
  int nrange = 0;         /* number of range errors */
#line 3646
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3646
  long cxp = (long) *((char**)xpp);
#line 3646

#line 3646
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3646
  /* sjl: manually stripmine so we can limit amount of
#line 3646
   * vector work space reserved to LOOPCNT elements. Also
#line 3646
   * makes vectorisation easy */
#line 3646
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3646
    ni=Min(nelems-j,LOOPCNT);
#line 3646
    if (realign) {
#line 3646
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3646
      xp = tmp;
#line 3646
    } else {
#line 3646
      xp = (int64 *) *xpp;
#line 3646
    }
#line 3646
   /* copy the next block */
#line 3646
#pragma cdir loopcnt=LOOPCNT
#line 3646
#pragma cdir shortloop
#line 3646
    for (i=0; i<ni; i++) {
#line 3646
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3646
     /* test for range errors (not always needed but do it anyway) */
#line 3646
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3646
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3646
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3646
    }
#line 3646
   /* update xpp and tp */
#line 3646
    if (realign) xp = (int64 *) *xpp;
#line 3646
    xp += ni;
#line 3646
    tp += ni;
#line 3646
    *xpp = (void*)xp;
#line 3646
  }
#line 3646
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3646

#line 3646
#else   /* not SX */
#line 3646
	const char *xp = (const char *) *xpp;
#line 3646
	int status = NC_NOERR;
#line 3646

#line 3646
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3646
	{
#line 3646
		const int lstatus = ncx_get_longlong_ulonglong(xp, tp);
#line 3646
		if (status == NC_NOERR) /* report the first encountered error */
#line 3646
			status = lstatus;
#line 3646
	}
#line 3646

#line 3646
	*xpp = (const void *)xp;
#line 3646
	return status;
#line 3646
#endif
#line 3646
}
#line 3646


#if X_SIZEOF_INT64 == SIZEOF_LONGLONG
/* optimized version */
int
ncx_putn_longlong_longlong(void **xpp, size_t nelems, const long long *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_INT64);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_INT64);
	return NC_NOERR;
}
#else
int
#line 3662
ncx_putn_longlong_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3662
{
#line 3662
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3662

#line 3662
 /* basic algorithm is:
#line 3662
  *   - ensure sane alignment of output data
#line 3662
  *   - copy (conversion happens automatically) input data
#line 3662
  *     to output
#line 3662
  *   - update tp to point at next unconverted input, and xpp to point
#line 3662
  *     at next location for converted output
#line 3662
  */
#line 3662
  long i, j, ni;
#line 3662
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3662
  int64 *xp;
#line 3662
  int nrange = 0;         /* number of range errors */
#line 3662
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3662
  long cxp = (long) *((char**)xpp);
#line 3662

#line 3662
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3662
  /* sjl: manually stripmine so we can limit amount of
#line 3662
   * vector work space reserved to LOOPCNT elements. Also
#line 3662
   * makes vectorisation easy */
#line 3662
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3662
    ni=Min(nelems-j,LOOPCNT);
#line 3662
    if (realign) {
#line 3662
      xp = tmp;
#line 3662
    } else {
#line 3662
      xp = (int64 *) *xpp;
#line 3662
    }
#line 3662
   /* copy the next block */
#line 3662
#pragma cdir loopcnt=LOOPCNT
#line 3662
#pragma cdir shortloop
#line 3662
    for (i=0; i<ni; i++) {
#line 3662
      /* the normal case: */
#line 3662
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3662
     /* test for range errors (not always needed but do it anyway) */
#line 3662
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3662
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3662
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3662
    }
#line 3662
   /* copy workspace back if necessary */
#line 3662
    if (realign) {
#line 3662
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3662
      xp = (int64 *) *xpp;
#line 3662
    }
#line 3662
   /* update xpp and tp */
#line 3662
    xp += ni;
#line 3662
    tp += ni;
#line 3662
    *xpp = (void*)xp;
#line 3662
  }
#line 3662
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3662

#line 3662
#else   /* not SX */
#line 3662

#line 3662
	char *xp = (char *) *xpp;
#line 3662
	int status = NC_NOERR;
#line 3662

#line 3662
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3662
	{
#line 3662
		int lstatus = ncx_put_longlong_longlong(xp, tp, fillp);
#line 3662
		if (status == NC_NOERR) /* report the first encountered error */
#line 3662
			status = lstatus;
#line 3662
	}
#line 3662

#line 3662
	*xpp = (void *)xp;
#line 3662
	return status;
#line 3662
#endif
#line 3662
}
#line 3662

#endif
int
#line 3664
ncx_putn_longlong_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3664
{
#line 3664
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3664

#line 3664
 /* basic algorithm is:
#line 3664
  *   - ensure sane alignment of output data
#line 3664
  *   - copy (conversion happens automatically) input data
#line 3664
  *     to output
#line 3664
  *   - update tp to point at next unconverted input, and xpp to point
#line 3664
  *     at next location for converted output
#line 3664
  */
#line 3664
  long i, j, ni;
#line 3664
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3664
  int64 *xp;
#line 3664
  int nrange = 0;         /* number of range errors */
#line 3664
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3664
  long cxp = (long) *((char**)xpp);
#line 3664

#line 3664
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3664
  /* sjl: manually stripmine so we can limit amount of
#line 3664
   * vector work space reserved to LOOPCNT elements. Also
#line 3664
   * makes vectorisation easy */
#line 3664
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3664
    ni=Min(nelems-j,LOOPCNT);
#line 3664
    if (realign) {
#line 3664
      xp = tmp;
#line 3664
    } else {
#line 3664
      xp = (int64 *) *xpp;
#line 3664
    }
#line 3664
   /* copy the next block */
#line 3664
#pragma cdir loopcnt=LOOPCNT
#line 3664
#pragma cdir shortloop
#line 3664
    for (i=0; i<ni; i++) {
#line 3664
      /* the normal case: */
#line 3664
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3664
     /* test for range errors (not always needed but do it anyway) */
#line 3664
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3664
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3664
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3664
    }
#line 3664
   /* copy workspace back if necessary */
#line 3664
    if (realign) {
#line 3664
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3664
      xp = (int64 *) *xpp;
#line 3664
    }
#line 3664
   /* update xpp and tp */
#line 3664
    xp += ni;
#line 3664
    tp += ni;
#line 3664
    *xpp = (void*)xp;
#line 3664
  }
#line 3664
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3664

#line 3664
#else   /* not SX */
#line 3664

#line 3664
	char *xp = (char *) *xpp;
#line 3664
	int status = NC_NOERR;
#line 3664

#line 3664
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3664
	{
#line 3664
		int lstatus = ncx_put_longlong_schar(xp, tp, fillp);
#line 3664
		if (status == NC_NOERR) /* report the first encountered error */
#line 3664
			status = lstatus;
#line 3664
	}
#line 3664

#line 3664
	*xpp = (void *)xp;
#line 3664
	return status;
#line 3664
#endif
#line 3664
}
#line 3664

int
#line 3665
ncx_putn_longlong_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3665
{
#line 3665
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3665

#line 3665
 /* basic algorithm is:
#line 3665
  *   - ensure sane alignment of output data
#line 3665
  *   - copy (conversion happens automatically) input data
#line 3665
  *     to output
#line 3665
  *   - update tp to point at next unconverted input, and xpp to point
#line 3665
  *     at next location for converted output
#line 3665
  */
#line 3665
  long i, j, ni;
#line 3665
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3665
  int64 *xp;
#line 3665
  int nrange = 0;         /* number of range errors */
#line 3665
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3665
  long cxp = (long) *((char**)xpp);
#line 3665

#line 3665
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3665
  /* sjl: manually stripmine so we can limit amount of
#line 3665
   * vector work space reserved to LOOPCNT elements. Also
#line 3665
   * makes vectorisation easy */
#line 3665
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3665
    ni=Min(nelems-j,LOOPCNT);
#line 3665
    if (realign) {
#line 3665
      xp = tmp;
#line 3665
    } else {
#line 3665
      xp = (int64 *) *xpp;
#line 3665
    }
#line 3665
   /* copy the next block */
#line 3665
#pragma cdir loopcnt=LOOPCNT
#line 3665
#pragma cdir shortloop
#line 3665
    for (i=0; i<ni; i++) {
#line 3665
      /* the normal case: */
#line 3665
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3665
     /* test for range errors (not always needed but do it anyway) */
#line 3665
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3665
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3665
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3665
    }
#line 3665
   /* copy workspace back if necessary */
#line 3665
    if (realign) {
#line 3665
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3665
      xp = (int64 *) *xpp;
#line 3665
    }
#line 3665
   /* update xpp and tp */
#line 3665
    xp += ni;
#line 3665
    tp += ni;
#line 3665
    *xpp = (void*)xp;
#line 3665
  }
#line 3665
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3665

#line 3665
#else   /* not SX */
#line 3665

#line 3665
	char *xp = (char *) *xpp;
#line 3665
	int status = NC_NOERR;
#line 3665

#line 3665
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3665
	{
#line 3665
		int lstatus = ncx_put_longlong_short(xp, tp, fillp);
#line 3665
		if (status == NC_NOERR) /* report the first encountered error */
#line 3665
			status = lstatus;
#line 3665
	}
#line 3665

#line 3665
	*xpp = (void *)xp;
#line 3665
	return status;
#line 3665
#endif
#line 3665
}
#line 3665

int
#line 3666
ncx_putn_longlong_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3666
{
#line 3666
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3666

#line 3666
 /* basic algorithm is:
#line 3666
  *   - ensure sane alignment of output data
#line 3666
  *   - copy (conversion happens automatically) input data
#line 3666
  *     to output
#line 3666
  *   - update tp to point at next unconverted input, and xpp to point
#line 3666
  *     at next location for converted output
#line 3666
  */
#line 3666
  long i, j, ni;
#line 3666
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3666
  int64 *xp;
#line 3666
  int nrange = 0;         /* number of range errors */
#line 3666
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3666
  long cxp = (long) *((char**)xpp);
#line 3666

#line 3666
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3666
  /* sjl: manually stripmine so we can limit amount of
#line 3666
   * vector work space reserved to LOOPCNT elements. Also
#line 3666
   * makes vectorisation easy */
#line 3666
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3666
    ni=Min(nelems-j,LOOPCNT);
#line 3666
    if (realign) {
#line 3666
      xp = tmp;
#line 3666
    } else {
#line 3666
      xp = (int64 *) *xpp;
#line 3666
    }
#line 3666
   /* copy the next block */
#line 3666
#pragma cdir loopcnt=LOOPCNT
#line 3666
#pragma cdir shortloop
#line 3666
    for (i=0; i<ni; i++) {
#line 3666
      /* the normal case: */
#line 3666
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3666
     /* test for range errors (not always needed but do it anyway) */
#line 3666
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3666
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3666
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3666
    }
#line 3666
   /* copy workspace back if necessary */
#line 3666
    if (realign) {
#line 3666
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3666
      xp = (int64 *) *xpp;
#line 3666
    }
#line 3666
   /* update xpp and tp */
#line 3666
    xp += ni;
#line 3666
    tp += ni;
#line 3666
    *xpp = (void*)xp;
#line 3666
  }
#line 3666
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3666

#line 3666
#else   /* not SX */
#line 3666

#line 3666
	char *xp = (char *) *xpp;
#line 3666
	int status = NC_NOERR;
#line 3666

#line 3666
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3666
	{
#line 3666
		int lstatus = ncx_put_longlong_int(xp, tp, fillp);
#line 3666
		if (status == NC_NOERR) /* report the first encountered error */
#line 3666
			status = lstatus;
#line 3666
	}
#line 3666

#line 3666
	*xpp = (void *)xp;
#line 3666
	return status;
#line 3666
#endif
#line 3666
}
#line 3666

int
#line 3667
ncx_putn_longlong_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3667
{
#line 3667
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3667

#line 3667
 /* basic algorithm is:
#line 3667
  *   - ensure sane alignment of output data
#line 3667
  *   - copy (conversion happens automatically) input data
#line 3667
  *     to output
#line 3667
  *   - update tp to point at next unconverted input, and xpp to point
#line 3667
  *     at next location for converted output
#line 3667
  */
#line 3667
  long i, j, ni;
#line 3667
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3667
  int64 *xp;
#line 3667
  int nrange = 0;         /* number of range errors */
#line 3667
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3667
  long cxp = (long) *((char**)xpp);
#line 3667

#line 3667
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3667
  /* sjl: manually stripmine so we can limit amount of
#line 3667
   * vector work space reserved to LOOPCNT elements. Also
#line 3667
   * makes vectorisation easy */
#line 3667
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3667
    ni=Min(nelems-j,LOOPCNT);
#line 3667
    if (realign) {
#line 3667
      xp = tmp;
#line 3667
    } else {
#line 3667
      xp = (int64 *) *xpp;
#line 3667
    }
#line 3667
   /* copy the next block */
#line 3667
#pragma cdir loopcnt=LOOPCNT
#line 3667
#pragma cdir shortloop
#line 3667
    for (i=0; i<ni; i++) {
#line 3667
      /* the normal case: */
#line 3667
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3667
     /* test for range errors (not always needed but do it anyway) */
#line 3667
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3667
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3667
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3667
    }
#line 3667
   /* copy workspace back if necessary */
#line 3667
    if (realign) {
#line 3667
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3667
      xp = (int64 *) *xpp;
#line 3667
    }
#line 3667
   /* update xpp and tp */
#line 3667
    xp += ni;
#line 3667
    tp += ni;
#line 3667
    *xpp = (void*)xp;
#line 3667
  }
#line 3667
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3667

#line 3667
#else   /* not SX */
#line 3667

#line 3667
	char *xp = (char *) *xpp;
#line 3667
	int status = NC_NOERR;
#line 3667

#line 3667
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3667
	{
#line 3667
		int lstatus = ncx_put_longlong_long(xp, tp, fillp);
#line 3667
		if (status == NC_NOERR) /* report the first encountered error */
#line 3667
			status = lstatus;
#line 3667
	}
#line 3667

#line 3667
	*xpp = (void *)xp;
#line 3667
	return status;
#line 3667
#endif
#line 3667
}
#line 3667

int
#line 3668
ncx_putn_longlong_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3668
{
#line 3668
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3668

#line 3668
 /* basic algorithm is:
#line 3668
  *   - ensure sane alignment of output data
#line 3668
  *   - copy (conversion happens automatically) input data
#line 3668
  *     to output
#line 3668
  *   - update tp to point at next unconverted input, and xpp to point
#line 3668
  *     at next location for converted output
#line 3668
  */
#line 3668
  long i, j, ni;
#line 3668
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3668
  int64 *xp;
#line 3668
  int nrange = 0;         /* number of range errors */
#line 3668
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3668
  long cxp = (long) *((char**)xpp);
#line 3668

#line 3668
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3668
  /* sjl: manually stripmine so we can limit amount of
#line 3668
   * vector work space reserved to LOOPCNT elements. Also
#line 3668
   * makes vectorisation easy */
#line 3668
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3668
    ni=Min(nelems-j,LOOPCNT);
#line 3668
    if (realign) {
#line 3668
      xp = tmp;
#line 3668
    } else {
#line 3668
      xp = (int64 *) *xpp;
#line 3668
    }
#line 3668
   /* copy the next block */
#line 3668
#pragma cdir loopcnt=LOOPCNT
#line 3668
#pragma cdir shortloop
#line 3668
    for (i=0; i<ni; i++) {
#line 3668
      /* the normal case: */
#line 3668
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3668
     /* test for range errors (not always needed but do it anyway) */
#line 3668
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3668
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3668
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3668
    }
#line 3668
   /* copy workspace back if necessary */
#line 3668
    if (realign) {
#line 3668
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3668
      xp = (int64 *) *xpp;
#line 3668
    }
#line 3668
   /* update xpp and tp */
#line 3668
    xp += ni;
#line 3668
    tp += ni;
#line 3668
    *xpp = (void*)xp;
#line 3668
  }
#line 3668
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3668

#line 3668
#else   /* not SX */
#line 3668

#line 3668
	char *xp = (char *) *xpp;
#line 3668
	int status = NC_NOERR;
#line 3668

#line 3668
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3668
	{
#line 3668
		int lstatus = ncx_put_longlong_float(xp, tp, fillp);
#line 3668
		if (status == NC_NOERR) /* report the first encountered error */
#line 3668
			status = lstatus;
#line 3668
	}
#line 3668

#line 3668
	*xpp = (void *)xp;
#line 3668
	return status;
#line 3668
#endif
#line 3668
}
#line 3668

int
#line 3669
ncx_putn_longlong_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3669
{
#line 3669
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3669

#line 3669
 /* basic algorithm is:
#line 3669
  *   - ensure sane alignment of output data
#line 3669
  *   - copy (conversion happens automatically) input data
#line 3669
  *     to output
#line 3669
  *   - update tp to point at next unconverted input, and xpp to point
#line 3669
  *     at next location for converted output
#line 3669
  */
#line 3669
  long i, j, ni;
#line 3669
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3669
  int64 *xp;
#line 3669
  int nrange = 0;         /* number of range errors */
#line 3669
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3669
  long cxp = (long) *((char**)xpp);
#line 3669

#line 3669
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3669
  /* sjl: manually stripmine so we can limit amount of
#line 3669
   * vector work space reserved to LOOPCNT elements. Also
#line 3669
   * makes vectorisation easy */
#line 3669
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3669
    ni=Min(nelems-j,LOOPCNT);
#line 3669
    if (realign) {
#line 3669
      xp = tmp;
#line 3669
    } else {
#line 3669
      xp = (int64 *) *xpp;
#line 3669
    }
#line 3669
   /* copy the next block */
#line 3669
#pragma cdir loopcnt=LOOPCNT
#line 3669
#pragma cdir shortloop
#line 3669
    for (i=0; i<ni; i++) {
#line 3669
      /* the normal case: */
#line 3669
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3669
     /* test for range errors (not always needed but do it anyway) */
#line 3669
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3669
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3669
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3669
    }
#line 3669
   /* copy workspace back if necessary */
#line 3669
    if (realign) {
#line 3669
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3669
      xp = (int64 *) *xpp;
#line 3669
    }
#line 3669
   /* update xpp and tp */
#line 3669
    xp += ni;
#line 3669
    tp += ni;
#line 3669
    *xpp = (void*)xp;
#line 3669
  }
#line 3669
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3669

#line 3669
#else   /* not SX */
#line 3669

#line 3669
	char *xp = (char *) *xpp;
#line 3669
	int status = NC_NOERR;
#line 3669

#line 3669
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3669
	{
#line 3669
		int lstatus = ncx_put_longlong_double(xp, tp, fillp);
#line 3669
		if (status == NC_NOERR) /* report the first encountered error */
#line 3669
			status = lstatus;
#line 3669
	}
#line 3669

#line 3669
	*xpp = (void *)xp;
#line 3669
	return status;
#line 3669
#endif
#line 3669
}
#line 3669

int
#line 3670
ncx_putn_longlong_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3670
{
#line 3670
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3670

#line 3670
 /* basic algorithm is:
#line 3670
  *   - ensure sane alignment of output data
#line 3670
  *   - copy (conversion happens automatically) input data
#line 3670
  *     to output
#line 3670
  *   - update tp to point at next unconverted input, and xpp to point
#line 3670
  *     at next location for converted output
#line 3670
  */
#line 3670
  long i, j, ni;
#line 3670
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3670
  int64 *xp;
#line 3670
  int nrange = 0;         /* number of range errors */
#line 3670
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3670
  long cxp = (long) *((char**)xpp);
#line 3670

#line 3670
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3670
  /* sjl: manually stripmine so we can limit amount of
#line 3670
   * vector work space reserved to LOOPCNT elements. Also
#line 3670
   * makes vectorisation easy */
#line 3670
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3670
    ni=Min(nelems-j,LOOPCNT);
#line 3670
    if (realign) {
#line 3670
      xp = tmp;
#line 3670
    } else {
#line 3670
      xp = (int64 *) *xpp;
#line 3670
    }
#line 3670
   /* copy the next block */
#line 3670
#pragma cdir loopcnt=LOOPCNT
#line 3670
#pragma cdir shortloop
#line 3670
    for (i=0; i<ni; i++) {
#line 3670
      /* the normal case: */
#line 3670
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3670
     /* test for range errors (not always needed but do it anyway) */
#line 3670
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3670
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3670
      nrange += tp[i] > X_INT64_MAX ;
#line 3670
    }
#line 3670
   /* copy workspace back if necessary */
#line 3670
    if (realign) {
#line 3670
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3670
      xp = (int64 *) *xpp;
#line 3670
    }
#line 3670
   /* update xpp and tp */
#line 3670
    xp += ni;
#line 3670
    tp += ni;
#line 3670
    *xpp = (void*)xp;
#line 3670
  }
#line 3670
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3670

#line 3670
#else   /* not SX */
#line 3670

#line 3670
	char *xp = (char *) *xpp;
#line 3670
	int status = NC_NOERR;
#line 3670

#line 3670
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3670
	{
#line 3670
		int lstatus = ncx_put_longlong_uchar(xp, tp, fillp);
#line 3670
		if (status == NC_NOERR) /* report the first encountered error */
#line 3670
			status = lstatus;
#line 3670
	}
#line 3670

#line 3670
	*xpp = (void *)xp;
#line 3670
	return status;
#line 3670
#endif
#line 3670
}
#line 3670

int
#line 3671
ncx_putn_longlong_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3671
{
#line 3671
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3671

#line 3671
 /* basic algorithm is:
#line 3671
  *   - ensure sane alignment of output data
#line 3671
  *   - copy (conversion happens automatically) input data
#line 3671
  *     to output
#line 3671
  *   - update tp to point at next unconverted input, and xpp to point
#line 3671
  *     at next location for converted output
#line 3671
  */
#line 3671
  long i, j, ni;
#line 3671
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3671
  int64 *xp;
#line 3671
  int nrange = 0;         /* number of range errors */
#line 3671
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3671
  long cxp = (long) *((char**)xpp);
#line 3671

#line 3671
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3671
  /* sjl: manually stripmine so we can limit amount of
#line 3671
   * vector work space reserved to LOOPCNT elements. Also
#line 3671
   * makes vectorisation easy */
#line 3671
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3671
    ni=Min(nelems-j,LOOPCNT);
#line 3671
    if (realign) {
#line 3671
      xp = tmp;
#line 3671
    } else {
#line 3671
      xp = (int64 *) *xpp;
#line 3671
    }
#line 3671
   /* copy the next block */
#line 3671
#pragma cdir loopcnt=LOOPCNT
#line 3671
#pragma cdir shortloop
#line 3671
    for (i=0; i<ni; i++) {
#line 3671
      /* the normal case: */
#line 3671
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3671
     /* test for range errors (not always needed but do it anyway) */
#line 3671
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3671
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3671
      nrange += tp[i] > X_INT64_MAX ;
#line 3671
    }
#line 3671
   /* copy workspace back if necessary */
#line 3671
    if (realign) {
#line 3671
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3671
      xp = (int64 *) *xpp;
#line 3671
    }
#line 3671
   /* update xpp and tp */
#line 3671
    xp += ni;
#line 3671
    tp += ni;
#line 3671
    *xpp = (void*)xp;
#line 3671
  }
#line 3671
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3671

#line 3671
#else   /* not SX */
#line 3671

#line 3671
	char *xp = (char *) *xpp;
#line 3671
	int status = NC_NOERR;
#line 3671

#line 3671
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3671
	{
#line 3671
		int lstatus = ncx_put_longlong_ushort(xp, tp, fillp);
#line 3671
		if (status == NC_NOERR) /* report the first encountered error */
#line 3671
			status = lstatus;
#line 3671
	}
#line 3671

#line 3671
	*xpp = (void *)xp;
#line 3671
	return status;
#line 3671
#endif
#line 3671
}
#line 3671

int
#line 3672
ncx_putn_longlong_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3672
{
#line 3672
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3672

#line 3672
 /* basic algorithm is:
#line 3672
  *   - ensure sane alignment of output data
#line 3672
  *   - copy (conversion happens automatically) input data
#line 3672
  *     to output
#line 3672
  *   - update tp to point at next unconverted input, and xpp to point
#line 3672
  *     at next location for converted output
#line 3672
  */
#line 3672
  long i, j, ni;
#line 3672
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3672
  int64 *xp;
#line 3672
  int nrange = 0;         /* number of range errors */
#line 3672
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3672
  long cxp = (long) *((char**)xpp);
#line 3672

#line 3672
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3672
  /* sjl: manually stripmine so we can limit amount of
#line 3672
   * vector work space reserved to LOOPCNT elements. Also
#line 3672
   * makes vectorisation easy */
#line 3672
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3672
    ni=Min(nelems-j,LOOPCNT);
#line 3672
    if (realign) {
#line 3672
      xp = tmp;
#line 3672
    } else {
#line 3672
      xp = (int64 *) *xpp;
#line 3672
    }
#line 3672
   /* copy the next block */
#line 3672
#pragma cdir loopcnt=LOOPCNT
#line 3672
#pragma cdir shortloop
#line 3672
    for (i=0; i<ni; i++) {
#line 3672
      /* the normal case: */
#line 3672
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3672
     /* test for range errors (not always needed but do it anyway) */
#line 3672
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3672
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3672
      nrange += tp[i] > X_INT64_MAX ;
#line 3672
    }
#line 3672
   /* copy workspace back if necessary */
#line 3672
    if (realign) {
#line 3672
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3672
      xp = (int64 *) *xpp;
#line 3672
    }
#line 3672
   /* update xpp and tp */
#line 3672
    xp += ni;
#line 3672
    tp += ni;
#line 3672
    *xpp = (void*)xp;
#line 3672
  }
#line 3672
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3672

#line 3672
#else   /* not SX */
#line 3672

#line 3672
	char *xp = (char *) *xpp;
#line 3672
	int status = NC_NOERR;
#line 3672

#line 3672
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3672
	{
#line 3672
		int lstatus = ncx_put_longlong_uint(xp, tp, fillp);
#line 3672
		if (status == NC_NOERR) /* report the first encountered error */
#line 3672
			status = lstatus;
#line 3672
	}
#line 3672

#line 3672
	*xpp = (void *)xp;
#line 3672
	return status;
#line 3672
#endif
#line 3672
}
#line 3672

int
#line 3673
ncx_putn_longlong_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3673
{
#line 3673
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3673

#line 3673
 /* basic algorithm is:
#line 3673
  *   - ensure sane alignment of output data
#line 3673
  *   - copy (conversion happens automatically) input data
#line 3673
  *     to output
#line 3673
  *   - update tp to point at next unconverted input, and xpp to point
#line 3673
  *     at next location for converted output
#line 3673
  */
#line 3673
  long i, j, ni;
#line 3673
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3673
  int64 *xp;
#line 3673
  int nrange = 0;         /* number of range errors */
#line 3673
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3673
  long cxp = (long) *((char**)xpp);
#line 3673

#line 3673
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3673
  /* sjl: manually stripmine so we can limit amount of
#line 3673
   * vector work space reserved to LOOPCNT elements. Also
#line 3673
   * makes vectorisation easy */
#line 3673
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3673
    ni=Min(nelems-j,LOOPCNT);
#line 3673
    if (realign) {
#line 3673
      xp = tmp;
#line 3673
    } else {
#line 3673
      xp = (int64 *) *xpp;
#line 3673
    }
#line 3673
   /* copy the next block */
#line 3673
#pragma cdir loopcnt=LOOPCNT
#line 3673
#pragma cdir shortloop
#line 3673
    for (i=0; i<ni; i++) {
#line 3673
      /* the normal case: */
#line 3673
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3673
     /* test for range errors (not always needed but do it anyway) */
#line 3673
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3673
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3673
      nrange += tp[i] > X_INT64_MAX ;
#line 3673
    }
#line 3673
   /* copy workspace back if necessary */
#line 3673
    if (realign) {
#line 3673
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3673
      xp = (int64 *) *xpp;
#line 3673
    }
#line 3673
   /* update xpp and tp */
#line 3673
    xp += ni;
#line 3673
    tp += ni;
#line 3673
    *xpp = (void*)xp;
#line 3673
  }
#line 3673
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3673

#line 3673
#else   /* not SX */
#line 3673

#line 3673
	char *xp = (char *) *xpp;
#line 3673
	int status = NC_NOERR;
#line 3673

#line 3673
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3673
	{
#line 3673
		int lstatus = ncx_put_longlong_ulonglong(xp, tp, fillp);
#line 3673
		if (status == NC_NOERR) /* report the first encountered error */
#line 3673
			status = lstatus;
#line 3673
	}
#line 3673

#line 3673
	*xpp = (void *)xp;
#line 3673
	return status;
#line 3673
#endif
#line 3673
}
#line 3673


/* uint64 --------------------------------------------------------------------*/

#if X_SIZEOF_UINT64 == SIZEOF_ULONGLONG
/* optimized version */
int
ncx_getn_ulonglong_ulonglong(const void **xpp, size_t nelems, unsigned long long *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_UNSIGNED_LONG_LONG);
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_UINT64);
	return NC_NOERR;
}
#else
int
#line 3691
ncx_getn_ulonglong_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3691
{
#line 3691
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3691

#line 3691
 /* basic algorithm is:
#line 3691
  *   - ensure sane alignment of input data
#line 3691
  *   - copy (conversion happens automatically) input data
#line 3691
  *     to output
#line 3691
  *   - update xpp to point at next unconverted input, and tp to point
#line 3691
  *     at next location for converted output
#line 3691
  */
#line 3691
  long i, j, ni;
#line 3691
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3691
  uint64 *xp;
#line 3691
  int nrange = 0;         /* number of range errors */
#line 3691
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3691
  long cxp = (long) *((char**)xpp);
#line 3691

#line 3691
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3691
  /* sjl: manually stripmine so we can limit amount of
#line 3691
   * vector work space reserved to LOOPCNT elements. Also
#line 3691
   * makes vectorisation easy */
#line 3691
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3691
    ni=Min(nelems-j,LOOPCNT);
#line 3691
    if (realign) {
#line 3691
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3691
      xp = tmp;
#line 3691
    } else {
#line 3691
      xp = (uint64 *) *xpp;
#line 3691
    }
#line 3691
   /* copy the next block */
#line 3691
#pragma cdir loopcnt=LOOPCNT
#line 3691
#pragma cdir shortloop
#line 3691
    for (i=0; i<ni; i++) {
#line 3691
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3691
     /* test for range errors (not always needed but do it anyway) */
#line 3691
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3691
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3691
      nrange += xp[i] > ULONGLONG_MAX ;
#line 3691
    }
#line 3691
   /* update xpp and tp */
#line 3691
    if (realign) xp = (uint64 *) *xpp;
#line 3691
    xp += ni;
#line 3691
    tp += ni;
#line 3691
    *xpp = (void*)xp;
#line 3691
  }
#line 3691
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3691

#line 3691
#else   /* not SX */
#line 3691
	const char *xp = (const char *) *xpp;
#line 3691
	int status = NC_NOERR;
#line 3691

#line 3691
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3691
	{
#line 3691
		const int lstatus = ncx_get_ulonglong_ulonglong(xp, tp);
#line 3691
		if (status == NC_NOERR) /* report the first encountered error */
#line 3691
			status = lstatus;
#line 3691
	}
#line 3691

#line 3691
	*xpp = (const void *)xp;
#line 3691
	return status;
#line 3691
#endif
#line 3691
}
#line 3691

#endif
int
#line 3693
ncx_getn_ulonglong_schar(const void **xpp, size_t nelems, schar *tp)
#line 3693
{
#line 3693
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3693

#line 3693
 /* basic algorithm is:
#line 3693
  *   - ensure sane alignment of input data
#line 3693
  *   - copy (conversion happens automatically) input data
#line 3693
  *     to output
#line 3693
  *   - update xpp to point at next unconverted input, and tp to point
#line 3693
  *     at next location for converted output
#line 3693
  */
#line 3693
  long i, j, ni;
#line 3693
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3693
  uint64 *xp;
#line 3693
  int nrange = 0;         /* number of range errors */
#line 3693
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3693
  long cxp = (long) *((char**)xpp);
#line 3693

#line 3693
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3693
  /* sjl: manually stripmine so we can limit amount of
#line 3693
   * vector work space reserved to LOOPCNT elements. Also
#line 3693
   * makes vectorisation easy */
#line 3693
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3693
    ni=Min(nelems-j,LOOPCNT);
#line 3693
    if (realign) {
#line 3693
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3693
      xp = tmp;
#line 3693
    } else {
#line 3693
      xp = (uint64 *) *xpp;
#line 3693
    }
#line 3693
   /* copy the next block */
#line 3693
#pragma cdir loopcnt=LOOPCNT
#line 3693
#pragma cdir shortloop
#line 3693
    for (i=0; i<ni; i++) {
#line 3693
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3693
     /* test for range errors (not always needed but do it anyway) */
#line 3693
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3693
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3693
      nrange += xp[i] > SCHAR_MAX ;
#line 3693
    }
#line 3693
   /* update xpp and tp */
#line 3693
    if (realign) xp = (uint64 *) *xpp;
#line 3693
    xp += ni;
#line 3693
    tp += ni;
#line 3693
    *xpp = (void*)xp;
#line 3693
  }
#line 3693
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3693

#line 3693
#else   /* not SX */
#line 3693
	const char *xp = (const char *) *xpp;
#line 3693
	int status = NC_NOERR;
#line 3693

#line 3693
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3693
	{
#line 3693
		const int lstatus = ncx_get_ulonglong_schar(xp, tp);
#line 3693
		if (status == NC_NOERR) /* report the first encountered error */
#line 3693
			status = lstatus;
#line 3693
	}
#line 3693

#line 3693
	*xpp = (const void *)xp;
#line 3693
	return status;
#line 3693
#endif
#line 3693
}
#line 3693

int
#line 3694
ncx_getn_ulonglong_short(const void **xpp, size_t nelems, short *tp)
#line 3694
{
#line 3694
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3694

#line 3694
 /* basic algorithm is:
#line 3694
  *   - ensure sane alignment of input data
#line 3694
  *   - copy (conversion happens automatically) input data
#line 3694
  *     to output
#line 3694
  *   - update xpp to point at next unconverted input, and tp to point
#line 3694
  *     at next location for converted output
#line 3694
  */
#line 3694
  long i, j, ni;
#line 3694
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3694
  uint64 *xp;
#line 3694
  int nrange = 0;         /* number of range errors */
#line 3694
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3694
  long cxp = (long) *((char**)xpp);
#line 3694

#line 3694
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3694
  /* sjl: manually stripmine so we can limit amount of
#line 3694
   * vector work space reserved to LOOPCNT elements. Also
#line 3694
   * makes vectorisation easy */
#line 3694
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3694
    ni=Min(nelems-j,LOOPCNT);
#line 3694
    if (realign) {
#line 3694
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3694
      xp = tmp;
#line 3694
    } else {
#line 3694
      xp = (uint64 *) *xpp;
#line 3694
    }
#line 3694
   /* copy the next block */
#line 3694
#pragma cdir loopcnt=LOOPCNT
#line 3694
#pragma cdir shortloop
#line 3694
    for (i=0; i<ni; i++) {
#line 3694
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3694
     /* test for range errors (not always needed but do it anyway) */
#line 3694
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3694
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3694
      nrange += xp[i] > SHORT_MAX ;
#line 3694
    }
#line 3694
   /* update xpp and tp */
#line 3694
    if (realign) xp = (uint64 *) *xpp;
#line 3694
    xp += ni;
#line 3694
    tp += ni;
#line 3694
    *xpp = (void*)xp;
#line 3694
  }
#line 3694
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3694

#line 3694
#else   /* not SX */
#line 3694
	const char *xp = (const char *) *xpp;
#line 3694
	int status = NC_NOERR;
#line 3694

#line 3694
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3694
	{
#line 3694
		const int lstatus = ncx_get_ulonglong_short(xp, tp);
#line 3694
		if (status == NC_NOERR) /* report the first encountered error */
#line 3694
			status = lstatus;
#line 3694
	}
#line 3694

#line 3694
	*xpp = (const void *)xp;
#line 3694
	return status;
#line 3694
#endif
#line 3694
}
#line 3694

int
#line 3695
ncx_getn_ulonglong_int(const void **xpp, size_t nelems, int *tp)
#line 3695
{
#line 3695
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3695

#line 3695
 /* basic algorithm is:
#line 3695
  *   - ensure sane alignment of input data
#line 3695
  *   - copy (conversion happens automatically) input data
#line 3695
  *     to output
#line 3695
  *   - update xpp to point at next unconverted input, and tp to point
#line 3695
  *     at next location for converted output
#line 3695
  */
#line 3695
  long i, j, ni;
#line 3695
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3695
  uint64 *xp;
#line 3695
  int nrange = 0;         /* number of range errors */
#line 3695
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3695
  long cxp = (long) *((char**)xpp);
#line 3695

#line 3695
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3695
  /* sjl: manually stripmine so we can limit amount of
#line 3695
   * vector work space reserved to LOOPCNT elements. Also
#line 3695
   * makes vectorisation easy */
#line 3695
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3695
    ni=Min(nelems-j,LOOPCNT);
#line 3695
    if (realign) {
#line 3695
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3695
      xp = tmp;
#line 3695
    } else {
#line 3695
      xp = (uint64 *) *xpp;
#line 3695
    }
#line 3695
   /* copy the next block */
#line 3695
#pragma cdir loopcnt=LOOPCNT
#line 3695
#pragma cdir shortloop
#line 3695
    for (i=0; i<ni; i++) {
#line 3695
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3695
     /* test for range errors (not always needed but do it anyway) */
#line 3695
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3695
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3695
      nrange += xp[i] > INT_MAX ;
#line 3695
    }
#line 3695
   /* update xpp and tp */
#line 3695
    if (realign) xp = (uint64 *) *xpp;
#line 3695
    xp += ni;
#line 3695
    tp += ni;
#line 3695
    *xpp = (void*)xp;
#line 3695
  }
#line 3695
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3695

#line 3695
#else   /* not SX */
#line 3695
	const char *xp = (const char *) *xpp;
#line 3695
	int status = NC_NOERR;
#line 3695

#line 3695
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3695
	{
#line 3695
		const int lstatus = ncx_get_ulonglong_int(xp, tp);
#line 3695
		if (status == NC_NOERR) /* report the first encountered error */
#line 3695
			status = lstatus;
#line 3695
	}
#line 3695

#line 3695
	*xpp = (const void *)xp;
#line 3695
	return status;
#line 3695
#endif
#line 3695
}
#line 3695

int
#line 3696
ncx_getn_ulonglong_long(const void **xpp, size_t nelems, long *tp)
#line 3696
{
#line 3696
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3696

#line 3696
 /* basic algorithm is:
#line 3696
  *   - ensure sane alignment of input data
#line 3696
  *   - copy (conversion happens automatically) input data
#line 3696
  *     to output
#line 3696
  *   - update xpp to point at next unconverted input, and tp to point
#line 3696
  *     at next location for converted output
#line 3696
  */
#line 3696
  long i, j, ni;
#line 3696
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3696
  uint64 *xp;
#line 3696
  int nrange = 0;         /* number of range errors */
#line 3696
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3696
  long cxp = (long) *((char**)xpp);
#line 3696

#line 3696
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3696
  /* sjl: manually stripmine so we can limit amount of
#line 3696
   * vector work space reserved to LOOPCNT elements. Also
#line 3696
   * makes vectorisation easy */
#line 3696
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3696
    ni=Min(nelems-j,LOOPCNT);
#line 3696
    if (realign) {
#line 3696
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3696
      xp = tmp;
#line 3696
    } else {
#line 3696
      xp = (uint64 *) *xpp;
#line 3696
    }
#line 3696
   /* copy the next block */
#line 3696
#pragma cdir loopcnt=LOOPCNT
#line 3696
#pragma cdir shortloop
#line 3696
    for (i=0; i<ni; i++) {
#line 3696
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3696
     /* test for range errors (not always needed but do it anyway) */
#line 3696
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3696
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3696
      nrange += xp[i] > LONG_MAX ;
#line 3696
    }
#line 3696
   /* update xpp and tp */
#line 3696
    if (realign) xp = (uint64 *) *xpp;
#line 3696
    xp += ni;
#line 3696
    tp += ni;
#line 3696
    *xpp = (void*)xp;
#line 3696
  }
#line 3696
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3696

#line 3696
#else   /* not SX */
#line 3696
	const char *xp = (const char *) *xpp;
#line 3696
	int status = NC_NOERR;
#line 3696

#line 3696
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3696
	{
#line 3696
		const int lstatus = ncx_get_ulonglong_long(xp, tp);
#line 3696
		if (status == NC_NOERR) /* report the first encountered error */
#line 3696
			status = lstatus;
#line 3696
	}
#line 3696

#line 3696
	*xpp = (const void *)xp;
#line 3696
	return status;
#line 3696
#endif
#line 3696
}
#line 3696

int
#line 3697
ncx_getn_ulonglong_float(const void **xpp, size_t nelems, float *tp)
#line 3697
{
#line 3697
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3697

#line 3697
 /* basic algorithm is:
#line 3697
  *   - ensure sane alignment of input data
#line 3697
  *   - copy (conversion happens automatically) input data
#line 3697
  *     to output
#line 3697
  *   - update xpp to point at next unconverted input, and tp to point
#line 3697
  *     at next location for converted output
#line 3697
  */
#line 3697
  long i, j, ni;
#line 3697
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3697
  uint64 *xp;
#line 3697
  int nrange = 0;         /* number of range errors */
#line 3697
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3697
  long cxp = (long) *((char**)xpp);
#line 3697

#line 3697
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3697
  /* sjl: manually stripmine so we can limit amount of
#line 3697
   * vector work space reserved to LOOPCNT elements. Also
#line 3697
   * makes vectorisation easy */
#line 3697
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3697
    ni=Min(nelems-j,LOOPCNT);
#line 3697
    if (realign) {
#line 3697
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3697
      xp = tmp;
#line 3697
    } else {
#line 3697
      xp = (uint64 *) *xpp;
#line 3697
    }
#line 3697
   /* copy the next block */
#line 3697
#pragma cdir loopcnt=LOOPCNT
#line 3697
#pragma cdir shortloop
#line 3697
    for (i=0; i<ni; i++) {
#line 3697
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3697
     /* test for range errors (not always needed but do it anyway) */
#line 3697
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3697
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3697
      nrange += xp[i] > FLOAT_MAX ;
#line 3697
    }
#line 3697
   /* update xpp and tp */
#line 3697
    if (realign) xp = (uint64 *) *xpp;
#line 3697
    xp += ni;
#line 3697
    tp += ni;
#line 3697
    *xpp = (void*)xp;
#line 3697
  }
#line 3697
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3697

#line 3697
#else   /* not SX */
#line 3697
	const char *xp = (const char *) *xpp;
#line 3697
	int status = NC_NOERR;
#line 3697

#line 3697
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3697
	{
#line 3697
		const int lstatus = ncx_get_ulonglong_float(xp, tp);
#line 3697
		if (status == NC_NOERR) /* report the first encountered error */
#line 3697
			status = lstatus;
#line 3697
	}
#line 3697

#line 3697
	*xpp = (const void *)xp;
#line 3697
	return status;
#line 3697
#endif
#line 3697
}
#line 3697

int
#line 3698
ncx_getn_ulonglong_double(const void **xpp, size_t nelems, double *tp)
#line 3698
{
#line 3698
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3698

#line 3698
 /* basic algorithm is:
#line 3698
  *   - ensure sane alignment of input data
#line 3698
  *   - copy (conversion happens automatically) input data
#line 3698
  *     to output
#line 3698
  *   - update xpp to point at next unconverted input, and tp to point
#line 3698
  *     at next location for converted output
#line 3698
  */
#line 3698
  long i, j, ni;
#line 3698
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3698
  uint64 *xp;
#line 3698
  int nrange = 0;         /* number of range errors */
#line 3698
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3698
  long cxp = (long) *((char**)xpp);
#line 3698

#line 3698
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3698
  /* sjl: manually stripmine so we can limit amount of
#line 3698
   * vector work space reserved to LOOPCNT elements. Also
#line 3698
   * makes vectorisation easy */
#line 3698
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3698
    ni=Min(nelems-j,LOOPCNT);
#line 3698
    if (realign) {
#line 3698
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3698
      xp = tmp;
#line 3698
    } else {
#line 3698
      xp = (uint64 *) *xpp;
#line 3698
    }
#line 3698
   /* copy the next block */
#line 3698
#pragma cdir loopcnt=LOOPCNT
#line 3698
#pragma cdir shortloop
#line 3698
    for (i=0; i<ni; i++) {
#line 3698
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3698
     /* test for range errors (not always needed but do it anyway) */
#line 3698
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3698
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3698
      nrange += xp[i] > DOUBLE_MAX ;
#line 3698
    }
#line 3698
   /* update xpp and tp */
#line 3698
    if (realign) xp = (uint64 *) *xpp;
#line 3698
    xp += ni;
#line 3698
    tp += ni;
#line 3698
    *xpp = (void*)xp;
#line 3698
  }
#line 3698
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3698

#line 3698
#else   /* not SX */
#line 3698
	const char *xp = (const char *) *xpp;
#line 3698
	int status = NC_NOERR;
#line 3698

#line 3698
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3698
	{
#line 3698
		const int lstatus = ncx_get_ulonglong_double(xp, tp);
#line 3698
		if (status == NC_NOERR) /* report the first encountered error */
#line 3698
			status = lstatus;
#line 3698
	}
#line 3698

#line 3698
	*xpp = (const void *)xp;
#line 3698
	return status;
#line 3698
#endif
#line 3698
}
#line 3698

int
#line 3699
ncx_getn_ulonglong_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3699
{
#line 3699
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3699

#line 3699
 /* basic algorithm is:
#line 3699
  *   - ensure sane alignment of input data
#line 3699
  *   - copy (conversion happens automatically) input data
#line 3699
  *     to output
#line 3699
  *   - update xpp to point at next unconverted input, and tp to point
#line 3699
  *     at next location for converted output
#line 3699
  */
#line 3699
  long i, j, ni;
#line 3699
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3699
  uint64 *xp;
#line 3699
  int nrange = 0;         /* number of range errors */
#line 3699
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3699
  long cxp = (long) *((char**)xpp);
#line 3699

#line 3699
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3699
  /* sjl: manually stripmine so we can limit amount of
#line 3699
   * vector work space reserved to LOOPCNT elements. Also
#line 3699
   * makes vectorisation easy */
#line 3699
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3699
    ni=Min(nelems-j,LOOPCNT);
#line 3699
    if (realign) {
#line 3699
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3699
      xp = tmp;
#line 3699
    } else {
#line 3699
      xp = (uint64 *) *xpp;
#line 3699
    }
#line 3699
   /* copy the next block */
#line 3699
#pragma cdir loopcnt=LOOPCNT
#line 3699
#pragma cdir shortloop
#line 3699
    for (i=0; i<ni; i++) {
#line 3699
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3699
     /* test for range errors (not always needed but do it anyway) */
#line 3699
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3699
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3699
      nrange += xp[i] > LONGLONG_MAX ;
#line 3699
    }
#line 3699
   /* update xpp and tp */
#line 3699
    if (realign) xp = (uint64 *) *xpp;
#line 3699
    xp += ni;
#line 3699
    tp += ni;
#line 3699
    *xpp = (void*)xp;
#line 3699
  }
#line 3699
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3699

#line 3699
#else   /* not SX */
#line 3699
	const char *xp = (const char *) *xpp;
#line 3699
	int status = NC_NOERR;
#line 3699

#line 3699
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3699
	{
#line 3699
		const int lstatus = ncx_get_ulonglong_longlong(xp, tp);
#line 3699
		if (status == NC_NOERR) /* report the first encountered error */
#line 3699
			status = lstatus;
#line 3699
	}
#line 3699

#line 3699
	*xpp = (const void *)xp;
#line 3699
	return status;
#line 3699
#endif
#line 3699
}
#line 3699

int
#line 3700
ncx_getn_ulonglong_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3700
{
#line 3700
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3700

#line 3700
 /* basic algorithm is:
#line 3700
  *   - ensure sane alignment of input data
#line 3700
  *   - copy (conversion happens automatically) input data
#line 3700
  *     to output
#line 3700
  *   - update xpp to point at next unconverted input, and tp to point
#line 3700
  *     at next location for converted output
#line 3700
  */
#line 3700
  long i, j, ni;
#line 3700
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3700
  uint64 *xp;
#line 3700
  int nrange = 0;         /* number of range errors */
#line 3700
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3700
  long cxp = (long) *((char**)xpp);
#line 3700

#line 3700
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3700
  /* sjl: manually stripmine so we can limit amount of
#line 3700
   * vector work space reserved to LOOPCNT elements. Also
#line 3700
   * makes vectorisation easy */
#line 3700
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3700
    ni=Min(nelems-j,LOOPCNT);
#line 3700
    if (realign) {
#line 3700
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3700
      xp = tmp;
#line 3700
    } else {
#line 3700
      xp = (uint64 *) *xpp;
#line 3700
    }
#line 3700
   /* copy the next block */
#line 3700
#pragma cdir loopcnt=LOOPCNT
#line 3700
#pragma cdir shortloop
#line 3700
    for (i=0; i<ni; i++) {
#line 3700
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3700
     /* test for range errors (not always needed but do it anyway) */
#line 3700
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3700
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3700
      nrange += xp[i] > UCHAR_MAX ;
#line 3700
    }
#line 3700
   /* update xpp and tp */
#line 3700
    if (realign) xp = (uint64 *) *xpp;
#line 3700
    xp += ni;
#line 3700
    tp += ni;
#line 3700
    *xpp = (void*)xp;
#line 3700
  }
#line 3700
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3700

#line 3700
#else   /* not SX */
#line 3700
	const char *xp = (const char *) *xpp;
#line 3700
	int status = NC_NOERR;
#line 3700

#line 3700
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3700
	{
#line 3700
		const int lstatus = ncx_get_ulonglong_uchar(xp, tp);
#line 3700
		if (status == NC_NOERR) /* report the first encountered error */
#line 3700
			status = lstatus;
#line 3700
	}
#line 3700

#line 3700
	*xpp = (const void *)xp;
#line 3700
	return status;
#line 3700
#endif
#line 3700
}
#line 3700

int
#line 3701
ncx_getn_ulonglong_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3701
{
#line 3701
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3701

#line 3701
 /* basic algorithm is:
#line 3701
  *   - ensure sane alignment of input data
#line 3701
  *   - copy (conversion happens automatically) input data
#line 3701
  *     to output
#line 3701
  *   - update xpp to point at next unconverted input, and tp to point
#line 3701
  *     at next location for converted output
#line 3701
  */
#line 3701
  long i, j, ni;
#line 3701
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3701
  uint64 *xp;
#line 3701
  int nrange = 0;         /* number of range errors */
#line 3701
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3701
  long cxp = (long) *((char**)xpp);
#line 3701

#line 3701
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3701
  /* sjl: manually stripmine so we can limit amount of
#line 3701
   * vector work space reserved to LOOPCNT elements. Also
#line 3701
   * makes vectorisation easy */
#line 3701
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3701
    ni=Min(nelems-j,LOOPCNT);
#line 3701
    if (realign) {
#line 3701
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3701
      xp = tmp;
#line 3701
    } else {
#line 3701
      xp = (uint64 *) *xpp;
#line 3701
    }
#line 3701
   /* copy the next block */
#line 3701
#pragma cdir loopcnt=LOOPCNT
#line 3701
#pragma cdir shortloop
#line 3701
    for (i=0; i<ni; i++) {
#line 3701
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3701
     /* test for range errors (not always needed but do it anyway) */
#line 3701
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3701
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3701
      nrange += xp[i] > USHORT_MAX ;
#line 3701
    }
#line 3701
   /* update xpp and tp */
#line 3701
    if (realign) xp = (uint64 *) *xpp;
#line 3701
    xp += ni;
#line 3701
    tp += ni;
#line 3701
    *xpp = (void*)xp;
#line 3701
  }
#line 3701
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3701

#line 3701
#else   /* not SX */
#line 3701
	const char *xp = (const char *) *xpp;
#line 3701
	int status = NC_NOERR;
#line 3701

#line 3701
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3701
	{
#line 3701
		const int lstatus = ncx_get_ulonglong_ushort(xp, tp);
#line 3701
		if (status == NC_NOERR) /* report the first encountered error */
#line 3701
			status = lstatus;
#line 3701
	}
#line 3701

#line 3701
	*xpp = (const void *)xp;
#line 3701
	return status;
#line 3701
#endif
#line 3701
}
#line 3701

int
#line 3702
ncx_getn_ulonglong_uint(const void **xpp, size_t nelems, uint *tp)
#line 3702
{
#line 3702
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3702

#line 3702
 /* basic algorithm is:
#line 3702
  *   - ensure sane alignment of input data
#line 3702
  *   - copy (conversion happens automatically) input data
#line 3702
  *     to output
#line 3702
  *   - update xpp to point at next unconverted input, and tp to point
#line 3702
  *     at next location for converted output
#line 3702
  */
#line 3702
  long i, j, ni;
#line 3702
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3702
  uint64 *xp;
#line 3702
  int nrange = 0;         /* number of range errors */
#line 3702
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3702
  long cxp = (long) *((char**)xpp);
#line 3702

#line 3702
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3702
  /* sjl: manually stripmine so we can limit amount of
#line 3702
   * vector work space reserved to LOOPCNT elements. Also
#line 3702
   * makes vectorisation easy */
#line 3702
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3702
    ni=Min(nelems-j,LOOPCNT);
#line 3702
    if (realign) {
#line 3702
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3702
      xp = tmp;
#line 3702
    } else {
#line 3702
      xp = (uint64 *) *xpp;
#line 3702
    }
#line 3702
   /* copy the next block */
#line 3702
#pragma cdir loopcnt=LOOPCNT
#line 3702
#pragma cdir shortloop
#line 3702
    for (i=0; i<ni; i++) {
#line 3702
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3702
     /* test for range errors (not always needed but do it anyway) */
#line 3702
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3702
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3702
      nrange += xp[i] > UINT_MAX ;
#line 3702
    }
#line 3702
   /* update xpp and tp */
#line 3702
    if (realign) xp = (uint64 *) *xpp;
#line 3702
    xp += ni;
#line 3702
    tp += ni;
#line 3702
    *xpp = (void*)xp;
#line 3702
  }
#line 3702
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3702

#line 3702
#else   /* not SX */
#line 3702
	const char *xp = (const char *) *xpp;
#line 3702
	int status = NC_NOERR;
#line 3702

#line 3702
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3702
	{
#line 3702
		const int lstatus = ncx_get_ulonglong_uint(xp, tp);
#line 3702
		if (status == NC_NOERR) /* report the first encountered error */
#line 3702
			status = lstatus;
#line 3702
	}
#line 3702

#line 3702
	*xpp = (const void *)xp;
#line 3702
	return status;
#line 3702
#endif
#line 3702
}
#line 3702


#if X_SIZEOF_UINT64 == SIZEOF_ULONGLONG
/* optimized version */
int
ncx_putn_ulonglong_ulonglong(void **xpp, size_t nelems, const unsigned long long *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_UINT64);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_UINT64);
	return NC_NOERR;
}
#else
int
#line 3718
ncx_putn_ulonglong_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3718
{
#line 3718
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3718

#line 3718
 /* basic algorithm is:
#line 3718
  *   - ensure sane alignment of output data
#line 3718
  *   - copy (conversion happens automatically) input data
#line 3718
  *     to output
#line 3718
  *   - update tp to point at next unconverted input, and xpp to point
#line 3718
  *     at next location for converted output
#line 3718
  */
#line 3718
  long i, j, ni;
#line 3718
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3718
  uint64 *xp;
#line 3718
  int nrange = 0;         /* number of range errors */
#line 3718
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3718
  long cxp = (long) *((char**)xpp);
#line 3718

#line 3718
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3718
  /* sjl: manually stripmine so we can limit amount of
#line 3718
   * vector work space reserved to LOOPCNT elements. Also
#line 3718
   * makes vectorisation easy */
#line 3718
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3718
    ni=Min(nelems-j,LOOPCNT);
#line 3718
    if (realign) {
#line 3718
      xp = tmp;
#line 3718
    } else {
#line 3718
      xp = (uint64 *) *xpp;
#line 3718
    }
#line 3718
   /* copy the next block */
#line 3718
#pragma cdir loopcnt=LOOPCNT
#line 3718
#pragma cdir shortloop
#line 3718
    for (i=0; i<ni; i++) {
#line 3718
      /* the normal case: */
#line 3718
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3718
     /* test for range errors (not always needed but do it anyway) */
#line 3718
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3718
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3718
      nrange += tp[i] > X_UINT64_MAX ;
#line 3718
    }
#line 3718
   /* copy workspace back if necessary */
#line 3718
    if (realign) {
#line 3718
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3718
      xp = (uint64 *) *xpp;
#line 3718
    }
#line 3718
   /* update xpp and tp */
#line 3718
    xp += ni;
#line 3718
    tp += ni;
#line 3718
    *xpp = (void*)xp;
#line 3718
  }
#line 3718
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3718

#line 3718
#else   /* not SX */
#line 3718

#line 3718
	char *xp = (char *) *xpp;
#line 3718
	int status = NC_NOERR;
#line 3718

#line 3718
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3718
	{
#line 3718
		int lstatus = ncx_put_ulonglong_ulonglong(xp, tp, fillp);
#line 3718
		if (status == NC_NOERR) /* report the first encountered error */
#line 3718
			status = lstatus;
#line 3718
	}
#line 3718

#line 3718
	*xpp = (void *)xp;
#line 3718
	return status;
#line 3718
#endif
#line 3718
}
#line 3718

#endif
int
#line 3720
ncx_putn_ulonglong_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3720
{
#line 3720
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3720

#line 3720
 /* basic algorithm is:
#line 3720
  *   - ensure sane alignment of output data
#line 3720
  *   - copy (conversion happens automatically) input data
#line 3720
  *     to output
#line 3720
  *   - update tp to point at next unconverted input, and xpp to point
#line 3720
  *     at next location for converted output
#line 3720
  */
#line 3720
  long i, j, ni;
#line 3720
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3720
  uint64 *xp;
#line 3720
  int nrange = 0;         /* number of range errors */
#line 3720
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3720
  long cxp = (long) *((char**)xpp);
#line 3720

#line 3720
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3720
  /* sjl: manually stripmine so we can limit amount of
#line 3720
   * vector work space reserved to LOOPCNT elements. Also
#line 3720
   * makes vectorisation easy */
#line 3720
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3720
    ni=Min(nelems-j,LOOPCNT);
#line 3720
    if (realign) {
#line 3720
      xp = tmp;
#line 3720
    } else {
#line 3720
      xp = (uint64 *) *xpp;
#line 3720
    }
#line 3720
   /* copy the next block */
#line 3720
#pragma cdir loopcnt=LOOPCNT
#line 3720
#pragma cdir shortloop
#line 3720
    for (i=0; i<ni; i++) {
#line 3720
      /* the normal case: */
#line 3720
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3720
     /* test for range errors (not always needed but do it anyway) */
#line 3720
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3720
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3720
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3720
    }
#line 3720
   /* copy workspace back if necessary */
#line 3720
    if (realign) {
#line 3720
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3720
      xp = (uint64 *) *xpp;
#line 3720
    }
#line 3720
   /* update xpp and tp */
#line 3720
    xp += ni;
#line 3720
    tp += ni;
#line 3720
    *xpp = (void*)xp;
#line 3720
  }
#line 3720
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3720

#line 3720
#else   /* not SX */
#line 3720

#line 3720
	char *xp = (char *) *xpp;
#line 3720
	int status = NC_NOERR;
#line 3720

#line 3720
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3720
	{
#line 3720
		int lstatus = ncx_put_ulonglong_schar(xp, tp, fillp);
#line 3720
		if (status == NC_NOERR) /* report the first encountered error */
#line 3720
			status = lstatus;
#line 3720
	}
#line 3720

#line 3720
	*xpp = (void *)xp;
#line 3720
	return status;
#line 3720
#endif
#line 3720
}
#line 3720

int
#line 3721
ncx_putn_ulonglong_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3721
{
#line 3721
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3721

#line 3721
 /* basic algorithm is:
#line 3721
  *   - ensure sane alignment of output data
#line 3721
  *   - copy (conversion happens automatically) input data
#line 3721
  *     to output
#line 3721
  *   - update tp to point at next unconverted input, and xpp to point
#line 3721
  *     at next location for converted output
#line 3721
  */
#line 3721
  long i, j, ni;
#line 3721
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3721
  uint64 *xp;
#line 3721
  int nrange = 0;         /* number of range errors */
#line 3721
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3721
  long cxp = (long) *((char**)xpp);
#line 3721

#line 3721
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3721
  /* sjl: manually stripmine so we can limit amount of
#line 3721
   * vector work space reserved to LOOPCNT elements. Also
#line 3721
   * makes vectorisation easy */
#line 3721
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3721
    ni=Min(nelems-j,LOOPCNT);
#line 3721
    if (realign) {
#line 3721
      xp = tmp;
#line 3721
    } else {
#line 3721
      xp = (uint64 *) *xpp;
#line 3721
    }
#line 3721
   /* copy the next block */
#line 3721
#pragma cdir loopcnt=LOOPCNT
#line 3721
#pragma cdir shortloop
#line 3721
    for (i=0; i<ni; i++) {
#line 3721
      /* the normal case: */
#line 3721
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3721
     /* test for range errors (not always needed but do it anyway) */
#line 3721
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3721
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3721
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3721
    }
#line 3721
   /* copy workspace back if necessary */
#line 3721
    if (realign) {
#line 3721
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3721
      xp = (uint64 *) *xpp;
#line 3721
    }
#line 3721
   /* update xpp and tp */
#line 3721
    xp += ni;
#line 3721
    tp += ni;
#line 3721
    *xpp = (void*)xp;
#line 3721
  }
#line 3721
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3721

#line 3721
#else   /* not SX */
#line 3721

#line 3721
	char *xp = (char *) *xpp;
#line 3721
	int status = NC_NOERR;
#line 3721

#line 3721
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3721
	{
#line 3721
		int lstatus = ncx_put_ulonglong_short(xp, tp, fillp);
#line 3721
		if (status == NC_NOERR) /* report the first encountered error */
#line 3721
			status = lstatus;
#line 3721
	}
#line 3721

#line 3721
	*xpp = (void *)xp;
#line 3721
	return status;
#line 3721
#endif
#line 3721
}
#line 3721

int
#line 3722
ncx_putn_ulonglong_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3722
{
#line 3722
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3722

#line 3722
 /* basic algorithm is:
#line 3722
  *   - ensure sane alignment of output data
#line 3722
  *   - copy (conversion happens automatically) input data
#line 3722
  *     to output
#line 3722
  *   - update tp to point at next unconverted input, and xpp to point
#line 3722
  *     at next location for converted output
#line 3722
  */
#line 3722
  long i, j, ni;
#line 3722
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3722
  uint64 *xp;
#line 3722
  int nrange = 0;         /* number of range errors */
#line 3722
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3722
  long cxp = (long) *((char**)xpp);
#line 3722

#line 3722
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3722
  /* sjl: manually stripmine so we can limit amount of
#line 3722
   * vector work space reserved to LOOPCNT elements. Also
#line 3722
   * makes vectorisation easy */
#line 3722
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3722
    ni=Min(nelems-j,LOOPCNT);
#line 3722
    if (realign) {
#line 3722
      xp = tmp;
#line 3722
    } else {
#line 3722
      xp = (uint64 *) *xpp;
#line 3722
    }
#line 3722
   /* copy the next block */
#line 3722
#pragma cdir loopcnt=LOOPCNT
#line 3722
#pragma cdir shortloop
#line 3722
    for (i=0; i<ni; i++) {
#line 3722
      /* the normal case: */
#line 3722
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3722
     /* test for range errors (not always needed but do it anyway) */
#line 3722
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3722
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3722
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3722
    }
#line 3722
   /* copy workspace back if necessary */
#line 3722
    if (realign) {
#line 3722
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3722
      xp = (uint64 *) *xpp;
#line 3722
    }
#line 3722
   /* update xpp and tp */
#line 3722
    xp += ni;
#line 3722
    tp += ni;
#line 3722
    *xpp = (void*)xp;
#line 3722
  }
#line 3722
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3722

#line 3722
#else   /* not SX */
#line 3722

#line 3722
	char *xp = (char *) *xpp;
#line 3722
	int status = NC_NOERR;
#line 3722

#line 3722
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3722
	{
#line 3722
		int lstatus = ncx_put_ulonglong_int(xp, tp, fillp);
#line 3722
		if (status == NC_NOERR) /* report the first encountered error */
#line 3722
			status = lstatus;
#line 3722
	}
#line 3722

#line 3722
	*xpp = (void *)xp;
#line 3722
	return status;
#line 3722
#endif
#line 3722
}
#line 3722

int
#line 3723
ncx_putn_ulonglong_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3723
{
#line 3723
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3723

#line 3723
 /* basic algorithm is:
#line 3723
  *   - ensure sane alignment of output data
#line 3723
  *   - copy (conversion happens automatically) input data
#line 3723
  *     to output
#line 3723
  *   - update tp to point at next unconverted input, and xpp to point
#line 3723
  *     at next location for converted output
#line 3723
  */
#line 3723
  long i, j, ni;
#line 3723
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3723
  uint64 *xp;
#line 3723
  int nrange = 0;         /* number of range errors */
#line 3723
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3723
  long cxp = (long) *((char**)xpp);
#line 3723

#line 3723
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3723
  /* sjl: manually stripmine so we can limit amount of
#line 3723
   * vector work space reserved to LOOPCNT elements. Also
#line 3723
   * makes vectorisation easy */
#line 3723
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3723
    ni=Min(nelems-j,LOOPCNT);
#line 3723
    if (realign) {
#line 3723
      xp = tmp;
#line 3723
    } else {
#line 3723
      xp = (uint64 *) *xpp;
#line 3723
    }
#line 3723
   /* copy the next block */
#line 3723
#pragma cdir loopcnt=LOOPCNT
#line 3723
#pragma cdir shortloop
#line 3723
    for (i=0; i<ni; i++) {
#line 3723
      /* the normal case: */
#line 3723
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3723
     /* test for range errors (not always needed but do it anyway) */
#line 3723
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3723
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3723
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3723
    }
#line 3723
   /* copy workspace back if necessary */
#line 3723
    if (realign) {
#line 3723
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3723
      xp = (uint64 *) *xpp;
#line 3723
    }
#line 3723
   /* update xpp and tp */
#line 3723
    xp += ni;
#line 3723
    tp += ni;
#line 3723
    *xpp = (void*)xp;
#line 3723
  }
#line 3723
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3723

#line 3723
#else   /* not SX */
#line 3723

#line 3723
	char *xp = (char *) *xpp;
#line 3723
	int status = NC_NOERR;
#line 3723

#line 3723
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3723
	{
#line 3723
		int lstatus = ncx_put_ulonglong_long(xp, tp, fillp);
#line 3723
		if (status == NC_NOERR) /* report the first encountered error */
#line 3723
			status = lstatus;
#line 3723
	}
#line 3723

#line 3723
	*xpp = (void *)xp;
#line 3723
	return status;
#line 3723
#endif
#line 3723
}
#line 3723

int
#line 3724
ncx_putn_ulonglong_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3724
{
#line 3724
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3724

#line 3724
 /* basic algorithm is:
#line 3724
  *   - ensure sane alignment of output data
#line 3724
  *   - copy (conversion happens automatically) input data
#line 3724
  *     to output
#line 3724
  *   - update tp to point at next unconverted input, and xpp to point
#line 3724
  *     at next location for converted output
#line 3724
  */
#line 3724
  long i, j, ni;
#line 3724
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3724
  uint64 *xp;
#line 3724
  int nrange = 0;         /* number of range errors */
#line 3724
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3724
  long cxp = (long) *((char**)xpp);
#line 3724

#line 3724
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3724
  /* sjl: manually stripmine so we can limit amount of
#line 3724
   * vector work space reserved to LOOPCNT elements. Also
#line 3724
   * makes vectorisation easy */
#line 3724
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3724
    ni=Min(nelems-j,LOOPCNT);
#line 3724
    if (realign) {
#line 3724
      xp = tmp;
#line 3724
    } else {
#line 3724
      xp = (uint64 *) *xpp;
#line 3724
    }
#line 3724
   /* copy the next block */
#line 3724
#pragma cdir loopcnt=LOOPCNT
#line 3724
#pragma cdir shortloop
#line 3724
    for (i=0; i<ni; i++) {
#line 3724
      /* the normal case: */
#line 3724
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3724
     /* test for range errors (not always needed but do it anyway) */
#line 3724
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3724
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3724
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3724
    }
#line 3724
   /* copy workspace back if necessary */
#line 3724
    if (realign) {
#line 3724
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3724
      xp = (uint64 *) *xpp;
#line 3724
    }
#line 3724
   /* update xpp and tp */
#line 3724
    xp += ni;
#line 3724
    tp += ni;
#line 3724
    *xpp = (void*)xp;
#line 3724
  }
#line 3724
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3724

#line 3724
#else   /* not SX */
#line 3724

#line 3724
	char *xp = (char *) *xpp;
#line 3724
	int status = NC_NOERR;
#line 3724

#line 3724
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3724
	{
#line 3724
		int lstatus = ncx_put_ulonglong_float(xp, tp, fillp);
#line 3724
		if (status == NC_NOERR) /* report the first encountered error */
#line 3724
			status = lstatus;
#line 3724
	}
#line 3724

#line 3724
	*xpp = (void *)xp;
#line 3724
	return status;
#line 3724
#endif
#line 3724
}
#line 3724

int
#line 3725
ncx_putn_ulonglong_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3725
{
#line 3725
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3725

#line 3725
 /* basic algorithm is:
#line 3725
  *   - ensure sane alignment of output data
#line 3725
  *   - copy (conversion happens automatically) input data
#line 3725
  *     to output
#line 3725
  *   - update tp to point at next unconverted input, and xpp to point
#line 3725
  *     at next location for converted output
#line 3725
  */
#line 3725
  long i, j, ni;
#line 3725
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3725
  uint64 *xp;
#line 3725
  int nrange = 0;         /* number of range errors */
#line 3725
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3725
  long cxp = (long) *((char**)xpp);
#line 3725

#line 3725
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3725
  /* sjl: manually stripmine so we can limit amount of
#line 3725
   * vector work space reserved to LOOPCNT elements. Also
#line 3725
   * makes vectorisation easy */
#line 3725
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3725
    ni=Min(nelems-j,LOOPCNT);
#line 3725
    if (realign) {
#line 3725
      xp = tmp;
#line 3725
    } else {
#line 3725
      xp = (uint64 *) *xpp;
#line 3725
    }
#line 3725
   /* copy the next block */
#line 3725
#pragma cdir loopcnt=LOOPCNT
#line 3725
#pragma cdir shortloop
#line 3725
    for (i=0; i<ni; i++) {
#line 3725
      /* the normal case: */
#line 3725
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3725
     /* test for range errors (not always needed but do it anyway) */
#line 3725
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3725
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3725
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3725
    }
#line 3725
   /* copy workspace back if necessary */
#line 3725
    if (realign) {
#line 3725
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3725
      xp = (uint64 *) *xpp;
#line 3725
    }
#line 3725
   /* update xpp and tp */
#line 3725
    xp += ni;
#line 3725
    tp += ni;
#line 3725
    *xpp = (void*)xp;
#line 3725
  }
#line 3725
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3725

#line 3725
#else   /* not SX */
#line 3725

#line 3725
	char *xp = (char *) *xpp;
#line 3725
	int status = NC_NOERR;
#line 3725

#line 3725
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3725
	{
#line 3725
		int lstatus = ncx_put_ulonglong_double(xp, tp, fillp);
#line 3725
		if (status == NC_NOERR) /* report the first encountered error */
#line 3725
			status = lstatus;
#line 3725
	}
#line 3725

#line 3725
	*xpp = (void *)xp;
#line 3725
	return status;
#line 3725
#endif
#line 3725
}
#line 3725

int
#line 3726
ncx_putn_ulonglong_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3726
{
#line 3726
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3726

#line 3726
 /* basic algorithm is:
#line 3726
  *   - ensure sane alignment of output data
#line 3726
  *   - copy (conversion happens automatically) input data
#line 3726
  *     to output
#line 3726
  *   - update tp to point at next unconverted input, and xpp to point
#line 3726
  *     at next location for converted output
#line 3726
  */
#line 3726
  long i, j, ni;
#line 3726
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3726
  uint64 *xp;
#line 3726
  int nrange = 0;         /* number of range errors */
#line 3726
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3726
  long cxp = (long) *((char**)xpp);
#line 3726

#line 3726
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3726
  /* sjl: manually stripmine so we can limit amount of
#line 3726
   * vector work space reserved to LOOPCNT elements. Also
#line 3726
   * makes vectorisation easy */
#line 3726
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3726
    ni=Min(nelems-j,LOOPCNT);
#line 3726
    if (realign) {
#line 3726
      xp = tmp;
#line 3726
    } else {
#line 3726
      xp = (uint64 *) *xpp;
#line 3726
    }
#line 3726
   /* copy the next block */
#line 3726
#pragma cdir loopcnt=LOOPCNT
#line 3726
#pragma cdir shortloop
#line 3726
    for (i=0; i<ni; i++) {
#line 3726
      /* the normal case: */
#line 3726
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3726
     /* test for range errors (not always needed but do it anyway) */
#line 3726
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3726
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3726
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3726
    }
#line 3726
   /* copy workspace back if necessary */
#line 3726
    if (realign) {
#line 3726
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3726
      xp = (uint64 *) *xpp;
#line 3726
    }
#line 3726
   /* update xpp and tp */
#line 3726
    xp += ni;
#line 3726
    tp += ni;
#line 3726
    *xpp = (void*)xp;
#line 3726
  }
#line 3726
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3726

#line 3726
#else   /* not SX */
#line 3726

#line 3726
	char *xp = (char *) *xpp;
#line 3726
	int status = NC_NOERR;
#line 3726

#line 3726
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3726
	{
#line 3726
		int lstatus = ncx_put_ulonglong_longlong(xp, tp, fillp);
#line 3726
		if (status == NC_NOERR) /* report the first encountered error */
#line 3726
			status = lstatus;
#line 3726
	}
#line 3726

#line 3726
	*xpp = (void *)xp;
#line 3726
	return status;
#line 3726
#endif
#line 3726
}
#line 3726

int
#line 3727
ncx_putn_ulonglong_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3727
{
#line 3727
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3727

#line 3727
 /* basic algorithm is:
#line 3727
  *   - ensure sane alignment of output data
#line 3727
  *   - copy (conversion happens automatically) input data
#line 3727
  *     to output
#line 3727
  *   - update tp to point at next unconverted input, and xpp to point
#line 3727
  *     at next location for converted output
#line 3727
  */
#line 3727
  long i, j, ni;
#line 3727
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3727
  uint64 *xp;
#line 3727
  int nrange = 0;         /* number of range errors */
#line 3727
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3727
  long cxp = (long) *((char**)xpp);
#line 3727

#line 3727
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3727
  /* sjl: manually stripmine so we can limit amount of
#line 3727
   * vector work space reserved to LOOPCNT elements. Also
#line 3727
   * makes vectorisation easy */
#line 3727
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3727
    ni=Min(nelems-j,LOOPCNT);
#line 3727
    if (realign) {
#line 3727
      xp = tmp;
#line 3727
    } else {
#line 3727
      xp = (uint64 *) *xpp;
#line 3727
    }
#line 3727
   /* copy the next block */
#line 3727
#pragma cdir loopcnt=LOOPCNT
#line 3727
#pragma cdir shortloop
#line 3727
    for (i=0; i<ni; i++) {
#line 3727
      /* the normal case: */
#line 3727
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3727
     /* test for range errors (not always needed but do it anyway) */
#line 3727
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3727
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3727
      nrange += tp[i] > X_UINT64_MAX ;
#line 3727
    }
#line 3727
   /* copy workspace back if necessary */
#line 3727
    if (realign) {
#line 3727
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3727
      xp = (uint64 *) *xpp;
#line 3727
    }
#line 3727
   /* update xpp and tp */
#line 3727
    xp += ni;
#line 3727
    tp += ni;
#line 3727
    *xpp = (void*)xp;
#line 3727
  }
#line 3727
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3727

#line 3727
#else   /* not SX */
#line 3727

#line 3727
	char *xp = (char *) *xpp;
#line 3727
	int status = NC_NOERR;
#line 3727

#line 3727
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3727
	{
#line 3727
		int lstatus = ncx_put_ulonglong_uchar(xp, tp, fillp);
#line 3727
		if (status == NC_NOERR) /* report the first encountered error */
#line 3727
			status = lstatus;
#line 3727
	}
#line 3727

#line 3727
	*xpp = (void *)xp;
#line 3727
	return status;
#line 3727
#endif
#line 3727
}
#line 3727

int
#line 3728
ncx_putn_ulonglong_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3728
{
#line 3728
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3728

#line 3728
 /* basic algorithm is:
#line 3728
  *   - ensure sane alignment of output data
#line 3728
  *   - copy (conversion happens automatically) input data
#line 3728
  *     to output
#line 3728
  *   - update tp to point at next unconverted input, and xpp to point
#line 3728
  *     at next location for converted output
#line 3728
  */
#line 3728
  long i, j, ni;
#line 3728
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3728
  uint64 *xp;
#line 3728
  int nrange = 0;         /* number of range errors */
#line 3728
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3728
  long cxp = (long) *((char**)xpp);
#line 3728

#line 3728
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3728
  /* sjl: manually stripmine so we can limit amount of
#line 3728
   * vector work space reserved to LOOPCNT elements. Also
#line 3728
   * makes vectorisation easy */
#line 3728
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3728
    ni=Min(nelems-j,LOOPCNT);
#line 3728
    if (realign) {
#line 3728
      xp = tmp;
#line 3728
    } else {
#line 3728
      xp = (uint64 *) *xpp;
#line 3728
    }
#line 3728
   /* copy the next block */
#line 3728
#pragma cdir loopcnt=LOOPCNT
#line 3728
#pragma cdir shortloop
#line 3728
    for (i=0; i<ni; i++) {
#line 3728
      /* the normal case: */
#line 3728
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3728
     /* test for range errors (not always needed but do it anyway) */
#line 3728
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3728
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3728
      nrange += tp[i] > X_UINT64_MAX ;
#line 3728
    }
#line 3728
   /* copy workspace back if necessary */
#line 3728
    if (realign) {
#line 3728
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3728
      xp = (uint64 *) *xpp;
#line 3728
    }
#line 3728
   /* update xpp and tp */
#line 3728
    xp += ni;
#line 3728
    tp += ni;
#line 3728
    *xpp = (void*)xp;
#line 3728
  }
#line 3728
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3728

#line 3728
#else   /* not SX */
#line 3728

#line 3728
	char *xp = (char *) *xpp;
#line 3728
	int status = NC_NOERR;
#line 3728

#line 3728
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3728
	{
#line 3728
		int lstatus = ncx_put_ulonglong_ushort(xp, tp, fillp);
#line 3728
		if (status == NC_NOERR) /* report the first encountered error */
#line 3728
			status = lstatus;
#line 3728
	}
#line 3728

#line 3728
	*xpp = (void *)xp;
#line 3728
	return status;
#line 3728
#endif
#line 3728
}
#line 3728

int
#line 3729
ncx_putn_ulonglong_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3729
{
#line 3729
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3729

#line 3729
 /* basic algorithm is:
#line 3729
  *   - ensure sane alignment of output data
#line 3729
  *   - copy (conversion happens automatically) input data
#line 3729
  *     to output
#line 3729
  *   - update tp to point at next unconverted input, and xpp to point
#line 3729
  *     at next location for converted output
#line 3729
  */
#line 3729
  long i, j, ni;
#line 3729
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3729
  uint64 *xp;
#line 3729
  int nrange = 0;         /* number of range errors */
#line 3729
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3729
  long cxp = (long) *((char**)xpp);
#line 3729

#line 3729
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3729
  /* sjl: manually stripmine so we can limit amount of
#line 3729
   * vector work space reserved to LOOPCNT elements. Also
#line 3729
   * makes vectorisation easy */
#line 3729
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3729
    ni=Min(nelems-j,LOOPCNT);
#line 3729
    if (realign) {
#line 3729
      xp = tmp;
#line 3729
    } else {
#line 3729
      xp = (uint64 *) *xpp;
#line 3729
    }
#line 3729
   /* copy the next block */
#line 3729
#pragma cdir loopcnt=LOOPCNT
#line 3729
#pragma cdir shortloop
#line 3729
    for (i=0; i<ni; i++) {
#line 3729
      /* the normal case: */
#line 3729
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3729
     /* test for range errors (not always needed but do it anyway) */
#line 3729
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3729
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3729
      nrange += tp[i] > X_UINT64_MAX ;
#line 3729
    }
#line 3729
   /* copy workspace back if necessary */
#line 3729
    if (realign) {
#line 3729
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3729
      xp = (uint64 *) *xpp;
#line 3729
    }
#line 3729
   /* update xpp and tp */
#line 3729
    xp += ni;
#line 3729
    tp += ni;
#line 3729
    *xpp = (void*)xp;
#line 3729
  }
#line 3729
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3729

#line 3729
#else   /* not SX */
#line 3729

#line 3729
	char *xp = (char *) *xpp;
#line 3729
	int status = NC_NOERR;
#line 3729

#line 3729
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3729
	{
#line 3729
		int lstatus = ncx_put_ulonglong_uint(xp, tp, fillp);
#line 3729
		if (status == NC_NOERR) /* report the first encountered error */
#line 3729
			status = lstatus;
#line 3729
	}
#line 3729

#line 3729
	*xpp = (void *)xp;
#line 3729
	return status;
#line 3729
#endif
#line 3729
}
#line 3729



/*
 * Other aggregate conversion functions.
 */

/* text */

int
ncx_getn_text(const void **xpp, size_t nelems, char *tp)
{
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3741
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3741
	return NC_NOERR;
#line 3741

}

int
ncx_pad_getn_text(const void **xpp, size_t nelems, char *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3747

#line 3747
	if (rndup)
#line 3747
		rndup = X_ALIGN - rndup;
#line 3747

#line 3747
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3747
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 3747

#line 3747
	return NC_NOERR;
#line 3747

}

int
ncx_putn_text(void **xpp, size_t nelems, const char *tp)
{
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3753
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3753

#line 3753
	return NC_NOERR;
#line 3753

}

int
ncx_pad_putn_text(void **xpp, size_t nelems, const char *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3759

#line 3759
	if (rndup)
#line 3759
		rndup = X_ALIGN - rndup;
#line 3759

#line 3759
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3759
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3759

#line 3759
	if (rndup)
#line 3759
	{
#line 3759
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 3759
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 3759
	}
#line 3759

#line 3759
	return NC_NOERR;
#line 3759

}


/* opaque */

int
ncx_getn_void(const void **xpp, size_t nelems, void *tp)
{
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3768
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3768
	return NC_NOERR;
#line 3768

}

int
ncx_pad_getn_void(const void **xpp, size_t nelems, void *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3774

#line 3774
	if (rndup)
#line 3774
		rndup = X_ALIGN - rndup;
#line 3774

#line 3774
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3774
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 3774

#line 3774
	return NC_NOERR;
#line 3774

}

int
ncx_putn_void(void **xpp, size_t nelems, const void *tp)
{
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3780
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3780

#line 3780
	return NC_NOERR;
#line 3780

}

int
ncx_pad_putn_void(void **xpp, size_t nelems, const void *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3786

#line 3786
	if (rndup)
#line 3786
		rndup = X_ALIGN - rndup;
#line 3786

#line 3786
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3786
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3786

#line 3786
	if (rndup)
#line 3786
	{
#line 3786
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 3786
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 3786
	}
#line 3786

#line 3786
	return NC_NOERR;
#line 3786

}
