<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# Int32

> Base utilities for signed 32-bit integers.

<section class="usage">

## Usage

```javascript
var ns = require( '@stdlib/number/int32/base' );
```

#### ns

Base utilities for signed 32-bit integers.

```javascript
var o = ns;
// returns {...}
```

<!-- <toc pattern="*"> -->

<div class="namespace-toc">

-   <span class="signature">[`int32ToUint32( x )`][@stdlib/number/int32/base/to-uint32]</span><span class="delimiter">: </span><span class="description">convert a signed 32-bit integer to an unsigned 32-bit integer.</span>

</div>

<!-- </toc> -->

</section>

<!-- /.usage -->

<section class="examples">

## Examples

<!-- TODO: better examples -->

<!-- eslint no-undef: "error" -->

```javascript
var objectKeys = require( '@stdlib/utils/keys' );
var ns = require( '@stdlib/number/int32/base' );

console.log( objectKeys( ns ) );
```

</section>

<!-- /.examples -->

<section class="links">

<!-- <toc-links> -->

[@stdlib/number/int32/base/to-uint32]: https://github.com/stdlib-js/number/tree/main/int32/base/to-uint32

<!-- </toc-links> -->

</section>

<!-- /.links -->
