
# example.js

``` javascript
var Worker = require("worker-loader!./worker");
var worker = new Worker;
worker.postMessage("b");
worker.onmessage = function(event) {
	var templateB = event.data; // "This text was generated by template B"
}
```

# worker.js

``` javascript
onmessage = function(event) {
	var template = event.data;
	require(["../require.context/templates/" + event.data], function(tmpl) {
		postMessage(tmpl());
	});
}
```

# js/output.js

<details><summary><code>/******/ (function(modules) { /* webpackBootstrap */ })</code></summary>

``` javascript
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "js/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
```

</details>

``` javascript
/******/ ([
/* 0 */
/*!********************!*\
  !*** ./example.js ***!
  \********************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

var Worker = __webpack_require__(/*! worker-loader!./worker */ 1);
var worker = new Worker;
worker.postMessage("b");
worker.onmessage = function(event) {
	var templateB = event.data; // "This text was generated by template B"
}


/***/ }),
/* 1 */
/*!********************************************************!*\
  !*** (webpack)/node_modules/worker-loader!./worker.js ***!
  \********************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

module.exports = function() {
	return new Worker(__webpack_require__.p + "hash.worker.js");
};

/***/ })
/******/ ]);
```

# js/[hash].worker.js

``` javascript
/******/ (function(modules) { // webpackBootstrap
/******/ 	this["webpackChunk"] = function webpackChunkCallback(chunkIds, moreModules) {
/******/ 		for(var moduleId in moreModules) {
/******/ 			modules[moduleId] = moreModules[moduleId];
/******/ 		}
/******/ 		while(chunkIds.length)
/******/ 			installedChunks[chunkIds.pop()] = 1;
/******/ 	};
/******/
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// object to store loaded chunks
/******/ 	// "1" means "already loaded"
/******/ 	var installedChunks = {
/******/ 		1: 1
/******/ 	};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/ 	// This file contains only the entry chunk.
/******/ 	// The chunk loading function for additional chunks
/******/ 	__webpack_require__.e = function requireEnsure(chunkId) {
/******/ 		return new Promise(function(resolve) {
/******/ 			// "1" is the signal for "already loaded"
/******/ 			if(!installedChunks[chunkId]) {
/******/ 				importScripts("" + chunkId + ".hash.worker.js");
/******/ 			}
/******/ 			resolve();
/******/ 		});
/******/ 	};
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "js/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/*!*******************!*\
  !*** ./worker.js ***!
  \*******************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

onmessage = function(event) {
	var template = event.data;
	__webpack_require__.e/* require */(0).then(function() { var __WEBPACK_AMD_REQUIRE_ARRAY__ = [__webpack_require__(/*! ../require.context/templates */ 1)("./" + event.data)]; (function(tmpl) {
		postMessage(tmpl());
	}.apply(null, __WEBPACK_AMD_REQUIRE_ARRAY__));}).catch(__webpack_require__.oe);
}


/***/ })
/******/ ]);
```

# js/0.[hash].worker.js

``` javascript
webpackChunk([0],[
/* 0 */,
/* 1 */
/*!*********************************************!*\
  !*** ../require.context/templates ^\.\/.*$ ***!
  \*********************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

var map = {
	"./a": 2,
	"./a.js": 2,
	"./b": 3,
	"./b.js": 3,
	"./c": 4,
	"./c.js": 4
};
function webpackContext(req) {
	return __webpack_require__(webpackContextResolve(req));
};
function webpackContextResolve(req) {
	var id = map[req];
	if(!(id + 1)) // check for number or string
		throw new Error("Cannot find module '" + req + "'.");
	return id;
};
webpackContext.keys = function webpackContextKeys() {
	return Object.keys(map);
};
webpackContext.resolve = webpackContextResolve;
module.exports = webpackContext;
webpackContext.id = 1;

/***/ }),
/* 2 */
/*!*****************************************!*\
  !*** ../require.context/templates/a.js ***!
  \*****************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = function() {
	return "This text was generated by template A";
}

/***/ }),
/* 3 */
/*!*****************************************!*\
  !*** ../require.context/templates/b.js ***!
  \*****************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = function() {
	return "This text was generated by template B";
}

/***/ }),
/* 4 */
/*!*****************************************!*\
  !*** ../require.context/templates/c.js ***!
  \*****************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports) {

module.exports = function() {
	return "This text was generated by template C";
}

/***/ })
]);
```

# Info

## Uncompressed

```
Hash: de5e6c34dad6f90c6640
Version: webpack 3.5.1
           Asset     Size  Chunks             Chunk Names
0.hash.worker.js  1.85 kB          [emitted]  
  hash.worker.js  3.91 kB          [emitted]  
       output.js  3.27 kB       0  [emitted]  main
Entrypoint main = output.js
chunk    {0} output.js (main) 311 bytes [entry] [rendered]
    > main [0] ./example.js 
    [0] ./example.js 215 bytes {0} [built]
    [1] (webpack)/node_modules/worker-loader!./worker.js 96 bytes {0} [not cacheable] [built]
        cjs require worker-loader!./worker [0] ./example.js 1:13-46
Child worker:
               Asset     Size  Chunks             Chunk Names
    0.hash.worker.js  1.85 kB       0  [emitted]  
      hash.worker.js  3.91 kB       1  [emitted]  main
    Entrypoint main = hash.worker.js
    chunk    {0} 0.hash.worker.js 463 bytes {1} [rendered]
        > [0] ./worker.js 3:1-5:3
        [1] ../require.context/templates ^\.\/.*$ 217 bytes {0} [built]
            amd require context ../require.context/templates [0] ./worker.js 3:1-5:3
        [2] ../require.context/templates/a.js 82 bytes {0} [optional] [built]
            context element ./a.js [1] ../require.context/templates ^\.\/.*$ ./a.js
            context element ./a [1] ../require.context/templates ^\.\/.*$ ./a
        [3] ../require.context/templates/b.js 82 bytes {0} [optional] [built]
            context element ./b.js [1] ../require.context/templates ^\.\/.*$ ./b.js
            context element ./b [1] ../require.context/templates ^\.\/.*$ ./b
        [4] ../require.context/templates/c.js 82 bytes {0} [optional] [built]
            context element ./c.js [1] ../require.context/templates ^\.\/.*$ ./c.js
            context element ./c [1] ../require.context/templates ^\.\/.*$ ./c
    chunk    {1} hash.worker.js (main) 168 bytes [entry] [rendered]
        > main [0] ./worker.js 
        [0] ./worker.js 168 bytes {1} [built]
```

## Minimized (uglify-js, no zip)

```
Hash: de5e6c34dad6f90c6640
Version: webpack 3.5.1
           Asset       Size  Chunks             Chunk Names
0.hash.worker.js  544 bytes          [emitted]  
  hash.worker.js  811 bytes          [emitted]  
       output.js  632 bytes       0  [emitted]  main
Entrypoint main = output.js
chunk    {0} output.js (main) 311 bytes [entry] [rendered]
    > main [0] ./example.js 
    [0] ./example.js 215 bytes {0} [built]
    [1] (webpack)/node_modules/worker-loader!./worker.js 96 bytes {0} [not cacheable] [built]
        cjs require worker-loader!./worker [0] ./example.js 1:13-46
Child worker:
               Asset       Size  Chunks             Chunk Names
    0.hash.worker.js  544 bytes       0  [emitted]  
      hash.worker.js  811 bytes       1  [emitted]  main
    Entrypoint main = hash.worker.js
    chunk    {0} 0.hash.worker.js 463 bytes {1} [rendered]
        > [0] ./worker.js 3:1-5:3
        [1] ../require.context/templates ^\.\/.*$ 217 bytes {0} [built]
            amd require context ../require.context/templates [0] ./worker.js 3:1-5:3
        [2] ../require.context/templates/a.js 82 bytes {0} [optional] [built]
            context element ./a.js [1] ../require.context/templates ^\.\/.*$ ./a.js
            context element ./a [1] ../require.context/templates ^\.\/.*$ ./a
        [3] ../require.context/templates/b.js 82 bytes {0} [optional] [built]
            context element ./b.js [1] ../require.context/templates ^\.\/.*$ ./b.js
            context element ./b [1] ../require.context/templates ^\.\/.*$ ./b
        [4] ../require.context/templates/c.js 82 bytes {0} [optional] [built]
            context element ./c.js [1] ../require.context/templates ^\.\/.*$ ./c.js
            context element ./c [1] ../require.context/templates ^\.\/.*$ ./c
    chunk    {1} hash.worker.js (main) 168 bytes [entry] [rendered]
        > main [0] ./worker.js 
        [0] ./worker.js 168 bytes {1} [built]
```
