# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1871-1 (wordpress)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64754);
 script_cve_id("CVE-2008-6762", "CVE-2008-6767", "CVE-2009-2334", "CVE-2009-2854", "CVE-2009-2851", "CVE-2009-2853", "CVE-2008-1502", "CVE-2008-4106", "CVE-2008-4769", "CVE-2008-4796", "CVE-2008-5113");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Debian Security Advisory DSA 1871-1 (wordpress)");

 desc = "The remote host is missing an update to wordpress
announced via advisory DSA 1871-1.


Several vulnerabilities have been discovered in wordpress, weblog
manager. The Common Vulnerabilities and Exposures project identifies the
following problems:

CVE-2008-6762

It was discovered that wordpress is prone to an open redirect
vulnerability which allows remote attackers to conduct phishing atacks.

CVE-2008-6767

It was discovered that remote attackers had the ability to trigger an
application upgrade, which could lead to a denial of service attack.

CVE-2009-2334

It was discovered that wordpress lacks authentication checks in the
plugin configuration, which might leak sensitive information.

CVE-2009-2854

It was discovered that wordpress lacks authentication checks in various
actions, thus allowing remote attackers to produce unauthorised edits or
additions.

CVE-2009-2851

It was discovered that the administrator interface is prone to a
cross-site scripting attack.

CVE-2009-2853

It was discovered that remote attackers can gain privileges via certain
direct requests.

CVE-2008-1502

It was discovered that the _bad_protocol_once function in KSES, as used
by wordpress, allows remote attackers to perform cross-site scripting
attacks.

CVE-2008-4106

It was discovered that wordpress lacks certain checks around user
information, which could be used by attackers to change the password of
a user.

CVE-2008-4769

It was discovered that the get_category_template function is prone to a
directory traversal vulnerability, which could lead to the execution of
arbitrary code.

CVE-2008-4796

It was discovered that the _httpsrequest function in the embedded snoopy
version is prone to the execution of arbitrary commands via shell
metacharacters in https URLs.

CVE-2008-5113

It was discovered that wordpress relies on the REQUEST superglobal array
in certain dangerous situations, which makes it easier to perform
attacks via crafted cookies.


For the stable distribution (lenny), these problems have been fixed in
version 2.5.1-11+lenny1.

For the oldstable distribution (etch), these problems have been fixed in
version 2.0.10-1etch4.

For the testing distribution (squeeze) and the unstable distribution
(sid), these problems have been fixed in version 2.8.3-1.


We recommend that you upgrade your wordpress packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201871-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1871-1 (wordpress)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"wordpress", ver:"2.0.10-1etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wordpress", ver:"2.5.1-11+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
