#
#VID cdf18ed9-7f4a-11d8-9645-0020ed76ef5a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52432);
 script_cve_id("CVE-2004-0176", "CVE-2004-0365", "CVE-2004-0367");
 script_bugtraq_id(9952);
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: ethereal, tethereal";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   ethereal
   tethereal

CVE-2004-0176
Multiple buffer overflows in Ethereal 0.8.13 to 0.10.2 allow remote
attackers to cause a denial of service and possibly execute arbitrary
code via the (1) NetFlow, (2) IGAP, (3) EIGRP, (4) PGM, (5) IrDA, (6)
BGP, (7) ISUP, or (8) TCAP dissectors.

CVE-2004-0365
The dissect_attribute_value_pairs function in packet-radius.c for
Ethereal 0.8.13 to 0.10.2 allows remote attackers to cause a denial of
service (crash) via a malformed RADIUS packet that triggers a null
dereference.

CVE-2004-0367
Ethereal 0.10.1 to 0.10.2 allows remote attackers to cause a denial of
service (crash) via a zero-length Presentation protocol selector.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.ethereal.com/appnotes/enpa-sa-00013.html
http://security.e-matters.de/advisories/032004.html
http://secunia.com/advisories/11185
http://www.osvdb.org/4462
http://www.osvdb.org/4463
http://www.osvdb.org/4464
http://www.vuxml.org/freebsd/cdf18ed9-7f4a-11d8-9645-0020ed76ef5a.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: ethereal, tethereal";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"ethereal");
if(!isnull(bver) && revcomp(a:bver, b:"0.10.3")<0) {
    security_note(0, data:"Package ethereal version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"tethereal");
if(!isnull(bver) && revcomp(a:bver, b:"0.10.3")<0) {
    security_note(0, data:"Package tethereal version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
