###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for kdeutils FEDORA-2007-2985
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861133);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "FEDORA", value: "2007-2985");
  script_cve_id("CVE-2007-4352", "CVE-2007-5392", "CVE-2007-5393");
  script_name( "Fedora Update for kdeutils FEDORA-2007-2985");
  desc = "

  Vulnerability Insight:
  Utilities for the K Desktop Environment.
  Includes:
    * ark (tar/gzip archive manager);
  
    * kcalc (scientific calculator);
  
    * kcharselect (character selector);
    * kdepasswd (change password);
    * kdessh (ssh front end);
    * kdf (view disk usage);
    * kedit (simple text editor);
    * kfloppy (floppy formatting tool);
    * kgpg (gpg gui)
    * khexedit (hex editor);
    * kjots (note taker);
    * ktimer (task scheduler);
    * kwikdisk (removable media utility)


  Affected Software/OS:
  kdeutils on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-November/msg00311.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kdeutils");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"kdeutils", rpm:"kdeutils~3.5.8~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils", rpm:"kdeutils~3.5.8~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-extras", rpm:"kdeutils-extras~3.5.8~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-devel", rpm:"kdeutils-devel~3.5.8~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-debuginfo", rpm:"kdeutils-debuginfo~3.5.8~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-devel", rpm:"kdeutils-devel~3.5.8~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-extras", rpm:"kdeutils-extras~3.5.8~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils", rpm:"kdeutils~3.5.8~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-debuginfo", rpm:"kdeutils-debuginfo~3.5.8~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}