This is the first release from the new Puppet Mode maintainers @bbatsov and @lunaryorn.

We forked Puppet Mode about half a year ago, to fix many outstanding issues, and improve the mode to work better with modern Emacsen.  It took us longer than expected to bring the mode into shape, but now we are finally there.

Changes
=======

New commands
------------

This release adds a bunch of brand-new commands to work on Puppet manifests:

- <kbd>C-c C-j</kbd>: Jump to definition of classes, resources and variables (powered by the **new Imenu support**)
- <kbd>C-M-a</kbd> and <kbd>C-M-e</kbd>: Move to the beginning and end of the current block
- <kbd>C-c C-a</kbd>: Align parameters in the current block (powered by the new **builtin alignment rules**)
- <kbd>C-c C-v</kbd>, <kbd>C-c C-l</kbd>, <kbd>C-c C-c</kbd>: Validate (with `puppet parser validate`), lint (with `puppet-lint`) and apply (with `puppet apply`) the current manifest

Font lock
---------

We completely rewrote the fontification code.  Puppet Mode now fontifies more expressions than before:

- All keywords and built-in functions from Puppet 3.4
- Variable declarations and references
- Variable expansions in double-quoted and single-quoted strings (the latter with `font-lock-warning-face`, to make aware of a possible mistake)
- Variable references in comments, if you set the new option `puppet-fontify-variables-in-comments` to a non-nil value.
- Special escape sequences in double quoted strings
- Regular expression literals
- Built-in metaparameters
- The negation operator
- Class, node and type definitions
- Resource declarations, references and collectors

We also fixed a number of outstanding issues.  Notably, Puppet Mode understands C-style comments, and will no longer highlight the names of built-in types or functions in parameters.

Roadmap
=======

This release is the first major step to bring Puppet Mode into a decent shape, but we are far from complete.  We currently lack any unit tests, so your immediate focus is now on improving the test coverage to make sure that we never break Puppet Mode for you.

The indentation code also needs a lot of work.  Currently Puppet Mode still uses the imperative ad-hoc indentation code we inherited from Puppetlabs Inc.  We plain to rewrite indentation based on SMIE, the powerful indentation and navigation engine in Emacs 24.  Hopefully this fixes many broken corner-cases and hiccups of the current imperative indentation code we inherited from Puppetlabs Inc.

Beyond these immediate steps we are open for suggestions and contributions to improve the mode and add new features.  If you have any idea, please share your thoughts!

Enjoy this release!
