# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class ErrorResponse(Model):
    """Describes the format of Error response.

    :param code: Error code
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, code: str=None, message: str=None, **kwargs) -> None:
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class MetricNamespace(Model):
    """Metric namespace class specifies the metadata for a metric namespace.

    :param id: The ID of the metricNamespace.
    :type id: str
    :param type: The type of the namespace.
    :type type: str
    :param name: The name of the namespace.
    :type name: str
    :param properties: Properties which include the fully qualified namespace
     name.
    :type properties:
     ~azure.mgmt.monitor.v2017_12_01_preview.models.MetricNamespaceName
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'MetricNamespaceName'},
    }

    def __init__(self, *, id: str=None, type: str=None, name: str=None, properties=None, **kwargs) -> None:
        super(MetricNamespace, self).__init__(**kwargs)
        self.id = id
        self.type = type
        self.name = name
        self.properties = properties


class MetricNamespaceName(Model):
    """The fully qualified metric namespace name.

    :param metric_namespace_name: The metric namespace name.
    :type metric_namespace_name: str
    """

    _attribute_map = {
        'metric_namespace_name': {'key': 'metricNamespaceName', 'type': 'str'},
    }

    def __init__(self, *, metric_namespace_name: str=None, **kwargs) -> None:
        super(MetricNamespaceName, self).__init__(**kwargs)
        self.metric_namespace_name = metric_namespace_name
