# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.workloadorchestration.aio import WorkloadOrchestrationMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestWorkloadOrchestrationMgmtInstanceHistoriesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(WorkloadOrchestrationMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_instance_histories_get(self, resource_group):
        response = await self.client.instance_histories.get(
            resource_group_name=resource_group.name,
            target_name="str",
            solution_name="str",
            instance_name="str",
            instance_history_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_instance_histories_list_by_instance(self, resource_group):
        response = self.client.instance_histories.list_by_instance(
            resource_group_name=resource_group.name,
            target_name="str",
            solution_name="str",
            instance_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
