% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation-raster.r
\name{annotation_raster}
\alias{annotation_raster}
\title{Annotation: high-performance rectangular tiling}
\usage{
annotation_raster(raster, xmin, xmax, ymin, ymax, interpolate = FALSE)
}
\arguments{
\item{raster}{raster object to display}

\item{xmin, xmax}{x location (in data coordinates) giving horizontal
location of raster}

\item{ymin, ymax}{y location (in data coordinates) giving vertical
location of raster}

\item{interpolate}{If \code{TRUE} interpolate linearly, if \code{FALSE}
(the default) don't interpolate.}
}
\description{
This is a special version of \code{\link{geom_raster}} optimised for static
annotations that are the same in every panel. These annotations will not
affect scales (i.e. the x and y axes will not grow to cover the range
of the raster, and the raster must already have its own colours). This
is useful for adding bitmap images.
}
\examples{
# Generate data
rainbow <- matrix(hcl(seq(0, 360, length.out = 50 * 50), 80, 70), nrow = 50)
ggplot(mtcars, aes(mpg, wt)) +
  geom_point() +
  annotation_raster(rainbow, 15, 20, 3, 4)
# To fill up whole plot
ggplot(mtcars, aes(mpg, wt)) +
  annotation_raster(rainbow, -Inf, Inf, -Inf, Inf) +
  geom_point()

rainbow2 <- matrix(hcl(seq(0, 360, length.out = 10), 80, 70), nrow = 1)
ggplot(mtcars, aes(mpg, wt)) +
  annotation_raster(rainbow2, -Inf, Inf, -Inf, Inf) +
  geom_point()
rainbow2 <- matrix(hcl(seq(0, 360, length.out = 10), 80, 70), nrow = 1)
ggplot(mtcars, aes(mpg, wt)) +
  annotation_raster(rainbow2, -Inf, Inf, -Inf, Inf, interpolate = TRUE) +
  geom_point()
}
