/************************************* */
/* Rule Set Based Access Control       */
/* Author and (c) 1999-2004: Amon Ott  */
/* File system                         */
/* helper functions for all parts      */
/* Last modified: 30/Apr/2004          */
/************************************* */

#ifndef __RSBAC_FS_H
#define __RSBAC_FS_H

#include <linux/fs.h>
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
#include <linux/major.h>
#include <linux/root_dev.h>
#include <linux/sched.h>
#endif

/* original lookup_dentry function without rsbac patch for adf call */

struct dentry * rsbac_lookup_hash(struct qstr *name, struct dentry * base);
struct dentry * rsbac_lookup_one_len(const char * name, struct dentry * base, int len);

#ifndef SOCKFS_MAGIC
#define SOCKFS_MAGIC 0x534F434B
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
#ifndef SYSFS_MAGIC
#define SYSFS_MAGIC 0x62656572
#endif
#endif

struct super_block * rsbac_get_super_block(kdev_t kdev);

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
extern void FASTCALL(__fput(struct file *));
#else
#ifndef __fput
extern void __fput(struct file *);
#endif
#endif

#ifndef SHM_FS_MAGIC
#define SHM_FS_MAGIC 0x02011994
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
static inline int init_private_file(struct file *filp, struct dentry *dentry, int mode)
{
	memset(filp, 0, sizeof(*filp));
	filp->f_mode   = mode;
	atomic_set(&filp->f_count, 1);
	filp->f_dentry = dentry;
	filp->f_uid    = current->fsuid;
	filp->f_gid    = current->fsgid;
	filp->f_op     = dentry->d_inode->i_fop;
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,2)
	filp->f_mapping     = dentry->d_inode->i_mapping;
	file_ra_state_init(&filp->f_ra, filp->f_mapping);
#endif
	if (filp->f_op->open)
		return filp->f_op->open(dentry->d_inode, filp);
	else
		return 0;
}
#endif

#endif
