/* debug.h - Definitions and declarations for the debugging primitives
 *
 * Copyright (c) 2003 Peter Busser <peter@trusteddebian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111, USA
 */

/* Define the values for turning debugging on and off. */
enum debugval {DEBUG_OFF = 0, DEBUG_ON};

/* Enable debugging output */
#define enable_debug() (set_debug(DEBUG_ON))

/* Enable debugging output */
#define disable_debug() (set_debug(DEBUG_OFF))

/* Set the debugging */
void set_debug( enum debugval val );

/* Print a formatted debug message */
void debug( const char *fmt, ... );

/* Print a debugging string */
void debugstr( const char *str );

