## TFSA-2021-032: `CHECK`-fail in `CTCGreedyDecoder`

### CVE Number
CVE-2021-29543

### Impact
An attacker can trigger a denial of service via a `CHECK`-fail in
`tf.raw_ops.CTCGreedyDecoder`:

```python
import tensorflow as tf

inputs = tf.constant([], shape=[18, 2, 0], dtype=tf.float32)
sequence_length = tf.constant([-100, 17], shape=[2], dtype=tf.int32)
merge_repeated = False

tf.raw_ops.CTCGreedyDecoder(inputs=inputs, sequence_length=sequence_length, merge_repeated=merge_repeated)
```

This is because the
[implementation](https://github.com/tensorflow/tensorflow/blob/1615440b17b364b875eb06f43d087381f1460a65/tensorflow/core/kernels/ctc_decoder_ops.cc#L37-L50)
has a `CHECK_LT` inserted to validate some invariants. When this condition is
false, the program aborts, instead of returning a valid error to the user. This
abnormal termination can be weaponized in denial of service attacks.

### Patches
We have patched the issue in GitHub commit
[ea3b43e98c32c97b35d52b4c66f9107452ca8fb2](https://github.com/tensorflow/tensorflow/commit/ea3b43e98c32c97b35d52b4c66f9107452ca8fb2).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Yakun Zhang and Ying Wang of Baidu
X-Team.
