/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.mviz;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;
import javax.swing.table.AbstractTableModel;
import net.tinyos.mviz.DLink;
import net.tinyos.mviz.DLinkModel;
import net.tinyos.mviz.DMoteModel;
import net.tinyos.mviz.DMoteModelListener;
import net.tinyos.mviz.DNavigate;
import net.tinyos.mviz.DShape;
import net.tinyos.mviz.DataModel;
import net.tinyos.mviz.MessageInput;

public class DDocument
extends JPanel
implements ActionListener {
    protected String directory;
    protected JPanel canvas;
    protected Vector layers;
    private Color currentColor;
    public float[] maxValues;
    public int selectedFieldIndex;
    public int selectedLinkIndex;
    public ImageIcon icon;
    public Image image;
    public DNavigate navigator;
    public Vector sensed_motes;
    public Vector sensed_links;
    public ArrayList moteModels;
    public ArrayList linkModels;
    private JTextField jText;
    private DrawTableModel tableModel;
    private JTable jTable;
    public int width_canvas = 600;
    public int height_canvas = 600;
    protected ArrayList motes = new ArrayList();
    protected ArrayList links = new ArrayList();
    protected DMoteModel selected = null;
    protected HashMap moteIndex;
    protected HashMap linkIndex;
    Random rand = new Random();

    public Color getColor() {
        return this.currentColor;
    }

    private String[] toStringArray(Vector vector) {
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public DDocument(int n, int n2, Vector vector, Vector vector2, String string) {
        this.layers = new Vector();
        this.directory = string;
        this.setOpaque(false);
        this.setLayout(new BorderLayout(6, 6));
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.selectedFieldIndex = 0;
        this.selectedLinkIndex = 0;
        this.canvas = new DPanel(this);
        this.canvas.setLayout(null);
        this.canvas.setDoubleBuffered(true);
        this.canvas.setPreferredSize(new Dimension(n, n2));
        this.canvas.setMinimumSize(new Dimension(n, n2));
        this.canvas.setSize(new Dimension(n, n2));
        this.canvas.setOpaque(false);
        this.canvas.setBorder(new SoftBevelBorder(1));
        this.add((Component)this.canvas, "Center");
        this.sensed_motes = vector;
        this.sensed_links = vector2;
        this.moteIndex = new HashMap();
        this.linkIndex = new HashMap();
        String string2 = this.directory + "/mote.gif";
        try {
            this.image = Toolkit.getDefaultToolkit().getImage(string2);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        System.out.println(string2);
        this.canvas.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent componentEvent) {
                DDocument.this.navigator.redrawAllLayers();
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setDoubleBuffered(true);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.add((Component)jPanel, "West");
        this.currentColor = Color.GRAY;
        this.navigator = new DNavigate(this.sensed_motes, this.sensed_links, this);
        jPanel.add(this.navigator);
        jPanel.add(Box.createVerticalStrut(10));
        this.tableModel = new DrawTableModel(this.sensed_motes);
        this.jTable = new JTable(this.tableModel);
        this.jTable.setAutoResizeMode(4);
        JScrollPane jScrollPane = new JScrollPane(this.jTable);
        jScrollPane.setPreferredSize(new Dimension(350, 200));
        jScrollPane.setMinimumSize(new Dimension(350, 200));
        jScrollPane.setSize(new Dimension(350, 200));
        jPanel.add(jScrollPane);
        this.enableEvents(2001L);
        this.enableEvents(2000L);
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    private void zMove(int n) {
        this.tableModel.updateTable();
    }

    public DDocument(Vector vector, Vector vector2) {
        this(300, 300, vector, vector2, ".");
    }

    public DShape getSelected() {
        return null;
    }

    public void setSelected(DShape dShape) {
    }

    private DMoteModel createNewMote(int n) {
        DMoteModel dMoteModel = new DMoteModel(n, this.rand, this);
        this.motes.add(dMoteModel);
        this.moteIndex.put(new Integer(n), dMoteModel);
        this.tableModel.add(dMoteModel);
        this.navigator.addMote(dMoteModel);
        return dMoteModel;
    }

    public void setMoteValue(int n, String string, int n2) {
        ValueSetEvent valueSetEvent = new ValueSetEvent(this, n, string, n2);
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        eventQueue.postEvent(valueSetEvent);
    }

    private DLinkModel createNewLink(DMoteModel dMoteModel, DMoteModel dMoteModel2) {
        DLinkModel dLinkModel = new DLinkModel(dMoteModel, dMoteModel2, this.rand, this);
        this.links.add(dLinkModel);
        this.linkIndex.put(dMoteModel.getId() + " " + dMoteModel2.getId(), dLinkModel);
        return dLinkModel;
    }

    public void setLinkValue(int n, int n2, String string, int n3) {
        LinkSetEvent linkSetEvent = new LinkSetEvent(this, string, n3, n, n2);
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        eventQueue.postEvent(linkSetEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ValueSetEvent) {
            ValueSetEvent valueSetEvent = (ValueSetEvent)aWTEvent;
            String string = valueSetEvent.name();
            int n = valueSetEvent.moteId();
            int n2 = valueSetEvent.value();
            DMoteModel dMoteModel = (DMoteModel)this.moteIndex.get(new Integer(n));
            if (dMoteModel == null) {
                dMoteModel = this.createNewMote(n);
            }
            dMoteModel.setMoteValue(string, n2);
            this.navigator.redrawAllLayers();
        } else if (aWTEvent instanceof LinkSetEvent) {
            DLinkModel dLinkModel;
            DMoteModel dMoteModel;
            LinkSetEvent linkSetEvent = (LinkSetEvent)aWTEvent;
            String string = linkSetEvent.name();
            int n = linkSetEvent.start();
            int n3 = linkSetEvent.end();
            int n4 = linkSetEvent.value();
            DMoteModel dMoteModel2 = (DMoteModel)this.moteIndex.get(new Integer(n));
            if (dMoteModel2 == null) {
                dMoteModel2 = this.createNewMote(n);
            }
            if ((dMoteModel = (DMoteModel)this.moteIndex.get(new Integer(n3))) == null) {
                dMoteModel = this.createNewMote(n3);
            }
            if ((dLinkModel = (DLinkModel)this.linkIndex.get(n + " " + n3)) == null) {
                dLinkModel = this.createNewLink(dMoteModel2, dMoteModel);
            }
            dLinkModel.setLinkValue(string, n4);
            this.navigator.redrawAllLayers();
        } else {
            super.processEvent(aWTEvent);
        }
    }

    public static void usage() {
        System.err.println("usage: tos-mviz [-comm source] [-dir image_dir] message_type [message_type ...]");
    }

    public static void main(String[] stringArray) {
        Object object;
        JFrame jFrame = new JFrame("MViz");
        Vector<Object> vector = new Vector<Object>();
        String string = null;
        String string2 = ".";
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-comm")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-dir")) {
                    string2 = stringArray[++i];
                    continue;
                }
                object = stringArray[i];
                vector.add(object);
            }
        } else if (stringArray.length != 0) {
            DDocument.usage();
            System.exit(1);
        }
        if (vector.size() == 0) {
            DDocument.usage();
            System.exit(1);
        }
        DataModel dataModel = new DataModel(vector);
        object = new DDocument(600, 600, dataModel.fields(), dataModel.links(), string2);
        jFrame.setContentPane((Container)object);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
        MessageInput messageInput = new MessageInput(vector, string, (DDocument)object);
        messageInput.start();
    }

    private void repaintAllMotes() {
        Iterator iterator = this.motes.iterator();
        while (iterator.hasNext()) {
            ((DMoteModel)iterator.next()).requestRepaint();
        }
    }

    private void repaintAllLinks() {
        Iterator iterator = this.links.iterator();
        while (iterator.hasNext()) {
            ((DLink)iterator.next()).repaint();
        }
    }

    protected class LinkSetEvent
    extends AWTEvent {
        public static final int EVENT_ID = 2001;
        private String name;
        private int value;
        private int start;
        private int end;

        public LinkSetEvent(Object object, String string, int n, int n2, int n3) {
            super(object, 2001);
            this.value = n;
            this.name = string;
            this.start = n2;
            this.end = n3;
        }

        public String name() {
            return this.name;
        }

        public int value() {
            return this.value;
        }

        public int start() {
            return this.start;
        }

        public int end() {
            return this.end;
        }
    }

    protected class ValueSetEvent
    extends AWTEvent {
        public static final int EVENT_ID = 2000;
        private String name;
        private int value;
        private int mote;

        public ValueSetEvent(Object object, int n, String string, int n2) {
            super(object, 2000);
            this.value = n2;
            this.name = string;
            this.mote = n;
        }

        public String name() {
            return this.name;
        }

        public int value() {
            return this.value;
        }

        public int moteId() {
            return this.mote;
        }
    }

    private class CanvasMouse
    extends MouseAdapter {
        private CanvasMouse() {
        }
    }

    private class DPanel
    extends JPanel {
        private DDocument doc;
        private int lastX = -1;
        private int lastY = -1;

        public DPanel(DDocument dDocument2) {
            this.doc = dDocument2;
            this.addMouseListener(new MouseAdapter(){

                private boolean withinRange(int n, int n2, int n3) {
                    return n >= n2 && n <= n3;
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    DPanel.this.lastX = mouseEvent.getX();
                    DPanel.this.lastY = mouseEvent.getY();
                    for (DMoteModel dMoteModel : ((DPanel)DPanel.this).doc.motes) {
                        if (!this.withinRange(mouseEvent.getX(), dMoteModel.getLocX() - 20, dMoteModel.getLocX() + 20) || !this.withinRange(mouseEvent.getY(), dMoteModel.getLocY() - 20, dMoteModel.getLocY() + 20)) continue;
                        DDocument.this.selected = dMoteModel;
                        return;
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (((DPanel)DPanel.this).doc.selected != null) {
                        ((DPanel)DPanel.this).doc.selected = null;
                        DPanel.this.lastX = -1;
                        DPanel.this.lastY = -1;
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent mouseEvent) {
                    if (((DPanel)DPanel.this).doc.selected != null) {
                        if (DPanel.this.lastY == -1) {
                            DPanel.this.lastY = mouseEvent.getY();
                        }
                        if (DPanel.this.lastX == -1) {
                            DPanel.this.lastX = mouseEvent.getX();
                        }
                        int n = mouseEvent.getX();
                        int n2 = mouseEvent.getY();
                        int n3 = n - DPanel.this.lastX;
                        int n4 = n2 - DPanel.this.lastY;
                        DPanel.this.lastX = n;
                        DPanel.this.lastY = n2;
                        DDocument.this.selected.move(DDocument.this.selected.getLocX() + n3, DDocument.this.selected.getLocY() + n4);
                    }
                    ((DPanel)DPanel.this).doc.navigator.redrawAllLayers();
                }
            });
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.setOpaque(false);
            this.doc.navigator.redrawAllLayers();
        }
    }

    private class DrawTableModel
    extends AbstractTableModel
    implements DMoteModelListener {
        private Vector fields;

        public DrawTableModel(Vector vector) {
            this.fields = vector;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "X";
                }
                case 1: {
                    return "Y";
                }
            }
            return (String)this.fields.elementAt(n - 2);
        }

        public int getColumnCount() {
            return this.fields.size() + 2;
        }

        public int getRowCount() {
            return DDocument.this.motes.size();
        }

        public Object getValueAt(int n, int n2) {
            DMoteModel dMoteModel = (DMoteModel)DDocument.this.motes.get(n);
            switch (n2) {
                case 0: {
                    return "" + dMoteModel.getLocX();
                }
                case 1: {
                    return "" + dMoteModel.getLocY();
                }
            }
            return "" + (int)dMoteModel.getValue(n2 - 2);
        }

        public void shapeChanged(DMoteModel dMoteModel, int n) {
            int n2 = this.findModel(dMoteModel);
            if (n2 != -1) {
                this.fireTableRowsUpdated(n2, n2);
            }
        }

        public void add(DMoteModel dMoteModel) {
            dMoteModel.addListener(this);
            int n = DDocument.this.motes.size() - 1;
            this.fireTableRowsInserted(n, n);
        }

        public void remove(DMoteModel dMoteModel) {
            int n = this.findModel(dMoteModel);
            if (n != -1) {
                this.fireTableRowsDeleted(n, n);
            }
        }

        public void updateTable() {
            this.fireTableDataChanged();
        }

        private int findModel(DMoteModel dMoteModel) {
            for (int i = 0; i < DDocument.this.motes.size(); ++i) {
                if ((DMoteModel)DDocument.this.motes.get(i) != dMoteModel) continue;
                return i;
            }
            return -1;
        }
    }
}

