/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif
#include <stdlib.h>
#include <vdkb2/vdkb_evcontain.h>
#include <vdkb2/vdkb_form.h>
#include <vdkb2/vdkb_types.h>
#include <vdkb2/vdkb_prjman.h>
#include <vdkb2/vdkb_objinspect.h>
#include <vdkb2/vdkb_paned.h>
#include <vdkb2/vdkb_notebook.h>
#include <vdkb2/vdkb_table.h>
#include <vdkb2/vdkb_frame.h>
#include <vdkb2/vdkb_fixed.h>
#include "./pixmaps/border.xpm"
extern OpState  OperationalState;
static char buff[256];
int VDKBCanvas::Counter = 0;
int VDKBEventContainer::Counter = 0;
/*
 properties
 */
char* vdkevcontainer_props[] = { BORDERWIDTH,0 };
DEFINE_EVENT_LIST(VDKBEventContainer,VDKObjectContainer);
DEFINE_SIGNAL_LIST(VDKBEventContainer,VDKObjectContainer);
/*
 */
VDKBEventContainer::VDKBEventContainer(char* name,VDKForm* owner):
  VDKObjectContainer(owner),VDKBObject(name)
{
  int t;
  VDKBObject::object = this;
  widget = sigwid = gtk_event_box_new();
  container = NULL;
  canvas = NULL;
  slot = 0;
  mode = -1;
  outerbox = NULL;
  popmenu = NULL;
  Counter++;
  EventConnect("expose_event",&VDKBEventContainer::OnExpose,true);
  for(t=0; vdkevcontainer_props[t]; t++)
    proplist.add(VDKBProperty(vdkevcontainer_props[t]));
}

/*
checks if is a bin container and
already contains a widget
 */
static char* prompt = N_("<%s> is a binary container,\n\
binary containers can contain only one widget.\n\
Remove the actual one before adding something else");
bool
VDKBEventContainer::BinCheck(VDKObject* wid)
{

  // scan an excpetion: scrolled window
  if(container  &&
     GTK_IS_BIN(container) &&
     GTK_IS_SCROLLED_WINDOW(container)
     )
  {
    GtkBin* bin = GTK_BIN(container);
    if(GTK_IS_VIEWPORT (bin->child) &&
       GTK_BIN (bin->child)->child == NULL)
      return true;

  }
  // checks if is a bin with a child
  if(container &&
	   GTK_IS_BIN(container) &&
	   GTK_BIN(container)->child != NULL)
  {
    sprintf(buff,_(prompt),(char*) Name());
    wid->Owner()->Application()->VDKMessageBox(APPNAME,buff,
					    VDK_OK| VDK_ICONINFORMATION,
					    _(user_messages[user_ok]),
					    NULL, 8000);
    return false;
  }
  else if(container)
  return true;
  else
  return false;
}
/*
 */
extern VDKDnD *DragAndDrop ;
void
VDKBEventContainer::Add(VDKObject* obj, int justify,
		   int expand, int fill, int padding)
{
    VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
    if(ownerform)
      ownerform->Changed = true;
    boxlist.add(obj);
    VDKObjectContainer::Add(obj,justify,expand,fill,padding);
    VDKBEventContainer *box = dynamic_cast<VDKBEventContainer*>(obj);
    if(box && DragAndDrop)
      {
	// add to dnd support
	DragAndDrop->AddTarget(obj);
	// connect to drop
	ownerform->ConnectToDrop(obj);
      }
#if 0
    printf("\n************************");
    fflush(stdout);
    // gtk_widget_set_size_request(obj->WrappedWidget(),50,30);
#endif
}


/*
 */
VDKBEventContainer*
VDKBEventContainer::Outerbox(VDKBEventContainer* b)
{
  if(b) outerbox = b;
  return outerbox;
}

/*
Removes active container and recursively
remove parent boxes if empty. (disabled)
With some exceptions:
- boxes embedded in table,paned or notebook
should not be removed
- gui form inner box should not be removed
 */
bool
VDKBEventContainer::DelBox(VDKObject* sender)
{
  VDKBEventContainer* self = (VDKBEventContainer*) this;
  VDKBEventContainer* outer = self->outerbox;
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  if(! ownerform)
    return true;
  // paned,table,frame and notebook embedded boxes
  // cant be deleted
  if(outer && dynamic_cast<VDKEventBox*>(self))
    {
      if(
	 dynamic_cast<VDKPaned*>(outer) ||
	 dynamic_cast<VDKTable*>(outer) ||
	 dynamic_cast<VDKBGuiNotebook*>(outer) ||
	 dynamic_cast<VDKBFrame*>(outer)
	 )
	return true;
    }
  // has a parent container
  if( outer )
    {
      // removing the active one
      if ( ownerform->Active == self)
	ownerform->Active = NULL;
      outer->boxlist.remove(self);
      self->Visible = false;
      // this produce a strange bug
      // FIX ME:
      //outer->RemoveObject(self);

      // removes ancestor empty box if any
      // error prone :-(
      // recursive destroyng disabled
      // together with nested layouts
      // (see vdkb_evbox.cc)
      /*
	if( (outer != ownerform->InnerBox()) &&
	(dynamic_cast<VDKBEventBox*>(outer)) &&
	(outer->boxlist.size() == 0)
	)
	outer->DelBox(NULL);
      */
     }
  // removing active one
  else if (ownerform->Active == self)
    ownerform->Active = NULL;
  ownerform->Changed = true;
  return true;
}

/*
 */
bool
VDKBEventContainer::OnButtonPressed(VDKObject* sender, GdkEvent* event)
{
  VDKBObject* prevActive = NULL;
  GdkEventButton* evbtn = (GdkEventButton*) event;
  VDKBObject* active = dynamic_cast<VDKBObject*>(sender);

  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  // is still a valid widget ?
  if( ownerform->Active &&
      GTK_IS_WIDGET (ownerform->Active->ObjectFromVDK()->Widget()))
    {
      ownerform->Active->ClearMark();
      prevActive = ownerform->Active;
    }
  active->Mark();
  ownerform->Active = active;
  switch(evbtn->button)
    {
      // STUB HERE
    case 1:
      if(OperationalState.state == op_stand_by &&
	 OperationalState.action == act_add_widget )
	{
	  // propagate to form
	  OperationalState.source = NULL;
	  ownerform->OnButtonPress(this,event);
	}
      // set active to object inspector
      else
	  // propagate to form
	  ownerform->OnButtonPress(sender,event);
      break;
    case 3:
      if(prevActive != active)
      	ownerform->OnButtonPress(sender,event);
      active->PopMenu();
      break;
    }
  return false;//true;
}
/*
 */
void
VDKBEventContainer::ClearMark()
{
  if(canvas)
    {
      canvas->Clear();
      gtk_widget_draw(canvas->Widget(),NULL);
    }
  else
    VDKBObject::ClearMark();

}
/*
 */
void
VDKBEventContainer::Mark()
{
  if(canvas)
     canvas->Mark();
  else
    VDKBObject::Mark();
}

/*
 */
bool
VDKBEventContainer::OnExpose(VDKObject* sender, GdkEvent* ev)
{
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(sender->Owner());
  VDKBObject* self = dynamic_cast<VDKBObject*>(sender);
  GdkEventExpose* event = (GdkEventExpose*) ev;
  if( ownerform && 
      (ownerform->Active == self) && 
      (event->count == 0)
      )
      self->Mark();
  return false; // true;
}
/*
 */
VDKObjectContainer*
VDKBEventContainer::ExtraWidget(VDKBObjectInspector* isp)
{
  inspector = isp;
  VDKBox* bframe = new VDKBox(inspector);
  VDKTable *table = new VDKTable(inspector,1,2);
  VDKBox* box = new VDKBox(inspector,h_box);
  VDKCustomButton* button =
    new VDKCustomButton(inspector,(const char**) border_xpm,NULL);
  button->SetTip(_("Set border width"));
  button->Relief = (GtkReliefStyle) 2;
  box->Add(button,l_justify,false,false,0);
  button->Parent(this);
  int bw = atoi( (char*) GetProp(BORDERWIDTH));
  borderspin = new VDKSpinButton(inspector, bw, 0, 20 , 1 ,0 );
  borderspin->SetSize(60,-1);
  box->Add(borderspin,l_justify,false,false,5);
  SignalConnect(button,"clicked",&VDKBEventContainer::OnBorderWidth);
  table->AddToCell(box,0,0);
  bframe->Add(table,l_justify,false,false,false);
  return bframe;
}
/*
 */
bool
VDKBEventContainer::OnBorderWidth(VDKObject*)
{
  sprintf(buff,"%d",(int) borderspin->ValueAsInt);
  SetPropValue(BORDERWIDTH,buff);
  BorderWidth((int) borderspin->ValueAsInt);
  inspector->FormNeedToBeChanged();
  return true;
}

/*
 */
void 
VDKBEventContainer::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  VDKBObject::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\t%s%s;",PROP_BORDERWIDTH,(char*) GetProp(BORDERWIDTH));
  return;
}
/*
 */
bool
VDKBEventContainer::SelectParentContainer(VDKObject*)
{
  VDKBEventContainer* container =
    dynamic_cast<VDKBEventContainer*>(Parent());
  if(container)
    {
      VDKBGuiForm* ownerform =
	dynamic_cast<VDKBGuiForm*>(Owner());
      if(ownerform)
	{
	  ownerform->Active->ClearMark();
	  ownerform->Active = container;
	  ownerform->Active->Mark();
	  VDKBProjectManager* prjman =
	    dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
	  if(prjman && prjman->objInspector)
	    //	    prjman->objInspector->SetActive(container);
	    prjman->objInspector->SelectWidgetByTree(container);
	}
    }
  return true;
}
/////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////
/*
 */
DEFINE_EVENT_LIST(VDKBCanvas,VDKCanvas);

VDKBCanvas::VDKBCanvas(char* name,VDKForm* owner, int w, int h):
  VDKCanvas(owner,w,h),VDKBObject(name)
{
  VDKBObject::object = this;
  Counter++;
  EventConnect("expose_event",&VDKBCanvas::OnExpose,true);
}

bool
VDKBCanvas::OnExpose(VDKObject* sender, GdkEvent *ev)
{
  GdkEventExpose* event = (GdkEventExpose*) ev;
  if(event->count > 0)
    return true;
  VDKPoint p = VDKPoint(Widget()->allocation.width,
  		Widget()->allocation.height);
  // change line to dashed
  if(gc)
    {
      GdkGCValues  gc_values;
      gdk_gc_get_values  (gc, &gc_values);
      gdk_gc_set_line_attributes(gc,
				 1,
				 GDK_LINE_ON_OFF_DASH,
				 gc_values.cap_style,
				 gc_values.join_style);
    }
  // set foreground to light gray
  VDKRgb light("gray90");
  Foreground = light;
  // draw a rect around the box
  // first arg set to 0 means do not fill.
  DrawRect(0,0,0,p.x-1,p.y-1);
  Redraw();
  return false;// true;
}

/*
 */
void
VDKBCanvas::Mark()
{
  VDKPoint p = VDKPoint(Widget()->allocation.width,
  		Widget()->allocation.height);
  VDKRgb black("black");
  Foreground = black;
  GdkRectangle brush;
  brush.width = 4;
  brush.height = 4;

  brush.x = 0;
  brush.y = 0;
  DrawRect(true,brush.x,brush.y,brush.width,brush.height);

  brush.x = 0;
  brush.y = p.Y()-brush.height;
  DrawRect(true,brush.x,brush.y,brush.width,brush.height);

  brush.x = p.X()-brush.width;
  brush.y = 0;
  DrawRect(true,brush.x,brush.y,brush.width,brush.height);

  brush.x = p.X()-brush.width;
  brush.y = p.Y()-brush.height;
  DrawRect(true,brush.x,brush.y,brush.width,brush.height);

  if(Parent() && Parent()->isA() == vdkbevbox_class)
    {
      VDKBEventBox* box = (VDKBEventBox*) Parent();
      sprintf(buff,"%s",(char*) box->Name());
      DrawString(10,20,buff);
    }
  Redraw();
}
/*
 */
void
VDKBCanvas::DrawUnfilledRect(int x, int y, int w, int h)
{
if(pixmap)
  gdk_draw_rectangle(pixmap,
		     widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
		     FALSE,
		     x,y,w,h);
}





