/* This file is part of wmaloader.*
 * Copyright 2004 Andrew Wild */

/* wmaloader is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. */

/* wmaloader is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License
 * along with wmaloader; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*------------------------------------------------------------------------*/

/* system */
#include <stdio.h>
#include <stdarg.h>
#include <syslog.h>

#include "common.h"

/* True when program is running in background */
extern int backgrounded; // declared in wmaloader.c

/*------------------------------------------------------------------------*/

void message(char *format, ...){
  /* Print status messages - to STDOUT or syslog if backgrounded. */
  char buffer[512];
  int ret;
  va_list va;

  va_start(va, format);
  ret = vsnprintf(buffer, 200, format, va);
  va_end(va);

  if (!ret) return;
  
  if (backgrounded)	syslog(LOG_INFO, buffer);
  else printf(buffer);
}
