/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.RareExtractor;
import java.util.HashSet;
import java.util.Set;

class CompanyNameDetector
extends RareExtractor {
    static final int COMPANY_NAME_WINDOW = 3;
    final Set<String> companyNameEnds = new HashSet<String>();
    private static final long serialVersionUID = 21L;

    public CompanyNameDetector() {
        this.companyNameEnds.add("Company");
        this.companyNameEnds.add("COMPANY");
        this.companyNameEnds.add("Co.");
        this.companyNameEnds.add("Co");
        this.companyNameEnds.add("Cos.");
        this.companyNameEnds.add("CO.");
        this.companyNameEnds.add("COS.");
        this.companyNameEnds.add("Corporation");
        this.companyNameEnds.add("CORPORATION");
        this.companyNameEnds.add("Corp.");
        this.companyNameEnds.add("Corp");
        this.companyNameEnds.add("CORP.");
        this.companyNameEnds.add("Incorporated");
        this.companyNameEnds.add("INCORPORATED");
        this.companyNameEnds.add("Inc.");
        this.companyNameEnds.add("Inc");
        this.companyNameEnds.add("INC.");
        this.companyNameEnds.add("Association");
        this.companyNameEnds.add("ASSOCIATION");
        this.companyNameEnds.add("Assn");
        this.companyNameEnds.add("ASSN");
        this.companyNameEnds.add("Limited");
        this.companyNameEnds.add("LIMITED");
        this.companyNameEnds.add("Ltd.");
        this.companyNameEnds.add("LTD.");
        this.companyNameEnds.add("L.P.");
    }

    private boolean companyNameEnd(String s) {
        return this.companyNameEnds.contains(s);
    }

    @Override
    String extract(History h, PairsHolder pH) {
        String s = pH.getWord(h, 0);
        if (!CompanyNameDetector.startsUpperCase(s)) {
            return "0";
        }
        for (int i = 0; i <= 3; ++i) {
            String s1 = pH.getWord(h, i);
            if (!this.companyNameEnd(s1)) continue;
            return "1";
        }
        return "0";
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }
}

